'use strict';
define(function() {
  /**
   * Map Panels Manager Provider
   */
  var panelsManager = function() {
    var $panelContainer,
      $panels = {};

    // ---------------------------------- */

    this.$get = function($rootScope, $compile) {
      return {
        /**
         * Initializing the panelManager by adding the panelContainer element
         * @returns {boolean}
         */
        init: function() {
          //angular.element(document).find('body').eq(0).append('<div id="panelContainer"></div>');
          $panelContainer = angular.element(
            document.getElementById('panelContainer')
          );
          return true;
        },
        /**
         * Adding a panel to the manager
         * @param opt
         */
        addPanel: function(opt) {

          try {
            // Panel settings
            let id = '';
            let classes = 'map_panel';
            let style = '';

            // create a new scope or use the passed one if there is any
            let scope;
            if (opt.scope && opt.scope.special && opt.scope.special.usescope) {
              scope = opt.scope.$new();
              Object.assign(scope, opt.scope.special);
            } else {
              scope = angular.isObject(opt.scope)
                ? opt.scope.$new()
                : $rootScope.$new();
            }

            // new class
            if (opt.cssClass) {
              classes = 'newCssForPanel';
            }

            // id
            if (opt.id) id += opt.id;

            // visible
            if (opt.visible === false) classes += ' hiddenPanel';

            // Position Attribution
            opt.position = opt.position || 'bottom';
            classes += ' ' + opt.position;

            // stickToBorder
            if (opt.stickToBorder) classes += ' stick_to_border';

            // stickToRight
            if (opt.stickToRight) classes += ' stick_to_right';

            // size
            let pSize = 250;
            if (opt.size) pSize = opt.size;

            // position
            switch (opt.position) {
              case 'left':
              case 'right':
                style += 'min-width: ' + pSize + 'px';
                break;
              case 'top':
              case 'bottom':
              default:
                style += 'min-height: ' + pSize + 'px';
                break;
            }

            /* include templateUrl via ng-include */
            let tpl = '<div id="' + id + '" class="' + classes + '" style="' + style + '" >';
            if (opt.resizable) {
              tpl +=
                '<div class="panelresizebar" resizable resize-origin="panel" resize-origin-id="' +
                opt.id +
                '"></div>';
            }

            if (opt.templateUrl) {
              scope.templateUrl = opt.templateUrl;
              tpl += '<div ng-include="templateUrl"></div>';
            }
            tpl += '</div>';


            // Compile with error handling
            const compiledElement = $compile(tpl)(scope);

            // Add cleanup handler
            scope.$on('$destroy', () =>{
              compiledElement.remove();
            });

            $panelContainer.append(compiledElement);

            // add the panel to the panels list
            $panels[id] = angular.element(document.getElementById(id));
          }catch (error) {
            console.error('Error creating panel:', error);
            // Handle error appropriately
          }
        },
        /**
         * Hide the panel #id
         * @param id
         */
        hidePanel: function(id) {
          $panels[id].addClass('hiddenPanel');
        },
        /**
         * Show the panel #id
         * @param id
         */
        showPanel: function(id) {
          $panels[id].removeClass('hiddenPanel');
        },
        /**
         * Destroy the p[anel #id
         * @param id
         */
        removePanel: function(id) {
          if ($panels[id]) {
            if (angular.isDefined(angular.element($panels[id]).scope())) {
              angular
                .element($panels[id])
                .scope()
                .$destroy();
            }
            $panels[id].remove();
          }
        },
      };
    };
    this.$get.$inject = ['$rootScope', '$compile'];
  };
  return panelsManager;
});
