'use strict';
define(function() {
  var pcwinManager = function(
    PcwinFactory,
    gaDomUtils,
    $filter,
    SelectManager,
    gclayers,
    FeatureTypeFactory,
    AlertHpoFactory,
    panelsManager
  ) {
    return {
      templateUrl: 'js/XG/modules/common/views/directives/pcwinManager.html',
      restrict: 'EA',
      replace: true,
      link: function($scope) {
        /***************************************************************
         * get all Alertes from PCWIN
         **************************************************************/
        $scope.isLoading = false;
        $scope.stations = {};
        $scope.getAllAlertesPCWIN = function(sendata) {
          let featureUidByName = FeatureTypeFactory.getFeatureByName(
            'PCWIN_ALERTE'
          );
          $scope.isLoading = true;
          let paramRecherch = {
            filter: '0',
            pageIndex: '0',
            pageSize: '10',
            dataStore: featureUidByName.storeName,
          };
          PcwinFactory.getPagedAlarmsListAll(paramRecherch).then(
            function(res) {
              $scope.isLoading = false;
              $scope.fti = res.data.featureTypeInfo;
              $scope.geoj = res.data;
              $scope.stations = res.data;
              if ($scope.stations) {
                if (
                  $scope.stations.totalFeatures &&
                  $scope.stations.totalFeatures == '0'
                ) {
                  gaDomUtils.hideGlobalLoader();
                  AlertHpoFactory.getSimpleSuccess(
                    $filter('translate')('hpo.common.success'),
                    $filter('translate')('alerteManager.noData'),
                    true,
                    'info'
                  );
                } else {
                  if (
                    $scope.stations.errors &&
                    $scope.stations.errors.length != '0'
                  ){                  
                    AlertHpoFactory.getSimpleFail(
                      $filter('translate')('executQuery.alert.warning'),
                      $filter('translate')($scope.stations.errors),
                      true
                    );
                  }
                  $scope.vopenTabPanels();
                  gaDomUtils.hideGlobalLoader();
                }
              }
            },
            function(res) {
              AlertHpoFactory.showErrorMessage(res);
              $scope.isLoading = false;
              gaDomUtils.hideGlobalLoader();
            }
          );
        };

        /***************************************************************
         * get all Mesures from PCWIN
         **************************************************************/
        $scope.getAllMesuresPCWIN = () => {
          let featureUidByName = FeatureTypeFactory.getFeatureByName(
            'PCWIN_MESURE'
          );
          $scope.isLoadingMesure = true;
          let paramRecherch = {
            dataStore: featureUidByName.storeName,
          };
          PcwinFactory.getPagedMesuresList(paramRecherch).then((res) =>{
            $scope.isLoadingMesure = false;

            if(res.data){
              $scope.fti = res.data.featureTypeInfo;
              $scope.geoj = {totalFeatures: res.data.totalFeatures, 
                            features: res.data.features
                          };
              $scope.vopenTabPanels();
              require('toastr').success(
                $filter('translate')('PCWIN.pcwinmesureSuccess')
              );
            } else {
              require('toastr').warning(
                $filter('translate')('PCWIN.pcwinmesureFailed')
              );
            }       
          }, (res) => {
            $scope.isLoadingMesure = false;
            require('toastr').warning(
              $filter('translate')('PCWIN.pcwinmesureFailed')
            );
          });
        }

        /***************************************************************
         * update Kis data
         **************************************************************/
        $scope.isUpdating = false;
        $scope.updateKis = function() {
          let featureUidByName = FeatureTypeFactory.getFeatureByName(
            'PCWIN_ALERTE'
          );
          if (featureUidByName && $scope.stations && $scope.stations.features) {
            $scope.isUpdating = true;
            $scope.stationsdata = [];
            for (let i = 0; i < $scope.stations.features.length; i++) {
              $scope.stationsdata[i] = $scope.stations.features[i].properties;
            }
            // création des paramétres de recheche
            let paramRecherch = {
              dataStore: featureUidByName.storeName,
              listStations: $scope.stationsdata,
            };

            // MISe à jour des alertes
            PcwinFactory.updateStationAlerte(paramRecherch).then(
              function(res) {
                if (res.data) {
                  $scope.isUpdating = false;
                  gaDomUtils.hideGlobalLoader();
                  AlertHpoFactory.getSimpleSuccess(
                    $filter('translate')('hpo.common.success'),
                    $filter('translate')('alerteManager.majDatakisSuccess'),
                    true,
                    'info'
                  );
                  $scope.update = false;
                }
              },
              function(res) {
                $scope.update = false;
                $scope.isUpdating = false;
                AlertHpoFactory.showErrorMessage(res);
                gaDomUtils.hideGlobalLoader();
              }
            );
          }
        };

        /***************************************************************
         * setSelectInteraction Set the select interaction
         **************************************************************/
        $scope.layerdatatable = {};
        $scope.layerdatatable.height = 300;
        $scope.vopenTabPanels = function() {
          $scope.panelsManager.removePanel('selecttab');
          panelsManager.addPanel({
            id: 'selecttab',
            stickToRight: true,
            templateUrl:
              'js/XG/modules/common/views/directives/popPcwinDatatable.html',
            scope: $scope,
            stickToBorder: true,
            visible: true,
            resizable: true,
          });
        };
        $scope.closeTable = false;
        $scope.closepanel = function() {
          gclayers.clearhighLightFeatures();
          SelectManager.clear();
          panelsManager.removePanel('selecttab');
          $scope.feat = {};
        };
      },
    };
  };
  pcwinManager.$inject = [
    'PcwinFactory',
    'gaDomUtils',
    '$filter',
    'SelectManager',
    'gclayers',
    'FeatureTypeFactory',
    'AlertHpoFactory',
    'panelsManager',
  ];
  return pcwinManager;
});
