'use strict';
define(() => {
  const progressText = function() {
    return {
      restrict: 'A',
      scope: {
        progress: '=',
        progressBarWidth: '='
      },
      template: '<span ng-repeat="char in chars track by $index" class="progress-char" ng-style="getCharStyle($index)">{{char}}</span>',
      link: (scope, element) => {
        const CHAR_WIDTH = 8; // Largeur fixe d'un caractère en pixels

        scope.$watch('progress', (newVal) => {
          if (newVal !== undefined) {
            scope.chars = (newVal + '%').split('');
          }
        });

        scope.getCharStyle = (index) => {
          const progressElement = element[0].parentElement;
          const progressWidth = progressElement.offsetWidth;
          const totalChars = scope.chars.length;
          const textStartPosition = (progressWidth - (totalChars * CHAR_WIDTH)) / 2;

          // Position du début et du milieu du caractère
          const charStartPosition = textStartPosition + (index * CHAR_WIDTH);
          const charMidPosition = charStartPosition + (CHAR_WIDTH / 2);

          // Position actuelle de la barre de progression
          const progressPosition = (scope.progressBarWidth / 100) * progressWidth;

          // Le caractère change de couleur quand son point milieu est dépassé
          const isOverlapped = charMidPosition <= progressPosition;

          return {
            color: isOverlapped ? '#ffffff' : '#000000',
            textShadow: isOverlapped ?
                '0px 0px 2px rgba(0,0,0,0.8)' :
                '0px 0px 2px rgba(255,255,255,0.8)',
            transition: 'all 0.1s ease',
            display: 'inline-block',
            width: CHAR_WIDTH + 'px',
            textAlign: 'center'
          };
        };
      }
    };
  };

  return progressText;
});