'use strict';
define(function() {
  /**
   * Transform an array of elements with an array of each value of element[key]
   * [{a:'b'},{a:'c'},{a:'d'}] => ['b','c','d']
   * @returns input
   */
  var arrayMap = function() {
    return function(arr, key) {
      var returnedArray = [];
      for (var i in arr) {
        if (arr[i].hasOwnProperty(key)) {
          returnedArray.push(arr[i][key]);
        }
      }

      return returnedArray;
    };
  };

  arrayMap.$inject = [];
  return arrayMap;
});
