'use strict';
define(function() {
  /**
   * Replaces a datastore type with it's logo
   * @returns input
   */
  var dataStoreTypeLogo = function($sce) {
    return function(input) {
      var logo;
      if (input == undefined) {
        input = '';
      }
      input = input.toLowerCase();
      switch (input) {
        case 'postgis':
        case 'safepostgis':
        case 'arcgis':
        case 'mysql':
        case 'sqlserver':
        case 'oracle':
          logo =
            '<img src="img/datastores/' +
            input +
            '.png" class="editListLogo"/>';
          break;
        default:
          logo = input;
          break;
      }

      return $sce.trustAsHtml(logo);
    };
  };

  dataStoreTypeLogo.$inject = ['$sce'];
  return dataStoreTypeLogo;
});
