'use strict';
define(function() {
  /**
   * Replaces a true value with a check sign
   * and the false/undefined value with a cross sign
   * @returns input
   */
  var datetoshow = function($sce, $filter) {
    return function(input) {
      if (input)
        return $sce.trustAsHtml(
          $filter('date')(new Date(input), 'yyyy-MM-dd HH:mm')
        );
      else return input;
    };
  };

  datetoshow.$inject = ['$sce', '$filter'];
  return datetoshow;
});
