'use strict';
define(function() {
  var GeometryFactory = function($http, $filter) {
    var GeometryFactory = {};
    /**
     * Class : GeometryFactory
     * Factory WebServices
     */

    /**
     * Function: union
     */
    function union(senddata) {
      var promise = $http.post(
        '/services/{portalid}/geometry/union?f=json',
        senddata
      );
      return promise;
    }

    /**
     * Function: unionifpossible
     */
    function unionifpossible(senddata) {
      var promise = $http.post(
        '/services/{portalid}/geometry/unionifpossible?f=json',
        senddata
      );
      return promise;
    }

    /**
     * Function: buffer
     */
    let buffer = (senddata, bufferMethod, distance) => {
      return $http.post(
        '/services/{portalid}/geometry/buffer?f=json' +
        '&bufferMethod=' + bufferMethod +
        '&distance=' + distance,
        senddata
      );
    };

    /**
     * Function: difference
     */
    function difference(senddata, DifferenceGeometry) {
      var promise = $http.post(
        '/services/{portalid}/geometry/difference?f=json' +
          '&DifferenceGeometry=' +
          DifferenceGeometry,
        senddata
      );
      return promise;
    }
    /**
     * Function: unionandbuffer
     */
    function unionandbuffer(senddata, bufferMethod, distance) {
      var promise = $http.post(
        '/services/{portalid}/geometry/unionandbuffer?f=json' +
          '&bufferMethod=' +
          bufferMethod +
          '&distance=' +
          distance,
        senddata
      );
      return promise;
    }
    /**
     * Function: project
     */
    function project(senddata, inCRS, outCRS) {
      var promise = $http.post(
        '/services/{portalid}/geometry/project?f=json' +
          '&inCRS=' +
          inCRS +
          '&outCRS=' +
          outCRS,
        senddata
      );
      return promise;
    }
    /**
     * Function: autocomplete
     */
    function autocomplete(senddata, polygons, polylines) {
      var promise = $http.post(
        '/services/{portalid}/geometry/autoComplete?f=json' +
          '&polygons=' +
          polygons +
          '&polylines=' +
          polylines,
        senddata
      );
      return promise;
    }
    /**
     * Function: simplify
     */
    function simplify(senddata) {
      var promise = $http.post(
        '/services/{portalid}/geometry/simplify?f=json',
        senddata
      );
      return promise;
    }
    /**
     * Function: intersectTwoGeoms
     */
    function intersectTwoGeoms(senddata) {
      var promise = $http.post(
        '/services/{portalid}/geometry/intersectTwoGeoms?f=json',
        senddata
      );
      return promise;
    }
    /**
     * Function: intersect
     */
    function intersect(senddata, intersectGeometry) {
      var promise = $http.post(
        '/services/{portalid}/geometry/intersect?f=json' +
          '&intersectGeometry=' +
          intersectGeometry,
        senddata
      );
      return promise;
    }

    /**
     * Function: cut
     */
    function cut(senddata, CutterGeometry) {
      var promise = $http.post(
        '/services/{portalid}/geometry/cut?f=json' +
          '&CutterGeometry=' +
          CutterGeometry,
        senddata
      );
      return promise;
    }
    /**
     * Function: getcentroid
     */
    function getcentroid(senddata) {
      var promise = $http.post(
        '/services/{portalid}/geometry/getCentroid?f=json',
        senddata
      );
      return promise;
    }
    /**
     * Function: convexhull
     */
    function convexhull(senddata) {
      var promise = $http.post(
        '/services/{portalid}/geometry/convexHull?f=json',
        senddata
      );
      return promise;
    }

    function movePointWithLine(senddata) {
      var promise = $http.post(
        '/services/{portalid}/geometry/movepointwithline?f=json',
        senddata
      );
      return promise;
    }

    function moveLineWithLine(senddata) {
      var promise = $http.post(
        '/services/{portalid}/geometry/movelinetwithline?f=json',
        senddata
      );
      return promise;
    }

    /**
     * Opération qui peut être effectuée avec openlayers<ul><li>
     *   ol.geom.LineString.getCoordinatesAt()</li><li>
     *   MapJsUtils.getMultiLineStringCoordinatesAt()</li></ul>
     * @param {string} senddata tableau de géométries au format Geojson
     * @param {number} distance distance à laquelle doit etre calculée le point à partir de l'extrémité de départ de la ligne
     * @return {Promise} response contenant les coordonnées du point sous la forme d'une string
     */
    function getPointAtDistanceOnLine(senddata, distance) {
      return $http.post(
        '/services/{portalid}/geometry/getpointatdistanceonline?f=json' +
          '&distance=' +
          distance,
        senddata
      );
    }

    function getCentroidInPolygon(senddata) {
      var promise = $http.post(
        '/services/{portalid}/geometry/getCentroidInPolygon?f=json',
        senddata
      );
      return promise;
    }

    /**
     * Teste si la géométrie linéaire s'intersecte elle-même.
     * Utilise la méthode de Geotools de la classe Geometry: isSimple()
     * @param {string} lineGeometry géométrie linéaire geojson (ex. {type, coordinates})
     * @return {Promise} contient un booleen égal à true si la ligne s'intersecte elle-même sinon false
     */
    const isLineSelfIntersecting = (lineGeometry) => {
      return $http.post('/services/{portalid}/geometry/isLineSelfIntersecting?f=json', lineGeometry)
      .catch(error => {
        if (error && error.data && error.data.message) {
          require('toastr').error($filter('translate')(error.data.message));
        } else {
          require('toastr').error($filter('translate')('rulecfg.mustNotSelfIntersect.error'));
        }
      });
    };



    /**
     * Teste si la géométrie linéaire se chevauche elle-même.
     * Utilise la méthode de Geotools de la classe Geometry: isSimple()
     * @param {object} lineGeometry géométrie linéaire geojson (ex. {type, coordinates})
     * @return {boolean} true si la ligne se superpose elle-même sinon false
     */
    const isLineSelfOverlapping = (lineGeometry) => {
      return $http.post('/services/{portalid}/geometry/isLineSelfOverlapping?f=json', lineGeometry)
      .catch(
          error => {
            if (error && error.data && error.data.message) {
              require('toastr').error($filter('translate')(error.data.message));
            } else {
              require('toastr').error($filter('translate')('rulecfg.mustNotSelfIntersect.error'));
            }
          }
      );
    };
    /**
     * Trouve les objets qui se chevauchent à la géométrie fournie dans le corps de la requête.
     * Méthode pour suppléer l'opérateur overlap qui ne fonctionne pas correctement.
     * @param geometry geométrie linéaire ou surfacique pour laquelle on veut rechercher la présence d'objet en chevauchement
     * @param ftis liste d'uid de fti séparés par une virgule
     * @param outGeomType type de géométrie recherché en sortie ('LINESTRING', 'POLYGON'...), si null tous les types sont renvoyés
     * @param mapSrid srid de la carte de l'application KIS Map
     * @param tolerance distance de superposition minimale entre 2 lignes pour être considéré comme un réel chevauchement (en mètres).
     *                  Paramètre utilisé uniquement pour évaluer un chevauchement entre 2 linéaires/polygones
     * @return {string} objet geojson contenant la collection d'objets chevauchant la géométrie en entrée
     */
    const overlap = (geometry, ftis, outGeomType, mapSrid, tolerance) => {
      let url = '/services/{portalid}/geometry/overlap?f=json' + '&ftiUids=' + ftis
          + '&outGeomType=' + outGeomType + '&mapSrid=' + mapSrid;
      if (tolerance) {
        url += '&tolerance=' + tolerance;
      }
      return $http.post(url, geometry).catch(
          error => {
            if (error && typeof error.data === 'string') {
              console.error(error.data);
            }
            if (typeof error === 'object' && error !== null && error.hasOwnProperty('data')
                && typeof error.data === 'object' && error.data !== null
                && typeof error.data.message === 'string' && Array.isArray(error.data.details)
                && error.data.details.length > 0) {
              require('toastr').error($filter('translate')(error.message));
              console.error(error.data.details[0])
            }
          }
      );
    };

    return {
      GeometryFactory: GeometryFactory,
      union: union,
      unionifpossible: unionifpossible,
      buffer: buffer,
      difference: difference,
      unionandbuffer: unionandbuffer,
      project: project,
      autocomplete: autocomplete,
      simplify: simplify,
      intersectTwoGeoms: intersectTwoGeoms,
      intersect: intersect,
      getcentroid: getcentroid,
      cut: cut,
      convexhull: convexhull,
      movepointwithline: movePointWithLine,
      moveLineWithLine: moveLineWithLine,
      getPointAtDistanceOnLine: getPointAtDistanceOnLine,
      getCentroidInPolygon: getCentroidInPolygon,
      isLineSelfOverlapping: isLineSelfOverlapping,
      isLineSelfIntersecting: isLineSelfIntersecting,
      overlap: overlap
    };
  };
  GeometryFactory.$inject = ['$http', '$filter'];
  return GeometryFactory;
});
