'use strict';
define(function() {
  var homeAppSwitcher = function(
    $window,
    $rootScope,
    ConfigFactory,
    ApplicationFactory,
    FilesFactory,
    ngDialog,
    $filter,
    $location,
    gaJsUtils,
    homeFactory,
    PortalsFactory
  ) {
    return {
      templateUrl: 'js/XG/modules/home/views/directives/home_app_switcher.html',
      restrict: 'EA',
      scope: {
        allowConfig: '=?', // display configuration button
        inDropdown: '=?', // appswitcher displayed in dropdown
        portalId: '=?', // portalid
      },
      link: function(scope, elt, attrs, ctrl) {
        if (!angular.isDefined(scope.inDropdown)) scope.inDropdown = false;
        scope.goToHomeApp = false;
        if (scope.inDropdown) {
          if ($rootScope.xgos.isadmin) scope.goToHomeApp = true;
        }

        scope.goToHomeAppCfg = function() {
          $location.path('/home');
          $location.search('mode', 'config');
          $location.search('portal', PortalsFactory.getPortalId());
          $rootScope.appswitcher.visible = false;
        };

        // switcher state
        scope.switcher = {
          config: false,
          add_item: false,
        };

        if (!angular.isDefined(scope.portalId)) {
          scope.portalId = PortalsFactory.getPortalId();
        }

        // extraCfg objet to decorate applications
        var getExtraCfg = function(app) {
          var image = '';
          switch (app.type) {
            case 'MapApp':
              image = 'img/applications/default_images/' + app.type + '.png';
              break;
          }

          //-- Configuration supplémentaire
          return {
            image: image,
            description: '',
            visible: false,
          };
        };

        /**
         * createDefaultConfig
         * Create a default config template when /home has nerver been set before
         */
        var createDefaultConfig = function() {
          // set apps
          var appsCfg = {};
          scope.applications.forEach(function(app) {
            appsCfg[app.uid] = angular.extend(app, getExtraCfg(app));
          });

          // add admin
          if ($rootScope.xgos.isroot) {
            appsCfg['admin'] = {
              uid: 'admin',
              name: 'KIS admin',
              type: 'admin',
              description: '',
              image: '',
              visible: false,
            };
          }

          // default cfg
          scope.config = {
            filter: true,
            content:
              '<h1> ' +
              $filter('translate')('appswitcher.configuration.default_title') +
              ' </h1>' +
              '<img src="img/applications/default_images/appswitcher_default.jpg">' +
              '<h4> ' +
              $filter('translate')('appswitcher.configuration.default_sub') +
              ' </h4>' +
              '<p>' +
              'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor' +
              'incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis' +
              'nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.' +
              '</p>',
            apps: appsCfg,
          };
        };

        /**
         * check if apps have been added/edited/removed
         * since the configuration was made
         */
        var checkCurrentApps = function() {
          if (scope.applications.map != undefined) {
            var appUids = scope.applications.map(function(app) {
              return app.uid;
            });

            // check deleted apps
            for (var uid in scope.config.apps) {
              if (uid != 'admin' && !~uid.indexOf('external_app')) {
                // this app doesnt exist anymore
                if (!~appUids.indexOf(uid)) {
                  delete scope.config.apps[uid];
                }
              }
            }

            // check new apps
            appUids.forEach(function(appuid, index) {
              if (!scope.config.apps[appuid]) {
                scope.config.apps[appuid] = angular.extend(
                  scope.applications[index],
                  getExtraCfg(scope.applications[index])
                );
              }
              // set update name if it was changed
              scope.config.apps[appuid].name = scope.applications[index].name;
            });
          }
        };

        /**
         * Return app icon
         * @param app
         * @returns {string}
         */
        scope.getAppIcon = function(app) {
          var icon = 'fa fa-gears';
          if (app.type == 'MapApp') icon = 'fa fa-map-o';
          if (app.type == 'FormApp') icon = 'fa fa-check-square-o';
          if (app.type == 'SirocoApp') icon = 'fa fa-graph';
          if (app.type == 'CustomHtml') icon = 'fa fa-gear';
          if (~app.uid.indexOf('external_app')) icon = 'fa fa-link';

          return icon;
        };

        // get applications
        homeFactory.getApplicationThenGetConfiguration().then(
            (tmp) => {
              scope.applications = Object.assign([],ApplicationFactory.resources.applications);
              if (tmp === '') {
                createDefaultConfig();
              } else {
                // force l'usage de l'https sur les images placehold, kinda degueu
                for (const i in tmp.apps) {
                  // ne charge pas les références d'images du site placehold qui ne permet plus l'accès libre.
                  // Evite une erreur HTTP 403
                  if (tmp.apps.hasOwnProperty(i) && tmp.apps[i].image && tmp.apps[i].image.includes('//placehold.it')) {
                    tmp.apps[i].image = null;
                  }
                }

                scope.config = tmp;

                checkCurrentApps();
                //setExtraApps();
              }
            }
        );

        /**
         * select an application and display related information
         * @param app
         */
        scope.selectApp = function(app) {
          // get extra info from cfg
          scope.selectedApp = app;
        };

        /**
         * toggleConfig
         * @param value
         */
        scope.toggleConfig = function(value) {
          if (value) {
            scope.currentConfig = angular.copy(scope.config);
          } else {
            scope.config = scope.currentConfig;
          }
          scope.switcher.config = value;
          scope.filterApps = { v: '' };
        };

        /**
         * gotoApp
         * @param app
         */
        scope.gotoApp = function(app) {
          homeFactory.gotoApp(scope.portalId, app);
        };

        /**
         * edit an application image
         * @param app
         */
        var editAppImageDialog;
        scope.editAppImage = function(app) {
          scope.currentEditImageApp = app;
          scope.newImageSrc = '';

          editAppImageDialog = ngDialog.open({
            template:
              'js/XG/modules/home/views/modals/modal.app.image.html',
            className: 'ngdialog-theme-plain width800 nopadding miniclose',
            closeByDocument: false,
            scope: scope,
          });
        };
        /**
         * closeEditImageDialog
         */
        scope.closeEditImageDialog = function() {
          editAppImageDialog.close();
        };

        /**
         * uploadAppImage
         * @param input
         */
        scope.uploadAppImage = function(input) {
          scope.staticFile = input.files[0];
          var fd = new FormData();
          fd.append('file', scope.staticFile);

          FilesFactory.uploadprocess(fd).then(function(data) {
            scope.newImageSrc =
              '/services/' +
              scope.portalId +
              '/files/getfile?f=json' +
              '&fileName=' +
              scope.staticFile.name;
          });
        };

        /**
         * set the application new image
         */
        scope.setApplicationImage = function() {
          scope.closeEditImageDialog();
          scope.currentEditImageApp.image = scope.newImageSrc;
        };

        /**
         * reset new item
         */
        scope.resetNewItem = function() {
          scope.newItem = {
            title: '',
            url: '',
            description: '',
          };
        };
        scope.resetNewItem();

        /**
         *
         */
        scope.addNewItem = function() {
          var uid = 'external_app_' + Date.now();
          scope.config.apps[uid] = {
            uid: uid,
            name: scope.newItem.name,
            url: scope.newItem.url,
            description: scope.newItem.description,
            visible: false,
            type: 'external',
          };
          // setExtraApps(uid);
          scope.switcher.add_item = false;
          scope.resetNewItem();
        };

        /**
         * Delete an (external) application from the configuration object
         * @param app
         */
        scope.deleteAppFromCfg = function(app) {
          delete scope.config.apps[app.uid];
        };

        /**
         * check whether the new item can be submitted
         */
        scope.isValidNewItem = function() {
          return (
            scope.newItem.name != '' &&
            scope.newItem.url != '' &&
            scope.newItem.description != ''
          );
        };

        /**
         * saveConfiguration
         */
        scope.saveConfiguration = function() {
          ConfigFactory.add(scope.config, 'home', 'config', 'kis_home').then(
            function(res) {
              scope.currentConfig = angular.copy(scope.config);
              scope.toggleConfig(false);
            }
          );
        };

        scope.filterApps = { v: '' };
        scope.filterAppsList = function(list) {
          if (
            !angular.isDefined(scope.filterApps.v) ||
            scope.filterApps.v == ''
          ) {
            return list;
          }

          var result = {};
          angular.forEach(list, function(x, y) {
            if (
              ~x.name.toLowerCase().indexOf(scope.filterApps.v.toLowerCase())
            ) {
              result[y] = x;
            }
          });
          return result;
        };

        /**
         * hasRight
         * user acn display app according to its rights
         * @param app
         * @returns {*|boolean}
         */
        scope.hasRight = function(app) {
          return $rootScope.xgos.isadmin || app.uid != 'admin';
        };
      },
    };
  };

  homeAppSwitcher.$inject = [
    '$window',
    '$rootScope',
    'ConfigFactory',
    'ApplicationFactory',
    'FilesFactory',
    'ngDialog',
    '$filter',
    '$location',
    'gaJsUtils',
    'homeFactory',
    'PortalsFactory'
  ];
  return homeAppSwitcher;
});
