'use strict';
define(function() {
  var LogTrackerFactory = function($http) {
    var LogTrackerFactory = {};
    /**
     * Class : LogTrackerFactory
     * Factory WebServices
     */

    /**
     * Function: getlogs, Récupère les enregistrements de la table des log qui satisfont au filtre passé en paramètre.
     * @param filter  a string ECQL predicate see http://docs.geoserver.org/latest/en/user/filter/ecql_reference.html
     *  (ex: filter= "Quand AFTER 2015-08-13T07:45:36 AND Quand BEFORE 2015-08-14T07:46:00")
     *
     *  Si filter est chaine vide, tous les enregistrements seront ramenés.
     *
     * @param nb_lines not yet server implemented, use null.
     * @return un String GeoJson representant une FeatureCollection d'enregistrements de la table caj_log_tracker.
     */
    function getlogs(filter, nb_lines, page, count) {
      var promise = $http.get(
        '/services/{portalid}/logtracker/{appname}/getlogs?f=json' +
          '&filter=' +
          filter +
          '&nb_lines=' +
          nb_lines +
          '&page=' +
          page +
          '&count=' +
          count
      );

      return promise;
    }

    function getSize() {
      var promise = $http.get(
        '/services/{portalid}/logtracker/{appname}/getSize?f=json'
      );

      return promise;
    }
    /**
     * Function: deletelogs, Supprime les enregistrements de la table des log qui satisfont au filtre passé en paramètre.
     * @param filter  a string ECQL predicate see http://docs.geoserver.org/latest/en/user/filter/ecql_reference.html
     *  (ex: filter= "Quand AFTER 2015-08-13T07:45:36 AND Quand BEFORE 2015-08-14T07:46:00")
     *
     * filter ne doit pas être vide sinon, aucune suppression ramène "failed".
     * Si tous les enregistrements doivent être supprimés, donner à "filter" une condition toujours vraie (ex. : "1=1").
     *
     * @return  un Objet String "success" en cas de suppression réussi, ou "failed" en cas d'erreur.
     */
    function deletelogs(filter) {
      var promise = $http.get(
        '/services/{portalid}/logtracker/{appname}/deletelogs?f=json' +
          '&filter=' +
          filter
      );

      return promise;
    }
    return {
      LogTrackerFactory: LogTrackerFactory,
      getlogs: getlogs,
      deletelogs: deletelogs,
      getSize: getSize,
    };
  };
  LogTrackerFactory.$inject = ['$http'];
  return LogTrackerFactory;
});
