/**
 *
 */
'use strict';
define(function() {
  /**
   * PhoneFromCtrl
   * @param $scope
   * @param $window
   * @param $location
   * @param ApplicationFactory
   * @param RolesFactory
   * @constructor
   */
  var PhoneFromCtrl = function(
    $scope,
    $window,
    $location,
    RolesFactory,
    ngDialog,
    $timeout,
    $filter,
    FunctionFactory,
    $http,
    OdkFactory,
    $rootScope
  ) {
    $scope.builderForm = function(loadTemplate) {
      $scope.edit = false;
      $scope.pp = ngDialog.open({
        template: 'js/XG/modules/odk/views/modals/modal.add.document.html',
        className: 'ngdialog-theme-plain  width350 height370 miniclose',
        closeByDocument: false,
        scope: $scope,
      });
    };
    $scope.builderFormedit = function(loadTemplate) {
      $scope.edit = true;
      ngDialog.open({
        template: 'js/XG/modules/odk/views/modals/modal.add.document.html',
        className: 'ngdialog-theme-plain  width350 height370 miniclose',
        closeByDocument: false,
        scope: $scope,
      });
    };
    $scope.removeForm = function() {
      OdkFactory.removeuploaded($scope.edit_resource.name).then(function(res) {
        refreshList();
      });
    };
    $scope.getFile = function() {
      window.open(
        '/services/' +
          $rootScope.xgos.portal.uid +
          '/odk/getFile?f=json&name=' +
          $scope.edit_resource.name
      );
    };
    $scope.refreshDocumentsList = function() {
      //alert("coco");
      //refreshList();
      VerifyAndrefreshList();
    };

    $scope.editListCfg = {
      dataModule: 'odk',
      resource_type: 'mobileform',
      cols: ['name'],
      addFunction: $scope.builderForm,
      editFunction: $scope.builderFormedit,
      removeFunction: $scope.removeForm,
      extraActions: [
        {
          icon: "<i class='fa fa-download'></i>",
          label: 'common.featuretypes.refresh',
          fn: $scope.getFile,
          disableCondition: 'download',
        },
      ],
    };
    $scope.deleteNotValideForm = function(name) {
      OdkFactory.removeuploaded(name).then();
    };
    var VerifyAndrefreshList = function() {
      //$scope.currentResources = [];

      $scope.valide = true;
      OdkFactory.getlisttemplate().then(function(res) {
        /* $scope.testfeature = FeatureTypeFactory.getFeatureByUid('69506c75-9575-4a71-88e1-cb09a48ea263');*/
        //$scope.currentResources = res.data;
        var forms = res.data;
        for (var i = 0; i < res.data.length; i++) {
          if (res.data[i].name.indexOf(' ') !== -1) {
            //require('toastr').error("Le nom du fichier téléchargé n'est pas valide");
            require('toastr').error(
              $filter('translate')('odk.mobileform.nomInvalide')
            );
            $scope.valide = false;
            //alert('erreur dans le nom du fichier téléchargé');
            $scope.deleteNotValideForm(res.data[i].name);
            forms.splice(i, 1);
          }
        }
        $scope.currentResources = forms;
        if ($scope.valide == true) {
          console.log($scope.currentResources);
          $scope.pp.close();
        }
      });
    };
    /**
     * [refreshList description]
     * @return {[type]} [description]
     */
    var refreshList = function() {
      $scope.currentResources = [];

      OdkFactory.getlisttemplate().then(function(res) {
        /* $scope.testfeature = FeatureTypeFactory.getFeatureByUid('69506c75-9575-4a71-88e1-cb09a48ea263');*/
        $scope.currentResources = res.data;

        //refreshList();
      });
    };

    OdkFactory.getlisttemplate().then(function(res) {
      /* $scope.testfeature = FeatureTypeFactory.getFeatureByUid('69506c75-9575-4a71-88e1-cb09a48ea263');*/
      // $scope.currentResources = res.data;

      var forms = res.data;
      for (var i = 0; i < res.data.length; i++) {
        if (res.data[i].name.indexOf(' ') !== -1) {
          $scope.deleteNotValideForm(res.data[i].name);
          forms.splice(i, 1);
        }
      }
      $scope.currentResources = forms;

      //refreshList();
    });
    setTimeout(function() {
      // dev
      // $scope.builderForm({application_name: "mapapp", type: "forms", name: "simple.form"})
    }, 500);
  };

  PhoneFromCtrl.$inject = [
    '$scope',
    '$window',
    '$location',
    'RolesFactory',
    'ngDialog',
    '$timeout',
    '$filter',
    'FunctionFactory',
    '$http',
    'OdkFactory',
    '$rootScope',
  ];
  return PhoneFromCtrl;
});
