'use strict';
/**
 * @ngdoc overview
 * @name modules.odk
 * @description
 * odk module
 */
define([
  'angular',

  'modules/odk/services/OdkFactory',
  'modules/odk/controllers/PhoneFromCtrl',
  'modules/odk/controllers/phoneFormInterventionCtrl',
  'modules/odk/controllers/imeiCtrl',
], function(
  angular,
  OdkFactory,
  PhoneFromCtrl,
  phoneFormInterventionCtrl,
  imeiCtrl
) {
  // Module
  var mod = angular.module('odk', []);

  // Services
  mod.service('OdkFactory', OdkFactory);

  // Controllers
  mod.controller('PhoneFromCtrl', PhoneFromCtrl);
  mod.controller('phoneFormInterventionCtrl', phoneFormInterventionCtrl);
  mod.controller('imeiCtrl', imeiCtrl);

  // Configuration
  mod.config([
    '$routeProvider',
    function($routeProvider) {
      $routeProvider.when('/phonesform/', {
        templateUrl: 'js/XG/modules/' + 'odk/views/phonesform.html',
        controller: PhoneFromCtrl,
      });
      $routeProvider.when('/phonesformintervention/', {
        templateUrl: 'js/XG/modules/' + 'odk/views/phonesformintervention.html',
        controller: phoneFormInterventionCtrl,
      });
      $routeProvider.when('/imei/', {
        templateUrl: 'js/XG/modules/' + 'odk/views/imei.html',
        controller: imeiCtrl,
      });
    },
  ]);
  return mod;
});
