'use strict';
define(function() {
  var unitconvert = function() {
    return {
      restrict: 'A',
      require: 'ngModel',

      link: function(scope, element, attr, ngModel) {
        function fromUser(cm) {
          //var pix = (cm * 96) / 2.54 ;
          var pix = (cm * 72) / 2.54;
          return pix;
        }

        function toUser(pix) {
          //var cm = (pix * 2.54) / 96 ;
          var cm = (pix * 2.54) / 72;
          var roundcm = Math.round(cm * 100) / 100;
          return roundcm;
        }

        ngModel.$parsers.push(fromUser);
        ngModel.$formatters.push(toUser);
      },
    };
  };

  unitconvert.$inject = [];
  return unitconvert;
});
