'use strict';
define(function() {
  var ReportFactory = function($http) {
    var ReportFactory = {};
    /**
     * Class : ReportFactory
     * Factory WebServices
     */

    /**
     * Function: addtempfile
     */
    function addtempfile(senddata) {
      var promise = $http.post(
        '/services/{portalid}/report/{appname}/generated/add?f=json',
        senddata
      );

      return promise;
    }
    /**
     * Function: consultgeneratedreport
     */
    function consultgeneratedreport(senddata, isMultiReport, jasperFileName, dataStoreName,
      exportFormat, isAction = false, suffix = ''
    ) {
      return $http.post(
        '/services/{portalid}/report/{appname}/generated/consult?f=json'
        + '&isMultiReport=' + isMultiReport + '&jasperFileName=' + jasperFileName
        + '&dataStoreName=' + dataStoreName + '&exportFormat=' + exportFormat
        + '&isAction=' + isAction + '&suffix=' + suffix,
        senddata
      );
    }

    /**
     * Function: getreport
     */
    function getreport(
      senddata,
      jasperFileName,
      dataStoreName,
      isMultiReport,
      exportFormat,
      isAction = false
    ) {
      //var promise = $http.post('/services/{portalid}/report/{appname}/generated/get?f=json' +'&jasperFileName=' + jasperFileName +'&dataStoreName=' + dataStoreName +'&isMultiReport=' + isMultiReport +'&exportFormat=' + exportFormat,senddata);

      var promise = $http({
        url:
          '/services/{portalid}/report/{appname}/generated/get?f=json' +
          '&jasperFileName=' +
          jasperFileName +
          '&dataStoreName=' +
          dataStoreName +
          '&isMultiReport=' +
          isMultiReport +
          '&exportFormat=' +
          exportFormat +
          '&isAction=' +
          isAction,
        method: 'POST',
        data: senddata,
        headers: {
          'Content-Type': 'application/json',
          encoding: 'UTF-8',
        },
        responseType: 'blob',
      });

      return promise;
    }

    /**
     * Widget Tableaux de bord
     * Supprime un rapport Jasper du repo et renvoie la liste de rapport du dossier
     */
    function deletejasperfile(senddata) {
      const promise = $http.post(
        '/services/{portalid}/report/{appname}/jasper/remove?f=json',
        senddata,
        {
          transformRequest: angular.identity,
          headers: { 'Content-Type': undefined },
        }
      );
      promise.catch(
          err => {
            let error;
            if (err.data) {
              if (typeof err.data === 'string') {
                error = err.data;
              } else if (typeof err.data.message === 'string') {
                error = err.data.message;
              }
            } else {
              error = err;
            }
            require('toastr').error(error);
            console.error(error);
          });
      return promise;
    }

    /**
     * Function: getjasperfiles
     */
    function getjasperfiles(appname,isAction) {
      var promise = $http.get(
        '/services/{portalid}/report/{appname}/jasper/get?f=json' +
          '&appname=' +
          appname +
          '&isAction=' +
          isAction
      );

      return promise;
    }
    /**
     * Function: addjasperfile
     */
    const addjasperfile = (senddata, returnReportNames = false) => {
      return $http.post(
        '/services/{portalid}/report/{appname}/jasper/add?f=json'
          +'&returnReportNames=' + returnReportNames,
        senddata,
        {
          transformRequest: angular.identity,
          headers: { 'Content-Type': undefined },
        }
      );
    }

    /**
     * Function: getParameters
     */
    function getParameters(jasperFileName,isAction) {
      const dashboardPath = '/services/{portalid}/report/{appname}/jasper/getParameters?f=json&jasperFileName=' +
          jasperFileName;
      const actionPath = '/services/{portalid}/report/{appname}/jasper/getParameters?f=json&jasperFileName=' +
          jasperFileName + '&isAction=' + isAction;

      return $http.get(isAction ? actionPath : dashboardPath);

    }

    /**
     * Function: getParams
     */
    function getParams(jasperFileName, appname,isAction) {
      isAction = isAction ? isAction : false;
      return $http.get(
        '/services/{portalid}/report/' +
          appname +
          '/jasper/getParameters?f=json&jasperFileName=' +
          jasperFileName + '&isAction=' + isAction
      );
    }

    /**
     * Supprime un fichier
     * Fonction exécutée au clic sur le bouton "Supprimer"
     * @param appname nom de l'application où se trouve le fichier
     * @param isAction est true si le sous-répertoire est "reports_action
     * @param filename est le nom du fichier à supprimer
     * @param isImage est true si le fichier est une image
     * @returns {Promise}
     */
    function removeuploaded(appname,isAction,filename,isImage) {
      return $http.get(
          '/services/{portalid}/report/'+appname+'/jasper/'+isAction+'/removeuploaded?f=json' +
          '&filename=' +
          filename +
          '&isImage=' +
          isImage
      );
    }

    /**
     * Déplace un fichier du dossier "portalId/TEMP" au dossier "portalId/APPS/appname/type"
     * @param appname nom de l'application  où le fichier va être déplacé
     * @param type est égal à "action" ou "dashboard". Si "action" alors le fichier sera déplacé dans "/reports_action"
     * @param filenames tableau contenant les noms des fichiers temporaires à déplacer
     * @returns {Promise}
     */
    function saveTempFile(appname,type,filenames){
      const isAction = type==='action';
      return $http.post(
          '/services/{portalid}/report/' + appname
          + '/jasper/savetempfile?f=json' +
          '&isAction=' +
          isAction,filenames
      );
    }

    return {
      ReportFactory: ReportFactory,
      addtempfile: addtempfile,
      consultgeneratedreport: consultgeneratedreport,
      getreport: getreport,
      deletejasperfile: deletejasperfile,
      getjasperfiles: getjasperfiles,
      addjasperfile: addjasperfile,
      getParameters: getParameters,
      getParams: getParams,
      removeuploaded: removeuploaded,
      saveTempFile: saveTempFile
    };
  };
  ReportFactory.$inject = ['$http'];
  return ReportFactory;
});
