'use strict';
define(function () {
  var CheckUpFactory = function (
      $http,
      PortalsFactory
  ) {
    var portalid = angular.module('gcMain').portalid;
    if (portalid == undefined || portalid == '') {
      portalid = PortalsFactory.getPortalId();
    }

    function startCheckUp(storeName, clean, checkupList) {
      return $http.get(
        '/services/{portalid}/checkup/startCheckUp?f=json' +
          '&storeName=' +
          storeName +
          '&clean=' +
          clean + 
          '&checkupList=' +
          checkupList.join(',')
      );
    }

    function getCheckUpData() {
      return $http.get(
        '/services/{portalid}/checkup/getCheckUpData'
      );
    }

    function stopCheckUp() {
      return $http.get(
        '/services/{portalid}/checkup/stopCheckUp'
      );
    }

    function getCheckupList() {
      return $http.get(
        '/services/{portalid}/checkup/getCheckupList'
      );
    }

    return {
      startCheckUp: startCheckUp,
      getCheckUpData: getCheckUpData,
      stopCheckUp: stopCheckUp,
      getCheckupList: getCheckupList,
    };
  };
  CheckUpFactory.$inject = [
      '$http',
      'PortalsFactory'
  ];
  return CheckUpFactory;
});
