'use strict';
define(['angular'], function(angular) {
  var mod = angular.module('ga_jsgeneral_factory', []);

  mod.provider('gaJsGeneral', function() {
    this.$get = function($q) {
      return {
        loadScript: function(src) {
          var deferred = $q.defer();
          var script = document.createElement('script');
          script.setAttribute('src', src);
          script.addEventListener('load', () => deferred.resolve());
          document.head.appendChild(script);
          return deferred.promise;
        },
      };
    };
    this.$get.$inject = ['$q'];
  });

  return mod;
});
