'use strict';
define(function() {
  var ancCustomDossierRequetes = function(
    $rootScope,
    $filter,
    $q,
    FeatureTypeFactory,
    AncAppFactory,
    QueryFactory,
    gaDomUtils,
    AlertHpoFactory
  ) {
    return {
      templateUrl:
        'js/XG/widgets/ancapp/main/views/directives/ancCustomDossierRequetes.html',
      restrict: 'E',
      scope: {},
      link: function(scope) {
        const defaultDb = 'COMMON';
        let customRequests = [
          {
            label: '1. Bilan Contrôles du neuf',
            labelClass:"elasticPink",
            queryName:'queryNewControls',
            description:
              'Extraction des contrôles de Conception et Réalisation faits ou ' +
              'en cours sur une période donnée (exclusion des dossiers placés en archive, ' +
              'classés sans suite ou raccordés)',
            data: {
              relations: [
                {
                  filters: [
                    {
                      disabled: true,
                      choice: 'rule',
                      operand: 'equals',
                      value: 'en cours',
                      name: 'etat_dossier',
                      selectedfti: 'kis_anc_dossier',
                      guid: 'kis_anc_dossier_etat_dossier',
                      relation_DOSSIER_CONTROLE_choosen: 'kis_anc_dossier',
                    },
                    {
                      attr: {},
                      choice: 'relation',
                      choicesdone: 'Contient',
                      choices: ['Contient'],
                      controle_json_filters: {
                        rule: 'common',
                        types: {
                          FO1: { selected: true },
                          FO2: { selected: true },
                          FO3: { selected: true },
                          FO4: { selected: true },
                        },
                      },
                      filters: [
                        {
                          choice: 'rule',
                          operand: 'equals',
                          value: '',
                          name: 'info_generales.dossier.adresse_ville',
                          selectedfti: 'kis_anc_dossier_controle',
                          guid: 'kis_anc_dossier_info_general_adresse_ville',
                          relation_DOSSIER_CONTROLE_choosen:
                            'kis_anc_dossier_controle',
                        },
                        {
                          choice: 'rule',
                          operand: 'gt',
                          value: '',
                          name: 'date_passage',
                          selectedfti: 'kis_anc_dossier_controle',
                          guid: 'kis_anc_dossier_controle_date_passage_gt',
                          relation_DOSSIER_CONTROLE_choosen:
                            'kis_anc_dossier_controle',
                        },
                        {
                          choice: 'rule',
                          operand: 'lt',
                          value: '',
                          name: 'date_passage',
                          selectedfti: 'kis_anc_dossier_controle',
                          guid: 'kis_anc_dossier_controle_date_passage_lt',
                          relation_DOSSIER_CONTROLE_choosen:
                            'kis_anc_dossier_controle',
                        },
                        {
                          disabled: true,
                          choice: 'rule',
                          operand: 'include',
                          value: ['FO1', 'FO2'],
                          name: 'type',
                          selectedfti: 'kis_anc_dossier_controle',
                          guid: 'kis_anc_dossier_controle_type',
                          relation_DOSSIER_CONTROLE_choosen:
                            'kis_anc_dossier_controle',
                        },
                      ],
                      relation_DOSSIER_CONTROLE_choosen:
                        'kis_anc_dossier_controle',
                      selectedfti: 'kis_anc_dossier_controle',
                    },
                  ],
                  selectGlobaladvancedFti: 'Dossier ANC',
                  selectedfti: 'kis_anc_dossier',
                },
              ],
            },
          },
          {
            label: '2. Bilan des conceptions (constructions neuves)',
            labelClass:"elasticPink",
            queryName:'queryNewConstructions',
            description:
              'Liste des contrôles de conception pour une construction neuve,'
              +' validés sur une période (exclusion des dossiers placés en '
              +'archive, classés sans suite ou raccordés)',
            data: {
              relations: [
                {
                  filters: [
                    {
                      disabled: true,
                      choice: 'rule',
                      operand: 'equals',
                      value: 'en cours',
                      name: 'etat_dossier',
                      selectedfti: 'kis_anc_dossier',
                      guid: 'kis_anc_dossier_etat_dossier',
                      relation_DOSSIER_CONTROLE_choosen: 'kis_anc_dossier',
                    },
                    {
                      attr: {},
                      choice: 'relation',
                      choicesdone: 'Contient',
                      choices: ['Contient'],
                      controle_json_filters: {
                        rule: 'common',
                        types: {
                          FO1: { selected: true },
                        },
                      },
                      filters: [
                        {
                          choice: 'rule',
                          operand: 'gt',
                          value: '',
                          name: 'date_passage',
                          selectedfti: 'kis_anc_dossier_controle',
                          guid: 'kis_anc_dossier_controle_date_passage_gt',
                          relation_DOSSIER_CONTROLE_choosen:
                            'kis_anc_dossier_controle',
                        },
                        {
                          choice: 'rule',
                          operand: 'lt',
                          value: '',
                          name: 'date_passage',
                          selectedfti: 'kis_anc_dossier_controle',
                          guid: 'kis_anc_dossier_controle_date_passage_lt',
                          relation_DOSSIER_CONTROLE_choosen:
                            'kis_anc_dossier_controle',
                        },
                        {
                          disabled: true,
                          choice: 'rule',
                          operand: 'equals',
                          value: 'FO1',
                          name: 'type',
                          selectedfti: 'kis_anc_dossier_controle',
                          guid: 'kis_anc_dossier_controle_type',
                          relation_DOSSIER_CONTROLE_choosen:
                            'kis_anc_dossier_controle',
                        },
                        {
                          disabled: true,
                          choice: 'rule',
                          operand: 'equals',
                          value: 'Construction neuve',
                          name: 'caracteristiques_hab.new',
                          selectedfti: 'kis_anc_dossier_controle',
                          guid:
                            'kis_anc_dossier_controle_caracteristiques_hab_new',
                          relation_DOSSIER_CONTROLE_choosen:
                            'kis_anc_dossier_controle',
                        },
                        {
                          disabled: true,
                          choice: 'rule',
                          operand: 'equals',
                          value: 'Clos',
                          name: 'etat',
                          selectedfti: 'kis_anc_dossier_controle',
                          guid: 'kis_anc_dossier_controle_etat',
                          relation_DOSSIER_CONTROLE_choosen:
                            'kis_anc_dossier_controle',
                        },
                      ],
                      relation_DOSSIER_CONTROLE_choosen:
                        'kis_anc_dossier_controle',
                      selectedfti: 'kis_anc_dossier_controle',
                    },
                  ],
                  selectGlobaladvancedFti: 'Dossier ANC',
                  selectedfti: 'kis_anc_dossier',
                },
              ],
            },
          },
          {
            label: '3. Bilan des conceptions (constructions existantes)',
            labelClass:"elasticPink",
            queryName:'queryExistingConstructions',
            description:
              'Liste des contrôles de conception pour une construction existante,'
              +' validés sur une période (exclusion des dossiers placés en '
              +'archive, classés sans suite ou raccordés)',
            data: {
              relations: [
                {
                  filters: [
                    {
                      disabled: true,
                      choice: 'rule',
                      operand: 'equals',
                      value: 'en cours',
                      name: 'etat_dossier',
                      selectedfti: 'kis_anc_dossier',
                      guid: 'kis_anc_dossier_etat_dossier',
                      relation_DOSSIER_CONTROLE_choosen: 'kis_anc_dossier',
                    },
                    {
                      attr: {},
                      choice: 'relation',
                      choicesdone: 'Contient',
                      choices: ['Contient'],
                      controle_json_filters: {
                        rule: 'common',
                        types: {
                          FO1: { selected: true },
                        },
                      },
                      filters: [
                        {
                          choice: 'rule',
                          operand: 'equals',
                          value: '',
                          name: 'info_generales.dossier.adresse_ville',
                          selectedfti: 'kis_anc_dossier_controle',
                          guid: 'kis_anc_dossier_info_general_adresse_ville',
                          relation_DOSSIER_CONTROLE_choosen:
                            'kis_anc_dossier_controle',
                        },
                        {
                          choice: 'rule',
                          operand: 'gt',
                          value: '',
                          name: 'date_passage',
                          selectedfti: 'kis_anc_dossier_controle',
                          guid: 'kis_anc_dossier_controle_date_passage_gt',
                          relation_DOSSIER_CONTROLE_choosen:
                            'kis_anc_dossier_controle',
                        },
                        {
                          choice: 'rule',
                          operand: 'lt',
                          value: '',
                          name: 'date_passage',
                          selectedfti: 'kis_anc_dossier_controle',
                          guid: 'kis_anc_dossier_controle_date_passage_lt',
                          relation_DOSSIER_CONTROLE_choosen:
                            'kis_anc_dossier_controle',
                        },
                        {
                          disabled: true,
                          choice: 'rule',
                          operand: 'equals',
                          value: 'FO1',
                          name: 'type',
                          selectedfti: 'kis_anc_dossier_controle',
                          guid: 'kis_anc_dossier_controle_type',
                          relation_DOSSIER_CONTROLE_choosen:
                            'kis_anc_dossier_controle',
                        },
                        {
                          disabled: true,
                          choice: 'rule',
                          operand: 'equals',
                          value: 'Construction existante',
                          name: 'caracteristiques_hab.new',
                          selectedfti: 'kis_anc_dossier_controle',
                          guid:
                            'kis_anc_dossier_controle_caracteristiques_hab_new',
                          relation_DOSSIER_CONTROLE_choosen:
                            'kis_anc_dossier_controle',
                        },
                        {
                          disabled: true,
                          choice: 'rule',
                          operand: 'equals',
                          value: 'Clos',
                          name: 'etat',
                          selectedfti: 'kis_anc_dossier_controle',
                          guid: 'kis_anc_dossier_controle_etat',
                          relation_DOSSIER_CONTROLE_choosen:
                            'kis_anc_dossier_controle',
                        },
                      ],
                      relation_DOSSIER_CONTROLE_choosen:
                        'kis_anc_dossier_controle',
                      selectedfti: 'kis_anc_dossier_controle',
                    },
                  ],
                  selectGlobaladvancedFti: 'Dossier ANC',
                  selectedfti: 'kis_anc_dossier',
                },
              ],
            },
          },
          {
            label: '4. Recensement - bilan global',
            labelClass:"elasticPink",
            queryName:'queryValidatedControls',
            description:
              'Derniers contrôles validés sur une période donnée (exclusion des '
              + 'dossiers placés en archive, classés sans suite ou raccordés)',
            data: {
              relations: [
                {
                  filters: [
                    {
                      disabled: true,
                      choice: 'rule',
                      operand: 'equals',
                      value: 'en cours',
                      name: 'etat_dossier',
                      selectedfti: 'kis_anc_dossier',
                      guid: 'kis_anc_dossier_etat_dossier',
                      relation_DOSSIER_CONTROLE_choosen: 'kis_anc_dossier',
                    },
                    {
                      attr: {},
                      choice: 'relation',
                      choicesdone: 'Contient',
                      choices: ['Contient'],
                      controle_json_filters: {
                        rule: 'common',
                        types: {
                          FO1: { selected: true },
                          FO2: { selected: true },
                          FO3: { selected: true },
                          FO4: { selected: true },
                        },
                      },
                      filters: [
                        {
                          choice: 'rule',
                          operand: 'gt',
                          value: '',
                          name: 'date_passage',
                          selectedfti: 'kis_anc_dossier_controle',
                          guid: 'kis_anc_dossier_controle_date_passage_gt',
                          relation_DOSSIER_CONTROLE_choosen:
                            'kis_anc_dossier_controle',
                        },
                        {
                          choice: 'rule',
                          operand: 'lt',
                          value: '',
                          name: 'date_passage',
                          selectedfti: 'kis_anc_dossier_controle',
                          guid: 'kis_anc_dossier_controle_date_passage_lt',
                          relation_DOSSIER_CONTROLE_choosen:
                            'kis_anc_dossier_controle',
                        },
                        {
                          choice: 'rule',
                          operand: 'equals',
                          value: '',
                          name: 'info_generales.dossier.adresse_ville',
                          selectedfti: 'kis_anc_dossier_controle',
                          guid: 'kis_anc_dossier_info_general_adresse_ville',
                          relation_DOSSIER_CONTROLE_choosen:
                            'kis_anc_dossier_controle',
                        },
                        {
                          choice: 'rule',
                          operand: 'equals',
                          value: '',
                          name: 'type',
                          selectedfti: 'kis_anc_dossier_controle',
                          guid: 'kis_anc_dossier_controle_type',
                          relation_DOSSIER_CONTROLE_choosen:
                            'kis_anc_dossier_controle',
                        },
                        {
                          disabled: true,
                          choice: 'rule',
                          operand: 'equals',
                          value: 'Clos',
                          name: 'etat',
                          selectedfti: 'kis_anc_dossier_controle',
                          guid: 'kis_anc_dossier_controle_etat',
                          relation_DOSSIER_CONTROLE_choosen:
                            'kis_anc_dossier_controle',
                        },
                      ],
                      relation_DOSSIER_CONTROLE_choosen:
                        'kis_anc_dossier_controle',
                      selectedfti: 'kis_anc_dossier_controle',
                    },
                  ],
                  selectGlobaladvancedFti: 'Dossier ANC',
                  selectedfti: 'kis_anc_dossier',
                },
              ],
            },
          },
          {
            label: '5. Recensement des installations existantes',
            labelClass:"elasticPink",
            queryName:'queryExistingInstallations',
            description:
              'Liste des contrôles d’installations existantes (derniers contrôles'
              +' validés de type Diagnostic, Périodique, Vente, Neuf pour'
              +' constructions existantes) sur une période donnée (exclusion '
              +'des dossiers placés en archive, classés sans suite ou raccordés)',
            data: {
              relations: [
                {
                  filters: [
                    {
                      disabled: true,
                      choice: 'rule',
                      operand: 'equals',
                      value: 'en cours',
                      name: 'etat_dossier',
                      selectedfti: 'kis_anc_dossier',
                      guid: 'kis_anc_dossier_etat_dossier',
                      relation_DOSSIER_CONTROLE_choosen: 'kis_anc_dossier',
                    },
                    {
                      attr: {},
                      choice: 'relation',
                      choicesdone: 'Contient',
                      choices: ['Contient'],
                      controle_json_filters: {
                        rule: 'common',
                        types: {
                          FO1: { selected: true },
                        },
                      },
                      filters: [
                        {
                          choice: 'rule',
                          operand: 'equals',
                          value: '',
                          name: 'info_generales.dossier.adresse_ville',
                          selectedfti: 'kis_anc_dossier_controle',
                          guid: 'kis_anc_dossier_info_general_adresse_ville',
                          relation_DOSSIER_CONTROLE_choosen:
                            'kis_anc_dossier_controle',
                        },
                        {
                          choice: 'rule',
                          operand: 'gt',
                          value: '',
                          name: 'date_passage',
                          selectedfti: 'kis_anc_dossier_controle',
                          guid: 'kis_anc_dossier_controle_date_passage_gt',
                          relation_DOSSIER_CONTROLE_choosen:
                            'kis_anc_dossier_controle',
                        },
                        {
                          choice: 'rule',
                          operand: 'lt',
                          value: '',
                          name: 'date_passage',
                          selectedfti: 'kis_anc_dossier_controle',
                          guid: 'kis_anc_dossier_controle_date_passage_lt',
                          relation_DOSSIER_CONTROLE_choosen:
                            'kis_anc_dossier_controle',
                        },
                        {
                          disabled: true,
                          choice: 'rule',
                          operand: 'equals',
                          value: 'Clos',
                          name: 'etat',
                          selectedfti: 'kis_anc_dossier_controle',
                          guid: 'kis_anc_dossier_controle_etat',
                          relation_DOSSIER_CONTROLE_choosen:
                            'kis_anc_dossier_controle',
                        },
                      ],
                      relation_DOSSIER_CONTROLE_choosen:
                        'kis_anc_dossier_controle',
                      selectedfti: 'kis_anc_dossier_controle',
                    },
                  ],
                  selectGlobaladvancedFti: 'Dossier ANC',
                  selectedfti: 'kis_anc_dossier',
                },
              ],
            },
          },
          {
            label:
              '6. Nombre de contrôles réalisés sur une période donnée classés par commune et regroupés par type de contrôle',
            labelClass:"elasticPink",
            queryName:'queryInspectionsDone',
            description:
              'Basé sur le dernier contrôle validé (exclusion des dossiers placés en archive, classés sans suite ou raccordés)',
            data: {
              relations: [
                {
                  filters: [],
                  selectGlobaladvancedFti: 'Dossier ANC',
                  selectedfti: 'kis_anc_dossier',
                },
              ],
            },
          },
          {
            label:
              '7. Etat de conformité du parc ANC en différenciant les types de contrôle',
            labelClass:"elasticPink",
            queryName:'queryConformityStatusByType',
            description:
              'Regroupement des derniers contrôles validés par type de'
              + ' contrôle en excluant les dossiers pour lesquels le dernier'
              + ' contrôle validé est un contrôle de réalisation et qui au'
              + ' préalable n’ont pas eu de contrôle de type diagnostic,'
              + ' périodique ou vente (exclusion des dossiers placés en'
              + ' archive, classés sans suite ou raccordés)',
            data: {
              relations: [
                {
                  filters: [
                    {
                      attr: {},
                      choice: 'relation',
                      choicesdone: 'Contient',
                      choices: ['Contient'],
                      controle_json_filters: {
                        rule: 'common',
                        types: {
                          FO1: { selected: true },
                        },
                      },
                      filters: [
                        {
                          disabled: true,
                          choice: 'rule',
                          operand: 'equals',
                          value: 'Clos',
                          name: 'etat',
                          selectedfti: 'kis_anc_dossier_controle',
                          guid: 'kis_anc_dossier_controle_etat',
                          relation_DOSSIER_CONTROLE_choosen:
                            'kis_anc_dossier_controle',
                        },
                      ],
                      relation_DOSSIER_CONTROLE_choosen:
                        'kis_anc_dossier_controle',
                      selectedfti: 'kis_anc_dossier_controle',
                    },
                  ],
                  selectGlobaladvancedFti: 'Dossier ANC',
                  selectedfti: 'kis_anc_dossier',
                },
              ],
            },
          },
          {
            label: '8. Etat de conformité du parc ANC commune par commune',
            labelClass:"elasticPink",
            queryName:'queryConformityStatusByCity',
            description:
              'Regroupement des derniers contrôles validés par commune en '
              + 'excluant les dossiers pour lesquels le dernier contrôle '
              + 'validé est un contrôle de réalisation et qui au préalable '
              + 'n’ont pas eu de contrôle de type diagnostic, périodique ou '
              + 'vente (exclusion des dossiers placés en archive, classés '
              + 'sans suite ou raccordés)',
            data: {
              relations: [
                {
                  filters: [
                    {
                      attr: {},
                      choice: 'relation',
                      choicesdone: 'Contient',
                      choices: ['Contient'],
                      controle_json_filters: {
                        rule: 'common',
                        types: {
                          FO1: { selected: true },
                        },
                      },
                      filters: [
                        {
                          disabled: true,
                          choice: 'rule',
                          operand: 'equals',
                          value: 'Clos',
                          name: 'etat',
                          selectedfti: 'kis_anc_dossier_controle',
                          guid: 'kis_anc_dossier_controle_etat',
                          relation_DOSSIER_CONTROLE_choosen:
                            'kis_anc_dossier_controle',
                        },
                      ],
                      relation_DOSSIER_CONTROLE_choosen:
                        'kis_anc_dossier_controle',
                      selectedfti: 'kis_anc_dossier_controle',
                    },
                  ],
                  selectGlobaladvancedFti: 'Dossier ANC',
                  selectedfti: 'kis_anc_dossier',
                },
              ],
            },
          },
          {
            label: '9. Identification des puits et forages privés',
            labelClass:"elasticPink",
            queryName:'queryPrivateShaftAndDrilling',
            description:
              'Présence d’un captage d’eau sur le terrain et qui est destiné'
              + ' à la consommation humaine détectée lors du dernier contrôle validé',
            data: {
              relations: [
                {
                  filters: [
                    {
                      attr: {},
                      choice: 'relation',
                      choicesdone: 'Contient',
                      choices: ['Contient'],
                      controle_json_filters: {
                        rule: 'common',
                        types: {
                          FO1: { selected: true },
                        },
                      },
                      filters: [
                        {
                          disabled: true,
                          choice: 'rule',
                          operand: 'equals',
                          value: 'Clos',
                          name: 'etat',
                          selectedfti: 'kis_anc_dossier_controle',
                          guid: 'kis_anc_dossier_controle_etat',
                          relation_DOSSIER_CONTROLE_choosen:
                            'kis_anc_dossier_controle',
                        },
                        {
                          disabled: true,
                          choice: 'rule',
                          operand: 'equals',
                          value: 'Oui',
                          name: 'caracteristiques_terrain.captage',
                          selectedfti: 'kis_anc_dossier_controle',
                          guid:
                            'kis_anc_dossier_controle_caracteristiques_terrain_captage',
                          relation_DOSSIER_CONTROLE_choosen:
                            'kis_anc_dossier_controle',
                        },
                        {
                          disabled: true,
                          choice: 'rule',
                          operand: 'equals',
                          value: 'Oui',
                          name: 'caracteristiques_terrain.consomhumaine',
                          selectedfti: 'kis_anc_dossier_controle',
                          guid:
                            'kis_anc_dossier_controle_caracteristiques_terrain_consomhumaine',
                          relation_DOSSIER_CONTROLE_choosen:
                            'kis_anc_dossier_controle',
                        },
                      ],
                      relation_DOSSIER_CONTROLE_choosen:
                        'kis_anc_dossier_controle',
                      selectedfti: 'kis_anc_dossier_controle',
                    },
                  ],
                  selectGlobaladvancedFti: 'Dossier ANC',
                  selectedfti: 'kis_anc_dossier',
                },
              ],
            },
          },
          {
            label: '10. Habitations sans aucune installation',
            labelClass:"elasticPink",
            queryName:'queryWithoutInstallations',
            description:
              'Liste des habitations “sans installation (prétraitement,'
              + ' traitement, filière agréee), identifiées à partir du'
              + ' dernier contrôle validé en excluant les dossiers pour'
              + ' esquels le dernier contrôle validé est un contrôle de'
              + ' réalisation et qui au préalable n’ont pas eu de contrôle'
              + ' de type diagnostic, périodique ou vente (exclusion des'
              + ' dossiers placés en archive, classés sans suite ou raccordés)',
            data: {
              relations: [
                {
                  filters: [
                    {
                      attr: {},
                      choice: 'relation',
                      choicesdone: 'Contient',
                      choices: ['Contient'],
                      controle_json_filters: {
                        rule: 'common',
                        types: {
                          FO1: { selected: true },
                        },
                      },
                      filters: [
                        {
                          disabled: true,
                          choice: 'rule',
                          operand: 'equals',
                          value: 'Clos',
                          name: 'etat',
                          selectedfti: 'kis_anc_dossier_controle',
                          guid: 'kis_anc_dossier_controle_etat',
                          relation_DOSSIER_CONTROLE_choosen:
                            'kis_anc_dossier_controle',
                        },
                      ],
                      relation_DOSSIER_CONTROLE_choosen:
                        'kis_anc_dossier_controle',
                      selectedfti: 'kis_anc_dossier_controle',
                    },
                  ],
                  selectGlobaladvancedFti: 'Dossier ANC',
                  selectedfti: 'kis_anc_dossier',
                },
              ],
            },
          },
        ];

        getResolvedCustomRequests(customRequests).then(requests => {
          console.log('requests', angular.copy(requests));
          scope.customRequests = requests;
        });

        scope.setResultatElastic = (event, data) => {
          if (!event.data) {
            return;
          }

          const customQuery = {
            queryName: event.queryName,
            definedParameters: getCustomQueryFromFilters(
              event.data.relations[0].filters
            ),
          };
          gaDomUtils.showGlobalLoader();
          QueryFactory.executeAdvancedFilters(customQuery, defaultDb)
            .then(result => {
              require('toastr').success(
                $filter('translate')('elastic.search.search_success')
              );
              gaDomUtils.hideGlobalLoader();
              if (result.data.totalFeatures === '0') {
                AlertHpoFactory.getSimpleSuccess(
                  $filter('translate')('executQueryManager.alert.warning'),
                  $filter('translate')('executQueryManager.alert.vide'),
                  true,
                  'warning'
                );
                return;
              }
              result.data.featureTypeInfo.name = 'kis_anc_custom_query';
              result.data.featureTypeInfo.label = event.label;
              const dateAttributes = getDateAttributes(
                result.data.featureTypeInfo
              );
              result.data.features = result.data.features
                .filter(feature => feature)
                .map(feature => {
                  feature.id = feature.properties['reference_id_controle'];
                  feature.properties.ref_dossier = feature.properties[
                    'kis_anc_dossier.fid'
                  ]
                    ? `kis_anc_dossier.${feature.properties['kis_anc_dossier.fid']}`
                    : '';
                  feature.hideActionButtons = !feature.properties.ref_dossier;
                  if (dateAttributes.length > 0) {
                    Object.keys(feature.properties).forEach(property => {
                      if (dateAttributes.indexOf(property) !== -1) {
                        feature.properties[property] = $filter('date')(
                          feature.properties[property],
                          'dd/MM/yyyy HH:mm'
                        );
                      }
                    });
                  }
                  return feature;
                });
              $rootScope.$broadcast(
                'resultelastic',
                result.data,
                result.data.featureTypeInfo.name,
                event.data.relations[0]
              );
            })
            .catch(() => {
              require('toastr').error(
                $filter('translate')('elastic.search.search_failed')
              );
              gaDomUtils.hideGlobalLoader();
            });
        };

        function resolveFilter(request, filter) {
          const defer = $q.defer();
          filter.selectedfti =
            typeof filter.selectedfti === 'string'
              ? getFeatureFti(filter.selectedfti)
              : filter.selectedfti;
          if (filter.relation_DOSSIER_CONTROLE_choosen) {
            filter.relation_DOSSIER_CONTROLE_choosen = getFeatureFti(
              filter.relation_DOSSIER_CONTROLE_choosen
            );
          }
          filter.alias = filter.selectedfti.alias;
          filter.attributesaliases = [filter.alias];
          if (
            filter.selectedfti.name === 'kis_anc_dossier_controle' &&
            filter.controle_json_filters &&
            filter.controle_json_filters.types &&
            Object.keys(filter.controle_json_filters.types).filter(
              key => filter.controle_json_filters.types[key].selected
            ).length
          ) {
            getFakeControlAttributesFeatureFti(
              filter.controle_json_filters.types
            ).then(result => {
              filter.selectedfti.attributes = filter.selectedfti.attributes
                .map(attribute =>
                  Object.assign(attribute, {
                    category: 'Metadonees',
                    prefixedAlias: attribute.alias,
                  })
                )
                .concat(result);
              filter.filters = (filter.filters || []).map(
                filterFiltersFilter => {
                  filterFiltersFilter.selectedfti = angular.copy(
                    filter.selectedfti
                  );
                  return filterFiltersFilter;
                }
              );
              defer.resolve(filter);
            });
          } else {
            defer.resolve(filter);
          }
          const promise = defer.promise;
          promise.then(resolvedFilter => {
            if (resolvedFilter.choice !== 'relation') {
              if (resolvedFilter.name) {
                const attribute = getFeatureAttribute(
                  resolvedFilter.selectedfti,
                  resolvedFilter.name
                );
                const attributeValue =
                  resolvedFilter.selectedfti.name !== 'kis_anc_dossier_controle'
                    ? attribute.alias
                    : attribute;
                resolvedFilter = Object.assign(resolvedFilter, {
                  attr: attributeValue,
                  att: attributeValue,
                  type: attribute.type,
                  alias: attribute.alias,
                });
                resolvedFilter.selectedfti.attributes = [attribute];
                resolvedFilter.attributesaliases = [attributeValue];
              }
              if (resolvedFilter.guid) {
                request.fieldsConfiguration = Object.assign(
                  {},
                  request.fieldsConfiguration,
                  { [resolvedFilter.guid]: { visible: true } }
                );
              }
              defer.resolve(resolvedFilter);
            } else {
              let childFiltersPromises = resolvedFilter.filters.map(
                filterFiltersFilter =>
                  resolveFilter(request, filterFiltersFilter)
              );
              return $q.all(childFiltersPromises).then(filters => {
                resolvedFilter.filters = filters;
                resolvedFilter.selectGlobaladvancedFti =
                  resolvedFilter.selectedfti.alias;
                defer.resolve(resolvedFilter);
              });
            }
          });
          return defer.promise;
        }

        function getFeatureFti(ftiName) {
          return angular.copy(
            FeatureTypeFactory.getFeatureByNameAndDatastore(
              AncAppFactory.appCfg.main.datastore,
              ftiName
            )
          );
        }

        function getFakeControlAttributesFeatureFti(controles) {
          let promises = [];
          Object.keys(controles)
            .filter(controlName => controles[controlName].selected)
            .forEach(controlName => {
              if (controles[controlName].selected) {
                promises.push(
                  AncAppFactory.getBuildedFakeCtrlReponseFtiForElasticSearch(
                    controlName
                  )
                );
              }
            });
          return $q.all(promises).then(fakeCtrlFtis => {
            const intersectedAttributes = {};
            const attrs = {};
            fakeCtrlFtis.forEach((control, index) => {
              (control.attributes || []).forEach(attribute => {
                attribute.isCtrJsonAttribute = true;
                intersectedAttributes[attribute.name] =
                  intersectedAttributes[attribute.name] || [];
                if (
                  intersectedAttributes[attribute.name].indexOf(index) === -1
                ) {
                  intersectedAttributes[attribute.name].push(index);
                  attrs[attribute.name] = attribute;
                }
              });
            });
            return Object.keys(attrs)
              .filter(
                attr =>
                  intersectedAttributes[attr].length === fakeCtrlFtis.length
              )
              .map(attr => attrs[attr]);
          });
        }

        function resolveRelations(request) {
          const promises = [];
          request.data.relations.forEach(relation => {
            const defer = $q.defer();
            relation.selectedfti = getFeatureFti(relation.selectedfti);
            relation.selectGlobaladvancedFti = relation.selectedfti.alias;
            if (relation.relation_DOSSIER_CONTROLE_choosen) {
              relation.relation_DOSSIER_CONTROLE_choosen = getFeatureFti(
                relation.relation_DOSSIER_CONTROLE_choosen
              );
            }
            $q.all(
              (relation.filters || []).map(filter =>
                resolveFilter(request, filter)
              )
            ).then(filters => {
              relation.filters = filters;
              defer.resolve(relation);
            });
            promises.push(defer.promise);
          });
          return $q.all(promises);
        }

        function getFeatureAttribute(fti, attributeName) {
          return (
            fti.attributes.find(
              attribute => attribute.name === attributeName
            ) || { name: attributeName, type: '' }
          ); // Fallback for when the attribute doesn't exist on selectedfti
        }

        function getDateAttributes(fti) {
          const dateAttributesTypes = [
            'java.sql.Timestamp',
            'java.lang.Timestamp',
            'java.sql.Date',
            'java.lang.Date',
            'java.util.Date',
          ];
          return fti.attributes
            .filter(
              attribute => dateAttributesTypes.indexOf(attribute.type) !== -1
            )
            .map(attribute => attribute.name);
        }

        function getCustomQueryFromFilters(filters) {
          return filters
            .filter(filter => !filter.disabled)
            .reduce((accumulator, filter) => {
              if (filter.choice === 'rule') {
                const tableName = filter.att.isCtrJsonAttribute
                  ? filter.selectedfti.name + '_reponse'
                  : filter.selectedfti.name;
                accumulator.push({
                  expression: !filter.att.isCtrJsonAttribute
                    ? `${tableName}.${filter.name}`
                    : filter.name,
                  operande: {
                    key: filter.operand,
                    label: filter.operand,
                  },
                  attribut: filter.name,
                  table: tableName,
                  valeur: {
                    [filter.name]: filter.value,
                  },
                });
              } else {
                accumulator = accumulator.concat(
                  getCustomQueryFromFilters(filter.filters)
                );
              }
              return accumulator;
            }, [])
            .map((filter, index) =>
              Object.assign(filter, { id: `$${index + 1}` })
            );
        }
        function getResolvedCustomRequests(requests) {
          const promises = [];
          requests.forEach(request => {
            const defer = $q.defer();
            resolveRelations(request).then(relations => {
              request.data.relations = relations;
              request.resolved = true;
              defer.resolve(request);
            });
            promises.push(defer.promise);
          });
          return $q.all(promises);
        }
      },
    };
  };
  ancCustomDossierRequetes.$inject = [
    '$rootScope',
    '$filter',
    '$q',
    'FeatureTypeFactory',
    'AncAppFactory',
    'QueryFactory',
    'gaDomUtils',
    'AlertHpoFactory',
  ];
  return ancCustomDossierRequetes;
});
