'use strict';
define(function() {
  var ancFacturationDolibarr = function(
    BacAppFactory,
    AncAppFactory,
    gaDomUtils,
    $rootScope,
    dolibarrFactory,
    $q,
    $window,
    gaJsUtils
  ) {
    return {
      templateUrl:
        'js/XG/widgets/ancapp/main/views/directives/anc_facturation_dolibarr.html',
      restrict: 'EA',
      scope: {
        apptype: '=?',
      },
      link: function(scope, elt, attrs, ctrl) {
        scope.xgos = $rootScope.xgos;
        var CurrentAppFactory =
          scope.apptype == 'bac' ? BacAppFactory : AncAppFactory;

        var loadConfig = function() {
          scope.periodesCfg = angular.copy(
            CurrentAppFactory.appCfg.main.periodesCfg
          );

          // get data
          scope.dolibarrCfg = dolibarrFactory.cfg;

          // retrieve the dolibarr data
          if (
            angular.isDefined(CurrentAppFactory.appCfg.main.properties.dolibarr)
          ) {
            scope.dolibarrParams = angular.copy(
              CurrentAppFactory.appCfg.main.properties.dolibarr
            );
            dolibarrFactory.setDolibarrConnectionCfg(scope.dolibarrParams);
            dolibarrFactory.setDolibarrConnection(1).then(function(res) {
              console.log(res);
              console.log(dolibarrFactory.cfg);
            });
          }
        };

        scope.$on('checkIfDirtyFacturationCfg', function() {
          scope.saveDolibarCfg(true);
        });

        loadConfig();

        /**
         * saveDolibarCfg
         */
        scope.saveDolibarCfg = function(checkDirty) {
          if (angular.isDefined(checkDirty) && checkDirty) {
            if (
              !angular.equals(
                scope.periodesCfg,
                CurrentAppFactory.appCfg.main.periodesCfg
              ) ||
              !angular.equals(
                scope.dolibarrParams,
                CurrentAppFactory.appCfg.main.properties.dolibarr
              )
            )
              var ans = confirm(
                'Des données ne sont pas sauvegardées. Voulez-vous les enregistrer ?'
              );
          }
          if (angular.isUndefined(checkDirty) || (checkDirty && ans)) {
            gaDomUtils.showGlobalLoader();
            CurrentAppFactory.appCfg.main.periodesCfg = scope.periodesCfg;
            CurrentAppFactory.appCfg.main.properties.dolibarr =
              scope.dolibarrCfg.params;
            CurrentAppFactory.updateAppCfg().then(
              function() {
                dolibarrFactory.setDolibarrConnection();
              },
              function() {
                require('toastr').error(
                  "Erreur lors de l'enregistrement des parametres dolibarr"
                );
                gaDomUtils.hideGlobalLoader();
              }
            );
          } else if (checkDirty && !ans) {
            loadConfig();
          }
        };

        /**
         * getDolibarrServices
         */
        scope.getDolibarrServices = function(x) {
          dolibarrFactory.getServices().then(function(res) {
            scope.dolibarrServices = res.data;
          });
        };

        gaDomUtils.hideGlobalLoader();

        // ***************************************
        // ELEMENTS DE FACTURATION
        // ***************************************
        var fakePromise = function() {
          var deferred = $q.defer();
          deferred.resolve({
            data: gaJsUtils.guid(),
          });
          return deferred.promise;
        };
        // add element et crud dolibarr, sauvegarde auto dans la config
        scope.crudElement = function(element, id, dialog) {
          var service = {
            label: element.description ? element.description : element.nom,
            ref: element.nom,
            status: 1,
            status_buy: 0,
            finished: 0,
            price: element.prix,
            price_base_type: 'HT',
            tva_tx: element.tva,
            note: '',
            note_private: '',
          };

          if (id == -1) {
            // @INTERFACE JVS Multifac Omega
            var promise = CurrentAppFactory.appCfg.main.properties.dolibarr
              .facturationTierce.active
              ? fakePromise()
              : dolibarrFactory.addService(service);

            promise.then(
              function(res) {
                element.dolibarrId = res.data.replace(/"/g, '');
                scope.periodesCfg.tarification.push(element);

                CurrentAppFactory.appCfg.main.periodesCfg.tarification =
                  scope.periodesCfg.tarification;
                CurrentAppFactory.updateAppCfg();

                if (
                  !CurrentAppFactory.appCfg.main.properties.dolibarr
                    .facturationTierce.active
                )
                  scope.getDolibarrServices();
                dialog.close();
              },
              function() {
                require('toastr').error(
                  'Erreur lors de la création du service dans le module de facturation.'
                );
                gaDomUtils.hideGlobalLoader();
              }
            );
          } else if (angular.isDefined(element.dolibarrId)) {
            // @INTERFACE JVS Multifac Omega
            var promise = CurrentAppFactory.appCfg.main.properties.dolibarr
              .facturationTierce.active
              ? fakePromise()
              : dolibarrFactory.updateService(service, element.dolibarrId);

            promise.then(
              function(res) {
                scope.periodesCfg.tarification[id] = element;

                CurrentAppFactory.appCfg.main.periodesCfg.tarification =
                  scope.periodesCfg.tarification;
                CurrentAppFactory.updateAppCfg();
                dialog.close();

                if (
                  !CurrentAppFactory.appCfg.main.properties.dolibarr
                    .facturationTierce.active
                )
                  scope.getDolibarrServices();
              },
              function() {
                require('toastr').error(
                  'Erreur lors de la création du service dans le module de facturation.'
                );
                gaDomUtils.hideGlobalLoader();
              }
            );
          } else {
            require('toastr').error(
              "Cet élément de facturation n'est pas lié au système de facturation paramétré pour ce portail."
            );
            gaDomUtils.hideGlobalLoader();
          }
        };

        scope.filtreParPeriode = {};
        // par defaut la periode la plus recente
        if (scope.periodesCfg.periodes.length) {
          scope.filtreParPeriode.key = scope.periodesCfg.periodes.reduce(
            function(max, p) {
              return p.key > max ? p.key : max;
            },
            0
          );
        }

        /**
         * saveFacturationPeriodeCfg
         */
        scope.saveFacturationPeriodeCfg = function() {
          CurrentAppFactory.appCfg.main.periodesCfg = scope.periodesCfg;
          CurrentAppFactory.updateAppCfg().then(function() {});
        };

        /**
         * retourFactuClassique
         */
        scope.retourFactuClassique = function() {
          var ans = confirm(
            'Êtes-vous sur de vouloir basculer en mode de facturation simple ?'
          );
          if (ans) {
            CurrentAppFactory.appCfg.main.properties.dolibarr.active = false;
            CurrentAppFactory.updateAppCfg().then(function() {
              $window.location.reload();
            });
          }
        };
      },
    };
  };

  ancFacturationDolibarr.$inject = [
    'BacAppFactory',
    'AncAppFactory',
    'gaDomUtils',
    '$rootScope',
    'dolibarrFactory',
    '$q',
    '$window',
    'gaJsUtils',
  ];
  return ancFacturationDolibarr;
});
