'use strict';
define(function() {
  var ancBacCaracteristiquesEtablissement = function(
    BacAppFactory,
    FeatureTypeFactory,
    $rootScope,
    gaDomUtils
  ) {
    return {
      templateUrl:
        'js/XG/widgets/ancapp/main/views/anc_bac/anc_bac_caracteristiques_etablissement.html',
      restrict: 'EA',
      scope: {
        dossier: '=',
        mode: '=',
      },
      link: function(scope) {
        /*******************************************************************************
         *    Ftis
         * ********************************************************************************/
        scope.activitePrincipaleEtablissementFti = FeatureTypeFactory.getFeatureByNameAndDatastore(
          BacAppFactory.appCfg.main.datastore,
          'kis_bac_etablissement_activite_principale'
        );

        scope.kisBacListesDeroulantesControleFti = FeatureTypeFactory.getFeatureByUid(
          'kis_bac_listes_deroulantes_controles'
        );

        scope.etablissementFti = FeatureTypeFactory.getFeatureByNameAndDatastore(
          BacAppFactory.appCfg.main.datastore,
          'kis_bac_etablissement'
        );
        /*******************************************************************************
          Refresh data des Tables des Activtes et ICPE lors de mise à jour des dossiers 
        ********************************************************************************/
        scope.existCCIControle = false;
        $rootScope.$on('existCCIControleEvent', function(event, data) {
          /**
           * existCCIControle
           */
          scope.existCCIControle = true;
          /**
           * Refresh ActivitePrincipale Data
           */
          scope.getActivitePrincipale();

          /**
           * Refresh ActiviteSecondaire Data
           */
          scope.getActiviteSecondaires();
          if (
            angular.isUndefined(scope.dossier.properties['activite_secondaire'])
          ) {
            scope.initialisationTable('activite_secondaire');
          }
          /**
           * Refresh ICPE Data
           */
          scope.getClassementIcpe();
          if (angular.isUndefined(scope.dossier.properties['details_icpe'])) {
            scope.initialisationTable('details_icpe');
          }
        });
        /***************************************************
          Gestions de  Tableau des activtés secondaires
        ****************************************************/
        /**
         *Initialisation des tableaux
         */
        scope.initialisationTable = function(type) {
          if (angular.isUndefined(scope.dossier.properties[type])) {
            scope.dossier.properties[type] = [];
            scope.addLinesTable(1, type);
          }
        };
        /**
         * ajouter des lignes au tableau
         */
        scope.addLinesTable = function(number, type) {
          for (var i = 0; i < number; i++) {
            if (type == 'activite_secondaire') {
              if (scope.dossier.properties[type] === undefined)
                scope.dossier.properties[type] = {};
              scope.dossier.properties[type].push({
                batiment_activite: '',
                nature_activite: null,
                commentaires: '',
                id_etablissement: '',
              });
            }
            if (type == 'details_icpe') {
              if (scope.dossier.properties[type] === undefined)
                scope.dossier.properties[type] = {};
              scope.dossier.properties[type].push({
                numero_icpe: '',
                intitule_icpe: '',
                seuil_icpe: '',
                regime_icpe: null,
                document_icpe: '',
                commentaires: '',
              });
            }
          }
        };
        /**
         * supression des lignes de tableau
         */
        scope.deleteLineTable = function(index, type) {
          var tmpArr = [];
          scope.dossier.properties[type].forEach(function(l, i) {
            if (index != i) {
              tmpArr.push(scope.dossier.properties[type][i]);
            }
          });
          scope.dossier.properties[type] = tmpArr;
        };
        /**
         * reset de tableau
         */
        scope.resetTable = function(type) {
          let nomtableau = '';
          switch (type) {
            case 'activite_secondaire':
              nomtableau = 'des activités secondaires';
              break;
            case 'details_icpe':
              nomtableau = 'des détails du classement ICPE';
              break;
          }
          var ans = confirm(
            'Êtes-vous certain de vouloir réinitialiser le tableau ' +
              nomtableau +
              ' ?'
          );

          if (ans) {
            scope.dossier.properties[type] = [];
            scope.addLinesTable(1, type);
          }
        };
        /***************************************************
          Gestions des activtés principales
        ****************************************************/
        scope.saveActivitePrincipale = function() {
          let typeActivte = 'kis_bac_etablissement_activite_principale';
          let activitePrincipaleProperties = {};
          if (
            scope.dossier &&
            scope.dossier.properties &&
            scope.dossier.properties.activite_principale &&
            scope.dossier.properties.etablissement &&
            scope.dossier.properties.etablissement.id
          ) {
            activitePrincipaleProperties =
              scope.dossier.properties.activite_principale;
            var featureCollection = {
              type: 'FeatureCollection',
              features: [],
            };
            activitePrincipaleProperties.id_etablissement =
              scope.dossier.properties.etablissement.id;
            featureCollection.features.push({
              type: 'Feature',
              properties: activitePrincipaleProperties,
            });
            // Action en cours
            gaDomUtils.showGlobalLoader();
            BacAppFactory.saveActivitePrincipaleOrSecondaire(
              BacAppFactory.appCfg.appname,
              scope.dossier.properties.etablissement.id,
              typeActivte,
              featureCollection
            ).then(
              function(res) {
                if (res && res.data) {
                  require('toastr').success('Activite Principale enregistrée');
                }
                gaDomUtils.hideGlobalLoader();
              },
              function(res) {
                gaDomUtils.hideGlobalLoader();
                require('toastr').error(res.data);
              }
            );
          }
        };

        /**
         * Récuépration Activité Principale
         */
        scope.getActivitePrincipale = function() {
          let typeActivte = 'kis_bac_etablissement_activite_principale';
          if (
            scope.dossier &&
            scope.dossier.properties &&
            scope.dossier.properties.etablissement &&
            scope.dossier.properties.etablissement.id
          ) {
            BacAppFactory.getActivitePrincipaleOrActiviteSecondaires(
              BacAppFactory.appCfg.appname,
              scope.dossier.properties.etablissement.id,
              typeActivte
            ).then(
              function(res) {
                if (
                  res &&
                  res.data &&
                  res.data.features[0] &&
                  res.data.features[0].properties
                ) {
                  scope.dossier.properties.activite_principale =
                    res.data.features[0].properties;
                }
              },
              function(res) {
                require('toastr').error(res.data);
              }
            );
          }
        };
        scope.getActivitePrincipale();

        /**
         * Delete Activité Principale
         */
        scope.deleteActivitePrincipale = function() {
          let typeActivte = 'kis_bac_etablissement_activite_principale';
          if (
            scope.dossier &&
            scope.dossier.properties &&
            scope.dossier.properties.activite_principale &&
            scope.dossier.properties.etablissement &&
            scope.dossier.properties.etablissement.id
          ) {
            // Action en cours
            gaDomUtils.showGlobalLoader();
            BacAppFactory.deleteActivitePrincipaleOrSecondaire(
              BacAppFactory.appCfg.appname,
              scope.dossier.properties.etablissement.id,
              typeActivte
            ).then(
              function(res) {
                if (res && res.data) {
                  gaDomUtils.hideGlobalLoader();
                  require('toastr').success('Activite Principale supprimée');
                }
              },
              function(res) {
                gaDomUtils.hideGlobalLoader();
                require('toastr').error(res.data);
              }
            );
          }
        };
        /***************************************************
          Gestions des activtés secondaires
        ****************************************************/
        scope.saveActiviteSecondaires = function(type) {
          let typeActivte = 'kis_bac_etablissement_activite_secondaire';
          if (
            scope.dossier &&
            scope.dossier.properties &&
            scope.dossier.properties.activite_secondaire &&
            scope.dossier.properties.etablissement &&
            scope.dossier.properties.etablissement.id
          ) {
            var featureCollection = {
              type: 'FeatureCollection',
              features: [],
            };
            /**
             * Construction les données des activités secondaires
             */
            scope.dossier.properties.activite_secondaire.forEach(element => {
              let activitePrincipaleSecondairePttes = {};
              activitePrincipaleSecondairePttes = element;
              activitePrincipaleSecondairePttes.id_etablissement =
                scope.dossier.properties.etablissement.id;
              if (
                activitePrincipaleSecondairePttes.nature_activite_secondaire
              ) {
                activitePrincipaleSecondairePttes.nature_activite = angular.copy(
                  activitePrincipaleSecondairePttes.nature_activite_secondaire
                );
                delete activitePrincipaleSecondairePttes.nature_activite_secondaire;
              }
              featureCollection.features.push({
                type: 'Feature',
                properties: activitePrincipaleSecondairePttes,
              });
            });
            gaDomUtils.showGlobalLoader();
            BacAppFactory.saveActivitePrincipaleOrSecondaire(
              BacAppFactory.appCfg.appname,
              scope.dossier.properties.etablissement.id,
              typeActivte,
              featureCollection
            ).then(
              function(res) {
                if (res && res.data) {
                  require('toastr').success('Activite Secondaires enregistrée');
                  gaDomUtils.hideGlobalLoader();
                }
              },
              function(res) {
                require('toastr').error(res.data);
                gaDomUtils.hideGlobalLoader();
              }
            );
          }
        };
        scope.getActiviteSecondaires = function() {
          let typeActivte = 'kis_bac_etablissement_activite_secondaire';
          if (
            scope.dossier &&
            scope.dossier.properties &&
            scope.dossier.properties.etablissement &&
            scope.dossier.properties.etablissement.id
          ) {
            BacAppFactory.getActivitePrincipaleOrActiviteSecondaires(
              BacAppFactory.appCfg.appname,
              scope.dossier.properties.etablissement.id,
              typeActivte
            ).then(
              function(res) {
                if (res && res.data) {
                  if (
                    res.data.features &&
                    Array.isArray(res.data.features) &&
                    res.data.features.length > 0
                  ) {
                    scope.dossier.properties.activite_secondaire = [];
                    res.data.features.forEach(element => {
                      scope.dossier.properties.activite_secondaire.push(
                        element.properties
                      );
                    });
                  } else if (res.data.features.length == 0) {
                    scope.initialisationTable('activite_secondaire');
                  }
                }
              },
              function(res) {
                require('toastr').error(res.data);
              }
            );
          }
        };
        scope.getActiviteSecondaires();
        /***************************************************
          Gestions de Classement ICPE
        ****************************************************/
        scope.saveDetailsICPE = function(type) {
          if (
            scope.dossier &&
            scope.dossier.properties &&
            scope.dossier.properties.details_icpe &&
            scope.dossier.properties.etablissement &&
            scope.dossier.properties.etablissement.id
          ) {
            var featureCollection = {
              type: 'FeatureCollection',
              features: [],
            };
            /**
             * Construction les données des Classements Icpe
             */
            scope.dossier.properties.details_icpe.forEach(element => {
              let detailsIcpePttes = {};
              detailsIcpePttes = element;
              detailsIcpePttes.id_etablissement =
                scope.dossier.properties.etablissement.id;
              featureCollection.features.push({
                type: 'Feature',
                properties: detailsIcpePttes,
              });
            });
            gaDomUtils.showGlobalLoader();
            BacAppFactory.saveClassementIcpe(
              BacAppFactory.appCfg.appname,
              scope.dossier.properties.etablissement.id,
              featureCollection
            ).then(
              function(res) {
                if (res && res.data) {
                  require('toastr').success('Classement Icpe enregistrée');
                  gaDomUtils.hideGlobalLoader();
                }
              },
              function(res) {
                require('toastr').error(res.data);
                gaDomUtils.hideGlobalLoader();
              }
            );
          }
        };
        scope.getClassementIcpe = function() {
          if (
            scope.dossier &&
            scope.dossier.properties &&
            scope.dossier.properties.etablissement &&
            scope.dossier.properties.etablissement.id
          ) {
            BacAppFactory.getClassementIcpe(
              BacAppFactory.appCfg.appname,
              scope.dossier.properties.etablissement.id
            ).then(
              function(res) {
                if (res && res.data) {
                  if (
                    res.data.features &&
                    Array.isArray(res.data.features) &&
                    res.data.features.length > 0
                  ) {
                    scope.dossier.properties.details_icpe = [];
                    res.data.features.forEach(element => {
                      scope.dossier.properties.details_icpe.push(
                        element.properties
                      );
                    });
                    scope.dossier.properties.installation_environnement_icpe =
                      '1';
                  } else if (res.data.features.length == 0) {
                    scope.initialisationTable('details_icpe');
                  }
                }
              },
              function(res) {
                require('toastr').error(res.data);
              }
            );
          }
        };
        scope.getClassementIcpe();
      },
    };
  };
  ancBacCaracteristiquesEtablissement.$inject = [
    'BacAppFactory',
    'FeatureTypeFactory',
    '$rootScope',
    'gaDomUtils',
  ];
  return ancBacCaracteristiquesEtablissement;
});
