'use strict';

define(function() {
  var FO4Ctrl = function($scope, FeatureTypeFactory, $timeout, $rootScope) {
    $scope.kis_anc_listes_deroulantes_controles = FeatureTypeFactory.getFeatureByUid(
      'kis_anc_listes_deroulantes_controles'
    );

    $scope.setGrilleConformite = init => {
      if (
        angular.isDefined($scope.cdata.grille) &&
        Object.keys($scope.cdata.grille).length > 0
      ) {
        Object.keys($scope.cdata.grille).forEach(function(attr) {
          if (
            isObject($scope.cdata.grille[attr]) &&
            Object.keys($scope.cdata.grille[attr]).length > 0
          )
            Object.keys($scope.cdata.grille[attr]).forEach(function(attr2) {
              if ($scope.cdata.grille[attr][attr2] != null)
                $scope.checkConformite(attr + '.' + attr2);
              return;
            });
        });
      }

      if (init) {
        if (!$scope.cdata.grille) {
          $scope.cdata.grille = {
            conc: {},
          };
        }
        if (
          $scope.currentReport.properties.enjeusan !== undefined &&
          $scope.cdata.grille.conc.enjeusan === undefined
        ) {
          $scope.cdata.grille.conc.enjeusan =
            "'" + parseInt($scope.currentReport.properties.enjeusan, 10) + "'";
        }
        if (
          $scope.currentReport.properties.enjeuenv !== undefined &&
          $scope.cdata.grille.conc.enjeuenv === undefined
        ) {
          $scope.cdata.grille.conc.enjeuenv =
            "'" + parseInt($scope.currentReport.properties.enjeuenv, 10) + "'";
        }
        $rootScope.$broadcast(
          'updateCleanData',
          $scope.cdata.grille,
          'checkDiffCdata.grille'
        );
      }
    };

    const isObject = value => {
      return value && typeof value === 'object';
    };

    $scope.checkConformite = function(value) {
      $timeout(function() {
        const firstKey = value.split('.')[0];
        const secondKey = value.split('.')[1];
        if (
          firstKey === 'installation' &&
          secondKey === 'present' &&
          $scope.cdata.grille[firstKey][secondKey] === '1'
        ) {
          $scope.cdata.grille[firstKey].absent = '0';
        } else if (
          firstKey === 'installation' &&
          secondKey === 'absent' &&
          $scope.cdata.grille[firstKey][secondKey] === '1'
        ) {
          $scope.cdata.grille[firstKey].present = '0';
        }

        if (
          secondKey === 'aucun_defaut' &&
          $scope.cdata.grille[firstKey][secondKey] === '1'
        ) {
          // conservation of commentaire
          let newObj = {};
          if (angular.isDefined($scope.cdata.grille[firstKey].commentaire))
            newObj.commentaire = $scope.cdata.grille[firstKey].commentaire;

          $scope.cdata.grille[firstKey] = newObj;
          $scope.cdata.grille[firstKey][secondKey] = '1';
          $scope.cdata.grille[firstKey].show_article = 0;
        } else {
          if (
            angular.isUndefined($scope.cdata.grille[firstKey].aucun_defaut) ||
            $scope.cdata.grille[firstKey].aucun_defaut == null
          )
            $scope.cdata.grille[firstKey].aucun_defaut = '0';
          const propKeys = Object.keys($scope.cdata.grille[firstKey]).filter(
            function(item) {
              return (
                $scope.cdata.grille[firstKey][item] === '1' &&
                item !== 'aucun_defaut' &&
                item !== 'show_article' &&
                item !== 'present'
              );
            }
          );
          if (propKeys.length) {
            $scope.cdata.grille[firstKey].show_article = 1;
          } else {
            $scope.cdata.grille[firstKey].show_article = 0;
          }
        }

        testIsConforme();
      }, 0);
    };

    const testIsConforme = () => {
      if (angular.isDefined($scope.showConforme)) delete $scope.showConforme;

      // Ajout du showArticle s'il est manquant,
      // permettant l'affichage de la non conformité du contrôle
      for(const category in scope.cdata.grille) {
        // Si on est dans un des cas pouvant entrainer la non conformité du controle
        if(isObject(scope.cdata.grille[category]) && category !== 'conc') {
          for (const checkBox in scope.cdata.grille[category]) {
            if(checkBox !== 'aucun_defaut' && checkBox !== 'present' && scope.cdata.grille[category][checkBox] === '1'){
              scope.cdata.grille[category].show_article = 1;
            }
          }
        }
      }

      let hasArticle = Object.keys($scope.cdata.grille).filter(key => {
        return (
          key !== 'entretien_usure' &&
          key !== 'conc' &&
          isObject(scope.cdata.grille[key]) &&
          scope.cdata.grille[key].show_article === 1
        );
      });

      if (
        angular.isDefined($scope.cdata.grille.installation) &&
        $scope.cdata.grille.installation.absent === '1'
      )
        hasArticle.push($scope.cdata.grille.installation.absent);

      let hasAucunDefaut = Object.keys($scope.cdata.grille).filter(defaut => {
        return $scope.cdata.grille[defaut].aucun_defaut === '1';
      });

      if (
        angular.isDefined($scope.cdata.grille.installation) &&
        $scope.cdata.grille.installation.present === '1'
      )
        hasAucunDefaut.push($scope.cdata.grille.installation.present);

      if (hasArticle.length) {
        $scope.showConforme = 'avis_non_conforme';
        $scope.cdata.grille.conclusion = 'Avis non conforme.';
      } else if (!hasArticle.length && hasAucunDefaut.length) {
        $scope.showConforme = 'avis_conforme';
        $scope.cdata.grille.conclusion = 'Avis conforme.';
      } else {
        $scope.showConforme = '';
      }
    };
  };

  FO4Ctrl.$inject = ['$scope', 'FeatureTypeFactory', '$timeout', '$rootScope'];
  return FO4Ctrl;
});
