'use strict';
define(function() {
  var textAutoSize = function($timeout, $interval) {
    return {
      restrict: 'EA',

      link: function(scope, elt, attrs, ctrl) {
        var model = 0;
        function update(size) {
          if (size === 'overflow') {
            elt.css('overflow', 'scroll');
            elt.css('height', 500 + 'px');
          } else {
            elt.css('overflow', 'hidden');
            elt.css('height', 'auto');
            if (size > 0) {
              elt.css('height', size + 'px');
            }
          }
        }

        function checkModel() {
          var needToUpdate = false;
          if (
            model != elt[0].scrollHeight &&
            elt[0].scrollHeight < 500 &&
            elt[0].scrollHeight > 100
          ) {
            model = elt[0].scrollHeight;
            update(model);
            needToUpdate = true;
          } else if (
            model != elt[0].scrollHeight &&
            elt[0].scrollHeight > 500
          ) {
            update('overflow');
          }
          return needToUpdate;
        }

        attrs.$set('ngTrim', 'false');

        var stop;
        scope.clean = function() {
          if (angular.isDefined(stop)) {
            $interval.cancel(stop);
            stop = undefined;
          }
        };

        scope.start = function() {
          $timeout(function() {
            stop = $interval(function() {
              var needToUpdate = checkModel();
              if (!needToUpdate) {
                scope.clean();
              }
            }, 500);
          }, 0);
        };

        scope.start();

        scope.$on('$destroy', function() {
          scope.clean();
        });
      },
    };
  };

  textAutoSize.$inject = ['$interval', '$timeout', '$window'];
  return textAutoSize;
});
