'use strict';

define(function() {
  var CSDICtrl = function(
    $scope,
    AncAppFactory,
    ngDialog,
    FeatureTypeFactory,
    EditFactory,
    UsersFactory,
    $timeout,
    gaJsUtils
  ) {
    $scope.kis_bac_listes_deroulantes_controles = FeatureTypeFactory.getFeatureByUid(
      'kis_bac_listes_deroulantes_controles'
    );

    $scope.resetTab = function(type) {
      var ans = confirm(
        'Êtes-vous certain de vouloir réinitialiser le tableau des produits ?'
      );

      if (ans) {
        $scope.cdata[type] = [];
        // $scope.cdata[type].total = {};
        $scope.addLines(1, type);
      }
    };

    $scope.addLines = function(number, type) {
      if (angular.isUndefined($scope.cdata[type])) {
        $scope.cdata[type] = [];
      }

      for (var i = 0; i < number; i++) {
        $scope.cdata[type].push({
          reference: '',
          equipement: '',
          nombre: null,
          situation: '',
          commentaire: '',
        });
      }
    };

    $scope.initTable = function(type) {
      if (!$scope.cdata[type]) {
        $scope.cdata[type] = [];
      }
      if ($scope.cdata[type].length === 0){
        $scope.addLines(1, type);
      }
    };

    [
      'tableau_produit'
    ].forEach(function(type) {
      $timeout(()=>{
        $scope.initTable(type);
      }, 0);
    });

    $scope.deleteLine = function(index, type) {
      var tmpArr = [];
      $scope.cdata[type].forEach(function(l, i) {
        if (index != i) {
          tmpArr.push($scope.cdata[type][i]);
        }
      });

      $scope.cdata[type] = tmpArr;
    };

    $scope.num_dau = [];
    $scope.getDau = function() {
      console.log($scope.currentControles);
      console.log('getdau');
      $scope.currentControles.forEach(function(ctrl) {
        if (
          ctrl.properties.type === 'DUB' &&
          ctrl.properties.ref_demande_autorisation_urbanisme != null &&
          ctrl.properties.ref_demande_autorisation_urbanisme != ''
        ) {
          $scope.num_dau.push(
            ctrl.properties.ref_demande_autorisation_urbanisme
          );
        }
      });
    };

    $scope.getListePays = function() {
      gaJsUtils.getListePays().then(function(listePays) {
        $scope.listePays = listePays;
      });
    };
    $scope.getListePays();
  };

  CSDICtrl.$inject = [
    '$scope',
    'AncAppFactory',
    'ngDialog',
    'FeatureTypeFactory',
    'EditFactory',
    'UsersFactory',
    '$timeout',
    'gaJsUtils',    
  ];
  return CSDICtrl;
});
