'use strict';
define(function() {
  var countsGroup = function(FeatureTypeFactory, $timeout, extendedNgDialog) {
    return {
      templateUrl:
        'js/XG/widgets/hpoapp/home_admin_data/views/directives/countsGroup.html',
      restrict: 'EA',
      scope: {
        res: '=?',
        countGrp: '=?',
        index: '=',
      },
      link: function(scope) {
        scope.removeCountGrp = function() {
          scope.$emit('removeCountGrp', { index: scope.index });
        };

        scope.$on('refreshCountsGroup', init);

        function copyNumericAttributesOfFti(fti) {
          let ind;
          for (ind = 0; ind < fti.attributes.length; ind++) {
            if (
              fti.attributes[ind].type == 'java.lang.Integer' ||
              fti.attributes[ind].type == 'java.lang.Float' ||
              fti.attributes[ind].type == 'java.lang.Double'
            )
              scope.attributes.push(fti.attributes[ind]);
          }
        }

        function removeNonCommonFieldsFromFti(fti) {
          let i1, i2, found;
          for (i1 = 0; i1 < scope.attributes.length; i1++) {
            found = false;
            for (i2 = 0; i2 < fti.attributes.length; i2++) {
              if (
                scope.attributes[i1] &&
                fti.attributes[i2] &&
                scope.attributes[i1].name == fti.attributes[i2].name &&
                fti.attributes[i2].type == scope.attributes[i1].type
              ) {
                //-- L'attribut est commun aux ftis précédents
                found = true;
                break;
              }
              if (!found) scope.attributes.splice(i1, 1);
            }
          }
        }

        scope.selectIcon = function() {
          scope.selectIconDlg = extendedNgDialog.open({
            template:
              'js/XG/widgets/hpoapp/home_admin_data/views/dialog/selectCountsGroupIcon.html',
            className: 'ngdialog-theme-plain width400 nopadding miniclose',
            scope: scope,
          });
        };

        scope.closeIconSelection = function() {
          scope.selectIconDlg.close();
        };

        scope.iconSelected = function() {
          scope.selectIconDlg.close();
          scope.res.icon = scope.ws.selectedIcon;
        };

        scope.operandChanged = function() {
          if (scope.res.icon == undefined) {
            switch (scope.res.operand) {
              case 'count':
                scope.res.icon = 'img/hpo/count.png';
                break;
              case 'sum':
                scope.res.icon = 'img/hpo/cosumunt.png';
                break;
              case 'sql':
                scope.res.icon = 'img/hpo/LongueurLineaire.png';
                break;
            }
          }
        };

        function setIconList() {
          scope.iconLines = [
            ['img/hpo/sum.png', 'img/hpo/count.png', 'img/hpo/branchement.png'],
            [
              'img/hpo/video-camera.png',
              'img/hpo/LongueurLineaire.png',
              'img/hpo/manhole.png',
            ],
            [
              'img/hpo/calcul.png',
              'img/hpo/calcul1.png',
              'img/hpo/calcul2.png',
            ],
            [
              'img/hpo/defaillance.png',
              'img/hpo/defaillance1.png',
              'img/hpo/defaillancebranchement.png',
            ],
          ];
          scope.ws = {};
          scope.ws.selectedIcon = scope.iconLines[0][0];
        }
        function init(evt, counts) {
          let fti;

          setIconList();
          if (counts != undefined) {
            scope.countGrp = counts.groups[scope.index];
          }
          scope.ftiNames = '';
          scope.attributes = [];
          if (scope.countGrp) {
            for (let ind = 0; ind < scope.countGrp.ftiUids.length; ind++) {
              fti = FeatureTypeFactory.getFeatureByUid(
                scope.countGrp.ftiUids[ind]
              );

              if (ind == 0) copyNumericAttributesOfFti(fti);
              else removeNonCommonFieldsFromFti(fti);

              if (scope.ftiNames.length != 0) scope.ftiNames += ', ';
              scope.ftiNames += fti.alias + ' (' + fti.name + ')';
            }
          }
        }

        init();
      },
    };
  };

  countsGroup.$inject = ['FeatureTypeFactory', '$timeout', 'extendedNgDialog'];
  return countsGroup;
});
