'use strict';
define(function() {
  var ImportHistoriqueHpo = function(
    AlertHpoFactory,
    FeatureTypeFactory,
    HpoCarteAppFactory,
    $window,
    ImportExportFactory,
    ngDialog,
    $q,
    $filter,
    $rootScope,
    $timeout,
    gaUrlUtils,
    ParametersFactory,
    ngTableParams,
    gaDomUtils,
    EditFactory,
    QueryFactory
  ) {
    return {
      templateUrl:
        'js/XG/widgets/hpoapp/home_admin_data/views/directives/import_historique_hpo.html',
      restrict: 'EA',
      link: function(scope, elt, attrs, ctrl) {
        scope.configName = 'HpoImportHistoriqueConfig';

        var fti = HpoCarteAppFactory.getAppFactory().getFeatureTypes(
          'logic'
        )[0];
        // scope.datatableHeight = ($window.innerHeight - 200) + "px";
        scope.historique = {
          ftis: [fti],
          selectedfti: fti,
          attributes: fti.attributes.filter(function(x) {
            if (
              x &&
              ((HpoCarteAppFactory.getAppFactory().getExcludedAttributes(
                fti.name
              ) &&
                HpoCarteAppFactory.getAppFactory()
                  .getExcludedAttributes(fti.name)
                  .indexOf(x.name) === -1) ||
                !HpoCarteAppFactory.getAppFactory().getExcludedAttributes(
                  fti.name
                ))
            )
              return x;
          }),
          clauseWhere: '1=1',
          result: [],
        };

        scope.datatableHeightImport =
          angular.element('.xgos_content').height() - 50 - 70 - 90 + 'px';

        scope.addFeature = function() {
          scope.tabs.activeTab = 0;
        };

        scope.configureObjects = function(sendata) {
          console.log(sendata);
          gaDomUtils.showGlobalLoader();
          sendata = sendata
            .map(function(x) {
              if (!x.properties.CONFIGURER) return x;
            })
            .filter(function(x) {
              if (x) return x;
            });
          ImportExportFactory.getCreatedSchema(sendata).then(
            function(res) {
              if (res && res.data && res.data.length > 0) {
                console.log(res.data);
                scope.hpo.importedFeatures = res.data;
                AlertHpoFactory.getSimpleSuccess(
                  $filter('translate')('hpo.data.exchange.succes'),
                  scope.hpo.importedFeatures
                    .map(function(x) {
                      return gaUrlUtils.tryDecodeURIComponent(
                        x.alias ? x.alias : x.name
                      );
                    })
                    .join(' , ') +
                    ' ' +
                    $filter('translate')(
                      scope.hpo.importedFeatures.length > 1
                        ? 'hpo.data.exchange.importedplusieurs'
                        : 'hpo.data.exchange.imported'
                    ),
                  true
                );
                scope.tabs.activeTab = 2;
                $timeout(function() {
                  $rootScope.$broadcast('changedsourceLayers');
                }, 500);
              }
              gaDomUtils.hideGlobalLoader();
            },
            function(res) {
              AlertHpoFactory.getSimpleFail(
                $filter('translate')('hpo.data.exchange.fail'),
                $filter('translate')('hpo.data.exchange.addsfail'),
                true
              );
              gaDomUtils.hideGlobalLoader();
            }
          );
        };

        scope.renderShowAttributes = function(att, obj) {
          switch (att) {
            case 'TYPE_FICHIER':
              return "<img src='img/common/fileTypes/" + obj + ".png' />";
              break;
          }
        };

        scope.specialShow = {
          TYPE_FICHIER: scope.renderShowAttributes,
        };

        scope.disabledEdit = [
          'NOM_FICHIER',
          'TYPE_FICHIER',
          'DATE_IMPORT',
          'USER',
          'PARTAGER',
          'OTHER_USER',
          'CONFIGURER',
          'DATE_CONFIG',
          'SOURCE',
        ];
        scope.disabledCheckbox = function(res) {
          var disable = false;
          if (res && res.length > 0) {
            var configured = res
              .map(function(x) {
                if (x.properties.CONFIGURER) return x.properties.CONFIGURER;
              })
              .filter(function(x) {
                if (x) return x;
              });
            disable = configured.length === res.length;
          }
          return disable;
        };

        scope.changeFilter = function(val) {
          scope.datatableCrudHpo.defaultValue = val;
          if (scope.datatableCrudHpo.defaultValue === 2)
            scope.fullfilter = '1=1';
          if (scope.datatableCrudHpo.defaultValue === 1)
            scope.fullfilter = '"CONFIGURER" = \'TRUE\'';
          if (scope.datatableCrudHpo.defaultValue === 0)
            scope.fullfilter =
              '"CONFIGURER" = \'FALSE\' OR "CONFIGURER" IS NULL ';
        };

        scope.classSelection = function(val) {
          if (scope.datatableCrudHpo.defaultValue === val) return 'btn-primary';
          else return 'btn-default';
        };

        scope.datatableCrudHpo = {
          create: { func: scope.addFeature },
          extraActions: [
            {
              name: $filter('translate')('hpo.data.exchange.mappingconf'),
              class: 'btn-default',
              func: scope.configureObjects,
            },
          ],
          // defaultValue : 0,
          // specialExtraActions : [
          //     {
          //         "name" : $filter('translate')('hpo.data.exchange.notconfigured'),
          //         "ngclass" : scope.classSelection,
          //         "val" : 0,
          //         "func" : scope.changeFilter
          //     },
          //     {
          //         "name" : $filter('translate')('hpo.data.exchange.configured'),
          //         "ngclass" : scope.classSelection,
          //         "val" : 1,
          //         "func" : scope.changeFilter
          //     },
          //     {
          //         "name" : $filter('translate')('hpo.data.exchange.all'),
          //         "ngclass" : scope.classSelection,
          //         "val" : 2,
          //         "func" : scope.changeFilter
          //     }
          //
          // ],
          remove: true,
        };

        scope.addImportedData = function(data) {
          var FeatureCollection = {
            type: 'FeatureCollection',
            crs: {
              type: 'name',
              properties: {
                name: HpoCarteAppFactory.getAppFactory().getSrid(),
              },
            },
            features: data,
          };
          gaDomUtils.showGlobalLoader();
          EditFactory.add(
            scope.historique.selectedfti.uid,
            FeatureCollection,
            HpoCarteAppFactory.getAppFactory().getSrid()
          ).then(
            function(res) {
              try {
                if (res.data.errors.length > 0) {
                  AlertHpoFactory.getSimpleFail(
                    $filter('translate')('hpo.data.exchange.fail'),
                    $filter('translate')('hpo.data.exchange.addsfail'),
                    true
                  );
                }
                if (res.data.create.length > 0) {
                  var callback = function(isconfirm) {
                    if (isconfirm) {
                      var filter =
                        " IN ('" +
                        res.data.create
                          .map(function(x) {
                            return x.id;
                          })
                          .join("' , '") +
                        "' )";
                      gaDomUtils.hideGlobalLoader();
                      QueryFactory.data(
                        scope.historique.selectedfti.uid,
                        filter,
                        HpoCarteAppFactory.getAppFactory().getSrid(),
                        '',
                        '',
                        ''
                      ).then(
                        function(result) {
                          if (
                            result &&
                            result.data &&
                            result.data.features &&
                            result.data.features.length > 0
                          ) {
                            ImportExportFactory.getCreatedSchema(
                              result.data.features
                            ).then(
                              function(result1) {
                                if (
                                  result1 &&
                                  result1.data &&
                                  result1.data.length > 0
                                ) {
                                  console.log(result1.data);
                                  scope.hpo.importedFeatures = result1.data;
                                  AlertHpoFactory.getSimpleSuccess(
                                    $filter('translate')(
                                      'hpo.data.exchange.succes'
                                    ),
                                    result1.data
                                      .map(function(x) {
                                        return gaUrlUtils.tryDecodeURIComponent(
                                          x.alias ? x.alias : x.name
                                        );
                                      })
                                      .join(' , ') +
                                      ' ' +
                                      $filter('translate')(
                                        result1.data.length > 1
                                          ? 'hpo.data.exchange.importedplusieurs'
                                          : 'hpo.data.exchange.imported'
                                      ),
                                    true
                                  );
                                  scope.tabs.activeTab = 2;
                                  $timeout(function() {
                                    $rootScope.$broadcast(
                                      'changedsourceLayers'
                                    );
                                  }, 500);
                                }
                                gaDomUtils.hideGlobalLoader();
                              },
                              function(res) {
                                AlertHpoFactory.getSimpleFail(
                                  $filter('translate')(
                                    'hpo.data.exchange.fail'
                                  ),
                                  $filter('translate')(
                                    'hpo.data.exchange.addsfail'
                                  ),
                                  true
                                );
                                gaDomUtils.hideGlobalLoader();
                              }
                            );
                          } else {
                            gaDomUtils.hideGlobalLoader();
                          }
                        },
                        function() {
                          AlertHpoFactory.getSimpleFail(
                            $filter('translate')('hpo.data.exchange.fail'),
                            $filter('translate')('hpo.data.exchange.addsfail'),
                            true
                          );
                          gaDomUtils.hideGlobalLoader();
                        }
                      );
                    } else {
                      $timeout(function() {
                        AlertHpoFactory.getSimpleSuccess(
                          $filter('translate')('hpo.data.exchange.succes'),
                          $filter('translate')('hpo.data.exchange.adds'),
                          false
                        );
                        $rootScope.$broadcast('reloadDatatable');
                        scope.clearDropzone();
                        scope.tabs.activeTab = 1;
                      }, 500);
                      gaDomUtils.hideGlobalLoader();
                    }
                  };
                  AlertHpoFactory.alertConfirmCallback(
                    $filter('translate')('hpo.common.success'),
                    $filter('translate')(
                      'hpo.data.exchange.startconfiguration'
                    ),
                    'success',
                    true,
                    undefined,
                    '#F50072',
                    true,
                    undefined,
                    undefined,
                    true,
                    true,
                    callback
                  );
                  $rootScope.$broadcast('reloadDatatable');
                }
              } catch (e) {
                conole.error(e.stack);
              }
              gaDomUtils.hideGlobalLoader();
            },
            function(res) {
              AlertHpoFactory.getSimpleFail(
                $filter('translate')('hpo.data.exchange.fail'),
                $filter('translate')('hpo.data.exchange.addsfail'),
                true
              );
              gaDomUtils.hideGlobalLoader();
            }
          );
        };

        scope.checkDataExits = function(data) {
          if (data) {
            var namesExists = scope.hpo.importedFeatures.map(function(x) {
              return x.name;
            });
            scope.datatoadd = [];
            scope.datatocheckuser = [];
            scope.data = data;
            scope.data.map(function(x) {
              if (namesExists.indexOf(x.name) === -1) scope.datatoadd.push(x);
              else scope.datatocheckuser.push(x);
            });
            if (scope.datatocheckuser.length === 0) {
              scope.hpo.importedFeatures = scope.hpo.importedFeatures.concat(
                data
              );
              if (scope.data.length > 0) {
                AlertHpoFactory.getSimpleSuccess(
                  $filter('translate')('hpo.data.exchange.succes'),
                  scope.data
                    .map(function(x) {
                      return gaUrlUtils.tryDecodeURIComponent(
                        x.alias ? x.alias : x.name
                      );
                    })
                    .join(' , ') +
                    ' ' +
                    $filter('translate')(
                      scope.data.length > 1
                        ? 'hpo.data.exchange.importedplusieurs'
                        : 'hpo.data.exchange.imported'
                    ),
                  true
                );
              }
            } else {
              scope.hpo.importedFeatures = scope.hpo.importedFeatures.concat(
                scope.datatoadd
              );
              if (scope.datatoadd && scope.datatoadd.length > 0)
                AlertHpoFactory.getSimpleSuccess(
                  $filter('translate')('hpo.data.exchange.succes'),
                  scope.datatoadd
                    .map(function(x) {
                      return gaUrlUtils.tryDecodeURIComponent(
                        x.alias ? x.alias : x.name
                      );
                    })
                    .join(' , ') +
                    ' ' +
                    $filter('translate')(
                      scope.datatoadd.length > 1
                        ? 'hpo.data.exchange.importedplusieurs'
                        : 'hpo.data.exchange.imported'
                    ),
                  true
                );
            }
          }
        };

        scope.updateConfigure = function(res, result) {
          $rootScope.$broadcast('updateobjectsHPoindatabase', {
            res: res,
            result: result,
            fti: fti,
          });
        };

        scope.fullfilter = '"CONFIGURER" = \'FALSE\' OR "CONFIGURER" IS NULL ';

        scope.fullfilter = '"CONFIGURER" = \'FALSE\' OR "CONFIGURER" IS NULL ';
        scope.v = 1;
        scope.changedfilter = function(v) {
          if (v === 2) scope.fullfilter = '1=1';
          if (v === 0) scope.fullfilter = '"CONFIGURER" = \'TRUE\'';
          if (v === 1)
            scope.fullfilter =
              '"CONFIGURER" = \'FALSE\' OR "CONFIGURER" IS NULL ';
          scope.changedTab(scope.tabs.activeTab);
        };
      },
    };
  };

  ImportHistoriqueHpo.$inject = [
    'AlertHpoFactory',
    'FeatureTypeFactory',
    'HpoCarteAppFactory',
    '$window',
    'ImportExportFactory',
    'ngDialog',
    '$q',
    '$filter',
    '$rootScope',
    '$timeout',
    'gaUrlUtils',
    'ParametersFactory',
    'ngTableParams',
    'gaDomUtils',
    'EditFactory',
    'QueryFactory',
  ];
  return ImportHistoriqueHpo;
});
