'use strict';
define(function() {
  var ScientificCalculator = function(
    AlertHpoFactory,
    FeatureTypeFactory,
    HpoCarteAppFactory,
    $window,
    ImportExportFactory,
    ngDialog,
    $q,
    $filter,
    $rootScope,
    $timeout,
    gaUrlUtils,
    ParametersFactory,
    ngTableParams,
    gaDomUtils,
    EditFactory,
    QueryFactory
  ) {
    return {
      templateUrl:
        'js/XG/widgets/hpoapp/home_admin_data/views/utilities/scientific_calculator.html',
      restrict: 'EA',
      scope: {
        value: '=?',
        attr: '=?',
        attrs: '=?',
        fti: '=?',
        isrequired: '=?',
        supplementInformations: '=?',
        supplementPrefix: '=?',
        parameterInformation: '=?',
        allowAll: '=?',
        readonly: '=?',
      },
      link: function(scope, elt, attrs, ctrl) {
        scope.hpotextarea =
          'hpotextarea' + Math.round(Math.random() * 100000000);

        if (!scope.value) scope.value = '';
        scope.value = scope.value || '';
        scope.lastPosition = 0;
        scope.filterFunc = HpoCarteAppFactory.getAppFactory().filterFunc;
        // var inFocus = false;
        // $('#' + scope.hpotextarea).focusin(function() {
        //   inFocus = true;
        // });

        if (scope.fti && Object.keys(scope.fti).length > 0) {
          scope.attrs = HpoCarteAppFactory.getAppFactory().getAuthorizedAttributes(
            scope.fti
          );
        }
        scope.$watch('fti', function(newval) {
          if (newval && Object.keys(newval).length > 0) {
            scope.attrs = HpoCarteAppFactory.getAppFactory().getAuthorizedAttributes(
              scope.fti
            );
          }
        });

        scope.showParameterInformation = () => {
          ngDialog.openConfirm({
            template:
              'js/XG/widgets/hpoapp/home_admin_data/views/dialog/parameter_information.html',
            className:
              'ngdialog-theme-plain width800 minheight500 nopadding miniclose',
            closeByDocument: false,
            scope: scope,
          });
        }

        scope.add = function(v) {
          if (v === 57) {
            var newScope = $rootScope.$new();
            newScope.expression = {
              condition: '',
              conditiontrue: '',
              conditionfalse: '',
              attrs: scope.attrs,
            };
            var dialog = ngDialog.openConfirm({
              template:
                'js/XG/widgets/hpoapp/home_admin_data/views/dialog/if_else_interface.html',
              className:
                'ngdialog-theme-plain width1100 minheight500 nopadding miniclose',
              closeByDocument: false,
              scope: newScope,
            });
            dialog.then(function(data) {
              if (data) {
                var v =
                  'ifElse(' +
                  (angular.isDefined(data.condition) ? data.condition : '') +
                  ' , ' +
                  (angular.isDefined(data.conditiontrue)
                    ? data.conditiontrue
                    : '') +
                  ' , ' +
                  (angular.isDefined(data.conditionfalse)
                    ? data.conditionfalse
                    : '') +
                  ' )';
                var sStart = $('#' + scope.hpotextarea)[0].selectionStart;
                var sEnd = $('#' + scope.hpotextarea)[0].selectionEnd;
                var firstPart = scope.value.substring(0, sStart);
                var endPart = scope.value.substring(sEnd, scope.value.length);
                scope.value = firstPart + v + endPart;
                if (typeof v === 'string') scope.value = scope.value + ' ';
                $('#' + scope.hpotextarea)[0].select(scope.value.length - 1);
              }
            });
          } else {
            var v = getValue(v);
            var sStart = $('#' + scope.hpotextarea)[0].selectionStart;
            var sEnd = $('#' + scope.hpotextarea)[0].selectionEnd;
            var firstPart = scope.value.substring(0, sStart);
            var endPart = scope.value.substring(sEnd, scope.value.length);
            scope.value = firstPart + v + endPart;
            if (typeof v === 'string') scope.value = scope.value + ' ';
            $('#' + scope.hpotextarea)[0].select(scope.value.length - 1);
          }
        };

        scope.addattribute = function(v) {
          var sStart = $('#' + scope.hpotextarea)[0].selectionStart;
          var sEnd = $('#' + scope.hpotextarea)[0].selectionEnd;
          if (scope.value) {
            var beforelast = scope.value.charAt(sStart - 3);
            var last = scope.value.charAt(sStart - 2);
            if (last === ')' && beforelast !== "'") {
              if (
                (beforelast === ',' &&
                  scope.value.charAt(sStart - 4) === '(') ||
                (beforelast === '}' && scope.value.charAt(sStart - 4) === '{')
              ) {
                var p = sStart - 3;
                scope.value =
                  scope.value.substring(0, p) + v + scope.value.substring(p);
              } else {
                var p = sStart - 2;
                scope.value =
                  scope.value.substring(0, p) + v + scope.value.substring(p);
              }
            } else {
              var firstPart = scope.value.substring(0, sStart);
              var endPart = scope.value.substring(sEnd, scope.value.length);
              scope.value = firstPart + v + endPart;
            }
          } else {
            var firstPart = (endPart = '');
            scope.value = firstPart + v + endPart;
          }
          if (typeof v === 'string') scope.value = scope.value + ' ';
          $('#' + scope.hpotextarea)[0].select(scope.value.length - 1);
        };

        scope.addSupplement = function(v) {
          v = scope.supplementPrefix + "('" + v + "')";
          var sStart = $('#' + scope.hpotextarea)[0].selectionStart;
          var sEnd = $('#' + scope.hpotextarea)[0].selectionEnd;
          if (scope.value) {
            var beforelast = scope.value.charAt(sStart - 3);
            var last = scope.value.charAt(sStart - 2);
            if (last === ')' && beforelast !== "'") {
              if (
                (beforelast === ',' &&
                  scope.value.charAt(sStart - 4) === '(') ||
                (beforelast === '}' && scope.value.charAt(sStart - 4) === '{')
              ) {
                var p = sStart - 3;
                scope.value =
                  scope.value.substring(0, p) + v + scope.value.substring(p);
              } else {
                var p = sStart - 2;
                scope.value =
                  scope.value.substring(0, p) + v + scope.value.substring(p);
              }
            } else {
              var firstPart = scope.value.substring(0, sStart);
              var endPart = scope.value.substring(sEnd, scope.value.length);
              scope.value = firstPart + v + endPart;
            }
          } else {
            var exp = scope.value.substring(sStart, sEnd);
            var firstPart = scope.value.substring(0, sStart);
            var endPart = scope.value.substring(sEnd, scope.value.length);
            scope.value = firstPart + v + endPart;
          }
          if (typeof v === 'string') scope.value = scope.value + ' ';
          $('#' + scope.hpotextarea)[0].select(scope.value.length - 1);
        };

        scope.clear = function() {
          var sStart = $('#' + scope.hpotextarea)[0].selectionStart;
          var sEnd = $('#' + scope.hpotextarea)[0].selectionEnd;
          if (sStart === sEnd) scope.value = '';
          else {
            scope.value = scope.value.replace(
              scope.value.substring(sStart, sEnd),
              ''
            );
          }
        };

        var getValue = function(x) {
          var r;
          switch (x) {
            case 1:
            case 2:
            case 3:
            case 4:
            case 5:
            case 6:
            case 7:
            case 8:
            case 9:
            case 0:
              r = x;
              break;
            case 10:
              r = '(';
              break;
            case 11:
              r = ')';
              break;
            case 12:
              r = '+';
              break;
            case 13:
              r = '/';
              break;
            case 14:
              r = 'log()';
              break;
            case 15:
              r = 'asin()';
              break;
            case 16:
              r = '-';
              break;
            case 17:
              r = Math.PI;
              break;
            case 18:
              r = 'sqrt()';
              break;
            case 19:
              r = 'abs()';
              break;
            case 20:
              r = '*';
              break;
            case 21:
              r = 'sin()';
              break;
            case 22:
              r = 'cos()';
              break;
            case 23:
              r = 'tan()';
              break;
            case 24:
              r = 'pow(,)';
              break;
            case 25:
              r = 'exp()';
              break;
            case 27:
              r = 'ln()';
              break;
            case 28:
              r = '.';
              break;
            case 29:
              r = '%';
              break;
            case 30:
              r = 'acos()';
              break;
            case 31:
              r = 'atan()';
              break;
            case 32:
              r = 'asin()';
              break;
            case 33:
              r = '<';
              break;
            case 34:
              r = '>';
              break;
            case 35:
              r = '==';
              break;
            case 36:
              r = '!=';
              break;
            case 37:
              r = '&&';
              break;
            case 38:
              r = '||';
              break;
            case 39:
              r = '!';
              break;
            case 40:
              r = '<=';
              break;
            case 41:
              r = '>=';
              break;
            case 42:
              r = 'cosh()';
              break;
            case 43:
              r = 'tanh()';
              break;
            case 44:
              r = 'sinh()';
              break;
            case 45:
              r = 'toDegrees()';
              break;
            case 46:
              r = 'toRadians()';
              break;
            case 47:
              r = 'max({})';
              break;
            case 48:
              r = 'min({})';
              break;
            case 49:
              r = 'floor()';
              break;
            case 50:
              r = 'round()';
              break;
            case 51:
              r = 'sum({})';
              break;
            case 52:
              r = 'median({})';
              break;
            case 53:
              r = 'mean({})';
              break;
            case 54:
              r = 'year()';
              break;
            case 55:
              r = 'month()';
              break;
            case 56:
              r = 'day()';
              break;
            case 57:
              r = 'ifElse(,,)';
              break;
            case 58:
              r = 'norm({})';
              break;
          }
          return r;
        };

        var numberTypes = HpoCarteAppFactory.getAppFactory().getNumberTypes();
        if (
          scope.attr &&
          HpoCarteAppFactory.getAppFactory()
            .getNumberTypes()
            .indexOf(scope.attr.type) !== -1
        ) {
          numberTypes = numberTypes.concat(
            numberTypes,
            HpoCarteAppFactory.getAppFactory().getDateTypes()
          );
          scope.showdate = false;
        } else {
          scope.showdate = false;
        }
        scope.typeIsNumber = function(type) {
          if (scope.allowAll) return true;
          var b = false;
          if (numberTypes.indexOf(type.type) !== -1) b = true;
          return b;
        };

        scope.noDouble = function(attrs) {
          if (scope.allowAll) return attrs.length === 0;
          return (
            attrs
              .map(function(x) {
                if (numberTypes.indexOf(x.type) !== -1) return x;
              })
              .filter(function(x) {
                if (x) return x;
              }).length === 0
          );
        };
      },
    };
  };

  ScientificCalculator.$inject = [
    'AlertHpoFactory',
    'FeatureTypeFactory',
    'HpoCarteAppFactory',
    '$window',
    'ImportExportFactory',
    'ngDialog',
    '$q',
    '$filter',
    '$rootScope',
    '$timeout',
    'gaUrlUtils',
    'ParametersFactory',
    'ngTableParams',
    'gaDomUtils',
    'EditFactory',
    'QueryFactory',
  ];
  return ScientificCalculator;
});
