'use strict';
define(function() {
  var filterAsElastic = function(
    AlertHpoFactory,
    FeatureTypeFactory,
    HpoCarteAppFactory,
    $window,
    ImportExportFactory,
    ngDialog,
    $q,
    $filter,
    $rootScope,
    $timeout,
    gaUrlUtils,
    ParametersFactory,
    ngTableParams,
    gaDomUtils,
    EditFactory,
    QueryFactory
  ) {
    return {
      templateUrl:
        'js/XG/widgets/hpoapp/home_admin_data/views/utilities/filter_as_elastic.html',
      restrict: 'EA',
      scope: {
        attr: '=',
        fti: '=',
        res: '=?',
      },
      link: function(scope, elt, attrs, ctrl) {
        scope.inputNeeded = function() {
          var needs = [
            'startWith',
            'endWith',
            'regexp',
            'equals',
            'notEquals',
            'include',
            'gt',
            'gte',
            'lt',
            'lte',
          ];

          return ~needs.indexOf(scope.res.operand);
        };
        scope.inputFloatNeeded = function() {
          var needs = ['equals', 'gt', 'gte', 'lt', 'lte'];

          return ~needs.indexOf(scope.res.operand);
        };

        scope.inputBooleanNeeded = function() {
          var needs = ['equals'];

          return ~needs.indexOf(scope.res.operand);
        };

        scope.inputdayNeeded = function() {
          var needs = ['last', 'next'];

          return ~needs.indexOf(scope.res.operand);
        };

        scope.filterFunc = HpoCarteAppFactory.getAppFactory().filterFunc;

        scope.showAllValues = false;
        scope.searchForValues = function() {
          if (!scope.showAllValues) {
            gaDomUtils.showGlobalLoader();
            var promise = QueryFactory.dataattributeCorrectedDate(
              scope.fti.uid,
              scope.attr.name
            );
            promise.then(
              function(res) {
                if (res.data.length > 0) {
                  scope.autocompleteglobalsearch = res.data;
                  scope.autocompleteglobalsearchinclude = [];
                  var used;
                  if (angular.isDefined(scope.res.value))
                    used = scope.res.value.toString().split(',');
                  res.data.map(function(x) {
                    var obj = {
                      name: x,
                    };
                    if (used && used.indexOf(x) !== -1) obj.selected = true;
                    scope.autocompleteglobalsearchinclude.push(obj);
                  });
                } else {
                  scope.autocompleteglobalsearch = [];
                  scope.autocompleteglobalsearchinclude = [];
                  require('toastr').error(
                    $filter('translate')('elastic.search.novalues')
                  );
                }
                scope.showAllValues = !scope.showAllValues;
                gaDomUtils.hideGlobalLoader();
              },
              function(res) {
                scope.autocompleteglobalsearch = [];
                scope.showAllValues = !scope.showAllValues;
                console.error(res);
                gaDomUtils.hideGlobalLoader();
                require('toastr').error(
                  $filter('translate')('elastic.search.novalues')
                );
              }
            );
          } else {
            scope.showAllValues = !scope.showAllValues;
          }
        };

        scope.clickedCheckbox = function() {
          scope.res.value = scope.autocompleteglobalsearchinclude
            .map(function(x) {
              if (x.selected) return x.name;
            })
            .filter(function(x) {
              if (x) return x;
            })
            .join(',');
        };

        if (scope.attr.type === 'java.lang.String')
          scope.$watch('res.value', function(newVal) {
            if (!newVal || scope.showAllValues) return;
            if (newVal.length >= 2) {
              var query = scope.attr.name + " LIKE '" + newVal + "%'";
              var promise = QueryFactory.dataattributeCorrectedDate(
                scope.fti.uid,
                scope.attr.name,
                query
              );
              promise.then(
                function(res) {
                  if (res.data.length > 0) {
                    scope.autocompleteglobalsearch = res.data;
                  } else {
                    scope.autocompleteglobalsearch = [];
                  }
                },
                function(res) {
                  scope.autocompleteglobalsearch = [];
                }
              );
            }
          });

        if (
          HpoCarteAppFactory.getAppFactory()
            .getDateTypes()
            .indexOf(scope.attr.type) !== -1 &&
          (!scope.res.newValueUtil || !scope.res.newValueUtil.value)
        )
          scope.res.newValueUtil = {
            value: undefined,
          };

        scope.formatDateShow = HpoCarteAppFactory.getAppFactory().formatDateShow;
      },
    };
  };

  filterAsElastic.$inject = [
    'AlertHpoFactory',
    'FeatureTypeFactory',
    'HpoCarteAppFactory',
    '$window',
    'ImportExportFactory',
    'ngDialog',
    '$q',
    '$filter',
    '$rootScope',
    '$timeout',
    'gaUrlUtils',
    'ParametersFactory',
    'ngTableParams',
    'gaDomUtils',
    'EditFactory',
    'QueryFactory',
  ];
  return filterAsElastic;
});
