'use strict';
define(function() {
  var addComponentConfigCarte = function(
    AlertHpoFactory,
    FeatureTypeFactory,
    HpoCarteAppFactory,
    $window,
    ImportExportFactory,
    ngDialog,
    $q,
    $filter,
    $rootScope,
    $timeout,
    gaUrlUtils,
    ParametersFactory,
    ngTableParams,
    gaDomUtils,
    EditFactory,
    QueryFactory,
    HpoAppModelServices
  ) {
    return {
      templateUrl:
        'js/XG/widgets/mapappv2/home_admin_data/views/directives/add_component_config_carte.html',
      restrict: 'EA',
      scope: {
        config: '=?',
        ftis: '=?',
        res: '=?',
      },
      link: function(scope) {
        if (angular.isUndefined(scope.ftis))
          scope.ftis = HpoCarteAppFactory.getAppFactory().getFeatureTypes(
            'admin'
          );

        scope.res = {
          component: undefined,
          attributes: {
            identifiant: undefined,
            date_de_pose: undefined,
            materiau: undefined,
            diametre: undefined,
            longueur: undefined,
          },
        };
        if (scope.config) {
          var uid = scope.config.uid;
          scope.ftis.map(function(x, i) {
            if (uid && x.uid === uid) scope.res.component = x;
          });
          if (scope.res.component && scope.res.component.attributes) {
            scope.res.component.attributes.map(function(x) {
              if (
                x.name &&
                scope.config.identifiant &&
                x.name === scope.config.identifiant
              )
                scope.res.attributes.identifiant = x;
              else if (
                x.name &&
                scope.config.date_de_pose &&
                x.name === scope.config.date_de_pose
              )
                scope.res.attributes.date_de_pose = x;
              else if (
                x.name &&
                scope.config.materiau &&
                x.name === scope.config.materiau
              )
                scope.res.attributes.materiau = x;
              else if (
                x.name &&
                scope.config.diametre &&
                x.name === scope.config.diametre
              )
                scope.res.attributes.diametre = x;
              else if (
                x.name &&
                scope.config.longueur &&
                x.name === scope.config.longueur
              )
                scope.res.attributes.longueur = x;
            });
          }
          if (scope.config.format_date_de_pose)
            scope.res.format_date_pose = scope.config.format_date_de_pose;
          if (scope.config.id) scope.res.id = scope.config.id;
        }

        scope.selectedFti = function() {
          if (scope.res.component && scope.res.component.attributes) {
            var attributes = Object.keys(scope.res.attributes);
            var assignedAttribute = [];
            scope.res.component.attributes.map(function(x) {
              var name = x.name.toLowerCase();
              for (var i = 0; i < attributes.length; i++) {
                if (
                  assignedAttribute.indexOf(attributes[i]) &&
                  attributes[i].score(name.toLowerCase()) > 0.4
                ) {
                  scope.res.attributes[attributes[i]] = x;
                  assignedAttribute.push(attributes[i]);
                }
              }
            });
          }
        };

        scope.infoDateFormat = function() {
          var dialog = ngDialog.open({
            template:
              'js/XG/widgets/hpoapp/home_admin_data/views/dialog/date_format_info.html',
            className:
              'ngdialog-theme-plain width1100 minheight500 nopadding miniclose',
            closeByDocument: false,
            scope: scope,
          });
        };

        scope.checkDateFormat = function(ftiuid, date_attribute, date_format) {
          gaDomUtils.showGlobalLoader();
          HpoAppModelServices.checkDateFormat(
            ftiuid,
            date_attribute.name,
            date_format
          ).then(
            function(res) {
              gaDomUtils.hideGlobalLoader();
              if (res.data) {
                if (
                  res.data &&
                  res.data.status &&
                  JSON.parse(res.data.status)
                ) {
                  AlertHpoFactory.getSimpleSuccess(
                    $filter('translate')('hpo.common.info'),
                    $filter('translate')(res.data.message),
                    true,
                    'success'
                  );
                } else if (res.data && !res.data.status && res.data.results) {
                  var newScope = $rootScope.$new();
                  newScope.result = res.data;
                  newScope.currentResources = res.data.results;
                  newScope.editListCfg = {
                    dataModule: 'hpo',
                    resource_type: 'admin',
                    cols: ['value', 'status'],
                    deleteResourceButton: false,
                    dontShowLength: false,
                    notAddMode: false,
                    notPagination: false,
                    hideHeader: true,
                    hideDetails: true,
                    colsFunction: {
                      status: 'booleanToCheck',
                    },
                  };
                  var dialog = ngDialog.open({
                    template:
                      'js/XG/widgets/hpoapp/home_admin_data/views/dialog/date_format_show_result.html',
                    className:
                      'ngdialog-theme-plain width800 minheight500 nopadding miniclose',
                    closeByDocument: false,
                    scope: newScope,
                  });
                } else {
                  AlertHpoFactory.getSimpleSuccess(
                    $filter('translate')('hpo.common.info'),
                    $filter('translate')(res.data.message),
                    true,
                    'error'
                  );
                }
              } else {
                AlertHpoFactory.showErrorMessage(res);
              }
            },
            function(res) {
              gaDomUtils.hideGlobalLoader();
              AlertHpoFactory.showErrorMessage(res);
            }
          );
        };
      },
    };
  };

  addComponentConfigCarte.$inject = [
    'AlertHpoFactory',
    'FeatureTypeFactory',
    'HpoCarteAppFactory',
    '$window',
    'ImportExportFactory',
    'ngDialog',
    '$q',
    '$filter',
    '$rootScope',
    '$timeout',
    'gaUrlUtils',
    'ParametersFactory',
    'ngTableParams',
    'gaDomUtils',
    'EditFactory',
    'QueryFactory',
    'HpoAppModelServices',
  ];
  return addComponentConfigCarte;
});
