'use strict';
define([
  'angular',
  /**
   * Controller
   */
  'widgets/indigauapp/main/controllers/gcMainCarteController',

  /**
   * Factories
   */
  'widgets/indigauapp/main/factory/HpoCarteAppFactory',
  'widgets/indigauapp/main/factory/CarteAppFactory',
  'widgets/indigauapp/main/factory/CarteUserAppFactory',

  /**
   * Providers
   */
  'widgets/indigauapp/main/providers/CarteInitProvider',

  /**
   * dependencies
   */
  'angular-strap',
  'angular-strap.tpl',
  'angular-route',
  'ngDragDrop',
], function(
  angular,
  gcMainCarteController,
  HpoCarteAppFactory,
  CarteAppFactory,
  CarteUserAppFactory,
  CarteInitProvider
) {
  // generation du module
  var gcMain = angular.module('gcIndigauMain', [
    'model',
    'ga_urlutils_service',
    'ngRoute',
    'ngDragDrop',
  ]);
  
  /**
   * Controller
   */
  gcMain.controller('gcIndigauController', gcMainCarteController);

  /**
   * Factories
   */
  gcMain.factory('HpoCarteAppFactory', HpoCarteAppFactory);
  gcMain.factory('CarteAppFactory', CarteAppFactory);
  gcMain.factory('IndCarteUserAppFactory', CarteUserAppFactory);

  /**
   * Providers
   */
  gcMain.provider('CarteInitProvider', CarteInitProvider);

  return gcMain;
});
