define([
  'angular',
  'widgets/mapapp/annotations/directives/annotationswidget',
  'widgets/mapapp/annotations/directives/toolbarannotations',
  'widgets/mapapp/annotations/directives/colorbox',
], function(angular, annotationswidget, toolbarannotations, colorbox) {
  'use strict';

  // Angular module
  var gcannotations = angular.module('gc_annotations', [
    'mgcrea.ngStrap',
    'ngRoute',
    'pascalprecht.translate',
  ]);

  // Directives
  gcannotations.directive('gcannotationswidget', annotationswidget);
  gcannotations.directive('toolbarannotations', toolbarannotations);
  gcannotations.directive('colorbox', colorbox);

  // Filter for proper feature rotation in the UI
  gcannotations.filter('showDegrees', function() {
    var DEG_PER_RAD = 180 / Math.PI; // Degrees per radian
    return function(radians) {
      return Math.round(radians * DEG_PER_RAD) + ' °';
    };
  });

  return gcannotations;
});
