/**
 *
 */
'use strict';
define(function() {
  /**
   * attributesPopupCtrl
   * @param $scope
   * @param ReportIndicatorFactory
   * @constructor
   */
  var attributesPopupCtrl = function($scope, ngTableParams) {
    alert('attributesPopupCtrl');

    $scope.multipleEditValues = {};

    // get the attribute Types
    $scope.displayAttributesType = {};
    if (angular.isArray($scope.editdescription.fti.attributes)) {
      $scope.editdescription.fti.attributes.map(function(a) {
        var fieldType = '';
        switch (a.type) {
          case 'java.util.Date':
          case 'java.sql.Timestamp':
          case 'java.sql.Time':
          case 'java.sql.Date':
            fieldType = 'date';
            break;
          case 'java.lang.Double':
          case 'java.lang.Float':
          case 'java.math.BigDecimal':
          case 'java.lang.Integer':
            fieldType = 'number';
            break;
          case 'java.lang.Boolean':
            fieldType = 'boolean';
            break;
          default:
            fieldType = 'string';
            break;
        }
        $scope.displayAttributesType[a.name] = {
          type: a.type,
          fieldType: fieldType,
        };
      });
    }

    $scope.tableParams = new ngTableParams(
      {
        page: 1, // show first page
        count: 10, // count per page
        // sorting: {
        //   name: 'asc'     // initial sorting
        // }
      },
      {
        total: $scope.selectedFeatures.length, // length of data
        getData: function($defer, params) {
          params.total($scope.selectedFeatures.length); // set total for recalc pagination
          $defer.resolve(
            $scope.selectedFeatures.slice(
              (params.page() - 1) * params.count(),
              params.page() * params.count()
            )
          );
        },
      }
    );
    $scope.updateAllSelectedFeatures = function() {
      angular.forEach(multipleEditValues, function(value, key) {
        //Affectation des valeurs attributaires à chaque feature à partir des attributs temporaires.
        for (var i = 0; i < $scope.selectedFeatures.length; i++) {
          var f = $scope.selectedFeatures[i];
          f.currentProperties[key] = value;
        }
      });
    };

    /**
     * Toggle Edit mode for a specific line
     * @param index
     */
    $scope.editableLines = {};
    $scope.toggleEdit = function(index) {
      if ($scope.editableLines.hasOwnProperty(index)) {
        delete $scope.editableLines[index];
        reloadTable();
      } else {
        $scope.editableLines[index] = true;
      }
    };
    /**
     * Update a feature
     * @param obj
     * @param $index
     */
    $scope.updateData = function(obj, $index) {
      $scope.toggleEdit($index);
    };
  };

  attributesPopupCtrl.$inject = ['$scope', 'ngTableParams'];
  return attributesPopupCtrl;
});
