'use strict';
define(() => {
  let toolbarexportmap = (gaDomUtils) => {
    return {
      templateUrl: 'js/XG/widgets/mapapp/exportmap/views/toolbarexportmap.html',
      restrict: 'A',

      link: (scope) => {
        scope.exportToImage = () => {

          //Génération d'une image
          //Ajout d'un fond blanc (KIS-2839)

          scope.map.once('postcompose', function(event) {
            const canvas = event.context.canvas;
            let context = event.context.canvas.getContext('2d');

            let canvasContainer = canvas.getBoundingClientRect();
            const scaleX = canvas.width / canvasContainer.width;
            const scaleY = canvas.height / canvasContainer.height;
            let imageData = context.getImageData(0, 0, canvas.width, canvas.height);

            let newCanvas = document.createElement('canvas');
            newCanvas.width = canvas.width;
            newCanvas.height = canvas.height;

            let newContext = newCanvas.getContext('2d');

            newContext.scale(scaleX, scaleY);
            newContext.putImageData(imageData, 0, 0);

            // reset scale and draw behind existing image
            newContext.setTransform(1, 0, 0, 1, 0, 0);
            newContext.globalCompositeOperation = 'destination-over';

            // add background
            newContext.fillStyle = 'white';
            newContext.fillRect(0, 0, canvas.width, canvas.height);

            // reset the context
            newContext.globalCompositeOperation = 'source-over';
            newContext.scale(scaleX, scaleY);

            // les cotations ne ressortent pas sur les captures d'écran (KIS-2955)
            drawMeasureTooltips(newContext);

            // dessin de l'échelle graphique (KIS-2839)
            const lineScale = document.querySelector('.ol-scale-line-inner');
            const lineScaleRect = lineScale.getBoundingClientRect();
            const controlX = canvasContainer.right - 10 - lineScaleRect.width;
            const controlY = canvasContainer.bottom - 10 - lineScaleRect.height;
            const controlWidth = lineScaleRect.width;
            const controlHeight = lineScaleRect.height;
            const controlText = lineScale.innerText;
            const controlStrokeStyle = 'rgba(0, 0, 0, 1)';
            const controlFillStyleText = 'rgba(0, 0, 0, 1)';
            const controlFont = '12px  \'opensans\', sans-serif';
            const controlLineWidth = 1;

            newContext.beginPath();
            newContext.moveTo(controlX, controlY);
            newContext.lineTo(controlX, controlY + controlHeight);
            newContext.lineTo(controlX + controlWidth, controlY + controlHeight);
            newContext.lineTo(controlX + controlWidth, controlY);
            newContext.strokeStyle = controlStrokeStyle;
            newContext.lineWidth = controlLineWidth;
            newContext.stroke();
            newContext.closePath();
            newContext.font = controlFont;
            newContext.textBaseline = 'middle';
            newContext.fillStyle = controlFillStyleText;

            let textString = controlText;
            let textWidth = newContext.measureText(textString).width;
            const scaleTextX = controlX + (controlWidth - textWidth) / 2;
            const scaleTextY = controlY + controlHeight / 2;
            newContext.fillText(textString, scaleTextX, scaleTextY);

            // dessin de la source (ex: "Galilée - 26/04/2023) (KIS-2839)
            const refX = canvasContainer.left + 10;
            const refY = canvasContainer.bottom - 15;
            let timezone = Intl.DateTimeFormat().resolvedOptions().timeZone;
            if (!timezone) {
              timezone = 'Europe/Paris';
            }
            const date = (new Date()).toLocaleString('fr-FR',
                {timeZone: timezone, year: 'numeric', month: 'numeric', day: 'numeric'});
            textString = localStorage.getItem('app') + ' - ' + date;
            newContext.fillText(textString, refX, refY);

            let image = newCanvas.toDataURL('image/png');

            const nmablob = gaDomUtils.convertDataURItoBlob(image);
            const blobUrl = URL.createObjectURL(nmablob);
            window.open(blobUrl);
          });
          scope.map.renderSync();
        };

        /**
         * Dessine les infobulles des cotations de l'outil "Mesures" (mesure linéaire ou surfacique)
         * @param newContext contexte du nouveau canvas
         * @see KIS-2955
         */
        const drawMeasureTooltips = (newContext) => {
          scope.map.getOverlays().forEach(function(overlay) {
            const element = overlay.getElement();
            const position = overlay.getPosition();

            // Vérifie si l'élément est un tooltip et possède les classes spécifiées
            if (position && element.classList.contains('tooltip') && element.classList.contains('tooltip-static')) {

              // Récupére les coordonnées du tooltip par rapport à la fenêtre
              const rect = element.getBoundingClientRect();
              const tooltipTop = rect.top + window.pageYOffset;
              const tooltipLeft = rect.left + window.pageXOffset;
              const tooltipBottom = rect.bottom + window.pageYOffset;
              const tooltipRight = rect.right + window.pageXOffset;
              const halfTooltipWidth = ((tooltipRight - tooltipLeft) / 2);

              // Applique l'opacité au tooltip
              newContext.globalAlpha = 0.7;

              // Dessine le tooltip sur le canevas
              newContext.beginPath();

              // Styles spécifiés pour le tooltip
              const backgroundColor = '#ffcc33'; // Couleur de fond
              const textColor = 'black'; // Couleur du texte
              const borderColor = 'white'; // Couleur du texte
              const borderWidth = 1; // Largeur de la bordure
              const borderRadius = 4; // Border-radius
              const paddingV = 4; // Padding-top/bottom
              const paddingH = 8; // Padding-left/right
              const triangleSize = 5.5; // côté du triangle

              const tooltipText = element.innerText;

              // Dessine le corps du tooltip (rectangle avec bord arrondi)
              newContext.fillStyle = backgroundColor;
              newContext.strokeStyle = borderColor;
              newContext.lineWidth = borderWidth;
              newContext.moveTo(tooltipLeft, tooltipTop + borderRadius);
              newContext.arcTo(tooltipLeft, tooltipTop, tooltipLeft + borderRadius, tooltipTop, borderRadius);
              newContext.lineTo(tooltipRight - borderRadius, tooltipTop);
              newContext.arcTo(tooltipRight, tooltipTop, tooltipRight, tooltipTop + borderRadius, borderRadius);
              newContext.lineTo(tooltipRight, tooltipBottom - borderRadius);
              newContext.arcTo(tooltipRight, tooltipBottom, tooltipRight - borderRadius, tooltipBottom, borderRadius);
              newContext.lineTo(tooltipLeft + borderRadius, tooltipBottom);
              newContext.arcTo(tooltipLeft, tooltipBottom, tooltipLeft, tooltipBottom - borderRadius, borderRadius);
              newContext.lineTo(tooltipLeft, tooltipTop + borderRadius);

              // Rempli le fond et dessinez la bordure du tooltip
              newContext.fill();
              newContext.stroke();

              // Dessine le texte du tooltip
              newContext.fillStyle = textColor;
              newContext.textBaseline = 'middle';
              newContext.textAlign = 'center';
              newContext.font = '12px opensans, sans-serif';
              const center = [tooltipLeft + halfTooltipWidth, tooltipTop + paddingV / 2 + ((tooltipBottom - tooltipTop) / 2)];
              newContext.fillText(tooltipText, center[0], center[1], tooltipRight - tooltipLeft - (2 * paddingH));

              newContext.beginPath();
              // Dessine le triangle pointe en bas
              // Superpose le triangle à la bordure pour la masquer => on ajoute 1 pixel à coordonnée Y de la pointe basse
              newContext.fillStyle = backgroundColor;
              newContext.moveTo(tooltipLeft + halfTooltipWidth - triangleSize, tooltipBottom - 1);
              newContext.lineTo(tooltipLeft + halfTooltipWidth, tooltipBottom + triangleSize + 1);
              newContext.lineTo(tooltipLeft + halfTooltipWidth + triangleSize, tooltipBottom - 1);
              newContext.moveTo(tooltipLeft + halfTooltipWidth - triangleSize, tooltipBottom - 1);

              // Rempli le triangle
              newContext.fill();

              // Rétabli l'opacité par défaut après avoir dessiné le tooltip
              newContext.globalAlpha = 1.0;
            }
          });
        };
      },
    };
  };

  toolbarexportmap.$inject = ['gaDomUtils'];
  return toolbarexportmap;
});
