'use strict';
define(function() {
  var basemapwidget = function(
    gcPropertiesLayers,
    gclayers,
    ParametersFactory,
    gcPopup,
    extendedNgDialog,
    gaDomUtils,
    GeoTreatmentFactory
  ) {
    return {
      templateUrl:
        'js/XG/widgets/mapapp/geotreatment/views/treatments/treatSetAttribute.html',
      restrict: 'A',
      link: function(scope, elt, attrs, ctrl) {
        scope.activetreatment = '';
        scope.res = {};
        scope.geometricoperand = [
          'EQUALS',
          'DISJOINT',
          'INTERSECTS',
          'TOUCHES',
          'CROSSES',
          'WITHIN',
          'CONTAINS',
          'OVERLAPS',
        ];
        scope.selectedGeomOperand = 'INTERSECTS';
        scope.attributes_set = [];
        scope.geoLimit = GeoTreatmentFactory.DATABASE;
        scope.inprogress = false;
        scope.interrupt = false;
        scope.typeOfGeotreatment = 'setAttribute';
        scope.attributesTochange = '';

        let handlePromiseError= () =>{
          scope.inprogress = false;
        };

        scope.stop = function() {
          GeoTreatmentFactory.stoptreatment(scope.state).then(function(data) {
            scope.inprogress = false;
            scope.interrupt = true;
          }).catch(handlePromiseError);
        };

        function getAttrListOfFti2() {
          var aliases = [];
          aliases.push('ID');
          aliases.push(scope.attributesTochange);
          aliases.push(scope.attributesTochange + ' NEW');
          return aliases;
        }

        scope.run = function(
          fti1,
          fti2,
          attributeChse,
          attributeChse2,
          selectedGeomOperand
        ) {
          scope.attributesTochange = attributeChse2;
          var assoc = { src: attributeChse, dest: attributeChse2 };
          var attributes_set = [];
          attributes_set.push(assoc);
          scope.inprogress = true;
          const featureCollections = [];
          const spatialClause = 
            GeoTreatmentFactory.getSpatialClause(
              scope.geoLimit,
              scope.map,
              scope.limitZoneGeometry,
              [fti1.name], // fti2 is not passed because we don't need the features from this layer
              featureCollections);
          var param = {
            spatialclause: spatialClause,
            featureCollections: featureCollections,
            fti1: fti1.uid,
            fti2: fti2.uid,
            attributes: attributes_set,
            operand: selectedGeomOperand,
            submethod: 'evaluate',
            srid: scope.map.getView().getProjection().getCode()
          };
          GeoTreatmentFactory.treatment(
            param,
            'SetValueFromGeometry'
          ).then(function(data) {
            scope.state = data.data;
            scope.httpStatus=data.status;
            GeoTreatmentFactory.tick(scope, getAttrListOfFti2());
          }).catch(handlePromiseError);
        };
      },
    };
  };

  basemapwidget.$inject = [
    'gcPropertiesLayers',
    'gclayers',
    'ParametersFactory',
    'gcPopup',
    'extendedNgDialog',
    'gaDomUtils',
    'GeoTreatmentFactory',
  ];
  return basemapwidget;
});
