'use strict';
define(function() {
  var majicController = function($scope, gclayers, MajicFactory, $timeout) {
    $scope.viewMode = 'consult';

    $scope.AddParcelle = function() {
      $scope.viewMode = 'search';
      $timeout(()=> {
        MajicFactory.setInitPopupWidthAndMinWidth('search');
      },200);
    };

    $scope.SwitchToConsult = function() {
      $scope.viewMode = 'consult';
      var idcompte = $scope.parcelleInfosResult.idCompte;
      if ($scope.selectedParc) {
        var idcommune = $scope.selectedParc.idcommune;
        var idparcelle = $scope.selectedParc.idparcelle;
      }

      if ($scope.isProprietairesAutorized) $scope.VueProprietaire(idcompte);

      if ($scope.isBatimentAutorized) $scope.vueBatiment();

      if ($scope.isSubdivisionsAutorized)
        $scope.VueSubdivision(idcommune, idparcelle);

      if ($scope.isExonerationAutorized)
        $scope.VueExoneration(idcommune, idparcelle);
      $timeout(()=> {
        MajicFactory.setInitPopupWidthAndMinWidth('consult');
      },200);
    };

    $scope.SwitchToBatiConsult = function() {
      $scope.viewMode = 'batiConsult';
    };

    $scope.SwitchToLocalConsult = function() {
      $scope.viewMode = 'localConsult';
    };

    $scope.SwitchToCopropConsult = function() {
      $scope.viewMode = 'copropConsult';
      $scope.goneTocopropConsult = true;
    };

    function clearFormData() {
      $scope.parcelleInfosResult = {};
      $scope.proprioInfosResult = {};
      $scope.subdivisInfosResult = {};
      $scope.exoInfosResult = {};

      $scope.batimentInfosResult = {};
      $scope.pevInfosResult = {};

      $scope.habitatInfosResult = {};
      $scope.depInfosResult = {};
      $scope.localExoInfosResult = {};

      // Suppression de la mise en evidence de la parcelle en cours de
      // visualisation
      if ($scope.highLigtedFeature != undefined) {
        $scope.highLigtedFeature = gclayers.removehighLightFeatures(
          $scope.highLigtedFeature
        );
      }
    }

    /**
     * Supprime la parcelle sélectionnée dans la liste déroulante des
     * Parcelles consultables
     *
     * @param {type}
     *            parcelleObject
     * @returns {undefined}
     */
    $scope.removeFromConsultList = function(parcelleObject) {
      clearFormData();
      $scope.selectedParc = undefined;
      if (parcelleObject != undefined) {
        $scope.listeParcelles.splice(
          $scope.listeParcelles.indexOf(parcelleObject),
          1
        );
      }
    };
  };

  majicController.$inject = ['$scope', 'gclayers', 'MajicFactory', '$timeout'];

  return majicController;
});
