'use strict';
define(function() {
  var majicConsult = function(
    MajicFactory,
    ReportFactory,
    gclayers,
    QueryFactory,
    ConfigFactory,
    $q,
    $timeout,
    $rootScope,
    ngDialog,
    $filter,
    SelectManager,
    FeatureTypeFactory

) {
    return {
      templateUrl: 'js/XG/widgets/mapapp/majic/views/majicConsult.html',
      restrict: 'E',

      // methode executée au chargement de la page
      link: function(scope, element, attrs) {
        scope.isAdmin = $rootScope.xgos.isroot || $rootScope.xgos.isadmin;

        scope.roles = $rootScope.xgos.user.roles;
        scope.csvParams = {};
        scope.csvParams.comma = ',';
        scope.csvParams.semicolon = ';';

        scope.verifRole = function(roleName) {
          var exist = false;
          for (var i = 0; i < scope.roles.length; i++) {
            if (scope.roles[i].name === roleName) {
              exist = true;
            }
          }
          return exist;
        };

        scope.checkAutorizations = function() {
          scope.compteurAuthorizedOnglets = 0;
          scope.isParcelleAutorized = scope.verifRole('MajicConsultParcelle');
          scope.isParcelleAutorized =
            scope.isAdmin ||
            scope.isParcelleAutorized ||
            scope.roles.length === 0;
          if (scope.isParcelleAutorized) {
            scope.compteurAuthorizedOnglets =
              scope.compteurAuthorizedOnglets + 1;
          }
          scope.isProprietairesAutorized = scope.verifRole(
            'MajicConsultProprietaires'
          );
          scope.isProprietairesAutorized =
            scope.isAdmin ||
            scope.isProprietairesAutorized ||
            scope.roles.length === 0;
          if (scope.isProprietairesAutorized) {
            scope.compteurAuthorizedOnglets =
              scope.compteurAuthorizedOnglets + 1;
          }

          scope.isSubdivisionsAutorized = scope.verifRole(
            'MajicConsultSubdivisions'
          );
          scope.isSubdivisionsAutorized =
            scope.isAdmin ||
            scope.isSubdivisionsAutorized ||
            scope.roles.length === 0;
          if (scope.isSubdivisionsAutorized) {
            scope.compteurAuthorizedOnglets =
              scope.compteurAuthorizedOnglets + 1;
          }

          scope.isBatimentAutorized = scope.verifRole('MajicConsultBatiment');
          scope.isBatimentAutorized =
            scope.isAdmin ||
            scope.isBatimentAutorized ||
            scope.roles.length === 0;

          scope.isExonerationAutorized = scope.verifRole(
            'MajicConsultExonerations'
          );
          scope.isExonerationAutorized =
            scope.isAdmin ||
            scope.isExonerationAutorized ||
            scope.roles.length === 0;
        };

        scope.checkAutorizations();

        // Initialize tabs
        scope.tabsConsult = [
          {
            title: 'Parcelle',
            authorized: scope.isParcelleAutorized,
          },
          {
            title: 'Propriétaires',
            authorized: scope.isProprietairesAutorized,
          },
          {
            title: 'Subdivisions',
            authorized: scope.isSubdivisionsAutorized,
          },
          {
            title: 'Exonérations',
            authorized: scope.isExonerationAutorized,
          },
        ];

        scope.tabsConsult.activeTab = 0;

        // Handler du changement de sélection d'onglet de consultation
        scope.$watch('tabsConsult.activeTab', function(value) {
          if (
            ((scope.tabsConsult.activeTab == 1 && scope.isParcelleAutorized) ||
              (!scope.isParcelleAutorized &&
                scope.tabsConsult.activeTab == 0)) &&
            scope.isProprietairesAutorized
          ) {
            scope.VueProprietaire();
          } else if (
            ((scope.tabsConsult.activeTab == 2 &&
              scope.isProprietairesAutorized &&
              scope.isParcelleAutorized) ||
              (scope.tabsConsult.activeTab == 1 &&
                ((!scope.isParcelleAutorized &&
                  scope.isProprietairesAutorized) ||
                  (scope.isParcelleAutorized &&
                    !scope.isProprietairesAutorized))) ||
              (scope.tabsConsult.activeTab == 0 &&
                !scope.isParcelleAutorized &&
                !scope.isProprietairesAutorized)) &&
            scope.isSubdivisionsAutorized
          ) {
            scope.VueSubdivision();
          } else if (
            scope.tabsConsult.activeTab == scope.compteurAuthorizedOnglets &&
            scope.isExonerationAutorized
          ) {
            scope.VueExoneration();
          }
        });

        // ////////////////////////////////////////////////////////////
        // Données partagées
        // ///////////////////////////////////////////////////////////

        var idcommune = '';
        var idparcelle = '';
        var idcompte = '';

        // Boolean indicateur du chargement des données pour la parcelle
        // 'selectedParc' sélectionnée
        var bParc = false;
        var bSubv = false;
        var bExon = false;

        function InitBoolean() {
          bParc = false;
          bSubv = false;
          bExon = false;

          scope.initBatiBoolean();
          scope.initLocalBoolean();
        }

        // ////////////////////////////////////////////////////////////
        // Onglet Parcelles
        // ///////////////////////////////////////////////////////////

        scope.listeParcelles = [];
        scope.selectedParc = undefined;
        scope.SelectParcelle = function() {
          if (scope.selectedParc == undefined) {
            let defer = $q.defer();
            defer.resolve();
            return defer.promise;
          }

          InitBoolean();
          scope.tabsConsult.activeTab = 0;

          idcommune = scope.selectedParc.Parcelle.substr(0, 6);
          idparcelle = scope.selectedParc.Parcelle.substr(6);
          // idcommune = scope.selectedParc.idcommune;
          // idparcelle = scope.selectedParc.idparcelle;

          return scope.VueParcelle();
        };

        scope.parcelleInfosResult = {};

        scope.VueParcelle = function() {
          var defer = $q.defer();
          if (bParc == false) {
            if (idcommune != '') {
              bParc = true;
              MajicFactory.getparambyid(idcommune, idparcelle).then(
                function(res) {
                  scope.parcelleInfosResult = res.data;
                  idcompte = scope.parcelleInfosResult.idCompte;
                  scope.VueProprietaire(idcompte);
                  scope.highLigthParc();
                  defer.resolve();
                },
                function(reason) {
                  var resultObject = reason;
                  console.log('getparambyid echec : ' + resultObject);
                  require('toastr').error('getParcelle:' + resultObject);
                  defer.reject();
                }
              );
            }
          }
          // VerifListe();
          return defer.promise;
        };

        // ////////////////////////////////////////////////////////////
        // Onglet Propriétaires
        // ///////////////////////////////////////////////////////////

        var proprioInfosResults = [];
        var iProp = 0;
        scope.proprioInfosResult = {};

        scope.VueProprietaire = function(pIdCompte) {
          if (pIdCompte != undefined) {
            idcompte = pIdCompte;
          }
          scope.goneTocopropConsult = false;
          if (idcommune != '') {
            MajicFactory.getpropbyid(idcommune, idcompte, 'traditionnel').then(
              function(res) {
                scope.proprioInfosResults = proprioInfosResults = res.data;
                scope.changeProprietaire(0);
              },
              function(reason) {
                var resultObject = reason;
                console.log('VueProprietaire echec : ' + resultObject);
                require('toastr').error('VueProprietaire:' + resultObject);
              }
            );
          }
        };

        scope.changeProprietaire = function(i) {
          iProp = i;
          scope.proprioInfosResult = proprioInfosResults[iProp];
          if (scope.proprioInfosResult != undefined) {
            idcompte = scope.proprioInfosResult.compte;
          }
        };
        scope.PropPrec = function() {
          if (iProp <= 0) return;
          scope.changeProprietaire(--iProp);
        };
        scope.PropSuiv = function() {
          if (iProp >= proprioInfosResults.length - 1) return;
          scope.changeProprietaire(++iProp);
        };

        // ////////////////////////////////////////////////////////////
        // Onglet Subdivisions
        // ///////////////////////////////////////////////////////////

        var subdivisInfosResults = [];
        var iSubdi = 0;
        scope.subdivisInfosResult = {};

        scope.VueSubdivision = function(idcommuneCtrl, idparcCtrl) {
          if (!idcommune && idcommuneCtrl) {
            idcommune = idcommuneCtrl;
          }

          if (!idparcelle && idparcCtrl) {
            idparcelle = idparcCtrl;
          }
          if (bSubv == false || idcommune) {
            if (idcommune != '') {
              bSubv = true;
              MajicFactory.getsubdibyid(idcommune, idparcelle).then(
                function(res) {
                  subdivisInfosResults = res.data;
                  changeSubdivision(0);
                },
                function(reason) {
                  var resultObject = reason;
                  console.log('VueSubdivision echec : ' + resultObject);
                  require('toastr').error('VueSubdivision:' + resultObject);
                }
              );
            }
          }
        };

        function changeSubdivision(i) {
          iSubdi = i;
          scope.subdivisInfosResult = subdivisInfosResults[iSubdi];
        }
        scope.SubdPrec = function() {
          if (iSubdi <= 0) return;
          changeSubdivision(--iSubdi);
        };
        scope.SubdSuiv = function() {
          if (iSubdi >= subdivisInfosResults.length - 1) return;
          changeSubdivision(++iSubdi);
        };

        // ////////////////////////////////////////////////////////////
        // Onglet Exonérations
        // ///////////////////////////////////////////////////////////

        var exoInfosResults = [];
        var iExo = 0;
        scope.exoInfosResult = {};

        scope.VueExoneration = function(idcommuneCtrl, idparcCtrl) {
          if (!idcommune && idcommuneCtrl) {
            idcommune = idcommuneCtrl;
          }

          if (!idparcelle && idparcCtrl) {
            idparcelle = idparcCtrl;
          }

          if (bExon == false || idcommune) {
            if (idcommune != '') {
              bExon = true;
              MajicFactory.getexobyid(idcommune, idparcelle).then(
                function(res) {
                  exoInfosResults = res.data;
                  changeExoneration(0);
                },
                function(reason) {
                  var resultObject = reason;
                  console.log('VueExoneration echec : ' + resultObject);
                  require('toastr').error('VueExoneration:' + resultObject);
                }
              );
            }
          }
        };

        function changeExoneration(i) {
          iExo = i;
          scope.exoInfosResult = exoInfosResults[iExo];
        }
        scope.ExoPrec = function() {
          if (iExo <= 0) return;
          changeExoneration(--iExo);
        };
        scope.ExoSuiv = function() {
          if (iExo >= exoInfosResults.length - 1) return;
          changeExoneration(++iExo);
        };

        // ////////////////////////////////////////////////////////////
        // Sélection des Parcelles par bouton suivant et précedent
        // ///////////////////////////////////////////////////////////

        scope.refreshInfoParcelle = function(selectedParcIndex) {
          if (selectedParcIndex != undefined)
            scope.selectedParc = scope.listeParcelles[selectedParcIndex];
          scope.SelectParcelle().then(function() {
            scope.searchCoprops();
            scope
              .vueBatiment(undefined, undefined, 'locauxPrincipaux')
              .then(function() {
                var idcompte0 = scope.parcelleInfosResult.idCompte;
                $timeout(function() {
                  scope.VueProprietaire(idcompte0);
                  idcompte = idcompte0;
                }, 250);
              });
          });

          if (scope.isSubdivisionsAutorized) {
            scope.VueSubdivision();
          }
          if (scope.isExonerationAutorized) {
            scope.VueExoneration();
          }
        };

        scope.PrecParcelle = function() {
          // Si la liste est vide
          if (scope.listeParcelles.length == 0) return;

          // Sélection par défaut du premier element
          var selectedParcIndex = 0;
          // Si une parcelle est déjà sélectionnée
          if (scope.selectedParc != undefined) {
            // Récupération de l'index correspondant
            selectedParcIndex = scope.listeParcelles.indexOf(
              scope.selectedParc
            );
            // Si l'element sélectionné n'est pas le premier
            if (selectedParcIndex > 0) selectedParcIndex--;
          }
          // Sélection de la parcelle précedente
          scope.refreshInfoParcelle(selectedParcIndex);
        };

        scope.SuivParcelle = function() {
          // Si la liste est vide
          if (scope.listeParcelles.length == 0) return;

          // Sélection par défaut du premier element
          var selectedParcIndex = 0;
          // Si une parcelle est déjà sélectionnée
          if (scope.selectedParc != undefined) {
            // Récupération de l'index correspondant
            selectedParcIndex = scope.listeParcelles.indexOf(
              scope.selectedParc
            );
            // Si l'element sélectionné n'est pas le premier
            if (selectedParcIndex < scope.listeParcelles.length - 1)
              selectedParcIndex++;
          }
          // Sélection de la parcelle précedente
          scope.refreshInfoParcelle(selectedParcIndex);
        };

        // ////////////////////////////////////////////////////////////
        // Export CSV
        // ///////////////////////////////////////////////////////////

        scope.getCsvHeader = function() {
          return [
            idCommuneLabel,
            sectionLabel,
            parcelleLabel,
            numVoirieLabel,
            libelleVoieLabel,
            communeLabel,
            dateActeLabel,
            nomProprioLabel,
            nomNaissProprioLabel,
            adresseProprioLabel,
            dateNaissProprioLabel,
            lieuNaissProprioLabel
          ];
        };

        const idCommuneLabel = 'idCommune';
        const sectionLabel = 'Section';
        const parcelleLabel = 'Parcelle';
        const numVoirieLabel = 'N°voirie';
        const libelleVoieLabel = 'Voie';
        const communeLabel = 'Commune';

        const nomProprioLabel = 'Nom propriétaire';
        const nomNaissProprioLabel = 'Nom de naissance propriétaire';
        const adresseProprioLabel = 'Adresse propriétaire';
        const dateActeLabel = 'Date de l\'acte'
        const dateNaissProprioLabel = 'Date de naissance propriétaire'
        const lieuNaissProprioLabel = 'Lieu de naissance propriétaire'

        scope.getCsvSourceArray = function() {
          var mainPromise = $q.defer();

          var csvSourceArray = [];

          var i = 0;
          var idcommune = '';
          var idparcelle = '';
          var idcompte = '';
          var parcelleInfosResult = undefined;

          function treatNextParcelle() {
            if (i >= scope.listeParcelles.length) {
              // Fin : tableau des données à exporter en CSV est
              // complet.
              mainPromise.resolve(csvSourceArray);
            } else {
              var currentParcelle = scope.listeParcelles[i];
              idcommune = currentParcelle.Parcelle.substr(0, 6);
              idparcelle = currentParcelle.Parcelle.substr(6);

              getCsvParcelleInfo();
              i++;
            }
          }
          treatNextParcelle();

          function getCsvParcelleInfo() {
            if (idcommune != '') {
              MajicFactory.getparambyid(idcommune, idparcelle).then(
                function(res) {
                  parcelleInfosResult = res.data;
                  idcompte = parcelleInfosResult.idCompte;

                  getCsvProprietaires();
                },
                function(reason) {
                  var resultObject = reason;
                  console.log('getparambyid echec : ' + resultObject);
                  require('toastr').error('getParcelle:' + resultObject);
                  mainPromise.reject('');
                }
              );
            } else {
              treatNextParcelle();
            }
          }

          let proprioInfosResults = [];
          let proprioInfosResult = {};

          const getCsvProprietaires = () => {
            if (idcommune != '' && scope.isProprietairesAutorized) {
              MajicFactory.getproprietairesCsv(
                idcommune,
                idparcelle,
                idcompte,
                scope.coprops
              ).then(
                (res) => {
                  scope.proprioInfosResults = proprioInfosResults = res.data;

                  const dataColumn = {};
                  dataColumn[idCommuneLabel] = idcommune;
                  dataColumn[sectionLabel] = parcelleInfosResult.section;
                  dataColumn[parcelleLabel] = parcelleInfosResult.numParcelle;

                  dataColumn[numVoirieLabel] =
                    parcelleInfosResult.numRue + ' ' + parcelleInfosResult.btq;
                  dataColumn[libelleVoieLabel] = parcelleInfosResult.nomRue;
                  dataColumn[communeLabel] = parcelleInfosResult.commune;
                  dataColumn[dateActeLabel] = parcelleInfosResult.dateActe;

                  if (proprioInfosResults.length > 0) {
                    for (let j = 0; j < proprioInfosResults.length; j++) {
                      proprioInfosResult = proprioInfosResults[j];

                      const dataColumnWithProprio = angular.copy(dataColumn);
                      dataColumnWithProprio[nomProprioLabel] =
                        proprioInfosResult.nom;
                      dataColumnWithProprio[nomNaissProprioLabel] =
                          proprioInfosResult.nomProp;
                      dataColumnWithProprio[adresseProprioLabel] =
                        proprioInfosResult.nomRue +
                        ' ' +
                        proprioInfosResult.compRue +
                        ', ' +
                        proprioInfosResult.nomVille +
                        ' ' +
                        proprioInfosResult.compVille;
                      dataColumnWithProprio[dateNaissProprioLabel] = proprioInfosResult.dateProp;
                      dataColumnWithProprio[lieuNaissProprioLabel] = proprioInfosResult.villeProp;

                      csvSourceArray[
                        csvSourceArray.length
                      ] = dataColumnWithProprio;
                    }
                  } else {
                    csvSourceArray[csvSourceArray.length] = dataColumn;
                  }

                  treatNextParcelle();
                },
                (reason) => {
                  console.log('VueProprietaire echec : ' + reason.message);
                  require('toastr').error('VueProprietaire:' + reason.message);
                  mainPromise.reject('');
                }
              );
            } else {
              treatNextParcelle();
            }
          }

          return mainPromise.promise;
        };

        // ////////////////////////////////////////////////////////////
        // Fonctionnalité des rapports
        // ///////////////////////////////////////////////////////////

        /**
         * Lance la génération du rapport de la matrice cadastrale
         * Récupère la configuration quand on utilise l'outil "Edition Metier"
         * @constructor
         * @see getMatCad
         */
        scope.MatCad = () => {
          if (!scope.MatCadReportName) {
            scope.getConfig().then(
                () => {
                  // Nom des rapports Jasper
                  const reportsNames = MajicFactory.getReportNames(
                      scope.config);
                  if (reportsNames.has('MatCadReportName')) {
                    scope.MatCadReportName = reportsNames.get(
                        'MatCadReportName');
                  }
                  getMatCad();
                }
            )
          } else {
            getMatCad();
          }
        };

        /**
         * Lance la génération de l'extrait individuel de propriété
         * Récupère la configuration quand on utilise l'outil "Edition Metier"
         * @constructor
         * @see getRelProp
         */
        scope.RelProp = () => {
          if (!scope.RelPropReportName) {
            scope.getConfig().then(
                () => {
                  const reportsNames = MajicFactory.getReportNames(
                      scope.config);
                  if (reportsNames.has('RelPropReportName')) {
                    scope.RelPropReportName = reportsNames.get(
                        'RelPropReportName');
                    getRelProp();
                  }
                }
            );
          } else {
            getRelProp();
          }
        };

        function getMatCad(){
          if (idcommune != '' && idcompte != '') {
            var data = {};
            data['idcomm'] = idcommune;
            data['idcompte'] = idcompte;
            // TODO : Mettre en config le nom du rapport
            ReportFactory.getreport(
                data,
                scope.MatCadReportName,
                'majic',
                false,
                'pdf'
            ).then(
                function(data, status) {
                  var resultObject = data.data;
                  var blob = new Blob([resultObject], {
                    type: 'application/pdf',
                  });
                  var objectUrl = URL.createObjectURL(blob);
                  window.open(objectUrl);
                  // Libération de la mémoire de
                  // l'objet URL
                  // window.URL.revokeObjectURL();
                },
                function(reason) {
                  var resultObject = reason;
                  console.log(
                      'MatCad:Une erreur est survenue lors de la requete de génération du rapport: ' +
                      resultObject
                  );
                  require('toastr').error(
                      'Une erreur est survenue lors de la requete de génération du rapport: ' +
                      resultObject
                  );
                }
            );
          } else {
            alert('Veuillez choisir une parcelle.');
            return;
          }
        }

        function getRelProp(){
          if (idcommune != '' && idcompte != '') {
            var data = {};
            data['idcomm'] = idcommune;
            data['idcompte'] = idcompte;
            // TODO : Mettre en config le nom du rapport
            ReportFactory.getreport(
                data,
                scope.RelPropReportName,
                'majic',
                false,
                'pdf'
            ).then(
                function(data, status) {
                  var resultObject = data.data;
                  var blob = new Blob([resultObject], {
                    type: 'application/pdf',
                  });
                  var objectUrl = URL.createObjectURL(blob);
                  window.open(objectUrl);
                  // Libération de la mémoire de
                  // l'objet URL
                  // window.URL.revokeObjectURL();
                },
                function(reason) {
                  var resultObject = reason.statustext;
                  console.log(
                      'RelProp:Une erreur est survenue lors de la requete de génération du rapport: ' +
                      resultObject
                  );
                  require('toastr').error(
                      'Une erreur est survenue lors de la requete de génération du rapport: ' +
                      resultObject
                  );
                }
            );
          } else {
            alert('Veuillez choisir une parcelle.');
            return;
          }
        }

        // ////////////////////////////////////////////////////////////
        // Recherche spatiale
        // ///////////////////////////////////////////////////////////

        scope.spatialParcRes = {};
        scope.geom = {};
        scope.geomselect = {};

        scope.onSpatialEnd = function(evt) {
          if (
            scope.spatialParcRes.features == undefined ||
            scope.spatialParcRes.features.length == 0
          ) {
            require('toastr').info('Aucun résultat.');
            return;
          }
          if (!scope.spatialParcRes.addMode) {
            scope.listeParcelles.splice(0);
            SelectManager.clear();
          }
          // liste des id des parcelles dont l'utilisateur n'a pas l'accès
          let listIdParcNonAutorisees = [];
          // liste des parcelles autorisées
          const authorizedFeatures = [];
          // tableau des communes autorisées de l'utilisateur
          const inseeAutorisees = $rootScope.xgos && $rootScope.xgos.user
          && $rootScope.xgos.user.communes ? $rootScope.xgos.user.communes : [];
          // Dans le cas où aucune commune n’a été ajoutée à la liste Filtrer sur les communes
          // alors toutes les communes doivent apparaitre
          const userHasMajicResctriction = inseeAutorisees.length !== 0;

          // rempli le tableau listeParcelles pour
          // sélectionner les parcelles et alimenter la popup de consultation
          for (const selectedParc of scope.spatialParcRes.features) {
            const properties = selectedParc.properties;

            if (properties[scope.parcelleIdName] === undefined && typeof properties[scope.parcelleIdName.toUpperCase()] === 'string') {
              scope.parcelleIdName = scope.parcelleIdName.toUpperCase();
            }

            const idParcelle = properties[scope.parcelleIdName];

            //Vérifier si l'id parcelle est déja dans la liste
            const isAlreadySelected = scope.listeParcelles.some(parc => parc.Parcelle === idParcelle);

            if(!isAlreadySelected) {
              // extraire le code commune de l’identifiant parcelle = 6 premiers caractères
              // et le comparer au code commune des communes autorisées
              const userHasCommune = userHasMajicResctriction && idParcelle
                  && idParcelle.length > 5 && inseeAutorisees.includes(idParcelle.substring(0, 6));

              if (idParcelle !== undefined) {
                if (!userHasMajicResctriction || userHasCommune) {
                  // si l'utilisateur n'a pas de restrictions ou détient l'accès à cette commune
                  scope.listeParcelles.push({
                    Parcelle: idParcelle,
                  });
                  authorizedFeatures.push(selectedParc);
                } else if (userHasMajicResctriction && !userHasCommune) {
                  // si l'utilisateur a au moins une restriction mais pas d'autorisation sur cette commune
                  listIdParcNonAutorisees.push(idParcelle);
                }
              } 
            }
          }

          // Dans le cas du irouge et des outils carto du widget MAJIC, un message toaster doit indiquer
          // "Vous n'êtes pas autorisé à consulter les données MAJIC liées aux parcelles sélectionnées"
          if (listIdParcNonAutorisees.length > 0) {
            require('toastr').warning(
                $filter('translate')('tools.majicedigeo.majic.parcsNonAutorise') + ' ('
                + listIdParcNonAutorisees.length + ')');
          }
          // créé le geojson de la sélection de parcelles
          const geojson = {
            'crs': scope.spatialParcRes.crs,
            'features': authorizedFeatures,
            'totalFeatures': authorizedFeatures.length,
            'type': 'FeatureCollection'
          };
          let alias;
          geojson.realTotalFeatures = {};
          if (scope.spatialParcRes.realTotalFeatures && Object.keys(
              scope.spatialParcRes.realTotalFeatures).length > 0) {
            alias = Object.keys(scope.spatialParcRes.realTotalFeatures)[0];
          }
          geojson.realTotalFeatures[alias] = authorizedFeatures.length;

          // addMode est true si l'utilisateur appuie sur la touche Ctrl
          geojson.addMode = !!(evt && evt.mapBrowserEvent && ((evt.mapBrowserEvent.pointerEvent &&
                  evt.mapBrowserEvent.pointerEvent.ctrlKey) ||
              (evt.mapBrowserEvent.originalEvent &&
                  evt.mapBrowserEvent.originalEvent.ctrlKey)));

          // rafraîchi le geojson du scope
          scope.spatialParcRes.features = authorizedFeatures;

          //Ajout des parcelles
          SelectManager.addFeaturesFromGeojson(geojson);

          // Dans le cas du irouge et des outils carto du widget MAJIC, un message toaster doit indiquer
          // "Vous n'êtes pas autorisé à consulter les données MAJIC liées aux parcelles sélectionnées"
          if (listIdParcNonAutorisees.length > 0) {
            require('toastr').warning(
                $filter('translate')('tools.majicedigeo.majic.parcsNonAutorise') + ' ('
                + listIdParcNonAutorisees.length + ')');
          }
          // -- Quand une seule parcelle et sélectionnée, l'afficher
          // d'office.
          if (scope.listeParcelles.length === 1) {
            scope.selectedParc = undefined;
            scope.PrecParcelle();
          }
          require('toastr').info(
              scope.listeParcelles.length + ' parcelles trouvée(s).'
          );
        };

        // ////////////////////////////////////////////////////////////
        // Zoom sur la parcelle sélectionnée
        // ///////////////////////////////////////////////////////////

        scope.highLigtedFeature = undefined;
        scope.highLigthParc = function() {
          // var ftDesc =
          // FeatureTypeFactory.getFeatureByUid("a585e49c-f0f0-41b8-822d-41631527597f");
          if (scope.selectedParc == undefined) return;
          // ID mot clée? correspond à la clée primaire ?
          // var where = "ID in ('"+ scope.selectedParc.Parcelle+"')";
          var where =
            scope.parcelleIdName +
            " in ('" +
            scope.selectedParc.Parcelle +
            "')";
          var ftid = scope.parcelles_uid;
          if (ftid == undefined) ftid = scope.config.parcelles_uid;
          // Remarque: les requetes spatiales ne sont pas implémentées
          // par Query.java
          QueryFactory.data(
            ftid,
            where,
            scope.map
              .getView()
              .getProjection()
              .getCode(),
            '',
            ''
          ).then(function(res) {
            if (
              res.data.features == undefined ||
              res.data.features.length == 0
            ) {
              require('toastr').info('Aucune parcelle edigeo trouvée.');
              return;
            }

            var format = new ol.format.GeoJSON();
            var features = format.readFeatures(res.data);
            if (features && features.length > 0) {
              var feature = features[0];
              // Mise en evidence de la parcelle
              if (scope.highLigtedFeature != undefined) {
                scope.highLigtedFeature = gclayers.removehighLightFeatures(
                  scope.highLigtedFeature
                );
              }
              gclayers.addhighLightFeature(feature);
              scope.highLigtedFeature = feature;
            }
          },
          (err) => {
            console.error(err.data);
            require('toastr').error($filter('translate')('tools.majicedigeo.majic.wrongIdField'));
          });
        };

        scope.zoomOnParc = function() {
          // var ftDesc =
          // FeatureTypeFactory.getFeatureByUid("a585e49c-f0f0-41b8-822d-41631527597f");
          if (scope.selectedParc == undefined) return;
          // ID mot clée? correspond à la clée primaire ?
          // var where = "ID in ('"+ scope.selectedParc.Parcelle+"')";
          var where =
            scope.parcelleIdName +
            " in ('" +
            scope.selectedParc.Parcelle +
            "')";
          var ftid = scope.parcelles_uid;
          if (ftid == undefined) ftid = scope.config.parcelles_uid;
          // Remarque: les requetes spatiales ne sont pas implémentées
          // par Query.java
          QueryFactory.data(
            ftid,
            where,
            scope.map
              .getView()
              .getProjection()
              .getCode(),
            '',
            ''
          ).then(function(res) {
            if (
              res.data.features == undefined ||
              res.data.features.length == 0
            ) {
              require('toastr').info('Aucune parcelle edigeo trouvée.');
              return;
            }
            var format = new ol.format.GeoJSON();
            var features = format.readFeatures(res.data);
            if (features && features.length > 0) {
              var feature = features[0];
              var ext = feature.getGeometry().getExtent();
              var x = (ext[2] + ext[0]) / 2;
              var y = (ext[3] + ext[1]) / 2;
              scope.map.getView().setCenter([x, y]);
              scope.map.getView().setZoom(18);
            }
          });
        };

        /**
         * Récupère et charge la configuration depuis le fichier.
         *
         * @returns {undefined}
         */
        scope.getConfig = function() {
          var p = $q.defer();
          ConfigFactory.get('widgets', 'majic').then(
            function(res) {
              if (res.data != '') {
                scope.config = res.data;
                if (scope.config.csvParams == undefined) {
                  scope.config.csvParams = {};
                  scope.config.csvParams.csvSeparator = ',';
                }
                console.info('Configuration de Majic chargée.');
              }
              // scope.readConfig();
              scope.parcelleIdName = scope.config['parcelleIdName'];
              p.resolve(true);
            },
            function(reason) {
              console.error('Configuration de Majic non chargée:' + reason);
            }
          );
          return p.promise;
        };

        scope.selectCsvSeparatorIsNot = function(sep) {
          return scope.config.csvParams.csvSeparator !== sep;
        };

        scope.selectCsvSeparatorIs = function(sep) {
          return scope.config.csvParams.csvSeparator === sep;
        };

        scope.openCsvExportParameters = function() {
          scope.csvParamsDlg = ngDialog.open({
            template:
              'js/XG/widgets/mapapp/majic/views/config/majicConsultCsvConfig.html',
            className: 'ngdialog-theme-plain width600',
            closeByDocument: false,
            scope: scope,
          });
        };

        /**
         * Enregistrement de la configuration sur fermeture du choix de séparateur.
         */
        scope.$on('ngDialog.closed', function(event, dialog) {
          if (scope.csvParamsDlg && scope.csvParamsDlg.id === dialog.attr('id')) {
            ConfigFactory.add(scope.config, 'widgets', 'majic');
          }
        });

        scope.selectParcelleFromParent = function() {
          var p = scope.getConfig();
          p.then(function() {
            if (
              attrs.parcellefromparent != undefined &&
              attrs.parcellefromparent.length != 0
            ) {
              var parc = JSON.parse(attrs.parcellefromparent);
              var parcId = parc.properties[scope.parcelleIdName];
              scope.listeParcelles.push({
                Parcelle: parcId,
                idcommune: parcId.substr(0, 6),
                idparcelle: parcId.substr(6),
              });
              scope.PrecParcelle();
            }
          });
        };

        scope.selectParcelleFromParent();
      },
    };
  };
  majicConsult.$inject = [
    'MajicFactory',
    'ReportFactory',
    'gclayers',
    'QueryFactory',
    'ConfigFactory',
    '$q',
    '$timeout',
    '$rootScope',
    'ngDialog',
    '$filter',
    'SelectManager',
    'FeatureTypeFactory'
  ];
  return majicConsult;
});
