'use strict';
define(function() {
  var majicCopropConsult = function(MajicFactory, gaJsUtils) {
    return {
      templateUrl: 'js/XG/widgets/mapapp/majic/views/majicCopropConsult.html',
      restrict: 'E',

      //scope commun

      //methode executée au chargement de la page
      link: function(scope, element, attrs, ctrl) {
        scope.filterFunc = gaJsUtils.filterFunc;
        scope.filtercoprops = '';

        var idcommune = '';
        var idparcelle = '';

        scope.initCopropView = function() {
          if (scope.selectedParc == undefined) return;
          idcommune = scope.selectedParc.Parcelle.substr(0, 6);
          idparcelle = scope.selectedParc.Parcelle.substr(6);
          scope.tabsLocalConsult.activeTab = 0;
        };

        scope.searchCoprops = function() {
          scope.initCopropView();
          MajicFactory.getcoproprietaires(idcommune, idparcelle).then(function(
            res
          ) {
            scope.coprops = res.data;
          });
        };

        scope.showCoprop = function(prop) {
          scope.proprioInfosResult = prop;
          var iProp;
          for (iProp = 0; iProp < scope.coprops.length; iProp++) {
            scope.coprops[iProp].selected = scope.coprops[iProp] == prop;
            if (scope.coprops[iProp].selected) {
              scope.batIdCommune = idcommune;
              scope.batIdParcelle = idparcelle;
              scope.vueBatiment(prop.compte, prop.idCommune, 'locauxDesLots');
            }
          }
        };
      },
    };
  };
  majicCopropConsult.$inject = ['MajicFactory', 'gaJsUtils'];
  return majicCopropConsult;
});
