'use strict';
define(function() {
  var operiswidget = function(
    ConfigFactory,
    ngDialog,
    FeatureTypeFactory,
    gclayers,
    $window,
    QueryFactory,
    GeometryFactory,
    EditFactory,
    SelectManager
  ) {
    return {
      templateUrl: 'js/XG/widgets/mapapp/operisconnect/views/operis.html',

      restrict: 'AC',

      link: function(scope, elt, attrs, ctrl) {
        var map = scope.map;
        scope.configop = {};

        /**
         * [SIG_Cadrer description]
         * @param {[type]} _dossier    [description]
         * @param {[type]} _parcelles  [description]
         * @param {[type]} _dossierRef [description]
         */
        $window.SIG_Cadrer = function(_dossier, _parcelles, _dossierRef) {
          scope.doss = [];
          scope.parc = [];
          var form = new ol.format.GeoJSON();
          var extent = ol.extent.createEmpty();
          if (!angular.isUndefined(_dossier)) {
            var wheredoss = ''; //scope.configop.dossattr.name + "=" + _dossier.codeADS ;
            if (scope.configop.parcattr.type == 'java.lang.String') {
              wheredoss =
                scope.configop.dossattr.name + "='" + _dossier.nom + "'";
            } else {
              wheredoss = scope.configop.dossattr.name + _dossier.nom;
            }
            //QueryFactory.pdata(scope.parcelles_uid,where,map.getView().getProjection().getCode(),"","")
            QueryFactory.data(
              scope.ftiDossier.uid,
              wheredoss,
              map
                .getView()
                .getProjection()
                .getCode(),
              '',
              ''
            ).then(function(res) {
              console.log(res.data);

              if (res.data.features.length > 0) {
                res.data.features.forEach(function(feat) {
                  scope.doss.push(feat);
                  var ft = form.readFeature(feat);

                  gclayers.addhighLightFeature(ft);
                });
              } else {
                swal(
                  'Pas de correspondance ',
                  'le dossier ' + _dossier.nom + " n'existe pas dans le SIG",
                  'warning'
                );
              }
            });
          }
          if (_parcelles != null) {
            var whereparc = '';

            if (scope.configop.parcattr.type == 'java.lang.String') {
              whereparc =
                scope.configop.parcattr.name +
                " IN ('" +
                _parcelles.join("','") +
                "')";
            } else {
              whereparc =
                scope.configop.parcattr.name +
                ' IN (' +
                _parcelles.join(',') +
                ')';
            }

            //QueryFactory.pdata(scope.parcelles_uid,where,map.getView().getProjection().getCode(),"","")
            QueryFactory.data(
              scope.ftiParcelle.uid,
              whereparc,
              scope.map
                .getView()
                .getProjection()
                .getCode()
            ).then(function(res) {
              console.log(res.data);
              if (res.data.features.length > 0) {
                res.data.features.forEach(function(feat) {
                  scope.parc.push(feat);
                  var ft = form.readFeature(feat);

                  gclayers.addhighLightFeature(ft);
                });
              } else {
                swal(
                  'Pas de correspondance ',
                  'pas de correspondance de parcelles dans le SIG',
                  'warning'
                );
              }
            });
          }
        };
        /**
         * Fonction exploite par Operis connect pour ce cardrer sur de  dossiers
         * @param {[type]} _dossiers [description]
         */
        $window.SIG_CadrerDossiers = function(_dossiers) {
          //alert("ici");
          var message = '';
          var doss = [];
          if (_dossiers) {
            for (var i = 0; i < _dossiers.length; i++) {
              if (_dossiers[i]) doss.push(_dossiers[i].codeADS);
            }
            var whereparc =
              scope.configop.dossattr.name + ' IN (' + doss.join(',') + ')';
            QueryFactory.data(
              scope.ftiDossier.uid,
              whereparc,
              scope.map
                .getView()
                .getProjection()
                .getCode()
            ).then(function(res) {
              console.log(res.data);

              res.data.features.forEach(function(feat) {
                scope.doss.push(feat);
                var ft = form.readFeature(feat);

                gclayers.addhighLightFeature(ft);
              });
            });
          }
        };

        /**
         * Imprimer Dossier (NON IMPLEMENTE)
         * @param {[type]} _dossier   [description]
         * @param {[type]} _parcelles [description]
         * @param {[type]} _url       [description]
         * @param {[type]} _idImage   [description]
         * @param {[type]} _echelle   [description]
         * @param {[type]} _largeur   [description]
         * @param {[type]} _hauteur   [description]
         */
        $window.SIG_ImprimerDossier = function(
          _dossier,
          _parcelles,
          _url,
          _idImage,
          _echelle,
          _largeur,
          _hauteur
        ) {
          /*alert("SIG_ImprimerDossier(" + _dossier.nom + ", " + _parcelles.length + " parcelles)");
                var message = "Parcelles :\n";   
                for (var i = 0; i < _parcelles.length; i++)
                    message += _parcelles[i] + "\n";
                alert(message);*/

          // Retour de l'url
          var codeErreur = 0;
          var message = 0;
          if (_url == null || _url == '') {
            _url = 'http://molene/DdCV3/Serveur/www/modeles/logoOperis.png';
          }
          if (_idImage == null || _idImage == '') {
            _idImage = 'fusion_0';
          }
          getAppiaConnect().DDC_RetourImprimerDossier(
            _dossier,
            _parcelles,
            _url,
            _idImage,
            _echelle,
            _largeur,
            _hauteur,
            codeErreur,
            message
          );
        };
        /**
         * Saisie de l'implantation d'un dossier
         *
         * @param _dossier   Nom du dossier
         * @param _parcelles Parcelles du dossier (tableau)
         *
         */
        $window.SIG_ImplanterDossier = function(_dossier, _parcelles) {
          ////LogEntrant("SIG_ImplanterDossier(" + _dossier.nom + ", " + _parcelles.length + " parcelles)");
          var message = 'Parcelles :\n';
          var geometries = [];
          var form = new ol.format.GeoJSON();
          if (_parcelles != null) {
            var whereparc = '';
            if (scope.configop.parcattr.type == 'java.lang.String') {
              whereparc =
                scope.configop.parcattr.name +
                " IN ('" +
                _parcelles.join("','") +
                "')";
            } else {
              whereparc =
                scope.configop.parcattr.name +
                ' IN (' +
                _parcelles.join(',') +
                ')';
            }

            //QueryFactory.pdata(scope.parcelles_uid,where,map.getView().getProjection().getCode(),"","")
            QueryFactory.data(
              scope.ftiParcelle.uid,
              whereparc,
              scope.map
                .getView()
                .getProjection()
                .getCode()
            ).then(function(res) {
              console.log(res.data);
              var geojsonj = res.data;
              //res.data.features.forEach(function(feat)
              for (var i = 0; i < res.data.features.length; i++) {
                var feat = res.data.features[i];
                geometries.push(feat.geometry);
                scope.parc.push(feat);
                var ft = form.readFeature(feat);

                gclayers.addhighLightFeature(ft);
              }

              GeometryFactory.unionifpossible(geometries).then(
                function(res) {
                  try {
                    if (res.data) {
                      if (res.data.type == 'Polygon') {
                        res.data.type = 'MultiPolygon';
                        res.data.coordinates = [res.data.coordinates];
                      }
                      scope.result = res.data;
                      scope.dossfeature = {
                        type: 'FeatureCollection',
                        features: [
                          {
                            geometry: res.data,
                            properties: {
                              annee: _dossier.annee,
                              codeADS: _dossier.codeADS,
                              codeINSEE: _dossier.codeINSEE,
                              instructeur: _dossier.instructeur,
                              modificatif: _dossier.modificatif,
                              nom: _dossier.nom,
                              numero: _dossier.numero,
                              surfaceDeclaree: _dossier.surfaceDeclaree,
                              transfert: _dossier.transfert,
                            },
                          },
                        ],
                      };

                      var wheredoss = ''; //scope.configop.dossattr.name + "=" + _dossier.codeADS ;
                      if (scope.configop.parcattr.type == 'java.lang.String') {
                        wheredoss =
                          scope.configop.dossattr.name +
                          "='" +
                          _dossier.nom +
                          "'";
                      } else {
                        wheredoss = scope.configop.dossattr.name + _dossier.nom;
                      }
                      //QueryFactory.pdata(scope.parcelles_uid,where,map.getView().getProjection().getCode(),"","")
                      QueryFactory.data(
                        scope.ftiDossier.uid,
                        wheredoss,
                        map
                          .getView()
                          .getProjection()
                          .getCode(),
                        '',
                        ''
                      ).then(function(res) {
                        console.log(res.data);
                        if (res.data.features.length > 0) {
                          var promisedel = EditFactory.r_delete(
                            scope.ftiDossier.uid,
                            scope.configop.relation.name,
                            res.data.features[0].id,
                            false
                          );
                          promisedel.then(function(deldata) {
                            scope.dossfeature.features[0].id =
                              res.data.features[0].id;
                            scope.doss.push(scope.dossfeature.features[0]);
                            EditFactory.update(
                              scope.ftiDossier.uid,
                              scope.dossfeature,
                              scope.map
                                .getView()
                                .getProjection()
                                .getCode()
                            ).then;
                            {
                              require('toastr').success('ok');
                              //console.log(Object.keys(res.data.create[0].id));
                              //console.log(res.data.create[0]["id"]);
                              // attention il faudra mettre les bon
                              // scope.result =res.data.create[0]["id"];
                              var idf = scope.dossfeature.features[0].id;

                              EditFactory.r_add(
                                geojsonj,
                                scope.ftiDossier.uid,
                                idf,
                                scope.configop.relation.name
                              ).then(function(resrel) {
                                // last relation
                                console.log(resrel);
                                swal(
                                  'Mise à jour de dossier',
                                  'le dossier ' +
                                    scope.dossfeature.features[0].properties
                                      .nom +
                                    ' est créé',
                                  'success'
                                );
                              });
                            }
                          });
                        } else {
                          scope.doss.push(scope.dossfeature.features[0]);
                          EditFactory.add(
                            scope.ftiDossier.uid,
                            scope.dossfeature,
                            scope.map
                              .getView()
                              .getProjection()
                              .getCode(),
                            false
                          ).then(function(resi) {
                            //alert(res.data);

                            //EditFactory.r_add(senddata ,fid,idd,relname)
                            //
                            if (resi.data.create.length == 1) {
                              require('toastr').success('ok');
                              //console.log(Object.keys(res.data.create[0].id));
                              //console.log(res.data.create[0]["id"]);
                              // attention il faudra mettre les bon
                              // scope.result =res.data.create[0]["id"];
                              var idf = resi.data.create[0]['id'];

                              EditFactory.r_add(
                                geojsonj,
                                scope.ftiDossier.uid,
                                idf,
                                scope.configop.relation.name
                              ).then(function(resrel) {
                                // last relation
                                console.log(resrel);
                                swal(
                                  'Creation de Dossier',
                                  'le dossier ' +
                                    scope.dossfeature.features[0].properties
                                      .nom +
                                    ' est créé',
                                  'success'
                                );
                              });
                            }
                          }); // fin de l'ajout
                        }
                      });
                    } else {
                      scope.result = undefined;
                    }
                  } catch (e) {
                    console.error(e);
                    scope.result = undefined;
                  }
                  gaDomUtils.hideGlobalLoader();
                },
                function(res) {
                  gaDomUtils.hideGlobalLoader();
                  scope.result = undefined;
                  require('toastr').error(res.data.message);
                }
              );
            }); // FIn de la requete query
          }
          //FINSaisie de l'implantation d'un dossier

          /*  for (var i = 0; i < _parcelles.length; i++)
                    message += _parcelles[i] + "\n";
                LogEntrant(message);
                changeSrc("./img/centrage2.png");*/
        };

        scope.ftiDossier = undefined;
        scope.ftiParcelle = undefined;

        scope.doss = [];
        scope.parc = [];

        scope.configop.dossfti = {};
        scope.configop.parcfti = {};

        /**
         * [resultselectDossierParc description]
         * @return {[type]} [description]
         */
        scope.resultselectDossierParc = function() {
          console.log(scope.res);
          scope.doss = [];
          scope.parc = [];

          if (scope.res.features.length > 0) {
            scope.res.features.forEach(function(feat) {
              if (feat.id.indexOf(scope.ftiDossier.name + '.') != -1) {
                scope.doss.push(feat);
              }
              if (feat.id.indexOf(scope.ftiParcelle.name + '.') != -1) {
                scope.parc.push(feat);
              }
            });
          }
        };

        ConfigFactory.get('widgets', scope.configopName).then(function(res) {
          scope.configop = res.data;
          if (scope.configop.dossftid) {
            scope.ftiDossier = FeatureTypeFactory.getFeatureByUid(
              scope.configop.dossftid
            );
          }
          if (scope.configop.parcftid) {
            scope.ftiParcelle = FeatureTypeFactory.getFeatureByUid(
              scope.configop.parcftid
            );
          }
          console.log(res);
        });

        /**
         * Recuperation de la config
         * @return {[type]} [description]
         */
        scope.getConfig = function() {
          ConfigFactory.get('widgets', scope.configopName).then(function(res) {
            if (res.data !== '' && res.status == 200) {
              scope.configop = data;
            }
          });
        };

        /**
         * focntion zoom sur toute les parcelles
         * @return {[type]} [description]
         */
        scope.zoom_all_parc = function() {
          gclayers.clearhighLightFeatures();
          var form = new ol.format.GeoJSON();
          var extent = ol.extent.createEmpty();
          for (var i = 0; i < scope.parc.length; i++) {
            var feat = form.readFeature(scope.parc[i]);
            ol.extent.extend(extent, feat.getGeometry().getExtent());
            gclayers.addhighLightFeature(feat);
          }
          //var extent = gclayers.getHighLightLayer().getExtent();
          scope.map.getView().fit(extent, scope.map.getSize());
        };
        /**
         * Fonction de communication avec operis connect search parcelle
         * @return {[type]} [description]
         */
        scope.search_all_parc = function() {
          var dos = [];
          for (var i = 0; i < scope.parc.length; i++) {
            dos.push(scope.parc[i].properties[scope.configop.parcattr.name]);
          }
          scope.DDC_RechercherDossiersParcelles([], dos);
        };
        /**
         * Zoom sur une parcelle
         * @param  {[type]} p [description]
         * @return {[type]}   [description]
         */
        scope.zoom_parc = function(p) {
          gclayers.clearhighLightFeatures();
          var form = new ol.format.GeoJSON();
          var extent = ol.extent.createEmpty();
          var feat = form.readFeature(p);
          ol.extent.extend(extent, feat.getGeometry().getExtent());
          gclayers.addhighLightFeature(feat);
          scope.map.getView().fit(extent, scope.map.getSize());
        };
        /**
         * recherche d'une parcelle dans operis
         * @param  {[type]} p [description]
         * @return {[type]}   [description]
         */
        scope.search_parc = function(p) {
          scope.DDC_RechercherDossiersParcelles(
            [],
            [p.properties[scope.configop.parcattr.name]]
          );
        };
        /**
         * info siur une parcelle dans operis
         * @param  {[type]} p [description]
         * @return {[type]}   [description]
         */
        scope.info_parc = function(p) {
          scope.DDC_AfficherFicheParcelle(
            p.properties[scope.configop.parcattr.name]
          );
        };
        scope.select_parc = function(p) {
          SelectManager.clear();
          gclayers.clearhighLightFeatures();
          var g = { type: 'FeatureCollection', features: [] };
          g.features.push(p);
          SelectManager.addFeaturesFromGeojson(g);
          SelectManager.openpop(scope);
        };
        scope.zoom_all_doss = function() {
          gclayers.clearhighLightFeatures();
          var form = new ol.format.GeoJSON();
          var extent = ol.extent.createEmpty();
          for (var i = 0; i < scope.doss.length; i++) {
            var feat = form.readFeature(scope.doss[i]);
            ol.extent.extend(extent, feat.getGeometry().getExtent());
            gclayers.addhighLightFeature(feat);
          }
          //var extent = gclayers.getHighLightLayer().getExtent();
          scope.map.getView().fit(extent, scope.map.getSize());
        };
        scope.search_all_doss = function() {
          var dos = [];
          for (var i = 0; i < scope.doss.length; i++) {
            dos.push(scope.doss[i].properties[scope.configop.dossattr.name]);
          }
          scope.DDC_RechercherDossiersParcelles(dos, []);
        };
        scope.zoom_doss = function(p) {
          gclayers.clearhighLightFeatures();
          var form = new ol.format.GeoJSON();
          var extent = ol.extent.createEmpty();
          var feat = form.readFeature(p);
          ol.extent.extend(extent, feat.getGeometry().getExtent());
          gclayers.addhighLightFeature(feat);
          scope.map.getView().fit(extent, scope.map.getSize());
        };
        scope.select_doss = function(d) {
          SelectManager.clear();
          gclayers.clearhighLightFeatures();

          var g = { type: 'FeatureCollection', features: [] };
          g.features.push(d);
          SelectManager.addFeaturesFromGeojson(g);
          SelectManager.openpop(scope);
        };
        scope.search_doss = function(d) {
          scope.DDC_RechercherDossiersParcelles(
            [d.properties[scope.configop.dossattr.name]],
            []
          );
        };
        scope.info_doss = function(d) {
          scope.DDC_AfficherFicheDossier(
            d.properties[scope.configop.dossattr.name]
          );
        };
        /**
         * Sauvegarde de la config
         * @return {[type]} [description]
         */
        scope.saveconfig = function() {
          ConfigFactory.add(scope.configop, 'widgets', scope.configopName).then(
            function(res) {
              require('toastr').success(res.data);
              scope.getConfig();
            },
            function(reason) {
              require('toastr').error(reason);
            }
          );
        };
        /**
         * Ajout de la config
         */
        scope.addConfig = function() {
          getAppiaConnect().DDC_RechercherDossiersParcelles('123145');
          /*scope.configop.ggg ="fjklfjdlkfjdlk";
              scope.configop.pff =scope.configopName;
              ConfigFactory.add(scope.configop,"widget",scope.configopName);*/
        };
        var ngDialogPromise = null;
        /**
         * Ouverture de la config
         * @return {[type]} [description]
         */
        scope.openConfig = function() {
          //console.log(scope.configop.url);
          //readKisGeocodageConfig();
          ConfigFactory.get('widgets', scope.configopName).then(function(res) {
            ngDialogPromise = ngDialog.openConfirm({
              template:
                'js/XG/widgets/mapapp/operisconnect/views/configuration.html',
              className: 'ngdialog-theme-plain width800 nopadding miniclose',
              scope: scope,
            });
            ngDialogPromise.then(
              function(data) {
                scope.configop = data;
                scope.saveconfig();
                //require('toastr').success(data);
              }
              /*function(data){
                                scope.getConfig();
                                require('toastr').info(data);
                            }*/
            );
          });
        };

        /**
         * Appel de la fonction DDC : RechercherDossiersParcelles
         *
         * @param _dossiers  Tableau des dossiers à rechercher
         * @param _parcelles Tableau des parcelles à rechercher
         *
         */
        scope.DDC_RechercherDossiersParcelles = function(
          _dossiers,
          _parcelles
        ) {
          var codeErreur = 0;
          var message = 0;
          getAppiaConnect().DDC_RechercherDossiersParcelles(
            _dossiers,
            _parcelles,
            codeErreur,
            message
          );
        };

        /**
         * Appel de la fonction DDC : Operis_RetourIMC
         *
         * @param _dossiers  Tableau des dossiers à rechercher
         * @param _parcelles Tableau des parcelles à rechercher
         *
         */
        scope.Operis_RetourIMC = function(
          _xml,
          _urlxml,
          _dossier,
          _codeErreur,
          _message
        ) {
          var codeErreur = 0;
          var message = 0;
          getAppiaConnect().Operis_RetourIMC(
            _xml,
            _urlxml,
            _dossier,
            _codeErreur,
            _message
          );
        };

        /**
         * Appel de la fonction Operis : RechercherDossiersParcelles
         *
         * @param _dossiers  Tableau des dossiers à rechercher
         * @param _parcelles Tableau des parcelles à rechercher
         *
         */
        scope.OP_RechercherDossiersParcelles = function(_dossiers, _parcelles) {
          var codeErreur = 0;
          var message = 0;
          getAppiaConnect().OP_RechercherDossiersParcelles(
            'Oxalis',
            _dossiers,
            _parcelles,
            codeErreur,
            message
          );
        };

        /**
         * Appel de la fonction DDC : AfficherFicheParcelle
         *
         * @param _parcelle Parcelle dont on demande la fiche
         *
         */
        scope.DDC_AfficherFicheParcelle = function(_parcelle) {
          var codeErreur = 0;
          var message = 0;
          getAppiaConnect().DDC_AfficherFicheParcelle(
            _parcelle,
            codeErreur,
            message
          );
        };

        /**
         * Appel de la fonction DDC : AfficherFicheDossier
         *
         * @param _dossier Parcelle dont on demande la fiche
         *
         */
        scope.DDC_AfficherFicheDossier = function(_dossier) {
          var codeErreur = 0;
          var message = 0;
          getAppiaConnect().DDC_AfficherFicheDossier(
            _dossier,
            codeErreur,
            message
          );
        };

        /**
             * Appel de la fonction DDC : MajReglementsParcelle
             * 
             * @param _parcelle Parcelle dont on met à jour les règlements
             * @param _reglements les règlements sous forme de tableau, chaque ligne représentant les attributs d'un règlement
             séparés par des ';'
             *
             */
        scope.PLU_MajReglementsParcelle_debut = function() {
          //message de début
          getAppiaConnect().PLU_MajReglementsParcelle(
            null,
            null,
            null,
            'PLU_MajReglementsParcelle_debut'
          );
        };
        scope.PLU_MajReglementsParcelle = function(_parcelle, _reglements) {
          var codeErreur = 0;
          var message = 0;
          //gestion de la synchro pour traiter par lot la quantité de données qui peut être importante
          //envoyer ligne par ligne, parcelle par parcelle, un seul règlement à la fois
          getAppiaConnect().PLU_MajReglementsParcelle(
            _parcelle,
            _reglements,
            codeErreur,
            message
          );
        };
        scope.PLU_MajReglementsParcelle_fin = function() {
          //message de fin
          getAppiaConnect().PLU_MajReglementsParcelle(
            null,
            null,
            null,
            'PLU_MajReglementsParcelle_fin'
          );
        };

        /**
         * Appel de la fonction VISDGI : RechercherParcelles
         *
         * @param _parcelles Tableau des parcelles à rechercher
         *
         */
        scope.VISDGI_RechercherParcelles = function(_parcelles) {
          var codeErreur = 0;
          var message = 0;
          getAppiaConnect().VISDGI_RechercherParcelles(
            _parcelles,
            codeErreur,
            message
          );
        };

        /**
         * Appel de la fonction VISDGI : AfficherRelevePropriete
         *
         * @param _parcelle Parcelle dont on demande le relevé de propriété
         *
         */
        scope.VISDGI_AfficherRelevePropriete = function(_parcelle) {
          var codeErreur = 0;
          var message = 0;
          getAppiaConnect().VISDGI_AfficherRelevePropriete(
            _parcelle,
            codeErreur,
            message
          );
        };
      },
    };
  };

  operiswidget.$inject = [
    'ConfigFactory',
    'ngDialog',
    'FeatureTypeFactory',
    'gclayers',
    '$window',
    'QueryFactory',
    'GeometryFactory',
    'EditFactory',
    'SelectManager',
  ];
  return operiswidget;
});
