'use strict';
define(function() {
  var selectinterv = function(
    gcStyleFactory,
    $http,
    SelectManager,
    gclayers,
    gcInteractions,
    PortalsFactory
  ) {
    return {
      templateUrl:
        'js/XG/widgets/mapapp/simpleIntervention/views/selectinterv.html',
      restrict: 'A',
      scope: {
        fti: '=fti',
        map: '=map',
        result: '=result',
        toolbarwidget: '=?',
      },

      link: function(scope) {
        scope.selectinterv = () => {
          var map = scope.map;
          scope.isActive = true;
          scope.dragBox = new ol.interaction.DragBox({
            condition: function(evt) {
              //MacEnvironments don't get here because the event is not
              //recognized as mouseEvent on Mac by the google closure.
              //We have to use the apple key on those devices
              return (
                evt.originalEvent.ctrlKey || scope.isActive
              ); /* ||
                      (gaBrowserSniffer.mac && evt.originalEvent.metaKey);*/
            },
            style: gcStyleFactory.getStyle('selectrectangle'),
          });

          scope.dragBox.set('gctype', 'kis');
          scope.dragBox.set('interaction', 'Select');
          scope.dragBox.set('widget', 'simpleintervention');
          scope.dragBox.setActive(true);
          gcInteractions.setCurrentToolBar(scope.toolbarwidget);
          map.addInteraction(scope.dragBox);

          scope.dragBox.on('boxend', function() {
            // URL de rcup des objets
            var res = '';
            scope.fti.forEach(function(fType) {
              res = res + fType.name + ',';
            });
            res = res.substr(0, res.length - 1);
            console.log(res);

            var catchments_url =
              '/services/' +
              PortalsFactory.getPortalId() +
              '/geoserver/ows?service=WFS&version=1.0.0&request=GetFeature&typeName=' +
              res +
              '&outputformat=json&srsName=' +
              map
                .getView()
                .getProjection()
                .getCode() +
              '&bbox=' +
              scope.dragBox.getGeometry().getExtent() +
              ',' +
              map
                .getView()
                .getProjection()
                .getCode();

            var promise = $http.get(catchments_url);
            promise.then(function(res) {
              scope.result = res.data;
              if (!SelectManager.isGeojsonEmpty(res)) {
                SelectManager.addFeaturesFromGeojson(res.data);
              }
            });
            scope.dragBox.setActive(false);
            map.removeInteraction(scope.dragBox);
          });
        };
      },
    };
  };

  selectinterv.$inject = [
    'gcStyleFactory',
    '$http',
    'SelectManager',
    'gclayers',
    'gcInteractions',
    'PortalsFactory',
  ];
  return selectinterv;
});
