'use strict';

define(function() {
  var tierceService = function() {
    this.$get = function($compile, ngTableParams) {
      /*
       *
       */
      var popup = function(options) {
        var uniqueID = new Date();
        var myRandom = Math.floor(Math.random() * 1000);
        var iddiv = uniqueID.getTime() + '' + myRandom;

        // Construct panel containt
        var htmlelement =
          '<div id="' +
          iddiv +
          '" class="popup" role="tablist" aria-multiselectable="true" bs-collapse  ng-style="pos">' +
          '<div class="panel panel-default"  ga-draggable ga-draggable-zone="#' +
          iddiv +
          'zone">' +
          '<div class="panel-heading" role="tab" id="' +
          iddiv +
          'zone"> ' +
          '   <div class="input-group input-group-sm popup_header" >' +
          '<span class="form-control" aria-label="" > ' +
          options.title +
          '</span>' +
          '     <span class="input-group-addon" >' +
          '<span class="glyphicon glyphicon-minus"  bs-collapse-toggle></span>' +
          '</span>' +
          '<span class="input-group-addon"  >' +
          '<span class="glyphicon glyphicon-remove" ng-click="options.close(' +
          iddiv +
          ');options.onclose()"></span>' +
          '</span></div>' +
          '</div>' +
          '<div class="panel-collapse" role="tabpanel" bs-collapse-target>' +
          '<div class="panel-body"  >';

        // include template html ?
        if (!angular.isUndefined(options.template)) {
          htmlelement =
            htmlelement +
            '    <div  class="thebody" ng-include=""  src="\'' +
            options.template +
            '\'" onload=""> </div>';
        }

        // include <div> content ?
        if (!angular.isUndefined(options.content)) {
          htmlelement =
            htmlelement +
            '    <div  class="thebody" > ' +
            options.content +
            '</div>';
        }

        // Close <div>
        htmlelement = htmlelement + '  </div>' + '</div>' + '</div>' + '</div>';

        var element = angular.element(htmlelement);

        options.ID = uniqueID;

        /*
         *
         */
        options.close = function(_uniqueID) {
          //console.log(this);
          console.log('Close panel with id : ' + _uniqueID);

          $('#' + _uniqueID).remove();
        };

        /*
         *
         */
        options.closePopup = function() {
          $('#' + options.ID).remove();
        };

        this.scope = options.scope;

        // Gestion du bouton ferme
        if (angular.isUndefined(options.showClose)) {
          options.showClose = true;
        }

        this.scope.options = options;

        this.element = $compile(element)(this.scope);

        $(document.body).append(this.element);
      };

      /*
       *
       */
      popup.prototype.close = function() {
        this.element.remove();
        this.element = null;
      };

      /*
       *
       */
      popup.prototype.destroy = function() {
        this.element.remove();
        this.element = null;
      };

      // Exposed functions
      return {
        open: function(options) {
          return new popup(options);
        },
      };
    };
    this.$get.$inject = ['$compile', 'ngTableParams'];
  };
  return tierceService;
});
