'use strict';
define([
  'angular',
  'widgets/sirocoapp/export/controllers/printCtrl',
  'widgets/sirocoapp/export/controllers/sitesListctrl',
  'widgets/sirocoapp/export/controllers/scheduleCtrl',
  'widgets/sirocoapp/export/controllers/exportCtrl',
], function(angular, printCtrl, sitesListctrl, scheduleCtrl, exportCtrl) {
  // Module
  var mod = angular.module('siroco_export', []);

  // Controllers
  mod.controller('printCtrl', printCtrl);
  mod.controller('sitesListctrl', sitesListctrl);
  mod.controller('scheduleCtrl', scheduleCtrl);
  mod.controller('exportCtrl', exportCtrl);

  //route provider
  mod.config([
    '$routeProvider',
    function($routeProvider) {
      $routeProvider.when('/siroco/print', {
        templateUrl: 'js/XG/widgets/sirocoapp/export/views/print.html',
        controller: printCtrl,
      });
      $routeProvider.when('/siroco/sites_list', {
        templateUrl: 'js/XG/widgets/sirocoapp/export/views/sites_list.html',
        controller: sitesListctrl,
      });
      $routeProvider.when('/siroco/schedule', {
        templateUrl: 'js/XG/widgets/sirocoapp/export/views/schedule.html',
        controller: scheduleCtrl,
      });
      $routeProvider.when('/siroco/gis', {
        templateUrl: 'js/XG/widgets/sirocoapp/export/views/gis.html',
        controller: exportCtrl,
      });
    },
  ]);
  return mod;
});
