'use strict';
define(function() {
  var gcelement = function(
    gcformfunction,
    FeatureTypeFactory,
    $q,
    $filter,
    $timeout,
    $rootScope,
    AssociationFactory,
    RightsFactory,
    ngDialog,
    formFunctionUtils,
    NetworkFactory,
    gaJsUtils
  ) {
    return {
      templateUrl: 'js/XG/widgets/utilities/form/views/formFieldRender.html',
      restrict: 'A',
      scope: {
        map: '=map',
        fti: '=fti',
        ftid: '=ftid',
        res: '=res',
        initvalue: '=initvalue',
        templatefields: '=templatefields',
        // Utilisé pour cacher le label du bouton enregistrer lorsque l'utilisateur n'a pas les droits
        userHasWriteRights: '=?',
        editsession: '=editsession',
        onvalidate: '&',
        editable: '=',
        currentbranch: '=',
        currenttab: '=',
        dropped: '=',
        formvariables: '=',
        feattree: '=treeControl',
        templateEvents: '=?',
        ftisToUse: '=?',
        noDefaultEdit: '=?', // For datatable hide edit button
        toolBarWidget: '=?toolbarwidget',
        relationholddata: '=relationholddata',
        chainpopup: '=chainpopup',
        editdescription: '=editdescription',
        uploadfile: '=',
        removedfile: '=',
        alltemplatefields: '=?',
        formName: '=?',
        dlgPopup: '=',
        templateform: '=',
        objectres: '=res'
      },
      link: function(scope) {
        scope.ftisData = {};


        /**
         * When the templatefields are loaded, we store the info about all the featuretypes which will be used
         * This is useful in the builder, for example to allow to edit an fti.attribute according to its type (text/textarea)
         */
        scope.refreshCfgButtonOnLoad = () => {
          scope.resetCfgButton = true;
          $timeout(function() {
            scope.resetCfgButton = false;
          });
        };

        const defaultRightDataclassic = [
          {name : 'setUserAttribut', label:'preValidationFunction.setUserAttribut'},
          {name : 'setUserCreationOnly', label:'preValidationFunction.setUserCreationOnly'}
        ];

        const defaultRightDataDate = [
          {name : 'setDateAttribut', label:'preValidationFunction.setDateAttribut'},
          {name : 'setDateCreationOnly', label:'preValidationFunction.setDateCreationOnly'}
        ];

        const typeDate = ['java.util.Date', 'java.sql.Timestamp', 'java.sql.Time', 'java.sql.Date'];
        const version = 1.0;

        let getFieldTypeAssociatedRightData = (field) =>{
          if(field && field.config && field.config.ftid && field.config.name) {
            let ftd = FeatureTypeFactory.getFeatureByUid(field.config.ftid);
            if(ftd && ftd.attributes){
              let att = ftd.attributes.find(x => x.name === field.config.name);
              if(att && att.type && typeDate.includes(att.type)){
                return angular.copy(defaultRightDataDate);
              }
            }
          }
          return angular.copy(defaultRightDataclassic);
        }

        scope.$watch(
          'templatefields',
          function(tf) {
            if (typeof tf != 'undefined' && angular.isArray(tf.fields)) {
              tf.fields.forEach(function(field) {
                if(angular.isDefined(field.type) && field.type === "attribute"){
                  let defaultRightData = getFieldTypeAssociatedRightData(field);
                  if(!angular.isDefined(field.preValidationFunction) || !angular.isDefined(field.preValidationFunction.leftData) ||
                    !angular.isDefined(field.preValidationFunction.version) || field.preValidationFunction.version<version){
                    field.preValidationFunction = {
                      leftData: [],
                      leftDisplayAttribute: 'label',
                      rightData: angular.copy(defaultRightData),
                      rightDisplayAttribute: 'label',
                      leftTitle: 'dom.input.preValidationFunctionLeft',
                      rightTitle: 'dom.input.preValidationFunctionRight',
                      source: 'right',
                      version : version
                    };
                  } else if (field.preValidationFunction.leftData.length + field.preValidationFunction.rightData.length < defaultRightData.length){
                    defaultRightData.forEach(element => {
                      let leftpos = field.preValidationFunction.leftData.map((e) => { return e.name; }).indexOf(element.name);
                      let rightpos = field.preValidationFunction.rightData.map((e) => { return e.name; }).indexOf(element.name);
                      if(rightpos === -1 && leftpos === -1){
                        field.preValidationFunction.rightData.push(element);
                      }
                    });
                  }
                }
                if (
                  field.config.ftid &&
                  !(field.config.ftid in scope.ftisData)
                ) {
                  var ftData = angular.copy(
                    FeatureTypeFactory.getFeatureByUid(field.config.ftid)
                  );
                  // make the attributes as an object
                  if (ftData) {
                    var newAttributesObject = {};
                    if (angular.isArray(ftData.attributes)) {
                      ftData.attributes.forEach(function(attr) {
                        newAttributesObject[attr.name] = attr;
                      });
                    }
                    ftData.attributes = newAttributesObject;
                    scope.ftisData[field.config.ftid] = ftData;
                  }
                }
                // if it's the save button -> set default object to 'current'
                if (field.config && (field.config.hasOwnProperty("beforefinish")
                  || field.config.hasOwnProperty("finish")) && field.config.feats === undefined) {
                  field.config.feats = 'current';
                }
              });
            }
          },
          1
        );
        scope.addtoArray = function(array, elem) {
          if (angular.isUndefined(array)) {
            array = [];
          }
          array.push(elem);
          try {
            scope.$apply();
          } catch(err) {}
        };

        scope.isDateType = (field) => {
          if (gaJsUtils.notNullAndDefined(scope.ftisData[field.config.ftid].attributes[field.config.name])) {
            return typeDate.includes(scope.ftisData[field.config.ftid].attributes[field.config.name].type);
          }
          return false;
        }

        // dropzone classes
        scope.editableClass = scope.editable ? 'builderDropZone notinatab' : '';
        scope.$watch('currenttab', function(ct) {
          if (scope.editable) {
            if (ct !== -1)
              scope.editableClass = scope.editableClass.replace(
                'notinatab',
                ''
              );
          }
        });

        /**
         * Remove a dragged object by
         * - removing it from the current dropZone
         * - removing the dropped reference
         * @param removeIndex
         */
        scope.removeDragged = function(removeIndex) {
          var toRemove = scope.templatefields.fields[removeIndex],
            droppedIndex = toRemove.type + '#' + toRemove.config.name;

          // only if dropped index does exist
          // TODO: that should always happen, we need to rebuild the dropped index when opening the form
          if (scope.dropped[droppedIndex]) {
            // remove from the list of droppedElements
            // -- The form component was dropped only once, we can remove it from the dropped list
            if (scope.dropped[droppedIndex].length === 1) {
              delete scope.dropped[toRemove.type + '#' + toRemove.config.name];
              // The form component was dropped multiple times, delete only the correct reference
            } else {
              var found = false;
              scope.dropped[droppedIndex].forEach(function(d, innerindex) {
                if (!found) {
                  if (
                    d.branch.uid === scope.currentbranch.uid &&
                    d.tab === scope.currenttab
                  ) {
                    // found the correct dropped reference to remove
                    scope.dropped[droppedIndex].splice(innerindex, 1);
                    found = true;
                  }
                }
              });
            }
          }

          // remove from the actual fieldList
          scope.templatefields.fields.splice(removeIndex, 1);
        };

        /**
         * Move the @index field in @direction
         * @param index
         * @param direction
         */
        scope.moveField = function(index, direction) {
          if (
            (index === 0 && direction === 'up') ||
            (index === scope.templatefields.fields.length - 1 &&
              direction === 'down')
          )
            return false;
          const newIndex = direction === 'up' ? index - 1 : index + 1;
          scope.templatefields.fields.splice(
            index,
            0,
            scope.templatefields.fields.splice(newIndex, 1)[0]
          );
        };

        scope.closeCfgPopovers = function() {
          // Hide popover
          // We should not '.remove()' the popover because it causes bugs on <select> containing ng-repeat.
          $('.popover').hide();
        };

        /**
         * Check whether we need to display the restrictions sorting options in the attribute configuration
         * @param attribut
         */
        scope.displayAttributeCfgRestrictionSort = function(attribut) {
          let display = false;

          if (attribut && Array.isArray(attribut.restrictions) && attribut.restrictions.length > 0) {
            display = attribut.restrictions.some(r => r.type === 'Tables');
          }
          return display;
        };

        /**
         * Evaluate Expressions
         * @param expressions
         * @param fields
         * @param selectedObject
         */
        scope.evaluateExpression = function(
          expressions,
          fields,
          selectedObject
        ) {
          const def = $q.defer();

          $timeout(() => {
            const objects = {
              res: scope.res,
              feattree: scope.feattree,
              map: scope.map,
            };

            if (angular.isDefined(selectedObject)) {
              objects.selectedObject = selectedObject;
            }

            if (angular.isDefined(expressions)) {
              if (isFtiUndefinedOrEmpty() && formFunctionUtils.someFunctionRequireFti(expressions)) {

                // récupère un tableau de fti ou ftis[i] est le fti de "current" de la fonction expressions[i]

                // récupère les champs quelque soit la structure du formulaire
                let tabs = scope.alltemplatefields.tabs;
                if (!tabs && scope.templatefields.hasOwnProperty('fields')) {
                  tabs = [{fields: scope.templatefields.fields}];
                }
                const ftis = formFunctionUtils.findRequiredFtis(expressions, tabs);

                gcformfunction.evaluateExpression(expressions, objects, scope.templatefields, ftis)
                .then(() => {def.resolve();});
              } else {
                gcformfunction
                .evaluateExpression(expressions, objects, scope.templatefields, scope.fti)
                .then(function() {
                  def.resolve();
                });
              }
            } else {
              def.resolve();
            }
          });

          return def.promise;
        };

        // TRADUIRE DANS LE JS
        // $filter('translate')('tools.ddqwdqw.dqwdqwdqwd')   tools.builder.fields.common
        scope.restrictionsSortTypes = [
          {
            name: $filter('translate')('tools.builder.fields.common.sort.type'),
            id: 'type',
          },
          {
            name: $filter('translate')(
              'tools.builder.fields.common.sort.alpha'
            ),
            id: 'alpha',
          },
          {
            name: $filter('translate')('tools.builder.fields.common.sort.num'),
            id: 'num',
          },
          {
            name: $filter('translate')('tools.builder.fields.common.sort.date'),
            id: 'date',
          },
        ];

        scope.restrictionsSortOrder = [
          {
            name: $filter('translate')('tools.builder.fields.common.sort.asc'),
          },
          {
            name: $filter('translate')('tools.builder.fields.common.sort.desc'),
          },
        ];

        scope.toggleRestrictionSort = function(
          restrictionSort_value,
          field_config
        ) {
          if (restrictionSort_value === false) {
            delete field_config.sort;
          } else {
            field_config.sort = {
              type: 'type',
              order: 'ASC',
            };
          }
        };

        scope.shouldIClearFixFields = function($index) {
          let _f = scope.templatefields.fields;

          // element est 50%
          if (_f[$index].wrapperWidth) {
            // si le suivant n'est pas 50% ou n'existe pas, on clearfix
            if (
              !angular.isDefined(_f[$index + 1]) ||
              !angular.isDefined(_f[$index + 1].wrapperWidth)
            ) {
              return true;
            }
          }

          return false;
        };

        scope.getField = function (field) {
          if(scope.ftisData  && field  && field.config && field.config.ftid
              && field.config.name && scope.ftisData[field.config.ftid]
              && scope.ftisData[field.config.ftid].attributes
              && scope.ftisData[field.config.ftid].attributes[field.config.name]) {
            field.restrictionKeyAsInt = scope.ftisData[field.config.ftid].attributes[field.config.name].type === 'java.lang.Integer';
          }
          // Enlève le droit en écriture dans le formulaire si besoin
          if (!RightsFactory.isAllowedToWriteAttributesInFeature($rootScope.xgos.user,
              field.config.ftid, field.config.name)) {
            field.readonly = true;
          }
          return field;
        };

        scope.readRightsOnField = (field) => {
          return RightsFactory.isAllowedToReadAttributesInFeature($rootScope.xgos.user,
              field.config.ftid, field.config.name)
        };

        scope.initVariableAssociation = (field) =>{
          if($rootScope.xgos.portal && $rootScope.xgos.portal.parameters &&
            $rootScope.xgos.portal.parameters.mainDB){
              AssociationFactory.getAll($rootScope.xgos.portal.parameters.mainDB).then((res) => {
                scope.associations = res.data;
                scope.selectedAssociation = res.data.find(ass =>  ass.name === field.config.name);
                scope.nameOtherAssociationTable = scope.selectedAssociation.atable === field.config.ftiname?
                                                      scope.selectedAssociation.btable:scope.selectedAssociation.atable;
                scope.ftiOtherAssociationTable = FeatureTypeFactory.getFeatureByName(scope.nameOtherAssociationTable);
              });
          }
        }

        /**
         * diplay a dialog where you can choose a form
         * @param {*} index index of the field
         */
        scope.openDialogToPickForm = (index) => {
          scope.formSelectionResultIndex = index;
          ngDialog.open({
            template:
              'js/XG/widgets/utilities/form/views/modal/builderOpen.html',
            className: 'ngdialog-theme-plain width1000 nopadding miniclose',
            closeByDocument: false,
            scope: scope,
          });
        };

        /**
         * load the list of all network names
         */
        scope.loadNetworkNames = () => {
          NetworkFactory.getAllNetworkNames().then(res => {
            scope.networkNames = res.data;
          }, error => {
            require('toastr').error('tools.builder.fields.network.error_network_list');
            console.error("can't load network list");
          });
        };

        /**
         * callcack for form selection
         * @param {*} selected
         */
        scope.openForm = (selected) => {
          if (scope.templatefields.fields[scope.formSelectionResultIndex]) {
            scope.templatefields.fields[scope.formSelectionResultIndex].formToOpen = selected;
          }
        }

        scope.$on('evaluateFormBuilder', function(e, data){
          if (data && data.fields){
            scope.evaluateExpression(data.expressions,data.fields);
          }else{
            scope.evaluateExpression(data.expressions);
          }
        });



        /**
         * Vérifie si l'objet fti du scope est vide (ne possédant pas de propriétés).
         * L'objet <code>scope.fti</code> est vide lorsque l'objet en cours d'édition dans le formulaire n'est pas enregistré
         * @return {boolean} true si l'objet <code>scope.fti</code> ne possède aucune propriété
         */
        const isFtiUndefinedOrEmpty = () => {
          return scope.fti === null || scope.fti === undefined || (scope.fti && Object.entries(scope.fti).length === 0);
        };

        scope.$on('callUpdateRelatedField', (event, fieldToUpdate) => {
          scope.$broadcast('updateRelatedField', fieldToUpdate);
        });

        /**
         * En présence d'un champ de type "bouton" sur une demi-colonne,
         * au conteneur du champ de classe ".field" on attribue la hauteur du champ situé sur la même ligne.
         * On ne tient pas compte du cas où le champ voisin est aussi un bouton (car cela s'annule)
         * @param {number} fieldIndex rang du champ de type "bouton" dans le tableau des champs du formulaire
         */
        scope.setWrappedButtonDivHeight = (fieldIndex) => {
          const currentFieldId = (scope.templatefields && scope.templatefields.title ? scope.templatefields.title + '-' : '') + 'fww-' + fieldIndex;
          const currentField = document.getElementById(currentFieldId);
          const currentRect = currentField.getBoundingClientRect();

          /**
           * METHODE IMBRIQUEE factorisant le code commun de l'évaluation des champs précédent et suivant
           * Dans le cas d'un champ de type "bouton" sur une demi-colonne.<br>
           * Renvoie la hauteur du champ voisin partageant la même ligne du formulaire
           * (champ précédent ou champ suivant).
           * Si le champ voisin est aussi un bouton, alors on renvoie la hauteur minimale (hauteur du bouton + padding)
           * @param {number} siblingIndex rang du champ voisin dans le tableau des champs du formulaire
           * @param {number} currentElementTopPosition position "top" du champ bouton situé sur une demi-colonne
           * @return {string|null} renvoie la hauteur du champ voisin
           * ou null si le champ à l'index "siblingIndex" n'est pas situé sur la même ligne que le champ de type "bouton" dont on cherche à définir la hauteur
           */
          const getSiblingInfo = (siblingIndex, currentElementTopPosition) => {
            // Vérifier le champ voisin
            const siblingId = (scope.templatefields && scope.templatefields.title ? scope.templatefields.title + '-' : '') + 'fww-' + siblingIndex;
            let sibling = document.getElementById(siblingId);
            if (sibling) {
              let siblingRect = sibling.getBoundingClientRect();
              const isHorizontallyAligned = currentElementTopPosition === siblingRect.top;

              // Si le champ voisin est à la même position verticale et affiché en "demi-colonne"
              if (isHorizontallyAligned) {
                const isButton = Array.isArray(scope.templatefields.fields)
                    && scope.templatefields.fields.length >= siblingIndex
                    && gaJsUtils.notNullAndDefined(scope.templatefields.fields[siblingIndex], 'config.name')
                    && scope.templatefields.fields[siblingIndex].config.name === 'button';

                // Si le champ voisin est un bouton
                if (isButton) {
                  const button = sibling.querySelector('.btn');
                  if (button) {
                    const buttonRect = button.getBoundingClientRect();
                    return `${buttonRect.height + 20}px`;
                  }
                }
                // dans une IS, le sibling trouvé n'est pas forcément le bon. On recherche alors le voisin sur une demi-colonne
                if (siblingRect.height === 0) {
                  sibling = document.querySelector(`#fww-${siblingIndex}.fww-1` );
                  if (sibling) {
                    siblingRect = sibling.getBoundingClientRect();
                  } else {
                    return null;
                  }
                }
                // Renvoyer la hauteur du champ voisin
                return `${siblingRect.height}px`;
              }
            }
            return null;
          };

          const previousHeight = getSiblingInfo(fieldIndex - 1, currentRect.top);
          if (previousHeight !== null) {
            return previousHeight;
          }

          const nextHeight = getSiblingInfo(fieldIndex + 1, currentRect.top);
          if (nextHeight !== null) {
            return nextHeight;
          }

          return 'inherit'; // Aucune correspondance, renvoyer 'inherit'
        };
      },
    };
  };

  gcelement.$inject = [
    'gcformfunction',
    'FeatureTypeFactory',
    '$q',
    '$filter',
    '$timeout',
    '$rootScope',
    'AssociationFactory',
    'RightsFactory',
    'ngDialog',
    'formFunctionUtils',
    'NetworkFactory',
    'gaJsUtils'
  ];
  return gcelement;
});
