'use strict';
define(function() {
  var javalangstring = function(ngDialog) {    
    return {
      templateUrl: 'js/XG/widgets/utilities/form/views/javalangstring.html',
      restrict: 'A',
      scope: {
        att: '=gcatt',
        result: '=result',
        activelabel: '=activelabel',
        initvalue: '=initvalue',
        fieldData: '=?fieldData',
        attributeData: '=?',
        missingMandatoryAttributes: '=missingmandatoryattributes',
        deleteNullDefaultValues: '&?'
      },

      link: function(scope, element, attrs, ctrl) {
        scope.restrict = false;
        scope.restricttype = '';

        var commentDialog;
        scope.openSavedCommentaries = function() {
          scope.element = {};
          scope.idAlreadySelected = [];
          scope.currentComment = scope.fieldData.commentaires;
          commentDialog = ngDialog.open({
            template:
              'js/XG/widgets/utilities/form/views/modal/modal.java_lang_string.commentaries.html',
            className: 'ngdialog-theme-plain width800 nopadding miniclose',
            closeByDocument: false,
            scope: scope,
          });
        };

        var putComment = [];
        scope.chooseComment = function() {
          scope.idAlreadySelected.forEach(function(c) {
            putComment.push(Object.values(c));
          });

          if (scope.result[scope.attributeData.name] != null) {
            putComment
              .splice(0, 0, scope.result[scope.attributeData.name])
              .join('\n');
          }
          var toPush = putComment.join('\n').toString();
          scope.result[scope.attributeData.name] = toPush;

          commentDialog.close();
          scope.currentComment.selected = {};
          putComment = [];
        };

        scope.mouseOverComment = function(id) {
          var commentHover = angular.element(
            document.querySelector('#comment_' + id)
          );
          if (!commentHover.hasClass('bg-primary'))
            commentHover.addClass('bg-info');
        };

        scope.mouseOutComment = function(id) {
          var commentHover = angular.element(
            document.querySelector('#comment_' + id)
          );
          commentHover.removeClass('bg-info');
        };

        scope.clickComment = function(id, comment) {
          var commentSelected = angular.element(
            document.querySelector('#comment_' + id)
          );
          var toCheck = 'element_' + id;

          if (angular.isDefined(scope.element[toCheck]))
            delete scope.element[toCheck];
          else scope.element[toCheck] = true;

          if (commentSelected.hasClass('bg-info'))
            commentSelected.removeClass('bg-info');

          if (commentSelected.hasClass('bg-primary')) {
            commentSelected.removeClass('bg-primary');
            scope.idAlreadySelected.forEach(function(elt, i) {
              if (Object.keys(elt) == id) {
                scope.idAlreadySelected.splice(i, 1);
              }
            });
          } else {
            commentSelected.addClass('bg-primary');
            var obj = {};
            obj[id] = comment;
            scope.idAlreadySelected.push(obj);
          }
        };

        scope.openCommentInput = function(param) {
          var childScope = scope.$new(false, scope);
          var template =
            "<textarea ng-model='result[att.name]'  style='width:500px;height:450px;'><textarea>";
          ngDialog.open({
            template: template,
            plain: true,
            scope: childScope,
            className: 'ngdialog-theme-plain width800',
          });
        };


        scope.openTextPopup = function() {
          let template;
          let childScope = scope.$new(false, scope);
          let maxLengthProperty = 'maxlength="' + scope.getMaxLength() + '"';
          let readonlyProperty = (scope.fieldData && scope.fieldData.readonly) ? "readonly" : "";
          template = "<textarea ng-model='result[att.name]' style='width:600px;height:400px;font-size: 12px;' " 
             + readonlyProperty + " "
             + maxLengthProperty + ">";
          ngDialog.open({
            template: template,
            plain: true,
            scope: childScope,
            className: 'ngdialog-theme-default openTextPopup'
          });
        };


        /**
         * get the max lenth of the attribute in the fti
         * @returns the max length
         */
        scope.getMaxLength = () => {
          if (scope.$root.xgos.sector !=="anc"
            && scope.$root.xgos.sector !== "bac") {
            if (scope.att && scope.att.size) {
              return scope.att.size;
            }
          }
          return undefined;
        };
      },
    };
  };

  javalangstring.$inject = ['ngDialog'];
  return javalangstring;
});
