'use strict';
define([
  'angular',
  'widgets/utilities/form/directives/formField',
  'widgets/utilities/form/directives/formBuilder',
  'widgets/utilities/form/directives/formBuilderVariables',
  'widgets/utilities/form/directives/formBuilderFtiArray',
  'widgets/utilities/form/directives/formBuilderFtiAttributeArray',
  'widgets/utilities/form/directives/formBuilderFtiUniqueAttributeArray',
  'widgets/utilities/form/directives/formBuilderFti',
  'widgets/utilities/form/directives/formBuilderFunction',
  'widgets/utilities/form/directives/formBuilderDatatableButtons',
  'widgets/utilities/form/directives/formComponent',
  'widgets/utilities/form/directives/formRender',
  'widgets/utilities/form/directives/formSub',
  'widgets/utilities/form/directives/formTabRender',
  'widgets/utilities/form/directives/formFieldRender',
  'widgets/utilities/form/directives/javalangstring',
  'widgets/utilities/form/directives/javalangdouble',
  'widgets/utilities/form/directives/javautildate',
  'widgets/utilities/form/directives/javalangboolean',
  'widgets/utilities/form/directives/javalanginteger',
  'widgets/utilities/form/directives/javasqltimestamp',
  'widgets/utilities/form/directives/gcattachment',
  'widgets/utilities/form/directives/gcattachments',
  'widgets/utilities/form/directives/gchyperlink',
  'widgets/utilities/form/directives/functionsBrowser',
  'widgets/utilities/form/directives/treeBranchPicker',
  'widgets/utilities/form/directives/attributeRestrictions',
  'widgets/utilities/form/directives/isReprogram',
  'widgets/utilities/form/directives/isBreadcrumb',
  'widgets/utilities/form/services/gc_formfunction',
  'widgets/utilities/form/services/formFunctionUtils',
  'widgets/utilities/form/services/gc_formfunctions/networkfunctions',
  'widgets/utilities/form/services/gc_formfunctions/editRulesFunctions',
  'widgets/utilities/form/services/gc_formfunctions/snapshotfunction',
  'widgets/utilities/form/services/gc_formfunctions/transferLayerFunctions',
  'widgets/utilities/form/services/gc_formfunctions/setDataFromCollectionFunction',
  'widgets/utilities/form/services/gc_formfunctions/setCountFromCollectionFunction',
  'widgets/utilities/form/services/gc_formfunctions/getFeaturesIntersectingFunction',
  'widgets/utilities/form/services/gc_formfunctions/setCurrentDateFunction',
  'widgets/utilities/form/services/gc_formfunctions/maintaSave2Function',
  'widgets/utilities/form/services/gc_formfunctions/setStaticDataToCollectionFunction',
  'widgets/utilities/form/services/FormsHelper',
  'widgets/utilities/form/services/gc_chainpopup',
  'widgets/utilities/form/services/dateUtils',
  'widgets/utilities/form/services/attributeRestrictionsUtils',
  'widgets/utilities/form/services/isUtils',
  'widgets/utilities/form/services/IndigauFormFactory',

  'angular-strap',
  'angular-strap.tpl',
  'ngDragDrop',
  'angular-route',
  'toastr',
  'ol3js',
  'ng-table',
], function (angular, formField, formBuilder, formBuilderVariables,
  formBuilderFtiArray, formBuilderFtiAttributeArray,formBuilderFtiUniqueAttributeArray, formBuilderFti, formBuilderFunction,
  formBuilderDatatableButtons, formComponent, formRender,
  formSub, formTabRender, formFieldRender, javalangstring,
  javalangdouble, javautildate, javalangboolean, javalanginteger,
  javasqltimestamp, gcattachment, gcattachments,gchyperlink, functionsBrowser,
  treeBranchPicker, attributeRestrictions, isReprogram, isBreadcrumb, gc_formfunction,
  formFunctionUtils, networkfunctions,
  editRulesFunctions, snapshotfunction, transferLayerFunctions, setDataFromCollectionFunction,
  setCountFromCollectionFunction, getFeaturesIntersectingFunction, setCurrentDateFunction,
  maintaSave2Function,setStaticDataToCollectionFunction, FormsHelper, gc_chainpopup,
  dateUtils, attributeRestrictionsUtils, isUtils, IndigauFormFactory
) {
  // generation du module
  //

  var formutilities = angular.module('formutilities', [
    'mgcrea.ngStrap',
    'ngRoute',
    'pascalprecht.translate',
    'ngDragDrop',
  ]);

  formutilities.directive('formField', formField);
  formutilities.directive('formBuilder', formBuilder);
  formutilities.directive('formBuilderVariables', formBuilderVariables);
  formutilities.directive('formBuilderFtiArray', formBuilderFtiArray);
  formutilities.directive('formBuilderFtiAttributeArray', formBuilderFtiAttributeArray);
  formutilities.directive('formBuilderFtiUniqueAttributeArray', formBuilderFtiUniqueAttributeArray);
  formutilities.directive('formBuilderFti', formBuilderFti);
  formutilities.directive('formBuilderFunction', formBuilderFunction);
  formutilities.directive(
    'formBuilderDatatableButtons',
    formBuilderDatatableButtons
  );
  formutilities.directive('formComponent', formComponent);
  formutilities.directive('formRender', formRender);
  formutilities.directive('formSub', formSub);
  formutilities.directive('formTabRender', formTabRender);
  formutilities.directive('formFieldRender', formFieldRender);
  formutilities.directive('javalangstring', javalangstring); // ajout factory
  formutilities.directive('javalangdouble', javalangdouble);
  formutilities.directive('javautildate', javautildate);
  formutilities.directive('javalanginteger', javalanginteger); // ajout factory
  formutilities.directive('javalangboolean', javalangboolean);
  formutilities.directive('javasqltimestamp', javasqltimestamp);
  formutilities.directive('gcattachment', gcattachment);
  formutilities.directive('gcattachments', gcattachments);
  formutilities.directive('gchyperlink', gchyperlink);
  formutilities.directive('functionsBrowser', functionsBrowser);
  formutilities.directive('treeBranchPicker', treeBranchPicker);
  formutilities.directive('attributeRestrictions', attributeRestrictions);
  formutilities.directive('isReprogram', isReprogram);
  formutilities.directive('isBreadcrumb', isBreadcrumb);
  formutilities.provider('gcformfunction', gc_formfunction);
  formutilities.provider('formFunctionUtils', formFunctionUtils);
  formutilities.provider('networkfunctions', networkfunctions);
  formutilities.provider('editRulesFunctions', editRulesFunctions);
  formutilities.provider('snapshotfunction', snapshotfunction);
  formutilities.provider('transferLayerFunctions', transferLayerFunctions);
  formutilities.provider('setDataFromCollectionFunction', setDataFromCollectionFunction);
  formutilities.provider('setCountFromCollectionFunction', setCountFromCollectionFunction);
  formutilities.provider('getFeaturesIntersectingFunction', getFeaturesIntersectingFunction);
  formutilities.provider('setCurrentDateFunction', setCurrentDateFunction);
  formutilities.provider('maintaSave2Function', maintaSave2Function);
  formutilities.provider('setStaticDataToCollectionFunction', setStaticDataToCollectionFunction);
  formutilities.provider('gcChainPopup', gc_chainpopup);

  formutilities.factory('FormsHelper', FormsHelper);
  formutilities.factory('dateUtils', dateUtils);
  formutilities.factory('attributeRestrictionsUtils', attributeRestrictionsUtils);
  formutilities.factory('isUtils', isUtils);
  formutilities.factory('IndigauFormFactory', IndigauFormFactory);

  formutilities.directive('formcompile', function($compile) {
    return {
      restrict: 'A',

      scope: {
        formObject: '=formObject',
      },
      link: function(scope, element, attrs) {
        var html = attrs.formcompile;

        //start creating an html string for our "view".
        // html = '';

        angular.forEach(scope.formObject, function(value, key) {
          scope[key] = value;
        });

        //create an angular element. (this is still our "view")
        var el = angular.element(html);

        //compile the view into a function.
        $compile(el)(scope);

        //append our view to the element of the directive.
        element.append(el);
      },
    };
  });

  return formutilities;
});
