/**
 *
 */
'use strict';
define(function() {
  var gcChainPopup = function() {
    this.$get = function($compile, $rootScope) {
      var modalProvider = null;
      var initialized = false;

      var ChainPopup = function(options) {
        var defPlacement = angular.isDefined(options.placement)
          ? options.placement
          : 'center';
        this.allClear = false;
        this.rootInstance = null;
        this.chainIndex = -1;
        this.nextInstances = [];
        this.currentInstance = null;

        var uniqueID = new Date();
        var myRandom = Math.floor(Math.random() * 1000);
        var idinstance = uniqueID.getTime() + '' + myRandom;

        var modalInstance = modalProvider({
          'data-animation': 'am-slide-right',
          'data-backdropAnimation': 'am-slide-left',
          scope: options.scope,
          title: options.title,
          template: options.template,
          keyboard: true,
          dismissable: options.showClose,
          placement: defPlacement,
          onHide: options.onclose,
          id: idinstance,
          backdrop: 'static',
        });

        this.currentInstance = this.rootInstance = modalInstance;
      };

      ChainPopup.prototype.release = function(destroyAll) {
        this.allClear = false;
        if (this.chainIndex == -1) {
          this.rootInstance.hide();
          this.rootInstance.destroy();
          this.allClear = true;
        } else {
          if (this.chainIndex == 0) {
            var instanceToClose = this.nextInstances[0];
            instanceToClose.hide();
            instanceToClose.destroy();
            this.nextInstances = [];
            if (destroyAll == true) {
              this.rootInstance.destroy();
              this.allClear = true;
            } else {
              this.currentInstance = this.rootInstance;
              this.rootInstance.show();
              this.chainIndex--;
            }
          } else {
            var instanceToClose = this.nextInstances[this.chainIndex];
            instanceToClose.hide();
            instanceToClose.destroy();
            this.nextInstances.pop();
            if (destroyAll == true) {
              angular.forEach(this.nextInstances, function(instanceToDestroy) {
                instanceToDestroy.destroy();
              });
              this.rootInstance.destroy();
              this.allClear = true;
            } else {
              this.chainIndex--;
              this.currentInstance = this.nextInstances[this.chainIndex];
              this.currentInstance.show();
            }
          }
        }

        console.log(this.chainIndex);
      };

      ChainPopup.prototype.isAllClear = function() {
        return this.allClear;
      };

      ChainPopup.prototype.close = function(destroyAll) {
        this.release(destroyAll);
      };

      ChainPopup.prototype.destroy = function(destroyAll) {
        this.release(destroyAll);
      };

      ChainPopup.prototype.hide = function() {
        console.log(angular.element(this.currentInstance));
        this.currentInstance.hide();
      };

      ChainPopup.prototype.toggle = function() {
        var instanceEl = this.currentInstance.$element;

        $(instanceEl)
          .find('.modal-footer')
          .slideToggle(null, function() {
            $(instanceEl)
              .find('.modal-body')
              .slideToggle(null, function() {
                instanceEl
                  .find('.modal-dialog')
                  .toggleClass('default-modal-dialog');
                instanceEl
                  .find('.modal-dialog')
                  .toggleClass('bottom-modal-dialog');
              });
          });

        instanceEl.toggleClass('min');
        var minusSel = instanceEl.find('.fa-minus');
        var cloneSel = instanceEl.find('.fa-clone');
        if (instanceEl.hasClass('min')) {
          $('.modal-backdrop').addClass('display-none');
        } else {
          $('.modal-backdrop').removeClass('display-none');
        }

        if (minusSel.length > 0)
          minusSel.toggleClass('.fa-minus').toggleClass('fa-clone');
        else cloneSel.toggleClass('.fa-minus').toggleClass('fa-clone');
      };

      ChainPopup.prototype.restore = function() {
        this.currentInstance.show();
      };

      ChainPopup.prototype.openNext = function(options) {
        var defPlacement = angular.isDefined(options.placement)
          ? options.placement
          : 'center';
        if (this.chainIndex == -1) this.rootInstance.hide();
        else this.nextInstances[this.chainIndex].hide();

        var uniqueID = new Date();
        var myRandom = Math.floor(Math.random() * 1000);
        var idinstance = uniqueID.getTime() + '' + myRandom;

        var nextModalInstance = modalProvider({
          'data-animation': 'am-slide-left',
          'data-backdropAnimation': 'am-slide-right',
          scope: options.scope,
          title: options.title,
          template: options.template,
          keyboard: true,
          dismissable: options.showClose,
          placement: defPlacement,
          onHide: options.onclose,
          id: idinstance,
        });

        this.currentInstance = nextModalInstance;

        this.nextInstances.push(nextModalInstance);

        this.chainIndex++;
      };

      return {
        openInChain: function(options) {
          return new ChainPopup(options);
        },
        setModalProvider: function(mProvider) {
          modalProvider = mProvider;
          initialized = true;
        },
        isInitialized: function() {
          return initialized;
        },
      };
    };
    this.$get.$inject = ['$compile', '$rootScope'];
  };
  return gcChainPopup;
});
