'use strict';
define(function () {
  const itvStylesFactory = function () {

    const NODE_AMONT = new ol.style.Style({
      image: new ol.style.Circle({
        radius: 6,
        fill: new ol.style.Fill({
          color: '#35dd2f',
        }),
        stroke: new ol.style.Stroke({
          color: 'rgba(0,0,0,1)',
        }),
      })
    });

    const NODE_AVAL = new ol.style.Style({
      image: new ol.style.Circle({
        radius: 6,
        fill: new ol.style.Fill({
          color: '#df4149',
        }),
        stroke: new ol.style.Stroke({
          color: 'rgba(0,0,0,1)',
        }),
      })
    });

    const NODE_ALONE = new ol.style.Style({
      image: new ol.style.Circle({
        radius: 6,
        fill: new ol.style.Fill({
          color: '#35afff',
        }),
        stroke: new ol.style.Stroke({
          color: 'rgba(0,0,0,1)',
        }),
      })
    });

    const CANALISATION_STYLE = [
      new ol.style.Style({
        stroke: new ol.style.Stroke({
          color: '#19a314',
          width: 8,
        })
      }),
      new ol.style.Style({
        stroke: new ol.style.Stroke({
          color: '#19f0f0',
          width: 2,
        })
      })
    ];


    const BRANCHEMENT_STYLE = new ol.style.Style({
      stroke: new ol.style.Stroke({
        color: '#606060',
        width: 5,
      }),
      fill: new ol.style.Fill({
        color: '#606060',
      }),
    });


    const CANAL_DE_BRCHT_STYLE = new ol.style.Style({
      stroke: new ol.style.Stroke({
        color: '#a0a0a0',
        width: 4,
      }),
      fill: new ol.style.Fill({
        color: '#a0a0a0',
      }),
    });

    /**
     * Style de l'objet linéaire parcouru par le marqueur
     * matérialisant la position de la vidéo d'inspection de l'ITV
     * @type {ol.style.Style}
     */
    const PIPE_ROUTE_STYLE =
        new ol.style.Style({
          stroke: new ol.style.Stroke({
            color: 'black',
            width: 5,
          })
    });

    /**
     * Style du marqueur matérialisant la position de la vidéo d'inspection de l'ITV
     * @type {ol.style.Style}
     */
    const VIDEO_MARKER_STYLE = new ol.style.Style({
      image: new ol.style.Circle({
        radius: 7,
        snapToPixel: false,
        fill: new ol.style.Fill({color: 'black'}),
        stroke: new ol.style.Stroke({
          color: 'white', width: 2
        })
      })
    });

    const DETAILS_STYLE = {
      'BC': new ol.style.Style({
        image: new ol.style.RegularShape({
          rotation: 0,
          angle: 0,
          fill: new ol.style.Fill({color: [90, 137, 173, 1]}),
          radius: 10,
          stroke: new ol.style.Stroke({color: 'black', width: 1}),
          points: 3,
        }),
      }),
      'BA': new ol.style.Style({
        image: new ol.style.RegularShape({
          rotation: 0,
          angle: 0,
          fill: new ol.style.Fill({color: [234, 249, 3, 1]}),
          radius: 10,
          stroke: new ol.style.Stroke({color: 'black', width: 1}),
          points: 3,
        }),
      }),
      'BB': new ol.style.Style({
        image: new ol.style.RegularShape({
          rotation: 0,
          angle: 0,
          fill: new ol.style.Fill({color: [216, 112, 71, 1]}),
          radius: 10,
          stroke: new ol.style.Stroke({color: 'black', width: 1}),
          points: 3,
        })
      }),
      'default': new ol.style.Style({
        image: new ol.style.RegularShape({
          rotation: 0,
          angle: 0,
          fill: new ol.style.Fill({color: [98, 229, 21, 1]}),
          radius: 10,
          stroke: new ol.style.Stroke({color: 'black', width: 1}),
          points: 3,
        })
      })
    };


    return {
      NODE_AMONT: NODE_AMONT,
      NODE_AVAL: NODE_AVAL,
      NODE_ALONE: NODE_ALONE,
      CANALISATION_STYLE: CANALISATION_STYLE,
      BRANCHEMENT_STYLE: BRANCHEMENT_STYLE,
      CANAL_DE_BRCHT_STYLE: CANAL_DE_BRCHT_STYLE,
      PIPE_ROUTE_STYLE: PIPE_ROUTE_STYLE,
      VIDEO_MARKER_STYLE: VIDEO_MARKER_STYLE,
      DETAILS_STYLE: DETAILS_STYLE
    };
  };
  itvStylesFactory.$inject = [];
  return itvStylesFactory;
});
