'use strict';
define(function() {
  var gcelement = function(NetworkFactory, $timeout) {
    var NOEUD_AMONT_STYLE = new ol.style.Style({
      image: new ol.style.Icon(
        /** @type {olx.style.IconOptions} */ ({
          anchor: [0.5, 46],
          anchorXUnits: 'fraction',
          anchorYUnits: 'pixels',
          opacity: 0.75,
          src: 'img/widget/network/noeudamont.png',
        })
      ),
    });

    var NOEUD_AVAL_STYLE = new ol.style.Style({
      image: new ol.style.Icon(
        /** @type {olx.style.IconOptions} */ ({
          anchor: [0.5, 46],
          anchorXUnits: 'fraction',
          anchorYUnits: 'pixels',
          opacity: 0.75,
          src: 'img/widget/network/noeudaval.png',
        })
      ),
    });

    var BARRIER_STYLE = new ol.style.Style({
      image: new ol.style.Icon(
        /** @type {olx.style.IconOptions} */ ({
          opacity: 0.75,
          src: 'img/widget/network/barrier.png',
        })
      ),
    });

    var GEOJSON_FORMAT = new ol.format.GeoJSON();

    var nodesSource = new ol.source.Vector({
      //create empty vector
    });

    var nodesLayer = new ol.layer.Vector({
      source: nodesSource,
    });

    return {
      templateUrl: 'js/XG/widgets/utilities/network/views/gcpathhtoolbar.html',

      restrict: 'A',
      scope: {
        map: '=map',
        netname: '=netname',
        minnodes: '=minnodes',
        maxnodes: '=maxnodes',
        nodesincr: '=nodesincr',
        pathprocessconfig: '=pathprocessconfig',
        result: '=res',
        featuresResult: '=featuresres',
        nfeaturesResult: '=netfeaturesres',
        onfinish: '&',
        toolBarWidget: '=?toolbarwidget',
      },
      link: function(scope, element, attrs, ctrl) {
        scope.amontNodeExist = false;
        scope.avalNodeExist = false;

        var map = scope.map;
        var nodesLayerRegistered = false;
        var amontFeature = null;
        var avalFeature = null;

        scope.shortestPath = {};
        scope.shortestPathFeatures = {};
        scope.netShortestPathFeatures = {};

        scope.noeudAmontIsActive = 'DEACTIVATED';
        scope.noeudAvalIsActive = 'DEACTIVATED';
        scope.addBarrierIsActive = 'DEACTIVATED';

        scope.path = {
          noeudAmont: {},
          noeudAval: {},
          lastAddedBarrier: {},
          barriers: [],
        };

        function activate() {
          if (nodesLayerRegistered == false) {
            map.addLayer(nodesLayer);
            nodesLayerRegistered = true;
          }
        }

        function deactivate() {
          if (nodesLayerRegistered == true) {
            map.removeLayer(nodesLayer);
            nodesLayerRegistered = false;
          }
          nodesSource.clear();
          amontFeature = null;
          avalFeature = null;
          scope.avalNodeExist = false;
          scope.avalNodeExist = false;

          scope.noeudAvalIsActive = 'DEACTIVATED';
          scope.noeudAmontIsActive = 'DEACTIVATED';
          scope.addBarrierIsActive = 'DEACTIVATED';

          scope.path = {
            noeudAmont: {},
            noeudAval: {},
            lastAddedBarrier: {},
            barriers: [],
          };
        }

        scope.noeudAmontSelected = function() {
          activate();

          if (
            amontFeature &&
            nodesSource.getFeatureById(amontFeature.getId()) != null
          ) {
            nodesSource.removeFeature(amontFeature);
            amontFeature == null;
            scope.amontNodeExist = false;
          }

          if (scope.path.noeudAmont && scope.path.noeudAmont.geometry) {
            var nodeGeometry = scope.path.noeudAmont.geometry;

            var olOriginGeometry = GEOJSON_FORMAT.readGeometry(nodeGeometry);
            amontFeature = new ol.Feature({
              name: '',
              geometry: olOriginGeometry,
            });

            amontFeature.setId(Math.floor(Math.random() * 1000));
            amontFeature.setStyle(NOEUD_AMONT_STYLE);

            nodesSource.addFeature(amontFeature);
            scope.amontNodeExist = true;
          }
        };

        scope.barrierAdded = function() {
          activate();

          if (
            scope.path.lastAddedBarrier &&
            scope.path.lastAddedBarrier.hitPoint
          ) {
            var barrierGeometry = scope.path.lastAddedBarrier.hitPoint;

            var olDestGeometry = GEOJSON_FORMAT.readGeometry(barrierGeometry);
            var barrierFeature = new ol.Feature({
              name: '',
              geometry: olDestGeometry,
            });

            barrierFeature.setStyle(BARRIER_STYLE);

            nodesSource.addFeature(barrierFeature);
            scope.path.barriers.push(scope.path.lastAddedBarrier.edge);
            scope.path.lastAddedBarrier = {};
          }
        };

        scope.noeudAvalSelected = function() {
          activate();

          if (
            avalFeature &&
            nodesSource.getFeatureById(avalFeature.getId()) != null
          ) {
            nodesSource.removeFeature(avalFeature);
            avalFeature == null;
            scope.avalNodeExist = false;
          }

          if (scope.path.noeudAval && scope.path.noeudAval.geometry) {
            var nodeGeometry = scope.path.noeudAval.geometry;

            var olDestGeometry = GEOJSON_FORMAT.readGeometry(nodeGeometry);
            avalFeature = new ol.Feature({
              name: '',
              geometry: olDestGeometry,
            });

            avalFeature.setId(Math.floor(Math.random() * 1000));
            avalFeature.setStyle(NOEUD_AVAL_STYLE);

            nodesSource.addFeature(avalFeature);
            scope.avalNodeExist = true;
          }
        };

        scope.noeudamontActivated = function() {
          scope.noeudAmontIsActive = 'ACTIVATED';
          scope.noeudAvalIsActive = 'DEACTIVATED';
          scope.addBarrierIsActive = 'DEACTIVATED';
        };

        scope.noeudavalActivated = function() {
          scope.noeudAvalIsActive = 'ACTIVATED';
          scope.noeudAmontIsActive = 'DEACTIVATED';
          scope.addBarrierIsActive = 'DEACTIVATED';
        };

        scope.addBarrierActivated = function() {
          scope.addBarrierIsActive = 'ACTIVATED';
          scope.noeudAmontIsActive = 'DEACTIVATED';
          scope.noeudAvalIsActive = 'DEACTIVATED';
        };

        scope.pathValidated = function() {
          scope.noeudAmontIsActive = 'DEACTIVATED';
          scope.noeudAvalIsActive = 'DEACTIVATED';
          scope.addBarrierIsActive = 'DEACTIVATED';

          scope.result = scope.shortestPath;
          scope.featuresResult = scope.shortestPathFeatures;
          scope.nfeaturesResult = scope.netShortestPathFeatures;

          $timeout(scope.onfinish, 100);

          deactivate();
        };

        scope.resetPathToolbar = function() {
          deactivate();
        };
      },
    };
  };

  gcelement.$inject = ['NetworkFactory', '$timeout'];
  return gcelement;
});
