'use strict';
define(function() {
  var gcelement = function(
    NetworkFactory,
    $timeout,
    ngDialog,
    gaDomUtils,
    gcInteractions
  ) {
    var FEATURE_COLLECTION_TEMPLATE = {
      type: 'FeatureCollection',
      features: [],
    };

    var NOEUD_AMONT_STYLE = new ol.style.Style({
      image: new ol.style.Icon(
        /** @type {olx.style.IconOptions} */ ({
          anchor: [0.5, 46],
          anchorXUnits: 'fraction',
          anchorYUnits: 'pixels',
          opacity: 0.75,
          src: 'img/widget/network/noeudamont.png',
        })
      ),
    });

    var LAST_CLOSING_NODE_STYLE = new ol.style.Style({
      image: new ol.style.Icon(
        /** @type {olx.style.IconOptions} */ ({
          anchor: [0.5, 20],
          anchorXUnits: 'fraction',
          anchorYUnits: 'pixels',
          opacity: 0.75,
          src: 'img/widget/network/lastnode.png',
        })
      ),
    });

    var POSSIBLE_NEXT_NODE_STYLE = new ol.style.Style({
      image: new ol.style.Circle({
        radius: 6,
        fill: new ol.style.Fill({
          color: 'rgba(255,255,255,1)',
        }),
        stroke: new ol.style.Stroke({
          color: 'rgba(255,0,0,1)',
        }),
      }),
    });

    var PATH_STYLE = new ol.style.Style({
      stroke: new ol.style.Stroke({
        width: 4,
        color: 'rgba(255, 0, 0, 1)',
        lineDash: [0.1, 5],
      }),
      zIndex: 2,
    });

    var VALID_PATH_STYLE = new ol.style.Style({
      stroke: new ol.style.Stroke({
        width: 4,
        color: 'rgba(100, 0, 200, 1)',
        lineDash: [0.1, 5],
      }),
      zIndex: 2,
    });

    var GEOJSON_FORMAT = new ol.format.GeoJSON();

    var styles = {
      MultiPolygon: [
        new ol.style.Style({
          stroke: new ol.style.Stroke({
            color: 'yellow',
            width: 1,
          }),
          fill: new ol.style.Fill({
            color: 'rgba(255, 255, 0, 0.1)',
          }),
        }),
      ],
      Polygon: [
        new ol.style.Style({
          stroke: new ol.style.Stroke({
            color: 'blue',
            lineDash: [4],
            width: 3,
          }),
          fill: new ol.style.Fill({
            color: 'rgba(0, 0, 255, 0.7)',
          }),
        }),
      ],
      Point: [
        new ol.style.Style({
          image: new ol.style.Circle({
            radius: 6,
            fill: new ol.style.Fill({
              color: 'rgba(255,255,255,1)',
            }),
            stroke: new ol.style.Stroke({
              color: 'rgba(255,0,0,1)',
            }),
          }),
        }),
      ],
    };

    var styleFunction = function(feature, resolution) {
      return styles[feature.getGeometry().getType()];
    };

    var originSource = new ol.source.Vector({
      //create empty vector
    });

    var originLayer = new ol.layer.Vector({
      source: originSource,
      style: styleFunction,
    });

    var pathsSource = new ol.source.Vector({
      //create empty vector
    });

    var pathsLayer = new ol.layer.Vector({
      source: pathsSource,
      style: styleFunction,
    });

    var validPathSource = new ol.source.Vector({
      //create empty vector
    });

    var validPathLayer = new ol.layer.Vector({
      source: validPathSource,
      style: styleFunction,
    });

    var lastEdgesSource = new ol.source.Vector({
      //create empty vector
    });
    var lastEdgesLayer = new ol.layer.Vector({
      source: lastEdgesSource,
      style: styleFunction,
    });

    var lastNodesSource = new ol.source.Vector({
      //create empty vector
    });
    var lastNodesLayer = new ol.layer.Vector({
      source: lastNodesSource,
      style: styleFunction,
    });

    var lastClosingNodesSource = new ol.source.Vector({
      //create empty vector
    });
    var lastClosingNodesLayer = new ol.layer.Vector({
      source: lastClosingNodesSource,
      style: styleFunction,
    });

    return {
      templateUrl:
        'js/XG/widgets/utilities/network/views/gcsubnetworkselect.html',
      restrict: 'A',
      scope: {
        map: '=map',
        netname: '=netname',
        minNodesToParse: '=minnodes',
        maxNodesToParse: '=maxnodes',
        nodesIncrementWalk: '=nodesincr',
        pathprocessconfig: '=pathprocessconfig',
        result: '=res',
        featuresResult: '=featuresres',
        nfeaturesResult: '=netfeaturesres',
        toolBarWidget: '=?toolbarwidget',
        onfinish: '&',
      },
      link: function(scope, element, attrs, ctrl) {
        scope.resultIsNotReady = true;
        var selectedFeature = null;
        var lastExtendPathDialog = null;
        scope.lastNetworkPartData = {};
        scope.showConfig = false;
        var startPathNode;
        scope.endPathNode = null;
        var allPaths = [];
        var map = scope.map;
        var networkName = scope.netname;
        scope.originNode = {};

        var pathProcessConfig = null;

        scope.nodesToParse = {
          value: scope.minNodesToParse,
          lastRequestValue: scope.minNodesToParse,
        };

        if (scope.pathprocessconfig)
          pathProcessConfig = simplifyPathProcessConfig(
            scope.pathprocessconfig
          );

        var inSrid = map
          .getView()
          .getProjection()
          .getCode();
        var btnElt = $(element.children()[0].children[0].children[0]);

        function activate() {
          map.addLayer(pathsLayer);
          map.addLayer(originLayer);
          map.addLayer(validPathLayer);
          map.addLayer(lastNodesLayer);
          map.addLayer(lastClosingNodesLayer);
          map.addLayer(lastEdgesLayer);

          scope.resultIsNotReady = true;
        }

        function deactivate() {
          scope.isActive = false;
          //map.removeInteraction(scope.pointer);
          if (scope.networkPathSelectInteraction) removePathSelectInteraction();

          if (scope.networkEdgeSelectInteraction) removeEdgeSelectInteraction();

          if (scope.networkExtendSelectInteraction)
            removeExtendSelectInteraction();

          map.removeLayer(pathsLayer);
          map.removeLayer(originLayer);
          map.removeLayer(validPathLayer);
          map.removeLayer(lastNodesLayer);
          map.removeLayer(lastClosingNodesLayer);
          map.removeLayer(lastEdgesLayer);

          pathsSource.clear();
          originSource.clear();
          validPathSource.clear();
          lastNodesSource.clear();
          lastClosingNodesSource.clear();
          lastEdgesSource.clear();

          startPathNode = null;
          scope.endPathNode = null;
          allPaths = [];
          scope.originNode = {};

          scope.resultIsNotReady = true;
        }

        function removeExtendSelectInteraction() {
          if (scope.networkExtendSelectInteraction) {
            scope.networkExtendSelectInteraction.setActive(false);
            map.removeInteraction(scope.networkExtendSelectInteraction);
            scope.networkExtendSelectInteraction.un(
              'select',
              handleExtendNodeEvent
            );
            scope.networkExtendSelectInteraction = null;
          }
        }

        function removePathSelectInteraction() {
          if (scope.networkPathSelectInteraction) {
            scope.networkPathSelectInteraction.setActive(false);
            map.removeInteraction(scope.networkPathSelectInteraction);
            scope.networkPathSelectInteraction.un(
              'drawstart',
              networkPathSelectStart
            );
            scope.networkPathSelectInteraction.un(
              'drawend',
              networkPathSelectEnd
            );
            scope.networkPathSelectInteraction = null;
          }
        }

        function removeEdgeSelectInteraction() {
          if (scope.networkEdgeSelectInteraction) {
            scope.networkEdgeSelectInteraction.setActive(false);
            map.removeInteraction(scope.networkEdgeSelectInteraction);
            scope.networkEdgeSelectInteraction.un(
              'select',
              handleEdgeSelectedEvent
            );
            scope.networkEdgeSelectInteraction = null;
          }
        }

        function networkPathSelectStart(evt) {
          /*sketchFeature = evt.feature;*/
        }

        function ftypeAttributeValuesToSavePartConfig(fTypeAttributeValues) {
          var elements = [];

          for (var ftiUID in fTypeAttributeValues) {
            var fTypeAttributeValues = fTypeAttributeValues[ftiUID];

            var ftiElements = [];

            angular.forEach(fTypeAttributeValues, function(attributeValue) {
              var attributeFilter = {
                attrName: attributeValue.attributeName,
                value: attributeValue.res[attributeValue.attributeName],
              };

              ftiElements.push(attributeFilter);
            });

            elements.push({
              ftiUID: ftiUID,
              attributesFilters: ftiElements,
            });
          }
          return elements;
        }

        function dataToSavePartConfig(data) {
          var fTypesUIDS = [];
          angular.forEach(data.leftData, function(choosedFType) {
            fTypesUIDS.push(choosedFType.uid);
          });

          return fTypesUIDS;
        }

        function simplifyPathProcessConfig(networkTool) {
          var networkToolConfig = {
            label: networkTool.label,
            toolType: networkTool.toolType,
            amontElements: [],
            avalElements: [],
            networkElements: [],
            amontElementsFilters: [],
            avalElementsFilters: [],
            networkElementsFilters: [],
            addPathAtEnd: true,
          };

          var amontElementsConfigPart = dataToSavePartConfig(
            networkTool.amontElementsData
          );
          var avalElementsConfigPart = dataToSavePartConfig(
            networkTool.avalElementsData
          );
          var networkElementsConfigPart = dataToSavePartConfig(
            networkTool.edgesAndNodesData
          );

          networkToolConfig.amontElements = amontElementsConfigPart;
          networkToolConfig.avalElements = avalElementsConfigPart;
          networkToolConfig.networkElements = networkElementsConfigPart;

          var amontElementsFiltersConfigPart = ftypeAttributeValuesToSavePartConfig(
            networkTool.currentAmontEditFTypeAttributeValues
          );
          var avalElementsFiltersConfigPart = ftypeAttributeValuesToSavePartConfig(
            networkTool.currentAvalEditFTypeAttributeValues
          );
          var networkElementsFiltersConfigPart = ftypeAttributeValuesToSavePartConfig(
            networkTool.currentEditFTypeAttributeValues
          );

          networkToolConfig.amontElementsFilters = amontElementsFiltersConfigPart;
          networkToolConfig.avalElementsFilters = avalElementsFiltersConfigPart;
          networkToolConfig.networkElementsFilters = networkElementsFiltersConfigPart;

          return networkToolConfig;
        }

        function activateExtentSelectInteraction() {
          removeExtendSelectInteraction();

          scope.networkExtendSelectInteraction = new ol.interaction.Select({
            layers: [lastClosingNodesLayer],
            style: new ol.style.Style({
              fill: new ol.style.Fill({
                color: 'rgba(255, 100, 50, 0.3)',
              }),
              stroke: new ol.style.Stroke({
                width: 2,
                color: 'rgba(255, 100, 50, 0.8)',
              }),
              image: new ol.style.Icon({
                scale: 0.7,
                rotateWithView: false,
                anchor: [0.5, 1],
                anchorXUnits: 'fraction',
                anchorYUnits: 'fraction',
                opacity: 1,
                src: 'img/widget/network/marker.png',
              }),
            }),
            toggleCondition: ol.events.condition.never,
          });

          scope.networkExtendSelectInteraction.set('gctype', 'kis');
          scope.networkExtendSelectInteraction.set('interaction', 'Select');
          scope.networkExtendSelectInteraction.set(
            'widget',
            'networksubpathselect'
          );
          scope.networkExtendSelectInteraction.setActive(true);
          gcInteractions.setCurrentToolBar(scope.toolBarWidget);
          map.addInteraction(scope.networkExtendSelectInteraction);
          scope.networkExtendSelectInteraction.on(
            'select',
            handleExtendNodeEvent
          );
        }

        function activateSelectNextEdgeInteraction() {
          removePathSelectInteraction();

          scope.networkEdgeSelectInteraction = new ol.interaction.Select({
            layers: [lastEdgesLayer],
            style: new ol.style.Style({
              fill: new ol.style.Fill({
                color: 'rgba(255, 100, 50, 0.3)',
              }),
              stroke: new ol.style.Stroke({
                width: 2,
                color: 'rgba(255, 100, 50, 0.8)',
              }),
              image: new ol.style.Icon({
                scale: 0.7,
                rotateWithView: false,
                anchor: [0.5, 1],
                anchorXUnits: 'fraction',
                anchorYUnits: 'fraction',
                opacity: 1,
                src: 'img/widget/network/marker.png',
              }),
            }),
            toggleCondition: ol.events.condition.never,
          });

          scope.networkEdgeSelectInteraction.set('gctype', 'kis');
          scope.networkEdgeSelectInteraction.set('interaction', 'Select');
          scope.networkEdgeSelectInteraction.set(
            'widget',
            'networksubpathselect'
          );
          scope.networkEdgeSelectInteraction.setActive(true);
          gcInteractions.setCurrentToolBar(scope.toolBarWidget);
          map.addInteraction(scope.networkEdgeSelectInteraction);

          scope.networkEdgeSelectInteraction.on(
            'select',
            handleEdgeSelectedEvent
          );
        }

        function networkPathSelectEnd(evt) {
          //scope.features = evt.feature;
          var format = new ol.format.GeoJSON();

          var feature = format.writeFeatureObject(evt.feature);

          scope.resgeometry = feature.geometry;
          var coordX = scope.resgeometry.coordinates[0];
          var coordY = scope.resgeometry.coordinates[1];

          if (scope.pathprocessconfig)
            pathProcessConfig = simplifyPathProcessConfig(
              scope.pathprocessconfig
            );

          scope.nodesToParse.lastRequestValue = scope.nodesToParse.value;

          NetworkFactory.getconnectededgesxy(
            pathProcessConfig,
            networkName,
            inSrid,
            coordX,
            coordY,
            'AMONT'
          ).then(function(res) {
            allPaths = [];
            scope.originNode = {};
            handlePossibleEdges(res.data, true);
          });
        }

        function confirmPreviousPathPortion(path) {
          allPaths.push(path);
          var olGeometry = GEOJSON_FORMAT.readGeometry(path.geometry);
          var confirmPath = new ol.Feature({
            name: '',
            geometry: olGeometry,
          });

          confirmPath.setStyle(VALID_PATH_STYLE);

          validPathSource.addFeature(confirmPath);
        }

        function showDialogToExtendPath() {
          scope.nodesToParse.lastRequestValue = scope.nodesToParse.value;

          lastExtendPathDialog = ngDialog.open({
            template:
              'js/XG/widgets/utilities/network/views/gcsubnetworkselectextent.html',
            closeByDocument: false,
            showClose: false,
            scope: scope,
          });
        }

        function getNetworkPart(nodesValue) {
          if (!nodesValue) nodesValue = scope.nodesToParse.value;

          gaDomUtils.showGlobalLoader();
          NetworkFactory.getnetworkpart(
            scope.lastNetworkPartData,
            networkName,
            inSrid,
            nodesValue
          ).then(
            function(res) {
              gaDomUtils.hideGlobalLoader();
              if (
                (res.data.nextPaths == null ||
                  res.data.nextPaths.length == 0) &&
                scope.nodesToParse.value < scope.maxNodesToParse
              )
                showDialogToExtendPath();
              else {
                var toRemoveFeatures = [];

                lastEdgesSource.forEachFeature(function(feat) {
                  if (selectedFeature != feat) toRemoveFeatures.push(feat);
                });

                angular.forEach(toRemoveFeatures, function(featToRemove) {
                  lastEdgesSource.removeFeature(featToRemove);
                });

                handlePossiblePaths(res.data, false, true);

                if (scope.networkEdgeSelectInteraction)
                  removeEdgeSelectInteraction();
              }
            },
            function errorCallback(response) {
              gaDomUtils.hideGlobalLoader();
            }
          );
        }

        function getExtendNetworkPart(nodesValue) {
          if (!nodesValue) nodesValue = scope.nodesToParse.value;

          gaDomUtils.showGlobalLoader();
          NetworkFactory.getextendnetworkpart(
            scope.lastNetworkPartData,
            networkName,
            inSrid,
            nodesValue
          ).then(
            function(res) {
              gaDomUtils.hideGlobalLoader();
              if (
                (res.data.nextPaths == null ||
                  res.data.nextPaths.length == 0) &&
                scope.nodesToParse.value < scope.maxNodesToParse
              )
                showDialogToExtendPath();
              else {
                var toRemoveFeatures = [];

                lastClosingNodesSource.forEachFeature(function(feat) {
                  if (selectedFeature != feat) toRemoveFeatures.push(feat);
                });

                lastClosingNodesSource.removeFeature(selectedFeature);

                handlePossiblePaths(res.data, false, false);
              }
            },
            function errorCallback(response) {
              gaDomUtils.hideGlobalLoader();
            }
          );
        }

        function handleExtendNodeEvent(evt) {
          if (evt.selected.length > 0) {
            selectedFeature = scope.networkExtendSelectInteraction
              .getFeatures()
              .item(0);

            if (selectedFeature) {
              var node = selectedFeature.get('node');
              var pathElts = selectedFeature.get('path').elements;
              var edge = pathElts[pathElts.length - 2];

              if (scope.pathprocessconfig)
                pathProcessConfig = simplifyPathProcessConfig(
                  scope.pathprocessconfig
                );

              scope.lastNetworkPartData = {
                origin: node,
                edge: edge,
                processConfig: pathProcessConfig,
              };

              getExtendNetworkPart();
            }
          }
        }

        function handleEdgeSelectedEvent(evt) {
          if (evt.selected.length > 0) {
            selectedFeature = scope.networkEdgeSelectInteraction
              .getFeatures()
              .item(0);

            if (selectedFeature) {
              var edge = selectedFeature.get('edge');

              if (scope.pathprocessconfig)
                pathProcessConfig = simplifyPathProcessConfig(
                  scope.pathprocessconfig
                );

              scope.lastNetworkPartData = {
                origin: scope.originNode,
                edge: edge,
                processConfig: pathProcessConfig,
              };

              getNetworkPart();
            }
          }
        }

        function handleToggleConfigPath() {
          scope.showConfig = !scope.showConfig;
        }

        function handleRetrySubNetworkExtension() {
          getNetworkPart(scope.nodesToParse.lastRequestValue);
          lastExtendPathDialog.close();
        }

        function handleCancelSubNetworkExtension(deactivateTool) {
          if (deactivateTool) deactivate();

          lastExtendPathDialog.close();
        }

        function featureAlreadyAdded(features, modelFeatureJSON) {
          for (var i = 0; i < features.length; i++) {
            var featureJSON = features[i];
            if (featureJSON.id == modelFeatureJSON.id) return true;
          }

          return false;
        }

        function handleValidatePath() {
          var resultFeatureCollection = angular.copy(
            FEATURE_COLLECTION_TEMPLATE
          );
          var networkResultFeatureCollection = angular.copy(
            FEATURE_COLLECTION_TEMPLATE
          );
          var mergedPathElements = [];
          var mergedGeometry = new ol.geom.MultiLineString('');
          //var allGeometries = [];
          for (var i = 0; i < allPaths.length; i++) {
            var path = allPaths[i];
            if (mergedPathElements.length != 0) path.elements.shift();

            for (var j = 0; j < path.elements.length; j++) {
              var pathElement = path.elements[j];
              var modelFeatureJSON = angular.fromJson(pathElement.modelFeature);
              if (
                !featureAlreadyAdded(
                  resultFeatureCollection.features,
                  modelFeatureJSON
                )
              ) {
                resultFeatureCollection.features.push(modelFeatureJSON);
                networkResultFeatureCollection.features.push(
                  angular.fromJson(pathElement.feature)
                );
                mergedPathElements.push(pathElement);
              }
            }

            var pathGeometry = GEOJSON_FORMAT.readGeometry(path.geometry);
            if (pathGeometry.getType() == 'LineString')
              mergedGeometry.appendLineString(pathGeometry);
            else {
              for (var k = 0; k < pathGeometry.getLineStrings().length; k++)
                mergedGeometry.appendLineString(pathGeometry.getLineString(k));
            }
          }

          var finalPath = {
            elements: mergedPathElements,
            features: resultFeatureCollection,
            netFeatures: networkResultFeatureCollection,
            geometry: GEOJSON_FORMAT.writeGeometry(mergedGeometry),
            //olGeometry: mergedGeometry
          };

          scope.result = {
            path: finalPath,
            startPathNode: startPathNode,
            endPathNode: scope.endPathNode,
          };

          scope.featuresResult = resultFeatureCollection;
          scope.nfeaturesResult = networkResultFeatureCollection;

          $timeout(scope.onfinish, 100);
          deactivate();
        }

        function getNextNodeEl(path) {
          return path.elements[path.elements.length - 1];
        }

        function geometryStyle(feature) {
          var style = [],
            geometry_type = feature.getGeometry().getType(),
            white = [255, 255, 255, 1],
            blue = [0, 153, 255, 1],
            width = 3;

          (style['LineString'] = [
            new ol.style.Style({
              stroke: new ol.style.Stroke({
                color: white,
                width: width + 2,
              }),
            }),
            new ol.style.Style({
              stroke: new ol.style.Stroke({
                color: blue,
                width: width,
              }),
            }),
          ]),
            (style['Polygon'] = [
              new ol.style.Style({
                fill: new ol.style.Fill({
                  color: [255, 255, 255, 0.5],
                }),
              }),
              new ol.style.Style({
                stroke: new ol.style.Stroke({
                  color: white,
                  width: 3.5,
                }),
              }),
              new ol.style.Style({
                stroke: new ol.style.Stroke({
                  color: blue,
                  width: 2.5,
                }),
              }),
            ]),
            (style['Point'] = [
              new ol.style.Style({
                image: new ol.style.Icon({
                  scale: 0.7,
                  rotateWithView: false,
                  anchor: [0.5, 1],
                  anchorXUnits: 'fraction',
                  anchorYUnits: 'fraction',
                  opacity: 1,
                  src: 'img/widget/network/marker.png',
                }),
                zIndex: 5,
              }),
            ]);

          return style[geometry_type];
        }

        function handlePossibleEdges(nextNodeEdges, initOrigin) {
          //ap.un('pointermove', mapOnPointerMove);

          pathsSource.clear();
          lastNodesSource.clear();
          lastClosingNodesSource.clear();
          lastEdgesSource.clear();

          if (initOrigin) {
            originSource.clear();
            scope.originNode = nextNodeEdges.origin;

            var olOriginGeometry = GEOJSON_FORMAT.readGeometry(
              scope.originNode.geometry
            );
            var originFeature = new ol.Feature({
              name: '',
              geometry: olOriginGeometry,
            });

            originFeature.setStyle(NOEUD_AMONT_STYLE);

            originSource.addFeature(originFeature);
          }

          for (var i = 0; i < nextNodeEdges.nextEdges.length; i++) {
            var edge = nextNodeEdges.nextEdges[i];

            var olGeometry = GEOJSON_FORMAT.readGeometry(edge.geometry);
            var possibleNextEdge = new ol.Feature({
              name: '',
              geometry: olGeometry,
            });

            possibleNextEdge.setStyle(PATH_STYLE);
            possibleNextEdge.set('edge', edge);

            lastEdgesSource.addFeature(possibleNextEdge);
          }

          scope.resultIsNotReady = initOrigin;

          if (scope.networkPathSelectInteraction)
            $timeout(activateSelectNextEdgeInteraction, 1000);
        }

        function verifyIfEndNodeIsClosingNode(endNode, lastNodes) {
          for (var i = 0; i < lastNodes.length; i++) {
            var lastNode = lastNodes[i];
            if (endNode.id == lastNode.id) return true;
          }

          return false;
        }

        function handlePossiblePaths(nextNodePaths, initOrigin, clear) {
          //ap.un('pointermove', mapOnPointerMove);

          if (clear) {
            pathsSource.clear();
            lastNodesSource.clear();
            lastClosingNodesSource.clear();
          }

          if (initOrigin) {
            originSource.clear();
            startPathNode = nextNodePaths.origin;

            var olOriginGeometry = GEOJSON_FORMAT.readGeometry(
              startPathNode.geometry
            );
            var originFeature = new ol.Feature({
              name: '',
              geometry: olOriginGeometry,
            });

            originFeature.setStyle(NOEUD_AMONT_STYLE);

            originSource.addFeature(originFeature);
          }
          var lastNodes = nextNodePaths.lastNodes;

          angular.forEach(nextNodePaths.nextPaths, function(path) {
            allPaths.push(path);
            var olGeometry = GEOJSON_FORMAT.readGeometry(path.geometry);
            var possibleNextPath = new ol.Feature({
              name: '',
              geometry: olGeometry,
            });

            possibleNextPath.setStyle(PATH_STYLE);

            pathsSource.addFeature(possibleNextPath);

            var nextNode = getNextNodeEl(path);

            var olNodeGeometry = GEOJSON_FORMAT.readGeometry(nextNode.geometry);
            var possibleNextNodeFeature = new ol.Feature({
              name: '',
              geometry: olNodeGeometry,
            });

            possibleNextNodeFeature.set('node', nextNode);
            possibleNextNodeFeature.set('path', path);
            //possibleNextNodeFeature.setStyle(POSSIBLE_NEXT_NODE_STYLE);
            if (verifyIfEndNodeIsClosingNode(nextNode, lastNodes)) {
              possibleNextNodeFeature.setStyle(LAST_CLOSING_NODE_STYLE);
              lastClosingNodesSource.addFeature(possibleNextNodeFeature);
            } else lastNodesSource.addFeature(possibleNextNodeFeature);

            scope.resultIsNotReady = false;

            activateExtentSelectInteraction();
            /* scope.networkEdgeSelectInteraction = new ol.interaction.Select({
                             condition: ol.events.condition.click,
                             layers: [lastNodesLayer]
                         });*/

            //map.on('pointermove', mapOnPointerMove);
          });
        }

        function compareCoordinates(coord1, coord2) {
          var lon1 = Math.round(coord1[0]);
          var lon2 = Math.round(coord2[0]);
          var lat1 = Math.round(coord1[1]);
          var lat2 = Math.round(coord2[1]);

          var percent_lon = Math.abs(lon1 / lon2 - 1).toFixed(4);
          var percent_lat = Math.abs(lat1 / lat2 - 1).toFixed(4);

          var percent = (Number(percent_lon) + Number(percent_lat) / 2).toFixed(
            4
          );

          return percent;
        }

        function between(number, min, max) {
          if (number >= min && number <= max) return true;
          else return false;
        }

        function toggleActionLaunch() {
          if (
            scope.isActive &&
            scope.networkPathSelectInteraction &&
            scope.networkPathSelectInteraction.getActive()
          ) {
            scope.isActive = false;
            //map.removeInteraction(scope.pointer);
            if (scope.networkPathSelectInteraction)
              removePathSelectInteraction();
            if (scope.networkEdgeSelectInteraction)
              removeEdgeSelectInteraction();
            if (scope.networkExtendSelectInteraction)
              removeExtendSelectInteraction();
            //ajouter ce code si on veut enlever la sélection après la désactivation du tool
            //SelectManager.clear();
          } else {
            scope.isActive = true;
          }

          if (scope.isActive) {
            scope.networkPathSelectInteraction = new ol.interaction.Draw({
              type: 'Point',
            });

            scope.networkPathSelectInteraction.set('gctype', 'kis');
            scope.networkPathSelectInteraction.set('interaction', 'Draw');
            scope.networkPathSelectInteraction.set(
              'widget',
              'networksubpathselect'
            );
            scope.networkPathSelectInteraction.setActive(true);
            gcInteractions.setCurrentToolBar(scope.toolBarWidget);
            map.addInteraction(scope.networkPathSelectInteraction);

            //on start
            scope.networkPathSelectInteraction.on(
              'drawstart',
              networkPathSelectStart
            );

            // on end
            scope.networkPathSelectInteraction.on(
              'drawend',
              networkPathSelectEnd
            );

            activate();
          } else deactivate();
        }

        scope.selectPath = function(event) {
          toggleActionLaunch();
        };

        scope.validatePath = function() {
          handleValidatePath();
        };

        scope.toggleConfigPath = function() {
          handleToggleConfigPath();
        };

        scope.retrySubNetworkExtension = function() {
          handleRetrySubNetworkExtension();
        };

        scope.cancelSubNetworkExtension = function(deactivateTool) {
          handleCancelSubNetworkExtension(deactivateTool);
        };
      },
    };
  };

  gcelement.$inject = [
    'NetworkFactory',
    '$timeout',
    'ngDialog',
    'gaDomUtils',
    'gcInteractions',
  ];
  return gcelement;
});
