define([
    'angular',
    'ngMock'
], function(angular) {

    let scope = null;
    let httpBackend = null;
    let directiveScope = null;

    // description of what we are testing
    describe('cfg.setUniqueIdByConcat', function() {

        beforeEach(module('app'));

        // before each test case (it statements), inject dependencies
        // and do some variable definitions
        beforeEach( inject(function($compile, $rootScope, $httpBackend, $templateCache) {
            scope = $rootScope.$new();
            httpBackend = $httpBackend;

            $templateCache.put("js/XG/modules/edit/views/rules/cfg/cfg.setUniqueIdByConcat.html",'HTML_OF_YOUR_DIRECTIVE');

            scope.currentfeaturetype = {
                alias: "Batiment_1",
                name: "Batiment_1",
                attributes: [
                    {
                        alias: "MyAttribute1",
                        name: "MyAttribute1"
                    },
                    {
                        alias: "MyAttribute2",
                        name: "MyAttribute2"
                    }
                ],
                rules: [
                    {
                        name: "SetUniqueIdByConcat",
                        type: "PostSave",
                        editTypes: [
                            {
                                label: "Création",
                                name: "add"
                            },
                            {
                                label: "Mise à jour géométrique",
                                name: "update"
                            },
                            {
                                label: "Mise à jour attributaire",
                                name: "updateattributes"
                            },
                            {
                                label: "Import",
                                name: "import"
                            }
                        ],
                        parameters: {
                            targetField: "MyAttribute2",
                            formula: {
                                numerotation: {
                                    auto: false,
                                    parts: [
                                        {
                                            format: "MyAttribute1",
                                            key: "attribut"
                                        },
                                        {
                                            format: "....",
                                            key: "separator"
                                        },
                                        {
                                            format: "100",
                                            key: "value"
                                        }
                                    ],
                                    separator: ''
                                }
                            }
                        }
                    }
                ]
            };
            scope.rule = {
                name: "SetUniqueIdByConcat",
                type: "PostSave",
                editTypes: [
                    {
                        label: "Création",
                        name: "add"
                    },
                    {
                        label: "Mise à jour géométrique",
                        name: "update"
                    },
                    {
                        label: "Mise à jour attributaire",
                        name: "updateattributes"
                    },
                    {
                        label: "Import",
                        name: "import"
                    }
                ],
                parameters: {
                    targetField: "MyAttribute2",
                    formula: {
                        numerotation: {
                            auto: false,
                            parts: [
                                {
                                    format: "MyAttribute1",
                                    key: "attribut"
                                },
                                {
                                    format: "....",
                                    key: "separator"
                                },
                                {
                                    format: "100",
                                    key: "value"
                                },
                            ],
                            separator: ''
                        }
                    }
                }
            };

            let element = angular.element(
                '<rule-cfg-set-unique-id-by-concat currentfeaturetype="currentfeaturetype" rule="rule">' +
                '</rule-cfg-set-unique-id-by-concat>'
            );

            $httpBackend.whenGET("js/XG/modules/translations/locale-fr.json").respond({ text: "test" });
            $httpBackend.whenGET("/services/-/translation/model-fr.json").respond({ text: "text"});

            let elementTemplate = $compile(element)(scope);
            try {
                scope.$apply();
            } catch(err) {}

            // this will not work when the scope is inherited from the parent
            // for that case you can do this directiveScope = elementTemplate.scope();
            directiveScope = elementTemplate.isolateScope();
        }));

        describe('check if the required properties are set', function() {

            it('rule name should be defined and it be should SetUniqueIdByConcat', () => {
                expect(directiveScope.rule.name).toEqual("SetUniqueIdByConcat");
            });

            it('rule type should be defined and it be should PostSave', () => {
                expect(directiveScope.rule.type).toEqual("PostSave");
            });

            it('Edit types should be defined', () => {
                expect(directiveScope.editTypeList).toEqual(jasmine.any(Object));
            });

            it('possibleTypes should be defined and should have 3 items ', () => {
                expect(directiveScope.possibleTypes).toEqual(jasmine.any(Object));
                expect(directiveScope.possibleTypes.length).toEqual(3);
            });

            it('attributes should be defined', () => {
                expect(directiveScope.attributes).toEqual(jasmine.any(Object));
            });
        });

        describe('check if partsPreview is set when directive is loaded', function() {
            it('parts preview should be set', () => {
                expect(directiveScope.partsPreview).toEqual("$[MyAttribute1....100");
            });
        });

        describe('test for addNumerotationPart()', function() {
            beforeEach(() => {
                directiveScope.addNumerotationPart()
            });

            it('numerotation parts should have a new part', () => {
                // we had 3 parts by default
                // when calling addNumerotationPart(), a new part should be added
                expect(directiveScope.formula.numerotation.parts.length).toEqual(4);
            });
        });

        describe('test for onNumerotationPartsChange()', function() {
            beforeEach(() => {
                // we do some changes to a certain part to mimic the user action
                let changedPart = directiveScope.formula.numerotation.parts[2] = {
                    format: "2500",
                    key: "value"
                };
                let changedIndex = 2;

                // after onNumerotationPartsChange(), parts preview should be updated
                // to take the change into consideration
                directiveScope.onNumerotationPartsChange(changedPart, changedIndex)
            });

            it('parts preview should contain 2500', () => {
                console.log(directiveScope.formula.numerotation.parts);
                expect(directiveScope.partsPreview).toEqual("$[MyAttribute1....2500");
            });
        });

        describe('test for moveNumerotationpart()', function() {
            let movedPart = null;
            beforeEach(() => {
                movedPart = directiveScope.formula.numerotation.parts[0];
                directiveScope.moveNumerotationpart('down', 0)
            });

            it('the part from index 0, should be moved to index 1', () => {
                expect(directiveScope.formula.numerotation.parts[1]).toEqual(movedPart);
            });

            it('parts preview should be updated after the part order has been changed', () => {
                expect(directiveScope.partsPreview).toEqual("....$[MyAttribute1100");
            });
        });

        describe('test for removePartFromNumerotationCfg()', function () {
            let removedPart = null;
            beforeEach(() => {
                removedPart = directiveScope.formula.numerotation.parts[2];
                directiveScope.removePartFromNumerotationCfg(2)
            });

            it('the part from index 2 should be removed', () => {
                expect(directiveScope.formula.numerotation.parts[2]).not.toEqual(removedPart)
            });
        });
    });
});

