function getWsFromUrl(url) {
  var ws, iPos;
  ws = url.replace('/geoserver/', '');
  iPos = ws.indexOf('/');
  if (iPos==0) {
    iPos = url.indexOf('/services');
    ws = url.substr(iPos+10);
    iPos = ws.indexOf('/');
    //ws = ws.substr(0,iPos);
  }
  return ws.substr(0, iPos);
}

/**
 *     Transformation de la requete HTTP enregquete POST.
 * -1- Lecture des paramètres de l'URL pour les écrires
 *     dans la liste des paramètres de typePOST.
 * -2- Envoi de la requête en POST
 * -3- Récupération et mise en place de l'image résultante
 *
 * @param {[[type]]} tile [[Description]]
 * @param {[[type]]} src [[Description]]
 */
function customLoader(tile, src) {
  var client = new XMLHttpRequest();

  //-- GET ALL THE PARAMETERS OUT OF THE SOURCE URL
  var dataEntries = src.split('&');
  var url;
  var params = '';
  var ws;
  for (var i = 0; i < dataEntries.length; i++) {
    if (i === 0) {
      url = dataEntries[i];
      ws = getWsFromUrl(url);
      url = url.replace('/' + ws, '');
    } else {
      if (dataEntries[i].substr(0, 7).toLowerCase() == 'layers=') {
        dataEntries[i] =
          dataEntries[i].substr(0, 7) + ws + ':' + dataEntries[i].substr(7);
        dataEntries[i] = dataEntries[i].replace('%2C', '%2C' + ws + ':');
      }
      if (params != '') params += '&';
      params = params + dataEntries[i];
    }
  }

  client.open('POST', url, true);
  client.responseType = 'blob';

  client.onload = function() {
    var reader = new FileReader();
    reader.onloadend = function() {
      tile.getImage().src = reader.result;
    };
    reader.readAsDataURL(client.response);
  };
  //client.setRequestHeader("Connection", "close");
  client.setRequestHeader('Content-type', 'application/x-www-form-urlencoded');
  //client.setRequestHeader("Content-length", params.length);
  client.send(params);
}

if (!olkis) var olkis = {};

olkis.KISTileArcGISRest = function(opt_options) {
  ol.source.TileArcGISRest.call(this, opt_options);
  this._baseTileUrlFunction = this.getTileUrlFunction();
  this.setTileUrlFunction(this.restFixedTileUrlFunction);
  this.setTileLoadFunction(customLoader);
};

olkis.KISImageArcGISRest = function(opt_options) {
  ol.source.ImageArcGISRest.call(this, opt_options);
  this._baseImageLoadFunction = this.getImageLoadFunction();
  this.setImageLoadFunction(this.restImageLoadFunction);
};

olkis.KISTileWMSRest = function(opt_options) {
  ol.source.TileWMS.call(this, opt_options);
  this.setTileLoadFunction(opt_options.gaJsUtils.customLoader);
};

olkis.KISImageWMSRest = function(opt_options) {
  ol.source.ImageWMS.call(this, opt_options);
  this._baseImageLoadFunction = this.getImageLoadFunction();
  this.setImageLoadFunction(this.restImageLoadFunction);
  olkis.gaJsUtils = opt_options.gaJsUtils;
};

olkis.deployInherits = function() {
  ol.inherits(olkis.KISTileArcGISRest, ol.source.TileArcGISRest);
  /**
   * @inheritDoc
   */
  olkis.KISTileArcGISRest.prototype.restFixedTileUrlFunction = function(
    tileCoord,
    pixelRatio,
    projection
  ) {
    var processURL = this._baseTileUrlFunction.call(
      this,
      tileCoord,
      pixelRatio,
      projection
    );
    processURL = processURL.replace(/BBOXSR.*&/, '').replace(/IMAGESR.*&/, '');
    return processURL;
  };

  ol.inherits(olkis.KISTileWMSRest, ol.source.TileWMS);
  /**
   * @inheritDoc
   */
  olkis.KISTileArcGISRest.prototype.restFixedTileUrlFunction = function(
    tileCoord,
    pixelRatio,
    projection
  ) {
    var processURL = this._baseTileUrlFunction.call(
      this,
      tileCoord,
      pixelRatio,
      projection
    );
    processURL = processURL.replace(/BBOXSR.*&/, '').replace(/IMAGESR.*&/, '');
    return processURL;
  };

  ol.inherits(olkis.KISImageArcGISRest, ol.source.ImageArcGISRest);
  /**
   * @inheritDoc
   */
  olkis.KISImageArcGISRest.prototype.restImageLoadFunction = function(
    image,
    src
  ) {
    src = src.replace(/BBOXSR.*&/, '').replace(/IMAGESR.*&/, '');
    customLoader(image, src);
    //image.getImage().src = src;
  };

  ol.inherits(olkis.KISImageWMSRest, ol.source.ImageWMS);
  /**
   * @inheritDoc
   */
  olkis.KISImageWMSRest.prototype.restImageLoadFunction = function(image, src) {
    src = src.replace(/BBOXSR.*&/, '').replace(/IMAGESR.*&/, '');
    olkis.gaJsUtils.customLoader(image, src);
    //image.getImage().src = src;
  };
};

define("kisoljs", ["ol3js"], function(){});

if (!olkis) var olkis = {};

olkis.loadProjections = function() {
  if (proj4) {
    proj4.defs(
      'EPSG:26191',
      '+proj=lcc +lat_1=33.3 +lat_0=33.3 +lon_0=-5.4 +k_0=0.999625769 +x_0=500000 +y_0=300000 +a=6378249.2 +b=6356515 +towgs84=31,146,47,0,0,0,0 +units=m +no_defs'
    );
    proj4.defs(
      'EPSG:2154',
      '+proj=lcc +lat_1=49 +lat_2=44 +lat_0=46.5 +lon_0=3 +x_0=700000 +y_0=6600000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs'
    );
    proj4.defs(
      'EPSG:3942',
      '+proj=lcc +lat_1=41.25 +lat_2=42.75 +lat_0=42 +lon_0=3 +x_0=1700000 +y_0=1200000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs'
    );
    proj4.defs(
      'EPSG:3943',
      '+proj=lcc +lat_1=42.25 +lat_2=43.75 +lat_0=43 +lon_0=3 +x_0=1700000 +y_0=2200000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs'
    );
    proj4.defs(
      'EPSG:3944',
      '+proj=lcc +lat_1=43.25 +lat_2=44.75 +lat_0=44 +lon_0=3 +x_0=1700000 +y_0=3200000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs'
    );
    proj4.defs(
      'EPSG:3945',
      '+proj=lcc +lat_1=44.25 +lat_2=45.75 +lat_0=45 +lon_0=3 +x_0=1700000 +y_0=4200000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs'
    );
    proj4.defs(
      'EPSG:3946',
      '+proj=lcc +lat_1=45.25 +lat_2=46.75 +lat_0=46 +lon_0=3 +x_0=1700000 +y_0=5200000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs'
    );
    proj4.defs(
      'EPSG:3947',
      '+proj=lcc +lat_1=46.25 +lat_2=47.75 +lat_0=47 +lon_0=3 +x_0=1700000 +y_0=6200000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs'
    );
    proj4.defs(
      'EPSG:3948',
      '+proj=lcc +lat_1=47.25 +lat_2=48.75 +lat_0=48 +lon_0=3 +x_0=1700000 +y_0=7200000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs'
    );
    proj4.defs(
      'EPSG:3949',
      '+proj=lcc +lat_1=48.25 +lat_2=49.75 +lat_0=49 +lon_0=3 +x_0=1700000 +y_0=8200000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs'
    );
    proj4.defs(
      'EPSG:3950',
      '+proj=lcc +lat_1=49.25 +lat_2=50.75 +lat_0=50 +lon_0=3 +x_0=1700000 +y_0=9200000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs'
    );
    proj4.defs(
      'EPSG:2965',
      '+proj=tmerc +lat_0=37.5 +lon_0=-85.66666666666667 +k=0.999966667 +x_0=99999.99989839978 +y_0=249999.9998983998 +ellps=GRS80 +datum=NAD83 +to_meter=0.3048006096012192 +no_defs'
    );
    proj4.defs(
      'EPSG:32648',
      '+proj=utm +zone=48 +datum=WGS84 +units=m +no_defs'
    );
    proj4.defs(
      'EPSG:32630',
      '+proj=utm +zone=30 +ellps=WGS84 +datum=WGS84 +units=m +no_defs'
    );
    proj4.defs('EPSG:2972',
      '+proj=utm +zone=22 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs +type=crs');
		proj4.defs('EPSG:32628','+proj=utm +zone=28 +datum=WGS84 +units=m +no_defs +type=crs');
  }
};

define("kisprojjs", ["proj4"], function(){});


define('containers/directives/collabseMenuDirective',[],function() {
  var collapseMenu = function($rootScope, UsersFactory, gcDirectivesList) {
    return {
      templateUrl: 'js/XG/containers/views/collapseMenu.html',
      controller: [
        '$scope',
        '$element',
        '$attrs',
        function($scope, $element, $attrs) {
          $scope.collapse = 'CollapseCtrl';
          $scope.currentResources = {};
          $scope.currenttool = {};
          $scope.countacc = 3;
          $scope.firstUpload = true;

          $scope.onclick = function(tool) {
            if ($scope.currenttool != tool) {
              if (angular.isDefined(tool.active) || !$scope.firstUpload) {
                tool.active = true;
                $scope.currenttool.active = false;
                $scope.firstUpload = false;
              } else {
                tool.active = !tool.active;
                $scope.currenttool.active = !$scope.currenttool.active;
              }
              console.log(
                'lance evenement ==>' +
                  'closeTools_' +
                  $scope.currenttool.directive
              );
              $scope.$broadcast(
                'closeTools_' + $scope.currenttool.directive,
                $scope.currenttool
              );
              console.log(
                'lance evenement ==>' + 'openTools_' + tool.directive
              );
              $scope.$broadcast('openTools_' + tool.directive, tool);
              $scope.currenttool = tool;

              // log user activity
              UsersFactory.user_monitoring({
                sector: $rootScope.xgos.sector,
                path: 'map',
                category: 'map_widget',
                parameters: '[Ouverture][' + tool.name + ']',
              });
            } else {
              tool.active = !tool.active;
              $scope.$broadcast('openCloseTools_' + tool.directive, tool);
            }
          };

          // alimente la liste des directives (pour voir si elles existent encore)
          // et des metadata (aide, urlwiki)
          let directivesList = gcDirectivesList.listtools();
          let directivesMetaData = gcDirectivesList.listtoolsMetaData();

          $scope.existingDirectives = {};
          $scope.widgetTooltips = {};
          directivesList.forEach(function(x) {
            $scope.existingDirectives[x.directive] = true;
          });
          for (let i in directivesMetaData) {
            $scope.widgetTooltips[i] = {
              description: directivesMetaData[i].description,
              wiki: directivesMetaData[i].wiki,
            };
          }

          /****
           *
           * toggleallDirectives
           *
           */
          function toggleallDirectives() {
            $scope.tools.map(function(tool) {
              tool.modules.map(function(module) {
                module.active = false;
              });
            });
            var elements = angular.element('#collapseMenu').find('.panel-info');
            angular.forEach(elements, function(element) {
              angular.forEach(
                angular
                  .element(element)
                  .find('.panel-collapse.collapse.am-collapse'),
                function(el) {
                  if (angular.element(el).hasClass('in')) {
                    angular
                      .element(element)
                      .find('.panel-title a')[0]
                      .click();
                  }
                }
              );
            });
          }

          $scope.onCategorieClick = function(tooc) {
            toggleallDirectives();
            if ($scope.currenttooc != tooc) {
              console.log('lance evenementr==>newCategorie');
              $scope.$broadcast('newCategorie', $scope.currenttool);
              $scope.currenttooc = tooc;
            }
          };

          $scope.removePanel = function(tool) {
            var deleteIndex = $scope.tools
              .map(function(x) {
                return x.directive;
              })
              .indexOf(tool.directive);
            $scope.tools.splice(deleteIndex, 1);
          };
        },
      ],

      restrict: 'A',
      scope: {
        map: '=map',
        tools: '=tools',
        mode: '=mode',
        panelsManager: '=panelsManager',
        menuContext: '=menuContext',
        tableheight: '=?',
      },
    };
  };
  collapseMenu.$inject = ['$rootScope', 'UsersFactory', 'gcDirectivesList'];
  return collapseMenu;
});


define('containers/directives/widgetTooltip',[],function() {
  var widgetTooltip = function($window) {
    return {
      templateUrl: 'js/XG/containers/views/widget_tooltip.html',
      restrict: 'EA',
      scope: {
        url: '=',
      },
      link: function($scope) {
        $scope.openToolTip = function() {
          $window.open($scope.url);
        };
      },
    };
  };
  widgetTooltip.$inject = ['$window'];
  return widgetTooltip;
});


define('containers/directives/draggableDirective',[], function() {
  var gcPopup = function() {
    return {
      restrict: 'A',
      templateUrl: 'js/XG/containers/views/popup.html',

      link: function(scope, element) {
        scope.pos = {
          top: 200,
          left: 200,
        };

        scope.dragActive = false;
        scope.pageX = 0;
        scope.pageY = 0;
        scope.X = 0;
        scope.Y = 0;

        scope.onMouseDown = function(evt) {
          scope.dragActive = true;
          //event.preventDefault();
          //document.onselectstart = function() { return false; };
          scope.Y = evt.pageY - scope.pos.top;
          scope.X = evt.pageX - scope.pos.left;
        };
        scope.onMouseMove = function(event) {
          if (scope.dragActive) {
            //console.log(scope);
            var t = event.pageY - scope.Y;
            var l = event.pageX - scope.X;
            scope.pos.top = t;
            scope.pos.left = l;
            scope.$app;
          }
        };
        scope.onMouseUp = function() {
          scope.dragActive = false;
        };
        scope.onMouseLeave = function(evt) {
          if (scope.dragActive) {
            var t = evt.pageY - scope.Y;
            var l = evt.pageX - scope.X;
            scope.pos.top = t;
            scope.pos.left = l;
          }
          scope.dragActive = false;
        };
        // Add close popup function
        scope.close = function() {
          console.log('close');
          scope.$destroy();
          scope = null;
          element.remove();
        };
        scope.getUniqueID = function() {
          var uniqueID = new Date();
          var myRandom = Math.floor(Math.random() * 1000);
          return uniqueID.getTime() + '' + myRandom;
        };
      },
    };
  };

  gcPopup.$inject = [];
  return gcPopup;
});

/**
 *
 */

define('containers/services/gcPopup',[],function() {
  var gcPopup = function() {
    this.$get = function($compile, $http, $rootScope, $timeout, dialogsCommon, $window) {
      var Popup = function(options) {
        this.popup = options.scope.$new(false);
        this.popup.options = options;
        this.popup.scope = options.scope;
        this.popup.isMaximized = false;
        this.popup.isTab = false;
        this.popup.position = options.position;
        this.popup.resizeEnabled = false;
        this.popup.popupStates = {};
        this.popup.boundings = {};
        this.popup.topOffset = null;
        this.popup.iddiv = generateUniqueId();
        this.popup.className = options.className;
        this.popup.minHeight = options.minHeight;
        this.popup.minWidth = options.minWidth;

        $http
          .get('js/XG/modules/common/views/gcPopupTemplate.html')
          .then(template => {
            var element = angular.element(template.data);
            const popupElement = $compile(element)(this.popup);

            $(document.body).append(popupElement);

            $timeout(() => {
              // wait until the template draw is over
              const popupElement = $(`div[ga-draggable-zone='#${this.popup.iddiv}zone']`);
              if (popupElement) {
                let titleWidth = popupElement.find('.popupName').outerWidth() + 118;

                // dimensionne le titre avec du style inline uniquement
                // si l'option noResizeTitlebar est absente
                // permet d'éviter le très mauvais calcul de largeur et
                // le sale ajout de style inline
                if (!options.noResizeTitlebar) {
                  popupElement.css({ 'min-width': titleWidth  + 'px'});
                }
                // ajoute la possibilité de fixer une largeur minimale à la popup
                if (options.minWidth) {
                  popupElement.css({ 'min-width': options.minWidth + 'px' });
                }

                if (!options.maxWidth) {
                  this.popup.options.maxWidth = $window.innerWidth - 50;
                }
                if (!options.maxHeight) {
                  this.popup.options.maxHeight = $window.innerHeight - 50;
                }
              }

              setPopupPosition(popupElement, this.popup.position);

              if (options.content) {
                var contentElement = angular.element(options.content);
                let compiledContentElement = $compile(contentElement)(
                  this.popup.scope
                );

                let popupContentElement = popupElement.find('.popupContent');
                popupContentElement.append(compiledContentElement);
              }
            });
          });


        this.popup.maximize = () => {
          if (this.popup.isTab) {
            this.popup.savePopupState('minimized');
          }
          else {
            this.popup.savePopupState('normal');
          }

          const popupElement = $(`div[ga-draggable-zone='#${this.popup.iddiv}zone']`);

          let leftMenu = $('.mapLeftMenu');
          let leftMenuCoordinates = {};
          let displayFirstLevelBoundings = $(
            '.displayFirstLevel'
          )[0].getBoundingClientRect();
          let mapMenuWrapperBoundings = $(
            '.mapMenuWrapper'
          )[0].getBoundingClientRect();

          if (leftMenu.find('.mapMenuWrapper').hasClass('active')) {
            leftMenuCoordinates.right = mapMenuWrapperBoundings.right;
            leftMenuCoordinates.width =
              displayFirstLevelBoundings.width + mapMenuWrapperBoundings.width;
          }
          else {
            leftMenuCoordinates.right = displayFirstLevelBoundings.right;
            leftMenuCoordinates.width = displayFirstLevelBoundings.width;
          }

          popupElement.find('.panel-collapse').show();

          let popupProps = {
            top: 0,
            left: leftMenuCoordinates.right,
            width: `calc(100vw - ${leftMenuCoordinates.width}px)`,
            height: '100vh',
          };
          let popupContentProps = {
            height: 'auto',
            width: 'auto',
          };

          this.popup.updateProperties(popupProps, popupContentProps);
          this.popup.isTab = false;
          this.popup.isMaximized = true;
          this.popup.resizeEnabled = false;
        };

        this.popup.normalize = () => {
          if (this.popup.isTab) {
            this.popup.savePopupState('minimized');
          }

          let popupProps = {
            top: this.popup.popupStates.normal.popupProperties.top,
            left: this.popup.popupStates.normal.popupProperties.left,
            width: this.popup.popupStates.normal.popupProperties.width,
            height: this.popup.popupStates.normal.popupProperties.height,
            'min-height': this.popup.popupStates.normal.popupProperties.minHeight
          };

          let popupContentProps = {
            height: this.popup.popupStates.normal.popupContentProperties.height,
            width: this.popup.popupStates.normal.popupContentProperties.width,
          };

          this.popup.updateProperties(popupProps, popupContentProps);
          this.popup.isTab = false;
          this.popup.isMaximized = false;
          this.popup.resizeEnabled = true;
        };

        this.popup.makeItTab = () => {
          if (!this.popup.isMaximized && !this.popup.isTab) {
            this.popup.savePopupState('normal');
            this.popup.savePopupState('minimized');
          }

          const popupElement = $(`div[ga-draggable-zone='#${this.popup.iddiv}zone']`);

          if (this.popup.isTab) {
            // make it normal
            popupElement.find('.panel-collapse').show();
            this.popup.normalize();
            this.popup.isTab = false;
          }
          else {
            // make it tab
            popupElement.find('.panel-collapse').hide();
            let tittleWidth = popupElement.find('.popupName').outerWidth() + 118;
            popupElement.css({
              top: this.popup.popupStates.normal.popupProperties.top,
              left: this.popup.popupStates.normal.popupProperties.left,
              height: 'auto',
              width: tittleWidth,
              'min-height': 'unset'
            });
            this.popup.isTab = true;
          }

          this.popup.isMaximized = false;
          this.popup.resizeEnabled = false;
        };

        this.popup.updateProperties = (popupProps, popupContentProps) => {
          const popupElement = $(`div[ga-draggable-zone='#${this.popup.iddiv}zone']`);
          popupElement.css({
            top: popupProps.top,
            left: popupProps.left,
            width: popupProps.width,
            height: popupProps.height,
          });

          popupElement.find('.popupContent').css({
            height: popupContentProps.height,
            width: popupContentProps.width,
          });
        };

        this.popup.savePopupState = state => {
          const popupElement = $(`div[ga-draggable-zone='#${this.popup.iddiv}zone']`);
          let popupContent = $('.popupContent');
          let popupBoundings = popupElement[0].getBoundingClientRect();
          let popupPosition = popupElement.position();

          // la hauteur minimale altère la minimization, on la sauvegarde avant de la retirer
          const popupMinHeight = Number.parseInt(popupElement.css("min-height"));

          this.popup.popupStates[state] = {
            popupProperties: {
              top: popupPosition.top,
              left: popupPosition.left,
              width: popupBoundings.width,
              height: popupBoundings.height,
              minHeight: popupMinHeight
            },
            popupContentProperties: {
              width: popupContent.outerWidth(),
              height: popupContent.outerHeight(),
            },
          };
        };

        this.popup.close = _uniqueID => {
          $('#' + _uniqueID).remove();
          this.popup.removeEvents();
          $rootScope.$broadcast('closeDraggable', {
            id: angular.isDefined(this.id) ? this.id : _uniqueID,
          });
          if (this.popup.options.onclose) this.popup.options.onclose();
        };

        this.popup.resize = event => {
          const popupElement = $(`div[ga-draggable-zone='#${this.popup.iddiv}zone']`);
          let isFocused = popupElement.attr('focusedPopup') === 'true';

          if (!isFocused) {
            return;
          }

          let popupBoundings = popupElement[0].getBoundingClientRect();
          let mousePosition = { left: event.clientX, top: event.clientY };
          $('body').css({ 'user-select': 'none' });

          switch (this.popup.resizeSide) {
            case 'topResize': {
              let popupIncrement = popupBoundings.top - mousePosition.top;
              let newPopupHeight = popupElement.height() + (popupBoundings.top - mousePosition.top);

              // empêche le redimensionnement en dessous de la hauteur minimale personnalisée
              if (this.popup.minHeight > 0 && newPopupHeight < this.popup.minHeight) {
                newPopupHeight = this.popup.minHeight;
              }

              popupElement.height(newPopupHeight);
              popupElement.css({
                top: popupElement.position().top - popupIncrement,
              });

              // ajuste la hauteur de la div '.popupContent' après redimensionnement de son conteneur
              const popupContent = popupElement.find('.popupContent');
              if (popupContent !== null) {
                popupContent.css({
                  height: '100%'
                });
              }

              $('body').css({ cursor: 'n-resize' });
              break;
            }
            case 'rightResize': {
              let newPopupWidth = popupElement.width() + mousePosition.left - popupBoundings.right;
              popupElement.width(newPopupWidth);

              // ajuste la largeur de la div '.popupContent' après redimensionnement de son conteneur
              const popupContent = popupElement.find('.popupContent');
              if (popupContent !== null) {
                popupContent.css({
                      width: '100%'
                });
              }
              $('body').css({ cursor: 'e-resize' });
              break;
            }
            case 'bottomResize': {
              let newPopupHeight = popupElement.height() + mousePosition.top - popupBoundings.bottom;

              // empêche le redimensionnement en dessous de la hauteur minimale personnalisée
              if (this.popup.minHeight > 0 && newPopupHeight < this.popup.minHeight) {
                newPopupHeight = this.popup.minHeight;
              }

              popupElement.height(newPopupHeight);

              // ajuste la hauteur de la div '.popupContent' après redimensionnement de son conteneur
              const popupContent = popupElement.find('.popupContent');
              if (popupContent !== null) {
                popupContent.css({
                  height: '100%'
                });
              }

              $('body').css({ cursor: 'n-resize' });
              break;
            }
            case 'leftResize': {
              let popupIncrement = popupBoundings.left - mousePosition.left;
              let newPopupWidth = popupElement.width() + (popupBoundings.left - mousePosition.left);

              popupElement.width(newPopupWidth);
              popupElement.css({
                left: popupElement.position().left - popupIncrement,
              });

              // ajuste la largeur de la div '.popupContent' après redimensionnement de son conteneur
              const popupContent = popupElement.find('.popupContent');
              if (popupContent !== null) {
                popupContent.css({
                  width: '100%'
                });
              }
              $('body').css({ cursor: 'e-resize' });
              break;
            }
          }
        };

        this.popup.startResize = event => {
          if (
            !this.popup.isMaximized &&
            !this.popup.isTab &&
            $(event.target).hasClass('resizeSide')
          ) {
            this.popup.resizeSide = $(event.target)
              .attr('class')
              .split(' ')[1];
          }
        };

        this.popup.finishResize = () => {
          $('body').css({ cursor: 'auto' });
          this.popup.resizeSide = null;
        };

        this.popup.toggleResize = (event, state) => {
          this.popup.resizeEnabled = state;
        };

        this.popup.activateDrag = event => {
          let eventTarget = $(event.target).hasClass('resizeSide');
          if (!eventTarget) {
            this.popup.resizeEnabled = false;
          }
        };

        this.popup.checkElement = event => {
          let isHeader =
            $(event.target).closest('.headerpopup').length ||
            $(event.target).hasClass('headerpopup');
          this.popup.isHeader = !!isHeader;
        };

        this.popup.dragPopup = (popupElement, left, top) => {

          const popupWidth = parseInt(popupElement.css('width'));
          let newLeft = left;
          let newTop = top;

          //left
          if (left < 0) {
            newLeft = 0;
          }
          //right
          if (left + popupWidth > window.innerWidth) {
            newLeft = window.innerWidth - popupWidth;
          }
          //top
          if (top < 0) {
            newTop = 0;
          }
          //bottom
          if (top + 44 > window.innerHeight) {
            newTop =  window.innerHeight-44; // 44 is the popup label's height
          }

          popupElement.css({
            left: newLeft,
            top: newTop
          });
        };

        this.popup.makeItFocused = () => {
          $timeout(function() {
            if(event){
              $(event.target)
                .closest('.popupContainer')
                .css('z-index', dialogsCommon.getMaxIndex() + 1);
            }
          });

          $('.popupPanel').attr('focusedPopup', false);

          if(event){
            $(event.target)
              .closest('.popupPanel')
              .attr('focusedPopup', true);
          }
        };

        this.popup.makeItFocused();

        if (this.popup.options.resizable) {
          $(document).on('mousemove', this.popup.resize);
          $(document).on('mousedown', this.popup.startResize);
          $(document).on('mouseup', this.popup.finishResize);
        }

        this.popup.removeEvents = () => {
          if (this.popup.options.resizable) {
            $(document).off('mousemove', this.popup.resize);
            $(document).off('mousedown', this.popup.startResize);
            $(document).off('mouseup', this.popup.finishResize);
          }
        };

        function generateUniqueId() {
          const uniqueID = new Date();
          const myRandom = Math.floor(Math.random() * 1000);
          return uniqueID.getTime() + '' + myRandom;
        }

        function setPopupPosition(popup, position) {
          const pos = Object.assign({
            top: 0,
            left: 0,
          }, position);
          popup.css({
            top: pos.top,
            left: pos.left,
          });
        }

        /**
         * Style de la popup à l'initialisation d'après la configuration de l'utilisateur
         * @type {{"max-height": string, "max-width": string, width: (string|string), "min-height": string, "min-width": string, height}}
         */
        this.popup.popupInitStyle = {
          'min-width': options.minWidth + 'px',
          'min-height': options.minHeight + 'px',
          'max-width': options.maxWidth + 'px',
          'max-height': options.maxHeight + 'px',
          'height': options.height,
          'width': options.width > 0 ? options.width + 'px' : 'auto'
        };
      };

      Popup.prototype.close = function() {
        this.popup.removeEvents();
        $('#' + this.popup.iddiv).remove();
      };

      Popup.prototype.destroy = function() {
        this.popup.removeEvents();
        $('#' + this.popup.iddiv).remove();
      };

      return {
        open: function(options) {
          return new Popup(options);
        },
      };
    };
    this.$get.$inject = [
      '$compile',
      '$http',
      '$rootScope',
      '$timeout',
      'dialogsCommon',
      '$window'
    ];
  };
  return gcPopup;
});


define('containers/directives/verticaltoolbardirective',[],function() {
  var verticaltoolbardirective = function(
    $compile,
    $window,
    $timeout,
    $interval,
    $rootScope,
    UsersFactory
  ) {
    return {
      templateUrl: 'js/XG/containers/views/verticaltoolbar.html',
      restrict: 'A',
      replace: true,
      link: function(scope) {
        var toolvarsNames = {};
        scope.currenttbbuttonname = '';
        scope.$watch(
          function() {
            return scope.toolsbarbutton;
          },
          function(buttons) {
            var toolbar = angular.element(
              document.getElementById('gcverticaltoolbar')
            );
            toolbar.empty();

            if (!buttons.length) return;

            angular.forEach(scope.toolsbarbutton, function(tool, key) {
              var hasRole = true;

              if ($rootScope.xgos.user.name != 'root') {
                if (angular.isDefined(tool.roles)) {
                  if (tool.roles.length > 0) {
                    hasRole = false;

                    angular.forEach($rootScope.xgos.user.roles, function(ro) {
                      var deleteIndex = tool.roles
                        .map(function(x) {
                          return x;
                        })
                        .indexOf(ro.name);

                      if (deleteIndex > -1) {
                        hasRole = true;
                      }
                    });
                  }
                }
              }

              if (tool.type == 'widget' && hasRole) {
                toolvarsNames[tool.name] = tool;
                var ind,
                  toolName = tool.name;
                ind = toolName.indexOf('#');
                if (ind != -1) {
                  toolName = toolName.substring(0, ind);
                }
                var direct;
                if (tool.title == 'toolbarselectiontools.tbtooltip')
                  direct =
                    '<div  class="toolbar_button" id="' +
                    tool.name +
                    '" ' +
                    toolName +
                    '></div>';
                else if (angular.isUndefined(tool.title)) {
                  direct =
                    '<div  class="toolbar_button" ng-click="onclickevent(\'' +
                    tool.name +
                    '\')" id="' +
                    tool.name +
                    '" ' +
                    toolName +
                    '></div>';
                } else {
                  direct =
                    '<div  class="toolbar_button" ng-click="onclickevent(\'' +
                    tool.name +
                    '\')" id="' +
                    tool.title +
                    '" ' +
                    toolName +
                    '></div>';
                }

                var templateScope = scope.$new();
                templateScope.config = tool.config;
                templateScope.params = tool.params;
                templateScope.toolBarWidget = tool;
                templateScope.onclickevent = function(a) {

                  if (a != scope.currenttbbuttonname) {
                    scope.$broadcast(
                      'closeToolsBar_' + scope.currenttbbuttonname,
                      scope.currenttbbuttonname
                    );
                    scope.currenttbbuttonname = a;

                    // log user activity
                    UsersFactory.user_monitoring({
                      sector: $rootScope.xgos.sector,
                      path: 'map',
                      category: 'map_tool',
                      parameters: '[Ouverture][' + a + ']',
                    });
                  } else {
                    scope.currenttbbuttonname = '';
                  }

                  /**
                   * [Permet de désactiver les boutons de scrolls lorsqu'un outil est ouvert.]
                   * [Se base sur les boutons enfants direct de la vertical toolbar.]
                   */

                  //				scope.$broadcast('checkinfotoolbar');
                };
                var a = $compile(direct)(templateScope);
                toolbar.append(a);
              }
            });
          },
          true
        );


        const toolsBar = $("#gcverticaltoolbar")[0];
        // ------ Scroll sidebar --------------

        let scrollUpInterval;
        let scrollDownInterval;

        scope.startScrollUp = () => {
          scope.stopScrollUp();
          scrollUpInterval = $interval(() => {
            if (toolsBar.scrollTop > 0) {
              toolsBar.scrollTop -= 1;
            }
          }, 5);
        };
    
        scope.stopScrollUp = () => {
          $interval.cancel(scrollUpInterval);
        };
    
        scope.startScrollDown = () => {
          scope.stopScrollDown();
          scrollDownInterval = $interval(function() {
            if (toolsBar.scrollTop < (toolsBar.scrollHeight - toolsBar.clientHeight)) {
              toolsBar.scrollTop += 2;
            }
          }, 5);
        };

        scope.stopScrollDown = () => {
          $interval.cancel(scrollDownInterval);
        };

        // évalue si la barre peut être scrollée vers le bas
        scope.canScrollDown = () => {
          if (toolsBar) {
            return !((toolsBar.scrollHeight - toolsBar.clientHeight) >= Math.ceil(toolsBar.scrollTop) - 1
              && (toolsBar.scrollHeight - toolsBar.clientHeight) <= Math.ceil(toolsBar.scrollTop) + 1);
          }
        };

        // évalue si la barre peut être scrollée vers le haut
        scope.canScrollUp = () => {
          if (toolsBar) {
            return toolsBar.scrollTop !== 0;
          }
        };

        scope.$on('checkinfotoolbar', function() {
          $timeout(function() {
            var buttonActive = angular.element(
              document.getElementsByClassName('toolbarscroll')
            );
            var disabled = false;
            var clickedButton = angular.element(
              document
                .getElementById('gcverticaltoolbar')
                .getElementsByClassName('toolbar_button')
            );
            if (clickedButton !== []) {
              for (var i = clickedButton.length - 1; i >= 0; i--) {
                if (
                  angular
                    .element(clickedButton[i].firstElementChild)
                    .hasClass('btn-info') &&
                  disabled === false
                ) {
                  disabled = true;
                }
              }
              if (disabled === true) {
                buttonActive.addClass('disabledScroll');
              } else {
                disabled = false;
                buttonActive.removeClass('disabledScroll');
              }
            }
          }, 500);
        });
      },
    };
  };

  verticaltoolbardirective.$inject = [
    '$compile',
    '$window',
    '$timeout',
    '$interval',
    '$rootScope',
    'UsersFactory',
  ];
  return verticaltoolbardirective;
});


define('containers/directives/resizable',[], function() {
  var resizable = function($document, $rootScope) {
    return {
      restrict: 'EA',
      scope: {
        resizeOrigin: '@?',
        resizeOriginId: '@?',
      },
      link: function(scope, element, attrs) {
        var parent = angular.element(element).parent()[0];
        var baseY;
        var currentHeight;
        var heightToAdd;
        var newHeight;

        element.on('mousedown', function(event) {
          event.preventDefault();

          baseY = event.pageY;
          currentHeight = parent.offsetHeight;

          $document.on('mousemove', mousemove);
          $document.on('mouseup', mouseup);
        });

        function resizeY() {
          parent.style.height = newHeight + 'px';
          parent.style.minHeight = 'auto';
        }

        function mousemove(event) {
          // Handle vertical resizer
          var y = event.pageY;
          heightToAdd = baseY - y;
          newHeight = currentHeight + heightToAdd;
          /*console.log('----------------------------');
                        console.log('baseY:'+baseY);
                        console.log('y:'+y);
                        console.log('currentHeight:'+currentHeight);
                        console.log('heightToAdd:'+heightToAdd);
                        console.log('newHeight:'+newHeight);
                        console.log('----------------------------');*/
          resizeY();
        }

        function emitResize() {
          if (scope.resizeOrigin) {
            $rootScope.$broadcast('elementResized', {
              element: {
                type: scope.resizeOrigin,
                id: scope.resizeOriginId,
              },
              transformation: {
                y: heightToAdd,
              },
            });
          }
        }
        function mouseup(event) {
          emitResize();
          $document.unbind('mousemove', mousemove);
          $document.unbind('mouseup', mouseup);
        }

        $rootScope.$on('forceElementResize', function(event, args) {
          if (
            args.element.type == scope.resizeOrigin &&
            args.element.id == scope.resizeOriginId
          ) {
            newHeight = args.dimensions.y;
            heightToAdd = args.dimensions.y - parent.offsetHeight;
            resizeY();
            emitResize();
          }
        });
      },
    };
  };

  resizable.$inject = ['$document', '$rootScope'];
  return resizable;
});


define('containers/directives/resizableModal',[], function() {
  var resizableModal = function($document, $rootScope) {
    return {
      restrict: 'A',

      link: function(scope, element, attrs) {
        // add direction items
        var box = angular.element(element),
          html =
            '<div class="dir" id="nw"></div>' +
            '<div class="dir" id="n"></div>' +
            '<div class="dir" id="ne"></div>' +
            '<div class="dir" id="w"></div>' +
            '<div class="dir" id="e"></div>' +
            '<div class="dir" id="sw"></div>' +
            '<div class="dir" id="s"></div>' +
            '<div class="dir" id="se"></div>';

        box.addClass('resizableModal');
        box.prepend(html);

        var prev_x = -1,
          prev_y = -1,
          dir = null,
          directions = element.find('.dir');

        directions.bind('mousedown', function(e) {
          e.preventDefault();
          prev_x = e.clientX;
          prev_y = e.clientY;
          dir = angular.element(event.target || event.srcElement).prop('id');
        });

        $document.mousemove(function(e) {
          if (prev_x == -1) return;

          var boxX = box.prop('offsetLeft'),
            boxY = box.prop('offsetTop'),
            boxW = box[0].offsetWidth,
            boxH = box[0].offsetHeight,
            dx = e.clientX - prev_x,
            dy = e.clientY - prev_y;

          if (dir.indexOf('n') > -1) {
            boxY += dy;
            boxH -= dy;
          }
          if (dir.indexOf('s') > -1) {
            boxH += dy;
          }
          if (dir.indexOf('w') > -1) {
            boxX += dx;
            boxW -= dx;
          }
          if (dir.indexOf('e') > -1) {
            boxW += dx;
          }

          box[0].style.top = boxY + 'px';
          box[0].style.left = boxX + 'px';
          box[0].style.width = boxW + 'px';
          box[0].style.height = boxH + 'px';

          prev_x = e.clientX;
          prev_y = e.clientY;
        });

        $(document).mouseup(function() {
          prev_x = -1;
          prev_y = -1;
        });
      },
    };
  };

  resizableModal.$inject = ['$document', '$rootScope'];
  return resizableModal;
});


define('containers/directives/kisProcess',['toastr','toastr','toastr'],function() {
  var kisProcess = function(
    $rootScope,
    gaDomUtils,
    $timeout,
    $filter,
    ngDialog,
    $interval,
    processFactory,
    ngTableParams,
    $location,
    gaUrlUtils
  ) {
    return {
      templateUrl: 'js/XG/containers/views/kis_process.html',
      restrict: 'EA',
      scope: {
        map: '=?',
      },
      controller: [
        '$scope',
        function($scope) {
          // $scope.eventSources = [{
          //     events: []
          // }];
        },
      ],
      link: function(scope) {
        scope.processtabs = [
          {
            title: 'process.mbtiles.main',
          },
          {
            title: 'process.geopackage.main',
          },
          {
            title: 'process.docxprocess.main',
          },
        ];
        scope.processtabs.activeTab = 0;
        scope.processtabs.autorefresh = true;

        scope.currentFormData = {
          mbtiles: undefined,
          gpkg: undefined,
          docx: undefined,
        };

        var TYPES = ['mbtiles', 'gpkg', 'docx'];
        scope.refreshallLists = function(b) {
          if (b && b === 'frombtn') gaDomUtils.showGlobalLoader();
          processFactory.getProcessByUserSpecial(TYPES.join(',')).then(
            function(res) {
              try {
                scope.currentFormData = res.data;
                scope.tableParamsProcess.reload();
              } catch (e) {
                console.error(e.stack);
              }
              if (b && b === 'frombtn') gaDomUtils.hideGlobalLoader();
            },
            function() {
              if (b && b === 'frombtn') gaDomUtils.hideGlobalLoader();
            }
          );
        };
        scope.refreshallLists('first');

        /**
         * Paramètres du tableau listant les règles associées au currentfeaturetype passé à cette directive
         */
        scope.tableParamsProcess = new ngTableParams(
          {
            page: 1, //ng-table show first page
            count: 10, // count per page
          },
          {
            total: 0, // length of data
            getData: function($defer, params) {
              try {
                switch (scope.processtabs.activeTab) {
                  case 0:
                    if (scope.currentFormData.mbtiles) {
                      var displayedTab = scope.currentFormData.mbtiles.slice(
                        (params.page() - 1) * params.count(),
                        params.page() * params.count()
                      );

                      params.total(scope.currentFormData.mbtiles.length); // set total for recalc pagination
                      $defer.resolve(displayedTab);
                    } else {
                      $defer.resolve([]);
                    }
                    break;
                  case 1:
                    if (scope.currentFormData.gpkg) {
                      displayedTab = scope.currentFormData.gpkg.slice(
                        (params.page() - 1) * params.count(),
                        params.page() * params.count()
                      );

                      params.total(scope.currentFormData.gpkg.length); // set total for recalc pagination
                      $defer.resolve(displayedTab);
                    } else {
                      $defer.resolve([]);
                    }
                    break;
                  case 2:
                    if (scope.currentFormData.docx) {
                      displayedTab = scope.currentFormData.docx.slice(
                        (params.page() - 1) * params.count(),
                        params.page() * params.count()
                      );

                      params.total(scope.currentFormData.docx.length); // set total for recalc pagination
                      $defer.resolve(displayedTab);
                    } else {
                      $defer.resolve([]);
                    }
                    break;
                }
              } catch (e) {
                console.error(e.stack);
                $defer.resolve([]);
              }
            },
          }
        );

        scope.$watch('processtabs.activeTab', function(newval) {
          if (angular.isDefined(newval)) scope.tableParamsProcess.reload();
        });

        var stop;
        scope.changedRefresh = function() {
          if (scope.processtabs.autorefresh) {
            scope.refreshallLists();
            stop = $interval(function() {
              scope.refreshallLists();
            }, 5000);
          } else {
            if (stop) $interval.cancel(stop);
          }
        };

        var btnstop;
        var stopnewclign = function() {
          angular
            .element(document.querySelector('.ProcessNav'))
            .removeClass('modified-options-true');
          if (stopnewclign) $interval.cancel(btnstop);
        };

        scope.$on('newProcessCreated', function(evt, arg) {
          scope.refreshallLists();
          if (angular.isDefined(arg)) scope.processtabs.activeTab = arg;
          if (!$rootScope.process.visible) {
            angular
              .element(document.querySelector('.ProcessNav'))
              .addClass('modified-options-true');
            btnstop = $interval(function() {
              stopnewclign();
            }, 10000);
          }
        });

        scope.$on('newProcessStop', function() {
          stopnewclign();
        });

        scope.removeProcess = function(idx) {
          try {
            idx =
              (scope.tableParamsProcess.page() - 1) *
                scope.tableParamsProcess.count() +
              idx;
            var callback = function(isConfirm) {
              if (isConfirm) {
                switch (scope.processtabs.activeTab) {
                  case 0:
                    processFactory
                      .deleteProcess(scope.currentFormData.mbtiles[idx])
                      .then(
                        function(res) {
                          $timeout(function() {
                            scope.currentFormData.mbtiles.splice(idx, 1);
                            scope.tableParamsProcess.reload();
                            swal(
                              $filter('translate')('portals.process.title'),
                              $filter('translate')(
                                'portals.process.object_removed'
                              ),
                              'success'
                            );
                          }, 500);
                        },
                        function() {
                          require('toastr').error(
                            $filter('translate')(
                              'process.process.processnotavailabe'
                            )
                          );
                        }
                      );
                    break;
                  case 1:
                    processFactory
                      .deleteProcess(scope.currentFormData.gpkg[idx])
                      .then(
                        function(res) {
                          $timeout(function() {
                            scope.currentFormData.gpkg.splice(idx, 1);
                            scope.tableParamsProcess.reload();
                            swal(
                              $filter('translate')('portals.process.title'),
                              $filter('translate')(
                                'portals.process.object_removed'
                              ),
                              'success'
                            );
                          }, 500);
                        },
                        function() {
                          require('toastr').error(
                            $filter('translate')(
                              'process.process.processnotavailabe'
                            )
                          );
                        }
                      );
                    break;
                  case 2:
                    processFactory
                      .deleteProcess(scope.currentFormData.docx[idx])
                      .then(
                        function(res) {
                          $timeout(function() {
                            scope.currentFormData.docx.splice(idx, 1);
                            scope.tableParamsProcess.reload();
                            swal(
                              $filter('translate')('portals.process.title'),
                              $filter('translate')(
                                'portals.process.object_removed'
                              ),
                              'success'
                            );
                          }, 500);
                        },
                        function() {
                          require('toastr').error(
                            $filter('translate')(
                              'process.process.processnotavailabe'
                            )
                          );
                        }
                      );
                    break;
                }
              }
            };
            swal(
              {
                title: $filter('translate')('portals.process.title'),
                text: $filter('translate')('portals.process.confirm_delete'),
                type: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#d9534f',
                confirmButtonText: $filter('translate')('common.yes'),
                cancelButtonText: $filter('translate')('common.no'),
                closeOnConfirm: true,
                closeOnCancel: true,
              },
              callback
            );
          } catch (e) {
            console.error(e.stack);
          }
        };

        scope.showQrProcess = function(idx) {
          try {
            idx =
              (scope.tableParamsProcess.page() - 1) *
                scope.tableParamsProcess.count() +
              idx;
            switch (scope.processtabs.activeTab) {
              case 0:
                var mobhost =
                  $location.protocol() +
                  '://' +
                  $location.host() +
                  ':' +
                  $location.port();
                var appname = localStorage.getItem('app');
                if ($location.search().app) {
                  appname = $location.search().app;
                }
                scope.mobqrcode =
                  '/services/' +
                  $rootScope.xgos.portal.uid +
                  '/process/qrcode?name=' +
                  appname +
                  '&token=' +
                  gaUrlUtils.encodeUriQuery(
                    localStorage.getItem('auth_token')
                  ) +
                  '&url=' +
                  mobhost +
                  '&uid=' +
                  scope.currentFormData.mbtiles[idx].uid;
                scope.titleqrcode =
                  $filter('translate')('process.process.qrmbtiles') +
                  ' ' +
                  scope.currentFormData.mbtiles[idx].file;
                ngDialog.open({
                  template: 'js/XG/widgets/mapapp/main/views/barecode.html',
                  className: 'ngdialog-theme-plain width300 miniclose',
                  closeByDocument: false,
                  scope: scope,
                });
                break;
              case 1:
                mobhost =
                  $location.protocol() +
                  '://' +
                  $location.host() +
                  ':' +
                  $location.port();
                var appname = localStorage.getItem('app');
                if ($location.search().app) {
                  appname = $location.search().app;
                }
                scope.mobqrcode =
                  '/services/' +
                  $rootScope.xgos.portal.uid +
                  '/process/qrcode?name=' +
                  appname +
                  '&token=' +
                  gaUrlUtils.encodeUriQuery(
                    localStorage.getItem('auth_token')
                  ) +
                  '&url=' +
                  mobhost +
                  '&uid=' +
                  scope.currentFormData.gpkg[idx].uid;
                scope.titleqrcode =
                  $filter('translate')('process.process.qrmbtiles') +
                  ' ' +
                  scope.currentFormData.gpkg[idx].file;
                ngDialog.open({
                  template: 'js/XG/widgets/mapapp/main/views/barecode.html',
                  className: 'ngdialog-theme-plain width300 miniclose',
                  closeByDocument: false,
                  scope: scope,
                });
                break;
            }
          } catch (e) {
            console.error(e.stack);
          }
        };

        scope.downloadProcess = function(idx) {
          try {
            idx =
              (scope.tableParamsProcess.page() - 1) *
                scope.tableParamsProcess.count() +
              idx;
            switch (scope.processtabs.activeTab) {
              case 0:
                if (
                  scope.currentFormData.mbtiles[idx].type.split('/').length ===
                  1
                )
                  window.open(
                    '/services/' +
                      $rootScope.xgos.portal.uid +
                      '/mbtiles/getFile?f=json&uid=' +
                      scope.currentFormData.mbtiles[idx].uid +
                      '&etat=' +
                      scope.currentFormData.mbtiles[idx].etat +
                      '&file=' +
                      scope.currentFormData.mbtiles[idx].file +
                      '&type=' +
                      scope.currentFormData.mbtiles[idx].type +
                      '&token=' +
                      encodeURIComponent(localStorage.getItem('auth_token'))
                  );
                else {
                  window.open(
                    '/services/' +
                      $rootScope.xgos.portal.uid +
                      '/geopackage/getZipFile?f=json&uid=' +
                      scope.currentFormData.mbtiles[idx].uid +
                      '&etat=' +
                      scope.currentFormData.mbtiles[idx].etat +
                      '&file=' +
                      scope.currentFormData.mbtiles[idx].file +
                      '&type=mbtiles&token=' +
                      encodeURIComponent(localStorage.getItem('auth_token'))
                  );
                }
                break;
              case 1:
                if (
                  scope.currentFormData.gpkg[idx].type.split('/').length === 1
                )
                  window.open(
                    '/services/' +
                      $rootScope.xgos.portal.uid +
                      '/geopackage/getFile?f=json&uid=' +
                      scope.currentFormData.gpkg[idx].uid +
                      '&etat=' +
                      scope.currentFormData.gpkg[idx].etat +
                      '&file=' +
                      scope.currentFormData.gpkg[idx].file +
                      '&type=' +
                      scope.currentFormData.gpkg[idx].type +
                      '&token=' +
                      encodeURIComponent(localStorage.getItem('auth_token'))
                  );
                else {
                  window.open(
                    '/services/' +
                      $rootScope.xgos.portal.uid +
                      '/geopackage/getZipFile?f=json&uid=' +
                      scope.currentFormData.gpkg[idx].uid +
                      '&etat=' +
                      scope.currentFormData.gpkg[idx].etat +
                      '&file=' +
                      scope.currentFormData.gpkg[idx].file +
                      '&type=mbtiles&token=' +
                      encodeURIComponent(localStorage.getItem('auth_token'))
                  );
                }
                break;
              case 2:
                if (
                  scope.currentFormData.docx[idx].type.split('/').length === 1
                )
                  window.open(
                    '/services/' +
                      $rootScope.xgos.portal.uid +
                      '/documents/getFileProcess?f=json&uid=' +
                      scope.currentFormData.docx[idx].uid +
                      '&token=' +
                      encodeURIComponent(localStorage.getItem('auth_token'))
                  );
                break;
            }
          } catch (e) {
            console.error(e.stack);
          }
        };
      },
    };
  };

  kisProcess.$inject = [
    '$rootScope',
    'gaDomUtils',
    '$timeout',
    '$filter',
    'ngDialog',
    '$interval',
    'processFactory',
    'ngTableParams',
    '$location',
    'gaUrlUtils',
  ];
  return kisProcess;
});


define('containers/directives/kisCalendar',['toastr','toastr'],() => {
  const kisCalendar = (
    $rootScope,
    $timeout,
    gaDomUtils,
    $filter,
    kisCalendarFactory,
    CalendarFactory,
    ConfigFactory,
    uiCalendarConfig,
    $q,
    AncAppFactory,
    gaBrowserSniffer,
    ngDialog,
    FeatureTypeFactory,
    $compile
  ) => {
    const kisCalendarLink = (scope) => {

      onInit();

      const agentsPlaceholder = 'Tous les Agents';
      const creatorPlaceholder = 'Tous les Créateurs';
      const eventTypesPlaceholder = 'Tous les types d\'événements';

      scope.viewType = 'calendar';
      scope.eventsTaken = {};
      scope.startWhenViewList;
      scope.endWhenViewList;

      scope.refreshEvents = () => {
        removeEvents();
        getCalendarEvents(scope.eventsFilters)
          .then(events => {
            changeEvents(events);
          })
          .finally(() => {
            gaDomUtils.hideGlobalLoader();
          });
      }

      scope.addNewEvent = () => {
        openCalendarEvent();
      }

      scope.onChangeViewType = (viewType) => {
        scope.viewType = viewType;
        if (viewType === 'list') {
          resolveListEvents();
        } else {
          scope.calendar_list_data = [];
          removeEvents();
        }
      }

      scope.onChangeViewDetails = (details) => {
        if (details) {
          scope.showDescription = details.showDescription;
          scope.showNumber = details.showNumber;
        }
        changeEvents(angular.copy(scope.eventSources[0].events));
      }

      scope.onChangedFilters = (eventsFilters) => {
        scope.eventsFilters = eventsFilters;
        if (scope.viewType === 'list') {
          resolveListEvents();
        } else {
          removeEvents();
          getCalendarEvents(eventsFilters)
            .then(events => {
              changeEvents(events);
            })
            .finally(() => {
              gaDomUtils.hideGlobalLoader();
            });
        }
      }

      scope.goToMonth = function () {
        const date = new Date();
        const numMonth = getNumberMonth(scope.selectedMonth);
        date.setMonth(numMonth);
        uiCalendarConfig.calendars['kisCalendar'].fullCalendar('gotoDate', date);
      };

      scope.goToYear = function () {
        const calendarCurrYear = uiCalendarConfig.calendars['kisCalendar'].fullCalendar('getDate');
        const yearDiff = scope.selectedYear - calendarCurrYear.year();

        uiCalendarConfig.calendars['kisCalendar'].fullCalendar(
          'gotoDate',
          calendarCurrYear.add(yearDiff, 'year')
        );
      };

      scope.openPopupAddAvent = function () {
        scope.addCtrl = {
          value: scope.ajouterctrl,
        };
        scope.showCalendarEvent = false;
        var title;
        if (scope.currentEvent && scope.currentEvent.id) {
          title = scope.currentEvent.id;
        } else {
          title = 'Ajouter un nouvel événement';
        }
        if (scope.agentCalendar && scope.agentCalendar.value) {
          scope.currentagent = scope.agentCalendar.value.login;
        }
        scope.agendaControle = ngDialog.open({
          template: 'js/XG/containers/views/popupAddEvent.html',
          className:
            'ngdialog-theme-plain width600 height400 miniclose nopadding',
          closeByDocument: false,
          scope: scope,
        });
      };

      scope.$on('closeNgDialogAgendaCtrl', function (event) {
        if (scope.agendaControle) scope.agendaControle.close();
      });

      scope.getEventLabelFromType = (id) => {
        var idx = scope.eventTypes
          .map(et => et.properties.type_id)
          .indexOf(id);
        if (scope.eventTypes[idx]) {
          return scope.eventTypes[idx].properties.alias;
        }
      };

      scope.openInvitePage = function () {
        scope.invitedevents = [];
        var url = $location.absUrl().split('#')[0] + '#/calendar_invite';
        window.open(url);
      };

      scope.setEventSize = function (size) {
        scope.eventDisplay.size = size;
      };

      scope.editEvent = function (event) {
        scope.currentEvent = angular.copy(event);
        scope.showCalendarEvent = true;
      };

      scope.$watch('plagehoraire', (newVal) => {
        if (newVal && newVal.jours) {
          scope.businessHours = getBusinessHours();
          if (scope.uiConfig && scope.uiConfig.calendar) {
            scope.uiConfig.calendar.defaultView = scope.calendarView
              && scope.calendarView.type || scope.defaultView;
            scope.uiConfig.calendar.defaultDate = scope.start_datetime
              || scope.defaultDate;
            scope.uiConfig.calendar.businessHours
              = scope.businessHours.businessIntervals;
            scope.uiConfig.calendar.minTime = scope.businessHours.minHour;
            scope.uiConfig.calendar.maxTime = scope.businessHours.maxHour;
            //-- Ne pas faire apparaître dans le calendrier
            //-- les jours configurés comme étant à ne pas utiliser
            //-- pour les rendez-vous.
            scope.uiConfig.calendar.hiddenDays = scope.businessHours.hiddenDays;
          }
        }
      }, true);

      scope.getWeekNumber = () => {
        if (!scope.weekNumberToShow) { 
          return '0'; 
        } else {
          return  scope.weekNumberToShow
        }
       
      }

      $rootScope.$on('$translateChangeEnd', function () {
        setCalendarLanguage();
      });

      $rootScope.$on('kis_calendar_event_refresh', function () {
        scope.eventDisplay.size = 'm';
        if (scope.viewType === 'list') {
          return resolveListEvents();
        } else {
          scope.refreshEvents();
          scope.currentEvent = {};
          scope.showCalendarEvent = false;
        }
      });
      $rootScope.$on('kis_calendar_eventAgent_refresh', function () {
        scope.eventDisplay.size = 'm';
        scope.refreshEvents();
        scope.currentEvent = {};
        scope.showCalendarEvent = false;
      });

      function getNumberMonth(monthName) {
        return scope.monthsList.findIndex((month) => month === monthName);
      }

      function setCalendarLanguage() {
        scope.calendarButtonTexts = {
          today: $filter('translate')('tools.calendar.ui.buttons.today'),
          month: $filter('translate')('tools.calendar.ui.buttons.month'),
          week: $filter('translate')('tools.calendar.ui.buttons.week'),
          day: $filter('translate')('tools.calendar.ui.buttons.day'),
        };
        scope.calendarAllDayText = $filter('translate')(
          'tools.calendar.ui.buttons.allday'
        );
        if (scope.rdvAuto) {
          scope.defaultDate = scope.dateRdvs;
        }
        const currLanguage = localStorage.getItem('current_language') || 'fr';
        if (currLanguage == 'fr') {
          scope.timeFormat = 'H:mm';
          scope.axisFormat = 'H:mm';
          scope.allDayText = 'Journée';
        } else {
          scope.timeFormat = 'H[h]';
          scope.axisFormat = 'h(:mm)a';
          scope.allDayText = 'all-day';
        }
      }

      function onInit() {

        scope.$on('$destroy', function () {
          $rootScope.$broadcast('kis_calendar_destroy');
        });

        watchChangedAgent();
        resolveFiltersOptions();
        setCalendarLanguage();

        setMonthsList();
        setYearsList();

        scope.eventSources = [{ events: [] }];

        if (scope.currentEvent || scope.rdvAuto) {
          scope.defaultView = 'agendaDay';
        } else {
          scope.defaultView = 'month';
        }

        scope.eventDisplay = {
          size: scope.currentEvent && scope.rdvAuto ? 'xl' : 'm',
        };

        if (scope.currentEvent) {
          scope.showCalendarEvent = true;
        }

        resolveEventTypes().then(() => {
          initUiCalendarConfig();
        });
      }

      function setMonthsList() {
        scope.monthsList = [
          'janvier',
          'février',
          'mars',
          'avril',
          'mai',
          'juin',
          'juillet',
          'août',
          'septembre',
          'octobre',
          'novembre',
          'décembre'
        ];
        const date = new Date();
        const monthNumber = date.getMonth();
        scope.selectedMonth = scope.monthsList[monthNumber];
      }

      function setYearsList() {
        scope.selectedYear = moment().year();
        scope.yearsList = [];
        for (
          var i = scope.selectedYear - 25;
          i < scope.selectedYear + 10;
          i++
        ) {
          scope.yearsList.push(i);
        }
      }

      function watchChangedAgent() {
        scope.$watch('selectedAgent', (agent) => {
          if (agent && agent.login) {
            const eventsFilters = Object.assign(scope.eventsFilters || {}, { agent: agent.login });
            scope.onChangedFilters(eventsFilters);
          }
        });
      }

      function resolveListEvents() {
        gaDomUtils.showGlobalLoader();

        scope.calendar_list_data = [];
        getEvents(scope.eventsFilters).then(data => {
          scope.calendar_list_data = data.features.sort(function (a, b) {
            return (
              gaBrowserSniffer.parseDateSpecIE(a.properties.start) -
              gaBrowserSniffer.parseDateSpecIE(b.properties.start)
            );
          });
        }).finally(() => gaDomUtils.hideGlobalLoader());
      }


      const initUiCalendarConfig = () => {
        scope.businessHours = getBusinessHours();

        scope.uiConfig = {
          calendar: {
            firstDay: 1,
            //-- Jour à ne pas faire apparaître dans le calendrier.
            hiddenDays: scope.businessHours.hiddenDays,
            slotEventOverlap: false,
            height: scope.heightCalendar || 650,
            slotDuration: '00:15:00',
            editable: true,
            buttonText: scope.calendarButtonTexts,
            handleWindowResize: false,
            header: {
              left: 'month agendaWeek agendaDay',
              center: 'title',
              right: 'today prev,next',
            },
            // dddd : c'est le jour 
            columnFormat: {
              agendaWeek: 'dddd D/MM',
              month: 'dddd',
            },
            titleFormat: 'D MMMM YYYY',
            eventClick: eventClick,
            eventDrop: eventDrop,
            eventResize: eventResize,
            defaultView: scope.defaultView,
            defaultDate: scope.defaultDate,
            allDayText: scope.calendarAllDayText,
            selectable: true,
            selectHelper: true,
            timezone: 'local',
            businessHours: scope.businessHours.businessIntervals,
            axisFormat: scope.axisFormat,
            timeFormat: scope.timeFormat,
            minTime: scope.businessHours.minHour,
            maxTime: scope.businessHours.maxHour,
            select: select,
            eventRender: eventRender,
            viewRender: (view) => {
              let refreshEvents = !scope.calendarView || scope.calendarView.type !== view.type || scope.calendarView.start.toISOString() !== view.start.toISOString();

              scope.calendarView = Object.assign({}, view);
              scope.disableDescription = false;

              if (view.name === 'agendaWeek') {
                scope.disableDescription = false;
              }

              scope.typeViewCal = view.name;
              scope.titleCal = view.title;
              let currentStartViewDate = new Date(view.start.toISOString());
              let startDate = new Date(currentStartViewDate.getFullYear(), 0, 1);
              let  days = Math.floor((currentStartViewDate - startDate) /
              (24 * 60 * 60 * 1000));
              scope.weekNumberToShow = Math.ceil(days / 7);
              // Correction de la date en cas de changement de l'année avant le mois
              // En effet quand on change l année avant le mois , les années augmentent deux ans et un an (à comprendre)  
              scope.start_datetime = new Date(view.start).toISOString().split('T')[0];

              if (scope.typeViewCal === 'month') {
                scope.end_datetime =  new Date(new Date(scope.start_datetime).getTime() + (1000 * 3600 * 24 * 30)).toISOString().split('T')[0]
              } else if (scope.typeViewCal === 'week') {
                scope.end_datetime =  new Date(new Date(scope.start_datetime).getTime() + (1000 * 3600 * 24 * 7)).toISOString().split('T')[0]
              } else {
                scope.end_datetime = view.end.toISOString();
              }

              switch (view.type) {
                case 'month':
                  const tmp = view.title.replace(/[0-9]/g, '').trim();
                  scope.selectedMonth = tmp.substring(tmp.lastIndexOf(' ') + 1);
                  break;
              }
              if (refreshEvents) {
                removeEvents();
                getCalendarEvents(scope.eventsFilters)
                  .then(events => {
                    changeEvents(events);
                  })
                  .finally(() => {
                    gaDomUtils.hideGlobalLoader();
                  });
              }
            },
          }
        };
        // pas d'affichage des weekends et subdivision en 4 de la plage horaire en consultation du calendrier
        if ($rootScope.calendar.visible) {
          scope.uiConfig.calendar.weekends = false;
          scope.uiConfig.calendar.slotDuration = '00:15:00';
        }
      };


      const getBusinessHours = () => {
        const days = ['MONDAY', 'TUESDAY', 'WEDNESDAY', 'THURSDAY', 'FRIDAY',
          'SATURDAY'];
        let daysOfWeek = [1, 2, 3, 4, 5];
        const defaultBusinessHours = {
          dow: daysOfWeek,
          start: '07:00',
          end: '19:00',
        };

        if (!scope.plagehoraire || !scope.plagehoraire.jours) {
          return {
            businessIntervals: [defaultBusinessHours],
            minHour: defaultBusinessHours.start,
            maxHour: defaultBusinessHours.end,
          };
        }

        daysOfWeek = [];
        let businessIntervals = [];
        const hiddenDays = [];

        Object.keys(scope.plagehoraire.jours).forEach((day) => {
          const dayNum = days.indexOf(day) + 1;
          const dayValues = scope.plagehoraire.jours[day];
          if (!dayValues.active) {
            //-- Alimentation de la liste des jours
            //-- à ne pas mettre dans le calendrier.
            hiddenDays.push(dayNum);
          }
          if (!dayValues.matinee && !dayValues.apresmidi) { return; }
          const minHour1 = dayValues.matinee && dayValues.dateDebut1
            ? moment(dayValues.dateDebut1).format('HH:mm')
            : null;
          const maxHour1 = dayValues.matinee && dayValues.dateFin1
            ? moment(dayValues.dateFin1).format('HH:mm')
            : null;
          const minHour2 = dayValues.apresmidi && dayValues.dateDebut2
            ? moment(dayValues.dateDebut2).format('HH:mm')
            : null;
          const maxHour2 = dayValues.apresmidi && dayValues.dateFin2
            ? moment(dayValues.dateFin2).format('HH:mm')
            : null;

          if (minHour1 && maxHour1) {
            businessIntervals.push({
              dow: [dayNum],
              start: minHour1,
              end: maxHour1,
            });
          }

          if (minHour2 && maxHour2) {
            businessIntervals.push({
              dow: [dayNum],
              start: minHour2,
              end: maxHour2,
            });
          }
        });


        if (businessIntervals.length === 0) {
          businessIntervals = [defaultBusinessHours];
        }

        const calendarMinMax = getCalendarMinMax(businessIntervals);

        const minHour = moment(calendarMinMax.min).add(getHoursToAddToMin(calendarMinMax.min), 'hours').add(1, 'seconds').format('HH:mm');
        const maxHour = moment(calendarMinMax.max).add(getHoursToAddToMax(calendarMinMax.max), 'hours').add(-1, 'seconds').format('HH:mm');

        return { businessIntervals, minHour, maxHour, hiddenDays };
      }


      function getHoursToAddToMin(date) {
        return moment(date).format('HH') > 0
          ? -1
          : 0;
      }

      function getHoursToAddToMax(date) {
        return moment(date).diff(moment('23:00', 'HH:mm')) > 0
          ? 0
          : moment(date).diff(moment('22:00', 'HH:mm')) > 0
            ? 1
            : 2;
      }

      function eventResize(event, delta, revertFunc) {
        eventResizeDrop(event.kis_event, 'resize', delta, revertFunc);
      };

      function eventDrop(event, delta, revertFunc) {
        eventResizeDrop(event.kis_event, 'drop', delta, revertFunc);
      };

      function eventResizeDrop(event, type, delta, revertFunc) {
        let canModifyEvent;
        const isUserManagerOrRoot = $rootScope.xgos.user.login == 'root' || $rootScope.xgos.user.roles.filter(role => role.name === 'kis_calendar_manager').length;
        if ($rootScope.xgos.user.name == event.properties.created_by || isUserManagerOrRoot) {
          canModifyEvent = true;
        }

        if (!canModifyEvent) {
          return revertFunc();
        }

        const confirmed = confirm($filter('translate')('tools.calendar.ui.event_actions.' + type + '.confirm'));
        if (!confirmed) {
          return revertFunc();
        }

        if (type == 'drop') {
          event.properties.start = moment(event.properties.start)
            .add(delta)
            .format();
        }
        event.properties.end = moment(event.properties.end)
          .add(delta)
          .format();

        event.properties.start = formatDate(event.properties.start);
        event.properties.end = formatDate(event.properties.end);
        CalendarFactory.updateeventtime({
          type: 'FeatureCollection',
          features: [event],
        }).then(() => {
          kisCalendarFactory.refreshListeDossier()
          refreshCtrlsPriseRdv();
          require('toastr').success(
            $filter('translate')('tools.calendar.ui.event_actions.' + type + '.done'),
            { positionClass: 'toast-bottom-left' }
          );
        });
      }

      function formatDate(dateSource) {
        let date = moment(dateSource);
        date = date.toISOString();
        date = $filter('date')(date, 'yyyy-MM-ddTHH:mm:ss.sssZ');
        return date;
      }

      function getCalendarMinMax(businessIntervals) {
        const hours = {};
        businessIntervals.forEach(interval => {
          hours.min = getMinDate(hours.min, moment(interval.start, 'HH:mm'));
          hours.max = getMaxDate(hours.max, moment(interval.end, 'HH:mm'));
        });
        return {
          min: moment(hours.min),
          max: moment(hours.max).add(-1, 'hours'),
        };
      }

      function getMinDate(date1, date2) {
        return !date1 || moment(date1).diff(moment(date2)) > 0
          ? date2
          : date1;
      }

      function getMaxDate(date1, date2) {
        return !date1 || moment(date1).diff(moment(date2)) < 0
          ? date2
          : date1;
      }

      function eventClick(event) {
        // l id du contrôle auquel le rdv est associé
        const idDossier = event.kis_event.relations.dossierId.split('.')[1];
        // l id du dossier auquel le rdv est associé
        const idControle = event.kis_event.relations.controleId.split('.')[1];
        if (scope.deleteButtonActivated) {
          kisCalendarFactory.annulerEvent(event.kis_event.id, scope.refreshEvents,event.kis_event.relations.dossierId)
            .then(refreshCtrlsPriseRdv);
          scope.deleteButtonActivated = false;
        } else if (scope.openFolderButtonActivated) {
          ouvreDossier(event);
          scope.openFolderButtonActivated = false;
        } else {
          scope.showCalendarEvent = true;
          scope.currentEvent = {
            id: event.kis_event.id,
            properties: event.kis_event.properties,
            type: event.kis_event.type
          };
        }
      }

      function eventRender(event, element) {
        setEventActionsButtons(element, event);
        if (scope.showDescription && !scope.disableDescription && event.kis_event) {
          renderDescription(event, element);
        }
      }

      function renderDescription(event, element) {
        element
          .find('.fc-content')
          .addClass('showtitledetail')
          .wrapInner('<div class=\'fc-content-wrapper\' />');
        if (event.kis_event.properties.description) {
          if (event.kis_event.properties.description) {
            // si da description n'est pas parsable en json, cela signifie que l'event a été enregistré avec l'ancienne methode'
            // c'est le cas ici, donc on affiche comme avant
            if (!IsJsonString(event.kis_event.properties.description)) {
              const desc = event.kis_event.properties.description.trim();
              element
                .find('.fc-content-wrapper')
                .after(
                  '<span class="calendar_event_description" title="' + desc + '">' +
                desc +
                '</span>'
                );
            }
            else {
              // si da description est parsable en json, cela signifie que l'event a été enregistrer avec la nouvelle méthode
              // if faut l'afficher avec cette nouvelle méthode : 
              var jsonDescription = JSON.parse(event.kis_event.properties.description);
              // on créé un nouveau json avec l ordre demandé, adresse-propro-occupant
              var descriptionEventFinalVersion = {
                'Adresse': jsonDescription.adresse,
                'Propriétaire': jsonDescription.proprietaire,
                'Occupant': jsonDescription.occupant
              };
              // la description qui apparaît au survol de l'evenement
              var stringToSeeOnHover
                = 'Adresse: ' + descriptionEventFinalVersion.Adresse + '\n'
                + 'Propriétaire: ' + descriptionEventFinalVersion.Propriétaire
                + '\n' + 'Occupant: ' + descriptionEventFinalVersion.Occupant;
              //  la description à l interieur de la div de description de l'evenement
              var eventDescriptionContent = Object.entries(descriptionEventFinalVersion).map(x=>x.join(':')).join('\n');

              element
                .find('.fc-content-wrapper')
                .after(
                  '<span class="calendar_event_description" title="' + stringToSeeOnHover + '">' +
                eventDescriptionContent +
                '</span>'
                );
            }
          }
        }

        element
          .find('.fc-title')
          .addClass('calendar_title_content');
        element[0].setAttribute('id', event.kis_event.id);
        element[0].setAttribute('idEvent', event.kis_event.id);
      }

      function ouvreDossier(event) {
        if (event && event.kis_event && event.kis_event.relations && event.kis_event.relations.dossierId) {
          loadListeDossier().then(() => {
            $timeout(() => {
              $rootScope.$broadcast('anc_open_controle', [{
                dossier_id: event.kis_event.relations.dossierId,
                controle_id: event.kis_event.relations.controleId,
              }]);
            });
          });
        } else {
          swal({
            title: 'Pas de dossier ANC associé à cet événement !',
            type: 'warning',
            confirmButtonColor: '#DD6B55',
            closeOnConfirm: true,
          });
        }
      }

      function loadListeDossier() {
        scope.loadListeDossierDefer = $q.defer();
        if (
          AncAppFactory.appCfg.main == undefined ||
          FeatureTypeFactory.resources.featuretypes.length == 0
        ) {
          $timeout(loadListeDossier, 500);
        } else {
          const loadedEltListeDossier = document.getElementsByClassName(
            'ancBacMainList'
          );
          const calEltListeDossier = document.getElementById(
            'kisCalendarListeDossier'
          );
          if (
            loadedEltListeDossier.length > 1 &&
            scope.childScope != undefined
          ) {
            scope.childScope.$destroy();
            scope.childScope = undefined;
            while (calEltListeDossier.firstChild) {
              calEltListeDossier.removeChild(calEltListeDossier.firstChild);
            }
          } else if (loadedEltListeDossier.length == 0) {
            var str = '<liste-dossiers ng-show="false"></liste-dossiers>';
            scope.childScope = scope.$new();
            var cmp = $compile(str)(scope.childScope);
            angular.element(calEltListeDossier).append(cmp);
          }
          scope.loadListeDossierDefer.resolve();
        }
        return scope.loadListeDossierDefer.promise;
      }


      /**
       * Vérifie que le créneau cliqué et défini
       * par les paramétres "start" et "end" correspond bien
       * à un créneau autorisé.
       *
       * @param {*} start : début du créneau cliqué
       * @param {*} end  : fin du créneau cliqué
       * @returns : VRAI si le créneau est autorisé, FAUX sinon
       */
      const businessHourSelected = (start, end) => {
        //-- Obtenir le jour depuis l'heure de début
        const startDay = start.day();
        const startHour = start.hour();
        const startMinute = start.minute();
        const endHour = end.hour();
        const endMinute = end.minute();
        //-- Liste des intervales
        const intervals = scope.businessHours.businessIntervals;
        for (let iInterv = 0; iInterv < intervals.length; iInterv++) {
          const interval = intervals[iInterv];
          let intervStartHour = interval.start.split(':');
          const intervStartMinute = parseInt(intervStartHour[1]);
          intervStartHour = parseInt(intervStartHour[0]);
          let intervEndHour = interval.end.split(':');
          const intervEndMinute = parseInt(intervEndHour[1]);
          intervEndHour = parseInt(intervEndHour[0]);

          if (interval.dow[0] == startDay
            && startHour >= intervStartHour && startMinute >= intervStartMinute
            && (startHour < intervEndHour
              || (startHour === intervEndHour && startMinute <= intervEndMinute))
            && (endHour < intervEndHour
              || (endHour === intervEndHour && endMinute <= intervEndMinute))
          ) {
            //-- On a cliqué dans une zone horaire qui correspond
            //-- à une plage autorisée.
            return true;
          }
        }
        //-- Le clic n'a pas été fait dans  une plage horaire autorisée.
        return false;
      };


      function select(start, end) {
        if (!businessHourSelected(start, end)) {
          //-- Le créneau cliqué n'est pas autorisé: on ne fait rien.
          return;
        }
        var startDate;
        if (!scope.rdvAuto) {
          if (!angular.copy(scope.currentEvent)) {
            scope.currentEvent = {
              properties: {},
            };
            startDate = $filter('date')(
              start.toDate(),
              'yyyy-MM-ddTHH:mm:ss.sssZ'
            );
            scope.currentEvent.properties.start = startDate;
          } else {
            var event;
            scope.currentEvent = event;
            startDate = $filter('date')(
              start.toDate(),
              'yyyy-MM-ddTHH:mm:ss.sssZ'
            );
            var endDate = $filter('date')(
              end.toDate(),
              'yyyy-MM-ddTHH:mm:ss.sssZ'
            );
            scope.currentEvent.collection.features[0].properties.start = startDate;
            scope.currentEvent.collection.features[0].properties.end = endDate;
          }
          scope.showCalendarEvent = true;
        }
        else {
          if (scope.disableClickEvent) {
            $timeout(() => {
              swal({ // This does something that remove the event created
                title: 'Le délai de rendez-vous est invalide !',
                type: 'warning',
                confirmButtonColor: '#DD6B55',
                closeOnConfirm: true,
              });
            });
            return;
          }
          const startTime = $filter('date')(start.toDate(), 'HH:mm');
          swal(
            {
              title:
                scope.listeCtrl.length > 1
                  ? 'Voulez vous lancer la planification des rendez vous à partir de ' +
                  startTime +
                  ' ?'
                  : 'Voulez vous valider cette prise de rendez-vous ?',
              type: 'warning',
              showCancelButton: true,
              confirmButtonColor: '#DD6B55',
              confirmButtonText: $filter('translate')('common.yes'),
              cancelButtonText: $filter('translate')('common.no'),
              closeOnConfirm: true,
            },
            isConfirm => {
              if (isConfirm) {
                $rootScope.$broadcast('getHeureDebut', {
                  debut: start,
                  heureDebut: startTime,
                  fixedSlot: true,
                });
              }
            }
          );
        }
      }

      function resolveFiltersOptions() {
        resolveAgentsAndOwners();
      }

      function resolveEventTypes() {
        return CalendarFactory.geteventtypes().then(() => {
          scope.eventTypes = CalendarFactory.resources.event_types.filter(eventType => {
            return eventType && eventType.properties.type && (
              (!isAnc() && !isBac()) ||
              (isAnc() && eventType.properties.type.toLowerCase().indexOf('kis_bac') === -1) ||
              (isBac() && eventType.properties.type.toLowerCase().indexOf('kis_anc') === -1)
            )
          });
          if (isAnc()) {
            return resolveAncEventTypesConfig().then(eventTypesConfig => {
              scope.rdvAllowedEventTypes = getFilteredRdvPossibleEventTypes(eventTypesConfig);
              return scope.eventTypes;
            });
          }
          scope.rdvAllowedEventTypes = angular.copy(scope.eventTypes);
          return scope.eventTypes;
        });
      }

      function resolveAgentsAndOwners() {
        scope.agents = [];
        scope.creators = [];
        return getEvents().then(data => {
          scope.agents = [agentsPlaceholder].concat(data.agents || []);
          scope.creators = [creatorPlaceholder].concat(getUniqueCreators(data.features));
        });
      }

      function getUniqueCreators(events) {
        const uniqueCreatedBy = [];
        return events.filter(event => {
          if (event.properties && event.properties.created_by && uniqueCreatedBy.indexOf(event.properties.created_by) === -1) {
            uniqueCreatedBy.push(event.properties.created_by);
            return true;
          }
          return false;
        }).map(event => event.properties.created_by);
      }

      function resolveAncEventTypesConfig() {
        return ConfigFactory.get('ANC', 'calendar').then(res => {
          scope.showNumber = res.data.showNumDossierDef;
          return res.data && res.data.eventTypes || [];
        }).catch(() => {
          require('toastr').error('Couldn\'t load event types configuration for ANC. Refresh page or contact an admin!');
          return []; // We don't have the data available to establish which event types can be used, so none.
        });
      }

      function getFilteredRdvPossibleEventTypes(eventTypesConfig = []) {
        return angular.copy(scope.eventTypes.filter(eventType =>
          (eventTypesConfig.find(eventTypeFromConfig => eventTypeFromConfig.type_id === eventType.properties.type_id) || {}).rdvIsPossible
        ));
      }

      function openCalendarEvent(event = { properties: {} }) {
        scope.currentEvent = event;
        scope.showCalendarEvent = true;
      }

      function setEventActionsButtons(element, event) {
        let btn = '';
        if (event && event.kis_event && event.kis_event.ref_dossier) {
          btn += '<span>&nbsp;</span><span class="openfolder btn btn-default calendareventbtn calendareventopen fa fa-folder-open-o" title="Ouvrir le contrôle"></span>';
        }
        btn += '<span class="closeon btn btn-default calendareventbtn calendardelete" title="Supprimer">X</span>';

        if (scope.typeViewCal == 'agendaWeek') {
          element.find('.fc-time').append(btn);
        } else {
          element.find('.fc-content').append(btn);
        }
        element.find('.calendardelete').click(function () {
          scope.deleteButtonActivated = true;
        });
        element.find('.calendareventopen').click(function () {
          scope.openFolderButtonActivated = true;
        });
      }

      function onCloseCalendarEvent() {
        scope.currentEvent = null;
        scope.showCalendarEvent = false;
      }

      function isAnc() {
        return $rootScope.xgos.sector === 'anc';
      }
      function isBac() {
        return $rootScope.xgos.sector === 'bac';
      }

      // format the eventArrays
      function formatEventObject(eventList) {
        eventList.features.forEach((f) =>{
          // si le dossier a été enregistré avec la nouvelle méthode
            if (f.properties.description && IsJsonString(f.properties.description)) {
              f.properties.adresse2 = JSON.parse(f.properties.description).adresse;
              f.properties.proprietaire2 = JSON.parse(f.properties.description).proprietaire;
              f.properties.occupant2 = JSON.parse(f.properties.description).occupant
            }
        });
        return eventList
      }
      
      function getEvents(filters = {}) {
        return CalendarFactory.getevents(
          getWhereQuery(filters),
          scope.start_datetime,
          scope.end_datetime
        ).then(response => {
          if (!response || !response.data) {
            return [];
          }
          scope.eventsTaken = response.data;
          scope.currentEvent = false;
          formatEventObject(scope.eventsTaken);
          return response.data;
        }).finally(() => gaDomUtils.hideGlobalLoader());
      }
      // function to test if a string is parsable into json
      function IsJsonString(str) {
        try {
            JSON.parse(str);
        } catch (e) {
            return false;
        }
        return true;
      }

      function geteventsCalendarMode(filters = {}) {
        return CalendarFactory.geteventsCalendarMode(
          getWhereQuery(filters),
          scope.start_datetime,
          scope.end_datetime
        ).then(response => {
          if (!response || !response.data) {
            return [];
          }
          scope.eventsTaken = response.data;
          scope.currentEvent = false;
          formatEventObject(scope.eventsTaken)
          return response.data;
        }).finally(() => gaDomUtils.hideGlobalLoader());
      }

      /**
       * Va cherche la liste des rendez vous sur une période de temps,
       * pour chaque rendez-vous, met à jour les données de l'evenement pour l'affichage
       * @param filters
       * @returns {*}
       */
      const getCalendarEvents = (filters = {}) => {
        gaDomUtils.showGlobalLoader();

        return geteventsCalendarMode(filters)
        .then(data => {
          let resolveEventsPromises = [];
          resolveEventsPromises = data.features.map((event) => {
            return resolveEventData(event);
          });
          return $q.all(resolveEventsPromises);
        });
      }


      function resolveEventData(event) {
        return CalendarFactory.geteventrelations(event.id).then((res) => {
          if (!res || !res.data || !res.data.features) { return event; }
          const dossierId = (
            (
              res.data.features.find(feature => feature.properties && feature.properties.feature_uid === 'kis_anc_dossier') || { properties: {} }
            ).properties.feature_id || '.'
          ).split('.')[1];
          event.relations = {
            dossierId: (res.data.features.find(feature => feature && feature.properties.feature_uid === 'kis_anc_dossier') || { properties: {} }).properties.feature_id,
            controleId: (res.data.features.find(feature => feature && feature.properties.feature_uid === 'kis_anc_dossier_controle') || { properties: {} }).properties.feature_id,
          };
          if (!dossierId) { return event; }
          return AncAppFactory.getdossier(dossierId).then((res) => {
            if (res.data.features && res.data.features.length != 0 && res.data.features[0].properties.ref_dossier) {
              event.ref_dossier = res.data.features[0].properties.ref_dossier;
            }
            return event;
          }).catch(() => event);
        }).catch(() => event);
      }

      function changeEvents(events = []) {
        events = events.map(event => event.kis_event || event);
        scope.eventSources[0] = { events: getUniqueEvents(events).map(transformFeatureToCalendarEvent) };
      }

      function removeEvents() {
        scope.eventSources[0] = { events: [] };
      }

      function getUniqueEvents(events) {
        const uniqueEventsIds = [];
        return events.filter(event => {
          if (uniqueEventsIds.indexOf(event.id) === -1) {
            uniqueEventsIds.push(event.id);
            return true;
          }
          return false;
        });
      }

      function transformFeatureToCalendarEvent(feature) {
        const color = '#' + feature.properties.color;
        return {
          title: getEventTypeTitleForCalendar(feature, feature.ref_dossier),
          start: moment(feature.properties.start),
          end: moment(feature.properties.end),
          color: color,
          allDay: feature.properties.allday,
          kis_event: feature,
        };
      }

      function getEventTypeTitleForCalendar(event, refDoss) {
        let title = '';
        if (
          scope.typeViewCal == 'agendaDay' ||
          kisCalendarFactory.resources.config.showEventType === true
        ) {
          title = event.properties.title;
        }
        if (scope.showNumber && refDoss) {
          if (title != '') {
            title += ' - ';
          }
          title += refDoss;
        }
        return title;
      }

      function getWhereQuery(filters) {
        const where = ['1=1'];
        if (filters.title) { where.push(`title ILIKE '%${filters.title}%'`); }
        if (filters.place) { where.push(`place ILIKE '%${filters.place}%'`); }
        if (filters.color) { where.push(`color='${filters.color}'`); }
        if (filters.created_by && filters.created_by !== creatorPlaceholder) { where.push(`created_by='${filters.created_by}'`); }
        if (filters.type_evenement && filters.type_evenement !== eventTypesPlaceholder) { where.push(`type_evenement='${filters.type_evenement}'`); }
        return where.join(' AND ') + (filters.agent && filters.agent !== agentsPlaceholder ? `&agent=${filters.agent}` : '');
      }

      function refreshCtrlsPriseRdv() {
        if (typeof scope.refreshCtrlsPriseRdv === 'function') {
          scope.refreshCtrlsPriseRdv();
        }
      }

    };

    return {
      templateUrl: 'js/XG/containers/views/kis_calendar.html',
      restrict: 'E',
      scope: {
        calendarCfg: '=?',
        currentEvent: '=?',
        currentdossier: '=?',
        agentcontrol: '=?',
        selectedAgent: '=?',
        dateRdvs: '=?',
        rdvAuto: '=',
        showAddEventButton: '=?',
        displayFilters: '=?',
        showDescription: '=?',
        plagehoraire: '=?',
        listeCtrl: '=?',
        disableClickEvent: '=?',
        refreshCtrlsPriseRdv: '=?'
      },
      link: kisCalendarLink
    };
  };

  kisCalendar.$inject = [
    '$rootScope',
    '$timeout',
    'gaDomUtils',
    '$filter',
    'kisCalendarFactory',
    'CalendarFactory',
    'ConfigFactory',
    'uiCalendarConfig',
    '$q',
    'AncAppFactory',
    'gaBrowserSniffer',
    'ngDialog',
    'FeatureTypeFactory',
    '$compile',
  ];
  return kisCalendar;
});

define('containers/directives/kisCalendarFilters',['toastr','toastr','toastr','toastr'],() => {
  const kisCalendarFilters = (
    gaDomUtils,
    CalendarFactory,
    $location,
    kisCalendarFactory,
    UsersFactory,
    $rootScope,
    $timeout,
    $filter
  ) => {

    const kisCalendarFiltersRwLink = (scope) => {

      const agentsPlaceholder = 'Tous les Agents';
      const creatorPlaceholder = 'Tous les Créateurs';
      const eventTypesPlaceholder = 'Tous les types d\'événements';

      scope.$watch('rdvAllowedEventTypes', () => {
        scope.showAddEvent = scope.rdvAllowedEventTypes && scope.rdvAllowedEventTypes.length && scope.showAddEventButton;
      }, true);

      scope.$watch('eventTypes', () => {
        scope.filterEventTypes = [{properties: { type_id: eventTypesPlaceholder, alias: eventTypesPlaceholder}}];
        scope.filterEventTypes = scope.filterEventTypes.concat(angular.copy(scope.eventTypes));
      }, true);

      initFilters();

      scope.modelOptions = {
        debounce: { default: 500 }
      }

      scope.calendarComments = {};

      scope.agents = scope.agents || [];
      scope.creators = scope.creators || [];

      setCalendarUrls();

      getInvitedEvents();

      scope.toggleView = () => {
        scope.viewType = scope.viewType !== 'calendar' ? 'calendar' : 'list';
        scope.onChangeViewType({ viewType: scope.viewType });
      }

      scope.toggleFilters = () => {
        if (scope.showFilters == true) {
          initFilters();
          scope.onChangedFilters({ eventsFilters: scope.eventsFilters });
          scope.showFilters = false;
          return;
        }
        scope.showFilters = true;
      }

      scope.toggleView();

      scope.changeFilters = (form, eventsFilters) => {
        if (!form.$valid) { return; }
        scope.onChangedFilters({ eventsFilters });
      }

      scope.toggleEventTitle = () => {
        scope.showDescription = !scope.showDescription;
        changeViewDetails();
      };

      scope.toggleEventNumber = () => {
        scope.showNumber = !scope.showNumber;
        changeViewDetails();
      }

      scope.exportCalendarPdf = () => {
        gaDomUtils.showGlobalLoader();
        CalendarFactory.exportcalendarpdf()
          .then(downloadICalendar)
          .catch(() => require('toastr').error('Le téléchargement Pdf a échoué'))
          .finally(() => gaDomUtils.hideGlobalLoader());
      };

      new Clipboard('.exportCalendarBtn');
      scope.clickOnUpload = () => {
        require('toastr').success(
          $filter('translate')('calendar.export.copy_success'),
          { positionClass: 'toast-bottom-left' }
        );
        $timeout(function() {
          angular.element('#hiddendownloadIcalUrl').trigger('click');
        });
      }

      scope.exportICalendar = () => {
        gaDomUtils.showGlobalLoader();
        CalendarFactory.exporticalendar()
          .then(downloadICalendar)
          .catch(() => require('toastr').error('Le téléchargement Ics a échoué'))
          .finally(() => gaDomUtils.hideGlobalLoader());
      };

      scope.addNewEvent = () => {
        scope.onAddNewEvent();
      }

      scope.openInvitePage = function () {
        scope.invitedevents = [];
        var url = $location.absUrl().split('#')[0] + '#/calendar_invite';
        window.open(url);
      };

      scope.commentChanged = function () {
        CalendarFactory.saveComment(
          scope.calendarComments.value,
          scope.commentType,
          scope.commentDate
        );
      };

      scope.$watch('calendarView.type', (newType) => {
        switch (newType) {
          case 'agendaDay':
          case 'agendaWeek':
            scope.showComments =
              kisCalendarFactory.resources.config.showComment &&
              kisCalendarFactory.resources.config.showComment[
                newType
              ];
            getComment();
            break;
          default:
            scope.showComments = false;
        }
      });
      scope.$watch('calendarView.start', () => {
        if (scope.showComments) {
          getComment();
        }
      });

      function getInvitedEvents() {
        CalendarFactory.getinvitedevents().then(function (res) {
          scope.invitedevents = res.data.features;
        });
      }

      function initFilters() {
        scope.eventsFilters = {
          agent: agentsPlaceholder,
          created_by: creatorPlaceholder,
          type_evenement: eventTypesPlaceholder,
        };
      }

      function downloadICalendar(res) {
        if (!res || !res.data) { return require('toastr').error('Download failed! Please try again later'); }
        const resources = res.data.split(',');
        window.open(
          '/services/' + resources[0] + '/calendar/downloadICalendar?' +
          '&name=' + resources[1] +
          '&token=' + localStorage.getItem('auth_token')
        );
      }

      function setCalendarUrls() {
        const url = $rootScope.xgos.kis_public_url || '';
        const services = url.endsWith('/') ? 'services/' : '/services/';
        const baseUrl = url + services + $rootScope.xgos.portal.uid;
        const userUid = $rootScope.xgos.user.uid || 'rootUser';
        scope.downloadIcalUrl = `${baseUrl}/calendar/downloadICalendarFile?uid=${userUid}`;
      }

      function changeViewDetails() {
        scope.onChangeViewDetails({ details: { showDescription: scope.showDescription, showNumber: scope.showNumber } });
      }

      function getComment() {
        const commentDate = new Date();
        scope.commentType = scope.calendarView.type;
        commentDate.setDate(scope.calendarView.start.date());
        commentDate.setMonth(scope.calendarView.start.month());
        commentDate.setYear(scope.calendarView.start.year());
        commentDate.setHours(12);
        commentDate.setMinutes(0);
        commentDate.setSeconds(0);
        commentDate.setMilliseconds(0);
        scope.commentDate = commentDate.getTime();
        CalendarFactory.getComment(scope.calendarView.type, scope.commentDate).then(
          function (res) {
            scope.calendarComments.value = res.data;
          }
        );
      }

      // Récupération de la légende pour les types d'évènement
      const eventTypesColorLegend = [];
      if (Array.isArray(scope.eventTypes)) {
        for(const eventType of scope.eventTypes) {
          eventTypesColorLegend.push({
            name: eventType.properties.alias || eventType.properties.type,
            color: '#'+(eventType.properties.default_color || 'e74c3c')
          });
        }
      }
      
      // Récupération de la légende pour les couleurs des utilisateurs
      const usersColorLegend = [];
      UsersFactory.getLightUsersByRoles('').then(res => {
        for (const userWithColor of res.data) {
          if (userWithColor.userHasColor === true) {
            usersColorLegend.push({
              name: userWithColor.vorname,
              color: userWithColor.userColor
            })
          }
        }
      });

      // Le composant kis_calendar_legend_color est utilisé pour les deux légendes
      // On affecte donc colorLegends en fonction de la légende désirée
      scope.openColorLegend = (legendType) => {
        scope.colorLegends = [];
        if (legendType === 'Users') {
          scope.colorLegends = usersColorLegend;
        } else if (legendType === 'eventTypes') {
          scope.colorLegends = eventTypesColorLegend;
        }
      };
    }

    return {
      templateUrl: 'js/XG/containers/views/kis_calendar_filters.html',
      restrict: 'E',
      scope: {
        onChangedFilters: '&',
        onChangeViewType: '&',
        onAddNewEvent: '&',
        onChangeViewDetails: '&',
        eventTypes: '=?',
        rdvAllowedEventTypes: '=?',
        showDescription: '=?',
        disableDescription: '=?',
        showNumber: '=?',
        showAddEvent: '=?',
        showAddEventButton: '=?',
        viewType: '=?',
        agents: '=?',
        creators: '=?',
        calendarView: '=?'
      },
      link: kisCalendarFiltersRwLink
    }
  }

  kisCalendarFilters.$inject = [
    'gaDomUtils',
    'CalendarFactory',
    '$location',
    'kisCalendarFactory',
    'UsersFactory',
    '$rootScope',
    '$timeout',
    '$filter',
  ];
  return kisCalendarFilters;

});


define('containers/directives/kisCalendarEvent',['toastr','toastr','toastr','toastr','toastr','toastr','toastr','toastr','toastr','toastr'],function() {
  var kisCalendarEvent = function(
    CalendarFactory,
    gaDomUtils,
    $filter,
    $rootScope,
    $location,
    $anchorScroll,
    UsersFactory,
    authFactory,
    ngDialog,
    FeatureTypeFactory,
    FunctionFactory,
    $timeout,
    gaJsUtils,
    AncAppFactory,
    kisCalendarFactory
  ) {
    return {
      templateUrl: 'js/XG/containers/views/kis_calendarevent.html',
      restrict: 'EA',
      scope: {
        map: '=?',
        currentEvent: '=',
        controleevent: '=?controleevent',
        currentagent: '=?currentagent',
        eventTypes: '=?',
        idEventType: '=?',
        dateMin: '=?',
        dateMax: '=?',
        color: '=?',
        notEditable: '=?',
        configValid: '=?',
        hideCloseButton: '@?', // hide close button
        hideUpdateButton: '@?', // hide update button
        cannotModify: '@?',
        onFinish: '&?', // optional onfinish, fired after event save/update
        defaultExtraData: '=?', // allow to feed relations, users, objects, documents, etc.. to a new object,
        setEventSize: '&',
        fromCalendar: '=?', // permet d'indiquer que l'event est inclu dans le calendar et pas en standalone ailleurs (taskmanager par ex)
        eventDisplay: '=?', // eventDisplay
        addCtrl: '=?',
        calendareventmin: '=?',
        rdvPossible: '=?',
        disableColorPicker: '=?',
      },
      link: function(scope, elt, attrs, ctrl) {
        scope.map = false;
        console.log(scope.addCtrl, scope.eventDisplay);
        var getMap = function() {
          if ($rootScope.xgos.sector == 'map') {
            scope.map = $rootScope.xgos.getMapAppMap();
            if (positionVectorLayer) scope.map.removeLayer(positionVectorLayer);
          }
        };
        getMap();

        if (scope.rdvPossible && scope.currentEvent && scope.currentEvent.properties && scope.currentEvent.properties.type_evenement) {
          scope.currentEvent.properties.type_evenement = 
            (scope.eventTypes.find(eventType => eventType.properties.type_id === scope.currentEvent.properties.type_evenement) || {}).type_id;
        }

        /**
         * get calendar geocodage config
         */
        //checkNestedProperty
        if (
          gaJsUtils.checkNestedProperty(
            'parameters.calendar.geocodage',
            $rootScope.xgos.portal
          )
        ) {
          scope.geocodage =
            $rootScope.xgos.portal.parameters.calendar.geocodage;
        }
        /**
         * get current user
         */
        scope.multiplePanels = {};
        scope.canModifyEvent = false;
        if (angular.isUndefined(scope.currentEvent)) {
          scope.currentEvent = {};
        }
        scope.multiplePanels.activePanels = [];

        scope.alerts = [];
        scope.currentUser = $rootScope.xgos.user;

        var refreshEventRelations = function() {
          CalendarFactory.geteventrelations(scope.currentEvent.id).then(
            function(res) {
              scope.currentEventRelations = res.data;
            }
          );
        };
        scope.$watch(
          'currentEvent.id',
          function(id) {
            scope.currentEventRelations = { features: [] };
            scope.uploadFileData = {
              id: scope.currentEvent.id,
              featuretype: 'kis_calendar_event',
            };
            if (id) refreshEventRelations();
            checkUserPermissions();
          },
          1
        );
        if (scope.currentEvent.id) {
          scope.uploadFileData = {
            id: scope.currentEvent.id,
            featuretype: 'kis_calendar_event',
          };

          checkUserPermissions();

          /**
           * get alerts from base by id_event
           */
          CalendarFactory.getalertsbyeventid(scope.currentEvent.id).then(
            function(res) {
              scope.alerts = [];
              for (var i = 0; i < res.data.features.length; i++) {
                var type = 'm';
                var value = res.data.features[i].properties.delai;
                scope.alerts.push({
                  value: returnAlertTypeOrValue(value, type, 'value'),
                  type: returnAlertTypeOrValue(value, type, 'type'),
                });
              }
            }
          );

          CalendarFactory.gettaskbyeventid(scope.currentEvent.id).then(function(
            res
          ) {
            if (res.data.features) {
              scope.currentTask = res.data.features[0];
            }
          });

          scope.currentFeatureUid = FeatureTypeFactory.getFeatureUidByName(
            'kis_calendar_event'
          );
        } else {
          $timeout(() => {
            scope.canModifyEvent = true;
          });
          //nouvel evenement
          if (!scope.currentEvent.properties)
            scope.currentEvent.properties = {};
          if (!scope.currentEvent.properties.start) {
            scope.currentEvent.properties.start = $filter('date')(
              moment(new Date())
                .hours(8)
                .minutes(0)
                .toDate(),
              'yyyy-MM-ddTHH:mm:ss.sssZ'
            );
          }
          /*scope.currentEvent.properties.start =
                        $filter('date')(moment(new Date()).hours(8).minutes(0).toDate(), "yyyy-MM-ddTHH:mm:ss.sssZ");*/
          
          scope.uploadFileData = {
            featuretype: 'kis_calendar_event',
          };

          if (angular.isDefined(scope.defaultExtraData)) {
            for (var i in scope.defaultExtraData) {
              scope[i] = scope.defaultExtraData[i];
            }
          }
        }

        if (angular.isUndefined(scope.currentEvent.properties)) {
          scope.currentEvent = { properties: {} };
        }

        if (angular.isDefined(scope.idEventType)) {
          scope.currentEvent.properties.type_evenement = scope.idEventType;
        }

        if (!angular.isDefined(scope.currentEvent.properties.color)) {
          if (!angular.isDefined(scope.color)) {
            scope.color = 'e74c3c';
          }
          scope.currentEvent.properties.color = scope.color;
        }

        if (!scope.currentEvent.properties.color) {
          scope.currentEvent.properties.color = 'e74c3c';
        }

        if (angular.isDefined(scope.configValid)) {
          if (
            scope.configValid.color === true &&
            angular.isDefined(scope.color)
          ) {
            scope.hasColor = true;
          }

          if (
            scope.configValid.type_evenement === true &&
            angular.isDefined(scope.idEventType)
          ) {
            scope.hasType = true;
          }
          //remove configValid.date_min
          if (
            scope.configValid.date_min === true &&
            angular.isDefined(scope.dateMin)
          ) {
            scope.currentEvent.properties.start = scope.dateMin;
            scope.hasDateMin = true;
          }

          if (
            scope.configValid.date_max === true &&
            angular.isDefined(scope.dateMax)
          ) {
            scope.currentEvent.properties.end = scope.dateMax;
            scope.hasDateMax = true;
          }
        }

        /**
         * get Event Types
         */
        var getEventTypes = function() {
          gaDomUtils.showGlobalLoader();
          if (scope.rdvPossible) { return; } // Make sure to not update the eventTypes if coming from agenda
          CalendarFactory.geteventtypes().then(
            function(res) {
              scope.eventTypes = CalendarFactory.resources.event_types;
              scope.showNoTypeAlert = true;
              gaDomUtils.hideGlobalLoader();
            },
            function() {
              gaDomUtils.hideGlobalLoader();
            }
          );
        };
        scope.showNoTypeAlert = false;
        if (!scope.eventTypes || !scope.eventTypes.length) {
          getEventTypes();
        }

        // whenever the list event types list is modified
        $rootScope.$on('editCalendarEventTypes', function() {
          if (angular.isUndefined(scope.eventTypes)) {
            getEventTypes();
          }
        });

        scope.isDefined = function(value) {
          var res = false;
          if (angular.isDefined(value)) {
            res = true;
          }
          return res;
        };

        /**
         * close
         */
        scope.closeEvent = function() {
          scope.currentEvent = false;
          $rootScope.$broadcast('closeNgDialogAgendaCtrl');

          $timeout(function() {
            scope.calendareventmin = true;
            $rootScope.$broadcast('kis_calendar_event_refresh');
          }, 200);
        };

        /**
         * set event object relation
         * @param features
         */
        var setEventRelations = function(features) {
          if (
            gaJsUtils.checkNestedProperty(
              'features.length',
              scope.currentEventRelations
            )
          ) {
            features.linked_objects = [
              {
                type: 'FeatureCollection',
                features: [],
              },
            ];
            for (
              var i = 0;
              i < scope.currentEventRelations.features.length;
              i++
            ) {
              features.linked_objects[0].features.push({
                type: 'Feature',
                properties: {
                  feature_id:
                    scope.currentEventRelations.features[i].properties
                      .feature_id,
                  feature_uid:
                    scope.currentEventRelations.features[i].properties
                      .feature_uid,
                },
              });
            }
          }
        };

        /**
         * prepare Email
         * @param recipients
         * @param title
         * @param content
         */
        var prepareEmail = function(recipients, title, content) {
          if (recipients && recipients.length) {
            recipients.forEach(function(recipient) {
              var mailDesc = [];
              mailDesc.push({
                name: 'mailTo',
                type: 'cst',
                value: [recipient],
              });
              mailDesc.push({
                name: 'mailSubject',
                type: 'cst',
                value: title,
              });
              mailDesc.push({
                name: 'mailContent',
                type: 'cst',
                value: content,
              });
              gaDomUtils.showGlobalLoader();
              FunctionFactory.execute(
                { parameters: mailDesc },
                'sendMail',
                'ja'
              ).then(
                function(res) {
                  gaDomUtils.hideGlobalLoader();
                  if (res.data === 'true') {
                  } else
                    require('toastr').error(
                      $filter('translate')('mail_writer.error')
                    );
                },
                function() {
                  gaDomUtils.hideGlobalLoader();
                }
              );
            });
          }
        };

        /**
         * send Email
         * @param type
         */
        var sendEmails = function(type) {
          var start = $filter('date')(
            scope.currentEvent.properties.start,
            'dd/MM/yyyy ' + $filter('translate')('calendar.email.at') + ' HH:mm'
          );
          var end = $filter('date')(
            scope.currentEvent.properties.end,
            'dd/MM/yyyy ' + $filter('translate')('calendar.email.at') + ' HH:mm'
          );
          var title =
            $filter('translate')('calendar.email.title') +
            scope.currentEvent.properties.title +
            ' ' +
            $filter('translate')('calendar.email.the') +
            ' ' +
            start;
          var recipients = [];
          var recipients_fullnames = [];
          var recipientsInvite = [];
          var recipientsInviteFullname = [];
          if (!scope.currentEvent.properties.description)
            scope.currentEvent.properties.description = '';
          if (scope.users_invite.length) {
            scope.users_invite.forEach(function(recipient) {
              if (recipient.email && recipient.email != '') {
                recipientsInvite.push(recipient.email);
              }
              recipientsInviteFullname.push(recipient.fullname);
            });
          }
          if (scope.users_concerne.length) {
            scope.users_concerne.forEach(function(recipient) {
              if (recipient.email && recipient.email != '') {
                recipients.push(recipient.email);
              }
              recipients_fullnames.push(recipient.fullname);
            });
          }

          var contentHead =
            '<p>' +
            $filter('translate')('calendar.email.hello') +
            ',</p>' +
            '<p>' +
            $rootScope.xgos.user.name +
            ' ' +
            $rootScope.xgos.user.vorname +
            ' ' +
            $filter('translate')('calendar.email.has') +
            ' ' +
            type +
            ' ' +
            $filter('translate')('calendar.email.event') +
            ' <b>' +
            scope.currentEvent.properties.title +
            '. </b></p>' +
            '<p>' +
            $filter('translate')('calendar.event.start') +
            ': <b>' +
            start +
            '</b></p>' +
            '<p>' +
            $filter('translate')('calendar.event.end') +
            ': <b>' +
            end +
            '</b></p>';

          if (
            scope.currentEvent.properties.description &&
            scope.currentEvent.properties.description != ''
          ) {
            contentHead =
              contentHead +
              '<p>' +
              $filter('translate')('calendar.event.detail') +
              ': ' +
              scope.currentEvent.properties.description +
              '</p>';
          }
          if (
            scope.currentEvent.properties.place &&
            scope.currentEvent.properties.place != ''
          ) {
            contentHead =
              contentHead +
              '<p>' +
              $filter('translate')('calendar.event.place') +
              ': ' +
              scope.currentEvent.properties.place +
              '</p>';
          }
          if (!recipients_fullnames.length) {
            contentHead =
              contentHead +
              '<p>' +
              $filter('translate')('calendar.email.noconcerne') +
              '</p>';
          } else {
            contentHead =
              contentHead +
              '<p>' +
              $filter('translate')('calendar.email.concernes') +
              ': ' +
              recipients_fullnames.join(', ') +
              '</p>';
          }

          if (recipientsInviteFullname.length) {
            contentHead =
              contentHead +
              '<p>' +
              $filter('translate')('calendar.email.invites') +
              ': ' +
              recipientsInviteFullname.join(', ') +
              '</p>';
          } else {
            contentHead =
              contentHead +
              '<p>' +
              $filter('translate')('calendar.email.noinvite') +
              '</p>';
          }

          if (scope.users_concerne.length) {
            prepareEmail(recipients, title, contentHead);
          }

          if (scope.users_invite.length) {
            var contentInvite =
              contentHead +
              '<p> <a class="btn-primary" href="' +
              $location.absUrl().split('#')[0] +
              '#/calendar_invite">' +
              $filter('translate')('calendar.email.manage') +
              '</a></p>';
            prepareEmail(recipientsInvite, title, contentInvite);
          }
        };
        /**
         * saveEvent
         */
        scope.currentEventRelation = {};
        scope.saveEvent = function() {
          var now = formatDate(new Date());
          scope.currentEvent.properties.creation_date = now;
          scope.currentEvent.properties.start = formatDate(scope.currentEvent.properties.start);
          scope.currentEvent.properties.end = formatDate(scope.currentEvent.properties.end);
          var features = {
            collection: {
              type: 'FeatureCollection',
              features: [
                {
                  type: 'Feature',
                  geometry: scope.currentEvent.geometry,
                  properties: scope.currentEvent.properties,
                },
              ],
            },
          };

          setEventRelations(features);
          setEventAlerts(features);
          setEventUsers(features);

          gaDomUtils.showGlobalLoader();

          CalendarFactory.addevent(features).then(
            function(res) {
              $timeout(function() {
                scope.uploadFileData.id = res.data[0].id;
              });
              if ($rootScope.xgos.portal.sendMailCfg)
                sendEmails($filter('translate')('calendar.email.created'));
              require('toastr').success(
                $filter('translate')(
                  'tools.calendar.ui.event_actions.save.done'
                ),
                {
                  positionClass: 'toast-bottom-left',
                }
              );

              $rootScope.$on('changeAttachmentId_ok', function() {
                scope.currentEvent = false;
                $rootScope.$broadcast('kis_calendar_event_refresh');
                $rootScope.$broadcast('closeEventModal');
                $rootScope.$broadcast('closeNgDialogAgendaCtrl');
                $rootScope.$broadcast('g2cAlertUpdate');
              });
              if (scope.onFinish && typeof scope.onFinish === 'function') {
                scope.onFinish({
                  insertedEvents: res.data,
                  eventData: angular.copy(scope.currentEvent),
                });
              }
              gaDomUtils.hideGlobalLoader();
            },
            function(res) {
              require('toastr').error(
                'Erreur lors de la planification de RDV',
                '',
                {
                  positionClass: 'toast-bottom-left',
                }
              );
              gaDomUtils.hideGlobalLoader();
            }
          );
        };

        /**
         * updateEvent
         */
        scope.updateEvent = function() {
          let idDossier = ""
          if (Array.isArray(scope.currentEventRelations.features)) { 
            scope.currentEventRelations.features.forEach((relation)=>{
              if (relation.properties.feature_id && relation.properties.feature_id.includes("kis_anc_dossier")
              && !relation.properties.feature_id.includes("kis_anc_dossier_controle")) {
                idDossier = relation.properties.feature_id.split('.')[1]
              }
            })
          }
          var start = moment(scope.currentEvent.properties.start);
          start = start.toISOString();
          start = $filter('date')(start, 'yyyy-MM-ddTHH:mm:ss.sssZ');
          scope.currentEvent.properties.start = start;

          var end = moment(scope.currentEvent.properties.end);
          end = end.toISOString();
          end = $filter('date')(end, 'yyyy-MM-ddTHH:mm:ss.sssZ');
          scope.currentEvent.properties.end = end;
          scope.currentEvent.properties.idDossier = idDossier;
          scope.currentEvent.properties.startTimeFormat = (new Date(start)).getTime();

          var features = {
            collection: {
              type: 'FeatureCollection',
              features: [scope.currentEvent],
            },
          };

          setEventRelations(features);
          setEventAlerts(features);
          setEventUsers(features);
          
          gaDomUtils.showGlobalLoader();
          CalendarFactory.updateevent(features).then(
            function(res) {
              if (scope.updateEmail.value) {
                if ($rootScope.xgos.portal.sendMailCfg)
                  sendEmails($filter('translate')('calendar.email.update'));
              }
              require('toastr').success(
                $filter('translate')(
                  'tools.calendar.ui.event_actions.update.done'
                ),
                {
                  positionClass: 'toast-bottom-left',
                }
              );

              $rootScope.$broadcast('kis_calendar_event_refresh');
              $rootScope.$broadcast('closeEventModal');
              $rootScope.$broadcast('g2cAlertUpdate');
              if (typeof scope.onFinish === 'function') {
                scope.onFinish({
                  insertedEvents: res.data,
                  eventData: angular.copy(scope.currentEvent),
                });
              }
              
              scope.currentEvent = false;
              kisCalendarFactory.refreshListeDossier()
              gaDomUtils.hideGlobalLoader();
            },
            function(res) {
              gaDomUtils.hideGlobalLoader();
            }
          );
        };
        scope.saveEventControle = function() {
          if (scope.addCtrl && scope.addCtrl.value == true) {
            $rootScope.$broadcast(
              'add_controle_to_dossier',
              scope.currentEvent.collection.features[0].properties.start
            );
          } else {
            var control = scope.controleevent;
            scope.savecurrentEventCtrl(control);
          }
        };

        $rootScope.$on('save_current_event_control', function(event, data) {
          if (scope.currentEvent && scope.currentEvent.linked_objects) {
            scope.currentEvent.linked_objects[0].features[0].properties.feature_id =
              data.control.id;
            scope.savecurrentEventCtrl(data.control);
          }
        });

        scope.savecurrentEventCtrl = function(control) {
          delete scope.currentEvent.collection.features[0]['id'];
          if (
            angular.isDefined(scope.currentEvent.linked_objects[0].features)
          ) {
            scope.currentEvent.linked_objects[0].features.forEach(function(
              elem,
              i
            ) {
              if (elem.properties.feature_uid == 'kis_anc_dossier')
                scope.currentEvent.linked_objects[0].features.splice(i, 1);
            });
          }
          control.properties.agent = scope.currentagent;
          control.properties.date_passage_rdv =
            scope.currentEvent.collection.features[0].properties.start;
          CalendarFactory.addevent(scope.currentEvent).then(
            function(res) {
              var eventid = res.data[0].id;
              //$rootScope.$broadcast("kis_calendar_event_refresh");
              scope.currentEvent = false;
              scope.currentevent = res.config.data.collection.features[0];
              scope.currentevent.id = eventid;

              var promise = AncAppFactory.updatecontrole({
                type: 'FeatureCollection',
                features: [control],
              });

              promise.then(
                function(res1) {
                  var xxx = {
                    event: scope.currentevent,
                    controle: res1.config.data.features[0],
                    agent: scope.currentagent,
                  };

                  $rootScope.$broadcast('kis_calendar_eventCtrl_refresh', xxx);
                  $rootScope.$broadcast('refresh_liste_controle');
                  $rootScope.$broadcast('closeNgDialogAgendaCtrl');

                  AncAppFactory.updateDatesDossier(control.id).then(function() {
                    kisCalendarFactory.refreshListeDossier();
                  });
                },
                function() {
                  require('toastr').error('error');
                }
              );

              require('toastr').success(
                "Évenement enregistré dans le calendrier de l'agent.",
                '',
                {
                  positionClass: 'toast-bottom-left',
                }
              );
            },
            function() {
              require('toastr').error(
                "Erreur lors de l'ajout de l'événement.",
                '',
                {
                  positionClass: 'toast-bottom-left',
                }
              );
            }
          );
        };
        scope.updateEventControle = function() {
          // console.log(scope.controleevent);
          scope.controleevent.properties.agent = scope.currentagent;
          scope.controleevent.properties.date_passage_rdv =
            scope.currentEvent.collection.features[0].properties.start;
          CalendarFactory.updateevent(scope.currentEvent).then(
            function(res) {
              scope.currentEvent = false;
              scope.currentevent = res.config.data.collection.features[0];
              // mise a jour du controle en fonctiond e l'event
              var promise = AncAppFactory.updatecontrole({
                type: 'FeatureCollection',
                features: [scope.controleevent],
              });
              promise.then(
                function(res1) {
                  var xxx = {
                    event: scope.currentevent,
                    controle: res1.config.data.features[0],
                    agent: scope.currentagent,
                  };
                  $rootScope.$broadcast('kis_calendar_eventCtrl_refresh', xxx);
                  $rootScope.$broadcast('closeNgDialogAgendaCtrl');
                  kisCalendarFactory.refreshListeDossier();
                  //ngDialog.close("agenda");
                },
                function() {
                  require('toastr').error('error');
                }
              );
              //var eventid = res.data[0].id;
              //require('toastr').success('ok');
            },
            function() {
              require('toastr').error('error');
            }
          );
        };

        /**
         * set Event alerts
         */
        var setEventAlerts = function(features) {
          if (scope.alerts.length) {
            features.alerts = [[]];
            for (var i = 0; i < scope.alerts.length; i++) {
              if (scope.alerts[i].type == 's') {
                features.alerts[0].push(scope.alerts[i].value);
              } else if (scope.alerts[i].type == 'm') {
                features.alerts[0].push(scope.alerts[i].value * 60);
              } else if (scope.alerts[i].type == 'h') {
                features.alerts[0].push(scope.alerts[i].value * 60 * 60);
              } else if (scope.alerts[i].type == 'd') {
                features.alerts[0].push(scope.alerts[i].value * 60 * 60 * 24);
              } else if (scope.alerts[i].type == 'w') {
                features.alerts[0].push(
                  scope.alerts[i].value * 60 * 60 * 24 * 7
                );
              } else if (scope.alerts[i].type == 'mth') {
                features.alerts[0].push(
                  scope.alerts[i].value * 60 * 60 * 24 * 30
                );
              }
            }
          }
        };

        /**
         * set Event users concerne and invite
         */
        var setEventUsers = function(features) {
          if (scope.users_concerne.length || scope.users_invite.length) {
            features.users = [[]];

            for (var i = 0; i < scope.users_concerne.length; i++) {
              features.users[0].push({
                login: scope.users_concerne[i].login,
                type: 'concerne',
              });
            }

            for (var i = 0; i < scope.users_invite.length; i++) {
              features.users[0].push({
                login: scope.users_invite[i].login,
                type: 'invite',
              });
            }
          }
        };

        /**
         * return wether an event is complete and can be submitted
         */
        scope.canSubmitEvent = function() {
          var res = true;
          scope.relationsInvalid = false;
          scope.dateInvalid = false;
          scope.valeursInvalid = false;
          if (
            scope.currentEventRelations &&
            scope.currentEventRelations.features &&
            scope.currentEventRelations.features.length
          ) {
            for (
              var i = 0;
              i < scope.currentEventRelations.features.length;
              i++
            ) {
              if (
                !scope.currentEventRelations.features[i].properties ||
                !scope.currentEventRelations.features[i].properties
                  .feature_uid ||
                scope.currentEventRelations.features[i].properties
                  .feature_uid == '' ||
                !scope.currentEventRelations.features[i].properties
                  .feature_id ||
                scope.currentEventRelations.features[i].properties.feature_id ==
                  ''
              ) {
                scope.relationsInvalid = true;
                res = false;
              }
            }
          }

          if (scope.currentEvent) {
            var start = new Date(scope.currentEvent.properties.start);
            var end = new Date(scope.currentEvent.properties.end);
            if (start > end) {
              res = false;
              scope.dateInvalid = true;
            }
          }

          var prop = scope.currentEvent.properties;
          if (
            angular.isUndefined(prop) ||
            angular.isUndefined(prop.title) ||
            angular.isUndefined(prop.start) ||
            angular.isUndefined(prop.end) ||
            angular.isUndefined(prop.type_evenement) ||
            prop.color == false
          ) {
            scope.valeursInvalid = true;
            res = false;
          }
          return res;
        };

        scope.blokTypeEventIfAnc = function() {
          // on ne bloque pas les nouveaux events
          if (!angular.isDefined(scope.currentEvent.id)) return false;

          var blokType = false;
          var eventType = scope.eventTypes[0].properties.type;
          if (eventType.startsWith('kis_anc')) {
            blokType = true;
          }
          return blokType;
        };

        /**
         * quand EventType changed, refresh alerts
         * @param currentEvent
         * @returns {boolean}
         */
        scope.currentEventTypeChange = function(currentEvent, type_id) {
          if(!currentEvent.properties.colorFromUser) {
            scope.currentEvent.properties.color = false;
            scope.eventTypes.forEach(function (eventType) {
              if (
                  eventType.properties.type_id == type_id &&
                  eventType.properties.default_color
              ) {
                scope.currentEvent.properties.color =
                    eventType.properties.default_color;
              }
            });
          }
          if (!scope.currentEvent.properties.color) {
            scope.currentEvent.properties.color = 'e74c3c';
          }
          if (currentEvent.id || $rootScope.xgos.user.login == 'root') {
            return false;
          }
          getAlerts(currentEvent);
        };

        /**
         * restrict_move_event
         * @returns {boolean}
         */
        scope.restrict_move_event = function() {
          var res = false;
          if (scope.eventTypes.length) {
            scope.eventTypes.forEach(function(type) {
              if (
                type.properties.type_id ==
                scope.currentEvent.properties.type_evenement
              ) {
                if (type.properties.restrict_move_event == true) {
                  res = true;
                }
              }
            });
          }
          if (!scope.currentEvent.id) res = false;
          return res;
        };

        /**
         * return alert type and value
         * @param value
         * @param type
         * @param renderType
         * @returns {*}
         */
        var returnAlertTypeOrValue = function(value, type, renderType) {
          if (value % (30 * 24 * 60 * 60) == 0) {
            type = 'mth';
            value = value / (30 * 24 * 60 * 60);
          } else if (value % (7 * 24 * 60 * 60) == 0) {
            type = 'w';
            value = value / (7 * 24 * 60 * 60);
          } else if (value % (24 * 60 * 60) == 0) {
            type = 'd';
            value = value / (60 * 24 * 60);
          } else if (value % (60 * 60) == 0) {
            type = 'h';
            value = value / (60 * 60);
          } else if (value % 60 == 0) {
            type = 'm';
            value = value / 60;
          }
          if (renderType == 'type') {
            return type;
          } else if (renderType == 'value') {
            return value;
          }
        };
        /**
         * get alerts
         * @param currentEvent
         */
        var getAlerts = function(currentEvent) {
          for (var i = 0; i < scope.eventTypes.length; i++) {
            if (
              scope.eventTypes[i].properties.type_id ==
              currentEvent.properties.type_evenement
            ) {
              scope.currentType = scope.eventTypes[i];
              scope.alerts = [];
              var tab = ['alerte1', 'alerte2', 'alerte3'];
              for (var j = 0; j < tab.length; j++) {
                var type = 'm';
                var value = scope.currentType.properties[tab[j]];

                if (scope.currentType.properties[tab[j]]) {
                  scope.alerts.push({
                    value: returnAlertTypeOrValue(value, type, 'value'),
                    type: returnAlertTypeOrValue(value, type, 'type'),
                  });
                }
              }
            }
          }
        };

        /**
         * add alert
         */
        scope.addAlert = function() {
          scope.alerts.push({
            value: 10,
            type: 'm',
          });
        };

        /**
         * remove alert
         * @param index
         */
        scope.removeAlert = function(index) {
          scope.alerts.splice(index, 1);
        };

        /**
         * remove all alerts
         */
        scope.removeAllAlerts = function() {
          var ans = confirm(
            'Êtes-vous certain de vouloir supprimer toutes les alertes ?'
          );
          if (ans) {
            scope.alerts = [];
          }
        };

        /**
         * checkbox for alerts
         * @type {*[]}
         */
        scope.alertDelaiTypes = [
          /*{
                    id: 's',
                    label: 'secondes'
                }, */ {
            id: 'm',
            label: 'minutes',
          },
          {
            id: 'h',
            label: 'heures',
          },
          {
            id: 'd',
            label: 'jours',
          },
          {
            id: 'w',
            label: 'semaines',
          },
          {
            id: 'mth',
            label: 'mois',
          },
        ];

        scope.panels = [
          { title: 'user' },
          { title: 'alerte' },
          { title: 'objet' },
          { title: 'document' },
        ];

        /**
         * render panel name
         * @param title
         * @returns {*}
         */
        scope.renderPanelName = function(title, attachmentNumber) {
          if (title == 'alerte') {
            // title = scope.alerts.length + ' ' + (scope.alerts && scope.alerts.length>1 ? title : title+'s');
            if (scope.alerts && scope.alerts.length) {
              if (scope.alerts.length == 1) {
                title =
                  '1 ' + $filter('translate')('calendar.event.alert_lowercase');
              } else {
                title =
                  scope.alerts.length +
                  ' ' +
                  $filter('translate')('calendar.event.alert_lowercase_plural');
              }
            } else {
              title =
                $filter('translate')('calendar.event.none_f') +
                ' ' +
                $filter('translate')('calendar.event.alert_lowercase');
            }
          } else if (title == 'objet') {
            if (
              scope.currentEventRelations &&
              scope.currentEventRelations.features.length
            ) {
              if (scope.currentEventRelations.features.length == 1) {
                title =
                  '1 ' + $filter('translate')('calendar.event.object_linked');
              } else {
                title =
                  scope.currentEventRelations.features.length +
                  ' ' +
                  $filter('translate')('calendar.event.objects_linked');
              }
            } else {
              title =
                $filter('translate')('calendar.event.none') +
                ' ' +
                $filter('translate')('calendar.event.object_linked');
            }
          } else if (title == 'user') {
            if (scope.users_invite.length || scope.users_concerne.length) {
              if (
                scope.users_invite.length + scope.users_concerne.length ==
                1
              ) {
                title = '1 ' + $filter('translate')('calendar.event.user');
              } else {
                title =
                  scope.users_invite.length +
                  scope.users_concerne.length +
                  ' ' +
                  $filter('translate')('calendar.event.users');
              }
            } else {
              title =
                $filter('translate')('calendar.event.none') +
                ' ' +
                $filter('translate')('calendar.event.user');
            }
          } else if (title == 'document') {
            if (!attachmentNumber) {
              title =
                $filter('translate')('calendar.event.none') +
                ' ' +
                $filter('translate')('calendar.event.document_linked');
            } else if (attachmentNumber <= 1) {
              title =
                attachmentNumber +
                ' ' +
                $filter('translate')('calendar.event.document_linked');
            } else {
              title =
                attachmentNumber +
                ' ' +
                $filter('translate')('calendar.event.documents_linked');
            }
          }
          return title;
        };

        /**
         * eventHasMap return whether event has map
         * @returns {boolean|*}
         */
        scope.eventHasMap = function() {
          return scope.map !== false;
        };

        function refreshControleur() {
          scope.users_concerne = [];
          scope.users_invite = [];
          if (!scope.currentEvent) {
            scope.users_concerne = [];
            scope.users_invite = [];
            return ;
          }
          CalendarFactory.getusersbyeventid(scope.currentEvent.id).then(
            function(res) {
              if (angular.isDefined(scope.currentEvent.id)) {
                scope.users_concerne = [];
                scope.users_invite = [];
                for (var i = 0; i < res.data.features.length; i++) {
                  for (var j = 0; j < scope.usersCol.length; j++) {
                    if (res.data.features[i].properties.type == 'concerne') {
                      if (
                        scope.usersCol[j].login ==
                        res.data.features[i].properties.user
                      ) {
                        scope.users_concerne.push(scope.usersCol[j]);
                      }
                    } else if (
                      res.data.features[i].properties.type == 'invite'
                    ) {
                      if (
                        scope.usersCol[j].login ==
                        res.data.features[i].properties.user
                      ) {
                        scope.users_invite.push(scope.usersCol[j]);
                      }
                    }
                  }
                }
                checkUserPermissions();
              }
            }
          );
        }

        scope.$watch('currentEvent', refreshControleur);
        /**
         * get liste users
         */
        UsersFactory.getactiveuserslight().then(function(res) {
          res.data.forEach(function(user) {
            user.url = 'img/user/default/user.png';
          });
          scope.usersCol = res.data;
          for (var i = 0; i < scope.usersCol.length; i++) {
            scope.usersCol[i].fullname =
              scope.usersCol[i].name + ' ' + scope.usersCol[i].vorname;
          }

          if (!scope.currentEvent.id) {
            addCurrentUserToConcerne();
          }
          refreshControleur();
        });

        /**
         * check string is email
         * @param email
         * @returns {boolean}
         */
        var validateEmail = function(email) {
          var re = /^(([^<>()\[\]\\.,;:\s@"]+(\.[^<>()\[\]\\.,;:\s@"]+)*)|(".+"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/;
          return re.test(email);
        };
        scope.usersExterneCol = [];
        scope.users_externe = [];
        scope.$watch(
          'users_externe',
          function() {
            if (scope.users_externe && scope.users_externe.length) {
              for (var i = 0; i < scope.users_externe.length; i++) {
                scope.users_externe[i].url = 'img/user/default/user.png';
                if (!validateEmail(scope.users_externe[i].email)) {
                  scope.users_externe.splice(i, 1);
                }
              }
            }
          },
          1
        );
        scope.users_concerne = [];
        scope.users_invite = [];
        /**
         * users_concerne changed
         */
        scope.$watch(
          'users_concerne',
          function(users_concerne) {
            addCurrentUserToConcerne();
            // Si le premier utilisateur concerné par l'évènement a une couleur,
            // l'évènement prend cette couleur (on enlève le #)
            if (users_concerne[0] && users_concerne[0].userHasColor) {
              scope.currentEvent.properties.color = users_concerne[0].userColor.substring(1);
              scope.currentEvent.properties.colorFromUser = true;
            } else {
              if (scope.currentEvent.properties){
                scope.currentEvent.properties.colorFromUser = false;
              }
            }
            checkusers(scope.users_concerne, scope.users_invite, 'invites');
          },
          1
        );

        /**
         *
         * @returns {boolean}
         */
        var addCurrentUserToConcerne = function() {
          if (
            !scope.currentUser ||
            (!scope.currentUser.login &&
              scope.currentEvent.properties.created_by !=
                scope.currentUser.login)
          ) {
            return false;
          }

          for (var i = 0; i < $rootScope.xgos.user.roles.length; i++) {
            if (
              $rootScope.xgos.user.roles[i].name == 'rootUser' ||
              $rootScope.xgos.user.roles[i].name == 'kis_calendar_manager' ||
              $rootScope.xgos.user.login == 'root'
            ) {
              return false;
            }
          }
          var contain = false;
          for (var i = 0; i < scope.users_concerne.length; i++) {
            if (scope.currentUser.login == scope.users_concerne[i].login) {
              contain = true;
            }
          }
          if (contain == false && scope.usersCol && scope.usersCol.length) {
            for (var j = 0; j < scope.usersCol.length; j++) {
              if (scope.usersCol[j].login == scope.currentUser.login) {
                scope.users_concerne.push(scope.usersCol[j]);
                checkUserPermissions();
              }
            }
          }
        };
        /**
         * users_invite changed
         */
        scope.$watch(
          'users_invite',
          function(users_invite) {
            checkusers(scope.users_invite, scope.users_concerne, 'concernes');
          },
          1
        );

        /**
         * check users
         * @param users
         */
        var checkusers = function(users, users_, type) {
          for (var i = 0; i < users.length; i++) {
            var contain = false;
            for (var j = 0; j < scope.usersCol.length; j++) {
              if (scope.usersCol[j].name == users[i].name) {
                contain = true;
                users[i] = scope.usersCol[j];
              }
            }
            if (contain == false) {
              users.splice(i, 1);
            }
          }

          contain = false;
          for (var i = 0; i < users_.length; i++) {
            if (users.length) {
              if (users_[i].login == users[users.length - 1].login) {
                contain = true;
              }
            }
          }
          if (contain == true) {
            if (
              !scope.currentEvent.properties.created_by ||
              scope.currentEvent.properties.created_by ==
                $rootScope.xgos.user.name
            ) {
              require('toastr').error(
                users[users.length - 1].fullname +
                  ' ' +
                  $filter('translate')('calendar.event.already_in_part') +
                  ' ' +
                  type
              );
            }
            users.splice(users.length - 1, 1);
          }
        };

        scope.openHistoriesDialog = function() {
          scope.currentFeatureUid = FeatureTypeFactory.getFeatureUidByName(
            'kis_calendar_event'
          );
          ngDialog.open({
            template:
              'js/XG/containers/views/modal.history.kis_calendar_event.html',
            className: 'ngdialog-theme-plain width800 nopadding miniclose',
            closeByDocument: false,
            scope: scope,
          });
        };

        /**
         * Annuler Event
         */
        scope.annulerEvent = function() {
          kisCalendarFactory.annulerEvent(
            scope.currentEvent.id,
            scope.closeEvent
          );
        };

        /**
         *  put end and start time auto
         */
        scope.$watch(
          'currentEvent.properties.start',
          function(start) {
            if (
              scope.currentEvent &&
              scope.currentEvent.properties.start &&
              !scope.currentEvent.id &&
              !scope.currentEvent.properties.end
            ) {
              scope.currentEvent.properties.end = $filter('date')(
                moment(scope.currentEvent.properties.start)
                  .add(1, 'hour')
                  .toDate(),
                'yyyy-MM-ddTHH:mm:ss.sssZ'
              );
            }
          },
          1
        );

        scope.updateEmail = {};

        $rootScope.$watch(
          'calendar.visible',
          function() {
            if ($rootScope.calendar.visible == true) {
              $rootScope.$broadcast('MapPositionPickerRemoveDraw');
              getMap();
            }
          },
          1
        );

        scope.positionpicker = {};

        scope.positionAutoComplete = {};
        /**
         * set position by positionAutoComplete
         */
        scope.$watch(
          'positionAutoComplete',
          function(positionAutoComplete) {
            if (positionAutoComplete.v) {
              if (angular.isDefined(positionAutoComplete.v.value)) {
                if (angular.isDefined(positionAutoComplete.v.geometry)) {
                  var feature;
                  if (scope.geocodage == 'google') {
                    feature = getFeatureByPoint([
                      positionAutoComplete.v.geometry.location.lng,
                      positionAutoComplete.v.geometry.location.lat,
                    ]);
                  } else if (scope.geocodage == 'nominatim') {
                    feature = getFeatureByPoint([
                      parseFloat(positionAutoComplete.v.lon),
                      parseFloat(positionAutoComplete.v.lat),
                    ]);
                  } else if (scope.geocodage.indexOf('kis_geocoder_') == 0) {
                    feature = getFeatureByPoint(
                      positionAutoComplete.v.geometry.coordinates
                    );
                  }
                  scope.currentEvent.geometry = feature.geometry;
                }

                scope.currentEvent.properties.place =
                  positionAutoComplete.v.value;
              } else {
                delete scope.currentEvent.geometry;
                scope.currentEvent.properties.place = positionAutoComplete.v;
              }
            }
          },
          1
        );

        /**
         * click MapPositionPicker
         */
        scope.openMapPositionPicker = function() {
          if (scope.canModifyEvent) $rootScope.calendar.visible = false;
        };

        /**
         * get feature geiJson by Point
         * @param coords
         */
        var getFeatureByPoint = function(coords) {
          var coords_3857 = ol.proj.transform(coords, 'EPSG:4326', 'EPSG:3857');

          var x = coords_3857[0];
          var y = coords_3857[1];
          var view = scope.map.getView();
          var resolution = view.getResolution();

          if (resolution != 'undefined') {
            var leftX = x - 5 * resolution;
            var rightX = x + 5 * resolution;
            var bottomY = y - 5 * resolution;
            var topY = y + 5 * resolution;
          } else {
            leftX = x - 5;
            rightX = x + 5;
            bottomY = y - 5;
            topY = y + 5;
          }

          var format = new ol.format.GeoJSON();
          /*      var feature = format.writeFeatureObject(new ol.Feature({
                        geometry: new ol.geom.MultiPolygon([[[coords_3857, coords_3857, coords_3857, coords_3857]]])
                    }));*/
          var feature = format.writeFeatureObject(
            new ol.Feature({
              geometry: new ol.geom.MultiPolygon([
                [
                  [
                    [leftX, bottomY],
                    [rightX, bottomY],
                    [rightX, topY],
                    [leftX, topY],
                    [leftX, bottomY],
                  ],
                ],
              ]),
            })
          );
          return feature;
        };
        /**
         * get position
         */
        scope.$watch(
          'positionpicker',
          function(positionpicker) {
            if (positionpicker.v && positionpicker.v.coordinates) {
              $rootScope.calendar.visible = true;
              $rootScope.$broadcast('MapPositionPickerRemoveDraw');
              var feature = getFeatureByPoint(positionpicker.v.coordinates);
              if (!scope.currentEvent) {
                scope.currentEvent = {};
              }
              scope.currentEvent.geometry = feature.geometry;
              if (
                scope.geocodage == 'google' &&
                positionpicker.v.infos[0] &&
                positionpicker.v.infos[0].formatted_address
              ) {
                scope.currentEvent.properties.place =
                  positionpicker.v.infos[0].formatted_address;
              } else if (
                scope.geocodage == 'nominatim' &&
                positionpicker.v.infos.display_name
              ) {
                scope.currentEvent.properties.place =
                  positionpicker.v.infos.display_name;
              } else if (
                scope.geocodage.indexOf('kis_geocoder_') == 0 &&
                positionpicker.v.infos.properties.label
              ) {
                scope.currentEvent.properties.place =
                  positionpicker.v.infos.properties.label;
              }
            }
          },
          1
        );
        /**
         * remove position
         */
        scope.deletePosition = function() {
          delete scope.currentEvent.geometry;
          scope.currentEvent.properties.place = '';
        };

        /**
         * centrer la position
         */
        var positionVectorLayer;
        scope.centerPosition = function() {
          scope.map.removeLayer(positionVectorLayer);
          $rootScope.calendar.visible = !$rootScope.calendar.visible;
          var feature = new ol.Feature({
            geometry: new ol.geom.MultiPolygon(
              scope.currentEvent.geometry.coordinates
            ),
          });

          var extent = feature.getGeometry().getExtent();

          var center = [extent[0], extent[1]];
          center = ol.proj.transform(
            center,
            'EPSG:3857',
            scope.map
              .getView()
              .getProjection()
              .getCode()
          );

          scope.map.getView().setCenter(center);
          scope.map.getView().setZoom(15);

          var iconFeature = new ol.Feature({
            geometry: new ol.geom.Point(center),
            population: 4000,
            rainfall: 500,
          });
          var iconStyle = new ol.style.Style({
            image: new ol.style.Icon({
              src: 'img/widget/adressLocation/marker.png',
              scale: 1,
            }),
          });
          iconFeature.setStyle(iconStyle);

          positionVectorLayer = new ol.layer.Vector({
            source: new ol.source.Vector({
              features: [iconFeature],
            }),
          });
          scope.map.addLayer(positionVectorLayer);
        };

        /**
         * format date
         * @param dateSource
         * @returns {*}
         */
        var formatDate = function(dateSource) {
          var date = moment(dateSource);
          date = date.toISOString();
          date = $filter('date')(date, 'yyyy-MM-ddTHH:mm:ss.sssZ');
          return date;
        };

        scope.informEmail = false;
        var currentEventStart, currentEventEnd;
        if (scope.currentEvent.id) {
          currentEventStart = formatDate(scope.currentEvent.properties.start);
          currentEventEnd = formatDate(scope.currentEvent.properties.end);
        }

        /**
         * update event, date changed, inform email send auto
         */
        var currentStartTime = scope.currentEvent.properties.start;
        scope.$watch(
          'currentEvent.properties.start',
          function(start) {
            if (start) {
              currentStartTime = moment(start).format('yyyy-MM-ddTHH:mm:ss.sssZ');
            } else {
              if (!scope.currentEvent) return false;
              scope.currentEvent.properties.start = currentStartTime;
            }
            avertirEmail(currentEventStart, start);
          },
          1
        );
        var currentEndTime = scope.currentEvent.properties.end;
        scope.$watch(
          'currentEvent.properties.end',
          function(end) {
            if (end) {
              currentEndTime = moment(end).format('yyyy-MM-ddTHH:mm:ss.sssZ');
            } else {
              if (!scope.currentEvent) return false;
              scope.currentEvent.properties.end = currentEndTime;
            }
            avertirEmail(currentEventEnd, end);
          },
          1
        );
        var avertirEmail = function(currentData, date) {
          if (scope.currentEvent.id) {
            date = formatDate(date);
            if (currentData != date) {
              scope.informEmail = true;
              scope.updateEmail.value = true;
            } else {
              scope.informEmail = false;
            }
          }
        };

        function checkUserPermissions() {
          if (!scope.currentEvent || !scope.currentEvent.id) {
            scope.canModifyEvent = true;
            scope.historyIsActive = false;
            return;
          }

          scope.canModifyEvent = false;
          if (
            $rootScope.xgos.user.name ==
            scope.currentEvent.properties.created_by
          ) {
            scope.canModifyEvent = true;
          }

          if (
            Array.isArray(scope.users_concerne) &&
            scope.users_concerne.filter(user => user.login === $rootScope.xgos.user.login).length
          ) {
            scope.canModifyEvent = true;
          }

          for (var i = 0; i < $rootScope.xgos.user.roles.length; i++) {
            if (
              $rootScope.xgos.user.roles[i].name == 'kis_calendar_manager' ||
              $rootScope.xgos.user.login == 'root'
            ) {
              scope.canModifyEvent = true;
            }
            if (
              $rootScope.xgos.user.roles[i].name == 'rootUser' ||
              $rootScope.xgos.user.login == 'root'
            ) {
              if (
                gaJsUtils.checkNestedProperty(
                  'parameters.history.active',
                  $rootScope.xgos.portal
                )
              ) {
                scope.historyIsActive = true;
              }
            }
          }

          if (
            scope.currentEvent.properties.allow_external_modification == true
          ) {
            scope.canModifyEvent = true;
          }

          if (scope.cannotModify) {
            scope.canModifyEvent = false;
          }
        }
      },
    };
  };

  kisCalendarEvent.$inject = [
    'CalendarFactory',
    'gaDomUtils',
    '$filter',
    '$rootScope',
    '$location',
    '$anchorScroll',
    'UsersFactory',
    'authFactory',
    'ngDialog',
    'FeatureTypeFactory',
    'FunctionFactory',
    '$timeout',
    'gaJsUtils',
    'AncAppFactory',
    'kisCalendarFactory',
  ];
  return kisCalendarEvent;
});


define('containers/directives/kisCalendarRelation',['toastr'],function() {
  var kisCalendarRelation = function(
    FeatureTypeFactory,
    ngDialog,
    QueryFactory,
    gclayers,
    $rootScope,
    $location,
    AncAppFactory,
    gaDomUtils
  ) {
    return {
      templateUrl: 'js/XG/containers/views/kis_calendarrelation.html',
      restrict: 'EA',
      scope: {
        res: '=',
        cannotModify: '=?',
        map: '=?',
      },
      link: function(scope, elt, attrs, ctrl) {
        /**
         * get all features
         */
        FeatureTypeFactory.get().then(function(res) {
          // adapte aux modification de FeatureFactory.get (doit utiliser res et non plus res.data)
          scope.featureslist = res;
        });

        var myDialog;
        scope.currentFeature = {};
        scope.selected = {};
        scope.currentIndex = false;
        /**
         * open dialog
         * @param relation
         * @param index
         */
        scope.openInfosDialog = function(relation, index) {
          scope.selected = {};
          scope.currentIndex = index;
          for (var i = 0; i < scope.featureslist.length; i++) {
            if (relation.properties.feature_uid == scope.featureslist[i].uid) {
              scope.currentFeature = scope.featureslist[i];
            }
          }
          myDialog = ngDialog.open({
            template:
              'js/XG/containers/views/modal.infos.kis_calendar_relation.html',
            className: 'ngdialog-theme-plain width800 nopadding miniclose',
            closeByDocument: false,
            scope: scope,
          });
        };

        /**
         * save
         */
        scope.save = function() {
          for (var i = 0; i < scope.res.features.length; i++) {
            if (
              scope.currentFeature.uid ==
                scope.res.features[i].properties.feature_uid &&
              scope.currentIndex == i
            ) {
              scope.res.features[i].properties.feature_id =
                scope.selected.list[0].id;
            }
          }
          myDialog.close();
          scope.currentIndex = false;
        };

        /**
         * close Dialog
         */
        scope.close = function() {
          myDialog.close();
          scope.currentIndex = false;
        };

        /**
         * remove relation
         * @param index
         */
        scope.removeRelation = function(index) {
          var ans = confirm(
            'Êtes-vous certain de vouloir supprimer cette relation?'
          );
          if (ans) {
            scope.res.features.splice(index, 1);
          }
        };

        /**
         * add relation
         */
        scope.newRelation = function() {
          if (!scope.res || !scope.res.features) {
            scope.res.features = [];
          }
          scope.res.features.push({
            type: 'Feature',
            properties: {},
          });
        };

        /**
         * is Geographic
         * @param relation
         * @returns {boolean}
         */
        scope.isGeographic = function(relation) {
          var res = false;
          if (
            relation &&
            relation.properties &&
            relation.properties.feature_uid
          ) {
            var feature = FeatureTypeFactory.getFeatureByUid(
              relation.properties.feature_uid
            );
            if (
              feature &&
              feature.geographic &&
              relation.properties.feature_id
            ) {
              res = true;
            }
          }
          if (!scope.map) {
            res = false;
          }
          return res;
        };

        /**
         * position On Map
         * @param relation
         */
        scope.positionOnMap = function(relation) {
          QueryFactory.get(
            relation.properties.feature_uid,
            relation.properties.feature_id
          ).then(function(res) {
            console.log(res.data.features[0]);
            if (res.data.features[0].geometry) {
              var obj = res.data.features[0];
              var format = new ol.format.GeoJSON();
              var f = format.readFeature(obj);
              var extent = f.getGeometry().getExtent();
              scope.map.getView().fit(extent, scope.map.getSize());
              $rootScope.calendar.visible = false;
              gclayers.clearhighLightFeatures();
              gclayers.addhighLightFeature(f);
            } else {
              require('toastr').info('Position inconnue');
            }
          });
        };

        /**
         * display anc report
         * @param id
         * @returns {boolean}
         */
        scope.displayAncReport = function(id) {
          var res = false;
          if ($location.path().indexOf('/anc/') == 0 && id) {
            if (
              id.split('.')[0] == 'kis_anc_dossier' ||
              id.split('.')[0] == 'kis_anc_dossier_controle'
            ) {
              res = true;
            }
          }
          return res;
        };

        /**
         * edit report anc
         * @param uid
         * @param fid
         */
        //open_id
        scope.editReport = function(uid, fid) {
          $location.search('fid', fid);
          if ($location.path().indexOf('/anc/reports/') != 0) {
            $location.path('/anc/reports/');
          }
        };
      },
    };
  };

  kisCalendarRelation.$inject = [
    'FeatureTypeFactory',
    'ngDialog',
    'QueryFactory',
    'gclayers',
    '$rootScope',
    '$location',
    'AncAppFactory',
    'gaDomUtils',
  ];
  return kisCalendarRelation;
});


define('containers/directives/kisAlertBtn',[],function() {
  var kisAlertBtn = function(
    CalendarFactory,
    $rootScope,
    AlertFactory,
    gaDomUtils,
    uiCalendarConfig,
    $timeout,
    $filter
  ) {
    return {
      templateUrl: 'js/XG/containers/views/kis_alertbtn.html',
      restrict: 'EA',
      scope: {
        map: '=?',
      },
      link: function(scope, elt, attrs, ctrl) {
        var where =
          'acquitte=false AND datealert BEFORE ' +
          moment().format('YYYY-MM-DDT23:30:00');
        scope.howmany = 0;
        scope.pulse = false;
        /*     AlertFactory.getcount(where).then(function (res) {
                    scope.howmany = res.data;
                    tick();
                });*/
        CalendarFactory.getalerts().then(function(res) {
          scope.howmany = CalendarFactory.resources.alerts.features.length;
        });

        $rootScope.$on('g2cAlertUpdate', function() {
          CalendarFactory.getalerts().then(function(res) {
            scope.howmany = CalendarFactory.resources.alerts.features.length;
          });
        });
        //function toutes les minutes qui compte les alert
        /*         function tick() {
                    AlertFactory.getcount(where).then(function (res)
                    {
                        if(scope.howmany != res.data )
                        {
                            scope.pulse = true;
                            require('toastr').info("Nouvelle Alerte");
                        }
                        else 
                        {
                            scope.pulse = false;
                        }
                        scope.howmany = res.data;
                        $timeout(tick, 100000);
                    })
                };


                $rootScope.$on('g2cAlertUpdate', function(event) {
                    AlertFactory.getcount(where).then(function (res)
                    {

                        scope.howmany = res.data;
                        
                    })
                });

                $rootScope.$on('g2cAlertStopPulse', function(event) {
                    scope.pulse = false;
                });
*/

        /**
         * Return type label from its id
         * @param id
         */
      },
    };
  };

  kisAlertBtn.$inject = [
    'CalendarFactory',
    '$rootScope',
    'AlertFactory',
    'gaDomUtils',
    'uiCalendarConfig',
    '$timeout',
    '$filter',
  ];
  return kisAlertBtn;
});


define('containers/directives/taskManager',['toastr','toastr'],function() {
  var taskManager = function(
    TaskFactory,
    gaDomUtils,
    ngDialog,
    EditFactory,
    $timeout,
    CalendarFactory,
    ParametersFactory,
    $filter,
    $q,
    gaJsUtils
  ) {
    return {
      templateUrl: 'js/XG/containers/views/taskmanager.html',
      restrict: 'EA',
      scope: {
        fuid: '=', // featureuid
        fid: '=', // featureid
      },
      link: function(scope, elt, attrs, ctrl) {
        scope.filter = {
          tasks: '',
          displayCanceled: false,
        };

        scope.tasks = [];
        scope.tasksEvents = [];
        scope.loadingTasks = true;

        // get eventTypes
        scope.eventTypes = [];
        /**
         * getEventTypes
         */
        var getEventTypes = function() {
          CalendarFactory.geteventtypes().then(function(res) {
            scope.eventTypes = CalendarFactory.resources.event_types;
          });
        };
        getEventTypes();

        scope.taskTemplates = [];
        /**
         * getTaskTemplates
         */
        var getTaskTemplates = function() {
          ParametersFactory.getbytype('TaskTemplate').then(function(res) {
            if (angular.isArray(res.data)) scope.taskTemplates = res.data;
          });
        };
        getTaskTemplates();

        scope.taskStatuses = {};
        /**
         * refreshTaskStatuses
         */
        var refreshTaskStatuses = function() {
          scope.taskStatuses.normal = 0;
          scope.taskStatuses.cloture = 0;
          scope.taskStatuses.annule = 0;

          scope.tasks.forEach(function(t) {
            scope.taskStatuses[t.properties.status] += 1;
          });
        };

        /**
         * task
         * @param task
         */
        var refreshTaskEvents = function(task) {
          TaskFactory.gettaskevents(task.id).then(function(res) {
            $timeout(function() {
              scope.tasksEvents[task.id] = $filter('orderBy')(
                res.data.features,
                'properties.start',
                false
              );
            }, 500);
          });
        };
        /**
         * getTasks
         */
        var getTasks = function() {
          TaskFactory.gettasks(scope.fuid, scope.fid).then(function() {
            scope.tasks = TaskFactory.resources.tasks;
            scope.tasks.forEach(function(task) {
              refreshTaskEvents(task);
            });
            refreshTaskStatuses();
            scope.loadingTasks = false;
          });
        };

        scope.$watch('fid', function(fid) {
          if (angular.isDefined(fid)) {
            getTasks();
          }
        });

        /* -************************************
         *  Tasks
         * ***********************************/

        /**
         * addTask dialog
         */
        var _addTaskDialog;
        scope.addTaskDialog = function() {
          scope.newTaskDateMin = $filter('date')(
            new Date(),
            'yyyy-MM-ddTHH:mm:ss.sssZ'
          );
          scope.newTask = {
            type: 'Feature',
            properties: {
              title: '',
              description: '',
              status: 'normal',
              fuid: scope.fuid,
              fid: scope.fid,
            },
          };
          scope.selectedTemplate = {};

          _addTaskDialog = ngDialog.open({
            template: 'js/XG/containers/views/modals/taskmanager.add.task.html',
            className: 'ngdialog-theme-plain width800 nopadding miniclose',
            closeByDocument: false,
            scope: scope,
          });
        };
        /**
         * check whether user can add a new task
         */
        scope.canAddNewTask = function() {
          var canAdd = true;
          if (
            scope.newTask.properties.title == '' ||
            scope.newTask.properties.description == ''
          )
            canAdd = false;
          if (
            angular.isDefined(scope.selectedTemplate.tpl) &&
            !angular.isDefined(scope.selectedTemplate.first_date)
          ) {
            canAdd = false;
          }

          return canAdd;
        };

        /**
         * updateDateStringAndFormat
         * @param dateString
         * @param duration
         */
        var updateDateStringAndFormat = function(dateString, duration) {
          return $filter('date')(
            moment(moment(dateString))
              .add(duration, 'seconds')
              .toDate(),
            'yyyy-MM-ddTHH:mm:ss.sssZ'
          );
        };

        /**
         * tplToTask
         * @param taskid
         * @param tpl
         * @param base_date
         */
        var tplToTask = function(taskid, tpl, base_date) {
          var def = $q.defer();

          var newEvents = [];
          var newEvent = {};

          tpl.events.forEach(function(event, idx) {
            newEvent = {
              type: 'Feature',
              properties: angular.copy(event),
            };

            base_date = updateDateStringAndFormat(base_date, event.delai);
            newEvent.properties.start = base_date;
            newEvent.properties.end = updateDateStringAndFormat(
              base_date,
              event.duration
            );

            console.log(base_date);

            // remove extra data
            delete newEvent.properties.duration;
            delete newEvent.properties.delai;
            newEvents.push(newEvent);
          });

          CalendarFactory.addevent({
            type: 'FeatureCollection',
            features: newEvents,
          }).then(
            function(res) {
              var toLink = [];
              res.data.forEach(function(x) {
                toLink.push({
                  task: taskid,
                  event: x.id,
                });
              });
              TaskFactory.addeventtotask(toLink).then(
                function(res) {
                  def.resolve();
                },
                function() {
                  def.reject();
                }
              );
            },
            function(res) {
              def.reject();
            }
          );

          return def.promise;
        };

        /**
         * addTask
         */
        scope.addTask = function() {
          gaDomUtils.showGlobalLoader();

          TaskFactory.addtask({
            type: 'FeatureCollection',
            features: [scope.newTask],
          }).then(
            function(res) {
              // from template
              if (angular.isDefined(scope.selectedTemplate.tpl)) {
                tplToTask(
                  res.data[0].id,
                  scope.selectedTemplate.tpl.data,
                  scope.selectedTemplate.first_date
                ).then(
                  function() {
                    getTasks();
                    gaDomUtils.hideGlobalLoader();
                  },
                  function() {
                    gaDomUtils.hideGlobalLoader();
                  }
                );
              } else {
                getTasks();
                gaDomUtils.hideGlobalLoader();
              }
            },
            function() {
              gaDomUtils.hideGlobalLoader();
            }
          );

          _addTaskDialog.close();
        };

        /**
         * pre_editTaskMetaData
         * @param event
         */
        scope.pre_editTaskMetaData = function(task) {
          scope.editTaskMetaData = task;
          scope.tmpeditTaskMetaData = angular.copy(task);
        };
        /**
         * pre_editTaskGeneral
         * @param event
         */
        scope.pre_editTaskGeneral = function(task) {
          scope.editTaskGeneral = task;
          scope.tmpeditTaskGeneral = angular.copy(task);
        };

        scope.doEditTaskGeneral = function() {
          gaDomUtils.showGlobalLoader();
          TaskFactory.updatetask({
            type: 'FeatureCollection',
            features: [scope.tmpeditTaskGeneral],
          }).then(function() {
            scope.editTaskGeneral.properties =
              scope.tmpeditTaskGeneral.properties;
            gaDomUtils.hideGlobalLoader();
            $('.popover-content')
              .parent()
              .remove();
          });
        };

        /**
         * editTaskMetaData
         */
        scope.doEditTaskMetaData = function() {
          // edit status
          if (
            scope.tmpeditTaskMetaData.properties.status !=
            scope.editTaskMetaData.properties.status
          ) {
            gaDomUtils.showGlobalLoader();
            TaskFactory.updatetaskstatus({
              task_id: scope.tmpeditTaskMetaData.id,
              status: scope.tmpeditTaskMetaData.properties.status,
            }).then(
              function(res) {
                scope.editTaskMetaData.properties.status =
                  scope.tmpeditTaskMetaData.properties.status;
                refreshTaskEvents(scope.editTaskMetaData);
                refreshTaskStatuses();
                gaDomUtils.hideGlobalLoader();
              },
              function() {
                gaDomUtils.hideGlobalLoader();
              }
            );
          }
        };

        /* -************************************
         *  Task Events
         * ***********************************/

        var _editEventTaskDialog;
        var currentTask;
        /**
         * editEventTaskDialog
         * @param task
         * @param event
         */
        var svgEvent;
        scope.editEventTaskDialog = function(task, event, index) {
          currentTask = task;
          scope.currentEvent = event ? angular.copy(event) : {};
          scope.isNewEvent = !angular.isDefined(event);

          if (!scope.isNewEvent) {
            svgEvent = angular.copy(event);
            scope.eventInTaskIndex = index;
          } else {
            scope.newEventExtraData = {
              currentEventRelations: gaJsUtils.setNewFeatureCollection({
                feature_uid: scope.fuid,
                feature_id: scope.fid,
              }),
            };
          }

          _editEventTaskDialog = ngDialog.open({
            template:
              'js/XG/containers/views/modals/taskmanager.add.event.html',
            className: 'ngdialog-theme-plain width1000 nopadding miniclose',
            closeByDocument: false,
            scope: scope,
          });
        };

        /**
         * Decalage des dates de début des events selectionnes
         * addEventToTask
         * @param eventData
         */
        var _decaleEventsDialog;
        var deregWatchDecalages;
        scope.addEventToTask = function(insertedEvents, eventData, isNewEvent) {
          $timeout(function() {
            if (!isNewEvent) {
              // allow user to move other events too
              if (
                scope.eventInTaskIndex <
                scope.tasksEvents[currentTask.id].length - 1
              ) {
                var prevstart = moment(svgEvent.properties.start),
                  newstart = moment(eventData.properties.start),
                  decalage = moment
                    .duration(newstart.diff(prevstart))
                    .asSeconds();

                if (decalage != 0) {
                  scope.decalageEvent = decalage;
                  scope.decalageEvent_display = ' ';

                  var absdecalage = Math.abs(decalage);

                  if (absdecalage >= 86400) {
                    var nbdays = Math.round(
                      moment.duration(newstart.diff(prevstart)).asDays()
                    );
                    absdecalage = absdecalage - nbdays * 86400;
                    scope.decalageEvent_display +=
                      nbdays + $filter('translate')('date.day_short');
                  }
                  if (absdecalage > 0) {
                    scope.decalageEvent_display +=
                      ' ' + moment.utc(absdecalage * 1000).format('HH[h]mm');
                  }

                  scope.currentEvents = angular.copy(
                    scope.tasksEvents[currentTask.id]
                  );

                  scope.currentEvents.forEach(function(x, i) {
                    if (i == scope.eventInTaskIndex) {
                      scope.currentEvents[i].properties.newstart = newstart;
                    } else {
                      scope.currentEvents[i].properties.newstart =
                        scope.currentEvents[i].properties.start;
                    }
                  });

                  scope.toggleDecalages = {};

                  deregWatchDecalages = scope.$watch(
                    'toggleDecalages',
                    function(t) {
                      scope.nbDecalages = 0;
                      for (var idx in t) {
                        var base = scope.currentEvents[idx].properties.start;
                        if (t[idx]) {
                          scope.currentEvents[idx].properties.newstart = moment(
                            moment(base)
                          )
                            .add(decalage, 'seconds')
                            .toDate();
                          scope.nbDecalages++;
                        } else {
                          scope.currentEvents[idx].properties.newstart = base;
                        }
                      }
                    },
                    1
                  );

                  _decaleEventsDialog = ngDialog.open({
                    template:
                      'js/XG/containers/views/modals/taskmanager.decal.events.html',
                    className:
                      'ngdialog-theme-plain width1000 nopadding miniclose',
                    closeByDocument: false,
                    scope: scope,
                  });
                }

                refreshTaskEvents(currentTask);
              } else {
                refreshTaskEvents(currentTask);
              }
            } else {
              TaskFactory.addeventtotask({
                task: currentTask.id,
                event: insertedEvents[0].id,
              }).then(function(res) {
                refreshTaskEvents(currentTask);
              });
            }
            _editEventTaskDialog.close();
          });
        };

        /**
         * validDecalages
         */
        scope.validDecalages = function() {
          // set new start
          var indexesToRemove = [scope.eventInTaskIndex];
          scope.currentEvents.forEach(function(e, i) {
            // changed date
            if (i != scope.eventInTaskIndex) {
              if (
                scope.currentEvents[i].properties.start !=
                scope.currentEvents[i].properties.newstart
              ) {
                scope.currentEvents[i].properties.start = $filter('date')(
                  scope.currentEvents[i].properties.newstart,
                  'yyyy-MM-ddTHH:mm:ss.sssZ'
                );
              } else {
                indexesToRemove.push(i);
              }
            }
            delete scope.currentEvents[i].properties.newstart;
          });

          indexesToRemove.forEach(function(idx) {
            scope.currentEvents.splice(idx, 1);
          });

          gaDomUtils.showGlobalLoader();
          CalendarFactory.updateevent({
            collection: {
              type: 'FeatureCollection',
              features: [scope.currentEvents],
            },
          }).then(
            function() {
              refreshTaskEvents(currentTask);
              gaDomUtils.hideGlobalLoader();
              _decaleEventsDialog.close();
              deregWatchDecalages();
            },
            function() {
              gaDomUtils.hideGlobalLoader();
              _decaleEventsDialog.close();
              deregWatchDecalages();
            }
          );
        };

        /**
         * pre_editEventMetaData
         * @param event
         */

        scope.pre_editEventMetaData = function(event, task, taskIndex) {
          scope.isLastTaskEvent =
            taskIndex == scope.tasksEvents[task.id].length - 1;
          scope.forceCloseTask = { v: false };
          currentTask = task;
          scope.editEventMetaData = event;
          scope.tmpeditEventMetaData = angular.copy(event);
        };

        /**
         * editEventMetaData
         */
        scope.doEditEventMetaData = function() {
          $('.popover-content')
            .parent()
            .remove();

          // edit status
          if (
            scope.editEventMetaData.properties.status !=
            scope.tmpeditEventMetaData.properties.status
          ) {
            gaDomUtils.showGlobalLoader();
            CalendarFactory.updateeventstatus({
              event_id: scope.editEventMetaData.id,
              status: scope.tmpeditEventMetaData.properties.status,
            }).then(
              function(res) {
                scope.editEventMetaData.properties.status =
                  scope.tmpeditEventMetaData.properties.status;

                if (scope.forceCloseTask.v) {
                  TaskFactory.updatetaskstatus({
                    task_id: currentTask.id,
                    status: 'cloture',
                  }).then(
                    function(res) {
                      currentTask.properties.status = 'cloture';
                      gaDomUtils.hideGlobalLoader();
                    },
                    function() {
                      gaDomUtils.hideGlobalLoader();
                    }
                  );
                } else {
                  gaDomUtils.hideGlobalLoader();
                }
              },
              function() {
                gaDomUtils.hideGlobalLoader();
              }
            );
          }
        };

        /* -************************************
         *  Task to template
         * ***********************************/
        /**
         *
         */
        var _taskToTemplateDialog;
        scope.taskToTemplateDialog = function(task) {
          var tplEvents = angular.copy(scope.tasksEvents[task.id]);
          tplEvents.forEach(function(tplEvent, idx) {
            var date1 = moment(tplEvent.properties.start),
              date2 = moment(tplEvent.properties.end);

            tplEvents[idx].properties.duration = moment
              .duration(date2.diff(date1))
              .asSeconds();
            tplEvents[idx].properties.duration_display = moment
              .utc(tplEvents[idx].properties.duration * 1000)
              .format('HH[h]mm');
          });

          scope.taskTemplate = {
            title: task.properties.title,
            description: task.properties.description,
            events: $filter('orderBy')(tplEvents, 'properties.start', false),
          };

          _taskToTemplateDialog = ngDialog.open({
            template:
              'js/XG/containers/views/modals/taskmanager.task.to.template.html',
            className: 'ngdialog-theme-plain width1000 nopadding miniclose',
            closeByDocument: false,
            scope: scope,
          });
        };

        /**
         * caculDelaiEntreEvents
         * @param index
         */
        scope.caculDelaiEntreEvents = function(index) {
          var date1 = moment(
              scope.taskTemplate.events[index - 1].properties.start
            ),
            date2 = moment(scope.taskTemplate.events[index].properties.start),
            duration = moment.duration(date2.diff(date1));

          scope.taskTemplate.events[index].delai = duration.asSeconds();
          scope.taskTemplate.events[index].delai_display = Math.round(
            duration.asDays()
          );
        };

        /**
         * canSaveTemplate
         * @returns {boolean}
         */
        scope.canSaveTemplate = function() {
          return (
            scope.taskTemplate.tile != '' &&
            scope.taskTemplate.description != ''
          );
        };

        /**
         * saveTaskTemplate
         */
        scope.saveTaskTemplate = function() {
          var toSave = {
            title: scope.taskTemplate.title,
            description: scope.taskTemplate.description,
            events: [],
          };

          scope.taskTemplate.events.forEach(function(event) {
            toSave.events.push({
              title: event.properties.title,
              description: event.properties.description,
              type_evenement: event.properties.type_evenement,
              color: event.properties.color,
              delai: event.delai ? event.delai_display * 24 * 3600 : 0,
              duration: event.properties.duration,
            });
          });

          console.log(toSave);
          gaDomUtils.showGlobalLoader();

          ParametersFactory.add(
            toSave,
            'TaskTemplate',
            toSave.title.replace(/ /g, '_')
          ).then(function(res) {
            if (
              res.data ==
              'Ajout impossible: un paramètre avec le même nom existe déjà.'
            ) {
              require('toastr').error(res.data);
              gaDomUtils.hideGlobalLoader();
              return false;
            }
            _taskToTemplateDialog.close();
            gaDomUtils.hideGlobalLoader();
            require('toastr').success($filter('translate')('common.saved'));
            getTaskTemplates();
          });
        };

        /**
         * getEventRGBAColor
         * @param color
         * @returns {string}
         */
        scope.getEventRGBAColor = function(color) {
          var r = parseInt(color.substring(0, 2), 16);
          var g = parseInt(color.substring(2, 4), 16);
          var b = parseInt(color.substring(4, 6), 16);

          return 'rgba(' + r + ',' + g + ',' + b + ',.65)';
        };
      },
    };
  };
  taskManager.$inject = [
    'TaskFactory',
    'gaDomUtils',
    'ngDialog',
    'EditFactory',
    '$timeout',
    'CalendarFactory',
    'ParametersFactory',
    '$filter',
    '$q',
    'gaJsUtils',
  ];
  return taskManager;
});


define('containers/services/panelsManager',[],function() {
  /**
   * Map Panels Manager Provider
   */
  var panelsManager = function() {
    var $panelContainer,
      $panels = {};

    // ---------------------------------- */

    this.$get = function($rootScope, $compile) {
      return {
        /**
         * Initializing the panelManager by adding the panelContainer element
         * @returns {boolean}
         */
        init: function() {
          //angular.element(document).find('body').eq(0).append('<div id="panelContainer"></div>');
          $panelContainer = angular.element(
            document.getElementById('panelContainer')
          );
          return true;
        },
        /**
         * Adding a panel to the manager
         * @param opt
         */
        addPanel: function(opt) {

          try {
            // Panel settings
            let id = '';
            let classes = 'map_panel';
            let style = '';

            // create a new scope or use the passed one if there is any
            let scope;
            if (opt.scope && opt.scope.special && opt.scope.special.usescope) {
              scope = opt.scope.$new();
              Object.assign(scope, opt.scope.special);
            } else {
              scope = angular.isObject(opt.scope)
                ? opt.scope.$new()
                : $rootScope.$new();
            }

            // new class
            if (opt.cssClass) {
              classes = 'newCssForPanel';
            }

            // id
            if (opt.id) id += opt.id;

            // visible
            if (opt.visible === false) classes += ' hiddenPanel';

            // Position Attribution
            opt.position = opt.position || 'bottom';
            classes += ' ' + opt.position;

            // stickToBorder
            if (opt.stickToBorder) classes += ' stick_to_border';

            // stickToRight
            if (opt.stickToRight) classes += ' stick_to_right';

            // size
            let pSize = 250;
            if (opt.size) pSize = opt.size;

            // position
            switch (opt.position) {
              case 'left':
              case 'right':
                style += 'min-width: ' + pSize + 'px';
                break;
              case 'top':
              case 'bottom':
              default:
                style += 'min-height: ' + pSize + 'px';
                break;
            }

            /* include templateUrl via ng-include */
            let tpl = '<div id="' + id + '" class="' + classes + '" style="' + style + '" >';
            if (opt.resizable) {
              tpl +=
                '<div class="panelresizebar" resizable resize-origin="panel" resize-origin-id="' +
                opt.id +
                '"></div>';
            }

            if (opt.templateUrl) {
              scope.templateUrl = opt.templateUrl;
              tpl += '<div ng-include="templateUrl"></div>';
            }
            tpl += '</div>';


            // Compile with error handling
            const compiledElement = $compile(tpl)(scope);

            // Add cleanup handler
            scope.$on('$destroy', () =>{
              compiledElement.remove();
            });

            $panelContainer.append(compiledElement);

            // add the panel to the panels list
            $panels[id] = angular.element(document.getElementById(id));
          }catch (error) {
            console.error('Error creating panel:', error);
            // Handle error appropriately
          }
        },
        /**
         * Hide the panel #id
         * @param id
         */
        hidePanel: function(id) {
          $panels[id].addClass('hiddenPanel');
        },
        /**
         * Show the panel #id
         * @param id
         */
        showPanel: function(id) {
          $panels[id].removeClass('hiddenPanel');
        },
        /**
         * Destroy the p[anel #id
         * @param id
         */
        removePanel: function(id) {
          if ($panels[id]) {
            if (angular.isDefined(angular.element($panels[id]).scope())) {
              angular
                .element($panels[id])
                .scope()
                .$destroy();
            }
            $panels[id].remove();
          }
        },
      };
    };
    this.$get.$inject = ['$rootScope', '$compile'];
  };
  return panelsManager;
});



define('containers/services/ActionsManager',['toastr','toastr','toastr','toastr','toastr','toastr','toastr','toastr','toastr','toastr','toastr','toastr','toastr','toastr','toastr','toastr','toastr','toastr','toastr','toastr','toastr','toastr','toastr'],function() {
  var ActionsManager = function(
    $filter,
    extendedNgDialog,
    $rootScope,
    SelectManager,
    ConfigFactory,
    ngDialog,
    ngTableParams,
    DocumentFactory,
    ReportIndicatorFactory,
    $q,
    FilesFactory,
    ActionFeatureFactory,
    $timeout,
    processFactory, gaJsUtils
  ) {
    var scope = $rootScope.$new();

    function setMap(map) {
      scope.map = map;
    }



    /*
     * Add Action OUS
     */
    function executeAction(currentselectedActionOnObject, objectActions, currentselect,
      currentselectfti, result, relatedfeature, scopeOfWidget) {
      if (!currentselectedActionOnObject) {
        require('toastr').error(
          $filter('translate')('selectfeaturetree.selectActionFirst')
        );
        return;
      }
      var index = objectActions
        .map(function(x) {
          return x.name;
        })
        .indexOf(currentselectedActionOnObject.name);

      var selectedAction = objectActions[index];
      const myFeature = result.features.find(feature => feature.id === currentselect.id);
      const currentSelectInFeatureCollection = {
        crs: currentselect.crs,
        type: 'FeatureCollection',
        totalFeatures: 1,
        realTotalFeatures: {
          [currentselectfti.alias]: 1
        },
        features: [myFeature]
      };
      switch (selectedAction.actionType) {
        case $filter('translate')('model.featuretypes.actions.form'):
          executeForm(selectedAction, currentselect, result);
          break;
        case $filter('translate')('model.featuretypes.actions.jasper'):
          executeJasper(
            selectedAction,
            currentselect,
            'onobject',
            currentselectfti,
            result,
            relatedfeature
          );
          break;
        case $filter('translate')('model.featuretypes.actions.url'):
          executeUrl(selectedAction, currentselect.properties);
          break;
        case $filter('translate')('model.featuretypes.actions.esrigeoprocess'):
          // -- N'afficher la commande de visualisation que si on a affaire
          // -- à un GeoPocess ArcGIS et que si au moins un a été lancé
          scopeOfWidget.actionTypeEsriGeoprocess = selectedAction.actionType;
          ActionFeatureFactory.executeEsriGeoprocess(selectedAction, currentselect.properties,
            scopeOfWidget, myFeature.geometry, currentselectfti.srid);
          break;
        case $filter('translate')('model.featuretypes.actions.html'):
          executeHtml(selectedAction, currentselect, currentselectfti);
          break;
        case $filter('translate')('model.featuretypes.actions.widget'):
        // On créé une collection avec uniquement la feature sur laquelle on execute l'action
          ActionFeatureFactory.openWidget(selectedAction, scope, currentSelectInFeatureCollection);
          break;
        default:
          switch (selectedAction.typeInfo) {
            case 'FORMULAIRE':
              executeForm(selectedAction, currentselect, result);
              break;
            case 'JASPER':
              executeJasper(
                selectedAction,
                currentselect,
                'onobject',
                currentselectfti,
                result,
                relatedfeature
              );
              break;
            case 'URL':
              executeUrl(selectedAction, currentselect.properties);
              break;
            case 'HTML':
              executeHtml(selectedAction, currentselect, currentselectfti);
              break;
          }
          break;
      }
    }

    function executeActionOnComponent(
      currentselectedActionOnComponent,
      componentActions,
      currentselectfti,
      geoj,
      result,
      relatedfeature, ws
    ) {
      if (!currentselectedActionOnComponent) {
        require('toastr').error(
          $filter('translate')('selectfeaturetree.selectActionFirst')
        );
        return;
      }
      var index = componentActions
        .map(function(x) {
          return x.name;
        })
        .indexOf(currentselectedActionOnComponent.name);

      var selectedAction = componentActions[index];
      scope.ws = ws;
      if (geoj) scope.geoj = geoj;
      else
        scope.geoj = SelectManager.getFeaturesByftiType(currentselectfti.name);
      executeJasper(
        selectedAction,
        scope.geoj,
        'oncomponent',
        currentselectfti,
        result,
        relatedfeature
      );
    }

    function executeActionOnGlobal(currentselectedActionOnGlobal, result) {
      var rapport = currentselectedActionOnGlobal.rapports[0];
      scope.parametersRapportUtilisateur = [];
      if (
        (rapport.type ===
          $filter('translate')('model.featuretypes.actions.JasperModel') ||
          rapport.typeInfo === 'JasperModel') &&
        rapport.parameters &&
        rapport.parameters.length > 0
      ) {
        var param = [];
        for (var j = 0; j < rapport.parameters.length; j++) {
          if (
            rapport.parameters[j].attribut !== 'ids.list' &&
            rapport.parameters[j].attribut !== 'user'
          ) {
            //rapport.parameters[j].rapportName = rapport.name;
            param.push(rapport.parameters[j]);
          }
        }
        if (param.length > 0)
          scope.parametersRapportUtilisateur.push({
            name: rapport.name,
            parameters: param,
          });
      }

      if (scope.parametersRapportUtilisateur.length > 0) {
        scope.tableParamsParameters = new ngTableParams(
          {
            page: 1, // show first page
            count: 10, // count per page
          },
          {
            total: 0, // length of data
            getData: function($defer, params) {
              var displayedTab = scope.parametersRapportUtilisateur.slice(
                (params.page() - 1) * params.count(),
                params.page() * params.count()
              );

              // set total for recalc pagination
              params.total(scope.parametersRapportUtilisateur.length);
              $defer.resolve(displayedTab);
            },
          }
        );
        scope.ngdiaParameters = ngDialog.openConfirm({
          template:
            'js/XG/widgets/mapapp/selectFeatureTree/views/panel/popoverActionsGlobalParameters.html',
          scope: scope,
          className: 'ngdialog-theme-plain width800 nopadding miniclose',
        });
        scope.ngdiaParameters.then(
          function() {
            executeGlobalJasper(rapport, result);
          },
          function() {
            require('toastr').info(
              $filter('translate')('selectfeaturetree.saisirtocontinue')
            );
          }
        );
      } else {
        executeGlobalJasper(rapport, result);
      }
    }

    function executeHtml(action, currentselect, currentselectfti) {
      scope.newobj = {};
      scope.newobj.current = currentselect;
      scope.fti = currentselectfti;
      if (scope.openHTMLDialog) scope.openHTMLDialog.close();
      scope.openHTMLDialog = extendedNgDialog.open({
        template: 'fichemetiers/' + action.url,
        className: 'ngdialog-theme-plain width800 nopadding miniclose',
        closeByDocument: false,
        scope: scope,
        title: currentselectfti.name,
        draggable: true,
      });
    }

    function executeForm(action, currentselect, result) {
      for (var i = 0; i < result.features.length; i++) {
        if (result.features[i].id === currentselect.id) {
          var selectedCurrentFeature = result.features[i];
          break;
        }
      }
      ConfigFactory.get(action.type, action.form).then(
        function (res) {
          scope.currentTemplate = res.data;
          const newScope = scope.$new();
          newScope.newobj = {};
          newScope.newobj.allResult = result;
          newScope.newobj.current = selectedCurrentFeature;

          if (scope.openFormulaireDialog) {
            scope.openFormulaireDialog.close();
          }
          scope.openFormulaireDialog = extendedNgDialog.open({
            template:
              'js/XG/widgets/mapapp/selectFeatureTree/views/panel/formulaire.html',
            className:
              action.name === 'info_abonne_omega'
                ? 'ngdialog-theme-plain height700 nopadding miniclose'
                : 'ngdialog-theme-plain width800 nopadding miniclose',
            closeByDocument: false,
            scope: newScope,
            title: '',
            draggable: true,
            scrollable: true,
            minimizeMaximize: true,
            resizable: true,
            minWidth: '570px',
            minHeight: '400px',
            formOptions: scope.currentTemplate.options,
          });
          newScope.dlgPopup = scope.openFormulaireDialog;
        },
        function () {
          console.log('form does not exist');
        }
      );
    }

    function executeUrl(action, properties) {
      scope.parametersRapportUtilisateur = [];
      var param = [];
      for (var j = 0; j < action.parameters.length; j++) {
        if (
          action.parameters[j].saisieMode ===
            $filter('translate')(
              'model.featuretypes.actions.saisieUtilisateur'
            ) ||
          action.parameters[j].typeInfo === 'saisieUtilisateur'
        ) {
          //action.parameters[j].rapportName = action.name;
          //.parametersRapportUtilisateur.push(action.parameters[j]);
          param.push(action.parameters[j]);
        }
      }
      if (param.length > 0)
        scope.parametersRapportUtilisateur.push({
          name: action.name,
          parameters: param,
        });
      if (scope.parametersRapportUtilisateur.length > 0) {
        scope.tableParamsParameters = new ngTableParams(
          {
            page: 1, // show first page
            count: 10, // count per page
          },
          {
            total: 0, // length of data
            getData: function($defer, params) {
              var displayedTab = scope.parametersRapportUtilisateur.slice(
                (params.page() - 1) * params.count(),
                params.page() * params.count()
              );

              // set total for recalc pagination
              params.total(scope.parametersRapportUtilisateur.length);
              $defer.resolve(displayedTab);
            },
          }
        );
        scope.ngdiaParameters = ngDialog.openConfirm({
          template:
            'js/XG/widgets/mapapp/selectFeatureTree/views/panel/popoverActionsGlobalParameters.html',
          scope: scope,
          className: 'ngdialog-theme-plain width800 nopadding miniclose',
        });
        scope.ngdiaParameters.then(
          function() {
            var url = parseUrl(action, properties);
            window.open(url);
          },
          function() {
            require('toastr').info(
              $filter('translate')('selectfeaturetree.saisirtocontinue')
            );
          }
        );
      } else {
        var url = parseUrl(action, properties);
        window.open(url);
      }
    }

    function parseUrl(action, properties) {
      var url = action.url;
      var params = action.parameters;
      if (params.length > 0) {
        url += '?';
        var value;
        for (var i = 0; i < params.length; i++) {
          switch (params[i].saisieMode) {
            case $filter('translate')(
              'model.featuretypes.actions.saisieAttribut'
            ):
              properties[params[i].value] &&
              properties[params[i].value] !== null
                ? (value = properties[params[i].value])
                : (value = '');
              if (i > 0) url += '&';
              url += params[i].name + '=' + value;
              break;
            case $filter('translate')(
              'model.featuretypes.actions.saisieStatic'
            ):
              if (i > 0) url += '&';
              url += params[i].name + '=' + params[i].attribute;
              break;
            case $filter('translate')(
              'model.featuretypes.actions.saisieUtilisateur'
            ):
              if (i > 0) url += '&';
              url += params[i].name + '=' + params[i].value;
              break;
            default:
              switch (params[i].typeInfo) {
                case 'saisieAttribut':
                  properties[params[i].value] &&
                  properties[params[i].value] !== null
                    ? (value = properties[params[i].value])
                    : (value = '');
                  if (i > 0) url += '&';
                  url += params[i].name + '=' + value;
                  break;
                case 'saisieStatic':
                  if (i > 0) url += '&';
                  url += params[i].name + '=' + params[i].attribute;
                  break;
                case 'saisieUtilisateur':
                  if (i > 0) url += '&';
                  url += params[i].name + '=' + params[i].value;
                  break;
              }
              break;
          }
        }
      }
      return url;
    }

    const executeGlobalJasper = (rapport, result) => {
      if (!rapport || !result) {
        require('toastr').error(
          $filter('translate')(
            'model.featuretypes.actions.reportorresultabsent'
          ));
      }else {
        const sendata = generateSendataForGlobal(rapport, result);
        if (!rapport.format || rapport.format.length===0){
          rapport.format = 'pdf';
        }
        ReportIndicatorFactory.generateReportExtended(
          rapport.file,
          rapport.storeName,
          sendata,
          rapport.format,
          true
        ).then(
          (res) => {
            if (res.data.pdfdone) {
              ReportIndicatorFactory.getPdf(res.data.fileNameGenerated, rapport.format).then(
                (data) => {
                  const resultObject = data.data;
                  const blob = new Blob([resultObject], gaJsUtils.applicationTypes[rapport.format]);
                  const objectUrl = URL.createObjectURL(blob);
                  window.open(objectUrl);
                },
                () => {
                  require('toastr').error(
                    $filter('translate')('model.featuretypes.actions.unableToDownloadFile')
                      + rapport.format);
                }
              );
            } else {
              require('toastr').error(
                $filter('translate')(
                  'model.featuretypes.actions.unabletogeneratepdf'
                ) +
                    ' ' +
                    rapport.file
              );
            }
          },
          () => {
            require('toastr').error(
              $filter('translate')(
                'model.featuretypes.actions.unabletogeneratepdf'
              ) +
                  ' ' +
                  rapport.file
            );
          }
        );
      }
    };

    function generateSendataForGlobal(rapport, currentselect) {
      if (!rapport || !currentselect) {
        require('toastr').error(
          $filter('translate')(
            'model.featuretypes.actions.reportorselecttabsent'
          ));
      } else {
        var res = {};
        angular.forEach(rapport.parameters, function (param) {
          switch (param.attribut) {
            case 'ids.list':
              for (var i = 0; i < currentselect.features.length; i++) {
                try {
                  var id = currentselect.features[i].id;
                  var featureName = id.split('.')[0];
                  if (Object.keys(res).indexOf(featureName) === -1)
                    res[featureName] = [];
                  res[featureName].push(Number(id.split('.')[1]));
                } catch (e) {
                  console.error(e.message);
                }
              }
              break;
            case 'user':
              res[param.name] = $rootScope.xgos.user.login;
              break;
            default:
              res[param.name] = param.value;
              break;
          }
        });
        return res;
      }
    }

    const executeJasper = (
      action,
      currentselect,
      which,
      currentselectfti,
      result,
      relatedfeature
    ) => {
      scope.parametersRapportUtilisateur = [];
      for (let i = 0; i < action.rapports.length; i++) {
        if (
          (action.rapports[i].type ===
            $filter('translate')('model.featuretypes.actions.JasperModel') ||
            action.rapports[i].typeInfo === 'JasperModel') &&
          action.rapports[i].parameters &&
          action.rapports[i].parameters.length > 0
        ) {
          const param = [];
          for (let j = 0; j < action.rapports[i].parameters.length; j++) {
            if (
              action.rapports[i].parameters[j].saisieMode ===
                $filter('translate')(
                  'model.featuretypes.actions.saisieUtilisateur'
                ) ||
              action.rapports[i].parameters[j].typeInfo === 'saisieUtilisateur'
            ) {
              param.push(action.rapports[i].parameters[j]);
            }
          }
          if (param.length > 0)
            scope.parametersRapportUtilisateur.push({
              name: action.rapports[i].name,
              parameters: param,
            });
        }
      }
      if (scope.parametersRapportUtilisateur.length > 0) {
        scope.tableParamsParameters = new ngTableParams(
          {
            page: 1, // show first page
            count: 10, // count per page
          },
          {
            total: 0, // length of data
            getData: function($defer, params) {
              const displayedTab = scope.parametersRapportUtilisateur.slice(
                (params.page() - 1) * params.count(),
                params.page() * params.count()
              );

              // set total for recalc pagination
              params.total(scope.parametersRapportUtilisateur.length);
              $defer.resolve(displayedTab);
            },
          }
        );
        scope.ngdiaParameters = ngDialog.openConfirm({
          template:
            'js/XG/widgets/mapapp/selectFeatureTree/views/panel/popoverActionsGlobalParameters.html',
          scope: scope,
          className: 'ngdialog-theme-plain width800 nopadding miniclose',
        });
        scope.ngdiaParameters.then(
          () => {
            switch (which) {
              case 'oncomponent':
                JasperOnComponent(action, currentselect, currentselectfti);
                break;
              case 'onobject':
                Jasper(
                  action,
                  currentselect,
                  currentselectfti,
                  result,
                  relatedfeature
                );
                break;
            }
          },
          () => {
            require('toastr').info(
              $filter('translate')('selectfeaturetree.saisirtocontinue')
            );
          }
        );
      } else {
        switch (which) {
          case 'oncomponent':
            JasperOnComponent(action, currentselect, currentselectfti);
            break;
          case 'onobject':
            Jasper(
              action,
              currentselect,
              currentselectfti,
              result,
              relatedfeature
            );
            break;
        }
      }
    };


    const Jasper = (action, currentselect, currentselectfti, result,
      relatedfeature) => {
      const sendata = getPortalDoc(currentselect, result, currentselectfti, relatedfeature);
      if (action.rapports.length === 1) {
        const rapport = action.rapports[0];

        switch (rapport.type) {
          case $filter('translate')('model.featuretypes.actions.PortalModel'):

            DocumentFactory.generatedocx(
              sendata,
              rapport.file,
              currentselect.id,
              false,
              scope.map.getView().getProjection().getCode()
            ).then((res) => {
              window.open(
                '/services/' +
                angular.module('gcMain').portalid +
                '/documents/downloaddocx?' +
                '&name=' +
                res.data.name
              );
            });
            break;
          case $filter('translate')('model.featuretypes.actions.StaticModel'):
            window.open(
              '/services/'+localStorage.getItem('portal')+'/files/getfilestatic?ftiname=' +
              currentselectfti.name +
              '&filename=' +
              rapport.file
            );
            break;
          case $filter('translate')('model.featuretypes.actions.JasperModel'):
            generateJasperDoc(rapport, currentselect, currentselectfti, action);
            break;
          default:
            switch (rapport.typeInfo) {
              case 'PortalModel':
                DocumentFactory.generatedocx(
                  sendata,
                  rapport.file,
                  currentselect.id,
                  false,
                  scope.map.getView().getProjection().getCode()
                ).then((res) => {
                  window.open(
                    '/services/' +
                    angular.module('gcMain').portalid +
                    '/documents/downloaddocx?' +
                    '&name=' +
                    res.data.name
                  );
                });
                break;
              case 'StaticModel':
                window.open(
                  '/services/'+localStorage.getItem('portal')+'/files/getfilestatic?ftiname=' +
                  currentselectfti.name +
                  '&filename=' +
                  rapport.file
                );
                break;
              case 'JasperModel':
                generateJasperDoc(rapport, currentselect, currentselectfti);
                break;
            }
            break;
        }
      } else {
        const promisses = [];
        const FullDataGenerate = [];
        for (let i = 0; i < action.rapports.length; i++) {
          const rapport = action.rapports[i];
          switch (rapport.type) {
            case $filter('translate')('model.featuretypes.actions.PortalModel'):
              ActionFeatureFactory.generateDocx(promisses, sendata, rapport, currentselect,
                FullDataGenerate);
              break;
            case $filter('translate')('model.featuretypes.actions.StaticModel'):
              FullDataGenerate.push({
                type: 'StaticModel',
                file: rapport.file,
                ftiname: currentselectfti.name,
              });
              break;
            case $filter('translate')('model.featuretypes.actions.JasperModel'):
              ActionFeatureFactory.generateJasper(rapport, currentselect, currentselectfti,
                promisses, FullDataGenerate);
              break;
            default:
              switch (rapport.typeInfo) {
                case 'PortalModel':
                  ActionFeatureFactory.generateDocx(promisses, sendata, rapport, currentselect,
                    FullDataGenerate);
                  break;
                case 'StaticModel':
                  FullDataGenerate.push({
                    type: 'StaticModel',
                    file: rapport.file,
                    ftiname: currentselectfti.name,
                  });
                  break;
                case 'JasperModel':
                  ActionFeatureFactory.generateJasper(rapport, currentselect, currentselectfti,
                    promisses, FullDataGenerate);
                  break;
              }
              break;
          }
        }
        $q.all(promisses).then(() => {
          FilesFactory.getActionsGeneratedZip(FullDataGenerate).then(
            (res) => {
              window.open(
                '/services/' +
                angular.module('gcMain').portalid +
                '/files/getgeneratedzip?filename=' +
                res.data.filename
              );
            },
            () => {
              require('toastr').error('error');
            }
          );
        });
      }
    };


    /**
     * Vérifie l'état d'un processus de génération de document avec un intervalle de 1 seconde
     *
     * Cette fonction interroge le statut d'un processus de génération de document et:
     * - Ouvre automatiquement le document si terminé avec succès (FINISHED)
     * - Affiche une erreur si la génération a échoué (FAILED)
     * - Continue de vérifier toutes les secondes si le processus est toujours en cours (RUNNING)
     * - Met à jour les indicateurs visuels dans l'interface utilisateur via scope.ws
     *
     * @param {string} processUid - Identifiant unique du processus à vérifier
     */
    const checkGeneratingDocx = (processUid) => {

      processFactory.getProcessByUid(processUid).then(response => {
        const data = response.data;
        if (!data) {
          // -- Quand pas de contenu, la description du process n'est pas prête
          $timeout(() => { checkGeneratingDocx(processUid); }, 1000);
        }
        else {
          // -- Le processus a 4 états possibles: RUNNING, FINISHED, FAILED, INTERRUPTED
          if (data.etat === 'FINISHED') {
            // -- Les documents on été générés, on les télécharge
            window.open(
              '/services/' + $rootScope.xgos.portal.uid +
              '/documents/getFileProcess?f=json&uid=' + processUid +
              '&token=' + encodeURIComponent(localStorage.getItem('auth_token'))
            );
            // -- Point vert pendant 15 secondes
            scope.ws.hasBeenGenerated = true;
            $timeout(() => {
              scope.ws.hasBeenGenerated = false;
            }, 15000);
          }
          else if (data.etat === 'FAILED') {
            // -- La fabrication es documents a échoué
            const error = data.errorMessage
              ? data.errorMessage : 'Erreur non détaillée';
            require('toastr').error(error);
            // -- Point rouge pendant 15 secondes
            scope.ws.generationError = true;
            $timeout(() => {
              scope.ws.generationError = false;
            }, 15000);
          }
          // -- Le processus est-il toujours en cours de génération ?
          scope.ws.isGeneratingDocx = data.etat === 'RUNNING';
          if (scope.ws.isGeneratingDocx) {
            $timeout(() => { checkGeneratingDocx(processUid); }, 1000);
          }
        }
      });
    };


    const JasperOnComponent = (action, geoj, currentselectfti) => {
      const rapport = action.rapports[0];
      if (
        rapport.typeInfo === 'PortalModel' ||
        rapport.type ===
          $filter('translate')('model.featuretypes.actions.PortalModel')
      ) {
        const senddata = getPortalDocMultiple(geoj, currentselectfti);
        scope.ws.isGeneratingDocx = true;
        DocumentFactory.generatemultipledocx(
          senddata,
          rapport.file,
          currentselectfti.uid,
          scope.map.getView().getProjection().getCode()
        ).then(
          (res) => {
            checkGeneratingDocx(res.data.uid);
          },
          () => {
            require('toastr').error('error');
          }
        );
      } else {
        const features = geoj.features;
        const sendata = [];
        angular.forEach(features, (feature) => {
          if (rapport && feature && currentselectfti){
            sendata.push(generateSendata(rapport, feature, currentselectfti));
          } else {
            require('toastr').error(
              $filter('translate')(
                'model.featuretypes.actions.ftiorreportorselectabsent'
              ));
          }
        });
        const execStoreName = currentselectfti.type==='esri'
          && rapport.storeName ? rapport.storeName : currentselectfti.storeName;
        ReportIndicatorFactory.checkActionReportExists(rapport.file).then(
          (result)=>{
            if (result && result.data){
              ReportIndicatorFactory.generateMultipleReportExtended(
                rapport.file,
                execStoreName,
                sendata,
                true
              ).then(
                (res) => {
                  if (res.data && res.data.etat === 'fini') {
                    window.open(
                      '/services/' +
                      angular.module('gcMain').portalid +
                      '/indicator/' +
                      angular.module('gcMain').app +
                      '/getgeneratedzip?filename=' +
                      res.data.file
                    );
                  } else {
                    require('toastr').error($filter('translate')(
                      'model.featuretypes.actions.multiplereporterror'));
                  }
                },
                () => {
                  require('toastr').error($filter('translate')(
                    'model.featuretypes.actions.multiplereportfailure'));
                }
              );
            }
            else {
              swal({
                title: $filter('translate')('model.featuretypes.actions.deletedFile'),
                text: $filter('translate')(
                  'model.featuretypes.actions.deletedReport') + '\n'
                  + (rapport && rapport.file ? rapport.file : 'rapport = undefined'),
                type: 'error',
                showCancelButton: false,
                confirmButtonColor: '#CCC',
                confirmButtonText: $filter('translate')('common.ok'),
                closeOnConfirm: true,
              });
            }
          },
          ()=>{
            require('toastr').error(
              $filter('translate')(
                'model.featuretypes.actions.unabletocheckFileExist'
              ) +
                ' ' +
                rapport.file
            );
          }
        );
      }
    };


    const generateJasperDoc = (rapport, currentselect, currentselectfti) => {
      if (!currentselectfti || !rapport || !currentselect) {
        require('toastr').error(
          $filter('translate')(
            'model.featuretypes.actions.ftiorreportorselectabsent'
          ));
      }else {
        const sendata = generateSendata(rapport, currentselect, currentselectfti);

        ReportIndicatorFactory.checkActionReportExists(rapport.file).then(
          (result) => {
            if (result && result.data) {
              let execStoreName = currentselectfti.type === 'esri'
                && rapport.storeName ? rapport.storeName
                : currentselectfti.storeName;
              if (!rapport.format || rapport.format.length === 0){
                rapport.format = 'pdf';
              }
              ReportIndicatorFactory.generateReportExtended(
                rapport.file,
                execStoreName,
                sendata,
                rapport.format,
                true).then(
                (res) => {
                  if (res.data && res.data.pdfdone) {
                    ReportIndicatorFactory.getPdf(
                      res.data.fileNameGenerated,
                      rapport.format).then(
                      (data) => {
                        const resultObject = data.data;
                        const blob
                          = new Blob([resultObject], gaJsUtils.applicationTypes[rapport.format]);
                        if ('rtf,odt,ods'.includes(rapport.format)){
                          const a = document.createElement('a');
                          document.body.appendChild(a);
                          a.style = 'display: none';
                          const url = window.URL.createObjectURL(blob);
                          a.href = url;
                          a.download = res.data.fileNameGenerated + '.' + rapport.format;
                          a.click();
                          window.URL.revokeObjectURL(url);
                        }else{
                          const objectUrl = URL.createObjectURL(blob);
                          window.open(objectUrl);
                        }
                      },
                      () => {
                        require('toastr').error(
                          $filter('translate')('model.featuretypes.actions.unableToDownloadFile')
                            + rapport.format);
                      }
                    );
                  } else {
                    require('toastr').error(
                      $filter('translate')(
                        'model.featuretypes.actions.unabletogeneratepdf') + ' ' + rapport.file
                    );
                  }
                },
                () => {
                  require('toastr').error(
                    $filter('translate')(
                      'model.featuretypes.actions.unabletogeneratepdf') + ' ' + rapport.file);
                }
              );
            } else {
              swal({
                title: $filter('translate')(
                  'model.featuretypes.actions.deletedFile'),
                text: $filter('translate')(
                  'model.featuretypes.actions.deletedReport') + '\n'
                      + (rapport && rapport.file ? rapport.file
                        : 'nom du rapport undefined'),
                type: 'error',
                showCancelButton: false,
                confirmButtonColor: '#CCC',
                confirmButtonText: $filter('translate')('common.ok'),
                closeOnConfirm: true,
              });
            }
          },
          () => {
            require('toastr').error(
              $filter('translate')(
                'model.featuretypes.actions.unabletocheckFileExist')
                + ' ' + rapport.file);
          }
        );
      }
    };

    const generateSendata = (rapport, currentselect, currentselectfti) => {
      if(!rapport || !currentselect || !currentselectfti){
        require('toastr').error(
          $filter('translate')(
            'model.featuretypes.actions.ftiorreportorselectabsent'
          ));
      }else{
        const res = {};
        angular.forEach(rapport.parameters, (param) => {
          switch (param.saisieMode) {
            case $filter('translate')(
              'model.featuretypes.actions.saisieAttribut'
            ):
              if (param.attribut === 'id' && currentselectfti.type !== 'esri') {
                res[param.name] = Number(
                  currentselect.id.replace(currentselectfti.name + '.', '')
                );
              } else {
                res[param.name] = currentselect.properties[param.attribut];
              }
              break;
            default:
              switch (param.typeInfo) {
                case 'saisieAttribut':
                  if (param.attribut === 'id') {
                    res[param.name] = Number(
                      currentselect.id.replace(currentselectfti.name + '.', '')
                    );
                  } else {
                    res[param.name] = currentselect.properties[param.attribut];
                  }
                  break;
                default:
                  res[param.name] = param.value;
                  break;
              }
              break;
          }
        });
        return res;
      }
    };

    const getPortalDocMultiple = (geoj, currentselectfti) => {
      const sendata = [];
      geoj.features.map((x) => {
        const res = {
          current: x,
          relationsNames: currentselectfti.relations
            .map((y) => {
              if (y.type === 'REL_NM') return y;
            })
            .filter((y) => {
              if (y) return y;
            }),
        };
        sendata.push(res);
      });
      return sendata;
    };

    const getPortalDoc = (
      currentselect,
      result,
      currentselectfti,
      relatedfeature
    ) => {
      let selectedCurrentFeature;
      for (let i = 0; i < result.features.length; i++) {
        if (result.features[i].id === currentselect.id) {
          selectedCurrentFeature = result.features[i];
          break;
        }
      }
      let res = {
        current: selectedCurrentFeature,
      };
      const idsNames = getNamesIds(currentselectfti, relatedfeature);
      res = createSendMessage(res, idsNames);

      return res;
    };

    const createSendMessage = (res, idsNames) => {
      const relationN = idsNames[2];
      const features = idsNames[3];
      let uniqueRelationNames = angular.copy(relationN);
      uniqueRelationNames = $.unique(uniqueRelationNames);
      for (let i = 0; i < uniqueRelationNames.length; i++) {
        const arr = [];
        for (let j = 0; j < relationN.length; j++) {
          if (relationN[j] === uniqueRelationNames[i]) arr.push(features[j]);
        }
        res[uniqueRelationNames[i]] = arr;
      }

      return res;
    };

    const getNamesIds = (currentselectfti, relatedfeature) => {
      const ids = [];
      const names = [];
      const relationN = [];
      const features = [];
      const relations = currentselectfti.relations;
      const relationsComponentsEnd = [];
      const relationsNames = [];
      relations.map((x) => {
        if (x.componentEnd) {
          relationsComponentsEnd.push(x.componentEnd);
          relationsNames.push(x.name);
        }
      });
      if (relatedfeature && relatedfeature.features) {
        for (const feature of relatedfeature.features) {
          const id = feature.id;
          const name = id.substring(0, id.lastIndexOf('.'));
          if (relationsComponentsEnd.indexOf(name) !== -1) {
            ids.push(id);
            names.push(name);
            features.push(feature);
            relationN.push(relationsNames[relationsComponentsEnd.indexOf(name)]);
          }
        }
      }

      return [ids, names, relationN, features];
    };

    return {
      setMap: setMap,
      executeAction: executeAction,
      executeActionOnComponent: executeActionOnComponent,
      executeActionOnGlobal: executeActionOnGlobal,
      executeHtml: executeHtml,
      executeForm: executeForm,
      executeUrl: executeUrl,
      parseUrl: parseUrl,
      executeGlobalJasper: executeGlobalJasper,
      generateSendataForGlobal: generateSendataForGlobal,
      executeJasper: executeJasper,
      Jasper: Jasper,
      JasperOnComponent: JasperOnComponent,
      generateJasperDoc: generateJasperDoc,
      generateSendata: generateSendata,
      getPortalDocMultiple: getPortalDocMultiple,
      getPortalDoc: getPortalDoc,
      createSendMessage: createSendMessage,
      getNamesIds: getNamesIds,
    };
  };

  ActionsManager.$inject = [
    '$filter',
    'extendedNgDialog',
    '$rootScope',
    'SelectManager',
    'ConfigFactory',
    'ngDialog',
    'ngTableParams',
    'DocumentFactory',
    'ReportIndicatorFactory',
    '$q',
    'FilesFactory',
    'ActionFeatureFactory',
    '$timeout',
    'processFactory',
    'gaJsUtils'
  ];

  return ActionsManager;
});


define('containers/services/kisCalendarFactory',[],function() {
  var kisCalendarFactory = function(
    ConfigFactory,
    AncAppFactory,
    $rootScope,
    $filter,
    CalendarFactory,
    FeatureTypeFactory,
    $q
  ) {
    var resources = {
      config: {
        eventTypes: []
      },
    };
    var dossierFTI;

    var mapTypeControle = {
      FO0: 'kis_anc_standard_fo0_reception',
      FO1: 'kis_anc_standard_fo1_conception',
      FO2: 'kis_anc_standard_fo2_realisation',
      FO3_mutation: 'kis_anc_standard_fo3_existant',
      FO3: 'kis_anc_standard_fo3_existant',
      FO4_mutation: 'kis_anc_standard_fo4_bon_fonctionnement',
      FO4: 'kis_anc_standard_fo4_bon_fonctionnement',
      Vidange: 'kis_anc_standard_controle_vidange',
      Ponctuel: 'kis_anc_standard_controle_ponctuel',
    };

    ConfigFactory.get('ANC', 'calendar').then(function(res) {
      if (res.data != '') resources.config = res.data;
    });

    function getColorFromConfig(eventTypeProps) {
      var iEt, ets, color;
      if (resources.config != undefined) {
        ets = resources.config.eventTypes;
        if (ets){
          for (iEt = 0; iEt < ets.length; iEt++) {
            if (ets[iEt].type_id == eventTypeProps.type_id) {
              color = ets[iEt].color;
            }
          }
        }
         
      }
      if (color == undefined) color = eventTypeProps.default_color;
      return color;
    }

    function getEventFromTypeDeControle(controle, eventTypes, pTypeControle) {
      var color, type_evenement, found, typeControle;
      if (pTypeControle != undefined) typeControle = pTypeControle;
      else typeControle = mapTypeControle[controle.properties.type];
      found = eventTypes.some(function(eventType) {
        if (typeControle == eventType.properties.type) {
          color = getColorFromConfig(eventType.properties);
          type_evenement = eventType.properties.type_id;
          return true;
        }
      });
      return { found: found, color: color, typeEvent: type_evenement };
    }

    function getDossierFti() {
      if (
        AncAppFactory.appCfg &&
        AncAppFactory.appCfg.main &&
        AncAppFactory.appCfg.main.datastore
      ) {
        var dossierFTI = FeatureTypeFactory.getFeatureByNameAndDatastore(
          AncAppFactory.appCfg.main.datastore,
          'kis_anc_dossier'
        );
      }
      return dossierFTI
    }

    function refreshListeDossier() {
      if (dossierFTI == undefined) dossierFTI = getDossierFti();
      if (dossierFTI) {
        $rootScope.$broadcast('refreshDatatable', { uid: dossierFTI.uid });
      }
    }

    /**
     *    Suppression d'un événement du calendrier.
     */
    function annulerEvent(idOfEventToDelete, closeEvent, idDossier) {
      var ans = confirm($filter('translate')('calendar.event.cancel_event'));
      if (ans) {
        var id = idOfEventToDelete.split('.');
        return CalendarFactory.cancelevent(id[1],idDossier).then(function(res) {
          refreshListeDossier();
          if (closeEvent != undefined) closeEvent();
        });
      }
      return $q.reject();
    }

    return {
      getEventFromTypeDeControle: getEventFromTypeDeControle,
      annulerEvent: annulerEvent,
      refreshListeDossier: refreshListeDossier,
      resources: resources,
    };
  };
  kisCalendarFactory.$inject = [
    'ConfigFactory',
    'AncAppFactory',
    '$rootScope',
    '$filter',
    'CalendarFactory',
    'FeatureTypeFactory',
    '$q',
  ];
  return kisCalendarFactory;
});



define('containers/services/AssEditProcessServices',['toastr','toastr','toastr','toastr','toastr','toastr','toastr'],function () {
  var AssEditProcessServices = function (
    AdvancedEditionFactory,
    gclayers,
    FeatureTypeFactory,
    gcWFS,
    EditRulesFeatGeomFactory,
    extendedNgDialog,
    $translate,
    gaDomUtils,
    ogcFactory,
    ASSEditionFactory
  ) {
    let consumerScope;
    const GEOJSON_PARSER = new ol.format.GeoJSON();
    let wfsLayer = undefined;
    let style;
    let fti = undefined;
    let tool = {
      actionParent: 'ASS',
      actionType: 'longitudinalProfil',
      itemUID: '3b7abc6e-05a4-442c-bd14-0b719604eccb',
      style: 'elec_editing_elec-tool-04-bt-tron-move-png24',
      tooltip: 'Profil en long',
    }

    let longitudinalProfilFormTitle = 'Génération du profil en long';
    $translate('networkedit.sanitation.longitudinalProfilFormTitle').then(
      (res) => {
        longitudinalProfilFormTitle = res;
      }
    );


    /**
     * Pose une image sur le sommet et le milieu de chaque seguement
     * @param  {[type]} geometry [description]
     * @param  {[type]} styles   [description]
     * @return {[type]}          [description]
     */
    function typeGeometry(geometry, styles) {
      if (geometry.getLineString(0)) {
        geometry.getLineString(0).forEachSegment((start, end) => {
          const dx = end[0] - start[0];
          const dy = end[1] - start[1];
          const centre = [];
          centre[0] = start[0] + dx / 2;
          centre[1] = start[1] + dy / 2;

          const rotation = Math.atan2(dy, dx);
          // arrows
          styles.push(
            new ol.style.Style({
              geometry: new ol.geom.Point(end),
              image: new ol.style.Icon({
                src: 'img/common/arrow.png',
                anchor: [0.7, 0.5],
                // anchor: [0.75, 0.5],
                rotateWithView: true,
                rotation: -rotation,
              }),
            })
          );

          styles.push(
            new ol.style.Style({
              geometry: new ol.geom.Point(centre),
              image: new ol.style.Icon({
                src: 'img/common/arrow.png',
                anchor: [0.7, 0.5],
                // anchor: [0.75, 0.5],
                rotateWithView: true,
                rotation: -rotation,
              }),
            })
          );
        });
      }
    }

    /**
     * elle met en evidence le flux de canalisation ainsi la canalisation inversée
     * @param  {[type]} feature [description]
     * @return {[type]}         [description]
     */
    let styleFunction = (feature) => {
      let lineWidth = 2;
      if (featuresInversees.indexOf(feature.getId()) != -1) {
        lineWidth = 4;
        featuresInversees.splice(featuresInversees.indexOf(feature.getId()), 1);
      }
      const geometry = feature.getGeometry();
      const styles = [
        // linestring
        new ol.style.Style({
          stroke: new ol.style.Stroke({
            color: '#B22222',
            width: lineWidth,
          }),
        }),
      ];

      typeGeometry(geometry, styles);

      return styles;
    };

    // var styleFunctionInv = function(feature) {
    //       // var geometry = feature.getGeometry();
    //       var styles = [
    //         // linestring
    //         new ol.style.Style({
    //           image: new ol.style.Icon({
    //            src: 'img/common/Arrow-Down-Red.png',
    //            anchor: [0.0, 0.0]
    //                // rotateWithView: true
    //              }),
    //           stroke: new ol.style.Stroke({
    //             color: '#B22222',
    //             width: 2
    //           })

    //         })

    //         ];

    //      return styles;
    //    };

    function dessinerFlux(scope, tool) {
      if (gclayers.getOperationalLayer()) {
        const layers = gclayers.getOperationalLayer();

        const fti = FeatureTypeFactory.getFeatureByUid(scope.currentFti.uid);

        const layersToLoad = [];
        layersToLoad.push(fti);
        wfsLayer = gcWFS.getOlLayerFromFeaturetypeInfoArray(layersToLoad,scope.map);
        wfsLayer.setStyle(styleFunction);
        const map = scope.map;
        map.addLayer(wfsLayer);
        console.log(wfsLayer);
      }
    }

    function effacerFlux(scope, tool) {
      const map = scope.map;
      map.removeLayer(wfsLayer);
      console.log('supprimé!!!');
    }

    let featuresInversees = [];

    function inverser(scope, res, evt, consumerScope) {
      scope.isActive = true;
      const selectedFeatures = GEOJSON_PARSER.readFeatures(res.data);
      const layersToLoad = [];
      if (selectedFeatures.length > 0) {
        fti = {
          shareObject: '',
          editType: scope.editdescription.editType,
          feature: selectedFeatures[0],
          fti: scope.editdescription.fti,
          uid: scope.editdescription.fti.uid,
        };

        layersToLoad.push(fti);

        const feature = wfsLayer
          .getSource()
          .getFeatureById(fti.feature.getId());
        featuresInversees.push(feature.getId());
        const geom = feature.getGeometry();
        const geomInversee = EditRulesFeatGeomFactory.inverserLine(geom);
        feature.setGeometry(geomInversee);

        wfsLayer.setStyle(styleFunction);
        consumerScope.$broadcast('editProcessUpdated', {
          editprocessawait: true,
        });

        scope.editdescription.editType = 'update';
        scope.editdescription.editedfeature = scope.currentFeature = feature;
        scope.editdescription.fti = fti;
      }
    }

    function supprimer() {
      const feature = wfsLayer.getSource().getFeatureById(fti.feature.getId());
      const geom = feature.getGeometry();
      const geomInversee = EditRulesFeatGeomFactory.inverserLine(geom);
      feature.setGeometry(geomInversee);

      wfsLayer.setStyle(styleFunction);
    }

    function longitudinalProfil(scope) {

      scope.longProfilInput = {
        title: 'Profil en long',
        pc: 50,
        vertScale: 100,
        horizScale: 100,
        textSize: 0.005,
      };

      scope.onSelectNodeId = (position) => {
        gclayers.getselectSource().clear();

        console.log(position);
        console.log(scope.selectTool.res);
        if (scope.selectTool.res.features.length > 0) {
          const selectedFeatures = GEOJSON_PARSER.readFeatures(
            scope.selectTool.res
          );
          const selectedFeature = selectedFeatures[0];
          gclayers.getselectSource().addFeature(selectedFeature);

          const featProperties = selectedFeature.getProperties();
          const idValue = featProperties['id'];

          if (position == 'start') {
            scope.longProfilInput.startId = idValue;
          } else if (position == 'end') {
            scope.longProfilInput.endId = idValue;
          }
        }
      };
      openProfileBuilderForm(scope);
    }

    function openProfileBuilderForm(scope) {
      if (scope.longitudinalProfilFormPopup != undefined) {
        scope.longitudinalProfilFormPopup.close();
      }

      scope.longitudinalProfilFormPopup = extendedNgDialog.open({
        template:
          'js/XG/widgets/mapapp/longitudinalprofile/views/modal.form.html',
        className: 'ngdialog-theme-plain width600 nopadding miniclose',
        closeByDocument: false,
        scope: scope,
        draggable: {
          title: longitudinalProfilFormTitle,
        },
      });
    }

    function launchLongProfilBuild(scope) {
      gclayers.getselectSource().clear();
      const srid = scope.selectTool.map.getView().getProjection().getCode();
      const nodeUids = scope.selectTool.uids.join();
      const cql_filter = 'id = ' + scope.longProfilInput.startId;

      gaDomUtils.showGlobalLoader();

      const promise = ogcFactory.getfeatures(
        'GetFeature',
        'WFS',
        '1.0.0',
        nodeUids,
        'json',
        srid,
        cql_filter
      );
      promise
        .then((res) => {
          if (res.data.features.length != 1) {
            gaDomUtils.hideGlobalLoader();
            require('toastr').error('Noeud de départ non trouvé');
          }
          const selectedFeatures = GEOJSON_PARSER.readFeatures(res.data);
          const selectedFeature = selectedFeatures[0];
          const cql_filter2 = 'id = ' + scope.longProfilInput.endId;

          const promise2 = ogcFactory.getfeatures(
            'GetFeature',
            'WFS',
            '1.0.0',
            nodeUids,
            'json',
            srid,
            cql_filter2
          );
          promise2
            .then((res2) => {
              if (res2.data.features.length != 1) {
                gaDomUtils.hideGlobalLoader();
                require('toastr').error('Noeud de fin non trouvé');
              }
              const selectedFeatures2 = GEOJSON_PARSER.readFeatures(res2.data);
              const selectedFeature2 = selectedFeatures2[0];
              const featID1 = selectedFeature.getId();
              const featIdSplit1 = featID1.split('.');

              if (featIdSplit1.length != 2) {
                gaDomUtils.hideGlobalLoader();
                require('toastr').error('Erreur de syntaxe de l\'ID du noeud de départ');
              }
              const idStart = featIdSplit1[1];
              const layerName = featIdSplit1[0];
              const featID2 = selectedFeature2.getId();
              const featIdSplit2 = featID2.split('.');

              if (featIdSplit2.length != 2) {
                gaDomUtils.hideGlobalLoader();
                require('toastr').error(
                  "Erreur de syntaxe de l'ID du noeud d'arrivée'"
                );
              }
              const idEnd = featIdSplit2[1];

              const longitudinalProfilData = {
                findPathInput: {
                  start: {
                    featureId: idStart,
                    layerName: layerName,
                  },
                  end: {
                    featureId: idEnd,
                    layerName: layerName,
                  },
                },
                fileTile: scope.longProfilInput.title,
                pdc: scope.longProfilInput.pc,
                emitter: scope.longProfilInput.emitter,
                recipient: scope.longProfilInput.recipient,
                localisation: scope.longProfilInput.localisation,
                date: buildDate(scope.longProfilInput.date),
                formatIndex: scope.longProfilInput.format.index,
                verticalScale: scope.longProfilInput.vertScale,
                horizontalScale: scope.longProfilInput.horizScale,
                graduation: 'm',
                textSize: scope.longProfilInput.textSize,
                diameterUnit: scope.longProfilInput.diameterUnit,
                diameterDivider: scope.longProfilInput.diameterDivider,
              };

              //console.log(longitudinalProfilData);

              const promise3 = ASSEditionFactory.buildprofile(
                longitudinalProfilData,
                nodeUids
              );
              promise3
                .then((res3) => {
                  const fileName = res3.data.filename;
                  const portalId = res3.data.portalId;
                  if (fileName.startsWith('EXPORTEDPROFILE')) {
                    const downloadurl =
                      '/services/' +
                      portalId +
                      '/assedition/downloadexportedprofile?f=json' +
                      '&exportedProfileId=' +
                      fileName;
                    window.open(downloadurl);
                  }
                })
                .catch((error) => {
                  require('toastr').error(
                    'Impossible de télécharger le fichier <br>' + error.data
                  );
                })
                .finally(() => {
                  gaDomUtils.hideGlobalLoader();
                });
            })
            .catch((error) => {
              require('toastr').error(
                'Impossible de télécharger le fichier : ' + error
              );
            })
            .finally(() => {
              gaDomUtils.hideGlobalLoader();
            });
        })
        .catch((error) => {
          require('toastr').error(
            'Impossible de télécharger le fichier : ' + error
          );
        })
        .finally(() => {
          gaDomUtils.hideGlobalLoader();
        });
    }

    function buildDate(date) {
      let dd = date.getDate();
      let mm = date.getMonth() + 1;
      if (dd.toString().length == 1) {
        dd = '0' + dd;
      }
      if (mm.toString().length == 1) {
        mm = '0' + mm;
      }
      const yy = date.getFullYear();
      return dd+'/'+mm+'/'+yy
    }

    function init() {
      // To implement later, for loading network configs.
    }


    return {
      dessinerFlux: dessinerFlux,
      effacerFlux: effacerFlux,
      inverser: inverser,
      supprimer: supprimer,
      longitudinalProfil: longitudinalProfil,
      launchLongProfilBuild: launchLongProfilBuild,
    };
  };

  AssEditProcessServices.$inject = [
    'AdvancedEditionFactory',
    'gclayers',
    'FeatureTypeFactory',
    'gcWFS',
    'EditRulesFeatGeomFactory',
    'extendedNgDialog',
    '$translate',
    'gaDomUtils',
    'ogcFactory',
    'ASSEditionFactory',
  ];

  return AssEditProcessServices;
});


define('containers/mod',[
  'angular',

  'containers/directives/collabseMenuDirective',
  'containers/directives/widgetTooltip',
  'containers/directives/draggableDirective',
  'containers/services/gcPopup',
  'containers/directives/verticaltoolbardirective',
  'containers/directives/resizable',
  'containers/directives/resizableModal',
  'containers/directives/kisProcess',
  'containers/directives/kisCalendar',
  'containers/directives/kisCalendarFilters',
  'containers/directives/kisCalendarEvent',
  'containers/directives/kisCalendarRelation',
  'containers/directives/kisAlertBtn',
  'containers/directives/taskManager',
  'containers/services/panelsManager',
  'containers/services/ActionsManager',
  'containers/services/kisCalendarFactory',
  'containers/services/AssEditProcessServices',

  'angular-strap',
  'angular-strap.tpl',
  'angular-route',
  'toastr',
  'ol3js',
  'ng-table',
], function (
  angular,
  CollapseMenu,
  widgetTooltip,
  draggableDirective,
  gcPopup,
  verticaltoolbardirective,
  resizable,
  resizableModal,
  kisProcess,
  kisCalendar,
  kisCalendarFilters,
  kisCalendarEvent,
  kisCalendarRelation,
  kisAlertBtn,
  taskManager,
  panelsManager,
  ActionsManager,
  kisCalendarFactory,
  AssEditProcessServices
) {
  // generation du module
  var gccontainer = angular.module('gc_container', [
    'mgcrea.ngStrap',
    'ngRoute',
    'pascalprecht.translate',
    'model',
  ]);

  gccontainer.provider('panelsManager', panelsManager);
  gccontainer.directive('collapsemenu', CollapseMenu);
  gccontainer.directive('widgetTooltip', widgetTooltip);
  gccontainer.directive('gcPopup', draggableDirective);
  gccontainer.provider('gcPopup', gcPopup);
  gccontainer.directive('gcverticaltoolbar', verticaltoolbardirective);
  gccontainer.directive('resizable', resizable);
  gccontainer.directive('resizableModal', resizableModal);
  gccontainer.directive('kisProcess', kisProcess);
  gccontainer.directive('kisCalendar', kisCalendar);
  gccontainer.directive('kisCalendarFilters', kisCalendarFilters);
  gccontainer.directive('kisCalendarEvent', kisCalendarEvent);
  gccontainer.directive('kisCalendarRelation', kisCalendarRelation);
  gccontainer.directive('kisAlertBtn', kisAlertBtn);
  gccontainer.directive('taskManager', taskManager);
  gccontainer.factory('ActionsManager', ActionsManager);
  gccontainer.factory('kisCalendarFactory', kisCalendarFactory);
  gccontainer.factory('AssEditProcessServices', AssEditProcessServices);

  gccontainer.directive('nghtmlcompile', [
    '$compile',
    '$rootScope',
    'gaJsUtils',
    function ($compile, $rootScope, gaJsUtils) {
      return {
        restrict: 'A',

        link: function (scope, element, attrs) {
          if ($rootScope.loadedWidget == undefined)
            $rootScope.loadedWidget = [];
          let widgetUid;

          scope.$watch(attrs.nghtmlcompile, function (newValue, oldValue) {
            //-- Clef composée du nom du widget concaténé avec le nom de la configuration.
            widgetUid = newValue + '_' + scope.tool.config;
            if ($rootScope.loadedWidget[widgetUid] == undefined) {
              var templateScope = scope.$parent.$new();
              templateScope.map = scope.$parent.map;
              templateScope.ConfigName = scope.tool.config;
              templateScope.toolBarWidget = scope.tool;
              templateScope.panelsManager = scope.$parent.panelsManager;
              templateScope.mode = scope.$parent.mode;
              templateScope.contextMenu = gaJsUtils.getMenuOptions(scope);
              $rootScope.loadedWidget[widgetUid] = templateScope;
            }
            element.html('<div ' + newValue + '></div>');

            $compile(element.contents())($rootScope.loadedWidget[widgetUid]);
          });
          scope.$on('$destroy', function () {

            // KIS-3353: l’utilisateur doit pouvoir garder la popup du widget quand la catégorie se ferme
            // pour utiliser d’autres widgets en parallèle : geocatalog, localisation
            let activeWidgetName = null;
            const isPopupShown = document.querySelector('.ngdialog');
            if (isPopupShown) {
              const leftMapPanel = document.getElementById('map_aside');
              if (leftMapPanel) {
                const currentTool = leftMapPanel.querySelector('#tool.active');
                if (currentTool) {
                  activeWidgetName = currentTool.firstElementChild.id;
                }
              }
            }

            // KIS-3353: le widget actif n'est pas destroy si une popup est affichée
            if (widgetUid && scope.tool.name !== activeWidgetName) {
              $rootScope.loadedWidget[widgetUid].$destroy();
              delete $rootScope.loadedWidget[widgetUid];
            }
          });
        },
      };
    },
  ]);

  gccontainer.directive('popupbody', function () {
    return {
      restrict: 'A',
      link: function (scope, element, attrs) {},
      templateUrl: function (elem, attrs) {
        return attrs.popupbody || 'some/path/default.html';
      },
    };
  });

  gccontainer.directive('gaDraggable', [
    '$document',
    'gaBrowserSniffer',
    function ($document, gaBrowserSniffer) {
      return {
        restrict: 'A',
        scope: {
          dragPopup: '=?',
        },
        link: link,
      };

      function link(scope, element, attr) {
        var startX = 0,
          startY = 0,
          x = null,
          y = null;
        var eventKey = gaBrowserSniffer.events;
        var regex = /^(input|textarea|a|button)$/i;

        // Firefox doesn't like transition during drag
        element.addClass('ga-draggable');
        element.css({ position: 'absolute' });

        var dragZone = element.find(attr['gaDraggableZone']);

        if (!dragZone || dragZone.length == 0) {
          dragZone = element;
        }

        dragZone.addClass('ga-draggable-zone');

        dragZone.bind(eventKey.start, function (evt) {
          // If the class has disappeared that means draggable is not allow
          // temporarly.
          if (!dragZone.hasClass('ga-draggable-zone')) {
            return;
          }

          x = element.prop('offsetLeft');
          y = element.prop('offsetTop');

          let dragActive =
            element[0].getAttribute('drag-active') === 'true' ||
            element[0].getAttribute('drag-active') === null;

          if (dragActive) {
            startX = getMouseEventX(evt) - x;
            startY = getMouseEventY(evt) - y;
            $document.bind(eventKey.move, drag);
            $document.bind(eventKey.end, dragend);
          }
        });

        function drag(evt) {
          x = getMouseEventX(evt) - startX;
          y = getMouseEventY(evt) - startY;
          
          scope.dragPopup(element, x, y);

          // block default interaction
          if (!regex.test(evt.target.nodeName)) {
            evt.preventDefault();
          }
        }

        function dragend(evt) {
          $document.unbind(eventKey.move, drag);
          $document.unbind(eventKey.end, dragend);

          // block default interaction
          if (!regex.test(evt.target.nodeName)) {
            evt.preventDefault();
          }
        }

        /* Utils */

        // RE3: Get the X coordinate of a mouse or a touch event
        var getMouseEventX = function (event) {
          if (event.originalEvent) {
            event = event.originalEvent;
          }
          return angular.isNumber(event.clientX)
            ? event.clientX
            : event.touches[0].clientX;
        };

        // RE3: Get the Y coordinate of a mouse or touch event
        var getMouseEventY = function (event) {
          if (event.originalEvent) {
            event = event.originalEvent;
          }
          return angular.isNumber(event.clientY)
            ? event.clientY
            : event.touches[0].clientY;
        };
      }
    },
  ]);

  return gccontainer;
});



define('modules/configuration/constant/configuration',[],function() {
  return {
    standardAngularModules: [
      // **************************************************************************************************
      // PLEASE ORDER THOSE  IN THE SAME ORDER AS IN js/XG/main.js
      // Or it becomes really hard to debug dependencies problems
      // **************************************************************************************************

      //CONTAINER
      'gc_container',
      //CORE
      'configuration',
      'common',
      'export',
      'geometry',
      'googlemaps',
      'query',
      'config',
      'decoupadmin',
      'edit',
      'gc_report',
      'gc_maphistoric',
      'gc_featureattachment',
      'gc_filesf',
      'arcgis',
      'authentication',
      'licence',
      'home',
      'translation',
      'portals',
      'rootdebug',
      'logtracker',
      'dolibarr',
      'rights',
      'model',
      'tools',
      'applications',
      'parameters',
      'gc_graticules',
      'majic',
      'style',
      'interfaces',
      'ogc',
      'odk',
      'process',
      'tmh.dynamicLocale',

      'function',

      //UTILITIES
      'modelutilities',
      'editutilities',
      'datautilities',
      'selectutilities',
      'formutilities',
      'htmlutilities',
      'reportutilities',
      'componentutilities',
      'configutilities',
      'networkutilities',
      'calendarutilities',
      'calcexpressionutilities',
      'chartutilities',
      'elasticutilities',
      'numberInputWithTextValue',
      'itvTool',
      'gc_dbparaminfo',
      'relationutilities',
      'associationsutilities',
      'encodingutilities',
      //MAP APP
      'gcMain',
      'gc_majic',
      'gc_config',
      'gc_geolocation',
      'gc_measure',
      'gc_map_logo',
      'gc_selectiontools',
      //"gc_mapmodel",
      'gc_layermanager',
      'gc_mouseposition',
      'gc_scalevalue',
      'gc_map',
      'gc_scaleline',
      'gc_style_service',
      'gc_importwms',
      'gc_importwfs',
      'gc_meteo',
      'gc_selectmanager',
      'gc_selecttool',
      'gc_selecttool_bypoint',
      'gc_extract_coordinates',
      'gc_selecttool_bypointutilities',
      'gc_selecttool_bypolygon',
      'gc_selecttool_byline',
      'gc_selecttoolbuffer',
      'gc_printv2',
      'gc_atlas',
      'gc_exportgeopackage',
      'gc_importexportmbtiles',
      // "gc_cesium",
      'gc_streetview',
      'gc_toolbargeocoderreverse',
      'gc_toolbargeocoderreversew3w',
      'gc_style',
      'gc_directions',
      'gc_elevation',
      'gc_basemap',
      'gc_position',
      'gc_what3words',
      'gc_executequery',
      'gc_getwmswfs',
      'gc_bizedition',
      'gc_exportmap',
      'gc_exportmapsvg',
      'gc_geosignet',
      'gc_versionlib',
      'gc_geotreatment',
      'gc_quickpopup',
      /* "gc_wflow",*/
      'gc_dynamicstyle',
      'gc_esriprint',
      'gc_esrisymbolstyle',
      'gc_urlsharing',
      'gc_csvgeocoder',
      'gc_majic',
      'gc_query',
      'gc_selectfeaturetree',
      'gc_geolocalisation',
      'gc_localisationMultiLevel',
      'gc_importexport',
      'gc_importdxf',
      'gc_importgpx',
      'gc_importxlsx',
      'gc_importTransferLayer',
      'gc_exportxlsx',
      'gc_importdivers',
      'gc_indigauwidget',
      'gc_mapcatalog',
      'gc_dictwidget',
      'gc_networkwidget',
      'gc_statistique',
      //"gc_itvwidget",
      'gc_itv',
      'gc_simpleinterv',
      'gc_legend',
      'gc_staticimage',
      'gc_longitudinalprofile',
      'gc_takephoto',
      'gc_annotations',
      'gc_map_annotations',
      'gc_defaultfilters',
      'gc_quickfilter',
      'gc_quickquery',
      'gc_dashboard',
      'gc_tabledata',
      'gc_overview',
      'gc_statistique',
      'gc_customforms',
      'gc_intervflow',
      'gcaboutwidget',
      'featureattachmentwidgetmod',
      'gc_maphistoric',
      'gc_elasticsearch',
      'gc_raster',
      'gc_importdwg',
      'gc_importdocuments',
      'gc_operis',
      'gc_biztopology',
      'gc_importgpkg',

      //AEP
      'eaupotable',
      'gc_aepInt',

      // TIERCES
      'gc_tierce',

      // YAMOUSSOUKRO @jenkins_remove1

      // 'gcesendmailservices',
      // 'gc_globalservices',
      // 'gc_day_cherchermodsup',
      // 'gc_day_cherchermodsup2',
      // 'gc_day_chercherconsult',
      // 'gc_day_searchresult',
      // 'gc_formfield',
      // 'gc_intervalfield',
      // 'gc_containercontainer',
      // 'gc_objlistcontainer',
      // 'gc_ffl2',
      // 'gc_ffpl2',
      // 'gc_ffgl2',
      // 'gc_fftablel2',
      // 'gc_fftable4updl2',
      // 'gc_ffl2attachment',
      // 'gc_relationformfield',
      // 'gc_relationformfieldl2',
      // 'gc_reportfield',
      // 'gc_formfieldgroup',
      // 'gc_formfieldpanel',
      // 'gc_stepcontainer',
      // 'gc_tabcontainer',
      // 'gc_applyprocedure',
      // 'gc_units',
      // 'gc_geometryfield',
      // 'gc_indicateurmgt',
      // 'gc_day_editobjectwidget',
      // 'gc_day_typeprojet',
      // 'gc_day_choixprogramme',
      // 'gc_sendmailfield',
      // 'gc_iframe',

      // YAMOUSSOUKRO @jenkins_remove2

      /**
       * HPO
       */
      'gcMainHpoHomeAdminData',
      'gcMainHpoModel',
      'gcMainHpoAnalyseMulticritere',
      'gcMainHpoChantiers',
      'gcMainHpo',

      /**
       * Carte V2
       */
      'gcMainCarteHomeAdminData',
      'gcMainMapV2',

      // TOOLS
      'ga_urlutils_service',
      'ga_browsersniffer_service',
      'ga_jsutils_service',
      'ga_domutils_service',
      'ga_jsgeneral_factory',
      'gc_directives_list',
      'gc_tiercefunctions_service',
      'gc_restriction_provider',
      'statsaffaire',
      'gc_save_get_templates',
      'mapJsUtils_service',
      // **************************************************************************************************
      // **************************************************************************************************

      //FORM APP
      'gcFormMain',
      //SIROCO APP
      'gcSirocoMain',
      'siroco_init',
      'siroco_export',
      // ANC APP
      'gcAncMain',
      // BAC APP
      'gcBacMain',
      'gcAncBacCommon',
      //INDIGAU APP
      'gcIndigauMain',
      // angular
      'ngRoute',
      'ngResource',
      'ngCookies',
      'ngSanitize',
      'ui-rangeSlider',
      'textAngular',
      'textAngularSetup',

      'print',
      // vendor
      'pascalprecht.translate',
      'mgcrea.ngStrap',
      'ngTable',
      'ngCsv',
      'ngAnimate',
      'validator',
      'builder',
      //"ngTouch",
      'ngDialog',
      'toggle-switch',
      'angularBootstrapNavTree',
      'ngBonita',
      'ngProgress',
      'cfp.hotkeys',
      //"w11k.flash",
      //'w11k.flash.template',
      'dndLists',
      // remove it when we use only ...
      'ui.rCalendar.tpls',
      'ui.rCalendar',
      // .... this one
      'ui.calendar',
      'ui.bootstrap.contextMenu',
      'mdChips',
      '720kb.socialshare',
      'angular-bind-html-compile',
      'angular-jsoneditor',
      'ui.select',
      'angularjs-dropdown-multiselect',
      // 'dndLists'
    ],
    standardAngularModulesKisMobileAnc: [
      // **************************************************************************************************
      // PLEASE ORDER THOSE  IN THE SAME ORDER AS IN js/XG/main.js
      // Or it becomes really hard to debug dependencies problems
      // **************************************************************************************************

      //CONTAINER
      'gc_container',
      //CORE
      'configuration',
      'common',
      'export',
      'geometry',
      'googlemaps',
      'query',
      'config',
      'edit',
      'gc_report',
      'gc_maphistoric',
      'gc_featureattachment',
      'gc_filesf',
      'authentication',
      'home',
      'licence',
      'translation',
      'portals',
      'rootdebug',
      'logtracker',
      'rights',
      'model',
      'tools',
      'applications',
      'parameters',
      'gc_graticules',
      'majic',
      'style',
      'interfaces',
      'ogc',
      'odk',
      'process',
      'tmh.dynamicLocale',

      'function',

      //UTILITIES
      'modelutilities',
      'editutilities',
      'datautilities',
      'selectutilities',
      'formutilities',
      'htmlutilities',
      'reportutilities',
      'componentutilities',
      'configutilities',
      'networkutilities',
      'calendarutilities',
      'calcexpressionutilities',
      //'chartutilities',
      'elasticutilities',
      //'itvTool',
      //MAP APP
      'gcMain',
      'gc_majic',
      'gc_config',
      'gc_geolocation',
      'gc_measure',
      'gc_map_logo',
      'gc_layermanager',
      'gc_scalevalue',
      'gc_mouseposition',
      'gc_map',
      'gc_scaleline',
      'gc_style_service',
      'gc_importwms',
      'gc_importwfs',
      'gc_meteo',
      'gc_selectmanager',
      'gc_selecttool',
      'gc_selecttool_bypoint',
      'gc_extract_coordinates',
      'gc_selecttool_bypointutilities',
      'gc_selecttool_bypolygon',
      'gc_selecttool_byline',
      'gc_selecttoolbuffer',
      'gc_printv2',
      'gc_atlas',
      //"gc_exportgeopackage",
      'gc_importexportmbtiles',
      // "gc_cesium",
      'gc_streetview',
      'gc_toolbargeocoderreverse',
      'gc_style',
      'gc_directions',
      'gc_elevation',
      'gc_basemap',
      'gc_position',
      'gc_what3words',
      'gc_getwmswfs',
      'gc_bizedition',
      'gc_exportmap',
      'gc_exportmapsvg',
      'gc_geosignet',
      'gc_versionlib',
      'gc_geotreatment',
      'gc_quickpopup',
      /* "gc_wflow",*/
      'gc_dynamicstyle',
      'gc_esriprint',
      'gc_esrisymbolstyle',
      'gc_urlsharing',
      'gc_csvgeocoder',
      'gc_majic',
      'gc_query',
      'gc_selectfeaturetree',
      'gc_geolocalisation',
      'gc_localisationMultiLevel',
      'gc_importexport',
      'gc_importTransferLayer',
      'gc_importdxf',
      'gc_importgpx',
      'gc_importxlsx',
      'gc_exportxlsx',
      'gc_importdivers',
      'gc_mapcatalog',
      'gc_dictwidget',
      'gc_networkwidget',
      'gc_statistique',
      //"gc_itvwidget",
      //"gc_itv",
      'gc_simpleinterv',
      'gc_legend',
      'gc_staticimage',
      'gc_longitudinalprofile',
      'gc_takephoto',
      'gc_annotations',
      'gc_map_annotations',
      'gc_defaultfilters',
      'gc_quickfilter',
      'gc_quickquery',
      'gc_dashboard',
      'gc_tabledata',
      'gc_overview',
      'gc_statistique',
      'gc_customforms',
      'gc_intervflow',
      'gcaboutwidget',
      'featureattachmentwidgetmod',
      'gc_maphistoric',
      'gc_elasticsearch',
      'gc_raster',
      'gc_importdwg',
      'gc_importdocuments',
      'gc_operis',
      'gc_biztopology',
      'gc_importgpkg',

      //AEP
      'eaupotable',
      'gc_aepInt',

      'gc_tierce',
      'anc',

      // TOOLS
      'ga_urlutils_service',
      'ga_browsersniffer_service',
      'ga_jsutils_service',
      'ga_domutils_service',
      'ga_jsgeneral_factory',
      'gc_directives_list',
      'gc_tiercefunctions_service',
      'gc_restriction_provider',
      'mapJsUtils_service',
      //"statsaffaire",
      // **************************************************************************************************
      // **************************************************************************************************

      //FORM APP
      //"gcFormMain",
      //SIROCO APP
      /*"gcSirocoMain",
            "siroco_init",
            "siroco_export",*/
      // ANC APP
      'gcAncMain',
      // BAC APP
      'gcBacMain',
      'gcAncBacCommon',
      // angular
      'ngRoute',
      'ngResource',
      'ngCookies',
      'ngSanitize',
      'ui-rangeSlider',
      'textAngular',
      'textAngularSetup',

      'print',
      // vendor
      'pascalprecht.translate',
      'mgcrea.ngStrap',
      'ngTable',
      'ngCsv',
      'ngAnimate',
      'validator',
      'builder',
      //"ngTouch",
      'ngDialog',
      'toggle-switch',
      'angularBootstrapNavTree',
      'ngBonita',
      'ngProgress',
      'cfp.hotkeys',
      //"w11k.flash",
      //'w11k.flash.template',
      'dndLists',
      // remove it when we use only ...
      'ui.rCalendar.tpls',
      'ui.rCalendar',
      // .... this one
      'ui.calendar',
      'ui.bootstrap.contextMenu',
      'mdChips',
      '720kb.socialshare',
      'angular-bind-html-compile',
    ],
    system: 'dev',
  };
});


/**
 * @ngdoc overview
 * @name modules.config
 * @description
 * config module
 */
define('modules/configuration/mod',['angular', 'modules/configuration/constant/configuration'], function(
  angular,
  configuration
) {
  var config = angular.module('configuration', []);
  //config.constant("config", configuration);

  return configuration;
});



define('modules/common/controllers/MainCtrl',[],function() {
  /*
   * MainCtrl
   */
  var MainCtrl = function($scope) {};

  MainCtrl.$inject = ['$scope'];
  return MainCtrl;
});



define('modules/common/controllers/NavigationCtrl',[],function() {
  /*
   * NavigationCtrl
   */
  var NavigationCtrl = function(
    $scope,
    $location,
    PortalsFactory,
    gaJsUtils,
    $rootScope
  ) {
    /*
         Navbar groups definition
         */
    var visibilityList = function(menu) {
      var visibilityList = $rootScope.xgos.portal.parameters.visibilityList;
      if (angular.isDefined(visibilityList) && visibilityList.length > 0) {
        if (JSON.parse(visibilityList).indexOf(menu) != -1) {
          return false;
        }
      }
      return true;
    };
    $scope.rightsNavigation = {
      main_title: 'rights.title',
      icon: 'user',
      subs: [
        {
          label: 'rights.users.title',
          icon: 'users',
          target: 'users',
          visible: visibilityList('users'),
        },
        {
          label: 'rights.groups.title',
          icon: 'th-list',
          target: 'groups',
          visible: visibilityList('groups'),
        },
        {
          label: 'rights.roles.title',
          icon: 'list',
          target: 'roles',
          visible: visibilityList('roles'),
        },
        {
          label: 'rights.restriction.title',
          icon: 'ban',
          target: 'restrictions',
          visible:
            visibilityList('restrictions') && $rootScope.xgos.isadmin
        },
        {
          label: 'rights.extra_authentication.title',
          icon: 'user-plus',
          target: 'extra_authentication',
          visible:
            visibilityList('extra_authentication') &&
            gaJsUtils.checkNestedProperty(
              'portal.parameters.extra_authentication.active',
              $scope.xgos
            ) !== false,
        },
      ],
    };

    $scope.modelNavigation = {
      main_title: 'model.main',
      icon: 'hdd',
      subs: [
        {
          label: 'model.datastores.title',
          icon: 'database',
          target: 'datasources',
          visible: visibilityList('datasources'),
        },
        {
          label: 'model.featuretypes.title',
          icon: 'cube',
          target: 'features',
          visible: visibilityList('features'),
        },
        {
          label: 'model.association.title',
          icon: 'arrows-h',
          target: 'association',
          visible: visibilityList('association'),
        },
        {
          label: 'model.objectFiles.title',
          icon: 'clipboard',
          target: 'objectFiles',
          visible: visibilityList('objectFiles'),
        },
        {
          label: 'model.basemap.title',
          icon: 'square-o',
          target: 'basemap',
          visible: visibilityList('basemap'),
        },
        {
          label: 'model.units.title',
          icon: 'list',
          target: 'units',
          visible: visibilityList('units'),
        },
        {
          label: 'model.styles.title',
          icon: 'eye',
          target: 'style',
          visible: visibilityList('style'),
        },
        {
          label: 'model.network.title',
          icon: 'crop',
          target: 'networks',
          visible: visibilityList('networks'),
        },
      ],
    };

    $scope.toolsNavigation = {
      main_title: 'tools.main',
      icon: 'wrench',
      subs: [
        {
          label: 'tools.builder.title',
          icon: 'clipboard',
          target: 'builder',
          visible: visibilityList('builder'),
        },
        {
          label: 'tools.document.title',
          icon: 'pencil',
          target: 'documents',
          visible: visibilityList('documents'),
        },
        {
          label: 'tools.reports.title',
          icon: 'pencil',
          target: 'reports',
          visible: visibilityList('reports'),
        },
        {
          label: 'tools.actions.title',
          icon: 'pencil',
          target: 'actions',
          visible: visibilityList('actions'),
        },
        {
          label: 'tools.calendar.title',
          icon: 'calendar',
          target: 'calendar',
          visible:
            visibilityList('calendar') &&
            gaJsUtils.checkNestedProperty(
              'portal.parameters.calendar.active',
              $scope.xgos
            ) !== false,
        },
        {
          label: 'tools.tracker.title',
          icon: 'line-chart',
          target: 'tracker',
          visible:
            visibilityList('tracker') &&
            gaJsUtils.checkNestedProperty(
              'portal.parameters.log_tracker_active',
              $scope.xgos
            ) !== false,
        },
        {
          label: 'applications.print.title',
          icon: 'print',
          target: 'printmodel',
          visible: visibilityList('printmodel'),
        },
        {
          label: 'tools.atlas.title',
          icon: 'print',
          target: 'atlas',
          visible: visibilityList('atlas'),
        },
        {
          label: 'tools.majicedigeo.title',
          icon: 'upload',
          target: 'majicedigeo',
          visible: visibilityList('majicedigeo'),
        },
        {
          label: 'tools.portal_monitoring.title',
          icon: 'line-chart',
          target: 'portal_monitoring',
          visible:
            visibilityList('portal_monitoring') &&
            gaJsUtils.checkNestedProperty(
              'portal.parameters.portal_monitoring.active',
              $scope.xgos
            ) !== false,
        }
      ],
    };

    $scope.applicationNavigation = {
      main_title: 'applications.main',
      icon: 'picture',
      subs: [
        {
          label: 'applications.main',
          icon: 'cubes',
          target: 'applications',
          visible: visibilityList('applications'),
        },
        {
          label: 'applications.parameters.title',
          icon: 'cogs',
          target: 'parameters',
          visible: visibilityList('parameters'),
        },
      ],
    };

    $scope.mobileNavigation = {
      main_title: 'mobile.main',
      icon: 'picture',
      subs: [
        {
          label: 'mobile.form.main',
          icon: 'pencil',
          target: 'phonesform',
          visible: visibilityList('phonesform'),
        },
        {
          label: 'mobile.form_intervention.main',
          icon: 'pencil',
          target: 'phonesformintervention',
          visible: visibilityList('phonesformintervention'),
        },
        {
          label: 'mobile.phone.title',
          icon: 'mobile',
          target: 'imei',
          visible: visibilityList('imei'),
        },
      ],
    };

    $scope.licenceNavigation = {
      main_title: 'licence.main',
      icon: 'picture',
      subs: [
        {
          label: 'licence.main',
          icon: 'info',
          target: 'licence',
          visible: visibilityList('licence'),
        },
      ],
    };

    $scope.processNavigation = {
      main_title: 'process.main',
      icon: 'book',
      subs: [
        {
          label: 'process.mbtiles.main',
          icon: 'file-picture-o',
          target: 'process',
          visible: visibilityList('process'),
        },
        {
          label: 'process.geopackage.main',
          icon: 'file-picture-o',
          target: 'geopackage',
          visible: visibilityList('geopackage'),
        },
        /**
         *
         * Geopackage fait pas partie du roadmap RC 1-1-0
         */
        {
          label: 'process.docxprocess.main',
          icon: 'file-word-o',
          target: 'docxprocess',
          visible: visibilityList('docxprocess'),
        },
      ],
    };

    $scope.rootNavigation = {
      main_title: 'root.main',
      icon: 'wrench',
      subs: [
        {
          label: 'root.confguration.main',
          icon: 'file-o',
          target: 'configuration',
          visible: visibilityList('configuration'),
        },
        {
          label: 'root.logs.main',
          icon: 'file-o',
          target: 'logs',
          visible: visibilityList('logs'),
        },
        {
          label: 'tools.checkUp.title',
          icon: 'check',
          target: 'checkUp',
          visible: visibilityList('checkUp'),
        },
      ],
    };

    /**
     * Returns if the current page is the one selected in the nav bar
     *
     * @param path
     * @returns {boolean}
     */
    $scope.isCurrentPath = function(path) {
      if (typeof path == 'string') {
        return $location.path() == path;
      } else {
        return path.indexOf($location.path()) !== -1;
      }
    };
  };

  NavigationCtrl.$inject = [
    '$scope',
    '$location',
    'PortalsFactory',
    'gaJsUtils',
    '$rootScope',
  ];
  return NavigationCtrl;
});



define('modules/common/controllers/CalendarInviteCtrl',[],function() {
  /*
   * CalendarInviteCtrl
   */
  var CalendarInviteCtrl = function(
    $scope,
    CalendarFactory,
    ngDialog,
    $rootScope
  ) {
    /**
     * refrsh
     */
    var refresh = function() {
      CalendarFactory.getinvitedevents().then(function(res) {
        $scope.invitedevents = res.data;
      });
    };
    refresh();

    /**
     * set Event User Status
     * @param event
     * @param type
     */
    $scope.setEventUserStatus = function(event, type) {
      CalendarFactory.seteventuserstatus('', event.id, type).then(function(
        res
      ) {
        console.log(res.data);
        refresh();
      });
    };

    var dialogEvent;

    $scope.edit = function(event) {
      $scope.currentEvent = event;
      dialogEvent = ngDialog.open({
        template:
          'js/XG/modules/common/views/directives/modal.calendar.event.html',
        className: 'ngdialog-theme-plain width1000 miniclose nopadding',
        closeByDocument: false,
        scope: $scope,
      });
    };

    $rootScope.$on('closeEventModal', function() {
      if (dialogEvent) dialogEvent.close();
    });
  };

  CalendarInviteCtrl.$inject = [
    '$scope',
    'CalendarFactory',
    'ngDialog',
    '$rootScope',
  ];
  return CalendarInviteCtrl;
});



define('modules/common/controllers/listesDeroulantesCtrl',['toastr','toastr','toastr','toastr','toastr','toastr','toastr','toastr','toastr','toastr'],function() {
  var listesDeroulantesCtrl = function(
    $scope,
    FeatureTypeFactory,
    AncAppFactory,
    ngDialog,
    gaDomUtils,
    ParametersFactory,
    $q,
    $rootScope,
    gaJsUtils,
    BacAppFactory
  ) {
    var CurrentAppFactory = $rootScope.xgos.sector == 'bac' ? BacAppFactory : AncAppFactory;
    $scope.listeTabs = { activeTab: 0 };
    $scope.listeDeroulantesTabsMap =
      $scope.listesDeroulantesTab.childrenTabsNames;

    $scope.resetAllVariables = () => {
      $scope.elements = [];
      $scope.listesDeroulantesData = [];
      $scope.listesDeroulantesAttributes = [];
      $scope.selectedAttribute = { model: [] };
      $scope.elementFilter = {};
      $scope.valuesFilter = null;
      $scope.modalEditRestrictValue = null;
      $scope.newValueModel = { name: '' };
      $scope.selectedElement = { model: null };
      $scope.selectedElementValues = [];
      $scope.editingItemsInProgress = {};
      $scope.usage = {};
    };

    $scope.$watch('listeTabs.activeTab', (newTab, oldTab) => {
      $scope.activeTab = $scope.listeDeroulantesTabsMap[newTab];
      $scope.resetAllVariables();

      $scope.featuresToShow = $scope.listeDeroulantesSources[$scope.activeTab];
      $scope.selectedFeature = {
        model: $scope.featuresToShow[0],
      };

      $scope.elements = $scope.selectedFeature.model.value;
      $scope.getElementsData();
    });

    $scope.onFeatureChange = selectedFeature => {
      $scope.resetAllVariables();
      $scope.elements = selectedFeature.model.value;
      $scope.getElementsData();
    };

    $scope.getElementsData = () => {
      for (let index = 0; index < $scope.elements.length; index++) {
        let listeData = FeatureTypeFactory.getFeatureByUid(
          $scope.elements[index]
        );
        $scope.listesDeroulantesData.push(listeData);
      }
    };

    $scope.setAttributes = selectedElement => {
      $scope.listesDeroulantesAttributes = [];
      $scope.selectedElement.model = selectedElement;
      let allAttributes = [];

      if (selectedElement[0].name === 'kis_anc_vidange') {
        allAttributes = selectedElement[0].attributes.filter(
          attribute => attribute.name === 'destination_matieres'
        );
      } else {
        allAttributes = selectedElement[0].attributes.filter(
          attribute => attribute.name !== 'civilite'
        );
      }

      allAttributes = $scope.excludeKisANCMicrostationAttributes(allAttributes);
      allAttributes = $scope.excludeSpecialAttributes(allAttributes);
      allAttributes = $scope.excludeRadioValues(allAttributes);
      $scope.listesDeroulantesAttributes = $scope.excludeValuesWithoutDomainRestriction(
        allAttributes
      );
      $scope.addExtraInformationForDuplicatedValues($scope.listesDeroulantesAttributes);
    };

    $scope.excludeSpecialAttributes = attributes => {
      let attributesToExclude = [];

      if ($rootScope.xgos.sector === 'bac'){
         attributesToExclude = [
          'collecte_eau',
          'conclusion_sondage_1',
          'conclusion_sondage_2',
          'conclusion_sondage_3',
          'destination_eaux_pluviales',
          'destination_eau',
          'dysfonctionnement',
          'defaut_structure',
          'entretien_usure',
          'origine_effluent',
          'pente_terrain',
          'pedologie_nature_1',
          'pedologie_nature_2',
          'pedologie_nature_3',
          'pedologie_nature_4',
          'pedologie_profondeur_1',
          'pedologie_profondeur_2',
          'pedologie_profondeur_3',
          'pedologie_profondeur_4',
          'pedologie_profondeur_5',
          'pedologie_profondeur_6',
          'pedologie_profondeur_7',
          'type_zonage',
        ];
      }
      return attributes.filter(
        attribute => attributesToExclude.indexOf(attribute.name) === -1
      );
    };

    $scope.excludeKisANCMicrostationAttributes = attributes => {
      let attributesToExclude = ['ctrlbf', 'ctrlbc', 'ctrlbe'];

      return attributes.filter(attribute => {
        let startingName = attribute.name.split('_')[0];
        return attributesToExclude.indexOf(startingName) === -1;
      });
    };

    $scope.excludeRadioValues = attributes => {
      return attributes.filter(attribute => {
        if (attribute.restrictions.length) {
          let attributeRestrictions = attribute.restrictions[0];

          if (
            attributeRestrictions.type === 'Domain' &&
            attributeRestrictions.listofValues
          ) {
            let attributeValues = Object.values(
              attributeRestrictions.listofValues
            );
            let radioValues =
              attributeValues.indexOf('Oui') !== -1 &&
              attributeValues.indexOf('Non') !== -1 &&
              attributeValues.indexOf('?') !== -1;

            return !(attributeValues.length === 3 && radioValues);
          } else {
            return true;
          }
        } else {
          return true;
        }
      });
    };

    $scope.excludeValuesWithoutDomainRestriction = allAttributes => {
      return allAttributes.filter(attribute => {
        if (!attribute.restrictions[0]) {
          return false;
        }

        return attribute.restrictions[0].type === 'Domain';
      });
    };

    $scope.addExtraInformationForDuplicatedValues = (attributes) => {
      let attributesToChange = [];
      attributes.forEach(attribute => {
        let duplicateIndex = attributes.findIndex(
            (element) => element !== attribute && element.alias
                === attribute.alias);
        if (duplicateIndex >= 0) {
          attributesToChange.push(attribute);
        }
      });
      attributesToChange.forEach(
          attribute => attribute.alias = attribute.alias + ' ('
              + attribute.name.substring(0, attribute.name.indexOf('_')) + ')');
    };

    $scope.setAttributeValues = selectedAttribute => {
      $scope.selectedAttributesValues = [];
      $scope.selectedAttribute.model = selectedAttribute;

      if(
          selectedAttribute[0] !== undefined &&
          selectedAttribute[0].restrictions[0] !== undefined
      ){
        for (let property in selectedAttribute[0].restrictions[0].listofValues) {
          if (
              selectedAttribute[0].restrictions[0].listofValues.hasOwnProperty(
                  property
              )
          ) {
            let currentValue =
                selectedAttribute[0].restrictions[0].listofValues[property];
            $scope.selectedAttributesValues.push({
              name: currentValue,
              key: property,
            });
          }
        }
      }
      $scope.getValuesUsage(selectedAttribute);
    };

    $scope.isEditMode = value => {
      return $scope.editingItemsInProgress[value];
    };

    $scope.addToEditing = value => {
      $scope.editingItemsInProgress[value] = true;
    };

    $scope.cancelEdit = (value, index) => {
      let previousAttributeValues =
        $scope.selectedAttribute.model[0].restrictions[0].listofValues;
      $scope.selectedAttributesValues[index].name =
        previousAttributeValues[value.key];

      delete $scope.editingItemsInProgress[value.key];
    };

    $scope.saveEditedValue = (value, index) => {
      if (!value.name.length) {
        require('toastr').error('Valeur manquante');
        return;
      }

      let alreadyExists = false;
      let selectedAttributeValues =
        $scope.selectedAttribute.model[0].restrictions[0].listofValues;

      for (let property in selectedAttributeValues) {
        if (selectedAttributeValues.hasOwnProperty(property)) {
          let currentValue = selectedAttributeValues[property];
          if (value.name === currentValue && value.key !== property) {
            alreadyExists = true;
            value.name = currentValue;
            break;
          }
        }
      }

      if (alreadyExists) {
        require('toastr').error('La valeur introduite existe déjà');
      } else {
        selectedAttributeValues[value.key] =
          $scope.selectedAttributesValues[index].name;
        $scope.performSave('Valeur changée').then(() => {
          $rootScope.$broadcast('modelValueChanged');
          delete $scope.editingItemsInProgress[value.key];
        });
      }
    };

    $scope.getValuesUsage = selectedAttribute => {
      let element = $scope.selectedElement.model[0].name;
      if(selectedAttribute[0] !== undefined){
        CurrentAppFactory.checkrestrictiononcomponent(
            element,
            selectedAttribute[0].name
        ).then(response => {
          let valuesUsage = response.data;
          let currentValues =
              $scope.selectedAttribute.model[0].restrictions[0].listofValues;

          for (let index in currentValues) {
            if (valuesUsage[index]) {
              $scope.usage[index] = valuesUsage[index];
            } else {
              $scope.usage[index] = 0;
            }
          }
        });
      }

    };

    $scope.addValueToFeature = valueToAdd => {
      if (!valueToAdd.length) {
        require('toastr').error('Valeur manquante');
        return;
      }

      let alreadyExists = false;
      let restrictions = $scope.selectedAttribute.model[0].restrictions;
      let selectedAttributesValues;

      if (!restrictions[0].listofValues) {
        restrictions[0].listofValues = {};
      }

      selectedAttributesValues = angular.copy(restrictions[0].listofValues);

      for (let property in selectedAttributesValues) {
        let currentValue = selectedAttributesValues[property];

        if (valueToAdd === currentValue) {
          alreadyExists = true;
          break;
        }
      }

      if (alreadyExists) {
        require('toastr').error('La valeur introduite existe déjà');
      } else {
        $scope.addKeyAndValue(selectedAttributesValues, valueToAdd);

        $scope.performSave('Valeur ajoutée').then(() => {
          $rootScope.$broadcast('modelValueChanged');
          $scope.setAttributeValues($scope.selectedAttribute.model);
          $scope.newValueModel.name = '';
        });
      }
    };

    $scope.addKeyAndValue = (selectedAttributesValues, valueToAdd) => {
      let keyToAdd = generateUniqueId();
      selectedAttributesValues[keyToAdd] = valueToAdd;
      $scope.selectedAttribute.model[0].restrictions[0].listofValues = selectedAttributesValues;
    };

    function generateUniqueId() {
      const date = new Date();
      const random = Math.floor(Math.random() * 1000);
      return date.getTime() + '' + random;
    }

    $scope.performSave = successMessage => {
      let deferred = $q.defer();

      FeatureTypeFactory.update($scope.selectedElement.model[0]).then(() => {
        require('toastr').success(successMessage);
        ParametersFactory.publish($scope.selectedElement.model[0].uid).then(
          () => {
            require('toastr').success('Composant mis à jour');
            deferred.resolve();
          }
        );
      });

      return deferred.promise;
    };

    $scope.prepareValuesToRemove = (value, index) => {
      $scope.listOfValues = angular.copy($scope.selectedAttributesValues);
      $scope.listOfValues.splice(index, 1);

      let valueToRemove = {
        id: value.key,
        used: $scope.usage[value.key],
        value: value.name,
      };

      return valueToRemove;
    };

    $scope.prepareRemoveAndUpdate = (element, attribute, key) => {
      $scope.descElem = {
        elemName: element[0].name,
        attrName: attribute[0].name,
        attrKey: key.id,
        attrAlias: attribute[0].alias,
        attrValueAlias: key.value,
        attrUsedTimes: key.used,
        fti: element[0],
      };

      $scope.modalEditRestrictValue = ngDialog.open({
        template:
          'js/XG/widgets/ancapp/main/views/modals/modal.editAttributeRestriction.html',
        className: 'ngdialog-theme-plain width800 miniclose nopadding',
        closeByDocument: false,
        scope: $scope,
        onclose: () => {
          delete $scope.descElem;
        },
      });
    };

    $scope.replaceValue = () => {
      var ans = confirm(
        "Êtes-vous sur de changer la valeur de l'attribut ? \n Cette opération peut être longue en fonction du nombre d'éléments concernés."
      );
      if (ans) {
        gaDomUtils.showGlobalLoader();
        CurrentAppFactory.updaterestrictionvalueoncomponent(
          $scope.descElem.elemName,
          $scope.descElem.attrName,
          $scope.descElem.attrKey,
          $scope.descElem.newValue
        ).then(res => {
          $scope.setAttributeValues($scope.selectedAttribute.model);
          $scope.modalEditRestrictValue.close();
          gaDomUtils.hideGlobalLoader();
          require('toastr').success('Valeur changée');
        });
      }
    };

    $scope.resetValuesUsage = () => {
      gaDomUtils.showGlobalLoader();
      $scope.updateComponentValues().then(() => {
        gaDomUtils.hideGlobalLoader();
        require('toastr').success('Réinitialisation effectuée');
        $scope.setAttributeValues($scope.selectedAttribute.model);
        $scope.modalEditRestrictValue.close();
      });
    };

    $scope.updateComponentValues = () => {
      return CurrentAppFactory.updaterestrictionvalueoncomponent(
        $scope.descElem.elemName,
        $scope.descElem.attrName,
        $scope.descElem.attrKey,
        null
      );
    };

    $scope.deleteValues = () => {
      gaDomUtils.showGlobalLoader();
      $scope.updateComponentValues().then(() => {
        delete $scope.selectedAttribute.model[0].restrictions[0].listofValues[
          $scope.descElem.attrKey
        ];
        $scope.setAttributeValues($scope.selectedAttribute.model);

        FeatureTypeFactory.update($scope.selectedElement.model[0]).then(() => {
          require('toastr').success('Valeur supprimée');
          ParametersFactory.publish($scope.selectedElement.model[0].uid).then(
            () => {
              gaDomUtils.hideGlobalLoader();
              require('toastr').success('Composant mis à jour');
            }
          );
          $scope.modalEditRestrictValue.close();
        });
      });
    };

    $scope.cancelUpdateValues = () => {
      delete $scope.descElem;
      $scope.modalEditRestrictValue.close();
    };

    $scope.reaffectationAllowed = () => {
      return (
        $scope.selectedFeature.model.value[0] !==
          'kis_anc_listes_deroulantes_controles' &&
        $scope.selectedFeature.model.value[0] !==
          'kis_bac_listes_deroulantes_controles'
      );
    };
  };

  listesDeroulantesCtrl.$inject = [
    '$scope',
    'FeatureTypeFactory',
    'AncAppFactory',
    'ngDialog',
    'gaDomUtils',
    'ParametersFactory',
    '$q',
    '$rootScope',
    'gaJsUtils',
    'BacAppFactory'
  ];
  return listesDeroulantesCtrl;
});


define('modules/common/services/extendedNgDialog',[],function () {
  /**
   *
   * Class : extendedNgDialog
   * Extends the original ngdialog third party provider
   *
   * @param ngDialog
   * @param $rootScope
   * @param $document
   * @param $timeout
   * @param $filter
   * @param $http
   * @param dialogsCommon
   * @returns service functions (open, etc)
   */
  const extendedNgDialog = function (
    ngDialog,
    $rootScope,
    $document,
    $timeout,
    $filter,
    $http,
    dialogsCommon,
    $window,
    gaJsUtils
  ) {


    const popupHeight = (popupElement) => {
      return popupElement.height() - 44;
    };


    this.Popup = function(opts) {

      // -- Ticket pour le KIS-3606 ajout de l'option suivante:
      // -- option "broadcastHeightChanged" qui permet de signaler un changement de hauteur
      // -- aux enfants de la popup par envoi du message identifié par la valeur de cette option

      // create a new scope by extending the parent scope
      // add functions for popup features(drag drop, resize, minimize/maximize)
      opts.scope = opts.scope.$new();
      this.popup = $.extend({}, opts);
      this.popup.features = this.popup.scope;
      this.popup.features = $.extend(this.popup.features, opts);

      // booleans used to toggle different states(tab, normalized, maximized)
      this.popup.features.isMaximized = false;
      this.popup.features.isTab = false;
      this.popup.features.resizeEnabled = false;
      this.popup.features.dragActive = true;
      this.popup.features.popupStates = {};
      this.popup.features.boundings = {};
      this.popup.features.topOffset = null;

      // by default popups are draggable
      // by default close button is shown
      this.popup.features.draggable = opts.draggable !== false;
      this.popup.features.scrollable = opts.scrollable === true;
      this.popup.features.showClose = opts.showClose !== false;
      this.popup.features.makeTabAllOthers =
        this.popup.features.minimizeProperty === true;

      this.popup.features.className = opts.className || '';
      this.popup.features.formOptions = opts.formOptions ? opts.formOptions : {};
      if (!opts.title) {
        // if no title is provided -> take the title configured in the form itself
        this.popup.features.title = this.popup.features.formOptions.formTitle;
      }
      this.popup.features.position = opts.position || { top: 0, left: 0 };

      // utility functions
      // declared with null for hoisting purposes
      this.popup.features.closeDialog = null;
      this.popup.features.maximize = null;
      this.popup.features.normalize = null;
      this.popup.features.makeItTab = null;
      this.popup.features.updateProperties = null;
      this.popup.features.savePopupState = null;
      this.popup.features.toggleDraggable = null;
      this.popup.features.toggleResize = null;
      this.popup.features.activateDrag = null;
      this.popup.features.addEvents = null;
      this.popup.features.removeEvents = null;
      this.popup.features.resize = null;
      this.popup.features.startResize = null;
      this.popup.features.finishResize = null;
      this.popup.features.addCustomizations = null;
      this.popup.features.iddiv = generateUniqueId();

      $http
        .get('js/XG/modules/common/views/extendedNgDialogTemplate.html')
        .then(template => {
          const element = angular.element(template.data);
          this.popup.features.contentTemplate = this.popup.template;
          this.popup.template = element[0].outerHTML;
          this.popup.plain = true;
          this.popup.showClose = false;

          const dialogReturn = ngDialog.open(this.popup);
          this.popup = $.extend(this.popup, dialogReturn);
          if (opts.scope.closeCallback) {
            dialogReturn.closePromise.then(function(data) {
              opts.scope.closeCallback(data);
            });
          }
        });

      $('body').toggleClass('no_drop_modal');
      let deregNgDialog = $rootScope.$on('ngDialog.opened', (e, $dialog) => {
        this.popup.dialog = $dialog;
        // we need timeout because we need to wait for angular
        //to finish data model evaluation in the template
        $('.ngdialog').hide();
        $timeout(() => {
          let body = $('body');
          let popupElement = $(
            `div[ga-draggable-zone='#${this.popup.features.iddiv}zone']`
          );
          let popupContainer = popupElement.closest('.popupContainer');

          popupContainer
            .closest('.ngdialog')
            .attr('dialog-id', this.popup.features.iddiv);
          popupContainer.closest('.ngdialog').addClass('extendedNgDialog');

          body.append(popupContainer);
          $('.ngdialog').show();
          body.toggleClass('no_drop_modal');
          if(this.popup.features.addCustomizations){
            this.popup.features.addCustomizations();
          }
          this.popup.features.makeItFocused(popupElement, e);
        }, 0);
        deregNgDialog();
      });


      this.popup.features.minimize = () => {
        this.popup.features.makeItTab();
        let popupElement = $(
          `div[ga-draggable-zone='#${this.popup.features.iddiv}zone']`
        );
        popupElement.closest('.popupContainer').css('margin', 0);

        let nrOfPopups = $('.extendedNgDialog').length;

        popupElement.css({
          top: nrOfPopups * 50 - popupElement.height(),
          left: 20,
        });
      };


      $rootScope.$on('minimizePopup', (event, id) => {
        if (id === this.popup.features.iddiv && !this.popup.features.isTab) {
          this.popup.features.minimize();
        }
      });


      this.popup.features.onNgDialogClosed = (e, $dialog) => {
        let ngDialogId = $dialog.attr('id');

        if (ngDialogId === this.popup.id) {
          let dialogId = $dialog.attr('dialog-id');
          let dialogElement = $(`#${dialogId}`);
          dialogElement.remove();

          this.popup.features.removeEvents();
          this.popup.deregisterClosedEvent();
          $rootScope.$broadcast('onNgDialogClosed', ngDialogId);
        }
      };

      this.popup.deregisterClosedEvent = $rootScope.$on(
        'ngDialog.closed',
        this.popup.features.onNgDialogClosed
      );

      this.popup.features.closeDialog = () => {
        let dialog = $(`div[dialog-id='${this.popup.features.iddiv}']`);

        let dialogId = dialog.attr('id');
        ngDialog.close(dialogId);
      };

      this.popup.features.maximize = () => {
        this.popup.features.prevPopupHeight = this.popup.features.height;
        if (this.popup.features.isTab) {
          this.popup.features.savePopupState('minimized');
        }
        else {
          this.popup.features.savePopupState('normal');
        }

        const popupElement = $(
          `div[ga-draggable-zone='#${this.popup.features.iddiv}zone']`
        );
        popupElement.closest('.popupContainer').css('margin', 0);

        let leftMenu = $('.mapLeftMenu');
        let leftMenuCoordinates = {};

        const categoriesVerticalBar = $('.displayFirstLevel');
        let displayFirstLevelBoundings;
        if (categoriesVerticalBar && categoriesVerticalBar.length > 0) {
          displayFirstLevelBoundings = categoriesVerticalBar[0].getBoundingClientRect();
        }
        else {
          // la barre verticale des catégories n'est pas toujours présente (ex. page d'accueil)
          displayFirstLevelBoundings = {right:0,width:0};
        }

        const mapWidgetContainer = $('.mapMenuWrapper');
        let mapMenuWrapperBoundings;
        if (mapWidgetContainer && mapWidgetContainer.length > 0) {
          mapMenuWrapperBoundings = mapWidgetContainer[0].getBoundingClientRect();
        }
        else {
          // le conteneur d'un widget n'est pas toujours présent (ex. page d'accueil)
          mapMenuWrapperBoundings = {right:0,width:0};
        }

        if (leftMenu.find('.mapMenuWrapper').hasClass('active')) {
          leftMenuCoordinates.right = mapMenuWrapperBoundings.right;
          leftMenuCoordinates.width =
            displayFirstLevelBoundings.width + mapMenuWrapperBoundings.width;
        }
        else {
          leftMenuCoordinates.right = displayFirstLevelBoundings.right;
          leftMenuCoordinates.width = displayFirstLevelBoundings.width;
        }

        popupElement.find('.panel-collapse.extendedNgDialogContent').show();

        popupElement.css({
          width: `calc(100vw - ${leftMenuCoordinates.width}px`,
          height: 'calc(100vh)',
          position: 'absolute',
          left: leftMenuCoordinates.right,
          top: '0px',
        });

        this.popup.features.isTab = false;
        this.popup.features.isMaximized = true;
        this.popup.features.isMinimized = false;
        this.popup.features.resizeEnabled = false;

        // redimensionne la div contentTemplate
        setContentTemplateHeight(popupElement);
        this.popup.features.height = popupHeight(popupElement) + 'px';
        broadcastHeightChanged();
      };


      this.popup.features.normalize = () => {
        this.popup.features.prevPopupHeight = this.popup.features.height;
        let popupElement = $(
          `div[ga-draggable-zone='#${this.popup.features.iddiv}zone']`
        );
        popupElement.closest('.popupContainer').css('margin', 'auto');

        if (this.popup.features.isTab) {
          this.popup.features.savePopupState('minimized');
        }

        let popupProps = {
          top: this.popup.features.popupStates.normal.popupProperties.top,
          left: this.popup.features.popupStates.normal.popupProperties.left,
          width: this.popup.features.popupStates.normal.popupProperties.width,
          height: this.popup.features.popupStates.normal.popupProperties.height,
        };

        this.popup.features.updateProperties(popupProps);
        this.popup.features.isTab = false;
        this.popup.features.isMaximized = false;
        this.popup.features.isMinimized = false;
        this.popup.features.resizeEnabled = false;

        // redimensionne la div contentTemplate
        setContentTemplateHeight(popupElement);
        this.popup.features.height = popupHeight(popupElement) + 'px';
        broadcastHeightChanged();
      };

      this.popup.features.makeItTab = () => {
        if (!this.popup.features.isMaximized && !this.popup.features.isTab) {
          this.popup.features.savePopupState('normal');
          this.popup.features.savePopupState('minimized');
        }

        let popupElement = $(
          `div[ga-draggable-zone='#${this.popup.features.iddiv}zone']`
        );
        popupElement.closest('.popupContainer').css('margin', 'auto');

        if (this.popup.features.isTab) {
          // make it normal
          this.popup.features.isMinimized = false;
          popupElement.find('.panel-collapse.extendedNgDialogContent').show();
          this.popup.features.normalize();
          this.popup.features.isTab = false;
        }
        else {
          // make it tab
          this.popup.features.isMinimized = true;
          popupElement.find('.panel-collapse.extendedNgDialogContent').hide();
          let tittleWidth = popupElement.find('.popupName').outerWidth() + 118;

          // KIS-3082: en voulant minimiser la fenêtre, celle-ci prend toute la hauteur de la page
          let titleHeight = popupElement.find('.headerpopup').outerHeight();

          let minimizedOffsets;
          if (this.popup.features.popupStates.minimized) {
            minimizedOffsets = {
              top: this.popup.features.popupStates.minimized.popupProperties
                .top,
              left: this.popup.features.popupStates.minimized.popupProperties
                .left,
            };
          }
          else {
            minimizedOffsets = {
              top: this.popup.features.position.top,
              left: this.popup.features.position.left,
            };
          }

          popupElement.css({
            top: minimizedOffsets.top,
            left: minimizedOffsets.left,
            height: titleHeight,
            width: tittleWidth,
          });

          this.popup.features.isTab = true;
        }

        this.popup.features.isMaximized = false;
        this.popup.features.resizeEnabled = false;
      };

      this.popup.features.updateProperties = popupProps => {
        let popupElement = $(
          `div[ga-draggable-zone='#${this.popup.features.iddiv}zone']`
        );

        popupElement.css({
          top: popupProps.top,
          left: popupProps.left,
          width: popupProps.width,
          height: popupProps.height,
        });
      };

      /**
       * Le cas échéant envoyer un message aux enfants de la poup
       * afin qu'ils puissent mettre à jour leurs dimensions
       */
      const broadcastHeightChanged = () => {

        let newPopupHeight = this.popup.features.height;
        if (opts.broadcastHeightChanged && this.popup.features.prevPopupHeight !== newPopupHeight) {
          opts.scope.$broadcast(opts.broadcastHeightChanged,
            {
              heightDelta: parseInt(newPopupHeight) - parseInt(this.popup.features.prevPopupHeight),
              containerHeight: newPopupHeight
            });
        }
      };


      this.popup.features.savePopupState = state => {
        let popupElement = $(
          `div[ga-draggable-zone='#${this.popup.features.iddiv}zone']`
        );
        let popupBoundings = popupElement[0].getBoundingClientRect();
        let popupPosition = popupElement.position();

        this.popup.features.popupStates[state] = {
          popupProperties: {
            top: popupPosition.top,
            left: popupPosition.left,
            width: popupBoundings.width,
            height: popupBoundings.height,
          },
        };
      };

      this.popup.features.toggleDraggable = event => {
        let targetParent = $(event.target).closest('.headerpopup');

        this.popup.features.dragActive = targetParent.hasClass('headerpopup');
      };

      this.popup.features.toggleResize = (event, state) => {
        this.popup.resizeEnabled = state;
      };

      this.popup.features.activateDrag = event => {
        let eventTarget = $(event.target).hasClass('resizeSide');
        if (!eventTarget) {
          this.popup.resizeEnabled = false;
        }
      };

      this.popup.features.dragPopup = (popupElement, left, top) => {

        const popupWidth = parseInt(popupElement.css('width'));
        const halfScreenWidth = window.innerWidth / 2;
        const halfScreenHeight = window.innerHeight / 2;
        let newLeft = left;
        let newTop = top;

        //left
        if (left < -halfScreenWidth) {
          newLeft = -halfScreenWidth;
        }
        //right
        if (left + popupWidth > halfScreenWidth) {
          newLeft = halfScreenWidth - popupWidth;
        }
        //top
        if (top < -halfScreenHeight) {
          newTop = -halfScreenHeight;
        }
        //bottom
        if (top + 44 > halfScreenHeight) {
          newTop = halfScreenHeight-44; // 44 is the popup label's height
        }

        popupElement.css({
          left: newLeft,
          top: newTop
        });
      };

      this.popup.features.addEvents = () => {
        // only add events if dialog is resizable
        if (this.popup.features.resizable) {
          $(document).on('mousemove', this.popup.features.resize);
          $(document).on('mousedown', this.popup.features.startResize);
          $(document).on('mouseup', this.popup.features.finishResize);
        }
      };

      this.popup.features.removeEvents = () => {
        // after dialog is closed, remove the events associated with it
        if (this.popup.features.resizable) {
          $(document).off('mousemove', this.popup.features.resize);
          $(document).off('mousedown', this.popup.features.startResize);
          $(document).off('mouseup', this.popup.features.finishResize);
        }
      };


      this.popup.features.resize = event => {
        const popupElement = $(
          `div[ga-draggable-zone='#${this.popup.features.iddiv}zone']`
        );
        if (!popupElement.data('focusedPopup')) {
          return;
        }

        let popupBoundings = popupElement[0].getBoundingClientRect();
        let mousePosition = { left: event.clientX, top: event.clientY };
        let body = $('body');
        body.css({ 'user-select': 'none' });

        switch (this.popup.features.resizeSide) {
          case 'topResize': {
            let popupIncrement = popupBoundings.top - mousePosition.top;
            let newPopupHeight =
              popupElement.height() + (popupBoundings.top - mousePosition.top);

            popupElement.height(newPopupHeight);
            popupElement.css({
              top: popupElement.position().top - popupIncrement,
            });
            body.css({ cursor: 'n-resize' });
            this.popup.features.height
              = isPopupDimValid(popupHeight(popupElement),this.popup.features.minHeight) ?
                popupHeight(popupElement) + 'px'
                : (gaJsUtils.isolateCssSizeNumericValue(this.popup.features.minHeight) -44) + 'px' ;

            // KIS-3082: mauvais dimensionnement de la fenêtre et/ou agencement
            // des éléments contenus dans la fenêtre
            removeFixedHeightOnVerticalResize(popupElement);

            break;
          }
          case 'rightResize': {
            let newPopupWidth =
              popupElement.width() + mousePosition.left - popupBoundings.right;
            let popupLeftPosition = popupElement.position().left;

            popupElement.width(newPopupWidth);
            popupElement.css({
              left: popupLeftPosition,
            });

            body.css({ cursor: 'e-resize' });
            this.popup.features.width
              = isPopupDimValid(popupElement.width(),this.popup.features.minWidth) ?
                popupElement.width() + 'px' : this.popup.features.minWidth;
            break;
          }
          case 'bottomResize': {
            let newPopupHeight =
              popupElement.height() + mousePosition.top - popupBoundings.bottom;
            let popupTopPosition = popupElement.position().top;

            popupElement.height(newPopupHeight);
            popupElement.css({
              top: popupTopPosition,
            });
            body.css({ cursor: 'n-resize' });

            // KIS-3082: mauvais dimensionnement de la fenêtre et/ou agencement
            //des éléments contenus dans la fenêtre
            removeFixedHeightOnVerticalResize(popupElement);

            this.popup.features.height = setRezizedContentTemplateHeight(popupElement);
            break;
          }
          case 'leftResize': {
            let popupIncrement = popupBoundings.left - mousePosition.left;
            let newPopupWidth =
              popupElement.width() + (popupBoundings.left - mousePosition.left);

            popupElement.width(newPopupWidth);
            popupElement.css({
              left: popupElement.position().left - popupIncrement,
            });
            body.css({ cursor: 'e-resize' });
            this.popup.features.width
              = isPopupDimValid(popupElement.width(),this.popup.features.minWidth) ?
                popupElement.width() + 'px' : this.popup.features.minWidth;
            break;
          }
        }
      };

      this.popup.features.startResize = event => {
        this.popup.features.prevPopupHeight = this.popup.features.height;
        if (!this.popup.features.isMaximized &&
          !this.popup.features.isTab &&
          $(event.target).hasClass('resizeSide')
        ) {
          this.popup.features.resizeSide = $(event.target)
            .attr('class')
            .split(' ')[1];
        }
      };

      this.popup.features.hide = () => {
        document.getElementById(this.popup.features.iddiv).style.display = 'none';
      };

      this.popup.features.show = () => {
        document.getElementById(this.popup.features.iddiv).style.display = 'block';
      };


      this.popup.features.finishResize = () => {
        $('body').css({ cursor: 'auto' });
        this.popup.features.resizeSide = null;

        // -- Le cas échéant envoyer un message aux enfants de la poup
        // -- afin qu'ils puissent mettre à jour leurs dimensions
        broadcastHeightChanged();
      };

      /**
       * Place la popup au 1er plan
       * @param iddiv attribut html 'id' de la div enfant
       * @see this.popup.features.iddiv
       */
      this.popup.features.onForeground = (iddiv) =>{
        if ($('.popupContainer').length>1){
          $('.popupContainer').css('zIndex', 2100);
          $('#'+iddiv).css( 'zIndex', 2101);
        }
      };

      this.popup.features.makeItFocused = function(htmlElem,event0) {
        $timeout(function(event) {
          if(event || event0) {
            $(htmlElem).closest('.popupContainer').css('z-index', dialogsCommon.getMaxIndex());
          }
        });

        $('.popupPanel').data('focusedPopup', false);
        $(htmlElem).closest('.popupPanel')
          .data('focusedPopup', true);
      };

      this.popup.features.addEvents();

      this.popup.features.addCustomizations = () => {
        let popupElement = $(
          `div[ga-draggable-zone='#${this.popup.features.iddiv}zone']`
        );
        let popupContainer = popupElement.closest('.popupContainer');

        popupContainer.addClass(this.popup.features.className);

        if (this.popup.features.formOptions.formHeight) {
          popupElement.css('height',
            this.popup.features.formOptions.formHeight + 'vh');
        }
        if (this.popup.features.formOptions.formWidth) {
          popupElement.css('width',
            'calc(' + this.popup.features.formOptions.formWidth + 'vw - 60px)');
        }

        if (this.popup.features.formOptions.formPosition) {
          // this config is stored in the form itself
          // AND it has priority over the other position config
          placeFormAt(popupElement, this.popup.features.formOptions.formPosition);
        }
        else if (
          this.popup.features.position.top !== 0 ||
          this.popup.features.position.left !== 0
        ) {
          // this config is in the intervflow widget
          popupContainer.removeClass('centered');

          popupElement.css({
            left: this.popup.features.position.left,
            top: this.popup.features.position.top,
          });
        }

        if (this.popup.features.makeTabAllOthers) {
          let allPopups = $('.popupContainer');

          for (let index = 0; index < allPopups.length; index++) {
            let popupId = $(allPopups[index]).attr('id');

            if (popupId !== this.popup.features.iddiv) {
              // minimize all other popups
              $rootScope.$broadcast('minimizePopup', popupId);
            }
          }
        }
      };

      function placeFormAt(popupElement, position) {
        let cssConfig;
        switch(position) {
          case 'top_left':
            cssConfig = {
              top: 'calc(-50vh)',
              left: 'calc(-50vw + 50px)'
            };
            break;
          case 'top_right':
            cssConfig = {
              top: 'calc(-50vh)',
              right: 'calc(-50vw + 50px)'
            };
            break;
          case 'center':
            cssConfig = {
              margin: 'auto',
              top: 'auto',
              bottom: 'auto',
              left: 'auto',
              right: 'auto'
            };
            break;
          case 'bottom_left':
            cssConfig = {
              bottom: 'calc(-50vh - 20px)',
              left: 'calc(-50vw + 50px)'
            };
            break;
          case 'bottom_right':
            cssConfig = {
              bottom: 'calc(-50vh - 20px)',
              right: 'calc(-50vw + 50px)'
            };
            break;
          default:
            console.error('unknown position setting: ' + position);
            break;
        }
        if (popupElement && cssConfig) {
          popupElement.css(cssConfig);
        }
      }

      function generateUniqueId() {
        const uniqueID = new Date();
        const myRandom = Math.floor(Math.random() * 1000);
        return uniqueID.getTime() + '' + myRandom;
      }

      /**
       * Définition des dimensions et de la position que la popup doit prendre
       * quand celle-ci passe d'un état réduit à normal
       * @param {object} popupPropsToSet position top/left et dimensions width/height
       */
      this.popup.features.setNormalSize = (popupPropsToSet) => {
        if (popupPropsToSet) {
          if (!this.popup.features.popupStates.normal
              || !this.popup.features.popupStates.normal.popupProperties) {
            this.popup.features.popupStates.normal = {
              popupProperties: {}
            };
          }
          this.popup.features.popupStates.normal.popupProperties.top = popupPropsToSet.top;
          this.popup.features.popupStates.normal.popupProperties.left = popupPropsToSet.left;
          this.popup.features.popupStates.normal.popupProperties.width = popupPropsToSet.width;
          this.popup.features.popupStates.normal.popupProperties.height = popupPropsToSet.height;
        }
      };

      return this.popup;
    };

    /**
     * Allow the dialog to be dragged while holding mousedown on the handler
     * @param element
     * @param opts
     */
    let makeDraggable = function(element, opts) {
      const paramx = 320;

      const paramy = 300;

      let $dialog = element.find('.ngdialog-content'),
        borderSpacing = 10,
        $dialogWidth = $dialog.outerWidth(),
        $dialogHeight = $dialog.outerHeight(),
        startX = 0,
        startY = 0,
        x = paramx,
        y = paramy,
        handler = angular.element(
          '<h3 class="modalTitle ngdialog_handler">' +
            $filter('translate')(opts.title) +
            '</h3>'
        );

      console.log($dialogHeight);
      console.log('er');

      // reset dialog position
      $dialog.css({
        position: 'absolute',
        left: x,
        top: y,
      });

      $dialog.prepend(handler);

      handler.on('mousedown', function(event) {
        // Prevent default dragging of selected content
        event.preventDefault();
        startX = event.screenX - x;
        startY = event.screenY - y;

        $document.on('mousemove', mousemove);
        $document.on('mouseup', mouseup);
      });

      function mousemove(event) {
        y = event.screenY - startY;
        x = event.screenX - startX;

        // Make it impossible to push the dialog out of the client window
        let borders = {
          right: window.screen.availWidth - $dialogWidth - borderSpacing,
          left: borderSpacing,
          top: borderSpacing + 94,
          bottom: window.screen.availHeight - borderSpacing - 47,
        };

        if (x > borders.right) {
          x = borders.right;
        }
        if (x < borders.left) {
          x = borders.left;
        }
        if (y < borders.top) {
          y = borders.top;
        }
        // useless ?
        if (x < borders.left) {
          y = borders.left;
        }

        // it should be possible to go under the maxheight as long as the
        // draggable part is still visible
        if (y > borders.bottom) y = borders.bottom;

        $dialog.css({
          top: y + 'px',
          left: x + 'px',
        });
      }

      function mouseup() {
        $document.off('mousemove', mousemove);
        $document.off('mouseup', mouseup);
      }
    };

    /**
     * Vérifie si la hauteur/largeur de la popup est supérieure à la hauteur/largeur mini
     * @param currentDim valeur courante de la hauteur ou de la largeur de la popup
     * @param dimValueLimit valeur la plus basse admise pour la hauteur/largeur
     * @return {boolean} true si la hauteur/largeur courante est supérieure
     *     à la hauteur-min/largeur-min
     */
    const isPopupDimValid = (currentDim, dimValueLimit) => {
      if (dimValueLimit) {
        if (Number.isInteger(dimValueLimit)) {
          return currentDim > Number.parseInt(dimValueLimit);
        } else {
          const dimLimitAsNum = Number.parseFloat(dimValueLimit);
          if (dimValueLimit.endsWith('px')) {
            return currentDim > dimLimitAsNum;
          }
          else if (dimValueLimit.endsWith('vh')) {
            return currentDim > ($window.innerHeight * dimLimitAsNum / 100);
          }
          else if (dimValueLimit.endsWith('vw')) {
            return currentDim > ($window.innerWidth * dimLimitAsNum / 100);
          }
        }
      }
      return true;
    };

    /**
     * Dimensionnement du contentTemplate à l'initialisation
     * @param popup
     */
    const initContentTemplateSize = (popup) => {
      $timeout(() => {
        // définit la hauteur et la largeur
        if (popup.formOptions && Number.isFinite(popup.formOptions.formHeight)
          && Number.isFinite(popup.formOptions.formWidth)) {
          popup.features.height = ((popup.formOptions.formHeight * $window.innerHeight / 100)
            - 44) + 'px';
          popup.features.width = '100%';
        }
        else {
          const popupDiv = document.getElementById(popup.features.iddiv);
          if (popupDiv && popupDiv.children.length > 0
              && popupDiv.children[0].clientHeight > 0 && popupDiv.children[0].clientWidth > 0) {
            popup.features.height =  (popupDiv.children[0].clientHeight - 44) + 'px';
            popup.features.width = popupDiv.children[0].clientWidth + 'px';
          }
        }
        // ajoute la hauteur de la barre de titre à la valeur minHeight
        if (popup.features.minHeight) {
          const heightAsNum = Number.parseInt(popup.features.minHeight);
          if (heightAsNum > 0) {
            if (popup.features.minHeight.endsWith('px')) {
              popup.features.minHeight = (heightAsNum + 44) + 'px';
            }
            else if (popup.features.minHeight.endsWith('vh')) {
              const pxWithTitleBar = (($window.innerHeight * heightAsNum / 100) + 44);
              const vhWithTitleBar = (pxWithTitleBar * 100) / $window.innerHeight;
              popup.features.minHeight = vhWithTitleBar + 'vh';
            }
            // KIS-3079: mauvais dimensionnement de la popup.
            // Les boutons Fermer/Enregistrer n'étaient pas positionnés
            // au bas de la popup.
            // La popup prend la hauteur du contenu (minHeight+44 par défaut)
            if (!popup.features.height
              && !popup.features.doNotForcePopupHeightToMinHeight) {
              popup.features.height = popup.features.minHeight;
            }
          }
        }
      });
    };

    /**
     * A chaque redimensionnement vertical de la popup,
     * calcule la valeur de la hauteur du contentTemplate.<br>
     * Assure que la hauteur du contentTemplate ne soit pas inférieure
     * à la hauteur minimale si celle-ci existe.<br>
     * Prend en compte les hauteurs minimales notées en px ou en vh
     * @param popupElement élement HTML de la popup (titre compris)
     * @return {string} hauteur du contentTemplate de la popup
     */
    const setRezizedContentTemplateHeight = (popupElement) => {
      if (this.popup && this.popup.features && typeof this.popup.features.minHeight === 'string'
          && this.popup.features.minHeight.length > 0) {
        const minHeightAsNum = Number.parseInt(this.popup.features.minHeight);
        if (!isPopupDimValid((popupHeight(popupElement)), this.popup.features.minHeight)
          && minHeightAsNum > 0) {
          if (this.popup.features.minHeight.endsWith('px')) {
            return (minHeightAsNum - 44) + 'px';
          }
          else if (this.popup.features.minHeight.endsWith('vh')) {
            const pxValue = ($window.innerHeight * minHeightAsNum / 100) - 44;
            return (pxValue * 100 / $window.innerHeight) + 'vh';
          }
        }
      }
      return popupHeight(popupElement) + 'px';
    };

    /**
     * Définit la hauteur du conteneur du corps de la popup
     * en fonction de la hauteur de la popup entière.
     * Il s'agit de la hauteur de la popup à laquelle on soustrait la hauteur de la barre
     * de titre fixe à 44px
     * @param popupElement élement HTML de la popup
     */
    const setContentTemplateHeight = (popupElement) => {
      if (Object.prototype.hasOwnProperty.call(popupElement, 0)) {
        const popupDiv = popupElement[0];
        const popupContent = popupDiv.querySelector('.contentTemplate');
        if (popupContent) {
          popupContent.style.height = popupHeight(popupElement) + 'px';
        }
      }
    };

    /**
     * Lors d'un redimensionnement de popup, dans le cas d'un formulaire (IS et autres),
     * cette méthode permet de contourner le paramètre "Hauteur" de la configuration du formulaire.
     * En effet, pour redimensionner une popup, le corps de la popup ne peut pas avoir
     * une hauteur fixe.
     * @param popupElement element JQuery contenant le corps de la popup
     */
    const removeFixedHeightOnVerticalResize = (popupElement) => {
      if (popupElement) {
        const jQueryRenderedForm = popupElement.find('.renderedForm');
        const bypassFormFixedHeight = 'height:100% !important;';
        if (jQueryRenderedForm) {
          const renderedForm = jQueryRenderedForm[0];

          if (renderedForm) {
            if (!renderedForm.hasAttribute('style')) {

              // créé un attribut de style inline
              renderedForm.setAttribute('style', bypassFormFixedHeight);

            } else {

              // ajoute la propriété à l'attribut de style inline existant
              let elementStyle = renderedForm.getAttribute('style');
              if (typeof elementStyle === 'string' && elementStyle.length > 0
                && !elementStyle.includes(bypassFormFixedHeight)) {
                if (!elementStyle.endsWith(';')) {
                  elementStyle += ';';
                }
                elementStyle += bypassFormFixedHeight;
                renderedForm.setAttribute('style', elementStyle);
              }
            }
          }
        }
      }
    };

    /**
     * Extends the ngDialog open method
     * @param opts paramétrage de la popup fourni par la directive exécutant la méthode .open()
     */
    this.open = function(opts) {
      const popup = new this.Popup(opts);

      // Dimensionnement du contentTemplate à l'initialisation
      initContentTemplateSize(popup);

      return popup;
    };

    /**
     * the old ngDialog open method
     * @param opts
     */
    this.openOld = function(opts) {
      let bodyClasses = document.getElementsByTagName('body')[0].className;
      if (bodyClasses.indexOf('no_drop_modal') === -1) {
        document.getElementsByTagName('body')[0].className += ' no_drop_modal';
      }

      // Open the dialog
      let dialogInfos = ngDialog.open(opts);

      // when the dialog is opened, makeitDraggable
      let deregNgDialog = $rootScope.$on('ngDialog.opened', function(
        e,
        $dialog
      ) {
        // if it is the targeted dialog
        if (dialogInfos.id === $dialog.attr('id')) {
          $dialog
            .removeClass('ngdialog-overlay')
            .addClass('ngdialog-no-overlay ngdialog-draggable');
          document.getElementsByTagName(
            'body'
          )[0].className = document
            .getElementsByTagName('body')[0]
            .className.replace('no_drop_modal', '');
          // timeout to be sure the dom is rendered
          $timeout(function() {
            // hacky // todo : make it better @rb
            let dialogContent = $dialog.find('.ngdialog-content');
            let decalageTop = window.screen.availHeight;
            dialogContent[0].style.marginTop = '-' + decalageTop + 'px';
            if (opts.draggable) {
              makeDraggable($dialog, opts);
            }
          },0);
        }
        deregNgDialog();
      });
      return dialogInfos;
    };
    return this;
  };

  extendedNgDialog.$inject = [
    'ngDialog',
    '$rootScope',
    '$document',
    '$timeout',
    '$filter',
    '$http',
    'dialogsCommon',
    '$window',
    'gaJsUtils'
  ];
  return extendedNgDialog;
});


define('modules/common/services/dialogsCommon',[],function() {
  var dialogsCommon = function() {
    /**
     * this method is used for resize of the dialogs but it doesn't do it's
     *    job very well. feel free to bomb it. It looks overcomplicated for what it shoud do
     * checkIfMarginIsReached seems to only be used in extendedNgDialog and gcPopup
     */
    this.checkIfMarginIsReached = dialogParams => {
      let dialogType = dialogParams.type;
      let coordinates = dialogParams.coordinates;
      let element = dialogParams.element;
      let event = dialogParams.event;

      let draggableBoundings = element[0].getBoundingClientRect();
      let viewportHeight = window.innerHeight;
      let viewportWidth = window.innerWidth;
      let isMargin = false;

      let leftOffset = draggableBoundings.left;
      let viewportTopOffset = 0;

      let popupContentHeight = 0;
      let draggableZoneHeight = 0;

      if (element[0].classList.contains('ga-draggable-zone')) {
        draggableZoneHeight = element[0].querySelector('.ga-draggable-zone').clientHeight;
        popupContentHeight = draggableBoundings.height - draggableZoneHeight;
      }


      let topOffset = draggableBoundings.top - 2;
      let rightOffset = draggableBoundings.right;
      let botttomOffset = draggableBoundings.bottom + viewportTopOffset;

      let isDraggingLeft =
        coordinates.mouseStartHorizontalPosition >=
        coordinates.mouseMoveHorizontalPosition;

      let isDraggingTop =
          coordinates.mouseStartVerticalPosition >=
          coordinates.mouseMoveVerticalPosition;

      let isDraggingRight =
          coordinates.mouseStartHorizontalPosition <=
          coordinates.mouseMoveHorizontalPosition;

      let isDraggingBottom =
          coordinates.mouseStartVerticalPosition <=
          coordinates.mouseMoveVerticalPosition;

      if (leftOffset <= 0 && isDraggingLeft) {
        if (dialogType === 'gcPopup') {
          element.css('left', 0);
        } else {
          element.css('left', -viewportWidth / 2);
        }
        stopEvent(event);
        isMargin = true;
      }

      if (topOffset <= 0 && isDraggingTop) {
        if (dialogType === 'gcPopup') {
          const top = -(viewportTopOffset + 20);
          element.css('top', top < 0 ? 0 : top);
        } else {
          const top = -viewportHeight / 2 - viewportTopOffset;
          element.css('top', top < 0 ? 0 : top);
        }

        stopEvent(event);
        isMargin = true;
      }

      if (rightOffset >= viewportWidth && isDraggingRight) {
        if (dialogType === 'gcPopup') {
          element.css('left', viewportWidth - element.width());
        } else {
          element.css('left', viewportWidth / 2 - element.width());
        }

        stopEvent(event);
        isMargin = true;
      }

      if (botttomOffset - popupContentHeight >= viewportHeight && isDraggingBottom) {
        if (dialogType === 'gcPopup') {
          element.css('top', viewportHeight - element.height() + popupContentHeight - (viewportTopOffset + 20));
        } else {
          element.css(
            'top',
            viewportHeight / 2 - viewportTopOffset - element.height() + popupContentHeight
          );
        }

        stopEvent(event);
        isMargin = true;
      }

      return isMargin;
    };

    this.getMaxIndex = ()=>{
      let maxZIndex = -1;
      $('div').each(function () {
        const zIndex =  parseInt($(this).css('z-index'));
        if (!isNaN(zIndex) && zIndex > maxZIndex
          && !$(this).hasClass('xgos_loader')
          && !$(this).hasClass('sweet-alert')) {
          maxZIndex = parseInt(zIndex);
        }
      });
      if (maxZIndex === -1) {
        maxZIndex = 10000;
      }
      return maxZIndex;
    };

    function stopEvent(event) {
      event.preventDefault();
      event.stopPropagation();
    }

    return {
      checkIfMarginIsReached: this.checkIfMarginIsReached,
      getMaxIndex: this.getMaxIndex,
    };
  };

  dialogsCommon.$inject = [];
  return dialogsCommon;
});


define('modules/common/services/kisGeocodageFactory',[],function() {
  var kisGeocodageFactory = function($http, $rootScope) {
    var kisGeocodageFactory = {};

    /**
     * search
     * @param url
     * @param q
     * @param type
     * @returns {HttpPromise}
     */
    function search(url, q, type) {
      url = url?url:'https://api-adresse.data.gouv.fr';
      var url_address = url + '/search/?q=' + q;
      if (type && type != '') {
        url_address = url_address + '&type=' + type;
      }
      var promise = $http.get(url_address);
      return promise;
    }

    /**
     * reverse
     * @param url
     * @param coordinate
     * @returns {HttpPromise}
     */
    function reverse(url, coordinate) {
      var promise = $http.get(
        url + '/reverse/?lon=' + coordinate[0] + '&lat=' + coordinate[1]
      );
      return promise;
    }

    /**
     * Retrieve a geoCoderCfg configuration from it's id
     * if it doesnt exist (anymore), return false and toastr error
     * @param id
     * @return geoCoderCfg
     */
    function getGeocoderConfigFromId(id) {
      var geoCoderCfg = false,
        geocoders = $rootScope.xgos.portal.parameters.kisgeocodage;

      for (var i in geocoders) {
        if (geocoders[i].id == id) {
          geoCoderCfg = geocoders[i];
          break;
        }
      }

      return geoCoderCfg;
    }

    function getMarkerLayer() {
      var image = new ol.style.Circle({
        radius: 5,
        fill: null,
        stroke: new ol.style.Stroke({ color: 'red', width: 1 }),
      });
      var iconStyle = new ol.style.Style({
        image: new ol.style.Icon(
          /** @type {olx.style.IconOptions} */ ({
            anchor: [0.5, 1],
            anchorXUnits: 'fraction',
            anchorYUnits: 'fraction',
            opacity: 0.75,
            src: 'img/widget/adressLocation/marker.png',
          })
        ),
      });

      var styles = {
        Point: [iconStyle],
        LineString: [
          new ol.style.Style({
            fill: new ol.style.Fill({
              color: 'rgba(255,255,255,0.4)',
            }),
            stroke: new ol.style.Stroke({
              color: 'red',
              width: 2,
            }),
          }),
        ],
        MultiLineString: [
          new ol.style.Style({
            stroke: new ol.style.Stroke({
              color: 'red',
              width: 1,
            }),
          }),
        ],
        MultiPoint: [
          new ol.style.Style({
            image: image,
          }),
        ],
        MultiPolygon: [
          new ol.style.Style({
            stroke: new ol.style.Stroke({
              color: 'yellow',
              width: 1,
            }),
            fill: new ol.style.Fill({
              color: 'rgba(255, 255, 0, 0.1)',
            }),
          }),
        ],
        Polygon: [
          new ol.style.Style({
            stroke: new ol.style.Stroke({
              color: 'blue',
              lineDash: [4],
              width: 3,
            }),
            fill: new ol.style.Fill({
              color: 'rgba(0, 0, 255, 0.7)',
            }),
          }),
        ],
        GeometryCollection: [
          new ol.style.Style({
            stroke: new ol.style.Stroke({
              color: 'magenta',
              width: 2,
            }),
            fill: new ol.style.Fill({
              color: 'magenta',
            }),
            image: new ol.style.Circle({
              radius: 10,
              fill: null,
              stroke: new ol.style.Stroke({
                color: 'magenta',
              }),
            }),
          }),
        ],
        Circle: [
          new ol.style.Style({
            stroke: new ol.style.Stroke({
              color: 'red',
              width: 2,
            }),
            fill: new ol.style.Fill({
              color: 'rgba(255,0,0,0.2)',
            }),
          }),
        ],
      };
      var styleFunction = function(feature, resolution) {
        return styles[feature.getGeometry().getType()];
      };

      var vectorSource = new ol.source.Vector({
        //create empty vector
      });
      return new ol.layer.Vector({
        source: vectorSource,
        style: styleFunction,
      });
    }

    return {
      kisGeocodageFactory: kisGeocodageFactory,
      search: search,
      reverse: reverse,
      getGeocoderConfigFromId: getGeocoderConfigFromId,
      getMarkerLayer: getMarkerLayer,
    };
  };
  kisGeocodageFactory.$inject = ['$http', '$rootScope'];
  return kisGeocodageFactory;
});


define('modules/common/services/twitterFactory',[],function() {
  var TwitterFactory = function($http) {
    var TwitterFactory = {};
    /**
     * Class : TwitterFactory
     * Factory WebServices
     */

    /**
     * Function: execute
     */
    function execute(functionName) {
      var promise = $http.get(
        '/services/{portalid}/twitter/execute?f=json' +
          '&functionName=' +
          functionName
      );

      return promise;
    }

    return {
      TwitterFactory: TwitterFactory,
      execute: execute,
    };
  };
  TwitterFactory.$inject = ['$http'];
  return TwitterFactory;
});


define('modules/common/services/versionsFactory',[],function() {
  var VersionsFactory = function($http, $q) {
    var VersionsFactory = {};


    const getIndigauVersion = (versData, versTreedata, def) => {
      $http.get(
        '/services/{portalid}/indigau/{appname}/getversion?f=json'
      ).then((res) => {
        const data = res.data;
        let version;
        if (!data.errorList || data.errorList.length != 0
          || !data.strValeur || data.strValeur.length == 0) {
          version = 'Indigau 2.0.1';
        }
        else {
          version = data.strValeur;
        }
        def.resolve([versData, versTreedata, version]);
      });
    };


    /**
     * Function: getVersions
     */
    function getVersions(sector) {
      var def = $q.defer();
      // recuperation des versions
      $http.get('./versions_kis/versions.json').then(
        function(response) {
          let data = response.data;
          let status = response.status;

          if (data && status === 200) {
            let versionsData = data;
            let versionTreedata = [];

            let actuelleList = versionsData.current.split('.');
            for (let version of versionsData.versions) {
              let compare = version.number.split('.');
              let valideVersion = true;
              for(let i=0;i<actuelleList.length;i++){
                if(!angular.isDefined(compare[i])){
                  break;
                }else if(parseInt(actuelleList[i])>parseInt(compare[i])){
                  break;
                }else if(parseInt(actuelleList[i])<parseInt(compare[i])){
                  valideVersion = false;
                  break;
                }
              }
              // ne prend que les versions <= version actuelle
              if (valideVersion) {
                let pdfLink;

                if (
                  angular.isDefined(version.blank) &&
                  version.blank == true
                ) {
                  pdfLink = null;
                } else {
                  pdfLink =
                    './versions_kis/' + version.number + '.pdf';

                  versionTreedata.push({
                    label: version.number,
                    date: version.date,
                    pdf: pdfLink,
                  });
                }
              }
            }
            if (sector !== 'indigau') {
              def.resolve([versionsData, versionTreedata]);
            }
            else {
              getIndigauVersion(versionsData, versionTreedata, def);
            }
          } else {
            def.reject();
            console.log(
              '%c  cannot get version number ',
              'background: #f00; color: #fff'
            );
          }
        },
        function() {
          def.reject();
          console.log(
            '%c  cannot get version number ',
            'background: #f00; color: #fff'
          );
        }
      );

      return def.promise;
    }

    return {
      VersionsFactory: VersionsFactory,
      getVersions: getVersions,
    };
  };
  VersionsFactory.$inject = ['$http', '$q'];
  return VersionsFactory;
});


define('modules/common/directives/navGroup',[],function() {
  var navGroup = function($location) {
    return {
      restrict: 'EA',
      scope: {
        checkpath: '=',
        infos: '=groupinfos',
      },
      link: function($scope, element, attrs) {
        $scope.isCollapsed = true;

        var groupLi = angular.element(element[0].querySelector('.group'));

        groupLi.on('click', function() {
          groupLi.removeClass('active');
          if (!$scope.isCollapsed) {
            groupLi.addClass('active');
          }
        });

        var search = $location.url().split('?');
        $scope.urlParameters = '';
        if (search.length > 1) {
          $scope.urlParameters = '?' + search[1];
        }

        $scope.main_title = $scope.infos.main_title;
        $scope.icon = $scope.infos.icon;
        $scope.subs = $scope.infos.subs;

        // checks if the group needs to be opened
        $scope.activeSub = false;
        $scope.subs.forEach(function(sub) {
          if ($scope.checkpath('/' + sub.target + '/')) {
            $scope.activeSub = true;
            //$scope.isCollapsed = false;
          }
          $scope.isCollapsed = false;
        });

        /**
         * get sub link, nothing if disabled
         * @param sub
         * @returns {string}
         */
        $scope.getSubLink = function(sub) {
          return sub.disabled
            ? ''
            : '#' + sub.target + '' + $scope.urlParameters;
        };
        $scope.showGroup = function(subs) {
          return subs.findIndex(item => item.visible == true)!=-1;
        };
      },
      templateUrl: 'js/XG/modules/common/views/navGroup.html',
    };
  };

  navGroup.$inject = ['$location'];
  return navGroup;
});


define('modules/common/directives/applicationLogo',[],function() {
  var applicationLogo = function() {
    return {
      restrict: 'EA',
      scope: {
        width: '=',
        height: '=',
      },
      template: '<div style="width: {{width}}px; height: {{height}}px;" class="application_logo"></div>',
      link: function() {
      },
    };
  };

  applicationLogo.$inject = [];
  return applicationLogo;
});


define('modules/common/directives/submitLoad',[],function() {
  var submitLoad = function() {
    return {
      scope: {
        submitLoad: '&',
      },
      link: function(scope, form, iAttrs) {
        form.bind('submit', function() {
          var submitButton = angular.element(form[0].querySelector('.submit'));

          form.addClass('processing');
          submitButton.prop('disabled', true);

          scope.submitLoad().then(
            function() {
              form.removeClass('processing');
              submitButton.prop('disabled', false);
            },
            function() {
              form.removeClass('processing');
              submitButton.prop('disabled', false);
            }
          );
        });
      },
    };
  };

  submitLoad.$inject = [];
  return submitLoad;
});


define('modules/common/directives/dualListBox',['toastr'],function() {
  /**
   * DualListBox Directive
   * Provides two listBox with drag&drop functionnality
   */

  var dualListGroup = function($filter, gaJsUtils, $timeout) {
    return {
      restrict: 'A',
      scope: {
        data: '=',
        addfilters: '=?',
        noSortLeft: '=?',
        noSortRight: '=?',
        afterMoveItem: '&?',
        afterMoveItems: '&?',
        // on-change: is called when data change
        // exemple-> on-change="myfunction(myparam)"
        onChange: '&?'
      },
      link: function(scope, elt) {
        // Instanciate both data lists as array if needed
        if (!scope.data) {
          scope.data = {};
        }
        if (!angular.isArray(scope.data.leftData)) {
          scope.data.leftData = [];
        }
        if (!angular.isArray(scope.data.rightData)) {
          scope.data.rightData = [];
        }
        if(!scope.filter){
          scope.filter = {};
        }

        // ajoute une classe tabs à la div principale du template html
        // permet d'appliquer du css spécifique aux dualListBox qui contiennent des tabs
        scope.hasTabs
          = Object.prototype.hasOwnProperty.call(
            scope.data, 'tabs') && typeof scope.data.tabs === 'string';

        function checkSourceAgainstSelected() {
          /*
                 If a source is provided,
                 the data from that side cannot contain data from the other side
                 ex: usersGroups-groups, groups is the source and cannot contain
                 data from userGroups
                 */
          if (angular.isDefined(scope.data.source)) {
            const source =
              scope.data.source === 'left'
                ? scope.data.leftData
                : scope.data.rightData;
            const destination =
              scope.data.source === 'left'
                ? scope.data.rightData
                : scope.data.leftData;

            destination.forEach(function(d) {
              source.forEach(function(s, i) {
                /*
                  TODO: Should be the right way!
                  TODO: Didnt work while comparing groups cause
                  TODO: users.groups has no linked roles, whereas scope.resources.groups does!
                  if(angular.equals(s, d)){
                      source.splice(i,1);
                  }*/
                if (s.uid == undefined || d.uid == undefined) {
                  if (angular.equals(s, d)) {
                    source.splice(i, 1);
                  }
                } else if (s.uid == d.uid) {
                  source.splice(i, 1);
                }
              });
            });
          }
        }

        /**
         * Drop Success Handler
         * Remove index from array
         *
         * @param $event
         * @param index rang de l'élement glissé/déposé dans le tableau d'origine
         * @param array tableau d'origine de l'élément glissé/déposé
         * @param fromSide côté d'origine de l'élément glissé/déposé
         *  (ex. 'left' pour un élément glissé de la gauche vers la droite)
         */
        scope.dropSuccessHandler = function($event, index, array) {

          if (!scope.data.disableDragFromRight) {
            array.splice(index, 1);
          }
          else if (!~scope.data.disableDragFromRight.indexOf(array[index][scope.data.keytocheck])) {
            array.splice(index, 1);
          }
          // après drop d'un élément, exécute une méthode du composant parent
          // si celui-ci doit agir sur cet évènement (ex. setRemoteAttribute)
          if (scope.afterMoveItem && typeof scope.afterMoveItem === 'function') {
            $timeout(scope.afterMoveItem());
          }
        };

        scope.moveItem = (array, index, direction) => {
          gaJsUtils.moveElementInArray(array, index, direction);
        };
        scope.isFirstItem = (index) => {
          return index === 0;
        };
        scope.isLastItem = (array, index) => {
          return index === array.length -1;
        };

        /**
         * Gère le dépôt d'un élément ($data) dans un tableau cible spécifié.
         *
         * @param {Event} $event - L'événement de dépôt déclenché par l'interaction utilisateur.
         * @param {Object} $data - L'objet de données qui est déposé.
         * @param {Array} array - Le tableau cible dans lequel les données doivent être ajoutées.
         * @param {boolean} fromLeft - Indique si les données proviennent de la liste de gauche.
         */
        scope.onDrop = function($event, $data, array, fromLeft) {
          $timeout(() => {
            // Détermine le filtre cible et vérifie s'il est actif (utilisé pour filtrer les données)
            const targetFilter = fromLeft ? scope.filter.rightFilter : scope.filter.leftFilter;
            const isTargetFiltered = fromLeft ? typeof targetFilter === 'string' && targetFilter.length > 0 : false;

            // S'assure que le tableau cible est bien un tableau ; l'initialise si ce n'est pas le cas
            if(!angular.isArray(array)){
              array = [];
            }

            // Si le déplacement depuis la liste de droite n'est pas désactivé :
            if (!scope.data.disableDragFromRight) {
              // Vérifie si l'objet $data n'existe pas déjà dans le tableau cible
              if (!array.some(el => el.name === $data.name)) {
                // Ajoute l'objet $data au tableau cible
                array.push($data);

                // Si un filtre est actif sur la cible, met à jour les données sauvegardées
                if (isTargetFiltered) {
                  updateBackupData($data, fromLeft);
                }
              }
            }else {
              // Si le déplacement depuis la liste de droite est désactivé pour cet élément spécifique :
              if (~scope.data.disableDragFromRight.indexOf($data[scope.data.keytocheck])) {
                // Affiche un avertissement si l'élément est interdit de déplacement
                require('toastr').warning(
                  $filter('translate')('hpo.model.calage.required')
                );
              } else {
                // Sinon, ajoute l'objet $data au tableau cible s'il n'existe pas déjà
                if (!array.some(el => el.name === $data.name)) {
                  array.push($data);
                  // Met à jour les données sauvegardées si un filtre est actif
                  if (isTargetFiltered) {
                    updateBackupData($data, fromLeft);
                  }
                }
              }
            }

            // Si on est pas dans le cas d'une fiche-objet avec onglets
            if (!gaJsUtils.notNullAndDefined(scope.data.tabs)) {
              $timeout(() => {
                // Supprime l'élément $data de la liste source (gauche ou droite)
                const sourceList = fromLeft ? scope.data.leftData : scope.data.rightData;
                const indexInSource = sourceList.findIndex(el => el.name === $data.name);
                if (indexInSource >= 0) {
                  sourceList.splice(indexInSource, 1);
                }
              });
            }

            // Trie la liste cible si le tri automatique est activé pour cette direction
            if((!fromLeft && !scope.noSortLeft) || (fromLeft && !scope.noSortRight)){
              gaJsUtils.sortDataByNameIgnoreCase(array);
            }
            if (typeof scope.onChange === 'function') {
              // call the function on next $apply to make
              // sure the ng-model has been updated
              $timeout(scope.onChange);
            }
          })
        };

        let setleftBackupData = () => {
          if(scope.data.tabs === 'left'){
            if(!scope.data.leftBackupData){
              scope.data.leftBackupData = [];
            }
            for(let i=0;i<scope.data.leftData.length;i++){
              scope.data.leftBackupData[i] = scope.data.leftData[i].fields;
            }
          }else{
            scope.data.leftBackupData = scope.data.leftData;
          }
        }

        /**
         * Met à jour les données de sauvegarde en déplaçant un élément d'un côté à l'autre.
         * La méthode identifie de quel côté (gauche ou droit) provient l'élément donné,
         * le retire de sa liste d'origine et l'ajoute à la liste cible opposée.
         *
         * @param {Object} droppedElement - L'élément à déplacer entre les listes de sauvegarde.
         * @param {Object} fromLeft - true quand l'élement provient de la liste de gauche
         */
        const updateBackupData = (droppedElement, fromLeft) => {

          // Détermine la liste source (d'où provient l'élément) et la liste cible (où il doit aller)
          const sourceSideList = fromLeft ? scope.data.leftBackupData : scope.data.rightBackupData;
          const targetSideList = fromLeft ? scope.data.rightBackupData : scope.data.leftBackupData;

          // Ajoute l'élément à la liste cible
          targetSideList.push(droppedElement);

          // Trouve l'index de l'élément dans la liste source
          const index = sourceSideList.findIndex(att => att.name === droppedElement.name);


          // Si l'élément existe dans la liste source, le supprime de cette liste
          if (index >= 0) {
            sourceSideList.splice(index, 1);
          }
          gaJsUtils.sortDataByNameIgnoreCase(targetSideList);
        };

        scope.$on('setDualListBoxContent', function(event, params) {
          if (params.id === scope.data.id) {
            if (params.leftData) {
              scope.data.leftData = params.leftData;
              setleftBackupData();
            }
            if (params.rightData) {
              scope.data.rightData = params.rightData;
              scope.data.rightBackupData = params.rightData;
            }
            checkSourceAgainstSelected();
            if (params.tellItIsDone)
              params.tellItIsDone.done = true;
          }
        });

        scope.$on('initFilter', () => {
          if(angular.isDefined(scope.filter.rightFilter)){
            scope.filter.rightFilter = "";
            scope.filterBox(scope.filter.rightFilter, false);
          }
          if(angular.isDefined(scope.filter.leftFilter)){
            scope.filter.leftFilter = "";
            scope.filterBox(scope.filter.leftFilter, true);
          }
        });

        checkSourceAgainstSelected();

        /**
         * En cas d'actualisation des données d'entrée de la dual-list-box,
         * prépare les données de backup pour faire fonctionner le filtre
         * et enlève les doublons si "removeDuplicates"
         */
        const onChangeData = () => {
          if(scope.data.removeDuplicates && scope.data.rightData && scope.data.leftData) {
            for (const leftElement of scope.data.leftData) {
              for (let i=scope.data.rightData.length-1; i>=0; i--) {
                if(leftElement[scope.data.leftDisplayAttribute] ===
                    scope.data.rightData[i][scope.data.rightDisplayAttribute]) {
                  scope.data.rightData.splice(i, 1);
                }
              }
            }
          }
          if (scope.addfilters) {
            scope.data.rightBackupData = scope.data.rightData;
            setleftBackupData();
          }
        };
        // Préparation des données à l'initialisation
        onChangeData();
        // Broadcast à utiliser lorsque l'on change les données de la directive déjà chargée
        scope.$on('changeDualListBoxData', onChangeData);

        /**
         * Filtre la liste de données (partie gauche ou droite) en fonction de la saisie dans un champ de filtre.
         * Si l'input de filtre est vide, réinitialise les données à leur état original.
         * @param {string} filterValue - Valeur saisie dans le champ de filtre
         * @param {boolean} isLeftData - Indique si le filtre s'applique à la partie gauche (true) ou droite (false)
         */
        scope.filterBox = (filterValue, isLeftData) => {
          if (isLeftData) { // Cas où le filtre s'applique à la partie gauche
            if(scope.data.tabs === 'left') {
              // Filtre chaque champ de 'leftData' individuellement si l'onglet actuel est 'left'
              for(let i=0; i<scope.data.leftData.length; i++) {
                scope.data.leftData[i].fields = filterList(scope.data.leftBackupData[i], filterValue, isLeftData, scope.data.rightData);
              }
            } else {
              // Filtre globalement la liste 'leftData' si les onglets ne portent pas sur la partie gauche ('left')
              scope.data.leftData = filterList(scope.data.leftBackupData, filterValue, isLeftData, scope.data.rightData);
            }
          } else {
            // Cas où le filtre s'applique à la partie droite
            const hasTabs = typeof scope.data.tabs === 'string' && scope.data.tabs.length > 0;
            const elementsToExclude = hasTabs ? scope.data.leftData.flatMap(tab => tab.fields) : scope.data.leftData;
            scope.data.rightData = filterList(scope.data.rightBackupData, filterValue, isLeftData, elementsToExclude);
          }
        };

        /**
         * Filtre la liste en entrée et renvoie une liste d'objets ayant une propriété 'name'
         * contenant la string filtervalue en paramètre
         * @param list liste d'objets à filtrer où chaque élément comporte une propriété 'name'
         * @param filterValue string qui doit être contenu dans la propriété 'name' de tous les éléments de la liste de sortie
         * @param isLeftData true quand filtervalue est saisi dans l'input du filtre de la partie gauche de la dualList
         * @param elementsToExclude objets déjà présents dans la liste opposée à ne pas proposer dans la liste filtrée
         * @return {[string]} objets ayant une propriété 'name' contenant la string filtervalue en paramètre
         */
        const filterList = (list, filterValue, isLeftData, elementsToExclude = []) => {
          let attribute;
          if (angular.isDefined(isLeftData)) {
            if (isLeftData) {
              attribute = scope.data.leftDisplayAttribute ? scope.data.leftDisplayAttribute : 'name';
            } else {
              attribute = scope.data.rightDisplayAttribute ? scope.data.rightDisplayAttribute : 'name';
            }
          } else {
            attribute = 'name';
          }
          const excluded = elementsToExclude.length > 0 ? elementsToExclude.map(el => el[attribute].toLowerCase()) : [];
          return list.filter(el => !excluded.includes(el[attribute].toLowerCase())
                  && (filterValue.length === 0 || (filterValue.length > 0
                      && el[attribute].toLowerCase().includes(filterValue.toLowerCase()))));
        };

        /**
         * Au clic sur le bouton flèche gauche/droite
         * déplace toutes les valeurs d'une liste à une autre.
         * @param fromLeft est true au clic sur le bouton de la flèche vers la droite
         */
        scope.moveAllItems = (fromLeft) => {
          const source = fromLeft ? 'leftData' : 'rightData';
          const target = fromLeft ? 'rightData' : 'leftData';

          if(scope.data.tabs === 'left'){
            if(fromLeft){
              scope.data[target].push(...scope.data[source][scope.data.activeTab].fields)
            }else{
              scope.data[target][scope.data.activeTab].fields.push(...scope.data[source]);
            }
          }else{
            scope.data[target].push(...scope.data[source]);
          }

          // au clic sur la flèche pour tout ajouter/enlever, envoie un évènement au composant parent si celui-ci doit agir sur cet évènement (ex. setRemoteAttribute)
          if (scope.afterMoveItems && typeof scope.afterMoveItems === 'function') {
            scope.afterMoveItems();
          }

          // pour ne pas perdre le passage en référence des variable il faut pas faire scope.data[source] = []
          if(scope.data.tabs === 'left' && fromLeft &&
            Array.isArray(scope.data[source][scope.data.activeTab].fields) &&
            scope.data[source][scope.data.activeTab].fields.length>0){
            scope.data[source][scope.data.activeTab].fields.length = 0;
          }else if(Array.isArray(scope.data[source]) && scope.data[source].length>0){
            scope.data[source].length = 0;
          }
          if (typeof scope.onChange === 'function') {
            // call the function on next $apply to make
            // sure the ng-model has been updated
            $timeout(scope.onChange);
          }
        };

        if(!scope.noSortLeft){
          gaJsUtils.sortDataByNameIgnoreCase(scope.data.leftData);
        }
        if(!scope.noSortRight){
          gaJsUtils.sortDataByNameIgnoreCase(scope.data.rightData);
        }

        /**
         * cette methode ajoute un onglet aux listBox gauche
         */
        scope.addTabsToBranch = () => {
          if (angular.isUndefined(scope.data.leftData))
            scope.data.leftData = [];
          scope.data.leftData.push({
            title: $filter('translate')(
              'tools.builder.form.tabs.default_title'
            ),
            fields: [],
          });
          setleftBackupData();
          if (scope.data.leftData.length === 1) {
            scope.data.activeTab = 0;
          }

          // surveille le nombre d'onglets pour ajuster la position des parties gauche/milieu/droite et la hauteur du conteneur
          // la hauteur d'une titre d'onglet est de 41px
          adjustDualListBoxMarginTop();
        };

        /**
         * Au clic sur le bouton "Cliquer pour éditer" ou sur le bouton "Valider" (coche),
         * cette methode change entre le mode edition et le mode classique (0 ou 1)
         * @param {number} mode
         */
        scope.toggleTabEditMode = (mode) => {
          scope.editMode = mode;
        };
        /**
         * Au clic sur le bouton supprimer un onglet (croix rouge),<ul><li>
         * supprime l'onglet de la partie gauche</li><li>
         * attend la prochaine frame et ajuste la position verticale des 3 parties et la hauteur du conteneur
         * @param {number} index rang de l'onglet dans le tableau d'onglets
         */
        scope.removeTab = (index) => {
          const tabFields = scope.data.leftData[index].fields;

          // KIS-3332: quand je supprime un onglet alors je dois retrouver les attributs de l’onglet dans la liste des attributs disponibles
          if (Array.isArray(tabFields) && tabFields.length > 0) {
            scope.data.rightData.push(...scope.data.leftData[index].fields);
            gaJsUtils.sortDataByNameIgnoreCase(scope.data.rightData);
            for (const field of tabFields) {
              if (!scope.data.rightBackupData.find(field => field.name === field.name)) {
                scope.data.rightBackupData.push(field);
              }
            }
            gaJsUtils.sortDataByNameIgnoreCase(scope.data.rightBackupData);
          }

          scope.data.leftData.splice(index, 1);

          // surveille le nombre d'onglets pour ajuster la position des parties gauche/milieu/droite et la hauteur du conteneur
          // la hauteur d'une titre d'onglet est de 41px
          adjustDualListBoxMarginTop();
        };
        scope.switchedTab = -1;

        /**
         * cette methode permet de modifier la position des onglets
         */
        scope.moveTab = (index, direction) => {
          if (
            (index === 0 && direction === 'left') ||
            (index === scope.data.leftData.length - 1 && direction === 'right')
          )
            return false;
          var newTabs = angular.copy(scope.data.leftData),
            newIndex = direction === 'left' ? index - 1 : index + 1;
          newTabs.splice(index, 0, newTabs.splice(newIndex, 1)[0]);
          scope.data.leftData = newTabs;
          scope.switchedTab = newIndex;

          // KIS-336: actualise la propriété margin-top
          adjustDualListBoxMarginTop();

          // KIS-3340: le déplacement d'un onglet doit garder le focus sur cet onglet
          $timeout(() => {
            scope.data.activeTab = newIndex;
          });
        };

        /**
         * Au clic sur le bouton "Ajouter un onglet" et au clic sur le bouton "Supprimer un onglet",
         * lorsque une ligne de titre d'onglets est ajoutée/supprimée:<ul><li>
         * modifie la position verticale des parties gauche et droite</li><li>
         * modifie la position verticale des flèches gauche/droite dans la partie du milieu</li><li>
         * modifie la hauteur du conteneur commun des parties gauche/milieu/droit
         * KIS-2987
         */
        const adjustDualListBoxMarginTop = () => {
          $timeout(() => {
            if (elt && elt[0]) {

              // conteneur des onglets
              const tabsContainer = elt[0].querySelector('.nav.nav-tabs');

              if (tabsContainer) {

                // méthode interne qui modifie la propriété marginBottom ou marginTop du style de l'élément
                const modifyElementStyle = (style, marginSide) => {
                  const marginValue = (scope.tabsLineCount -1) * tabLineHeight;
                  const marginProperty = 'margin' + marginSide[0].toUpperCase() + marginSide.substring(1);
                  style[marginProperty] = marginValue + 'px';
                };

                // évalue la hauteur du conteneur des onglets
                scope.tabsLineCount = Math.round(tabsContainer.clientHeight / tabLineHeight);

                // liste de la partie gauche de chaque onglet
                const leftListsContainer = tabsContainer.nextSibling;
                const leftLists = leftListsContainer.querySelectorAll('.list');

                if (leftLists) {
                  for (const leftList of leftLists) {
                    // modifie la position verticale de la liste de gauche (div absolute)
                    modifyElementStyle(leftList.style, 'top');
                  }
                }

                // conteneur des parties gauche et droite:
                const dualListContainer = tabsContainer.closest('.dualListBox');

                // agrandissement/rétrécissement de la hauteur
                if (dualListContainer) {
                  modifyElementStyle(dualListContainer.style, 'bottom');

                  // liste de la partie droite
                  // modifie la position verticale de la liste de droite (div absolute)
                  const rightList = dualListContainer.querySelector('.right-part .list');
                  if (rightList) {
                    modifyElementStyle(rightList.style, 'top');
                  }

                  // partie du milieu: flèches gauche/droite
                  // modifie la position verticale de la partie du milieu (div absolute)
                  const middlePart = dualListContainer.querySelector('.middle-part');
                  if (middlePart) {
                    modifyElementStyle(middlePart.style, 'top');
                  }

                  // filtres de texte
                  // modifie la position verticale des filtres
                  const filters = dualListContainer.querySelectorAll('.dualListBox-filters');
                  if (filters) {
                    for (const filterElement of filters) {
                      modifyElementStyle(filterElement.style, 'top');
                    }
                  }
                }
              }
            }
          });
        };

        /**
         * Evalue si la liste de la partie gauche et la liste de la partie droite sont situées à la même position verticale
         * @param {HTMLElement} tabsContainer conteneur des lignes de titres d'onglets
         * @return {boolean} true si la partie gauche et la liste de la partie droite sont situées à la même position verticale
         * KIS-2987
         */
        const leftAndRightPartHasSameVerticalPosition = (tabsContainer) => {
          const dualListContainer = tabsContainer.closest('.dualListBox');
          if (dualListContainer) {
            const leftList = dualListContainer.querySelector('.left-part .list');
            const rightList = dualListContainer.querySelector('.right-part .list');
            if (leftList && rightList) {
              return leftList.offsetTop === rightList.offsetTop;
            } else {
              // attend la prochaine frame pour l'affichage des listes
              $timeout(() => {
                leftAndRightPartHasSameVerticalPosition(tabsContainer);
              });
            }
          } else {
            $timeout(() => {
              // attend la prochaine frame pour l'affichage de la dualListBox
              leftAndRightPartHasSameVerticalPosition(tabsContainer);
            });
          }
        };

        /**
         * Effectue le décompte du nombre de lignes de titres d'onglets
         * Si la popup contient plus d'1 ligne d'onglets alors
         * on décale les listes des parties gauche et droite, la partie du milieu
         * et on agrandit la hauteur du conteneur de la dualistbox
         * @param {HTMLElement} tabsContainer conteneur des lignes de titres d'onglets
         * KIS-2987
         */
        const initDualListBoxOffset = (tabsContainer = null) => {
          if (scope.hasTabs && elt && elt[0]) {
            if (!tabsContainer) {
              tabsContainer = elt[0].querySelector('.nav.nav-tabs');
            }
            if (tabsContainer) {

              if (leftAndRightPartHasSameVerticalPosition(tabsContainer)) {

                // hauteur d'une ligne de titres d'onglets
                adjustDualListBoxMarginTop();
              } else {

                // attend que l'affichage de la popup tienne compte de la position absolute des div de la dualListBox
                $timeout(() => {
                  initDualListBoxOffset(tabsContainer);
                });
              }
            } else {
              // si la dualListBox n'est pas encore affiché on attend la frame suivante
              $timeout(() => {
                initDualListBoxOffset();
              });
            }
          }
        };

        // Hauteur d'une ligne d'onglets
        // base de calcul de la propriété margin-top des parties gauche/droite
        const tabLineHeight = 41;

        // Dès l'initialisation, effectue le décompte du nombre de lignes de titres d'onglets
        initDualListBoxOffset();

      },
      templateUrl: 'js/XG/modules/common/views/directives/dualListBox.html',
    };
  };

  dualListGroup.$inject = ['$filter', 'gaJsUtils', '$timeout'];
  return dualListGroup;
});


/**
 * Simple list / edit / add / remove list from a json list of elements **Note:**
 * an object editListCfg must be declared in parent scope.<br/> if not, the
 * directive needs configuration object to be passed through data-cfg attribute
 *
 * <pre>
 * &lt;div edit-list data-cfg=&quot;myCfgObject&quot;&gt;&lt;/div&gt;
 * </pre>
 */
define('modules/common/directives/editList',['toastr','toastr','toastr','toastr','toastr'],function() {
  var editList = function(
    ngTableParams,
    ngDialog,
    $rootScope,
    FeatureTypeFactory,
    gaJsUtils,
    $filter,
    InitProvider,
    PortalsFactory,
    gaDomUtils
  ) {
    return {
      restrict: 'A',
      link: function(scope, elem, attrs) {
        if (
          InitProvider &&
          InitProvider.getHpoConfig &&
          InitProvider.getHpoConfig() &&
          InitProvider.getHpoConfig().datastoreuid
        )
          scope.specialHpoAppUid = InitProvider.getHpoConfig().datastoreuid;

        scope.case = { sensitivity: 0 };
        scope.criterias = {};
        scope.searchMode = false;
        scope.svgPage = 1;
        scope.oldcopy = {};

        scope.$watch('currentResources', () => {
          scope.countLength();
        });

        /** display / hide full list when search mode is activated * */
        scope.toggleSearchMode = () => {
          scope.searchMode = !scope.searchMode;
          scope.$emit('searchModeChange',{name:scope.editListCfg.name, searchMode:scope.searchMode});
          scope.criterias = {};
          if (scope.searchMode) {
            scope.svgPage = scope.tableParams.page();
            scope.tableParams.count(scope.tableParams.total());
          } else {
            scope.tableParams.count(_tableParams.count);
            scope.tableParams.page(scope.svgPage);
          }
        };
        /**
         * Sorte les roles , cette focntion peut etre utilisé pour tous les
         * autres
         */
        scope.sortRoles = function() {
          if (scope.editListCfg.resource_type == 'roles') {
            scope.currentResources.sort(function(a, b) {
              var x = a.name.toLowerCase();
              var y = b.name.toLowerCase();
              if (x < y) {
                return -1;
              }
              if (x > y) {
                return 1;
              }
              return 0;
            });
          }
        };

        /**
         * Cancel whatever may be currently selected
         */
        const cancelCurrentSelection = function() {
          if (scope.currentResources) {
            scope.currentResources.forEach(function(x) {
              x.$selected = false;
            });
          }
          scope.selected_resource = null;
          scope.selected_resource_index = -1;
          scope.edit_resource = null;
        };

        /**
         * Edit list filter (search button)
         *
         * @param criterias
         * @returns {Function}
         */
        scope.editListFilter = (criterias) => {
          return (item) => {
            let showItem = true;
            for (let c in criterias) {
              let cmp = '';
              if (item.hasOwnProperty(c) && item[c] !== '' && new Date(item[c]) !== 'Invalid Date') {
                cmp = $filter('date')(item[c], gaJsUtils.getLocaleDateString());
              } else {
              // cast as string or indexOf will throw an error
                cmp += item[c];
              }
              let compareValue = angular.copy(criterias[c]);

              if (!scope.case.sensitivity) {
                cmp = cmp.toLowerCase();
                compareValue = compareValue.toLowerCase();
              }

              if (!item.hasOwnProperty(c) || cmp.indexOf(compareValue) == -1) {
                showItem = false;
              }
            }
            return showItem;
          };
        };
        
        scope.countLength = () => {
          if(scope.currentResources){
            scope.countRessourcesLength = scope.currentResources.filter(scope.editListFilter(scope.criterias)).length;
          }
        }

        var renderTitleEditListCfg = function() {
          scope.editListCfg.titleCol = [];
          scope.editListCfg.cols.forEach(function(colname) {
            scope.editListCfg.titleCol.push(
              scope.editListCfg.dataModule +
                '.' +
                scope.editListCfg.resource_type +
                '.' +
                colname
            );
          });
        };

        /*
         * Configuration
         */

        if (scope.editListCfg && scope.editListCfg.notPagination) {
          var _tableParams = {
            filter: {
              name: 'M',
            },
            count: 1,
            page: 1,
          };
        } else {
          _tableParams = {
            page: 1,
            count: 50,
            filter: {
              name: 'M',
            },
          };
        }

        cancelCurrentSelection();
        /*
         * By default, the directive configuration is inherited from the
         * parentscope which must contain an editListCfg object But if another
         * object is passed from the data-cfg attribute, this one will be used
         */

        if (
          angular.isDefined(scope.editListCfg) &&
          angular.isDefined(scope.editListCfg.dataModule) &&
          angular.isDefined(scope.editListCfg.resource_type) &&
          angular.isDefined(scope.editListCfg.cols) &&
          scope.editListCfg.cols.length > 0
        ) {
          renderTitleEditListCfg();
        }

        if (attrs.cfg) {
          scope.editListCfg = scope[attrs.cfg];

          /*
          set the currentResources to be the one provided by the the cfg object
          if the object provided is undefined, we set it a new empty array
          */
          if (
            scope[attrs.cfg] &&
            scope[attrs.cfg].hasOwnProperty('currentResources')
          ) {
            scope.currentResources = scope[attrs.cfg].currentResources;
          }
          // force the table reset
          scope.resetTable = true;
        }

        if (angular.isUndefined(scope.editListCfg)) {
          scope.editListCfg = {};
        }
        if (angular.isUndefined(scope.editListCfg.addResourceButton)) {
          scope.editListCfg.addResourceButton = true;
        }

        if (angular.isUndefined(scope.editListCfg.deleteResourceButton)) {
          scope.editListCfg.deleteResourceButton = true;
        }

        scope.displayWarning = false;

        // when the object is ready, display it
        if (angular.isDefined(scope.editListCfg.warning)) {
          var deregwarning = scope.$watch(
            scope.editListCfg.warning,
            function(warning) {
              if (angular.isDefined(warning)) {
                scope.editListCfg.warning = warning;
                scope.displayWarning = true;
                deregwarning();
              }
            },
            1
          );
        }

        /**
         * Display the resources in a table
         */
        scope.setTable = function() {
          var data = scope.currentResources;

          if (scope.editListCfg.notPagination) {
            scope.tableParams = new ngTableParams(_tableParams, {
              total: data.length,
              counts: [],
              getData: function($defer, params) {
                data = scope.currentResources;
                if (data.code == 403) {
                  var errorMsg = '<h4>Erreur 403</h4> ';
                  errorMsg += '<br/><h4>Details</h4>';
                  errorMsg += '<br/>' + data.message;
                  require('toastr').error(errorMsg);
                } else {
                  $defer.resolve(
                    data.slice(
                      (params.page() - 1) * params.count(),
                      params.page() * params.count()
                    )
                  );

                  if (params.page() != 1 && data.length == params.count()) {
                    params.page(1);
                    scope.tableParams.reload();
                  }
                }
              },
            });
          } else {
            scope.tableParams = new ngTableParams(_tableParams, {
              total: data.length,
              getData: function($defer, params) {
                data = scope.currentResources;
                if (data.code == 403) {
                  var errorMsg = '<h4>Erreur 403</h4> ';
                  errorMsg += '<br/><h4>Details</h4>';
                  errorMsg += '<br/>' + data.message;
                  require('toastr').error(errorMsg);
                } else {
                  $defer.resolve(
                    data.slice(
                      (params.page() - 1) * params.count(),
                      params.page() * params.count()
                    )
                  );

                  if (params.page() != 1 && data.length == params.count()) {
                    params.page(1);
                  }
                }
              },
            });
          }

          // HOTFIX from https://github.com/esvit/ng-table/issues/297
          scope.tableParams.settings().$scope = scope;
        };

        /**
         * Returns the object to edit which is an empty js object if no
         * defaultValues are set
         *
         * @returns {{}}
         */
        scope.getDefautEditResource = function() {
          var defautResource = {};

          // if some default values are set
          if (scope.editListCfg.defautValues) {
            scope.editListCfg.defautValues.forEach(function(df) {
              defautResource[df.k] = angular.copy(df.v);
            });
          }
          return defautResource;
        };

        /**
         * Edit Resource Modal
         *
         * @param isNew
         */
        var cDialog;
        scope.edit_modal = function(isNew, c, copy) {
          if (copy) {
            scope.editModalIsNew = copy;
            cDialog = ngDialog.open({
              template:
                'js/XG/modules/' +
                scope.editListCfg.dataModule +
                '/views/modals/modal.' +
                scope.editListCfg.resource_type +
                '.html',
              className:
                'ngdialog-theme-plain ' +
                (scope.editListCfg.width || 'width800'),
              closeByDocument: false,
              closeByEscape: false,
              scope: scope,
            });
          } else {
            scope.duplicate =false;
            if (angular.isDefined(scope.editListCfg.restrictAdd)) {
              if (scope.editListCfg.restrictAdd.condition) {
                require('toastr').error(
                  $filter('translate')(scope.editListCfg.restrictAdd.message)
                );
                return;
              }
            }

            scope.editModalIsNew = isNew;
            // force reset

            // a specific add function was configured
            if (isNew && scope.editListCfg.addFunction) {
              scope.editListCfg.addFunction();
              return false;
            }
            if (!isNew && scope.editListCfg.editFunction) {
              scope.editListCfg.editFunction(scope.edit_resource);
              return false;
            }

            scope.isNewResource = isNew || false;
            if (isNew) {
              scope.selected_resource_index = -1;
              scope.edit_resource = scope.getDefautEditResource();
            }

            if (!isNew) {
              scope.oldcopy = angular.copy(scope.edit_resource);
            }

            if (
              isNew &&
              angular.isDefined(scope.cancreate) &&
              !scope.cancreate
            ) {
              console.log('licence cannot add app');
              scope.showAlertLicence();
            } else {
              cDialog = ngDialog.open({
                template:
                  'js/XG/modules/' +
                  scope.editListCfg.dataModule +
                  '/views/modals/modal.' +
                  scope.editListCfg.resource_type +
                  '.html',
                className:
                  'ngdialog-theme-plain ' +
                  (scope.editListCfg.width || 'width800'),
                closeByDocument: false,
                closeByEscape: false,
                scope: scope,
              });
            }
          }

          var deregNgDialog = $rootScope.$on('ngDialog.opened', function(
            e,
            $dialog
          ) {
            if (cDialog.id == $dialog.attr('id')) {
              // Brodcast the fact that the edit modal is loading
              scope.$emit('data_modal', {
                action: 'edit',
                editObject: {
                  name: scope.editListCfg.resource_name,
                  obj: scope.edit_resource,
                  index: scope.selected_resource_index,
                },
                isNew: isNew,
                dialog: $dialog,
                dialogObject: cDialog,
              });
              deregNgDialog();
            }
          });
        };

        $rootScope.$on('ngDialog.close.edit', function(e, $dialog) {
          cDialog.close();
        });

        /**
         * Delete Resource Modal
         *
         * @param type
         */
        var deleteModal;
        scope.delete_modal = () => {
          // Broadcast the fact that the delete modal is loading
          scope.$emit('data_modal', {
            action: 'delete',
            editObject: {
              name: scope.editListCfg.resource_name,
              obj: scope.edit_resource,
              index: scope.selected_resource_index,
            },
          });

          // specific delete template
          if (scope.editListCfg.removeTemplate) {
            if (
              scope.editListCfg.removeTemplate ==
              'js/XG/modules/model/views/modals/modal.featuretypes.remove.html'
            ) {
              if (scope.edit_resource.uid) {
                FeatureTypeFactory.isfeatureindatabase(
                  scope.edit_resource.uid
                ).then(function(res) {
                  scope.edit_resource.isfeatureindatabase = res.data;
                });
              }
            }

            deleteModal = ngDialog.open({
              template: scope.editListCfg.removeTemplate,
              className: 'ngdialog-theme-plain',
              closeByDocument: false,
              scope: scope,
            });

            // else
          } else {
            deleteModal = ngDialog.open({
              template:
                'js/XG/modules/common/views/directives/editListDeleteModal.html',
              className: 'ngdialog-theme-plain',
              closeByDocument: false,
              scope: scope,
            });
          }
        };

        scope.delete_modal_multi = () => {
          if(scope.editListCfg.allowMultipleSelection){
            if (!scope.editListCfg.allowMultipleSelection.deleteTemplate) {
              return;
            }
            scope.isFeaturesInDatabase = false;  
            //Vérifie si au moins une des table séléctionnés existe en BD
            Object.keys(scope.multiResourceSelection).forEach((key) => {
              FeatureTypeFactory.isfeatureindatabase(key).then((res) => {
                if(res.data){
                  scope.isFeaturesInDatabase = true;
                  return;
                }
              })
            });
            deleteModal = ngDialog.open({
              template: scope.editListCfg.allowMultipleSelection.deleteTemplate,
              className: 'ngdialog-theme-plain',
              closeByDocument: false,
              scope: scope,
            });
          }else{
            deleteModal = ngDialog.open({
              template:
                'js/XG/modules/common/views/directives/editListDeleteModal.html',
              className: 'ngdialog-theme-plain',
              closeByDocument: false,
              scope: scope,
            });
          }
        };

        $rootScope.$on('ngDialog.closed', function(e, $dialog) {
          if (deleteModal && deleteModal.id == $dialog.attr('id')) {
            if (scope.tableParams) scope.tableParams.reload();
            else scope.setTable();
          }
          if (cDialog && cDialog.id == $dialog.attr('id')) {
            if (scope.tableParams) scope.tableParams.reload();
            else scope.setTable();
          }
        });

        scope.$on('reloadEditList', () => {
          scope.tableParams.reload();
        });

        scope.multiResourceSelection = {};
        scope.currentSelectionIsMultiple = false;

        const handleMultipleSelection = function(
          obj,
          key,
          alreadySelectedValue
        ) {
          if (alreadySelectedValue) {
            obj[alreadySelectedValue] = true;
          }
          if (obj[key]) {
            delete obj[key];
          } else {
            obj[key] = true;
          }
        };

        scope.AddOrInsertAttributeToFeatureType = function() {
          let index_resource = selectLineResource();
          if (index_resource != -1 && scope.editModalIsNew) {
            swal(
              {
                title: $filter('translate')('common.titleconfirmmsg'),
                type: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#DD6B55',
                confirmButtonText: $filter('translate')('common.yes'),
                cancelButtonText: $filter('translate')('common.no'),
                closeOnConfirm: true,
                closeOnClickOutside: false,
              },
              function(isConfirm) {
                gaDomUtils.showGlobalLoader();
                if (isConfirm) {
                  insertAttributeToFeatureType(index_resource);
                } else {
                  scope.addAttributeToFeatureType();
                }
                cDialog.close();
                gaDomUtils.hideGlobalLoaderAfterTimeout();
              }
            );
          } else {
            gaDomUtils.showGlobalLoader();
            scope.addAttributeToFeatureType();
            cDialog.close();
            gaDomUtils.hideGlobalLoaderAfterTimeout();
          }
        };

        var selectLineResource = function() {
          if(angular.isDefined(scope.selected_resource) && scope.selected_resource !=null)
            return scope.currentFeatureType.attributes.findIndex(item => item.name == scope.selected_resource.name);
          return -1;
          
        };

        // inserer le nouveau attribut à la position d'attribut sélectionner
        var insertAttributeToFeatureType = function(index_resource) {
          scope.currentFeatureType.attributes.splice(
            index_resource,
            0,
            scope.currentFeatureTypeAttribute
          );
        };

        /**
         * Ensure the user can select one line only
         *
         * @param resource
         * @param index
         * @param force
         */
        scope.selectresource = function(resource, index, force) {
          // MultiSelection via ctrlClicking a line
          let msCfg = scope.editListCfg.allowMultipleSelection || scope.editListCfg.allowMultipleSelectionAttribute;
          if (event.ctrlKey && msCfg) {
            let alreadySelectedValue =
              scope.selected_resource != null
                ? scope.selected_resource[msCfg.uniqueKey]
                : false;
            cancelCurrentSelection();
            handleMultipleSelection(
              scope.multiResourceSelection,
              resource[msCfg.uniqueKey],
              alreadySelectedValue
            );
            scope.multiResourceSelectionLength = Object.keys(scope.multiResourceSelection).length;
            scope.currentSelectionIsMultiple = scope.multiResourceSelectionLength > 1;

            if(scope.editListCfg.allowMultipleSelectionAttribute){
              scope.editListCfg.allowMultipleSelectionAttribute.multiResourceSelection = scope.multiResourceSelection;
              scope.deleteAttMultiConfirm = $filter('translate')('common.deleteMultiAttConfirm').replace(
                                            '$1',scope.multiResourceSelectionLength);
            }
            scope.deleteConfirm = $filter('translate')('common.deleteConfirmComponent').replace(
                                      '$1',scope.multiResourceSelectionLength);
            return;
          } else if(scope.editListCfg.allowMultipleSelectionAttribute) {
            scope.editListCfg.allowMultipleSelectionAttribute.multiResourceSelection = {};
          }

          scope.multiResourceSelection = {};
          scope.currentSelectionIsMultiple = false;

          force = force || false;
          if (typeof index == 'undefined') index = -1;

          if (resource.$selected == true && force) {
            cancelCurrentSelection();
          } else {
            cancelCurrentSelection();
            resource.$selected = true;
            scope.selected_resource = resource;
            scope.selected_resource_index = index;
            scope.edit_resource = angular.copy(resource);
            if (scope.editListCfg.resource_type ==='default_filters' || scope.editListCfg.resource_type ==='clauses'){
              scope.$emit('edit_resource', scope.edit_resource);
            }
          }
        };

        /**
         * unSelectAllResources
         */
        scope.unSelectAllResources = function() {
          console.log(scope.selected_resource_index);
        };

        /**
         * moveItem up and down when editListCfg.allowReorder==true
         *
         * @param index
         * @param direction
         * @returns {boolean}
         */
        scope.moveItem = (index, direction) => {
          if (
            (index == 0 &&
              scope.tableParams.page() == 1 &&
              direction == 'up') ||
            (index == scope.currentResources.length - 1 && direction == 'down')
          )
            return false;
          let newIndex = direction == 'up' ? fixIndexCaseManyPages(index) -1 : index + 1;

          scope.currentResources.splice(
            fixIndexCaseManyPages(index),
            0,
            scope.currentResources.splice(newIndex, 1)[0]
          );
          scope.editListCfg.saveChangedOrder();
        };
        scope.isFirstItem = (index) => {
          return index == 0 && scope.tableParams.page() == 1;
        };

        scope.isLastItem = (index) => {
          return fixIndexCaseManyPages(index) === scope.tableParams.total()-1;
        }

        let fixIndexCaseManyPages = (idx) => {
          if(scope.tableParams && idx != -1){
            return (scope.tableParams.page() - 1) * scope.tableParams.count() +idx;
          }else{
            return idx;
          }
        }

        /*
         * Set/Update the table when data changes
         */
        var resourcesLength = 0;

        scope.$watch(
          function() {
            scope.sortRoles();
            return scope.currentResources;
          },
          function(data) {
            if (typeof data != 'undefined') {
              var errorMsg = '';
              if (data == 'calendar_error') {
                scope.editListCfg.dontShowLength = true;
                errorMsg =
                  '<div>Plusieurs sources de données sont actives sur ce portail.<div>';
                errorMsg +=
                  '<br/><div>Veuillez activer le calendrier ce qui permettra de désigner une source de données principale.</div>';
                require('toastr').error(errorMsg);
              } else {
                if (
                  typeof scope.tableParams == 'undefined' ||
                  scope.resetTable
                ) {
                  scope.setTable();
                  scope.resetTable = false;
                }
                if (scope.currentResources.code == 403) {
                  errorMsg = '<h4>Erreur 403</h4> ';
                  errorMsg += '<br/><h4>Details</h4>';
                  errorMsg += '<br/>' + scope.currentResources.message;
                  require('toastr').error(errorMsg);
                } else if (scope.currentResources.length) {
                  scope.tableParams
                    .total(scope.currentResources.length)
                    .reload();

                  /*
                   * Select the resource that was just added If necessary,
                   * change the page
                   */
                  if (
                    scope.currentResources.length > resourcesLength &&
                    resourcesLength > 0 &&
                    data.length > 0 &&
                    !scope.editListCfg.skipSelectAfterAdding
                  ) {
                    scope.selectresource(data[data.length - 1], 1);
                    scope.tableParams.parameters({
                      page: Math.ceil(data.length / _tableParams.count),
                    });
                  }
                  resourcesLength = scope.currentResources.length;
                }
              }
            }
          },
          true
        );

        /**
         * render cols value
         *
         * @param value
         * @param colname
         * @returns {*}
         */
        scope.renderValue = function(value, colname) {
          if (value && value != '' && new Date(value) != 'Invalid Date') {
            value = $filter('date')(value, gaJsUtils.getLocaleDateString());
          }
          return value;
        };

        /**
         * add cols css
         *
         * @param colname
         * @returns {*}
         */
        scope.addColsCss = function(colname) {
          return scope.editListCfg.colsCss[0][colname];
        };

        /**
         * check display Rendu Col
         *
         * @param resource
         * @param colname
         * @returns {boolean}
         */
        scope.displayRenduCol = function(resource, colname) {  
          var res = false;
          if (
            scope.editListCfg &&
            scope.editListCfg.colsCss &&
            scope.editListCfg.colsCss[0] &&
            Object.keys(scope.editListCfg.colsCss[0])[0] == colname &&
            resource[colname] &&
            resource[colname] != ''
          ) {
            res = true;
          }
          return res;
        };

        scope.getPortalByApplicatio = function() {
          PortalsFactory.getPortalAndApps().then(function(res) {
          });
        };

        /**
         * Fonction dans le HTML pour basculer l'affichage des onglets dans le header de la table
         * @returns {boolean} true si le header contient des onglets
         * @see scope.editListCfg
         */
        scope.fixedHeaderTableHasTabs = () => {
          return scope.editListCfg && scope.editListCfg.extraFilterTabs !== undefined && scope.editListCfg.extraFilterTabs.length>0
        }

        let currSortData = {};

        scope.sortTable = (att) => {
          if (scope.editListCfg.sort){
            if (!scope.currentResources || !scope.currentResources.length) {
              return false;
            }

            let sortOrder = 'asc';
            if (currSortData.column === att) {
              if (currSortData.order === 'asc') {
                sortOrder = 'desc';
              }
              if (currSortData.order === 'desc') {
                sortOrder = null;
              }
            }
            currSortData.order = sortOrder;
            currSortData.column = att;
            scope.editListCfg.defaultSort = currSortData.column && currSortData.column !== ''
                ? currSortData.column : '';

            if (scope.editListCfg.defaultSort && currSortData.order) {
              const prefix = currSortData.order === 'asc' ? '+' : '-';
              scope.editListCfg.defaultSort = prefix + scope.editListCfg.defaultSort;
            }
            refreshTableToDisplaySort({column: currSortData.column, direction: currSortData.order});
          }
        };

        /**
         * Rafraîchit la table
         */
        const refreshTableToDisplaySort = (sorting) => {
          const sortingColumnName = sorting.column;
          // recherche l'en-tête de la colomne triée
          const htmlSortedTh = $('.fixTh').filter((index) => {
            if (index > 0 && index <= scope.editListCfg.cols.length) {
              // index > 0 évite de traiter le bouton filtre
              const attname = scope.editListCfg.cols[index - 1];
              // comme index >=1, 'index - 1' permet de commencer la lecture du tableau au début
              return attname === sortingColumnName;
            } else {
              return false;
            }
          });
          scope.sorting = sorting;
          scope.tableParams
          .reload();
        };

        scope.isSortAsc = (colname) => {
          return scope.sorting && scope.sorting.column === colname && scope.sorting.direction
              === 'asc';
        };
        scope.isSortDesc = (colname) => {
          return scope.sorting && scope.sorting.column === colname && scope.sorting.direction
              === 'desc';
        };
      },
      templateUrl: 'js/XG/modules/common/views/directives/editList.html',
    };
  };

  editList.$inject = [
    'ngTableParams',
    'ngDialog',
    '$rootScope',
    'FeatureTypeFactory',
    'gaJsUtils',
    '$filter',
    'InitProvider',
    'PortalsFactory',
    'gaDomUtils'
  ];
  return editList;
});

define('modules/common/directives/closeModaleButton',[],function() {
  /**
   * Modals close button (ngDialog)
   * @returns {{restrict: string, templateUrl: string}}
   */
  var closeModaleButton = function() {
    return {
      restrict: 'E',
      templateUrl:
        'js/XG/modules/common/views/directives/closeModaleButton.html',
    };
  };

  closeModaleButton.$inject = [];
  return closeModaleButton;
});


define('modules/common/directives/geocatalogueFilter',[],function() {
  /**
   *
   */
  var geocatalogueFilter = function(FeatureTypeFactory, extendedNgDialog, $filter) {
    return {
      restrict: 'AE',
      templateUrl:
        'js/XG/modules/common/views/directives/geocatalogueFilter.html',
      link: function($scope) {
        $scope.initFilterLayers = () => {
          if($scope.edit_resource && ($scope.geocatalogueNotFromApplication || $scope.appTypeIsMap())){
            $scope.grouplayers = {};
            $scope.hiddenPanels = {};
            $scope.allPanelHidden = false;
            $scope.subGroupChecked = {};
            $scope.groupChecked= {};
            FeatureTypeFactory.get(true).then((res) =>{
              res.forEach(layer=>{
                if(layer.geographic || $scope.geocatalogueNotFromApplication){
                  var themename =
                    layer.theme && layer.theme !== 'undefined' ? layer.theme : 'Default';
                  layer.theme = themename;
                  if (angular.isUndefined($scope.grouplayers[themename])) {
                    $scope.grouplayers[themename] = [];
                  }
                  $scope.grouplayers[themename].push({
                    "name": layer.name,
                    "alias": layer.alias,
                    "uid": layer.uid,
                    "srid": layer.srid?'['+layer.srid.split(":").pop()+']':''
                  });
                }
              })
              $scope.display = 'Alias'
              $scope.grouplayersName = Object.keys($scope.grouplayers);
              $scope.showAllPanels();
              if(!$scope.edit_resource.filterLayers){
                $scope.edit_resource.filterLayers = {};
              }
              if(!$scope.edit_resource.filterLayers.layers){
                $scope.edit_resource.filterLayers.layers = {};
              }
              if(!angular.isDefined($scope.edit_resource.filterLayers.useFilter)){
                $scope.edit_resource.filterLayers.useFilter = false;
              }
              if($scope.geocatalogueNotFromApplication){
                $scope.edit_resource.rightFeatures.forEach(feat =>{
                  $scope.edit_resource.filterLayers.layers[feat]=true;
                });
              }
              $scope.grouplayersName.forEach(group=>{
                $scope.groupIsChecked(group);
              });
              $scope.allGroupIsChecked();
            });
            // init filterLayers dans un objet sinon filterLayers n'est pas mis à jour depuis le html
            $scope.search = {
              filterLayers: ''
            };
          }
        };
        $scope.checkFeature = (uid,value) => {
          $scope.edit_resource.filterLayers.layers[uid]=angular.isDefined(value)?
                                                          value:!$scope.edit_resource.filterLayers.layers[uid];
          if($scope.geocatalogueNotFromApplication){
            if(!$scope.edit_resource.filterLayers.layers[uid]){
              const index = $scope.edit_resource.rightFeatures.indexOf(uid);
              if (index > -1) {
                $scope.edit_resource.rightFeatures.splice(index, 1);
              }
            }else if($scope.edit_resource.rightFeatures.indexOf(uid)===-1) {
              $scope.edit_resource.rightFeatures.push(uid);
            }
          }
        }
        $scope.hideAllPanels = () => {
          $scope.grouplayersName.forEach(group=>{
            $scope.hiddenPanels[group] = true;
            $scope.allPanelHidden = true;
          });
        };
        // fermer tous les groupes de thèmes
        $scope.showAllPanels = function() {
          $scope.hiddenPanels = {};
          $scope.allPanelHidden = false;
        };

        $scope.groupIsChecked = (group) => {
          $scope.groupChecked[group] = true;
          $scope.grouplayers[group].forEach((layer) => {
            if(!$scope.edit_resource.filterLayers.layers[layer.uid]){
              $scope.groupChecked[group]  = false;
            }
          });
        };

        $scope.subGroupCheckedFn = (group) => {
          $scope.grouplayers[group].forEach((layer) => {
            $scope.checkFeature(layer.uid,$scope.groupChecked[group]);
          });
        };

        $scope.allGroupCheckedFn = () => {
          $scope.allGroupChecked=!$scope.allGroupChecked
          $scope.grouplayersName.forEach(group=>{
            $scope.groupChecked[group] = $scope.allGroupChecked;
            $scope.subGroupCheckedFn(group);
          });
        };
        $scope.allGroupIsChecked = () => {
          $scope.allGroupChecked= true;
          $scope.grouplayersName.forEach(group=>{
            if(!$scope.groupChecked[group]){
              $scope.allGroupChecked= false;
            }
          });
        }

        $scope.$watch('edit_resource', ()=>{
          $scope.initFilterLayers();
        });

        /**
         * Supprime le filtrage quand on appuie sur la touche "escape"
         * Uniquement lors du 1er caractère écrit:<ul><li>
         * Sauvegarde l'état de d'affichage des groupes</li><li>
         * Dégroupe tous les groupes de couches</li><ul>
         * @param event keydown event
         */
        $scope.onFilterKeydown = (event) => {
          // reset si escape
          $scope.search.filterLayers = event.keyCode === 27 ? '' : $scope.search.filterLayers;

          if (!$scope.hiddenPanelsPrevState && $scope.search.filterLayers.length > 0) {
            if (Object.keys($scope.hiddenPanels).length > 0) {
              $scope.hiddenPanelsPrevState = angular.copy($scope.hiddenPanels);
            }
            // modifie la variable allPanelHidden
            $scope.showAllPanels();
          }
        };


        /**
         * Après avoir effacé le texte de saisie du filtre,
         * restaure l'état initial d'affichage des groupes de couches
         */
        $scope.onFilterKeyup = () => {
          if ($scope.search.filterLayers.length === 0) {

            if ($scope.filterState){
              $scope.filterState = false;
            }

            // restaure un état initial existant
            if ($scope.hiddenPanelsPrevState) {
              $scope.hiddenPanels = $scope.hiddenPanelsPrevState;
              // restaure allPanelHidden
              if (Object.keys($scope.hiddenPanels).length === Object.keys($scope.grouplayers).length) {
                $scope.allPanelHidden = Object.values($scope.hiddenPanels).every(active => active);
              }
              $scope.hiddenPanelsPrevState = null;
            }
          }
        };

        /**
         * Au clic sur le bouton suppimer (croix) de la zone de saisie du filtre des couches
         */
        $scope.resetFilter = () => {
          $scope.search.filterLayers = ''
          $scope.onFilterKeyup();
        };

        /**
         * Au clic sur le bouton d'ouverture de la liste des composants
         */
        $scope.openGeocatalog = () => {
          if (!$scope.isGeocatalogOpened) {
            let title = $filter('translate')('applications.applications.filterLayers.title');
            if ($scope.geocatalogueNotFromApplication) {
              title = $filter('translate')('applications.applications.filterLayers.titleRole');
            }
            $scope.isGeocatalogOpened = true;
            extendedNgDialog.open({
              template:
                  'js/XG/modules/applications/views/modals/modal.filterLayers.application.html',
              className: 'ngdialog-theme-plain nopadding geocatalog miniclose',
              closeByDocument: false,
              scope: $scope,
              draggable: true,
              resizable: true,
              title: title,
              preCloseCallback: () => {
                $scope.isGeocatalogOpened = false;
              },
            });
          }
        };
      }
    };
  };

  geocatalogueFilter.$inject = ['FeatureTypeFactory', 'extendedNgDialog', '$filter'];
  return geocatalogueFilter;
});


define('modules/common/directives/checkList',[],function() {
  /**
   * DualListBox Directive
   * Provides two listBox with drag&drop functionnality
   */
  var checkList = function() {
    return {
      restrict: 'EA',
      scope: {
        cfg: '=',
      },
      link: function(scope) {
        // data must be an array
        if (!angular.isArray(scope.cfg.resources.data)) {
          return false;
        }

        /**
         * Check and applies the behavior specifie on the configuration object
         */
        scope.checkBehavior = function(index, checkPosition, behavior) {
          var list = scope.displayData.resources.data;

          if (!list[index].isChild) {
            // check un check all childs
            // todo : ugliest directive ever, do it again ! @RB to @RB
            list.forEach(function(d, i) {
              if (d.parentIndex == index) {
                list[i].checks[checkPosition] = !list[d.parentIndex].checks[
                  checkPosition
                ];
              }
            });
          }
          if (behavior) {
            switch (behavior) {
              case 'cancel_others':
                break;
            }
          }
        };

        scope.$watch(
          function() {
            return scope.cfg.resources.data;
          },
          function(data) {
            if (!data || data.length == 0) return;
            scope.displayData = angular.copy(scope.cfg);
            console.log(scope.displayData);
          },
          true
        );
      },
      templateUrl: 'js/XG/modules/common/views/directives/checkList.html',
    };
  };

  checkList.$inject = [];
  return checkList;
});


define('modules/common/directives/arrayInput',[],function() {
  /**
   *
   * @returns {{restrict: string, templateUrl: string}}
   */
  var arrayInput = function() {
    return {
      restrict: 'A',
      templateUrl: 'js/XG/modules/common/views/directives/arrayInput.html',
      scope: {
        res: '=',
      },
      link: function(scope) {
        scope.lines = angular.isArray(scope.res) ? scope.res : [''];

        /**
         * Add a line
         */
        scope.addLine = function() {
          var lastIndex = scope.lines.length - 1;
          var lastLine = scope.lines[lastIndex];

          if (lastLine) {
            scope.lines.push('');
          }
        };

        /**
         * Delete a line
         * @param index
         */
        scope.deleteLine = function(index) {
          scope.lines.splice(index, 1);
        };

        /**
         * Update res
         */
        scope.$watch(
          'lines',
          function(lines) {
            scope.res = lines;
          },
          1
        );
      },
    };
  };

  arrayInput.$inject = [];
  return arrayInput;
});


define('modules/common/directives/restrictedInput',['toastr'],function() {
  let restrictedinput = (ngDialog) => {
    return {
      templateUrl: 'js/XG/modules/common/views/directives/restrictedinput.html',
      restrict: 'EA',
      scope: {
        res: '=',
        ftid: '=',
        field: '=',
      },
      link: function(scope) {
        /**
         * Select a value from the restricted table
         */
        scope.selectRestrictedValue = () => {
          if (!scope.field) {
            require('toastr').error(
              'Please specify what field to search data on'
            );
            return;
          }

          // on initialise le conteneur de la sélection d'objets dans un objet
          // pour éviter les pbs de transmission de scope d'AngularJS entre restrictedInput et gcdatatable
          scope.selectedValue = {features: []};

          let restrictedDialog = ngDialog.open({
            template:
              'js/XG/modules/common/views/directives/modal.restrictedinput.html',
            className: 'ngdialog-theme-plain width800',
            closeByDocument: false,
            scope: scope,
          });

          scope.setSelectedValue = () => {
            restrictedDialog.close();
            scope.res = scope.selectedValue.features[0].properties[scope.field];
          };
        };
      },
    };
  };

  restrictedinput.$inject = ['ngDialog'];
  return restrictedinput;
});


define('modules/common/directives/validateInput',[],function() {
  var validateinput = function() {
    return {
      templateUrl: 'js/XG/modules/common/views/directives/validateinput.html',
      restrict: 'EA',
      scope: {
        value: '=',
        restrict: '=',
        validated: '=',
        isDisabled: '=?',
        onBlur: '&?',
      },
      link: function(scope, elt, attrs, ctrl) {
        scope.validated = true;
        scope.required = attrs.hasOwnProperty('required');

        // check value against restrict
        scope.$watch('value', function(value) {
          var valid = true;
          if (value && angular.isArray(scope.restrict)) {
            scope.restrict.forEach(function(r) {
              if (value.indexOf(r) != -1) {
                valid = false;
              }
            });
          }
          scope.validated = valid;
        });

        scope.blurAction = function() {
          if (angular.isDefined(attrs.onBlur)) {
            scope.onBlur();
          }
        };
      },
    };
  };

  validateinput.$inject = [];
  return validateinput;
});


define('modules/common/directives/tabbedForm',[],function() {
  var tabbedform = function($timeout) {
    return {
      restrict: 'EA',
      scope: {
        validate: '=',
        tabs: '=',
      },
      link: function(scope, elt, attrs, ctrl) {
        var form = angular.element(elt[0]),
          submitButton = form.find('button[type=submit]')[0];

        /**
         * check every element of scope.validate
         * if its empty, switch to tab and add empty class
         */
        var checkRequiredElements = function(e) {
          if (angular.isArray(scope.validate) && scope.validate.length > 0) {
            scope.validate.forEach(function(v) {
              var value = v.key || '';
              if (value.trim() == '') {
                $timeout(function() {
                  scope.tabs.activeTab = 0;
                  form.addClass('incompleteForm');
                });
                return;
              }
            });
          }
        };

        if (submitButton) {
          if (submitButton.addEventListener) {
            submitButton.addEventListener(
              'click',
              checkRequiredElements,
              false
            ); //Modern browsers
          } else if (ele.attachEvent) {
            submitButton.attachEvent('onclick', checkRequiredElements); //Old IE
          }
        }
      },
    };
  };

  tabbedform.$inject = ['$timeout'];
  return tabbedform;
});


define('modules/common/directives/uncheckableRadio',[],function() {
  /**
   * Permet d'uncheck un bouton radio
   * uncheckableRadio
   * @param $timeout
   * @returns {{restrict: string, require: string, link: link}}
   */
  var uncheckableRadio = function($timeout) {
    return {
      restrict: 'A',
      require: 'ngModel',
      link: function(scope, elt, attrs, ngModel) {
        var wasChecked;

        elt.bind('mouseup', function() {
          wasChecked = elt.prop('checked');
        });

        elt.bind('click', function() {
          // radio deja checked
          if (wasChecked) {
            $timeout(function() {
              elt.prop('checked', false);
              ngModel.$setViewValue(undefined);
            }, 0);
          }
        });
      },
    };
  };

  uncheckableRadio.$inject = ['$timeout'];
  return uncheckableRadio;
});


define('modules/common/directives/fixedHeaderTable',[],function() {
  var fixedHeaderTable = function($timeout) {
    return {
      restrict: 'EA',
      scope: {
        mode: '@',
        tableGuid: '=?',
        dontUseIt: '=?',
        noOffset: '=?'
      },
      link: function(scope, elt) {
        var table = elt[0],
          innerWraper = elt.find('.fixInner')[0],
          fixThs = table.getElementsByClassName('fixTh'),
          searchToggle = elt.find('.toggleSearch'),
          realths = table.getElementsByTagName('th');

        const setWidth = () => {
          // do not resize when table is empty
          if (table.getElementsByClassName('fixedTbodyLine').length == 0)
            return;

          // ignore first th
          for (var i = 0; i < realths.length / 2; i++) {
            // headers
            if (fixThs[i]) {
              var hWidth =
                realths[i].offsetWidth == 0 ? 100 : realths[i].offsetWidth;
              // first row has a 30px left padding
              if (i == 0) hWidth -= 30;
              fixThs[i].style.width = hWidth + 'px';
              // also set the th width so it wont reset when the table is empty
              realths[i].style.width = hWidth + 'px';
            }

            // search tr
            if (fixThs[i + realths.length / 2]) {
              fixThs[i + realths.length / 2].style.width =
                realths[i].offsetWidth + 'px';
            }
          }

          // fixes table width

          $timeout(function() {
            elt
              .find('.table')
              .css('min-width', elt.find('.table')[0].offsetWidth + 'px');
          });

          //console.log(hWidth);
        };

        var cancelFirstNullResult = true;

        /**
         * Cette fonction est utilisée pour aligner les entêtes d'une table
         * avec ses colonnes de données.
         *
         * Voici un résumé de ce que fait la fonction :
         *
         * 1. Elle vérifie d'abord si la table n'a pas de résultats.
         *    Si c'est le cas et que cancelFirstNullResult est true, elle sort de la fonction.
         * 2. Elle obtient la rectangle client de la table.
         * 3. Elle vérifie si la table a des lignes de données.
         *    Si c'est le cas, elle obtient la première ligne de colonnes de données.
         * 4. Ensuite, elle itère sur chaque entête (`fixThs`), et
         *    colonne de données correspondante. Si la colonne de données n'existe pas,
         *    elle suppose qu'il s'agit d'un filtre
         *    et obtient la colonne de données correspondante de l'itération précédente.
         * 5. Elle calcule la position relative de l'entête fixe en soustrayant la position gauche
         *    de la table de la position gauche de la colonne de données.
         * 6. Elle définit la position gauche de l'entête fixe sur la position relative calculée.
         *
         * En résumé, cette fonction aligne les entêtes d'une table avec ses colonnes de données,
         * en prenant en compte le nombre de résultats et la taille de la table.
         *
         */
        var setThPosition = function() {
          //console.log('setThPosition');

          // Quand le nombre de resultats passe a 0,
          // il y a un glitch qui decale toutes les colonnes vers la gauche dans le cas
          // des tableaux tres larges qui sont resizes violemment
          // par le navigateur (chrome en tout cas)
          // on annule donc ici ce comportement
          const fixedTbodyLine = table.getElementsByClassName('fixedTbodyLine');
          if (cancelFirstNullResult && !fixedTbodyLine.length) {
            cancelFirstNullResult = false;
            return;
          }

          const origineRect = table.getClientRects()[0];
          // et on le reactive des qu'on a au moins un resultat
          let cols;
          if (fixedTbodyLine.length) {
            cancelFirstNullResult = true;
            if (fixedTbodyLine && fixedTbodyLine.length) {
              cols = fixedTbodyLine[0].getElementsByTagName('td');
            }
          }

          // -- Alignement des colonnes d'entêtes (titre de colonne et filtres)
          // -- avec les colonnes de données.
          let delta=0; // -- Pour gestion du regoupement de colonnes (colspan).
          for (let i = 0; i < fixThs.length; i++) {
            let colInd = i + delta;
            let col = cols[colInd];
            if (!col) {
              // -- Quand col n'existe pas pour l'indice i,
              // -- c'est parceque l'on traite la liste des filtres
              // -- (liste qui suit celle des entêtes de colonnes dans la liste fixThs).
              colInd = i-fixThs.length/2;
              if (colInd===0) {
                // -- On attaque la liste des filtres
                delta = 0;
              }
              colInd += delta;
            }
            col = cols[colInd];
            if (col) {
              // -- Calcul de la position relative de la div de l'intitulé ou du filtre.
              // -- La position relative est le delta entre la position absolue de la table
              // -- et la position absolue de la colonne de données correspondante.
              const colRect = col.getClientRects()[0];
              fixThs[i].style.left = colRect.left - origineRect.left + 'px';
            }
            // -- Gestion du colSpan qui est utilisé dans les liste de l'administartion
            // -- où chaque bouton d'action est dans une colonne dans la partie des données,
            // -- mais qui correspond à un regroupement des N colonnes de commandes
            // -- dans la partie entête.
            // -- Quand des colonnes sont regroupées dans l'entête,
            // -- il faut les passer dans la partie données pour être en phase
            // -- entre la partie entête et la partie données et la partie des données.
            const colSpan = fixThs[i].parentElement.colSpan;
            if (colSpan && colSpan!=1) {
              delta = fixThs[i].parentElement.colSpan - 1;
            }
          }
        };

        const setThPositionWithoutOffset = () => {
          if (
            cancelFirstNullResult &&
              !table.getElementsByClassName('fixedTbodyLine').length
          ) {
            cancelFirstNullResult = false;
            return;
          }
          // et on le reactive des qu'on a au moins un resultat
          if (table.getElementsByClassName('fixedTbodyLine').length)
            cancelFirstNullResult = true;

          var decalLeft = 0;
          for (var i = 0; i < fixThs.length; i++) {
            if (i == realths.length / 2) decalLeft = 0;
            fixThs[i].style.left = decalLeft + 8 + 'px';
            decalLeft += realths[i].offsetWidth;
          }
        };

        if (!scope.dontUseIt) {
          searchToggle.bind('click', () => {
            $timeout(() => {
              if (scope.noOffset){
                setWidthWithoutOffset();
                setThPositionWithoutOffset();
              }else{
                setWidth();
                setThPosition();
              }
            }, 0);
          });

          // RB 11/2017
          // set width a first time when the table data is set
          // + remove width auto on the table which kept changing td width
          var alreadySet = false;
          scope.$on('dataTable_DataLoaded', function(a, e) {
            if (e.table_guid == scope.tableGuid) {
              if (!alreadySet) {
                $timeout(function() {
                  // -- Appel commenté le 22/02/2024 car l'affectation d'une largeur faite
                  // -- dans cette fonction désorganise la datatable dans le cas
                  // -- de la vue tabulaire des DICTs (premiere table ok,
                  // -- les suivantes maldimensionnées).
                  // -- Un test d'affichage d'autres datables ne reléve pas de désorganisation
                  // -- suite à cette mise en commentaire.
                  // setWidth();
                  alreadySet = true;
                  // enleve le width auto sur la table
                  table.style.width = 'inherit';
                });
              }
            }
          });
        }

        // scroll the headers when scrolling the innerWrapper
        // @FIX RB 09/2016
        // To make it work with firefox, we need to compute the left property,
        // and not the negative marginleft
        if (angular.isDefined(innerWraper)) {
          innerWraper.onscroll = () => {
            setThPosition();
          };
        }

        const setWidthWithoutOffset = () => {
          // do not resize when table is empty
          if (table.getElementsByClassName('fixedTbodyLine').length == 0)
            return;

          let tempWidth = [];

          // ignore first th
          for (let i = 0; i < realths.length / 2; i++) {
            // headers
            if (fixThs[i]) {
              let hWidth =
                  realths[i].offsetWidth === 0 ? 100 : realths[i].offsetWidth;

              // first row has a 30px left padding
              if (i === 0) hWidth -= 30;
              fixThs[i].style.width = hWidth + 'px';
              // also set the th width so it wont reset when the table is empty
              tempWidth[i] = hWidth + 'px';
            }

            // search tr
            if (fixThs[i + realths.length / 2]) {
              fixThs[i + realths.length / 2].style.width = tempWidth[i];
            }

            // fixes table width

            $timeout(() => {
              elt
                .find('.table')
                .css('min-width', elt.find('.table')[0].offsetWidth + 'px');
            });
          }
        };
      },
    };
  };

  fixedHeaderTable.$inject = ['$timeout'];
  return fixedHeaderTable;
});


define('modules/common/directives/mapPositionPicker',['toastr'],function() {
  var mapPositionPicker = function(
    ngDialog,
    $rootScope,
    $timeout,
    $http,
    gaDomUtils,
    gaJsUtils,
    gcWMS,
    FeatureTypeFactory,
    kisGeocodageFactory,
    $filter
  ) {
    return {
      templateUrl:
        'js/XG/modules/common/views/directives/map_position_picker.html',
      scope: {
        position: '=',
        bbox: '=?',
        center: '=?', // EPSG:3857
        zoom: '@?',
        service: '@?', // 'google' or 'nominatim' or KisGeocodage id
        nombreposition: '@?',
        getBbox: '=?', // if set to true, we retrieve the bbox,
        displayLayers: '=?', // array of fti to display
        map: '=?',
        cannotModify: '=?',
        displayFeaturesConfig: '=?', // used with features-config  directive,
        multipoint: '=?', // allow to pick multiple point
        apptype: '=?',
      },
      restrict: 'E',
      link: function(scope, element, attr) {
        //Objet retourne
        scope.position = {};

        //RB temporary disabled
        scope.nombreposition = false;

        // TMP FIX RB
        //address choisie
        scope.placeData = {};
        //Form des infos address
        scope.infoService = false;
        //Changer le color du botton Draw
        scope.dessin = false;

        var source, map, dialog_map_position_picker, vector, draw;

        //console.log(scope.position);

        //ng-Dialog
        scope.openMapDialog = function() {
          scope.position = {};
          scope.placeData.place = false;

          // si on a une map  (passe en parametre)
          if (scope.map) {
            map = scope.map;
            scope.activerDessin();
          } else {
            dialog_map_position_picker = ngDialog.open({
              template:
                'js/XG/modules/common/views/directives/map_position_picker_dialog.html',
              className: 'ngdialog-theme-plain fullScreen nopadding ',
              closeByDocument: false,
              showClose: false,
              scope: scope,
            });
          }
          /*        scope.position = {};
                     scope.placeData.place = false;
                     dialog_map_position_picker = ngDialog.open({
                     template: 'js/XG/modules/common/views/directives/map_position_picker_dialog.html',
                     className: 'ngdialog-theme-plain fullScreen nopadding ',
                     closeByDocument: false,
                     showClose: false,
                     scope: scope
                     });*/
        };

        //Click sur la map pour recuperer les coords
        //Condition avec attribute 'nombreposition'='3' dans la directive
        if (scope.nombreposition) {
          scope.coords = [];
        }

        // retrieve the bbox
        scope.setBboxFromMap = function() {
          scope.bbox = map.getView().calculateExtent(map.getSize());
          dialog_map_position_picker.close();
        };

        //Activer le dessin
        scope.activerDessin = function() {
          if (!scope.map) {
            if (scope.dessin == true) {
              scope.dessin = false;
              map.removeInteraction(draw);
              // source.clear();
              return false;
            }
            scope.dessin = true;
          }
          if (
            scope.nombreposition &&
            scope.coords.length == scope.nombreposition
          ) {
            return false;
          }

          draw = new ol.interaction.Draw({
            source: source,
            type: 'Point',
            maxPoints: 1,
          });

          draw.set('gctype', 'kis');
          draw.set('interaction', 'Draw');
          draw.set('widget', 'mappicker');

          if (vector) {
            map.getLayers().insertAt(9999, vector);
          }

          //Click sur la map
          draw.on('drawend', function(evt) {
            //transformer les coords de Openlayer
            if (scope.nombreposition) {
              //  scope.coords.push(ol.proj.transform(evt.feature.getGeometry().getCoordinates(), 'EPSG:3857', 'EPSG:4326'));
              scope.coords.push(
                ol.proj.transform(
                  evt.feature.getGeometry().getCoordinates(),
                  map
                    .getView()
                    .getProjection()
                    .getCode(),
                  'EPSG:4326'
                )
              );
            } else {
              //  scope.coords = ol.proj.transform(evt.feature.getGeometry().getCoordinates(), 'EPSG:3857', 'EPSG:4326');
              scope.coords = ol.proj.transform(
                evt.feature.getGeometry().getCoordinates(),
                map
                  .getView()
                  .getProjection()
                  .getCode(),
                'EPSG:4326'
              );
            }

            var url;
            if (angular.isUndefined(scope.service)) {
              $timeout(function() {
                scope.position.coordinates = scope.coords;

                if (!scope.nombreposition) {
                  scope.placeData.place = true;
                }
                if (
                  scope.nombreposition &&
                  scope.coords.length == scope.nombreposition
                ) {
                  scope.placeData.place = true;
                  map.removeInteraction(draw);
                  scope.dessin = false;
                }
              }, 0);
            } else {
              //Action en cours
              gaDomUtils.showGlobalLoader();
              var promise;
              if (scope.service == 'google') {
                //url = 'https://maps.googleapis.com/maps/api/geocode/json?key=AIzaSyBT9fBCbBmtzVOWmTZjNR55y94_zfG3KfM&latlng=' + scope.coords[1] + ',' + scope.coords[0];
                url =
                  'https://maps.googleapis.com/maps/api/geocode/json?latlng=' +
                  scope.coords[1] +
                  ',' +
                  scope.coords[0];
              } else if (scope.service == 'nominatim') {
                url =
                  'https://nominatim.openstreetmap.org/reverse?format=json&lat=' +
                  scope.coords[1] +
                  '&lon=' +
                  scope.coords[0] +
                  '&zoom=18&addressdetails=1';
              } else {
                promise = kisGeocodageFactory.reverse(
                  kisGeocodageFactory.getGeocoderConfigFromId(scope.service)
                    .url,
                  scope.coords
                );
                gaDomUtils.hideGlobalLoader();
              }
              if (scope.service == 'google' || scope.service == 'nominatim') {
                promise = $http.get(url);
              }
              promise.then(
                function(res) {
                  console.log(res.data);
                  scope.infoService = scope.service;
                  if (scope.service == 'google') {
                    if (res.data.results.length) {
                      scope.position.infos = res.data.results;
                      if (res.data.results.length) {
                        scope.placeData.place = res.data.results[0];
                      }
                    } else {
                      require('toastr').warning(
                        'Erreur lors de la récupération de la position, retenter dans quelques secondes.',
                        '',
                        {
                          positionClass: 'toast-bottom-left',
                        }
                      );
                      scope.placeData = {};
                    }
                  } else if (scope.service == 'nominatim') {
                    scope.position.infos = res.data;
                    scope.placeData.place = true;
                  } else {
                    scope.position.infos = res.data.features[0];
                    scope.placeData.place = true;
                  }
                  scope.dessin = false;
                  scope.position.coordinates = scope.coords;

                  //Sortir d'action en cours
                  gaDomUtils.hideGlobalLoader();
                },
                function() {
                  gaDomUtils.hideGlobalLoader();
                }
              );
            }

            if (angular.isUndefined(scope.nombreposition) && !scope.map) {
              source.clear();
            }
          });

          map.addInteraction(draw);
        };

        $rootScope.$on('MapPositionPickerRemoveDraw', function() {
          if (map && draw) {
            map.removeInteraction(draw);
          }
        });

        //Supprimer des coords du tableau
        scope.supprimerCoordsDuTableau = function(index) {
          scope.placeData.place = false;
          scope.coords.splice(index, 1);
          source.removeFeature(source.getFeatures()[index]);
        };

        var clearCoords = function() {
          scope.infoService = false;
          scope.dessin = false;
          scope.coords = [];
          scope.position = {};
          scope.placeData.place = false;
        };

        //Annuler coords
        scope.resetCoordsMapPicker = function() {
          clearCoords();
          map.removeInteraction(draw);
          source.clear();
        };

        //Fermer Dialog
        scope.fermerDialogMapPicker = function() {
          clearCoords();
          source.clear();
          map.removeInteraction(draw);
          dialog_map_position_picker.close();
        };

        //Annuler les infos du google/ moninatin
        scope.resetPickedPosition = function() {
          clearCoords();
          // scope.bbox = [];
        };

        //Comfimer un address qu'on a chousi
        scope.confimerMapPickerCoords = function() {
          if (scope.service == 'google') {
            scope.position.infos = scope.placeData;
          } else {
            // scope.placeData.place = false;
            scope.infoService = false;
          }
          scope.coords = [];
          scope.dessin = false;
          map.removeInteraction(draw);
          source.clear();
          dialog_map_position_picker.close();
          $rootScope.$broadcast('PositionFromMapPositionPickerChange');
        };

        /**
                 * reset zIndex for layers
                /* *!/
                $rootScope.$on('featuresConfigLayersDisplayChange', function (event, data) {
                    if(data.name=='mapPositionPicker'){
                        var array = [];
                        data.features.forEach(function (f) {
                            var l = gcWMS.getOlLayerFromFeaturetypeInfo(f);
                            map.removeLayer(l);
                            array.unshift(l);
                        });
                        array.forEach(function (l){
                            map.addLayer(l);
                        })
                    }
                });*/

        //title of button
        scope.possitionner = $filter('translate')(
          'common.directives.mappicker.position'
        );

        //Listen
        $rootScope.$on('ngDialog.opened', function(e, $dialog) {
          if (
            angular.isUndefined(dialog_map_position_picker) ||
            angular.isUndefined(dialog_map_position_picker.id)
          ) {
            return false;
          }

          if (dialog_map_position_picker.id != $dialog[0].id) {
            return false;
          }

          source = new ol.source.Vector({
            wrapX: false,
          });

          vector = new ol.layer.Vector({
            source: source,
            style: new ol.style.Style({
              image: new ol.style.Icon({
                anchor: [0.5, 46],
                anchorXUnits: 'fraction',
                anchorYUnits: 'pixels',
                src: 'img/common/map_directive_picker.png',
              }),
            }),
          });

          if (angular.isUndefined(scope.center)) {
            scope.center = [0, 0];
          }

          if (angular.isUndefined(scope.zoom)) {
            scope.zoom = 4;
          }

          map = new ol.Map({
            layers: [
              new ol.layer.Tile({
                source: new ol.source.OSM(),
              }),
              vector,
            ],
            target: 'map_position_picker',
            controls: ol.control.defaults(),
            view: new ol.View({
              center: scope.center,
              zoom: scope.zoom,
              projection: 'EPSG:3857',
              minResolution: 0.03732276771737122,
            }),
          });

          scope.currentMap = map;
          if (
            angular.isDefined(scope.displayLayers) &&
            ancAppAndroid == 'undefined'
          ) {
            scope.displayLayers.forEach(function(f) {
              var l = gcWMS.getOlLayerFromFeaturetypeInfo(f);
              map.addLayer(l);
            });
          }

          if (angular.isDefined(scope.bbox)) {
            map.getView().fit(scope.bbox, map.getSize());
          }
        });

        scope.capitalize = function(x) {
          return gaJsUtils.capitalizeFirstLetter(x);
        };
      },
    };
  };

  mapPositionPicker.$inject = [
    'ngDialog',
    '$rootScope',
    '$timeout',
    '$http',
    'gaDomUtils',
    'gaJsUtils',
    'gcWMS',
    'FeatureTypeFactory',
    'kisGeocodageFactory',
    '$filter',
  ];
  return mapPositionPicker;
});


define('modules/common/directives/positionAutoComplete',['toastr'],function() {
  var positionAutoComplete = function(
    $http,
    $timeout,
    kisGeocodageFactory,
    $rootScope,
    $filter
  ) {
    return {
      templateUrl:
        'js/XG/modules/common/views/directives/position_auto_complete.html',
      scope: {
        adresse: '=?',
        button: '@?',
        service: '@',
        defaultValue: '=?',
        allowValueFromText: '=?',
        cannotModify: '=?',
      },
      restrict: 'EA',
      link: function(scope, element, attr) {
        if (angular.isUndefined(scope.service)) scope.service = 'google';

        scope.buttonValue = scope.button;
        scope.buttonAffiche = true;
        scope.adresses = {};

        if (angular.isUndefined(scope.button)) {
          scope.buttonAffiche = false;
        }

        scope.$watch(
          'defaultValue',
          function(defaultValue) {
            setDefaultValue();
          },
          1
        );

        // set a default value and a default array (return by getInformationsFromAddress)
        var defaultArray = [];
        var setDefaultValue = function() {
          if (angular.isDefined(scope.defaultValue)) {
            defaultArray = [{ value: scope.defaultValue }];
            scope.adresses = { res: { value: scope.defaultValue } };
          }
        };
        setDefaultValue();

        scope.getInformationsFromAddress = function(address) {
          if (address == '' || address == undefined) {
            if (angular.isDefined(scope.defaultValue)) {
              return defaultArray;
            } else {
              return false;
            }
          }

          if (scope.service == 'google') {
            var params = { address: address, sensor: false };

            // return $http.get('https://maps.googleapis.com/maps/api/geocode/json?key=AIzaSyBT9fBCbBmtzVOWmTZjNR55y94_zfG3KfM', {params: params})
            return $http
              .get('https://maps.googleapis.com/maps/api/geocode/json', {
                params: params,
              })
              .then(function(res) {
                for (var i = 0; i < res.data.results.length; i++) {
                  res.data.results[i].value =
                    res.data.results[i].formatted_address;
                }
                return res.data.results;
              });
          } else if (scope.service == 'nominatim') {
            return $http
              .get(
                'https://nominatim.openstreetmap.org/?format=json&q=' + address
              )
              .then(function(res) {
                for (var i = 0; i < res.data.length; i++) {
                  res.data[i].value = res.data[i].display_name;
                }
                return res.data;
              });
          } else if (!scope.service || scope.service == '') {
            require('toastr').error(
              $filter('translate')(
                'common.directives.position_autocomplete.service_vide'
              )
            );
          } else {
            return kisGeocodageFactory
              .search(
                kisGeocodageFactory.getGeocoderConfigFromId(scope.service).url,
                address
              )
              .then(function(res) {
                for (var i = 0; i < res.data.features.length; i++) {
                  res.data.features[i].value =
                    res.data.features[i].properties.label;
                }
                return res.data.features;
              });
          }
        };

        scope.$on('$typeahead.select', function(value, index) {
          if (
            angular.isUndefined(scope.button) &&
            index == scope.adresses.res
          ) {
            scope.adresse = scope.adresses.res;
          }
        });

        if (scope.allowValueFromText) {
          if (angular.isUndefined(scope.button)) {
            scope.$watch(
              'adresses',
              function() {
                scope.adresse = scope.adresses.res;
              },
              1
            );
          }
        }

        scope.enregistrerInfo = function() {
          $timeout(function() {
            scope.adresse = scope.adresses.res;
          });
        };
      },
    };
  };

  positionAutoComplete.$inject = [
    '$http',
    '$timeout',
    'kisGeocodageFactory',
    '$rootScope',
    '$filter',
  ];
  return positionAutoComplete;
});


define('modules/common/directives/banoInfo',[],function() {
  var banoInfo = function($http, kisGeocodageFactory, $rootScope) {
    return {
      templateUrl: 'js/XG/modules/common/views/directives/bano_info.html',
      scope: {
        resultat: '=',
        type: '@',
        service: '@?', // id of Kis Geocodage
      },
      restrict: 'EA',
      link: function(scope, element, attr) {
        //Initiation de valeur
        scope.selectedAddress = {};
        var addressInfos;

        //la methode pour recuperer les infos automatiquement
        scope.getBanoInfos = function(requete) {
          if (requete == '' || requete == undefined) {
            return false;
          }

          var urlType = scope.type == 'postcode' ? 'city' : scope.type;
          var promise;
          if (!scope.service) {
            promise = $http.get(
              'https://api-adresse.data.gouv.fr/search/?q=' +
                requete +
                '&type=' +
                urlType
            );
          } else {
            promise = kisGeocodageFactory.search(
              kisGeocodageFactory.getGeocoderConfigFromId(scope.service).url,
              requete,
              urlType
            );
          }

          return promise.then(function(res) {
            addressInfos = [];
            var view;
            for (var i = 0; i < res.data.features.length; i++) {
              if (scope.type == 'city') {
                view = res.data.features[i].properties.city;
              } else if (scope.type == 'postcode') {
                view = res.data.features[i].properties.postcode;
              } else if (scope.type == 'street') {
                view = res.data.features[i].properties.label;
              }
              addressInfos.push({
                view: view,
                data: res.data.features[i],
              });
            }
            return addressInfos;
          });
        };

        //listen '$typeahead.select'
        scope.$on('$typeahead.select', function() {
          scope.resultat = scope.selectedAddress;
        });
      },
    };
  };

  banoInfo.$inject = ['$http', 'kisGeocodageFactory', '$rootScope'];
  return banoInfo;
});


define('modules/common/directives/featuresConfig',['toastr'],function() {
  var config = function($rootScope, gcWMS, FeatureTypeFactory, gclayers) {
    return {
      templateUrl: 'js/XG/modules/common/views/directives/features_config.html',
      scope: {
        config: '=',
        map: '=',
        tooltip: '=?', //tooltip on button
        fromAnc: '=?',
        baselayers: '=?',
      },
      restrict: 'EA',
      link: function(scope) {
        //console.log(scope.config)
        // console.log(scope.map)

        scope.mapFeatureConfig = {};
        scope.featuresObjectCompletEsri = [];
        scope.featuresObjectCompletG2c = [];
        scope.baseLayers = [];
        if (angular.isDefined(scope.config)) {
          // console.log(scope.config);
          var ind = 0;
          // we need to reset all layers to avoid multiple reverse (ticket 1548)
          gclayers.clearOperationalLayerg2c();
          Object.keys(scope.config).forEach(function(uid) {
            try {
              var f = FeatureTypeFactory.getFeatureByUid(uid);
              if (f.uid != "") {
                var l = gcWMS.getOlLayerFromFeaturetypeInfo(f, ind);
                if (gcWMS.getOlLayerFromFeaturetypeInfo(f) && f.type == 'esri') {
                  gclayers.addOperationalLayerESRI(l);
                  scope.featuresObjectCompletEsri.push(f);
                } else if (gcWMS.getOlLayerFromFeaturetypeInfo(f)) {
                  gclayers.addOperationalLayerg2c(l);
                  scope.featuresObjectCompletG2c.push(f);
                }
              } else {
                require('toastr').error("Couche configurée inexistante: " + uid +
                    ". Vous pouvez la supprimer de cette application.");
                console.error("Couche configurée inexistante: " + uid);
              }
            } catch (e) {
              e.stack;
            }
            ind++;
          });

          gclayers.getOperationalLayerg2cCollection().getArray().reverse();
          $rootScope.$broadcast('gcOperationalLayerOnInit');
          $rootScope.$broadcast('featuresConfigLoaded');
        }


        /**
         * refresh
         * @param index
         * @param f
         */
        scope.toggleVisibility = function (index, f) {
          if (scope.mapFeatureConfig[f.uid] === undefined) {
            scope.mapFeatureConfig[f.uid] = true;
          }
          scope.mapFeatureConfig[f.uid] = !scope.mapFeatureConfig[f.uid];

          var l = gcWMS.getOlLayerFromFeaturetypeInfo(f);
          gclayers.getOperationalLayerg2c().forEach(function (lay) {
            if (l.fti.uid == lay.fti.uid) {
              lay.setVisible(scope.mapFeatureConfig[f.uid]);
            }
          });
          gclayers.getOperationalLayerESRI().forEach(function (lay) {
            if (l.fti.uid == lay.fti.uid) {
              lay.setVisible(scope.mapFeatureConfig[f.uid]);
            }
          });
          $rootScope.$broadcast('gcOperationalLayerChange', '', 'applyall');
        };

        /**
         * toggleBaseMap
         */
        scope.toggleBaseMap = (layer) => {
            layer.active = !layer.active;
            toggleBaseLayer(layer);
        };
        function toggleBaseLayer(layer) {
          const bgLayers = gclayers.getBackGroundLayer();
          bgLayers.forEach(x => {
            x.setVisible(false);
          })
          const bgLayer = bgLayers.filter((bg) => bg.name == layer.name)[0];
          bgLayer.setVisible(layer.active);
        }
      

        if (angular.isDefined(scope.fromAnc) && scope.fromAnc) {
          if (scope.config.baselayers) {
            delete scope.config.baselayers;
          }
          Object.keys(scope.config).forEach(function (couche, i) {
            if (
              angular.isDefined(scope.config[couche]) &&
              angular.isDefined(scope.config[couche].split('-', 2)[1])
            ) {
              var f = FeatureTypeFactory.getFeatureByUid(couche);
              if (scope.config[couche].split('-', 2)[1] == '0' && f != null)
                scope.toggleVisibility(i, f);
            }
          });
        }

        scope.moveItem = function (index, delta, type) {
          if (type == 'esri') {
            var layer = gclayers.getOperationalLayerESRI()[index];
            gclayers.getOperationalLayerESRICollection().removeAt(index);
            gclayers
              .getOperationalLayerESRICollection()
              .insertAt(index + delta, layer);
            layer.index = index + delta;
            swapItems(scope.featuresObjectCompletEsri, index, index + delta);
          } else {
            gclayers.getOperationalLayerg2cCollection().getArray().reverse();
            var layer = gclayers.getOperationalLayerg2c()[index];
            gclayers.getOperationalLayerg2cCollection().removeAt(index);
            gclayers
              .getOperationalLayerg2cCollection()
              .insertAt(index + delta, layer);
            layer.index = index + delta;
            swapItems(scope.featuresObjectCompletG2c, index, index + delta);
            gclayers.getOperationalLayerg2cCollection().getArray().reverse();
          }
          $rootScope.$broadcast('gcOperationalLayerChange', '', 'applyall');
        };

        var swapItems = function (arr, index1, index2) {
          arr[index1] = arr.splice(index2, 1, arr[index1])[0];
          return arr;
        };
      },
    };
  };

  config.$inject = ['$rootScope', 'gcWMS', 'FeatureTypeFactory', 'gclayers'];
  return config;
});



define('modules/common/directives/eventLinked',['toastr','toastr','toastr'],function() {
  var eventLinked = function(
      AncAppFactory,
      BacAppFactory,
      CalendarFactory,
      UsersFactory,
      $filter,
      $rootScope,
      $timeout,
      gaDomUtils,
      ngDialog,
      gaJsUtils,
      kisCalendarFactory
  ) {
    return {
      templateUrl: 'js/XG/modules/common/views/directives/event_linked.html',
      scope: {
        openDialogUsers: '&?',
        actionPriseRdv: '&?',
        linkedobjects: '=?',
      },
      restrict: 'E',
      link: function(scope, element, attr) {

        scope.length_events = false;
        scope.disabled = false;
        scope.openControleAcceptsRDV = false;

        scope.currentRDVControles = [];
        scope.expanded = [];

        scope.appType = $rootScope.xgos.sector;

        var CurrentAppFactory = $rootScope.xgos.sector == 'bac' ? BacAppFactory : AncAppFactory;

        scope.getEventsAncRDV = function(){
          const where = "created_by='" + $rootScope.xgos.user.login + "'";

          CurrentAppFactory.getActifsControles(scope.linkedobjects).then(function(res) {
            if(
                res.data !== undefined && res.data.features !== undefined
                && res.data.features.length > 0
            ){
              scope.openControleAcceptsRDV = true;
            }
          })
          .catch(err => {
            err.stack;
          });

          UsersFactory.getactiveuserslight().then(function(res) {
            let usersArray = [];
            if(res.data !== undefined){
              usersArray = res.data;

              CurrentAppFactory.getcontroles(scope.linkedobjects).then(function(res) {

                if(res.data.features !== undefined){

                  scope.length_events = true;

                  if(res.data.features.length > 0){
                    // order controles
                    let controles = res.data.features;
                    controles.sort(function(a, b) {
                      let x = parseInt(a['id'].split('.')[1]);
                      let y = parseInt(b['id'].split('.')[1]);
                      return ((x < y) ? -1 : ((x > y) ? 1 : 0));
                    });

                    for(let i = 0; i < controles.length; i++){
                      controles[i].ctrlLabel = CurrentAppFactory.getControleName(
                          controles[i].properties.type,
                          controles[i].properties.date_passage
                      );

                      if(i == 0){
                        scope.expanded[i] = true;
                      } else {
                        scope.expanded[i] = false;
                      }
                      controles[i].eventsRDV = [];

                      $timeout(function(){

                        CalendarFactory.getevents(where, '', '','', controles[i].id).then(function(res){
                            if (
                                res.data != undefined &&
                                res.data.features !== undefined
                            ) {

                              controles[i].eventsRDV = res.data.features;

                              for (let property in res.data) {
                                for(let j = 0; j < controles[i].eventsRDV.length; j++){
                                  if(controles[i].eventsRDV[j].properties !== undefined){
                                    if(res.data['agents'][j] !== undefined){
                                      controles[i].eventsRDV[j].properties.agent = res.data['agents'][j];
                                    } else {
                                      controles[i].eventsRDV[j].properties.agent = '';
                                    }
                                  }
                                }
                              }

                              for(let j = 0; j < controles[i].eventsRDV.length; j++){
                                let event = controles[i].eventsRDV[j];

                                event.properties.agentRDV = {};

                                event.properties.agentRDV.login = event.properties.agent;

                                //display user's name and surname
                                let found = usersArray.find(function (element) {
                                  return element.login  == event.properties.agentRDV.login;
                                });
                                if (found !== undefined) {
                                  event.properties.agentRDV.name = found.name;
                                  event.properties.agentRDV.surname = found.vorname;
                                }

                                // alert color for date background
                                scope.dossiersCfg = angular.copy(
                                    CurrentAppFactory.appCfg.main.dossierCfg);

                                let echeance = new Date(
                                    event.properties.start).getTime();
                                let now = Date.now();
                                let diff = gaJsUtils.dayDiff(now, echeance);
                                if (diff < scope.dossiersCfg.alerte.red) {
                                  event.properties.alertClass = 'redAlertRDV';
                                } else if (diff > scope.dossiersCfg.alerte.red && diff
                                    < scope.dossiersCfg.alerte.green) {
                                  event.properties.alertClass = 'yellowAlertRDV';
                                } else {
                                  event.properties.alertClass = 'greenAlertRDV';
                                }

                                // statut du rendez vous
                                let choixStatutRDV = CurrentAppFactory.getChoixStatutRDV();

                                choixStatutRDV.forEach(function (statut, index) {
                                  if (controles[i].properties.statut_rdv === statut.value) {
                                    event.properties.statutRDV = statut.label;
                                  }
                                });
                                if (controles[i].properties.statut_rdv == null) {
                                  event.properties.statutRDV = 'A venir';
                                }

                                event.properties.origine_du_report_annulation =
                                    event.properties.origine_du_report_annulation_rdv;

                                //get comment
                                event.properties.comment = event.properties.commentaire_rdv;
                              }

                            }
                        })
                        .catch(err => {
                          require('toastr').error(
                              "Un problème est survenu lors de la récupération de l'evenement.",
                              'Erreur',
                              {
                                positionClass: 'toast-bottom-left',
                              }
                          );
                          err.stack;
                        });

                      }, 30);

                      scope.currentRDVControles.push(controles[i]);
                    }
                  }
                }

              })
              .catch(err => {
                err.stack;
              });

            }
          })
          .catch(err => {
            err.stack;
          });
        }

        scope.getEventsBacRDV = function() {
          const where = "created_by='" + $rootScope.xgos.user.login + "'";

          UsersFactory.getactiveuserslight().then(function (res) {
            let usersArray = [];
            if (res.data !== undefined) {
            usersArray = res.data;

            CurrentAppFactory.getcontroles(scope.linkedobjects).then(
                function (res) {
                  if (res.data.features !== undefined) {

                    scope.length_events = true;

                    if (res.data.features.length > 0) {
                      // order controles
                      let controles = res.data.features;
                      controles.sort(function (a, b) {
                        let x = parseInt(a['id'].split('.')[1]);
                        let y = parseInt(b['id'].split('.')[1]);
                        return ((x < y) ? -1 : ((x > y) ? 1 : 0));
                      });

                      for(let i = 0; i < controles.length; i++){
                        controles[i].ctrlLabel = CurrentAppFactory.getControleName(
                            controles[i].properties.type,
                            controles[i].properties.date_passage
                        );

                        if (i == 0) {
                          scope.expanded[i] = true;
                        } else {
                          scope.expanded[i] = false;
                        }

                        // event
                        controles[i].eventsRDV = [];

                        if(controles[i].properties.date_passage !== null){
                          let eventProperties = {};
                          eventProperties.properties = {};
                          let agentData = {};
                          agentData.login = controles[i].properties.agent;

                          //display user's name and surname
                          let found = usersArray.find(function (element) {
                            return element.login
                                == agentData.login;
                          });
                          if (found !== undefined) {
                            agentData.name = found.name;
                            agentData.surname = found.vorname;
                          }

                          eventProperties.properties.agentRDV = agentData;
                          eventProperties.properties.title = controles[i].ctrlLabel;
                          eventProperties.properties.start = controles[i].properties.date_passage;

                          // alert color for date background
                          scope.dossiersCfg = angular.copy(
                              CurrentAppFactory.appCfg.main.dossierCfg);

                          let echeance = new Date(
                              eventProperties.properties.start).getTime();
                          let now = Date.now();
                          let diff = gaJsUtils.dayDiff(now, echeance);
                          if (diff < scope.dossiersCfg.alerte.red) {
                            eventProperties.properties.alertClass = 'redAlertRDV';
                          } else if (diff > scope.dossiersCfg.alerte.red
                              && diff
                              < scope.dossiersCfg.alerte.green) {
                            eventProperties.properties.alertClass = 'yellowAlertRDV';
                          } else {
                            eventProperties.properties.alertClass = 'greenAlertRDV';
                          }

                          // statut du rendez vous
                          let choixStatutRDV = CurrentAppFactory.getChoixStatutRDV();

                          choixStatutRDV.forEach(function (statut, index) {
                            if (controles[i].properties.statut_rdv
                                === statut.value) {
                              eventProperties.properties.statutRDV = statut.label;
                            }
                          });
                          if (controles[i].properties.statut_rdv == null) {
                            eventProperties.properties.statutRDV = 'A venir';
                          }

                          eventProperties.properties.origine_du_report_annulation =
                              controles[i].properties.origine_du_report_annulation_rdv;

                          eventProperties.properties.comment =
                              controles[i].properties.commentaire_rdv;

                          controles[i].eventsRDV.push(eventProperties);
                        }

                        scope.currentRDVControles.push(controles[i]);
                      }
                    }
                  }
                })
                .catch(err => {
                  err.stack;
                });
            }
          })
          .catch(err => {
            err.stack;
          });
        }

        if(scope.appType === 'anc'){
          scope.getEventsAncRDV();
        } else if(scope.appType === 'bac') {
          scope.getEventsBacRDV();
        }


        // kis_calendar_event_changed
        $rootScope.$on('kis_calendar_event_changed', function(
            event,
            data
        ) {
          scope.currentRDVControles = [];
          scope.getEventsAncRDV();
        });

        //render date
        scope.renderValue = function(v) {
          v = new Date(v);
          v = $filter('date')(v, 'dd/MM/yyyy');

          return v;
        };

        //render date
        scope.renderTimeFromDate = function(v) {
          return new Date(v).toTimeString().split(' ')[0];
        };

        //refresh events
        scope.refresh = function() {
          scope.currentRDVControles = [];
          if(scope.appType === 'anc'){
            scope.getEventsAncRDV();
          } else if(scope.appType === 'bac') {
            scope.getEventsBacRDV();
          }
        };

        //add event
        scope.addNewEvent = function() {
          scope.actionPriseRdv();
        };

        scope.editEventLine = {};
        let svgType;
        let currentId;

        // edit event
        scope.editEvent = function(idx) {
          if (currentId && currentId != idx) {
            scope.events[currentId] = angular.copy(svgType);
            scope.editEventLine = {};
          }
          currentId = idx;
          let tmp = {};
          tmp[idx] = !scope.editEventLine[idx];
          scope.editEventLine = tmp;
          svgType = angular.copy(scope.events[idx]);
        };

        scope.updateEventType = function(idx) {
          gaDomUtils.showGlobalLoader();
          if (scope.events[idx].properties.agent) {
            scope.events[idx].properties.agent = {login: scope.events[idx].properties.agent.login}
          }
          CalendarFactory.updateeventdetails(scope.events[idx]).then(function(res) {
            gaDomUtils.hideGlobalLoader();
            scope.editEventLine = {};
            currentId = false;
          });
        }

        // cancel event edit
        scope.cancelEventEdit = function(idx) {
          $timeout(function() {
            scope.events[idx] = svgType;
            scope.editEventLine = {};
            currentId = false;
          });
        };

        scope.removeEvent = function(event, controlId) {
          var ans = confirm(
              'Êtes-vous certain de vouloir effectuer cette action ?'
          );

          if (ans) {
            if(scope.appType == 'anc'){
              gaDomUtils.showGlobalLoader();
              CalendarFactory.removeeventdetails(event.id).then(
                  function(res) {
                    scope.currentRDVControles = [];
                    scope.getEventsAncRDV();
                    gaDomUtils.hideGlobalLoader();
                  }
              )
              .catch(err => {
                err.stack;
              });
            }

            if(scope.appType == 'bac'){

              gaDomUtils.showGlobalLoader();

              CurrentAppFactory.getcontroles(scope.linkedobjects).then(function(res){
                if(res.data !== undefined && res.data.features !== undefined){

                  let control = res.data.features.filter(function(control){
                    return control.id == controlId;
                  });

                  if(control !== undefined && control[0] !== undefined){
                    control[0].properties.date_passage = null;
                    control[0].properties.origine_du_report_annulation_rdv = null;
                    control[0].properties.commentaire_rdv = null;
                    control[0].properties.statut_rdv = null;

                    // update controle object
                    BacAppFactory.updatecontrole({
                      type: 'FeatureCollection',
                      features: [control[0]],
                    }).then(function(res){

                    })
                    .catch(err => {
                      require('toastr').error(
                          "Un problème est survenu lors de l'enregistitrement de l'instruction.",
                          'Erreur',
                          {
                            positionClass: 'toast-bottom-left',
                          }
                      );
                      err.stack;
                    });


                    BacAppFactory.addcontroledetail(
                        control[0],
                        scope.linkedobjects,
                        controlId
                    ).then(function(res) {
                        require('toastr').success(
                            "Informations de l'instruction enregistrées.",
                            '',
                            {
                              positionClass: 'toast-bottom-left',
                            }
                        );
                      // reset dirty variable
                      scope.ctrlFormIsDirty = false;

                      scope.currentRDVControles = [];
                      scope.getEventsBacRDV();

                      gaDomUtils.hideGlobalLoader();
                    })
                    .catch(err => {
                      err.stack;
                    });

                  }
                }
              })
              .catch(err => {
                err.stack;
              });

            }
          }
        };
      },
    };
  };

  eventLinked.$inject = [
      'AncAppFactory',
      'BacAppFactory',
      'CalendarFactory',
      'UsersFactory',
      '$filter',
      '$rootScope',
      '$timeout',
      'gaDomUtils',
      'ngDialog',
      'gaJsUtils',
      'kisCalendarFactory',
  ];
  return eventLinked;
});


define('modules/common/directives/userPicker',[],function() {
  var userPicker = function(
    ngDialog,
    UsersFactory,
    $rootScope
  ) {
    return {
      templateUrl: 'js/XG/modules/common/views/directives/userPicker.html',
      scope: {
        res: '=',
        type: '=?', //checkbox pour partager url avec les utilisateurs
        titre: '=?',
        roles: '=?', // restreindre le choix aux roles spécifiés,
        disabled: '=?',
        initUser: '=?', // si login fourni, retourne l'utilisateur complet
        useragent: '=?',
        alternativeTitle: '=?',
      },
      restrict: 'EA',
      link: function(scope) {

        if (!scope.titre) {
          scope.titre = 'Choisir';
        }
        scope.select = {};

        var userSelectPickerDialog;
        scope.openDialogUsers = function() {
          scope.select = {};
          scope.select_users = {};
          $rootScope.$broadcast('userFromDialog', true);

          UsersFactory.getactiveuserslight().then(function(res) {
            var gusers = res.data;
            // tri si role specifié
            if (angular.isDefined(scope.roles)) {
              scope.users = gusers.filter(function(u) {
                return scope.roles.filter(function(n) {
                  return (
                    u.roles
                      .map(function(g) {
                        return g.name;
                      })
                      .indexOf(n) !== -1
                  );
                }).length;
              });
              console.log(scope.users);
            } else {
              scope.users = gusers;
            }
          });

          userSelectPickerDialog = ngDialog.open({
            template:
              'js/XG/modules/common/views/directives/user_picker_dialog.html',
            className: 'ngdialog-theme-plain width800 nopadding miniclose',
            closeByDocument: false,
            scope: scope,
          });
        };

        scope.selectUser = function() {
          scope.res = angular.copy(scope.select.user);
          userSelectPickerDialog.close();
        };

        scope.select_users = {};
        scope.partager = function() {
          var res = [];
          Object.keys(scope.select_users).forEach(function(key) {
            if (scope.select_users[key] == true) {
              scope.users.forEach(function(user) {
                if (user.login == key) {
                  res.push(user);
                }
              });
            }
          });
          scope.res = res;
          userSelectPickerDialog.close();
        };

        scope.render_select_users = function() {
          var value = false;
          Object.keys(scope.select_users).forEach(function(key) {
            if (scope.select_users[key] == true) {
              value = true;
            }
          });
          return value;
        };

        scope.unlinkUser = function() {
          for (var i in scope.res) {
            scope.res[i] = '';
          }
        };

        var initUser = function() {
          UsersFactory.getactiveuserslight().then(function(res) {
            res.data.forEach(function(u) {
              if (u.login === scope.initUser) scope.res = u;
            });
          });
        };

        if (angular.isDefined(scope.initUser)) initUser();
      },
    };
  };

  userPicker.$inject = [
    'ngDialog',
    'UsersFactory',
    '$rootScope',
  ];
  return userPicker;
});


define('modules/common/directives/parameterSaveLoad',[],function() {
  var parameterSaveLoad = function(
    ParametersFactory,
    $translate,
    $rootScope,
    $filter
  ) {
    return {
      templateUrl:
        'js/XG/modules/common/views/directives/parameter_save_load.html',
      scope: {
        type: '@',
        loadMapping: '&',
        saveMapping: '&',
      },
      restrict: 'EA',
      link: function(scope, element, attr) {
        scope.mappingToLoad = {};
        scope.currentMapping = {};

        /**
         * refresh mapping list
         */
        var refreshMappingList = function() {
          ParametersFactory.getbytype(scope.type).then(function(res) {
            scope.mappingList = res.data;
          });
        };

        refreshMappingList();
        $rootScope.$on('refreshParameterMappingList', function(event, data) {
          if (data.type == scope.type) {
            refreshMappingList();
          }
        });

        /**
         *  load parameter mapping
         */
        scope.innerLoad = function() {
          scope.loadMapping({ data: scope.mappingToLoad.value });
        };
        /**
         *  save parameter mapping
         */
        scope.innerSave = function() {
          var nameExist = scope.mappingList
            .map(function(x) {
              return x.name;
            })
            .indexOf(scope.currentMapping.name);

          var ans = 1;
          if (nameExist != -1)
            ans = confirm(
              $filter('translate')(
                'common.directives.parameter_save_load.name_exist'
              )
            );
          if (ans) {
            scope.saveMapping({ data: scope.currentMapping.name });
          }
        };
      },
    };
  };

  parameterSaveLoad.$inject = [
    'ParametersFactory',
    '$translate',
    '$rootScope',
    '$filter',
  ];
  return parameterSaveLoad;
});


define('modules/common/directives/emailWriter',[],function() {
  var emailWriter = function(
    ngDialog,
    UsersFactory,
    gaDomUtils,
    FunctionFactory,
    gaJsUtils,
    taOptions,
    $rootScope,
    $filter
  ) {
    return {
      templateUrl: 'js/XG/modules/common/views/directives/email_writer.html',
      scope: {
        title: '=?', // email title default
        content: '=?', //email content default
        buttonTitle: '=?', //button title default
        contentUrl: '=?',
      },
      restrict: 'EA',
      link: function(scope, element, attr) {
        if (!scope.buttonTitle) {
          scope.buttonTitle = 'mail_writer.title';
        }
        /**
         * reset taOptions of toolbar
         * @type {*[]}
         */
        taOptions.toolbar = [
          [
            'h1',
            'h2',
            'h3',
            'h4',
            'h5',
            'h6',
            'bold',
            'italics',
            'underline',
            'strikeThrough',
            'ul',
            'ol',
            'insertLink',
          ],
        ];

        /**
         * init data
         */
        var init = function() {
          scope.email = {};
          scope.recipients = [];
          scope.recipients_cc = [];
          scope.recipients_bcc = [];
          scope.copy_forself = false;
          /**
           * Email content and title default
           */
          if (scope.content) {
            scope.email.htmlVariable = scope.content;
          }
          if (scope.title) {
            scope.email.title = scope.title;
          }
          if (scope.contentUrl) {
            scope.email.htmlVariable =
              '<p><a href="' +
              scope.contentUrl +
              '">' +
              scope.contentUrl +
              '</a><br/></p>';
          }
        };
        init();

        scope.$on('urlsharingchanged', function(event, args) {
          scope.email.htmlVariable =
            '<p><a href="' + args + '">' + args + '</a><br/></p>';
        });

        /**
         * get liste users
         */
        UsersFactory.getactiveusers().then(function(res) {
          console.log(res.data);
          res.data.forEach(function(user) {
            user.url = 'img/user/default/user.png';
          });
          scope.usersCol = res.data;
        });

        var emailDialog;
        /**
         * open dialog Email
         * @returns {boolean}
         */
        scope.openModal = function() {
          /**
           * check emailCfg
           */
          if (
            !$rootScope.xgos.portal.sendMailCfg ||
            $rootScope.xgos.portal.sendMailCfg == null
          ) {
            gaJsUtils.errorMessage($filter('translate')('mail_writer.alert'));
            return false;
          }

          emailDialog = ngDialog.open({
            template:
              'js/XG/modules/common/views/directives/email_writer_dialog.html',
            className: 'ngdialog-theme-plain width1000 nopadding miniclose',
            closeByDocument: false,
            scope: scope,
          });
        };

        /**
         * send email
         */
        scope.sendEmail = function() {
          var recipients = scope.recipients.map(function(r) {
            return r.email;
          });

          var recipients_cc = [];
          scope.recipients_cc.forEach(function(recipient) {
            recipients_cc.push(recipient.email);
          });

          if (scope.copy_forself) {
            if (
              $rootScope.xgos.user.email &&
              $rootScope.xgos.user.email != ''
            ) {
              recipients_cc.push($rootScope.xgos.user.email);
            }
          }

          var recipients_bcc = [];
          scope.recipients_bcc.forEach(function(recipient) {
            recipients_bcc.push(recipient.email);
          });

          var mailDesc = [];
          mailDesc.push({
            name: 'mailTo',
            type: 'cst',
            value: recipients,
          });
          mailDesc.push({
            name: 'mailCC',
            type: 'cst',
            value: recipients_cc,
          });
          mailDesc.push({
            name: 'mailBCC',
            type: 'cst',
            value: recipients_bcc,
          });
          mailDesc.push({
            name: 'mailSubject',
            type: 'cst',
            value: scope.email.title,
          });
          mailDesc.push({
            name: 'mailContent',
            type: 'cst',
            value: scope.email.htmlVariable,
          });

          gaDomUtils.showGlobalLoader();
          FunctionFactory.execute(
            { parameters: mailDesc },
            'sendMail',
            'ja'
          ).then(
            function(res) {
              emailDialog.close();
              init();
              gaDomUtils.hideGlobalLoader();
              if (res.data === 'true') {
                gaJsUtils.successMessage(
                  $filter('translate')('mail_writer.success')
                );
              } else
                gaJsUtils.errorMessage(
                  $filter('translate')('mail_writer.error')
                );
            },
            function() {
              emailDialog.close();
              gaDomUtils.hideGlobalLoader();
            }
          );
        };

        /**
         * return button send value
         * @returns {boolean}
         */
        scope.renderValid = function() {
          var res = true;

          if (
            scope.email.title &&
            scope.email.htmlVariable &&
            scope.email.title != '' &&
            scope.email.htmlVariable != '' &&
            scope.recipients.length > 0
          ) {
            res = false;
          }
          return res;
        };

        scope.users = {};
        /**
         * get users from directive 'user-picker'
         * update la liste of recipients
         */
        scope.$watch(
          'users',
          function(users) {
            if (scope.users == {}) return false;
            if (scope.users.to) {
              var logins = [];
              scope.recipients.forEach(function(recipient) {
                logins.push(recipient.login);
              });
              scope.users.to.forEach(function(user) {
                var contains = false;
                logins.forEach(function(login) {
                  if (login == user.login) {
                    contains = true;
                  }
                });
                if (contains == false) {
                  user.url = 'img/user/default/user.png';
                  scope.recipients.push(user);
                  logins.push(user.login);
                }
              });
            }

            if (scope.users.cc) {
              logins = [];
              scope.recipients_cc.forEach(function(recipient) {
                logins.push(recipient.login);
              });
              scope.users.cc.forEach(function(user) {
                var contains = false;
                logins.forEach(function(login) {
                  if (login == user.login) {
                    contains = true;
                  }
                });
                if (contains == false) {
                  user.url = 'img/user/default/user.png';
                  scope.recipients_cc.push(user);
                  logins.push(user.login);
                }
              });
            }

            if (scope.users.bcc) {
              var logins = [];
              scope.recipients_bcc.forEach(function(recipient) {
                logins.push(recipient.login);
              });
              scope.users.bcc.forEach(function(user) {
                var contains = false;
                logins.forEach(function(login) {
                  if (login == user.login) {
                    contains = true;
                  }
                });
                if (contains == false) {
                  user.url = 'img/user/default/user.png';
                  scope.recipients_bcc.push(user);
                  logins.push(user.login);
                }
              });
            }
          },
          1
        );

        /**
         * check string value is email address
         * @returns {boolean}
         */
        var validEmail = function(recipients) {
          for (var i = 0; i < recipients.length; i++) {
            if (!recipients[i].url) {
              recipients[i].url = 'img/user/default/user.png';
            }
            var reg = /^([A-Za-z0-9_\-\.])+\@([A-Za-z0-9_\-\.])+\.([A-Za-z]{2,4})$/;
            if (reg.test(recipients[i].email) == false) {
              recipients.splice(i, 1);
            }
          }
        };

        /**
         * check email address valid
         */
        scope.$watch(
          'recipients',
          function(recipients) {
            validEmail(scope.recipients);
          },
          1
        );

        scope.$watch(
          'recipients_cc',
          function(recipients_cc) {
            validEmail(scope.recipients_cc);
          },
          1
        );

        scope.$watch(
          'recipients_bcc',
          function(recipients_bcc) {
            validEmail(scope.recipients_bcc);
          },
          1
        );
      },
    };
  };

  emailWriter.$inject = [
    'ngDialog',
    'UsersFactory',
    'gaDomUtils',
    'FunctionFactory',
    'gaJsUtils',
    'taOptions',
    '$rootScope',
    '$filter',
  ];
  return emailWriter;
});


define('modules/common/directives/kisGeocoderPicker',[],function() {
  var kisGeocoderPicker = function($rootScope, kisGeocodageFactory) {
    return {
      templateUrl:
        'js/XG/modules/common/views/directives/kis_geocoder_picker.html',
      scope: {
        res: '=', //return id of geocoder
        type: '@?',
        escape: '@?',
        hideDetail: '@?', // hide detail
        multiServer: '@?', // add 'google' and 'nominatim'
      },
      restrict: 'EA',
      link: function(scope, element, attr) {
        scope.kiageocodeurs = $rootScope.xgos.portal.parameters.kisgeocodage;
        /**
         *  if multiServer, add 'google' and 'nominatim'
         */
        if (scope.multiServer) {
          var containGoogle = false,
            containNominatim = false;

          for (var i = 0; i < scope.kiageocodeurs.length; i++) {
            if (scope.kiageocodeurs[i].id == 'google') {
              containGoogle = true;
            }
            if (scope.kiageocodeurs[i].id == 'nominatim') {
              containNominatim = true;
            }
          }
          if (containNominatim == false) {
            scope.kiageocodeurs.unshift({
              label: 'Nominatim',
              id: 'nominatim',
            });
          }
          if (containGoogle == false) {
            scope.kiageocodeurs.unshift({
              label: 'Google',
              id: 'google',
            });
          }
        }

        /**
         * select default
         */
        if (scope.res) {
          if (scope.escape) {
            scope.currentKiscodeur = scope.kiageocodeurs[0];
            var res = angular.copy(scope.res.replace(/\'/g, ''));
            for (var i = 0; i < scope.kiageocodeurs.length; i++) {
              if (res == scope.kiageocodeurs[i].id) {
                scope.currentKiscodeur = scope.kiageocodeurs[i];
              }
            }
          } else {
            for (var i = 0; i < scope.kiageocodeurs.length; i++) {
              if (scope.res == scope.kiageocodeurs[i].id) {
                scope.currentKiscodeur = scope.kiageocodeurs[i];
              }
            }
          }
        } else {
          if (scope.kiageocodeurs)
            scope.currentKiscodeur = scope.kiageocodeurs[0];
          if (scope.currentKiscodeur && scope.currentKiscodeur.id) {
            scope.res = angular.copy(scope.currentKiscodeur.id);
          }
        }

        scope.object = {};

        if (scope.kiageocodeurs && scope.kiageocodeurs.length == 1) {
          scope.currentKiscodeur = scope.kiageocodeurs[0];
          scope.res = angular.copy(scope.currentKiscodeur.id);
        }
        if (scope.escape) {
          scope.res = "'" + scope.res + "'";
        }

        /**
         * use for type select
         */
        scope.selectKisgeocodeur = function() {
          scope.res = angular.copy(scope.currentKiscodeur.id);
          if (scope.escape) {
            scope.res = "'" + scope.res + "'";
          }
        };

        /**
         * use for type checkbox
         */
        scope.$watch(
          'object',
          function(object) {
            if (scope.object != {} && scope.type == 'checkbox') {
              scope.res = [];
              Object.keys(scope.object).forEach(function(key) {
                if (scope.object[key] == true) {
                  scope.res.push(key);
                }
              });
            }
          },
          1
        );
      },
    };
  };

  kisGeocoderPicker.$inject = ['$rootScope', 'kisGeocodageFactory'];
  return kisGeocoderPicker;
});


define('modules/common/directives/positionFeature',[],function() {
  var positionFeature = function(
    ngDialog,
    $rootScope,
    FeatureTypeFactory,
    ogcFactory,
    gcWMS,
    PortalsFactory
  ) {
    return {
      templateUrl:
        'js/XG/modules/common/views/directives/position_feature.html',
      scope: {
        ftid: '=',
        fid: '=?',
        bbox: '=?',
        displayLayers: '=?', // array of fti to display
        positionImage: '=?',
        zoom: '=?', //
        displayFeaturesConfig: '=?', // used with features-config  directive
        tooltip: '=?', //used with ancBacMainReport
      },
      restrict: 'E',
      link: function(scope, element, attr) {
        var CenterOfGeom;
        var portalid = PortalsFactory.getPortalId(),
          map,
          dialogPositionFeature;

        // commentaire
        scope.openFeatureMap = function() {
          dialogPositionFeature = ngDialog.open({
            template:
              'js/XG/modules/common/views/directives/position_feature_dialog.html',
            className: 'ngdialog-theme-plain fullScreen nopadding',
            closeByDocument: false,
            showClose: true,
            scope: scope,
          });
        };

        //Listen After open ng-dialog
        $rootScope.$on('ngDialog.opened', function(e, $dialog) {
          if (
            angular.isUndefined(dialogPositionFeature) ||
            angular.isUndefined(dialogPositionFeature.id) ||
            dialogPositionFeature.id != $dialog[0].id
          ) {
            return false;
          }

          map = new ol.Map({
            layers: [
              new ol.layer.Tile({
                source: new ol.source.OSM(),
              }),
            ],
            target: 'map_position_feature',
            controls: ol.control.defaults({
              attributionOptions: {
                collapsible: false,
              },
            }),
            view: new ol.View({
              projection: 'EPSG:3857',
              center: [0, 0],
              minResolution: 0.03732276771737122,
              zoom: 10,
            }),
          });
          scope.currentMap = map;

          if (angular.isDefined(scope.displayLayers)) {
            scope.displayLayers.forEach(function(f) {
              var l = gcWMS.getOlLayerFromFeaturetypeInfo(f);
              map.addLayer(l);
            });
          }

          var cql_filter = '1=1';
          if (scope.fid.length == 0) {
            cql_filter = '1=2';
          } else if (scope.fid.length > 0) {
            cql_filter = "IN('" + scope.fid.join("','") + "')";
          }

          // afficher la feature et la zoomer
          var setExtent = function() {
            if (angular.isUndefined(scope.fid) || scope.fid.length == 0) {
              FeatureTypeFactory.getExtent(scope.ftid, 'EPSG:3857').then(
                function(res) {
                  map.getView().fit(res.data, map.getSize());
                  affichePositionImage();
                }
              );
            } else {
              //recuperer une feature par fid et ftid
              var promise = ogcFactory.getfeatures(
                'GetFeature',
                'WFS',
                '1.0.0',
                scope.ftid,
                'json',
                'EPSG:3857',
                cql_filter
              );
              promise.then(function(res) {
                //creer une nouvelle source pour cette feature
                var vectorSource = new ol.source.Vector({});
                var parser = new ol.format.GeoJSON();
                for (var i = 0; i < res.data.features.length; i++) {
                  vectorSource.addFeature(
                    parser.readFeature(res.data.features[i])
                  );
                }
                //RECUPERER L'EXTENT DE LA SOURCE
                map.getView().fit(vectorSource.getExtent(), map.getSize());
                affichePositionImage();
                if (scope.zoom) {
                  map.getView().setZoom(parseInt(scope.zoom));
                }
              });
            }
          };

          var affichePositionImage = function() {
            CenterOfGeom = map.getView().getCenter();
            var iconFeature = new ol.Feature({
              geometry: new ol.geom.Point(CenterOfGeom),
            });

            if (scope.positionImage) {
              var iconStyle = new ol.style.Style({
                image: new ol.style.Icon({
                  src: scope.positionImage,
                }),
              });
              iconFeature.setStyle(iconStyle);
            }

            var positionVectorLayer = new ol.layer.Vector({
              source: new ol.source.Vector({
                features: [iconFeature],
              }),
            });
            map.addLayer(positionVectorLayer);
          };

          //Si la bbox existe
          if (angular.isDefined(scope.bbox)) {
            map.getView().fit(scope.bbox, map.getSize());
            affichePositionImage();
          } else {
            //bbox n'eat pas existe
            setExtent();
          }

          //afficher la feature
          var afficherFeature = function() {
            FeatureTypeFactory.get().then(function(res) {
              // adapte aux modification de FeatureFactory.get (doit utiliser res et non plus res.data)
              for (var i = 0; i < res.length; i++) {
                if (res[i].uid === scope.ftid) {
                  map.addLayer(
                    new ol.layer.Tile({
                      source: new ol.source.TileWMS({
                        url:
                          '/services/' +
                          portalid +
                          '/geoserver/wms?token=' +
                          localStorage.auth_token,
                        params: {
                          LAYERS: portalid + ':' + res[i].name,
                          TILED: true,
                          CQL_FILTER: cql_filter,
                        },
                        serverType: 'geoserver',
                      }),
                    })
                  );
                }
              }
            });
          };
          afficherFeature();
        });
      },
    };
  };

  positionFeature.$inject = [
    'ngDialog',
    '$rootScope',
    'FeatureTypeFactory',
    'ogcFactory',
    'gcWMS',
    'PortalsFactory',
  ];
  return positionFeature;
});


define('modules/common/directives/featureHistoryTable',[],function() {
  var featureHistoryTable = function(
    $http,
    ngDialog,
    FeatureHistoryFactory,
    ngTableParams,
    $filter,
    $rootScope,
    $q,
    gaDomUtils,
    gaJsUtils
  ) {
    return {
      templateUrl:
        'js/XG/modules/common/views/directives/feature_history_table.html',
      scope: {
        fid: '=',
        ftid: '=',
        add: '=?',
        remove: '=?',
      },
      restrict: 'E',
      link: function(scope, element, attr) {
        //tableau des actions titles
        scope.action_titles = [''];

        //action title filter
        scope.titleFilter = { x: '' };

        scope.history_active = false;
        if (
          gaJsUtils.checkNestedProperty(
            'parameters.history.active',
            $rootScope.xgos.portal
          )
        ) {
          scope.history_active = true;
        }

        var lengthActions = 0;

        scope.tableFeaturesHistory = new ngTableParams(
          {
            page: 1,
            count: 10,
          },
          {
            total: 0,
            getData: function($defer, params) {
              // ng-class="{ 'disabled ' : disabled }"
              scope.disabled = true;
              var sort, attName;
              attName = Object.keys(params.sorting())[0];
              if (attName == 'Date') {
                attName = 'action_date';
              }
              if (attName && lengthActions != 0) {
                sort =
                  attName +
                  ',' +
                  params.sorting()[Object.keys(params.sorting())[0]];
              }

              console.log('oye');

              //recuperer les actions histories pas count,page et titleFilter
              FeatureHistoryFactory.getactions(
                scope.fid,
                scope.ftid,
                scope.titleFilter.x,
                params.page(),
                params.count(),
                sort
              ).then(function(res) {
                if (!res.data || res.data == '') return false;
                var results = [];
                lengthActions = res.data.features.length;
                for (var i = 0; i < res.data.features.length; i++) {
                  results[i] = res.data.features[i].properties;
                  results[i].id = res.data.features[i].id;
                  results[i].Date = new Date(
                    res.data.features[i].properties.action_date
                  );
                  if (
                    scope.action_titles.indexOf(
                      res.data.features[i].properties.action_title
                    ) == -1
                  ) {
                    scope.action_titles.push(
                      res.data.features[i].properties.action_title
                    );
                  }
                }

                //total
                params.total(res.data.totalFeatures);

                // var orderedData = params.sorting() ? $filter('orderBy')(results, params.orderBy()) : results;
                // scope.histories = orderedData.slice((params.page() - 1) * params.count(), params.page() * params.count());
                //$defer.resolve(orderedData);
                $defer.resolve(results);
                scope.disabled = false;
              });
            },
          }
        );

        scope.$on('$destroy', function(evt) {
          scope.tableFeaturesHistory = null;
        });

        //listen $rootScope $broadcast
        $rootScope.$on('refreshDossierActions', function(event, data) {
          if (data.ftid == scope.ftid && data.fid == scope.fid && scope.tableFeaturesHistory != null) {
            //refresh DossierActions
            scope.tableFeaturesHistory.reload();
          }
        });

        //Refresh DossierAction
        scope.refreshDossierAction = function() {
          scope.tableFeaturesHistory.reload();
        };

        var modal;
        scope.action = {
          date: new Date(),
        };
        scope.openModal = function() {
          modal = ngDialog.open({
            template:
              'js/XG/modules/common/views/modals/modal.featureAction.html',
            className: 'ngdialog-theme-plain width600 miniclose nopadding',
            closeByDocument: false,
            scope: scope,
          });
        };

        var formatDate = function(dateSource) {
          var date = moment(dateSource);
          date = date.toISOString();
          date = $filter('date')(date, 'yyyy-MM-ddTHH:mm:ss.sssZ');
          return date;
        };

        scope.addFeatureHistory = function() {
          scope.action.date = formatDate(scope.action.date);

          var sendata = {
            type: 'FeatureCollection',
            features: [
              {
                type: 'Feature',
                properties: {
                  feature_id: scope.fid,
                  feature_uid: scope.ftid,
                  action_title: scope.action.title,
                  action_description:
                    scope.action.detail + ' par ' + $rootScope.xgos.user.name,
                  user_id: $rootScope.xgos.user.name,
                  action_date: scope.action.date,
                },
              },
            ],
          };

          gaDomUtils.showGlobalLoader();
          FeatureHistoryFactory.addactionwithdate(sendata).then(
            function(res) {
              scope.tableFeaturesHistory.reload();
              gaDomUtils.hideGlobalLoader();
              modal.close();
              scope.action = {
                date: new Date(),
              };
            },
            function(res) {
              gaDomUtils.hideGlobalLoader();
            }
          );
        };

        /**
         * remove histoty
         * @param history
         */
        scope.removeHistory = function(history) {
          var ans = confirm(
            'Êtes-vous certain de vouloir effectuer cette action ?'
          );

          if (ans) {
            gaDomUtils.showGlobalLoader();
            FeatureHistoryFactory.removeaction(history.id).then(
              function(res) {
                scope.tableFeaturesHistory.reload();
                gaDomUtils.hideGlobalLoader();
              },
              function(res) {
                gaDomUtils.hideGlobalLoader();
              }
            );
          }
        };

        // Disable removeBoutton
        scope.disabledButtonRemove = () => {
          let disabeBoutton = true;
          if (angular.isArray($rootScope.xgos.user.roles)) {
            $rootScope.xgos.user.roles.forEach((role)=>{
              if (role.name == 'ANC_responsable' || role.name == 'sRootUser' || role.name == 'rootUser') {
                disabeBoutton =  false
              } 
            })
          }
          return disabeBoutton;
        }
      },
    };
  };

  featureHistoryTable.$inject = [
    '$http',
    'ngDialog',
    'FeatureHistoryFactory',
    'ngTableParams',
    '$filter',
    '$rootScope',
    '$q',
    'gaDomUtils',
    'gaJsUtils',
  ];
  return featureHistoryTable;
});


define('modules/common/directives/imageLibraryPicker',['toastr','toastr','toastr'],function() {
  var imageLibraryPicker = function(
    StyleFactory,
    ngDialog,
    gaDomUtils,
    $filter,
    $timeout
  ) {
    return {
      templateUrl:
        'js/XG/modules/common/views/directives/image_library_picker.html',
      scope: {
        imagePicked: '&?', // function called when an image is selected
        imageSelected: '=?', // already selected image
      },
      restrict: 'E',
      controller: [
        '$scope',
        function($scope) {
          $scope.imageTreeControl = {};
        },
      ],
      link: function(scope, element, attr) {
        // Initialisation du timestamp pour forcer le rechargement des images
        scope.timestamp = Date.now();
        
        /**
         * initial selection
         */
        if (scope.imageSelected) {
          var image = scope.imageSelected.split('/');
          scope.currentImg = image[image.length - 1];
        }

        scope.pickimages = [];
        scope.setImage = function(img) {
          // En session de suppression, la sélection d'une image coche la checkbox
          if (scope.isDeletingPortalImage) {
            if (!scope.portalImagesToDelete[img]) {
              scope.portalImagesToDelete[img] = true;
            } else {
              scope.portalImagesToDelete[img] = false;
            }
          } else {
            scope.currentImg = img; // used for css selected
            scope.imagePicked({
              data: {
                img: img,
                url: scope.pick.url,
              },
            });
          }
        };

        /**
         * Choosing an image folder
         * @param branch
         */
        scope.tree_handler = function(branch) {
          // display children images when parent is selected
          if (branch.mainfolder && !branch.images && branch.children) {
            branch.images = [];

            branch.children.forEach(function(sub) {
              if (sub.images) {
                sub.images.forEach(function(image) {
                  branch.images.push(sub.path + image);
                });
              }
            });
          }

          scope.pick = {
            images: branch.images,
            folder: branch.label,
            path: branch.path,
            url: branch.url,
            type: branch.type,
          };
          
          // Mise à jour du timestamp pour forcer le rechargement des images
          scope.timestamp = Date.now();
        };

        /**
         * Retrieve images list
         */
        var refreshSymbolImages = function() {
          return StyleFactory.getsymbolsimages().then(function(res) {
            var folders = [];

            if (angular.isDefined(res.data.portal[0])) {
              res.data.portal[0].label = $filter('translate')(
                'model.styles.editor.symbolizers.common.portal_images'
              );
              folders.push(res.data.portal[0]);

              res.data.common[0].label = $filter('translate')(
                'model.styles.editor.symbolizers.common.common_images'
              );
              folders.push(res.data.common[0]);
            }

            scope.imgfolders = folders;
            
            // Mise à jour du timestamp pour forcer le rechargement des images
            scope.timestamp = Date.now();

            $timeout(function() {
              if (scope.imageTreeControl.collapse_all != undefined) {
                scope.imageTreeControl.collapse_all();
                var communes = folders[1];
                scope.imageTreeControl.expand_branch(communes);
              }
            }, 0);

            /**
             * initial selection
             */
            if (scope.imageSelected) {
              var path = scope.imageSelected.split('/');
              var start = false;
              var new_path = [];
              for (var i = 0; i < path.length; i++) {
                if (start == true) {
                  new_path.push(path[i]);
                }
                if (path[i] == 'kis') {
                  start = true;
                }
              }
              scope.imgfolders.forEach(function(folder) {
                if (folder.children.length == 0 && new_path[0] != 'common') {
                  openBranch(folder);
                } else {
                  folder.children.forEach(function(child) {
                    if (new_path[2] == child.label) {
                      if (child.children.length == 0 || new_path.length == 4) {
                        openBranch(child);
                      } else {
                        child.children.forEach(function(c) {
                          if (new_path[3] == c.label) {
                            openBranch(c);
                          }
                        });
                      }
                    }
                  });
                }
              });
            }
          });
        };
        refreshSymbolImages();

        /**
         * open branch of tree
         * @param branch
         */
        var openBranch = function(branch) {
          $timeout(function() {
            scope.imageTreeControl.select_branch(branch);
          }, 0);
        };

        /** Upload File **/
        scope.uploadNewPortalImage = function(input) {

          // Ferme la session de suppression si elle était ouverte
          scope.stopPortalImagesDeletingSelection();

          scope.currentUploadFolder = scope.pick;

          // Méthode interne exécutée après vérifications: isFormatValid, imageNameAlreadyPresent, imageNameHasComma
          const processUpload = () => {
            gaDomUtils.showGlobalLoader();
            scope.staticFile = input.files[0];
            var fd = new FormData();
            fd.append('file', scope.staticFile);

            StyleFactory.uploadnewimage(fd, scope.currentUploadFolder.path).then(
                function(data) {
                  // Mise à jour du timestamp pour forcer le rechargement des images après upload
                  scope.timestamp = Date.now();
                  refreshSymbolImages().then(function() {
                    gaDomUtils.hideGlobalLoader();

                    // Après le rechargement des images, sélectionner le même dossier
                    if (scope.currentUploadFolder && scope.currentUploadFolder.type === 'portal') {
                      const portalGrp = scope.imgfolders.find(grp => grp.type === 'portal');
                      if (portalGrp) {
                        scope.tree_handler(portalGrp);
                      }
                    }

                    scope.pick = false;
                  });
                },
                err => {
                  gaDomUtils.hideGlobalLoader();
                  scope.pick = false;
                  console.error(err.data);
                }
            );
          };
          // Méthode interne exécutée quand isFormatNotValid ou imageNameHasComma
          const alertImportError = (translationKey, additionalText) => {
            swal({
              title: $filter('translate')(
                  'model.styles.editor.symbolizers.common.' + translationKey + 'Title')
              + additionalText ? additionalText : '',
              text: $filter('translate')('model.styles.editor.symbolizers.common.' + translationKey + 'Text'),
              type: 'error',
              showCancelButton: false,
              confirmButtonColor: '#CCC',
              confirmButtonText: $filter('translate')('common.ok'),
              closeOnConfirm: true,
            });
          };

          const importingFileName = input.files[0].name;

          // Le fichier importé doit être un png ou un svg
          const isFormatNotValid = !importingFileName.endsWith('png') && !importingFileName.endsWith('svg');

          // L'import doit détecter si le fichier importé existe déjà parmis les images de portail disponibles
          const imageNameAlreadyPresent = scope.imgfolders.find(
              grp => grp.type === 'portal').images.some(
              img => img.toLowerCase() === importingFileName.toLowerCase());

          // Le nom du fichier ne doit pas contenir de virgule (la virgule est réservée en caractère séparateur pour la suppression)
          const imageNameHasComma = importingFileName.includes(',');

          if (isFormatNotValid) {
            alertImportError('badFormat', importingFileName);
            return;
          }
          if (imageNameHasComma) {
            alertImportError('badFileName', importingFileName);
            return;
          }
          if (imageNameAlreadyPresent) {
            scope.importingFileName = importingFileName;
            const confirm = ngDialog.openConfirm({
              template: 'js/XG/widgets/mapapp/style/views/modals/modal.uploadimage.confirm.html',
              className: 'ngdialog-theme-plain width600 nopadding miniclose',
              scope: scope,
            });
            confirm.then(
                (data) => {
                  if (data) {
                    processUpload();
                  }
                },
                () => {
                }
            ).finally(
                () => {
                  scope.importingFileName = null;
                }
            );
          } else {
            processUpload();
          }
        };

        /**
         * Au clic sur le bouton "Supprimer" de l'encart des images de portail.
         * Démarre une "session de suppression": les boutons d'action et les checkboxes apparaissent
         */
        scope.startPortalImagesDeletingSelection = () => {
          scope.portalImagesToDelete = {};  // Stockage des noms d'images de portail à supprimer
          scope.isDeletingPortalImage = true; // Affichage des boutons et checkboxes
        };

        /**
         * Au clic sur le bouton "Annuler" (croix) la session de suppression des images de portail.
         * Annule la "session de suppression": les boutons d'action et les checkboxes disparaissent
         */
        scope.stopPortalImagesDeletingSelection = () => {
          scope.portalImagesToDelete = {};
          scope.isDeletingPortalImage = false;
        };

        /**
         * Au clic sur le bouton de confirmation rouge "Supprimer" (poubelle).
         * Exécute la suppression des images, ferme la session de suppression
         * et rafraîchit la liste des images de portail
         */
        scope.portalImagesConfirmDelete = () => {
          const toDeleteFileNames = Object.entries(scope.portalImagesToDelete)
          .filter(([key, value]) => value === true)
          .map(([key, value]) => key);
          if (toDeleteFileNames.length > 0) {
            StyleFactory.deletePortalImageFiles(toDeleteFileNames.join(',')).then(
                res => {
                  if (res.data) {
                    // gestion des images non supprimées
                    if (res.data.hasOwnProperty('fails') && Array.isArray(res.data.fails)
                        && res.data.fails.length > 0) {
                      require('toastr').warning($filter('translate')('model.styles.editor.symbolizers.common.deleteNotComplete'));
                    }
                    // gestion des erreurs de lecture de fichier sld
                    if (res.data.hasOwnProperty('errors') && Array.isArray(res.data.errors)
                        && res.data.errors.length > 0) {
                      console.error('portalImagesConfirmDelete : ', res.data.errors.join(', '));
                    }
                    // gestion des images supprimées
                    if (res.data.hasOwnProperty('deleted') && Array.isArray(res.data.deleted)
                        && res.data.deleted.length > 0) {

                      // supprime les images du front
                      const portalGrp = scope.imgfolders.find(grp => grp.type === 'portal');
                      portalGrp.images = portalGrp.images.filter(img => !res.data.deleted.includes(img));
                      // Sélectionne le groupe des images du portail
                      scope.tree_handler(portalGrp);
                    }
                    scope.isDeletingPortalImage = false;
                  } else {
                    require('toastr').error($filter('translate')('model.styles.editor.symbolizers.common.serverError'));
                    scope.isDeletingPortalImage = false;
                  }
                },
                err => {
                  require('toastr').error($filter('translate')('model.styles.editor.symbolizers.common.serverError'));
                  console.error("portalImagesConfirmDelete error : ", err.data);
                  scope.isDeletingPortalImage = false;
                }
            );
          } else {
            scope.isDeletingPortalImage = false;
          }
        };
      },
    };
  };

  imageLibraryPicker.$inject = [
    'StyleFactory',
    'ngDialog',
    'gaDomUtils',
    '$filter',
    '$timeout'
  ];
  return imageLibraryPicker;
});


define('modules/common/directives/jsonText',[],() => {
  var jsonText = () => {
    return {
        restrict: 'A',
        require: 'ngModel',
        link: function(scope, element, attr, ngModel) {            
          let stringToJson = (input) => {
            try {
                return JSON.parse(input);
            } catch (error) {
                return input;
            }
            
          }
          let jsonToString = (data) => {
            try {
                return JSON.stringify(data);
            } catch (error) {
                return data;
            }
          }
          ngModel.$parsers.push(stringToJson);
          ngModel.$formatters.push(jsonToString);
        }
    };
  };
  return jsonText;
});


define('modules/common/directives/arrayNumberInput',[],function() {
  /**
   *
   * @returns {{restrict: string, templateUrl: string}}
   */
  var arrayNumberInput = function() {
    return {
      restrict: 'A',
      templateUrl:
        'js/XG/modules/common/views/directives/arrayNumberInput.html',
      scope: {
        res: '=',
      },
      link: function(scope) {
        // Convert string number to number
        for (var i = 0; i < scope.res.length; i++) {
          var nb = Number(scope.res[i]);
          scope.res[i] = nb;

          scope.lines = angular.isArray(scope.res) ? scope.res : [0];
        }

        /**
         * Add a line
         */
        scope.addLine = function() {
          var lastIndex = scope.lines.length - 1;
          var lastLine = scope.lines[lastIndex];

          if (lastLine) {
            scope.lines.push('');
          }
        };

        /**
         * Delete a line
         * @param index
         */
        scope.deleteLine = function(index) {
          scope.lines.splice(index, 1);
        };

        /**
         * Update res
         */
        scope.$watch(
          'lines',
          function(lines) {
            scope.res = lines;
          },
          1
        );
      },
    };
  };

  arrayNumberInput.$inject = [];

  return arrayNumberInput;
});


define('modules/common/directives/kisSocialShare',[],function() {
  /**
   *
   * @returns {{restrict: string, templateUrl: string}}
   */
  var kisSocialShare = function() {
    return {
      restrict: 'EA',
      templateUrl:
        'js/XG/modules/common/views/directives/kis_social_share.html',
      scope: {
        text: '=?', // preset text
        url: '=?', // preset url
        tags: '=?', // preset comma separated tags (ie : kis, sig, altereo)
        services: '=?', // array of services names (ie ['twitter','facebook','linkedin'])
        disabled: '=?', // disabled buttons
      },
      link: function(scope) {
        if (!angular.isDefined(scope.text)) {
          scope.text = 'KIS, le SIG qui vous simplifie la ville';
        }
        if (!angular.isDefined(scope.url)) {
          scope.url = 'KIS, le SIG qui vous simplifie la ville';
        }
        if (!angular.isDefined(scope.tags)) {
          scope.tags = 'kis, sig';
        }
        if (!angular.isDefined(scope.disabled)) {
          scope.disabled = false;
        }
      },
    };
  };

  kisSocialShare.$inject = [];
  return kisSocialShare;
});


define('modules/common/directives/optionClass',[],function() {
  var optionClass = function() {
    return {
      require: 'select',
      link: function(scope, elem, attrs, ngSelect) {
        // get the source for the items array that populates the select.
        console.log('!');

        var optionsSourceStr = attrs.ngOptions.split(' ').pop(),
          // use $parse to get a function from the options-class attribute
          // that you can use to evaluate later.
          getOptionsClass = $parse(attrs.optionsClass);

        scope.$watch(optionsSourceStr, function(items) {
          // when the options source changes loop through its items.
          angular.forEach(items, function(item, index) {
            // evaluate against the item to get a mapping object for
            // for your classes.
            var classes = getOptionsClass(item),
              // also get the option you're going to need. This can be found
              // by looking for the option with the appropriate index in the
              // value attribute.
              option = elem.find('option[value=' + index + ']');

            // now loop through the key/value pairs in the mapping object
            // and apply the classes that evaluated to be truthy.
            angular.forEach(classes, function(add, className) {
              if (add) {
                angular.element(option).addClass(className);
              }
            });
          });
        });
      },
    };
  };

  optionClass.$inject = [];
  return optionClass;
});


define('modules/common/directives/executeQuery',[],function() {
  /**
   *
   */
  var executequery = function(
    QueryFactory,
    gaDomUtils,
    SelectManager,
    panelsManager,
    FeatureTypeFactory,
    AlertHpoFactory,
    $filter,
    ngDialog,
    DataStoreFactory,
    sldUtils,
    $timeout,
    $rootScope,
    extendedNgDialog,
    ngTableParams
  ) {
    return {
      templateUrl: 'js/XG/modules/common/views/directives/executeQuery.html',
      restrict: 'EA',
      scope: {
        fti: '=?',
        res: '=?',
      },
      link: function(scope) {
        scope.dbselector = {};
        scope.exect = {
          analysistool: 'allanalysis',
          result: [],
          geoj: {},
          requet: '',
          attributestouseindatatable: [],
          exportCSV: '',
        };

        $timeout(function() {
          scope.codeEditor = CodeMirror.fromTextArea(
            document.getElementById('code'),
            {
              mode: 'sql',
              indentWithTabs: true,
              smartIndent: true,
              lineNumbers: true,
              matchBrackets: true,
              autofocus: true,
              extraKeys: {
                'Ctrl-Space': 'autocomplete',
              },
              onChange: function() {
                scope.codeEditor.save();
              },
            }
          );
          scope.codeEditor.setSize('100%', '100%');
        }, 0);

        scope.saveCFG = function() {
          if (scope.codeEditor != undefined) {
            scope.codeEditor.setValue(scope.exect.requet);
            scope.codeEditor.on('change', function(cMirror) {
              scope.exect.requet = cMirror.getValue();
            });
          }
        };

        scope.loadDataStores = function() {
          DataStoreFactory.get().then(function(res) {
            if (res.data.length != 0) {
              scope.datasources = res.data;
              if (res.data.length == 1)
                scope.dbselector.choice = res.data[0].name;
              // else
              // scope.dbselector.choice = "";
            }
          });
        };
        scope.loadDataStores();
        scope.listFich = function() {
          scope.isroot = $rootScope.xgos.isroot;
          gaDomUtils.showGlobalLoader();
          var promise = QueryFactory.listFichSQL();
          promise.then(
            function(res) {
              scope.listTitreNomfile = res.data;
              scope.exect.requet = '';
              scope.saveCFG();
              if (Object.getOwnPropertyNames(res.data).length > 0) {
                scope.autocompleteglobalsearch = Object.keys(
                  scope.listTitreNomfile
                );
                scope.autocompleteglobalsearchinclude = [];
                res.data = Object.keys(res.data);
                var used;
                res.data.map(function(x) {
                  scope.obj = {
                    name: x,
                  };
                  if (used && used.indexOf(x) !== -1) scope.obj.selected = true;
                  scope.autocompleteglobalsearchinclude.push(scope.obj);
                });
              } else {
                scope.autocompleteglobalsearch = [];
                scope.autocompleteglobalsearchinclude = [];
              }
              gaDomUtils.hideGlobalLoader();
            },
            function(res) {
              scope.autocompleteglobalsearch = [];
              console.error(res);
              gaDomUtils.hideGlobalLoader();
            }
          );
        };

        scope.listFich();

        scope.exect.requet = null;

        scope.affichQuery = function(data, ds) {
          scope.ftisRequete = [];
          scope.operateurs = [];
          scope.exect = {};
          scope.feat = {};

          if (data != 'res.newValue') {
            data = scope.listTitreNomfile[data];
            scope.exect.exportCSV = data;
            gaDomUtils.showGlobalLoader();
            var promise = QueryFactory.afficherequet(data, ds);
            promise.then(
              function(res) {
                scope.exect.requet = res.data.requete;
                scope.exect.params = res.data.params;
                scope.exect.fieldsJson = res.data.fieldsJson;
                if (
                  scope.exect.params != undefined &&
                  scope.exect.params !== '' &&
                  scope.exect.params.length != 0
                ) {
                  for (var i in scope.exect.params) {
                    var tableName = scope.exect.params[i].table;
                    var parameName = scope.exect.params[i].attribut;
                    var operande = scope.exect.params[i].operande;
                    if (
                      !scope.ftisRequete[tableName] ||
                      tableName === 'kis_anc_dossier_controle_reponse'
                    ) {
                      if (tableName === 'kis_anc_dossier_controle_reponse') {
                        var fti = res.data.fakeFti;
                        for (var j in fti.attributes) {
                          if (fti.attributes[j].name === parameName) {
                            scope.exect.params[i].alias =
                              fti.attributes[j].alias;
                          }
                        }
                      } else {
                        var fti = FeatureTypeFactory.getFeatureByNameAndDatastore(
                          ds,
                          tableName
                        );
                      }
                      if (fti != false) {
                        scope.ftisRequete[tableName] = fti;
                        scope.operateurs[
                          tableName + parameName
                        ] = scope.listOperateursByAttributType(fti, parameName);
                        scope.saveCFG();
                        gaDomUtils.hideGlobalLoader();
                      } else {
                        AlertHpoFactory.alertConfirmCallback(
                          $filter('translate')('executQuery.alert.error'),
                          $filter('translate')(
                            'executQuery.alert.ftipasValide'
                          ),
                          'warning',
                          true,
                          'ok',
                          '#F50072',
                          false,
                          undefined,
                          undefined,
                          true,
                          false,
                          null
                        );
                        gaDomUtils.hideGlobalLoader();
                        scope.exect.params = '';
                        scope.exect.requet = '';
                        scope.saveCFG();
                        break;
                      }
                    } else {
                      scope.operateurs[
                        tableName + parameName
                      ] = scope.listOperateursByAttributType(
                        scope.ftisRequete[tableName],
                        parameName
                      );
                      scope.saveCFG();
                      gaDomUtils.hideGlobalLoader();
                    }
                  }
                } else {
                  AlertHpoFactory.alertConfirmCallback(
                    $filter('translate')('executQuery.alert.warning'),
                    $filter('translate')('executQuery.alert.paramvide'),
                    'warning',
                    true,
                    'ok',
                    '#F50072',
                    false,
                    undefined,
                    undefined,
                    true,
                    false,
                    null
                  );

                  scope.saveCFG();
                  gaDomUtils.hideGlobalLoader();
                }
              },
              function(res) {
                AlertHpoFactory.showErrorMessage(res);
                gaDomUtils.hideGlobalLoader();
              }
            );
          } else {
            scope.exect.requet = '';
            scope.saveCFG();
          }
        };

        scope.MAJFichSQL = function(nomFich, data) {
          var callback = function(confirmed) {
            if (confirmed) {
              gaDomUtils.showGlobalLoader();
              var promise = QueryFactory.MAJFichSQL(nomFich, data);
              promise.then(function(res) {
                AlertHpoFactory.getSimpleSuccess(
                  $filter('translate')('executQuery.alert.succes'),
                  $filter('translate')('executQuery.alert.valider'),
                  false
                );
                gaDomUtils.hideGlobalLoader();
              });
            }
          };
          AlertHpoFactory.alertConfirmCallback(
            $filter('translate')('executQuery.alert.warning'),
            $filter('translate')('executQuery.alert.mettreajour'),
            'warning',
            true,
            undefined,
            '#F50072',
            true,
            undefined,
            undefined,
            true,
            true,
            callback
          );
        };
        scope.queryname = undefined;
        scope.ngDialogPromise;
        scope.saveFichSQLHtml =
          'js/XG/modules/common/views/directives/saveFichSQL.html';

        scope.createFichSQL = function(query, ds) {
          if (query.trim() == '') {
            AlertHpoFactory.getSimpleFail(
              $filter('translate')('executQuery.alert.warning'),
              $filter('translate')('executQuery.alert.erreur'),
              true
            );
          } else {
            scope.ngDialogPromise = ngDialog.openConfirm({
              template: scope.saveFichSQLHtml,
              scope: scope,
              className: 'ngdialog-theme-plain width600 nopadding miniclose',
            });
            var callback = function(confirmed) {
              scope.createFichSQL(query, ds);
            };

            scope.ngDialogPromise.then(function(data) {
              if (
                scope.autocompleteglobalsearch != null &&
                scope.autocompleteglobalsearch.includes(data)
              ) {
                AlertHpoFactory.alertConfirmCallback(
                  $filter('translate')('executQuery.alert.error'),
                  $filter('translate')('executQuery.alert.existe'),
                  'warning',
                  true,
                  'ok',
                  '#F50072',
                  false,
                  undefined,
                  undefined,
                  true,
                  false,
                  callback
                );

                // require('toastr').error($filter('translate')('executQuery.alert.existe'));
              } else {
                gaDomUtils.showGlobalLoader();
                var promise = QueryFactory.createFichSQL(data, query);
                promise.then(
                  function(res) {
                    scope.listFich(ds);
                    AlertHpoFactory.getSimpleSuccess(
                      $filter('translate')('executQuery.alert.succes'),
                      $filter('translate')('executQuery.alert.valider'),
                      false
                    );
                    gaDomUtils.hideGlobalLoader();
                    scope.res.newValue = false;
                    scope.res.value = data;
                    scope.listTitreNomfile[data] = res.data;
                    scope.affichQuery(data, ds);
                  },
                  function(res) {
                    AlertHpoFactory.showErrorMessage(res);
                    gaDomUtils.hideGlobalLoader();
                  }
                );
              }
            });
          }
        };

        scope.$watch('res.value', function() {
          if (scope.res != undefined) {
            if (document.getElementsByName('newValue')['0'].selected) {
              scope.res.newValue = true;
            } else {
              scope.res.newValue = false;
            }
          }
        });

        scope.monresult = {};

        scope.test = false;
        scope.executeFich = function(data, ds) {
          var exect = angular.copy(scope.exect);
          gaDomUtils.showGlobalLoader();
          console.log(data);
          var promise = QueryFactory.executFichSQL(ds, exect);
          promise.then(
            function(res) {
              gaDomUtils.hideGlobalLoader();
              console.log(res.data != undefined);
              if (res.data != undefined) {
                var tmp = angular.copy(res.data);
                delete tmp.tablename;
                scope.exect.result = tmp;
                scope.fti = scope.exect.result.featureTypeInfo;
                scope.exect.attributestouseindatatable =
                  scope.exect.result.featureTypeInfo.attributes;
                SelectManager.addFeaturesFromGeojson(scope.exect.result);

                scope.feat = SelectManager.getFeatures();
                console.log(scope.exect.result);
                if ($rootScope.xgos && $rootScope.xgos.sector === 'map') {
                  scope.test = false;
                  if (scope.feat.totalFeatures > 0) {
                    scope.vopenTabPanels();
                    gaDomUtils.hideGlobalLoader();
                  }
                } else if (
                  $rootScope.xgos &&
                  $rootScope.xgos.sector === 'anc'
                ) {
                  console.log('OK !');

                  $rootScope.$broadcast('testTestResultTable', {
                    resultData: scope.exect,
                  });
                } else {
                  scope.test = true;
                }
              }
            },
            function(res) {
              AlertHpoFactory.showErrorMessage(res);
              gaDomUtils.hideGlobalLoader();
            }
          );
        };

        scope.show_selected = function() {
          var selector = document.getElementById('id_of_select');
          var value = selector[selector.selectedIndex].innerHTML;
          if (value === 'exists' || value === 'notexists') {
            $scope.buttonDisabled = false;
          } else {
            $scope.buttonDisabled = true;
          }
        };

        scope.layerdatatable = {};
        scope.vopenTabPanels = function() {
          scope.geoj = SelectManager.getFeaturesByftiType(scope.fti.name);
          scope.layerdatatable.height = 320;
          scope.closepanel();
          panelsManager.addPanel({
            id: 'selecttab',
            stickToRight: true,
            templateUrl:
              'js/XG/modules/common/views/directives/popexectDatatable.html',
            scope: scope,
            stickToBorder: true,
            visible: true,
            resizable: true,
          });
        };
        scope.closepanel = function() {
          panelsManager.removePanel('selecttab');
        };

        scope.opengraph = function() {
          console.log(scope.result);
          extendedNgDialog.open({
            template:
              'js/XG/widgets/mapapp/layerManager/views/charts/SelectedCharts.html',
            className: 'ngdialog-theme-plain width1000 nopadding miniclose',
            closeByDocument: false,
            scope: scope,
            draggable: true,
            title: $filter('translate')('layermanager.charts'),
          });
        };
        scope.getMap = function(aScope) {
          if (aScope == null) return undefined;
          if (aScope.map != undefined) return aScope.map;
          else return scope.getMap(aScope.$parent);
        };
        scope.map = scope.getMap(scope);

        scope.checkData = function(v) {
          var b = false;
          if (v instanceof Array) {
            if (b.length === 0) b = true;
          } else {
            if (Object.keys(v).length === 0) b = true;
          }
          return b;
        };
        scope.listOperateursByAttributType = function(fti, attributName) {
          var attributType = '';

          for (var ind = 0; ind < fti.attributes.length; ind++) {
            if (fti.attributes[ind].name == attributName) {
              attributType = fti.attributes[ind].type;

              if (attributType !== '') {
                switch (attributType) {
                  case 'text':
                    fti.attributes[ind].type = 'java.lang.String';
                    break;
                  case 'date':
                    fti.attributes[ind].type = 'java.sql.Timestamp';
                    break;
                  case 'number':
                    fti.attributes[ind].type = 'java.lang.Integer';
                    break;
                  case 'checkbox':
                  case 'radio':
                    fti.attributes[ind].type = 'java.lang.Boolean';
                    break;
                }
              }
            }
          }

          var operandsList = {
            Boolean: [
              {
                key: 'equals',
                label: 'equals',
              },
              {
                key: 'exists',
                label: 'exists',
              },
              {
                key: 'notexists',
                label: 'notexists',
              },
            ],

            Date: [
              {
                key: 'equals',
                label: 'equals',
              },
              {
                key: 'gt',
                label: 'gt;',
              },
              {
                key: 'gte',
                label: 'gte;',
              },
              {
                key: 'lt',
                label: 'lt;',
              },
              {
                key: 'lte',
                label: 'lte;',
              },
              {
                key: 'exists',
                label: 'exists',
              },
              {
                key: 'notexists',
                label: 'notexists',
              },
              {
                key: 'between',
                label: 'between',
              },
            ],

            Number: [
              {
                key: 'equals',
                label: 'equals',
              },
              {
                key: 'gt',
                label: 'gt;',
              },
              {
                key: 'gte',
                label: 'gte;',
              },
              {
                key: 'lt',
                label: 'lt;',
              },
              {
                key: 'lte',
                label: 'lte;',
              },
              {
                key: 'exists',
                label: 'exists',
              },
              {
                key: 'notexists',
                label: 'notexists',
              },
            ],

            String: [
              {
                key: 'startWith',
                label: 'startswith',
              },
              {
                key: 'endWith',
                label: 'endWith',
              },
              {
                key: 'regexp',
                label: 'regexp',
              },
              {
                key: 'inclus',
                label: 'inclus',
              },
              {
                key: 'equals',
                label: 'equals',
              },
              {
                key: 'notEquals',
                label: 'notEquals',
              },
              {
                key: 'exists',
                label: 'exists',
              },
              {
                key: 'notexists',
                label: 'notexists',
              },
            ],
          };

          var metaAttributType = '';

          if (attributType !== '') {
            switch (attributType) {
              case 'text':
              case 'java.lang.String':
              case 'java.lang.Character':
              case 'java.lang.CharSequence':
                metaAttributType = 'String';
                break;

              case 'number':
              case 'java.lang.Integer':
              case 'java.lang.Short':
              case 'java.lang.Double':
              case 'java.lang.Float':
              case 'java.math.BigDecimal':
              case 'java.lang.Long':
                metaAttributType = 'Number';
                break;

              case 'date':
              case 'java.sql.Timestamp':
              case 'java.lang.Timestamp':
              case 'java.sql.Date':
              case 'java.util.Date':
              case 'java.util.TimeZone':
                metaAttributType = 'Date';
                break;

              case 'checkbox':
              case 'radio':
              case 'java.lang.Boolean':
                metaAttributType = 'Boolean';
                break;
            }

            return operandsList[metaAttributType];
          }
        };
      },
    };
  };
  executequery.$inject = [
    'QueryFactory',
    'gaDomUtils',
    'SelectManager',
    'panelsManager',
    'FeatureTypeFactory',
    'AlertHpoFactory',
    '$filter',
    'ngDialog',
    'DataStoreFactory',
    'sldUtils',
    '$timeout',
    '$rootScope',
    'extendedNgDialog',
    'ngTableParams',
  ];
  return executequery;
});


define('modules/common/directives/executeQueryManager',[],function() {
  var executeQueryManager = function(
    $rootScope,
    QueryFactory,
    $filter,
    panelsManager,
    AlertHpoFactory,
    DataStoreFactory,
    ngDialog,
    extendedNgDialog,
    $location,
    gclayers,
    SelectManager
  ) {
    return {
      templateUrl:
        'js/XG/modules/common/views/directives/executeQueryManagerWidget.html',
      restrict: 'EA',
      replace: true,
      link: function($scope) {
        $rootScope.$on('elementResized', function(event, args) {
          if (args.element.type == 'panel' && args.element.id == 'selecttab') {
            var currHeight =
              $scope.layerdatatable.height + args.transformation.y;
            try {
              $scope.$apply(($scope.layerdatatable.height = currHeight));
            } catch(err) {}
          }
        });

        $scope.currentAppName = localStorage.getItem('app')
          ? localStorage.getItem('app')
          : $location.search().app;
        $scope.ConfigName = $scope.ConfigName
          ? $scope.ConfigName
          : $location.search().app;
        $scope.query = 'query';
        $scope.isroot = $rootScope.xgos.isroot || $rootScope.xgos.isadmin;

        $scope.roles = $rootScope.xgos.user.roles;
        $scope.hiddenPanels = {};
        $scope.allPanelHidden = false;
        $scope.hideAllPanels = function() {
          for (var categorie in $scope.categories) {
            var titre = $scope.categories[categorie].properties.titre;
            $scope.hiddenPanels[titre] = true;
            $scope.allPanelHidden = true;
          }
        };
        $scope.showAllPanels = function() {
          $scope.hiddenPanels = {};
          $scope.allPanelHidden = false;
        };

        $scope.requeteHiddenNoRoles = {};
        $scope.catHiddenNoRoles = {};

        $scope.existRoleAdminSQL = function() {
          for (var roleIndice in $scope.roles) {
            var roleName = $scope.roles[roleIndice].name;
            if ('admin_requete_sql' === roleName) {
              $scope.isroot = true;
            }
          }
        };
        $scope.existRoleAdminSQL();
        $scope.getRolesByUidRequeteAndCat = function() {
          for (var categorieIndice in $scope.categories) {
            $scope.catHiddenNoRoles[
              $scope.categories[categorieIndice].properties.uid
            ] = false;
            var requetes =
              $scope.categories[categorieIndice].properties.requetes;
            for (var requeteIndice in requetes) {
              var uid = requetes[requeteIndice].uid;
              $scope.requeteHiddenNoRoles[uid] = false;
              var rolesRequetes = requetes[requeteIndice].roles;
              if ($scope.isNotEmpty(rolesRequetes)) {
                for (var roleIndice in $scope.roles) {
                  var roleName = $scope.roles[roleIndice].name;
                  if (rolesRequetes.indexOf(roleName) >= 0 || $scope.isroot) {
                    $scope.requeteHiddenNoRoles[uid] = true;
                    $scope.catHiddenNoRoles[
                      $scope.categories[categorieIndice].properties.uid
                    ] = true;
                  }
                }
              } else {
                $scope.requeteHiddenNoRoles[uid] = true;
                $scope.catHiddenNoRoles[
                  $scope.categories[categorieIndice].properties.uid
                ] = true;
              }
            }
          }
        };

        $scope.categories = [];
        $scope.getFilterCategories = function() {
          $scope.currentAppName = localStorage.getItem('app')
            ? localStorage.getItem('app')
            : $location.search().app;
          QueryFactory.getFilterCategories(
            $scope.currentAppName,
            $scope.ConfigName
          ).then(function(res) {
            if (res.data.length != 0) {
              $scope.categories = res.data.features;
              $scope.getRolesByUidRequeteAndCat();
            }
          });
        };
        $scope.getFilterCategories();
        /***************************************************************
         * Récupération de la liste des base de données
         **************************************************************/
        $scope.datasources = [];
        $scope.dbselector = '';
        $scope.loadDataStores = function() {
          DataStoreFactory.get().then(function(res) {
            if (res.data.length != 0) {
              for (var indice in res.data) {
                $scope.datasources[indice] = res.data[indice].name;
              }
              if (res.data.length == 1) $scope.dbselector = res.data[0].name;
            }
          });
        };
        $scope.loadDataStores();
        /***************************************************************
         * Open Dialogs
         **************************************************************/
        $scope.categorieDialog = function() {
          $scope.categorieDialogOpen = ngDialog.open({
            template:
              'js/XG/modules/common/views/modals/modal.add.categorie.html',
            className:
              'ngdialog nopadding miniclose ngdialog-overlay ngdialog-theme-plain width700 ng-$scope',
            closeByDocument: false,
            scope: $scope,
          });
        };

        $scope.queryDialog = function() {
          $scope.queryDialogOpen = ngDialog.open({
            template:
              'js/XG/modules/common/views/modals/modal.add.requete.html',
            className:
              'ngdialog nopadding miniclose ngdialog-overlay ngdialog-theme-plain width1000 ng-$scope',
            closeByDocument: false,
            scope: $scope,
          });
        };

        $scope.executeQueryDialog = function() {
          $scope.nombreLigne = [];
          $scope.executeQueryDialogOpen = ngDialog.open({
            template:
              'js/XG/modules/common/views/modals/modal.execute.requete.html',
            className:
              'ngdialog nopadding miniclose ngdialog-overlay ngdialog-theme-plain width1300 ng-$scope',
            closeByDocument: false,
            scope: $scope,
          });
        };
        $scope.executeQueryEncoursDialog = function() {
          $scope.executeQueryEncoursDialogOpen = ngDialog.open({
            template:
              'js/XG/modules/common/views/modals/modal.requete.encours.html',
            className:
              'ngdialog nopadding miniclose ngdialog-overlay ngdialog-theme-plain width400 ng-$scope',
            closeByDocument: false,
            scope: $scope,
          });
        };

        /**
         * displayQueryExemple Displays an exemple of an Query
         */
        $scope.displayQueryExemple = function() {
          ngDialog.open({
            template:
              'js/XG/modules/common/views/modals/modal.requete.example.html',
            className:
              'ngdialog ngdialog-overlay ngdialog-theme-plain width800',
            closeByDocument: false,
          });
        };

        /***************************************************************
         * Permet de mettre a jour un fichier sql
         **************************************************************/
        $scope.executeRequeteDialog = function(uid) {
          $scope.requete = {};
          QueryFactory.afficherequet(
            uid,
            $scope.currentAppName,
            $scope.ConfigName
          ).then(function(res) {
            if (res.data) {
              $scope.requete.dataBase = res.data.dataBase;
              $scope.requete.newRequete = res.data.requete;
              $scope.requete.newRequeteTitle = res.data.titre;
              $scope.requete.newRequeteDescription = res.data.description;
              $scope.requete.roles = res.data.roles;
              $scope.requete.geo = res.data.geo;
              $scope.requete.geoTableMaitre = res.data.geoTableMaitre;
              $scope.requete.newRequeteNameFile = uid;
              $scope.requete.params = res.data.params;
              $scope.requete.fieldsJson = res.data.fieldsJson;
              $scope.fakeFti = res.data.fakeFti;
              $scope.majParamList(res.data.dataBase);
            } else {
              $scope.requete.newRequete = '';
            }
          });
          $scope.executeQueryDialog();
        };

        $scope.editRequeteDialog = function(uid, titre, categorie) {
          $scope.feat = {};
          $scope.requete = {};
          $scope.editRequeteBoolean = true;
          $scope.currentCategorie = categorie;
          QueryFactory.afficherequet(
            uid,
            $scope.currentAppName,
            $scope.ConfigName
          ).then(function(res) {
            if (res.data) {
              $scope.requete.dataBase = res.data.dataBase;
              $scope.requete.newRequete = res.data.requete;
              $scope.requete.newRequeteTitle = res.data.titre;
              $scope.requete.newRequeteDescription = res.data.description;
              $scope.requete.roles = res.data.roles;
              if (res.data.geo && res.data.geo != 'false') {
                $scope.requete.geo = res.data.geo === 'true' ? true: res.data.geo;
                $scope.requete.geoTableMaitre = res.data.geoTableMaitre;
              }
              $scope.requete.newRequeteNameFile = uid;
              $scope.requete.params = res.data.params;
              $scope.requete.fieldsJson = res.data.fieldsJson;
              $scope.requete.uidCategorie = categorie.properties.uid;
              $scope.fakeFti = res.data.fakeFti;
              $scope.majParamList(res.data.dataBase);
              $scope.getCorrectOperande($scope.requete.params);
            } else {
              $scope.requete.newRequete = '';
            }
          });
          $scope.queryDialog();
        };

        $scope.ftisRequete = [];
        $scope.operateurs = [];
        $scope.addRequeteDialog = function() {
          $scope.loadDataStores();
          $scope.feat = {};
          $scope.requete = {};
          if ($scope.dbselector) {
            $scope.requete.dataBase = $scope.dbselector;
          }
          $scope.currentCategorie = {};
          $scope.editRequeteBoolean = false;
          $scope.queryDialog();
        };

        $scope.getFakeFti = function() {
          QueryFactory.afficherequet('fake').then(function(res) {
            if (res.data.length != 0) {
              $scope.fakeFtiFakeAttrLis = res.data.fakeFti;
            }
          });
        };
        $scope.getFakeFti();
        $scope.addRequeteParamDialog = function() {
          $scope.paramsRequete = {};
        };

        $scope.addRequete = function(requete, currentCategorie) {
          if (
            requete.newRequete &&
            (!$scope.startWithSelect(requete.newRequete) ||
              $scope.includeDropUpdate(requete.newRequete))
          ) {
            AlertHpoFactory.getSimpleSuccess(
              $filter('translate')('executQueryManager.alert.warning'),
              $filter('translate')(
                'La requête doit commencer par Select ou Create View et ne pas contenir ni Drop ni Update'
              ),
              false
            );
          } else {
            // catégories vide, création de la cat par défaut
            if (!$scope.isNotEmpty($scope.categories)) {
              QueryFactory.addCategorie(
                'Sans Catégorie',
                $scope.currentAppName,
                $scope.ConfigName
              ).then(function(res) {
                if (res.data.features.length != 0) {
                  $scope.getFilterCategories();
                }
              });
            }

            if (
              !$scope.isNotEmpty(currentCategorie) ||
              !$scope.isNotEmpty(currentCategorie.properties) ||
              $scope.stringEmptyOrNot(currentCategorie.properties.uid)
            ) {
              requete.uidCategorie = 'CAT-000000-000000';
            } else {
              requete.uidCategorie = currentCategorie.properties.uid;
            }
            QueryFactory.createFichSQL(
              requete,
              $scope.currentAppName,
              $scope.ConfigName
            ).then(function(res) {
              if (res.data.length != 0) {
                $scope.getFilterCategories();
                $scope.queryDialogOpen.close();
                AlertHpoFactory.getSimpleSuccess(
                  $filter('translate')('executQueryManager.alert.succes'),
                  $filter('translate')('Création requête'),
                  false
                );
              }
            });
          }
        };
        $scope.editRequete = function(requete, currentCategorie) {
          if (
            requete.newRequete &&
            (!$scope.startWithSelect(requete.newRequete) ||
              $scope.includeDropUpdate(requete.newRequete))
          ) {
            AlertHpoFactory.getSimpleSuccess(
              $filter('translate')('executQueryManager.alert.warning'),
              $filter('translate')(
                'La requête doit commencer par Select ou Create View et ne pas contenir ni Drop ni Update'
              ),
              false
            );
          } else {
            requete.uidCategorie = currentCategorie.properties.uid;
            QueryFactory.MAJFichSQL(
              requete,
              $scope.currentAppName,
              $scope.ConfigName
            ).then(function(res) {
              if (res.data.length != 0) {
                $scope.getFilterCategories();
                $scope.queryDialogOpen.close();
                AlertHpoFactory.getSimpleSuccess(
                  $filter('translate')('executQueryManager.alert.succes'),
                  $filter('translate')('MAJ requête'),
                  false
                );
              }
            });
          }
        };
        $scope.removeRequete = function(newRequeteNameFile) {
          swal(
            {
              title: 'Êtes vous sûr de vouloir supprimer la requête ?',
              type: 'warning',
              showCancelButton: true,
              confirmButtonColor: '#DD6B55',
              confirmButtonText: $filter('translate')('common.yes'),
              cancelButtonText: $filter('translate')('common.no'),
              closeOnConfirm: true,
            },
            function(isConfirm) {
              if (isConfirm) {
                QueryFactory.removeRequete(
                  newRequeteNameFile,
                  $scope.currentAppName,
                  $scope.ConfigName
                ).then(
                  function(res) {
                    if (res.data.length != 0) {
                      $scope.getFilterCategories();
                      AlertHpoFactory.getSimpleSuccess(
                        $filter('translate')('executQueryManager.alert.succes'),
                        $filter('translate')('Supression requête'),
                        false
                      );
                    }
                  },
                  function(res) {
                    AlertHpoFactory.showErrorMessage(res);
                  }
                );
              }
            }
          );
        };

        $scope.exect = {};
        $scope.testRequete = function(db, requete) {
          if (
            requete.newRequete &&
            (!$scope.startWithSelect(requete.newRequete) ||
              $scope.includeDropUpdate(requete.newRequete))
          ) {
            AlertHpoFactory.getSimpleSuccess(
              $filter('translate')('executQueryManager.alert.warning'),
              $filter('translate')(
                'La requête doit commencer par Select ou Create View et ne pas contenir ni Drop ni Update'
              ),
              false
            );
          } else {
            $scope.executeQueryEncoursDialog();
            var promise = QueryFactory.executFichSQL(db, requete, true);
            promise.then(
              function(res) {
                if ($scope.executeQueryEncoursDialogOpen) {
                  $scope.executeQueryEncoursDialogOpen.close();
                }
                AlertHpoFactory.getSimpleSuccess(
                  $filter('translate')('executQueryManager.alert.succes'),
                  $filter('translate')(
                    'executQueryManager.alert.connectionSucces'
                  ),
                  false
                );
              },
              function(res) {
                if ($scope.executeQueryEncoursDialogOpen) {
                  $scope.executeQueryEncoursDialogOpen.close();
                }
                AlertHpoFactory.showErrorMessage(res);
              }
            );
          }
        };
        $scope.nombreLigne = [];
        $scope.verifNombreResSQL = function(db, requete) {
          if (
            requete.newRequete &&
            (!$scope.startWithSelect(requete.newRequete) ||
              $scope.includeDropUpdate(requete.newRequete))
          ) {
            AlertHpoFactory.getSimpleSuccess(
              $filter('translate')('executQueryManager.alert.warning'),
              $filter('translate')(
                'La requête doit commencer par Select ou Create View et ne pas contenir ni Drop ni Update'
              ),
              false
            );
          } else {
            $scope.executeQueryEncoursDialog();
            var promise = QueryFactory.executFichSQL(db, requete, false);
            promise.then(
              function(res) {
                if (res.data != undefined) {
                  $scope.nombreLigne[requete.newRequeteNameFile] =
                    res.data.totalFeatures;
                } else {
                  $scope.nombreLigne[requete.newRequeteNameFile] = 0;
                }
                AlertHpoFactory.getSimpleSuccess(
                  $filter('translate')('executQueryManager.alert.succes'),
                  $filter('translate')(
                    'Nombre des Lignes = ' + res.data.totalFeatures
                  ),
                  false
                );
                if ($scope.executeQueryEncoursDialogOpen) {
                  $scope.executeQueryEncoursDialogOpen.close();
                }
              },
              function(res) {
                if ($scope.executeQueryEncoursDialogOpen) {
                  $scope.executeQueryEncoursDialogOpen.close();
                }
                AlertHpoFactory.showErrorMessage(res);
              }
            );
          }
        };
        $scope.executeRequete = function(db, requete) {
          if (
            requete.newRequete &&
            (!$scope.startWithSelect(requete.newRequete) ||
              $scope.includeDropUpdate(requete.newRequete))
          ) {
            AlertHpoFactory.getSimpleSuccess(
              $filter('translate')('executQueryManager.alert.warning'),
              $filter('translate')(
                'La requête doit commencer par Select ou Create View et ne pas contenir ni Drop ni Update'
              ),
              false
            );
          } else {
            $scope.exect = requete;
            if (
              requete.geo &&
              requete.geo == 'true' &&
              requete.geoTableMaitre
            ) {
              $scope.showLocalisation = 'map';
            } else {
              delete requete.geo;
              delete $scope.geoTableMaitre;
              delete $scope.showLocalisation;
            }
            $scope.executeQueryEncoursDialog();
            var promise = QueryFactory.executFichSQL(db, $scope.exect, false);
            promise.then(
              function(res) {
                if (res.data != undefined) {
                  if (res.data.totalFeatures === '0') {
                    AlertHpoFactory.getSimpleSuccess(
                      $filter('translate')('executQueryManager.alert.warning'),
                      $filter('translate')('executQueryManager.alert.vide'),
                      false
                    );
                  } else {
                    delete res.data.tablename;
                    $scope.fti = res.data.featureTypeInfo;
                    delete res.data.featureTypeInfo;
                    $scope.geoj = res.data;
                    if ($scope.executeQueryEncoursDialogOpen) {
                      $scope.executeQueryEncoursDialogOpen.close();
                    }
                    if ($scope.executeQueryDialogOpen) {
                      $scope.executeQueryDialogOpen.close();
                    }
                    $scope.vopenTabPanels();
                  }
                }
              },
              function(res) {
                if ($scope.executeQueryEncoursDialogOpen) {
                  $scope.executeQueryEncoursDialogOpen.close();
                }
                AlertHpoFactory.getSimpleFail(
                  $filter('translate')('executQueryManager.alert.fail'),
                  $filter('translate')('executQueryManager.alert.query_cannot_be_executed') +
                  '\n' + res.data,
                  true);
              }
            );
          }
        };
        $scope.validTitre = {};
        $scope.verificationTitreRequeteUsed = function() {
          $scope.$watch(
            'requete',
            function(requetePropose) {
              $scope.validTitre = true;
              for (var categorieIndice in $scope.categories) {
                var requetes =
                  $scope.categories[categorieIndice].properties.requetes;
                for (var requeteIndice in requetes) {
                  var requete = requetes[requeteIndice];
                  if (
                    requete.titre &&
                    requetePropose.newRequeteTitle &&
                    requete.titre == requetePropose.newRequeteTitle &&
                    (!requetePropose.newRequeteNameFile ||
                      (requete.uid &&
                        requete.uid.toUpperCase() !=
                          requetePropose.newRequeteNameFile.toUpperCase()))
                  ) {
                    $scope.validTitre = false;
                  }
                }
              }
            },
            1
          );
        };

        /***************************************************************
         * Permet de mettre a jour la catégorie sql
         **************************************************************/
        $scope.addCatDialog = function() {
          $scope.getFilterCategories();
          $scope.currentCategorie = {};
          $scope.validTitreCat = true;
          $scope.editCatBoolean = false;
          $scope.categorieDialog();
        };

        $scope.editCatDialog = function(categorie) {
          $scope.getFilterCategories();
          $scope.currentCategorie = {};
          $scope.validTitreCat = true;
          $scope.currentCategorie.titre = categorie.properties.titre;
          $scope.currentCategorie.uid = categorie.properties.uid;
          $scope.editCatBoolean = true;
          $scope.categorieDialog();
        };

        $scope.addCategorie = function() {
          QueryFactory.addCategorie(
            $scope.currentCategorie.titre,
            $scope.currentAppName,
            $scope.ConfigName
          ).then(function(res) {
            if (res.data.features.length != 0) {
              $scope.categorieDialogOpen.close();
              $scope.getFilterCategories();
              AlertHpoFactory.getSimpleSuccess(
                $filter('translate')('executQueryManager.alert.succes'),
                $filter('translate')('Création catégorie'),
                false
              );
            }
          });
        };
        $scope.removeCategorie = function(uidCategorie) {
          swal(
            {
              title: 'Êtes vous sûr de vouloir supprimer la catégorie ?',
              type: 'warning',
              showCancelButton: true,
              confirmButtonColor: '#DD6B55',
              confirmButtonText: $filter('translate')('common.yes'),
              cancelButtonText: $filter('translate')('common.no'),
              closeOnConfirm: true,
            },
            function(isConfirm) {
              if (isConfirm) {
                QueryFactory.removeCategorie(
                  uidCategorie,
                  $scope.currentAppName,
                  $scope.ConfigName
                ).then(
                  function(res) {
                    if (res.data.length != 0) {
                      $scope.getFilterCategories();
                      AlertHpoFactory.getSimpleSuccess(
                        $filter('translate')('executQueryManager.alert.succes'),
                        $filter('translate')('Supression catégorie'),
                        false
                      );
                    }
                  },
                  function(res) {
                    AlertHpoFactory.showErrorMessage(res);
                  }
                );
              }
            }
          );
        };

        $scope.editCategorie = function() {
          QueryFactory.editCategorie(
            $scope.currentCategorie.titre,
            $scope.currentCategorie.uid,
            $scope.currentAppName,
            $scope.ConfigName
          ).then(
            function(res) {
              if (res.data.length != 0) {
                $scope.categorieDialogOpen.close();
                $scope.getFilterCategories();
                AlertHpoFactory.getSimpleSuccess(
                  $filter('translate')('executQueryManager.alert.succes'),
                  $filter('translate')('MAJ catégorie'),
                  false
                );
              }
            },
            function(res) {
              AlertHpoFactory.showErrorMessage(res);
            }
          );
        };

        $scope.validTitreCat = {};
        $scope.verificationTitreCatRequeteUsed = function() {
          $scope.validTitreCat = true;
          for (var categorieIndice in $scope.categories) {
            var titreCat = $scope.categories[categorieIndice].properties.titre;
            var newCategorieTitre = $scope.currentCategorie.titre;
            var titreUidCat = $scope.categories[categorieIndice].properties.uid;
            var newCategorieUid = $scope.currentCategorie.uid;
            if (
              newCategorieTitre &&
              titreCat &&
              newCategorieTitre.toUpperCase() == titreCat.toUpperCase() &&
              (!newCategorieUid ||
                (titreUidCat &&
                  titreUidCat.toUpperCase() != newCategorieUid.toUpperCase()))
            ) {
              $scope.validTitreCat = false;
            }
          }
        };

        /***************************************************************
         * Récupération de la liste des tables des données et des
         * attributs
         **************************************************************/
        $scope.featureTypesList = {};
        $scope.featureTypesListFields = [];
        $scope.featureTypesListGeo = [];
        $scope.loadDataTables = function() {
          QueryFactory.getAllFeatureTypeInfo().then(function(res) {
            if (res.data.length != 0) {
              $scope.featureTypesList = res.data;
              $scope.featureTypesList.push($scope.fakeFtiFakeAttrLis);
              $scope.featureTypesList.sort();
              $scope.featureTypesListFields.push($scope.fakeFtiFakeAttrLis);
              $scope.remplirFtiBaseTable();
            }
          });
        };
        $scope.loadDataTables();
        $scope.remplirFtiBaseTable = function() {
          for (var i in $scope.featureTypesList) {
            var fti = $scope.featureTypesList[i];
            $scope.ftisRequete[fti.name] = fti;
            if (fti.geographic == true) {
              $scope.featureTypesListGeo.push(fti.name);
            }
          }
          $scope.featureTypesListGeo.sort();
        };
        $scope.setfeatureTypeAttrRestriction = function(feat) {
          var restrictedComponent = feat;
          $scope.afeatureTypeAttrRestriction = {
            table: restrictedComponent,
            keyField: {},
            valueField: {},
          };
        };

        $scope.addParamToList = function(db, param) {
          if (!(db != undefined && db !== '' && db != 0)) {
            AlertHpoFactory.alertConfirmCallback(
              $filter('translate')('executQuery.alert.error'),
              'Vous devez choisir la base de données',
              'warning',
              true,
              'ok',
              '#F50072',
              false,
              undefined,
              undefined,
              true,
              false,
              null
            );
          } else {
            var paramCurrent = {};
            if (
              angular.isUndefined($scope.requete.params) ||
              $scope.requete.params === null ||
              $scope.requete.params.length === 0
            ) {
              $scope.requete.params = [];
              paramCurrent.id = '$1';
            } else {
              var indice = parseInt($scope.requete.params.length) + parseInt(1);
              paramCurrent.id = '$' + indice;
            }
            paramCurrent.table = param.table.name;
            paramCurrent.attribut = param.attribut.name;
            var expression =
              '"' +
              param.table.name +
              '"' +
              '.' +
              '"' +
              param.attribut.name +
              '"';
            paramCurrent.expression = expression;

            $scope.requete.params.push(paramCurrent);
            $scope.majParamList(db);
          }
        };
        $scope.addfieldsJsonToList = function(fieldsJson) {
          var fieldsJsonCurrent = {};
          if (
            angular.isUndefined($scope.requete.fieldsJson) ||
            $scope.requete.fieldsJson === null ||
            $scope.requete.fieldsJson.length === 0
          ) {
            $scope.requete.fieldsJson = [];
          }
          fieldsJsonCurrent.table = fieldsJson.table.name;
          fieldsJsonCurrent.attribut = fieldsJson.attribut.name;
          $scope.requete.fieldsJson.push(fieldsJsonCurrent);
        };

        $scope.removefieldsJsonfromList = function(param) {
          var index = $scope.requete.fieldsJson.indexOf(param);
          if (index > -1) $scope.requete.fieldsJson.splice(index, 1);
        };

        $scope.removeParamFromList = function(param) {
          var index = $scope.requete.params.indexOf(param);
          if (index > -1) $scope.requete.params.splice(index, 1);
        };

        $scope.majParamList = function(db) {
          if (
            $scope.requete.params != undefined &&
            $scope.requete.params !== '' &&
            $scope.requete.params.length != 0
          ) {
            var fti = {};
            for (var i in $scope.requete.params) {
              var tableName = $scope.requete.params[i].table;
              var parameName = $scope.requete.params[i].attribut;
              if (tableName === 'kis_anc_dossier_controle_reponse') {
                fti = $scope.fakeFti;
              } else {
                fti = $scope.ftisRequete[tableName];
              }

              if ($scope.isNotEmpty(fti) && fti != false) {
                $scope.ftisRequete[tableName] = fti;
                $scope.operateurs[
                  tableName + parameName
                ] = $scope.listOperateursByAttributType(fti, parameName);
              } else {
                AlertHpoFactory.alertConfirmCallback(
                  $filter('translate')('executQuery.alert.error'),
                  $filter('translate')('executQuery.alert.ftipasValide'),
                  'warning',
                  true,
                  'ok',
                  '#F50072',
                  false,
                  undefined,
                  undefined,
                  true,
                  false,
                  null
                );

                $scope.requete.params = '';
                $scope.requete.newRequete = '';
                break;
              }
            }
          }
        };
        $scope.listOperateursByAttributType = function(fti, attributName) {
          var attributType = '';

          for (var ind = 0; ind < fti.attributes.length; ind++) {
            if (fti.attributes[ind].name == attributName) {
              attributType = fti.attributes[ind].type;

              if (attributType !== '') {
                switch (attributType) {
                  case 'text':
                    fti.attributes[ind].type = 'java.lang.String';
                    break;
                  case 'date':
                    fti.attributes[ind].type = 'java.sql.Timestamp';
                    break;
                  case 'number':
                    fti.attributes[ind].type = 'java.lang.Integer';
                    break;
                  case 'checkbox':
                  case 'radio':
                    fti.attributes[ind].type = 'java.lang.Boolean';
                    break;
                }
              }
            }
          }

          var operandsList = {
            Boolean: [
              {
                key: 'equals',
                label: 'equals',
              },
              {
                key: 'exists',
                label: 'exists',
              },
              {
                key: 'notexists',
                label: 'notexists',
              },
            ],

            Date: [
              {
                key: 'equals',
                label: 'equals',
              },
              {
                key: 'gt',
                label: 'gt;',
              },
              {
                key: 'gte',
                label: 'gte;',
              },
              {
                key: 'lt',
                label: 'lt;',
              },
              {
                key: 'lte',
                label: 'lte;',
              },
              {
                key: 'exists',
                label: 'exists',
              },
              {
                key: 'notexists',
                label: 'notexists',
              },
              {
                key: 'between',
                label: 'between',
              },
            ],

            Number: [
              {
                key: 'equals',
                label: 'equals',
              },
              {
                key: 'gt',
                label: 'gt;',
              },
              {
                key: 'gte',
                label: 'gte;',
              },
              {
                key: 'lt',
                label: 'lt;',
              },
              {
                key: 'lte',
                label: 'lte;',
              },
              {
                key: 'exists',
                label: 'exists',
              },
              {
                key: 'notexists',
                label: 'notexists',
              },
            ],

            String: [
              {
                key: 'startWith',
                label: 'startswith',
              },
              {
                key: 'endWith',
                label: 'endWith',
              },
              {
                key: 'regexp',
                label: 'regexp',
              },
              {
                key: 'inclus',
                label: 'inclus',
              },
              {
                key: 'equals',
                label: 'equals',
              },
              {
                key: 'notEquals',
                label: 'notEquals',
              },
              {
                key: 'exists',
                label: 'exists',
              },
              {
                key: 'notexists',
                label: 'notexists',
              },
            ],
          };

          var metaAttributType = '';

          if (attributType !== '') {
            switch (attributType) {
              case 'text':
              case 'java.lang.String':
              case 'java.lang.Character':
              case 'java.lang.CharSequence':
                metaAttributType = 'String';
                break;

              case 'number':
              case 'java.lang.Integer':
              case 'java.lang.Short':
              case 'java.lang.Double':
              case 'java.lang.Float':
              case 'java.math.BigDecimal':
              case 'java.lang.Long':
                metaAttributType = 'Number';
                break;

              case 'date':
              case 'java.sql.Timestamp':
              case 'java.lang.Timestamp':
              case 'java.sql.Date':
              case 'java.util.Date':
              case 'java.util.TimeZone':
                metaAttributType = 'Date';
                break;

              case 'checkbox':
              case 'radio':
              case 'java.lang.Boolean':
                metaAttributType = 'Boolean';
                break;
            }

            return operandsList[metaAttributType];
          }
        };
        /***************************************************************
         * des fonctions et filtres diverses
         **************************************************************/

        $scope.opengraph = function() {
          $scope.currentselectfti = $scope.fti;
          extendedNgDialog.open({
            template:
              'js/XG/widgets/mapapp/layerManager/views/charts/SelectedCharts.html',
            className: 'ngdialog-theme-plain width1000 nopadding miniclose',
            closeByDocument: false,
            scope: $scope,
            draggable: true,
            title: $filter('translate')('layermanager.charts'),
          });
        };

        /**
         * Zoom on features contained in $scope.geoj
         */
        $scope.zoomOnData = () => {
          SelectManager.clear();
          // le widget boite d'information n'accepte pas le format de $scope.geoj
          //  tel qu'il est donc on doit le modifier.
          // remove ftiName in attributeName. 'ASS_REGARD.DATECREAT' -> 'DATECREAT'
          const geoJson = angular.copy($scope.geoj);
          if (Array.isArray(geoJson.features) && geoJson.features[0] && geoJson.features[0].id) {
            const ftiName = geoJson.features[0].id.split('.')[0];
            geoJson.features = geoJson.features.map(feat => {
              const newProperties = {};
              for (const attributeName in feat.properties) {
                const newAttributeName = attributeName.replace(ftiName+'.', '');
                newProperties[newAttributeName] = feat.properties[attributeName];
              }
              feat.properties = newProperties;
              return feat;
            });
          }
          SelectManager.addFeaturesFromGeojson(geoJson);
          $scope.map.getView().fit(
            SelectManager.getExtent(), $scope.map.getSize());
        };

        $scope.titre = '';
        var match = function(categorie, val) {
          var regex = new RegExp(val, 'i');
          var matched = categorie.properties.titre.search(regex) == 0;
          for (var indice in categorie.properties.requetes) {
            matched =
              matched ||
              categorie.properties.requetes[indice].titre.search(regex) == 0;
          }
          return matched;
        };

        $scope.filterCategories = function(categorie) {
          if (!$scope.titre) return true;
          var matched = true;
          $scope.titre.split(' ').forEach(function(token) {
            matched = matched && match(categorie, token);
          });

          return matched;
        };

        $scope.layerdatatable = {};
        $scope.layerdatatable.height = 300;
        $scope.vopenTabPanels = function() {
          // KIS-2958
          $scope.removeFid = true;

          $scope.panelsManager.removePanel('selecttab');
          $scope.advancedFiltersConfiguration = {text: true};
          $scope.tableClassList = 'small-text-select-filter';
          $scope.datatableExportCsvInGeoJson = true;
          // -- KIS-3700: Pour exporter un CSV avec des valeurs d'attributs,
          // -- il ne faudra pas garder les IDs qui vont donner le nom de la table
          // -- au servcie d'export.
          $scope.doNotExportIds
            =  $scope.exect.newRequete.toLowerCase().includes(' join ')
              && $scope.requete.geoTableMaitre!=undefined;
          panelsManager.addPanel({
            id: 'selecttab',
            stickToRight: true,
            templateUrl:
              'js/XG/modules/common/views/directives/popexectDatatable.html',
            scope: $scope,
            stickToBorder: true,
            visible: true,
            resizable: true,
          });
        };
        $scope.closeTable = false;
        $scope.closepanel = function() {
          gclayers.clearhighLightFeatures();
          SelectManager.clear();
          panelsManager.removePanel('selecttab');
          $scope.feat = {};
        };
        $scope.isNotEmpty = function(obj) {
          var isNotEmpty = false;
          for (var key in obj) {
            if (Object.prototype.hasOwnProperty.call(obj, key)) {
              isNotEmpty = true;
            }
          }
          return isNotEmpty;
        };
        $scope.stringEmptyOrNot = function(str) {
          return str && str.trim().length === 0;
        };
        $scope.startWithSelect = function(requete) {
          return (
            requete.toLowerCase().startsWith('select') ||
            requete.toLowerCase().startsWith('create or replace view') ||
            requete.toLowerCase().startsWith('create view') ||
            requete.toLowerCase().startsWith('replace view')
          );
        };
        $scope.includeDropUpdate = function(requete) {
          return (
            requete.toLowerCase().includes('drop') ||
            requete.toLowerCase().includes('update')
          );
        };
        $scope.$watch('requete.geo', (geo) => {
          if (!geo && $scope.requete) {
            delete $scope.requete.geo;
            delete $scope.requete.geoTableMaitre;
          }
        });
        $scope.isTableRestriction = (fti, attributeName) => {
          if (fti && fti.attributes && Array.isArray(fti.attributes)) {
            let attribute = fti.attributes.find(attribute => {
              return attribute.name === attributeName;
            });
            if (attribute && attribute.restrictions
              && Array.isArray(attribute.restrictions)
              && attribute.restrictions.length > 0) {
              return attribute.restrictions[0].type === 'Tables';
            }
          }
          return false;
        };
        /**
         * select's ng-options don't handle object comparison very well
         * we can't base the ng-select on the key because the backend needs the whole object.
         * we shouldn't save the whole operator object in the backend,
         * we should just store the key.
         * @param {*} params
         */
        $scope.getCorrectOperande = (params) => {
          if (params && Array.isArray(params)) {
            for (let param of params) {
              if (param.operande && param.table && param.attribut
                && $scope.operateurs && $scope.operateurs[param.table+param.attribut] != null) {
                let goodOperator = $scope.operateurs[param.table+param.attribut].find(operator => {
                  return operator.key === param.operande.key;
                });
                if (goodOperator) {
                  param.operande = goodOperator;
                }
              }
            }
          }
        };
      },
    };
  };

  executeQueryManager.$inject = [
    '$rootScope',
    'QueryFactory',
    '$filter',
    'panelsManager',
    'AlertHpoFactory',
    'DataStoreFactory',
    'ngDialog',
    'extendedNgDialog',
    '$location',
    'gclayers',
    'SelectManager'
  ];
  return executeQueryManager;
});


define('modules/common/directives/mapLeftMenu',['toastr'],function() {
  var mapLeftMenu = function(
    UsersFactory,
    $rootScope,
    $timeout,
    $interval,
    versionsFactory,
    ConfigFactory,
    $sce,
    $window,
    authFactory,
    gcDirectivesList,
    ngDialog,
    $filter,
    ThemesFactory,
    homeFactory
  ) {
    return {
      templateUrl: 'js/XG/modules/common/views/directives/mapleftmenu.html',
      restrict: 'EA',
      link: function(scope) {
        const BASE_MENU_WIDTH = 380;

        /**
         * Info : we use indexes for :
         * categories : cause category can have the same name
         * tools : cause the same category can include the same tool multiple times
         */

        var portalid = angular.module('gcMain').portalid;

        scope.currenttool = {};
        scope.firstUpload = true;
        // -1 = closed
        // -2 = specialTool
        scope.currentCategoryIndex = -1;
        scope.wrapper = {
          active: false,
          width: BASE_MENU_WIDTH,
          isPinned: true,
        };


        scope.currentAppName = localStorage.getItem('app');

        function prepareCurrentUer() {
          scope.userAvatar = 'img/common/admin.png';

          if (
            $rootScope.xgos.user &&
            angular.isDefined($rootScope.xgos.user.thumbnail) &&
            $rootScope.xgos.user.thumbnail != null
          ) {
            var imgUrl =
              '/services/' +
              portalid +
              '/thumbnail/getthumb?f=json&fileName=' +
              $rootScope.xgos.user.thumbnail;

            scope.userAvatar = imgUrl;
          }
        }

        prepareCurrentUer();

        scope.kisHomeCfg = false;

        function prepareKisHomeInfo() {
          ConfigFactory.get('home', 'config', 'kis_home').then(function(res) {
            if (res.data != '') {
              scope.kisHomeCfg = res.data;
            }
          });
        }

        prepareKisHomeInfo();

        /**
         * Return app icon
         * @param app
         * @returns {string}
         */
        scope.getKisAppIcon = function(app) {
          var icon = 'fa fa-gears';
          if (app.type == 'MapApp') icon = 'fa fa-map-o';
          if (app.type == 'FormApp') icon = 'fa fa-check-square-o';
          if (app.type == 'SirocoApp') icon = 'fa fa-graph';
          if (app.type == 'CustomHtml') icon = 'fa fa-gear';
          if (~app.uid.indexOf('external_app')) icon = 'fa fa-link';

          return icon;
        };

        scope.getHomeContent = function() {
          return $sce.trustAsHtml(scope.kisHomeCfg.content);
        };

        /**
         * Reformate fonction avec homeAppSwitcher, homeAppCarousel, homepageNews
         * dans homeFactory.
         * @param app objet application issu de ApplicationFactory.resources.applications
         */
        scope.gotoApp = function(app) {
          const distinctAppname = scope.currentAppName !== app.name;
          homeFactory.gotoApp(portalid,app,distinctAppname);
        };

        let toggleSubMenu = function() {
          scope.wrapper.active = !scope.wrapper.active;
          needToOpenMenu = !needToOpenMenu;
        };

        let needToOpenMenu = true;
        scope.selectCategory = function(idx) {
          const tool = Object.assign({}, scope.currenttool);
          scope.currentToolIndex = -1;
          scope.currenttool = {};

          if (tool.directive === 'ancmapwidget') {
            scope.$broadcast('ancmapwidget_tool_click');
          }
          if (tool.directive === 'bacmapwidget') {
            scope.$broadcast('bacmapwidget_tool_click');
          }

          if(!needToOpenMenu){
            tool.active = false;

            // we broadcast these two events to close the overlay of
            // the map and also destroy the component because
            // every time we open it we create a new one.
            scope.$broadcast('openCloseTools_gaprintv2', tool);
            scope.$broadcast('openCloseTools_esriprint');
            scope.$broadcast('destroy_gaprintv2');
            scope.$broadcast('destroy_atlas');
            scope.$broadcast('destroy_ancMapWidget');
            scope.$broadcast('destroy_bacMapWidget');
            scope.$broadcast('destroy_mapModelMgtWidget');
            scope.$broadcast('openCloseTools_' + tool.directive, tool);
          }

          scope.wrapper.width = BASE_MENU_WIDTH;
          scope.categoryTools = [];
          scope.specialTool = false;

          if (needToOpenMenu) {
            toggleSubMenu();
          }
          else if (scope.currentCategoryIndex == idx) {
            //-- On a recliqué sur la catégorie ouverte, pour la fermer.
            scope.$broadcast('closingCategory');
            scope.currentCategoryIndex = -1;
            scope.currenttool = {};
            toggleSubMenu();
            return;
          }
          else {
            //-- On a cliqué une autre catégorie que celle ouverte.
            scope.$broadcast('switchingCategory');
          }
          $timeout(() => {
            scope.categoryTools = scope.tools[idx].modules;
            scope.currentCategoryIndex = idx;
            $rootScope.MapLeftMenucategory = scope.tools[idx].categorie;
            if(scope.categoryTools && scope.categoryTools.length ===1) {
              $timeout(() => {
                // Timeout pour laisser le temps à la directive du widget de charger
                scope.onToolclick(scope.categoryTools[0],0,scope.tools[idx].categorie);
              }, 200);
            }
          });
        };

        scope.specialTool = false;
        scope.selectSpecialTool = function(toolName) {
          scope.wrapper.width = 480;
          switch (toolName) {
            case 'versions':
              scope.wrapper.width = 980;
              break;
          }
          scope.currentCategoryIndex = -2;

          if (needToOpenMenu) {
            toggleSubMenu();
          } else if (scope.specialTool === toolName) {
            scope.specialTool = false;
            toggleSubMenu();
            return;
          }
          $timeout(function() {
            scope.specialTool = toolName;
          });
        };

        // alimente la liste des directives (pour voir si elles existent encore)
        // et des metadata (aide, urlwiki)
        let directivesList = gcDirectivesList.listtools();
        let directivesMetaData = gcDirectivesList.listtoolsMetaData();

        scope.existingDirectives = {};
        scope.widgetTooltips = {};
        directivesList.forEach(function(x) {
          scope.existingDirectives[x.directive] = true;
        });

        /**
         * Récupère les URL des fichiers d'aide personnalisés pour construire les tooltips d'aide des widgets
         * L'url est personnalisée ou bien is s'agit de l'url par défaut présente dans la propriété [directive] de l'objet renvoyé par <code>listtoolsMetaData</code>
         * @see directivesMetaData
         */
        ConfigFactory.getWikiConfig().then(
            res => {
                if (res.data) {
                  scope.customWiki = res.data;
                }else{
                  scope.customWiki = [];
                }
                for (let category of scope.tools) {
                  for (let tool of category.modules){
                    // boucle sur tous les widgets
                    if (directivesMetaData.hasOwnProperty(tool.directive)){
                      // recherche du rang du widget dans le tableau des widgets ayant un fichier d'aide custom
                      const indexInCustomWikiList = scope.customWiki.findIndex(
                          cfg => cfg.directive === tool.directive && cfg.config === tool.config
                              && cfg.name === tool.name && cfg.title === $filter('translate')(tool.title));
                      const isWidgetPresentInCustomWikiList = indexInCustomWikiList > -1;

                      // initialise le tableau des widgets ayant le même nom de directive (i.e instances d'un même widget)
                      scope.widgetTooltips[tool.directive] = scope.widgetTooltips.hasOwnProperty(tool.directive) ? scope.widgetTooltips[tool.directive] : [];

                      // implémentation de la possibilité de différencier les fichiers d'aide entre instance d'un même widget
                      // ajoute un nouvel objet contenant les propriétés nécessaires pour relier une configuration de widget à une instance de widget
                      // il n'y a pas de propriété unique non null permettant d'identifier une instance de widget
                      scope.widgetTooltips[tool.directive].push({
                        description: directivesMetaData[tool.directive].description,
                        title: $filter('translate')(tool.title),
                        category: category.categorie,
                        wiki: isWidgetPresentInCustomWikiList
                            ? scope.customWiki[indexInCustomWikiList].wiki
                            : directivesMetaData[tool.directive].wiki,
                      });
                    }
                  }
                }
            },
            (error) => {
              require('toastr').info(
                  $filter('translate')('layermanager.wikiretrieveerror') + error.data.message
              );
            }
        )

        scope.onToolclick = function(tool, index, widgetCategory) {
          scope.currentToolIndex = index;

          if (scope.currenttool.directive === 'ancmapwidget') {
            scope.$broadcast('ancmapwidget_tool_click');
          }
          if (scope.currenttool.directive === 'bacmapwidget') {
            scope.$broadcast('bacmapwidget_tool_click');
          }

          if (scope.currenttool != tool) {
            if (tool.directive == 'mapModelMgtWidget') {
              tool.widgetCategory = widgetCategory;
            }

            if (tool.directive !== 'mapcatalogwidget') {
              angular.element('#large_catalog_container').remove();
            }

            switch (tool.directive) {
              case 'exportgeopackage':
              case 'imexmbtiles':
                scope.wrapper.width = 620;
                break;
              case 'csvgeocoder':
              case 'selectfeaturetreewidget':
              case 'elasticwidget':
                scope.wrapper.width = 420;
                break;
              default:
                scope.wrapper.width = BASE_MENU_WIDTH;
                break;
            }

            if (angular.isDefined(tool.active) || !scope.firstUpload) {
              tool.active = true;
              scope.currenttool.active = false;
              scope.firstUpload = false;
            } else {
              tool.active = !tool.active;
              scope.currenttool.active = !scope.currenttool.active;
            }

            scope.$broadcast(
              'closeTools_' + scope.currenttool.directive,
              scope.currenttool
            );

            scope.$broadcast('openTools_' + tool.directive, tool);
            scope.currenttool = tool;
            UsersFactory.user_monitoring({
              sector: $rootScope.xgos.sector,
              path: 'map',
              category: 'map_widget',
              parameters: '[Ouverture][' + tool.name + ']',
            });
          } else {
            scope.currentToolIndex = -1;
            scope.currenttool = {};
            tool.active = !tool.active;
            scope.$broadcast('openCloseTools_' + tool.directive, tool);
          }
        };

        // ------ Scroll sidebar --------------

        scope.categoriesSidebar = $("#tools-wrapper")[0];

        let scrollUpInterval;
        let scrollDownInterval;

        scope.startScrollUp = function() {
          scope.stopScrollUp();
          scrollUpInterval = $interval(function() {
            if (scope.categoriesSidebar.scrollTop > 0) {
              scope.categoriesSidebar.scrollTop -= 1;
            }
          }, 5);
        };
    
        scope.stopScrollUp = function() {
          $interval.cancel(scrollUpInterval);
        };
    
        scope.startScrollDown = function() {
          scope.stopScrollDown();
          scrollDownInterval = $interval(function() {
            if (scope.categoriesSidebar.scrollTop < (scope.categoriesSidebar.scrollHeight - scope.categoriesSidebar.clientHeight)) {
              scope.categoriesSidebar.scrollTop += 2;
            }
          }, 5);
        };

        scope.stopScrollDown = function() {
          $interval.cancel(scrollDownInterval);
        };

        // évalue si la barre peut être scrollée vers le bas
        scope.canScrollBottom = () => {
          if (scope.categoriesSidebar) {
            return !((scope.categoriesSidebar.scrollHeight - scope.categoriesSidebar.clientHeight) >= Math.ceil(scope.categoriesSidebar.scrollTop) - 1
                && (scope.categoriesSidebar.scrollHeight - scope.categoriesSidebar.clientHeight) <= Math.ceil(scope.categoriesSidebar.scrollTop) + 1);
          }
        }

        // évalue si la barre peut être scrollée vers le haut
        scope.canScrollTop = () => {
          if (scope.categoriesSidebar) {
            return scope.categoriesSidebar.scrollTop !== 0;
          }
        }

        // ------ gestion des versions --------------
        scope.versionsData = {};
        versionsFactory.getVersions().then(function(res) {
          scope.versionsData = res[0];
          scope.versionTreeData = res[1];
        });

        scope.displayFirstLevel = true;

        // ----- calendar tmp -----------------------
        var date = new Date();
        var d = date.getDate();
        var m = date.getMonth();
        var y = date.getFullYear();
        let events = [
          {
            id: 1,
            title: 'Événement important',
            description: "RDV avec le responsable métier et l'élu",
            lieu: '22 avenue victor Hugo, 75001 Paris',
            start: new Date(y, m, 1, 9, 0),
            end: new Date(y, m, 1, 12, 0),
          },
          {
            id: 2,
            title: 'Essai terrain',
            description: 'Essai sur le terrain des nouvelles tablettes',
            lieu: "Centre d'entrainement",
            start: new Date(y, m, d - 5, 12, 0),
            end: new Date(y, m, d - 5, 13, 0),
          },
          {
            id: 3,
            title: 'Réunion 1',
            description: 'COPIL hebdo',
            lieu: 'Siège',
            start: new Date(y, m, d - 3, 16, 0),
            end: new Date(y, m, d - 3, 18, 0),
            allDay: false,
          },
          {
            id: 4,
            title: 'Réunion 2',
            description: 'COPERF mensuel',
            lieu: 'Siège',
            start: new Date(y, m, d + 4, 16, 0),
            end: new Date(y, m, d + 4, 17, 0),
            allDay: false,
          },
          {
            id: 5,
            title: 'Enteretien technicien',
            description: 'Entretien Jean Pierre Dupont',
            lieu: 'Siège',
            start: new Date(y, m, d + 1, 19, 0),
            end: new Date(y, m, d + 1, 22, 30),
            allDay: false,
          },
        ];
        scope.eventSources = [events];
        scope.eventData = {};
        scope.eventClick = function(event) {
          console.log(event.start);

          scope.eventData.data = {
            id: event.id,
            title: event.title,
            description: event.description,
            lieu: event.lieu,
            jour: event.start.format('DD'),
            heureDebut: event.start.format('HH:mm'),
            heureFin: event.end.format('h:mm'),
            mois: event.start.format('MMMM').toUpperCase(),
          };
        };

        scope.uiConfig = {
          calendar: {
            height: 450,
            editable: true,
            header: {
              left: 'title',
              center: '',
              right: 'prev,next',
            },
            eventClick: scope.eventClick,
            eventRender: scope.eventRender,
          },
        };

        scope.logout = function() {
          authFactory.logout();
        };
        var accountModale;
        scope.change_password = function() {
          scope.currentuserdata = {};
          scope.currentuser = scope.xgos.user;
          scope.currentuserdata.login = scope.xgos.user.login;
          scope.currentuserdata.password = scope.xgos.user.pass;
          scope.currentuserdata.confirm_password = scope.xgos.user.pass;
          initPattern();
          scope.checkPassword();
          accountModale = ngDialog.open({
            template:
              'js/XG/modules/authentication/views/modals/modal.user.edit.html',
            className: 'ngdialog-theme-plain width500 miniclose nopadding',
            closeByDocument: false,
            scope: scope,
          });
        };
        scope.updateuser = function() {
          if (!scope.currentuserdata.password.match(scope.pattern)) {
            alert($filter('translate')('rights.users.passwordDontMatchPattern'));
            return;
          }
          scope.currentuser.pass = scope.currentuserdata.password;
          UsersFactory.update(scope.currentuser, scope.currentuserdata.password);
          getUser();
          accountModale.close();
        };

        var getUser = function() {
          UsersFactory.token().then(function(res) {
            if (res.data.code == 403) {
              authFactory.goToLogin(true);
            } else {
              scope.currentuser = res.data;
              scope.currentuserdata.login = res.data.login;
              scope.currentuserdata.password = res.data.pass;
              scope.currentuserdata.confirm_password = res.data.pass;
            }
          });
        };
        scope.close_dialog = function() {
          accountModale.close();
        };

        let initPattern = () => {
          if(!$rootScope.xgos.portal.parameters || !$rootScope.xgos.portal.parameters.settingPwd){
            scope.pattern = '(?=(.*[A-Z]){1,})(?=(.*[a-z]){1,})(?=(.*\\d){1,})(?=(.*\\W){1,}).{10,50}';
            scope.minimumNumberUppercase = 1;
            scope.minimumNumberLowercase = 1;
            scope.minimumNumberDigits = 1;
            scope.minimumNumberSpecialCharacters = 1;
            scope.minimumNumberTotalCharacters = 10;
          } else{
            scope.pattern = '(?=(.*[A-Z]){$1,})(?=(.*[a-z]){$2,})(?=(.*\\d){$3,})(?=(.*\\W){$4,}).{$5,50}';
            if($rootScope.xgos.portal.parameters.settingPwd.minimumNumberUppercase){
              scope.pattern = scope.pattern.replace('$1',$rootScope.xgos.portal.parameters.settingPwd.minimumNumberUppercase)
              scope.minimumNumberUppercase = $rootScope.xgos.portal.parameters.settingPwd.minimumNumberUppercase;
            }else{
              scope.pattern = scope.pattern.replace('$1',0)
            }
            if($rootScope.xgos.portal.parameters.settingPwd.minimumNumberLowercase){
              scope.pattern = scope.pattern.replace('$2',$rootScope.xgos.portal.parameters.settingPwd.minimumNumberLowercase)
              scope.minimumNumberLowercase = $rootScope.xgos.portal.parameters.settingPwd.minimumNumberLowercase;
            }else{
              scope.pattern = scope.pattern.replace('$2',0)
            }
            if($rootScope.xgos.portal.parameters.settingPwd.minimumNumberDigits){
              scope.pattern = scope.pattern.replace('$3',$rootScope.xgos.portal.parameters.settingPwd.minimumNumberDigits)
              scope.minimumNumberDigits = $rootScope.xgos.portal.parameters.settingPwd.minimumNumberDigits;
            }else{
              scope.pattern = scope.pattern.replace('$3',0)
            }
            if($rootScope.xgos.portal.parameters.settingPwd.minimumNumberSpecialCharacters){
              scope.pattern = scope.pattern.replace('$4',$rootScope.xgos.portal.parameters.settingPwd.minimumNumberSpecialCharacters)
              scope.minimumNumberSpecialCharacters = $rootScope.xgos.portal.parameters.settingPwd.minimumNumberSpecialCharacters;
            }else{
              scope.pattern = scope.pattern.replace('$4',0)
            }
            if($rootScope.xgos.portal.parameters.settingPwd.minimumNumberTotalCharacters){
              scope.pattern = scope.pattern.replace('$5',$rootScope.xgos.portal.parameters.settingPwd.minimumNumberTotalCharacters)
              scope.minimumNumberTotalCharacters = $rootScope.xgos.portal.parameters.settingPwd.minimumNumberTotalCharacters;
            }else{
              scope.pattern = scope.pattern.replace('$5',0)
            }
          }
        }

        scope.checkPassword = () => {
          if(scope.minimumNumberUppercase && scope.currentuserdata.password && scope.currentuserdata.password.match(
            '(?=(.*[A-Z]){'+scope.minimumNumberUppercase+',}).{'+scope.minimumNumberUppercase+',50}')){
              scope.minimumNumberUppercaseValid = true;
          } else{
            scope.minimumNumberUppercaseValid = false;
          }
          if(scope.minimumNumberLowercase && scope.currentuserdata.password &&  scope.currentuserdata.password.match(
            '(?=(.*[a-z]){'+scope.minimumNumberLowercase+',}).{'+scope.minimumNumberLowercase+',50}')){
              scope.minimumNumberLowercaseValid = true;
          } else{
            scope.minimumNumberLowercaseValid = false;
          }
          if(scope.minimumNumberDigits && scope.currentuserdata.password && scope.currentuserdata.password.match(
            '(?=(.*\\d){'+scope.minimumNumberDigits+',}).{'+scope.minimumNumberDigits+',50}')){
              scope.minimumNumberDigitsValid = true;
          } else{
            scope.minimumNumberDigitsValid = false;
          }
          if(scope.minimumNumberSpecialCharacters && scope.currentuserdata.password && scope.currentuserdata.password.match(
            '(?=(.*\\W){'+scope.minimumNumberSpecialCharacters+',}).{'+scope.minimumNumberSpecialCharacters+',50}')){
              scope.minimumNumberSpecialCharactersValid = true;
          } else{
            scope.minimumNumberSpecialCharactersValid = false;
          }
          if(scope.minimumNumberTotalCharacters && scope.currentuserdata.password && scope.currentuserdata.password.match(
            '.{'+scope.minimumNumberTotalCharacters+',50}')){
              scope.minimumNumberTotalCharactersValid = true;
          } else{
            scope.minimumNumberTotalCharactersValid = false;
          }
        }

        /**
         * Recherche l'url du wiki du widget suivant la directive, le titre et la catégorie du widget.<br>
         * Il peut exister plusieurs instance du même widget. Un widget n'a pas une propriété unique
         * capable de l'identifier.
         * @param directive nom de la directive équivalent à une propriété de l'objet renvoyé par
         * <code>listtoolsMetaData</code>
         * @param title titre du widget donné lors de la configuration des outils de la carte
         * @param category catégorie de widgets à laquelle appartient le widget
         * @return {string} l'url personnalisée ou bien l'url par défaut présente dans la propriété
         * [directive] de l'objet renvoyé par <code>listtoolsMetaData</code>
         * @see gcDirectivesList.listtoolsMetaData
         */
        scope.getWiki = (directive, title, category) => {
          let wiki = '';
          if (scope.widgetTooltips.hasOwnProperty(directive)) {
            const widgetConfig = scope.widgetTooltips[directive].find(
                widget => (widget.title === title || widget.title === $filter('translate')(title))
                    && widget.category === category);
            if (widgetConfig && widgetConfig.hasOwnProperty('wiki')) {
              wiki = widgetConfig.wiki;
            }
          }
          return wiki;
        };

        /**
         * En mode config, ouvre la popup d'édition d'un lien de navigation
         * depuis la rubrique "Aide" au bas de la barre verticale gauche de l'application Map.
         * Au clic sur le bouton "Ajouter un lien"
         */
        scope.editHelpTool = () => {
          scope.$broadcast('openNewPortalNavLinkDialog');
        };

        /**
         * Au changement du bouton toggle switch du thème,<ul><li>
         * Enregistre le nouveau thème dans l'utilisateur</li><li>
         * Met à jour l'utilisateur</li></ul>
         */
        scope.addThemeToUser = () => {
          ThemesFactory.addDarkOrDefaultThemeToUser();
        };

        // Widgets nécessitant le maximum d'espace vertical
        // Directives pour lesquels la div id="tool" va prendre un padding-bottom = 0
        scope.maxHeightTools = ['layermanagerwidget', 'mapcatalogwidget', 'gcdefaultfilters'];
      },
    };
  };

  mapLeftMenu.$inject = [
    'UsersFactory',
    '$rootScope',
    '$timeout',
    '$interval',
    'versionsFactory',
    'ConfigFactory',
    '$sce',
    '$window',
    'authFactory',
    'gcDirectivesList',
    'ngDialog',
    '$filter',
    'ThemesFactory',
    'homeFactory'
  ];
  return mapLeftMenu;
});


define('modules/common/directives/iconPicker',[],() => {
  const iconPicker = () => ({
    templateUrl: 'js/XG/modules/common/views/directives/icon_picker.html',
    scope: {
      picked: '=',
    },
    restrict: 'E',
    link(scope) {
      /**
       * Picking an icon
       * @param icon
       */
      scope.pickIcon = function(icon) {
        scope.picked = icon;
      };

      let icons = [
        'adjust',
        'anchor',
        'archive',
        'area-chart',
        'arrows',
        'arrows-h',
        'arrows-v',
        'asterisk',
        'at',
        'automobile',
        'ban',
        'bank',
        'bar-chart',
        'bar-chart-o',
        'barcode',
        'bars',
        'bed',
        'beer',
        'bell',
        'bell-o',
        'bell-slash',
        'bell-slash-o',
        'bicycle',
        'binoculars',
        'birthday-cake',
        'bolt',
        'bomb',
        'book',
        'bookmark',
        'bookmark-o',
        'briefcase',
        'bug',
        'building',
        'building-o',
        'bullhorn',
        'bullseye',
        'bus',
        'cab',
        'calculator',
        'calendar',
        'calendar-o',
        'camera',
        'camera-retro',
        'car',
        'caret-square-o-down',
        'caret-square-o-left',
        'caret-square-o-right',
        'caret-square-o-up',
        'cart-arrow-down',
        'cart-plus',
        'cc',
        'certificate',
        'check',
        'check-circle',
        'check-circle-o',
        'check-square',
        'check-square-o',
        'child',
        'circle',
        'circle-o',
        'circle-o-notch',
        'circle-thin',
        'clock-o',
        'close',
        'cloud',
        'cloud-download',
        'cloud-upload',
        'code',
        'code-fork',
        'coffee',
        'cog',
        'cogs',
        'comment',
        'comment-o',
        'comments',
        'comments-o',
        'compass',
        'copyright',
        'credit-card',
        'crop',
        'crosshairs',
        'cube',
        'cubes',
        'cutlery',
        'dashboard',
        'database',
        'desktop',
        'diamond',
        'dot-circle-o',
        'download',
        'edit',
        'ellipsis-h',
        'ellipsis-v',
        'envelope',
        'envelope-o',
        'envelope-square',
        'eraser',
        'exchange',
        'exclamation',
        'exclamation-circle',
        'exclamation-triangle',
        'external-link',
        'external-link-square',
        'eye',
        'eye-slash',
        'eyedropper',
        'fax',
        'female',
        'fighter-jet',
        'file-archive-o',
        'file-audio-o',
        'file-code-o',
        'file-excel-o',
        'file-image-o',
        'file-movie-o',
        'file-pdf-o',
        'file-photo-o',
        'file-picture-o',
        'file-powerpoint-o',
        'file-sound-o',
        'file-video-o',
        'file-word-o',
        'file-zip-o',
        'film',
        'filter',
        'fire',
        'fire-extinguisher',
        'flag',
        'flag-checkered',
        'flag-o',
        'flash',
        'flask',
        'folder',
        'folder-o',
        'folder-open',
        'folder-open-o',
        'frown-o',
        'futbol-o',
        'gamepad',
        'gavel',
        'gear',
        'gears',
        'genderless',
        'gift',
        'glass',
        'globe',
        'graduation-cap',
        'group',
        'hdd-o',
        'headphones',
        'heart',
        'heart-o',
        'heartbeat',
        'history',
        'home',
        'hotel',
        'image',
        'inbox',
        'info',
        'info-circle',
        'institution',
        'key',
        'keyboard-o',
        'language',
        'laptop',
        'leaf',
        'legal',
        'lemon-o',
        'level-down',
        'level-up',
        'life-bouy',
        'life-buoy',
        'life-ring',
        'life-saver',
        'lightbulb-o',
        'line-chart',
        'location-arrow',
        'lock',
        'magic',
        'magnet',
        'mail-forward',
        'mail-reply',
        'mail-reply-all',
        'male',
        'map-marker',
        'meh-o',
        'microphone',
        'microphone-slash',
        'minus',
        'minus-circle',
        'minus-square',
        'minus-square-o',
        'mobile',
        'mobile-phone',
        'money',
        'moon-o',
        'mortar-board',
        'motorcycle',
        'music',
        'navicon',
        'newspaper-o',
        'paint-brush',
        'paper-plane',
        'paper-plane-o',
        'paw',
        'pencil',
        'pencil-square',
        'pencil-square-o',
        'phone',
        'phone-square',
        'photo',
        'picture-o',
        'pie-chart',
        'plane',
        'plug',
        'plus',
        'plus-circle',
        'plus-square',
        'plus-square-o',
        'power-off',
        'print',
        'puzzle-piece',
        'qrcode',
        'question',
        'question-circle',
        'quote-left',
        'quote-right',
        'random',
        'recycle',
        'refresh',
        'remove',
        'reorder',
        'reply',
        'reply-all',
        'retweet',
        'road',
        'rocket',
        'rss',
        'rss-square',
        'search',
        'search-minus',
        'search-plus',
        'send',
        'send-o',
        'server',
        'share',
        'share-alt',
        'share-alt-square',
        'share-square',
        'share-square-o',
        'shield',
        'ship',
        'shopping-cart',
        'sign-in',
        'sign-out',
        'signal',
        'sitemap',
        'sliders',
        'smile-o',
        'soccer-ball-o',
        'sort',
        'sort-alpha-asc',
        'sort-alpha-desc',
        'sort-amount-asc',
        'sort-amount-desc',
        'sort-asc',
        'sort-desc',
        'sort-down',
        'sort-numeric-asc',
        'sort-numeric-desc',
        'sort-up',
        'space-shuttle',
        'spinner',
        'spoon',
        'square',
        'square-o',
        'star',
        'star-half',
        'star-half-empty',
        'star-half-full',
        'star-half-o',
        'star-o',
        'street-view',
        'suitcase',
        'sun-o',
        'support',
        'tablet',
        'tachometer',
        'tag',
        'tags',
        'tasks',
        'taxi',
        'terminal',
        'thumb-tack',
        'thumbs-down',
        'thumbs-o-down',
        'thumbs-o-up',
        'thumbs-up',
        'ticket',
        'times',
        'times-circle',
        'times-circle-o',
        'tint',
        'toggle-down',
        'toggle-left',
        'toggle-off',
        'toggle-on',
        'toggle-right',
        'toggle-up',
        'trash',
        'trash-o',
        'tree',
        'trophy',
        'truck',
        'tty',
        'umbrella',
        'university',
        'unlock',
        'unlock-alt',
        'unsorted',
        'upload',
        'user',
        'user-plus',
        'user-secret',
        'user-times',
        'users',
        'video-camera',
        'volume-down',
        'volume-off',
        'volume-up',
        'warning',
        'wheelchair',
        'wifi',
        'wrench',
        'bed',
        'buysellads',
        'cart-arrow-down',
        'cart-plus',
        'connectdevelop',
        'dashcube',
        'diamond',
        'facebook-official',
        'forumbee',
        'heartbeat',
        'hotel',
        'leanpub',
        'mars',
        'mars-double',
        'mars-stroke',
        'mars-stroke-h',
        'mars-stroke-v',
        'medium',
        'mercury',
        'motorcycle',
        'neuter',
        'pinterest-p',
        'sellsy',
        'server',
        'ship',
        'shirtsinbulk',
        'simplybuilt',
        'skyatlas',
        'street-view',
        'subway',
        'train',
        'transgender',
        'transgender-alt',
        'user-plus',
        'user-secret',
        'user-times',
        'venus',
        'venus-double',
        'venus-mars',
        'viacoin',
        'whatsapp',
        'ambulance',
        'automobile',
        'bicycle',
        'bus',
        'cab',
        'car',
        'fighter-jet',
        'motorcycle',
        'plane',
        'rocket',
        'ship',
        'space-shuttle',
        'subway',
        'taxi',
        'train',
        'truck',
        'wheelchair',
        'circle-thin',
        'genderless',
        'mars',
        'mars-double',
        'mars-stroke',
        'mars-stroke-h',
        'mars-stroke-v',
        'mercury',
        'neuter',
        'transgender',
        'transgender-alt',
        'venus',
        'venus-double',
        'venus-mars',
        'file',
        'file-archive-o',
        'file-audio-o',
        'file-code-o',
        'file-excel-o',
        'file-image-o',
        'file-movie-o',
        'file-o',
        'file-pdf-o',
        'file-photo-o',
        'file-picture-o',
        'file-powerpoint-o',
        'file-sound-o',
        'file-text',
        'file-text-o',
        'file-video-o',
        'file-word-o',
        'file-zip-o',
        'check-square',
        'check-square-o',
        'circle',
        'circle-o',
        'dot-circle-o',
        'minus-square',
        'minus-square-o',
        'plus-square',
        'plus-square-o',
        'square',
        'square-o',
        'cc-amex',
        'cc-discover',
        'cc-mastercard',
        'cc-paypal',
        'cc-stripe',
        'cc-visa',
        'credit-card',
        'google-wallet',
        'paypal',
        'area-chart',
        'bar-chart',
        'bar-chart-o',
        'line-chart',
        'pie-chart',
        'bitcoin',
        'btc',
        'cny',
        'dollar',
        'eur',
        'euro',
        'gbp',
        'ils',
        'inr',
        'jpy',
        'krw',
        'money',
        'rmb',
        'rouble',
        'rub',
        'ruble',
        'rupee',
        'shekel',
        'sheqel',
        'try',
        'turkish-lira',
        'usd',
        'align-center',
        'align-justify',
        'align-left',
        'align-right',
        'bold',
        'chain',
        'chain-broken',
        'clipboard',
        'columns',
        'copy',
        'cut',
        'dedent',
        'eraser',
        'file',
        'file-o',
        'file-text',
        'file-text-o',
        'files-o',
        'floppy-o',
        'font',
        'header',
        'indent',
        'italic',
        'link',
        'list',
        'list-alt',
        'list-ol',
        'list-ul',
        'outdent',
        'paperclip',
        'paragraph',
        'paste',
        'repeat',
        'rotate-left',
        'rotate-right',
        'save',
        'scissors',
        'strikethrough',
        'subscript',
        'superscript',
        'table',
        'text-height',
        'text-width',
        'th',
        'th-large',
        'th-list',
        'underline',
        'undo',
        'unlink',
        'angle-double-down',
        'angle-double-left',
        'angle-double-right',
        'angle-double-up',
        'angle-down',
        'angle-left',
        'angle-right',
        'angle-up',
        'arrow-circle-down',
        'arrow-circle-left',
        'arrow-circle-o-down',
        'arrow-circle-o-left',
        'arrow-circle-o-right',
        'arrow-circle-o-up',
        'arrow-circle-right',
        'arrow-circle-up',
        'arrow-down',
        'arrow-left',
        'arrow-right',
        'arrow-up',
        'arrows',
        'arrows-alt',
        'arrows-h',
        'arrows-v',
        'caret-down',
        'caret-left',
        'caret-right',
        'caret-square-o-down',
        'caret-square-o-left',
        'caret-square-o-right',
        'caret-square-o-up',
        'caret-up',
        'chevron-circle-down',
        'chevron-circle-left',
        'chevron-circle-right',
        'chevron-circle-up',
        'chevron-down',
        'chevron-left',
        'chevron-right',
        'chevron-up',
        'hand-o-down',
        'hand-o-left',
        'hand-o-right',
        'hand-o-up',
        'long-arrow-down',
        'long-arrow-left',
        'long-arrow-right',
        'long-arrow-up',
        'toggle-down',
        'toggle-left',
        'toggle-right',
        'toggle-up',
        'arrows-alt',
        'backward',
        'compress',
        'eject',
        'expand',
        'fast-backward',
        'fast-forward',
        'forward',
        'pause',
        'play',
        'play-circle',
        'play-circle-o',
        'step-backward',
        'step-forward',
        'stop',
        'youtube-play',
        'adn',
        'android',
        'angellist',
        'apple',
        'behance',
        'behance-square',
        'bitbucket',
        'bitbucket-square',
        'bitcoin',
        'btc',
        'buysellads',
        'cc-amex',
        'cc-discover',
        'cc-mastercard',
        'cc-paypal',
        'cc-stripe',
        'cc-visa',
        'codepen',
        'connectdevelop',
        'css3',
        'dashcube',
        'delicious',
        'deviantart',
        'digg',
        'dribbble',
        'dropbox',
        'drupal',
        'empire',
        'facebook',
        'facebook-f',
        'facebook-official',
        'facebook-square',
        'flickr',
        'forumbee',
        'foursquare',
        'ge',
        'git',
        'git-square',
        'github',
        'github-alt',
        'github-square',
        'gittip',
        'google',
        'google-plus',
        'google-plus-square',
        'google-wallet',
        'gratipay',
        'hacker-news',
        'html5',
        'instagram',
        'ioxhost',
        'joomla',
        'jsfiddle',
        'lastfm',
        'lastfm-square',
        'leanpub',
        'linkedin',
        'linkedin-square',
        'linux',
        'maxcdn',
        'meanpath',
        'medium',
        'openid',
        'pagelines',
        'paypal',
        'pied-piper',
        'pied-piper-alt',
        'pinterest',
        'pinterest-p',
        'pinterest-square',
        'qq',
        'ra',
        'rebel',
        'reddit',
        'reddit-square',
        'renren',
        'sellsy',
        'share-alt',
        'share-alt-square',
        'shirtsinbulk',
        'simplybuilt',
        'skyatlas',
        'skype',
        'slack',
        'slideshare',
        'soundcloud',
        'spotify',
        'stack-exchange',
        'stack-overflow',
        'steam',
        'steam-square',
        'stumbleupon',
        'stumbleupon-circle',
        'tencent-weibo',
        'trello',
        'tumblr',
        'tumblr-square',
        'twitch',
        'twitter',
        'twitter-square',
        'viacoin',
        'vimeo-square',
        'vine',
        'vk',
        'wechat',
        'weibo',
        'weixin',
        'whatsapp',
        'windows',
        'wordpress',
        'xing',
        'xing-square',
        'yahoo',
        'yelp',
        'youtube',
        'youtube-play',
        'youtube-square',
        'ambulance',
        'h-square',
        'heart',
        'heart-o',
        'heartbeat',
        'hospital-o',
        'medkit',
        'plus-square',
        'stethoscope',
        'user-md',
        'wheelchair',
      ];
      // remove the freakin duplicates
      scope.icons = [...new Set(icons)];
    },
  });
  iconPicker.$inject = [];
  return iconPicker;
});


define('modules/common/directives/categoryWidgetIconPicker',[],() => {
  const categoryWidgetIconPicker = () => ({
    templateUrl:
      'js/XG/modules/common/views/directives/category_widget_icon_picker.html',
    scope: {
      parent: '=',
    },
    restrict: 'E',
    link(scope) {},
  });
  categoryWidgetIconPicker.$inject = [];
  return categoryWidgetIconPicker;
});


define('modules/common/directives/kisVersions',[],function() {
  var kisVersions = function() {
    return {
      templateUrl: 'js/XG/modules/common/views/directives/kisversions.html',
      scope: {
        versionsData: '=',
        versionTreeData: '=',
      },
      restrict: 'EA',
      link: function(scope) {
        scope.versionTree = {};
        scope.versionTree_handle = function(branch) {
          scope.currentVersionDetail = branch;
        };

        scope.versionTree_handle(scope.versionTreeData[0]);
      },
    };
  };
  kisVersions.$inject = [];
  return kisVersions;
});


define('modules/common/directives/portalHelpLinks',['toastr','toastr','toastr','toastr','toastr','toastr'],function() {
  var portalHelpLinks = function(
      $rootScope,
      $timeout,
      $window,
      ngDialog,
      $filter,
      PortalsFactory,
      gaDomUtils,
      gaJsUtils
  ) {
    return {
      templateUrl: 'js/XG/modules/common/views/directives/portalHelpLinks.html',
      restrict: 'EA',
      scope: {
        mode: '=' // (obligatoire) on affiche les boutons d'édition quand mode = 'config'
      },
      link: function(scope) {

        /**
         * Au clic sur le bouton "Ajouter un lien" du mapLeftMenu (parent)
         */
        scope.$on('openNewPortalNavLinkDialog',() => {
          scope.editHelpTool();
        });
        /**
         * Ouvre un nouvel onglet sur le wiki kis
         */
        scope.goToWiki = () => {
          $window.open(
              'http://support.altereo.fr/xwiki/wiki/kis/view/Main/',
              '_blank'
          );
        };
        /**
         * Ouvre un nouvel onglet sur Mantis
         */
        scope.goToHelpPage = () => {
          $window.open('https://mantis.altereo.fr/', '_blank');
        };
        /**
         * Ouvre un nouvel onglet vers l'Url
         * @param url string de l'url de la page de redirection
         */
        scope.redirectTo = (url) => {
          gaJsUtils.redirectTo(url)
        };

        /**
         * Met à jour le portail quand on toggle l'affichage d'un lien par défaut (wiki, mantis)
         * @param toolName nom du lien ('showWiki' ou 'showMantis')
         */
        scope.toggleDefaultHelpTool = (toolName) => {
          scope.defaultHelpTools[toolName] = !scope.defaultHelpTools[toolName];
          if ($rootScope.xgos && $rootScope.xgos.portal && $rootScope.xgos.portal.parameters
              && $rootScope.xgos.portal.parameters.helpTools) {
            $rootScope.xgos.portal.parameters.helpTools[toolName] = scope.defaultHelpTools[toolName];
          }
          updatePortal($rootScope.xgos.portal);
        };

        /**
         * En mode config, ouvre la popup d'édition d'un lien de navigation
         * depuis la rubrique "Aide" au bas de la barre verticale gauche de l'application Map.
         * Au clic sur le bouton "Ajouter un lien" ou au clic sur un bouton vert "Edit" (crayon)
         * @param index rang du lien dans le tableau de lien de navigation specialHelpTools
         */
        scope.editHelpTool = (index) => {
          const initTool = {
            title: '',
            url: '',
            titleFirst: true
          }

          // Fait varier le titre de la popup
          // editingHelpTool est true au clic sur lien existant.
          scope.editingHelpTool = !!(!isNaN(index) && index > -1);

          // si clic sur mini bouton vert "Edit" d'un lien : copie le lien depuis la liste
          // si clic sur bouton "Ajouter un lien" : assigne le lien de base initTool
          scope.helpTool = !isNaN(index) && index > -1 ? Object.assign({},
              scope.helpTools[index]) : initTool;

          scope.editHelpToolDialog = ngDialog.open({
            template:
                'js/XG/modules/common/views/modals/modal.add.navigation.link.html',
            className: 'ngdialog-theme-plain width400 height600 miniclose nopadding',
            closeByDocument: false,
            scope: scope,
          });
          // recentre la croix de la popup après 0.1 seconde
          $timeout(() => {
            const popcontent = document.querySelector('.helptool-edit');
            const dialogclose = popcontent ? popcontent.nextElementSibling : null;
            if (dialogclose) {
              dialogclose.style.top = '-5px';
              dialogclose.style.right = '-5px';
            }
          }, 100);
        };

        /**
         * Enregistre un nouveau lien de navigation dans les paramètres du portail
         * Toggle editingHelpTool pour masquer la popup d'édition d'un lien
         */
        scope.appendHelpTool = () => {
          let helpToolHasNewImage = false;
          if (scope.dzMemShare.dropzoneComponent) {
            const files = scope.dzMemShare.dropzoneComponent.files;
            if (files !== null && files !== undefined && files.length > 0) {
              // le lien récupère le nom de l'image déposée
              scope.helpTool.imageName = scope.dzMemShare.dropzoneComponent.files[0].name;
              // une nouvelle image a été déposée
              helpToolHasNewImage = true;
            }
          }
          // mise à jour du portail
          PortalsFactory.addOrEditPortalHelpTool(
              portalid,
              scope.dzMemShare.processId,
              scope.helpTool
          ).then(
              res => {
                if (res.data && Array.isArray(res.data) && res.data.length > 0) {
                  if (scope.helpTool.uid && helpToolHasNewImage) {
                    // si mise à jour et chgt d'image, attend 1s avant de rafraichir le html
                    // le temps de la copie de l'image dans le contexte
                    gaDomUtils.showGlobalLoader();
                    $timeout(()=>{
                      updateHelpTools(res.data);
                      gaDomUtils.hideGlobalLoader();
                    }, 1000);
                  } else {
                    updateHelpTools(res.data)
                  }
                }
              },
              err => {
                require('toastr').error($filter('translate')('portals.help.appendToolError')
                + err.data.message ? err.data.message : '');
              }
          ).finally(
              () => {
                if (scope.editHelpToolDialog) {
                  scope.editHelpToolDialog.close()
                }
                scope.helpTool = null;
                scope.editingHelpTool = null;
              }
          );
        };



        /**
         * Au clic sur le bouton rouge "Supprimer" de la confirmation,
         * supprime un lien de navigation et met à jour le portail
         */
        scope.deleteHelpTool = () => {
          if (scope.helpTool && scope.helpTool.uid && portalid) {
            // mise à jour du portail
            PortalsFactory.deletePortalHelpTool(portalid, scope.helpTool.uid).then(
                res => {
                  if (res.data && Array.isArray(res.data)) {
                    updateHelpTools(res.data);
                  }
                },
                err => {
                  require('toastr').error($filter('translate')('portals.help.deleteToolError')
                  + err.data.hasOwnProperty('message') ? err.data.message : '');
                }
            );
          }
        };

        /**
         * Au clic sur le bouton "Annuler" de l'ajout d'un lien de navigation
         * Ferme la popup
         */
        scope.cancelEditHelpTool = () => {
          if (scope.editHelpToolDialog) {
            scope.editHelpToolDialog.close()
          }
          scope.helpTool = null;
          scope.editingHelpTool = null;
        };


        /**
         * Change le rang dans une liste.
         * La méthode est facilement adaptable à tout tableau de cette directive
         * @param index rang actuel du lien dans la liste
         * @param direction sens dans lequel doit être déplacé le lien (haut ou bas)
         * @param saveOrder est true pour mettre à jour le portail à chaque clic
         * @return {boolean} renvoie false si le déplacement n'est pas permis
         */
        scope.moveField = function (index, direction, saveOrder=false) {
          let fields = scope.helpTools;

          if (
              (index === 0 && direction === 'up') ||
              (index === fields - 1 &&
                  direction === 'down')
          ) {
            return false;
          } else {
            const newIndex = direction === 'up' ? index - 1 : index + 1;
            fields.splice(
                index,
                0,
                fields.splice(newIndex, 1)[0]
            );

            if (saveOrder) {
              PortalsFactory.savePortalHelpToolsParameter(portalid, fields).then(
                  res => {
                    if (res.data) {
                      scope.helpTools = fields;
                    } else {
                      require('toastr').error($filter('translate')('portals.help.savePortalError'));
                    }
                  },
                  err => {
                    require('toastr').error($filter('translate')('portals.help.savePortalError')
                    + err.data.hasOwnProperty('message') ? err.data.message : '');
                  }
              );
            }
          }
        };

        /**
         * Au clic sur le bouton rouge "Supprimer" (corbeille) d'un lien de navigation,
         * ouvre la popup de confirmation pour supprimer un lien de navigation.
         * @param index rang du lien dans la liste des liens de navigation
         */
        scope.confirmDeleteHelpTool = (index) => {
          scope.helpTool = scope.helpTools[index];
          ngDialog.open({
            template:
                'js/XG/modules/common/views/modals/modal.remove.navigation.link.html',
            className: 'ngdialog-theme-plain miniclose nopadding',
            closeByDocument: false,
            scope: scope,
          });
        };

        /**
         * URL de téléchargement de l'image. Renseigne l'attribut ng-src de chaque lien
         * @param {string} imageName nom du fichier image
         * @return {string} /services/${portalid}/files/downloadfile?fileName=${imageName}
         */
        scope.buildImageUrl = (imageName) => {
          return `/services/${portalid}/files/downloadfile?fileName=${imageName}`
        };

        /**
         * Rectifie le nom des helpTools déjà existants avant les changements du ticket KIS-3301.
         * Stocke uniquement le nom du fichier et non plus l'URL entière dans la propriété <code>parameters.helpTools.links[i].imageName</code>
         * @param {object} portal portail courant
         * @return {object[]} tableau des liens personnalisés à affecter au scope à l'initialisation de la directive
         */
        const cleanCorruptedFileNames = (portal) => {
          const portalHelpTools = portal.parameters.helpTools.links;

          if (Array.isArray(portal.parameters.helpTools.links)) {
            let hasCorruptedHelptoolFilename = false;

            for (const helptool of portalHelpTools) {
              const fileNameIndex = helptool.imageName.indexOf('fileName=');

              if (fileNameIndex !== -1) {
                hasCorruptedHelptoolFilename = true;
                helptool.imageName = helptool.imageName.slice(fileNameIndex + 9);
              }
            }
            if (hasCorruptedHelptoolFilename) {
              updatePortal(portal);
            }
          }
          return portalHelpTools;
        };

        /**
         * Factorisation de la méthode de mise à jour du portail avec gestion des erreurs
         * @param {object} portal portail courant
         */
        const updatePortal = (portal) => {
          PortalsFactory.update(portal).then(
              res => {
                if (res.data) {
                  if (res.data.code && res.data.code === 403) {
                    require('toastr').error($filter('translate')('portals.help.savePortalError')
                    + res.data.message ? res.data.message : '');
                  } else {
                    $rootScope.xgos.portal = res.data.portal;
                  }
                }
              },
              (err) => {
                require('toastr').error($filter('translate')('portals.help.savePortalError')
                + err.data.message ? err.data.message : '');
              }
          );
        };

        const updateHelpTools = (updatedHelpTools) => {
          scope.helpTools = updatedHelpTools;
          $rootScope.xgos.portal.parameters.helpTools.links = updatedHelpTools;
        };

        /******************
         * INITIALISATION *
         ******************/

        const portalid = angular.module('gcMain').portalid;

        scope.dzMemShare = {};

        // remove mode config if user is not admin
        scope.mode = $rootScope.xgos.isadmin ? scope.mode: '';

        scope.helpTools = [];

        /**
         * A l'ouverture de la catégorie "Help",
         * après un clic sur l'icône "?" de la barre des catégories,
         * initialise la liste des liens de navigation
         * @see scope.selectSpecialTool
         */
        if ($rootScope.xgos && $rootScope.xgos.portal && $rootScope.xgos.portal.parameters) {
          if (!$rootScope.xgos.portal.parameters.helpTools) {
            $rootScope.xgos.portal.parameters.helpTools = {};
          }
          // init defaultHelpTools
          scope.defaultHelpTools = {
            showWiki: $rootScope.xgos.portal.parameters.helpTools.showWiki !== undefined
                ? $rootScope.xgos.portal.parameters.helpTools.showWiki : true,
            showMantis: $rootScope.xgos.portal.parameters.helpTools.showMantis  !== undefined
                ? $rootScope.xgos.portal.parameters.helpTools.showMantis : true
          }

          // init specialHelpTools
          // rectifie le nom des helpTools déjà existants avant les changements du ticket KIS-3301
          const portalHelpTools = cleanCorruptedFileNames($rootScope.xgos.portal);

          if (portalHelpTools) {
            scope.helpTools = portalHelpTools;
          }
        }

      },
    };
  };

  portalHelpLinks.$inject = [
    '$rootScope',
    '$timeout',
    '$window',
    'ngDialog',
    '$filter',
    'PortalsFactory',
    'gaDomUtils',
    'gaJsUtils'
  ];
  return portalHelpLinks;
});


/**
 * Directive pour empêcher la saisie de caractères interdits dans les champs input
 * Utilisée notamment pour le nom de fichier Geopackage
 */
define('modules/common/directives/noForbiddenChars',[],function() {
  var noForbiddenChars = function() {
    return {
      restrict: 'A',
      require: 'ngModel',
      link: function(scope, element, attrs, ngModelCtrl) {
        // Liste des caractères interdits
        const forbiddenChars = '/!?£*%({[]})&#~§';
        
        // Fonction pour filtrer les caractères interdits pendant la saisie
        element.on('keypress', function(event) {
          if (forbiddenChars.indexOf(String.fromCharCode(event.which)) !== -1) {
            event.preventDefault();
          }
        });
        
        // Fonction pour nettoyer la valeur après collage (paste)
        element.on('input', function() {
          const value = element.val();
          let cleanValue = '';
          
          for (let i = 0; i < value.length; i++) {
            if (forbiddenChars.indexOf(value.charAt(i)) === -1) {
              cleanValue += value.charAt(i);
            }
          }
          
          if (cleanValue !== value) {
            ngModelCtrl.$setViewValue(cleanValue);
            ngModelCtrl.$render();
          }
        });
      }
    };
  };
  
  noForbiddenChars.$inject = [];
  
  return noForbiddenChars;
}); 

define('modules/common/directives/progressText',[],() => {
  const progressText = function() {
    return {
      restrict: 'A',
      scope: {
        progress: '=',
        progressBarWidth: '='
      },
      template: '<span ng-repeat="char in chars track by $index" class="progress-char" ng-style="getCharStyle($index)">{{char}}</span>',
      link: (scope, element) => {
        const CHAR_WIDTH = 8; // Largeur fixe d'un caractère en pixels

        scope.$watch('progress', (newVal) => {
          if (newVal !== undefined) {
            scope.chars = (newVal + '%').split('');
          }
        });

        scope.getCharStyle = (index) => {
          const progressElement = element[0].parentElement;
          const progressWidth = progressElement.offsetWidth;
          const totalChars = scope.chars.length;
          const textStartPosition = (progressWidth - (totalChars * CHAR_WIDTH)) / 2;

          // Position du début et du milieu du caractère
          const charStartPosition = textStartPosition + (index * CHAR_WIDTH);
          const charMidPosition = charStartPosition + (CHAR_WIDTH / 2);

          // Position actuelle de la barre de progression
          const progressPosition = (scope.progressBarWidth / 100) * progressWidth;

          // Le caractère change de couleur quand son point milieu est dépassé
          const isOverlapped = charMidPosition <= progressPosition;

          return {
            color: isOverlapped ? '#ffffff' : '#000000',
            textShadow: isOverlapped ?
                '0px 0px 2px rgba(0,0,0,0.8)' :
                '0px 0px 2px rgba(255,255,255,0.8)',
            transition: 'all 0.1s ease',
            display: 'inline-block',
            width: CHAR_WIDTH + 'px',
            textAlign: 'center'
          };
        };
      }
    };
  };

  return progressText;
});

define('modules/common/filters/booleanToCheck',[],function() {
  /**
   * Replaces a true value with a check sign
   * and the false/undefined value with a cross sign
   * @returns input
   */
  var booleanToCheck = function($sce) {
    return function(input) {
      var trInput = input;
      if (input === true) {
        trInput =
          '<div class="text-success bg-success text-center">\u2713</div>';
      } else if (input === false || typeof input == 'undefined') {
        trInput = '<div class="text-center">\u2718</div>';
      }
      return $sce.trustAsHtml(trInput);
    };
  };

  booleanToCheck.$inject = ['$sce'];
  return booleanToCheck;
});


define('modules/common/filters/datetoshow',[],function() {
  /**
   * Replaces a true value with a check sign
   * and the false/undefined value with a cross sign
   * @returns input
   */
  var datetoshow = function($sce, $filter) {
    return function(input) {
      if (input)
        return $sce.trustAsHtml(
          $filter('date')(new Date(input), 'yyyy-MM-dd HH:mm')
        );
      else return input;
    };
  };

  datetoshow.$inject = ['$sce', '$filter'];
  return datetoshow;
});


define('modules/common/filters/dataStoreTypeLogo',[],function() {
  /**
   * Replaces a datastore type with it's logo
   * @returns input
   */
  var dataStoreTypeLogo = function($sce) {
    return function(input) {
      var logo;
      if (input == undefined) {
        input = '';
      }
      input = input.toLowerCase();
      switch (input) {
        case 'postgis':
        case 'safepostgis':
        case 'arcgis':
        case 'mysql':
        case 'sqlserver':
        case 'oracle':
          logo =
            '<img src="img/datastores/' +
            input +
            '.png" class="editListLogo"/>';
          break;
        default:
          logo = input;
          break;
      }

      return $sce.trustAsHtml(logo);
    };
  };

  dataStoreTypeLogo.$inject = ['$sce'];
  return dataStoreTypeLogo;
});


define('modules/common/filters/layerTypeToIcon',[],function() {
  /**
   * Replaces a layer type with according icon
   * @returns input
   */
  var layerTypeToIcon = function($sce) {
    return function(input) {
      var trInput = input;
      trInput = '<div class="typeInfoIcon ' + input + '"><i></i></div>';
      return $sce.trustAsHtml(trInput);
    };
  };

  layerTypeToIcon.$inject = ['$sce'];
  return layerTypeToIcon;
});


define('modules/common/filters/userExtraProvider',[],function() {
  /**
   * userExtraProvider
   * @returns input
   */
  // PAS UTILISE POUR LE MOMENT
  var userExtraProvider = function($sce) {
    return function(input) {
      console.log('-------------------');
      console.log(input);

      var trInput = input;

      trInput = 'DADA ' + input + ' DUDU';
      return $sce.trustAsHtml(trInput);
    };
  };

  userExtraProvider.$inject = ['$sce'];
  return userExtraProvider;
});


define('modules/common/filters/ObjectsArrayToObjectAttributeArray',[],function() {
  var ObjectsArrayToObjectAttributeArray = function() {
    /**
     * Replaces every object in an array
     * with the name of the @attribute of said object
     *
     * ex: [ {"name":"uno"}, {"name":"dos"}] to ["uno","dos"], when the attribute parameter = name
     */
    return function(array, attribute) {
      array.forEach(function(object, index) {
        array[index] = object[attribute];
      });
      return array;
    };
  };
  ObjectsArrayToObjectAttributeArray.$inject = [];
  return ObjectsArrayToObjectAttributeArray;
});


define('modules/common/filters/isArray',[],function() {
  /**
   * Return whether input is an array or not
   * @returns input
   */
  var isArray = function($sce) {
    return function(input) {
      return angular.isArray(input);
    };
  };

  isArray.$inject = ['$sce'];
  return isArray;
});


define('modules/common/filters/isHexa',[],function() {
  /**
   * Return whether input is an hexadecimal string
   * @returns {Function}
   */
  var isHexa = function() {
    return function(input) {
      return input.match(/^#[0-9a-f]{3,6}$/i) ? true : false;
    };
  };

  isHexa.$inject = [];
  return isHexa;
});


define('modules/common/filters/displayXML',[],function() {
  /**
   * Display (indent + newlines) an xml string
   * @returns {Function}
   */
  var displayXML = function() {
    return function(xml) {
      if (xml !== void 0) {
        var formatted = '';
        var reg = /(>)(<)(\/*)/g;
        xml = xml.replace(reg, '$1\r\n$2$3');
        var pad = 0;
        jQuery.each(xml.split('\r\n'), function(index, node) {
          var indent = 0;
          if (node.match(/.+<\/\w[^>]*>$/)) {
            indent = 0;
          } else if (node.match(/^<\/\w/)) {
            if (pad != 0) {
              pad -= 1;
            }
          } else if (node.match(/^<\w[^>]*[^\/]>.*$/)) {
            indent = 1;
          } else {
            indent = 0;
          }

          var padding = '';
          for (var i = 0; i < pad; i++) {
            padding += '  ';
          }

          formatted += padding + node + '\r\n';
          pad += indent;
        });

        return formatted
          .replace(/&#x2F;/g, '/')
          .replace(/</g, '&lt;')
          .replace(/>/g, '&gt;')
          .replace(/ /g, '&nbsp;')
          .replace(/\n/g, '<br />');
      }
    };
  };

  displayXML.$inject = [];
  return displayXML;
});


define('modules/common/filters/forceArray',[],function() {
  /**
   * Wrap non array into array
   * @returns input
   */
  var forceArray = function($sce) {
    return function(input) {
      return angular.isArray(input) ? input : [input];
    };
  };

  forceArray.$inject = ['$sce'];
  return forceArray;
});


define('modules/common/filters/findObjectInArray',[],function() {
  /**
   * TODO: Remove if useless, the same thing can be done natively :
   * (input|filter:{key : value})[0]
   *
   * Returns the object having the @key property equals to @value, null if nothing is found
   *
   * @returns input
   */
  var findObjectInArray = function() {
    return function(input, key, value) {
      for (var i = 0; i < input.length; i++) {
        if (input[i][key] == value) {
          return input[i];
        }
      }
      return null;
    };
  };

  findObjectInArray.$inject = [];
  return findObjectInArray;
});


define('modules/common/filters/arrayMap',[],function() {
  /**
   * Transform an array of elements with an array of each value of element[key]
   * [{a:'b'},{a:'c'},{a:'d'}] => ['b','c','d']
   * @returns input
   */
  var arrayMap = function() {
    return function(arr, key) {
      var returnedArray = [];
      for (var i in arr) {
        if (arr[i].hasOwnProperty(key)) {
          returnedArray.push(arr[i][key]);
        }
      }

      return returnedArray;
    };
  };

  arrayMap.$inject = [];
  return arrayMap;
});


define('modules/common/filters/trustUrl',[],function() {
  /**
   * sce trust url
   * @returns input
   */
  var trustUrl = function($sce) {
    return function(url) {
      return $sce.trustAsResourceUrl(url);
    };
  };

  trustUrl.$inject = ['$sce'];
  return trustUrl;
});


define('modules/common/filters/translateColumn',[],function() {
  /**
   * A simple translate used in editList, as we need to specify a function to the cfg.colsFunction attribute
   * @returns input
   */
  var translateColumn = function($sce, $filter) {
    return function(input) {
      var trInput = $filter('translate')(input);
      return $sce.trustAsHtml(trInput);
    };
  };

  translateColumn.$inject = ['$sce', '$filter'];
  return translateColumn;
});


define('modules/common/filters/nl2br',[],function() {
  /**
   * \n -> <br/>
   * @returns {Function}
   */
  var nl2br = function($sce) {
    return function(input) {
      if (input && input !== void 0) {
        return $sce.trustAsHtml(input.replace(/\n/g, '<br>'));
      }
    };
  };

  nl2br.$inject = ['$sce'];
  return nl2br;
});


define('modules/common/filters/formatDateToLocale',[],function() {
  /**
   * formatDateToLocale
   * @returns {Function}
   */
  var formatDateToLocale = function() {
    return function(d) {
      if (d) {
        if (moment(d).isValid()) {
          return moment(d)
            .toDate()
            .toLocaleString(navigator.language, {
              day: '2-digit',
              month: '2-digit',
              year: '2-digit',
              hour: '2-digit',
              minute: '2-digit',
            });
        } else {
          return d;
        }
      }
    };
  };

  formatDateToLocale.$inject = [];
  return formatDateToLocale;
});


define('modules/common/filters/joinArray',[],function() {
  /**
   * Transforme un array en string avec séparateur ', '
   */
  const joinArray = () => {
    return (input) => {
      let str = '';
      if (input){
        for (let i = 0; i<input.length; i++){
          if (i > 0){
            str += ', ' + input[i];
          }else{
            str = input[i];
          }
        }
      }
      return str;
    };
  };

  joinArray.$inject = [];
  return joinArray;
});

/**
 * @ngdoc overview
 * @name modules.common
 * @description
 * common module
 */
define('modules/common/mod',[
  'angular',
  'modules/common/controllers/MainCtrl',
  'modules/common/controllers/NavigationCtrl',
  'modules/common/controllers/CalendarInviteCtrl',
  'modules/common/controllers/listesDeroulantesCtrl',

  'modules/common/services/extendedNgDialog',
  'modules/common/services/dialogsCommon',
  'modules/common/services/kisGeocodageFactory',
  'modules/common/services/twitterFactory',
  'modules/common/services/versionsFactory',

  'modules/common/directives/navGroup',
  'modules/common/directives/applicationLogo',
  'modules/common/directives/submitLoad',
  'modules/common/directives/dualListBox',
  'modules/common/directives/editList',
  'modules/common/directives/closeModaleButton',
  'modules/common/directives/geocatalogueFilter',
  'modules/common/directives/checkList',
  'modules/common/directives/arrayInput',
  'modules/common/directives/restrictedInput',
  'modules/common/directives/validateInput',
  'modules/common/directives/tabbedForm',
  'modules/common/directives/uncheckableRadio',
  'modules/common/directives/fixedHeaderTable',
  'modules/common/directives/mapPositionPicker',
  'modules/common/directives/positionAutoComplete',
  'modules/common/directives/banoInfo',
  'modules/common/directives/featuresConfig',
  'modules/common/directives/eventLinked',
  'modules/common/directives/userPicker',
  'modules/common/directives/parameterSaveLoad',
  'modules/common/directives/emailWriter',
  'modules/common/directives/kisGeocoderPicker',
  'modules/common/directives/positionFeature',
  'modules/common/directives/featureHistoryTable',
  'modules/common/directives/imageLibraryPicker',
  'modules/common/directives/jsonText',
  'modules/common/directives/arrayNumberInput',
  'modules/common/directives/kisSocialShare',
  'modules/common/directives/optionClass',
  'modules/common/directives/executeQuery',
  'modules/common/directives/executeQueryManager',
  'modules/common/directives/mapLeftMenu',
  'modules/common/directives/iconPicker',
  'modules/common/directives/categoryWidgetIconPicker',
  'modules/common/directives/kisVersions',
  'modules/common/directives/portalHelpLinks',
  'modules/common/directives/noForbiddenChars',
  'modules/common/directives/progressText',

  'modules/common/filters/booleanToCheck',
  'modules/common/filters/datetoshow',
  'modules/common/filters/dataStoreTypeLogo',
  'modules/common/filters/layerTypeToIcon',
  'modules/common/filters/userExtraProvider',
  'modules/common/filters/ObjectsArrayToObjectAttributeArray',
  'modules/common/filters/isArray',
  'modules/common/filters/isHexa',
  'modules/common/filters/displayXML',
  'modules/common/filters/forceArray',
  'modules/common/filters/findObjectInArray',
  'modules/common/filters/arrayMap',
  'modules/common/filters/trustUrl',
  'modules/common/filters/translateColumn',
  'modules/common/filters/nl2br',
  'modules/common/filters/formatDateToLocale',
  'modules/common/filters/joinArray',

  'angular-strap',
  'angular-strap.tpl',

  'angular-route',
  'ngDragDrop',

  'toastr',
  'ng-table',
], function(
  angular,
  MainCtrl,
  NavigationCtrl,
  CalendarInviteCtrl,
  listesDeroulantesCtrl,
  extendedNgDialog,
  dialogsCommon,
  kisGeocodageFactory,
  twitterFactory,
  versionsFactory,
  navGroup,
  applicationLogo,
  submitLoad,
  dualListBox,
  editList,
  closeModaleButton,
  geocatalogueFilter,
  checkList,
  arrayInput,
  restrictedInput,
  validateInput,
  tabbedForm,
  uncheckableRadio,
  fixedHeaderTable,
  mapPositionPicker,
  positionAutoComplete,
  banoInfo,
  featuresConfig,
  eventLinked,
  userPicker,
  parameterSaveLoad,
  emailWriter,
  kisGeocoderPicker,
  positionFeature,
  featureHistoryTable,
  imageLibraryPicker,
  jsonText,
  arrayNumberInput,
  kisSocialShare,
  optionClass,
  executeQuery,
  executeQueryManager,
  mapLeftMenu,
  iconPicker,
  categoryWidgetIconPicker,
  kisVersions,
  portalHelpLinks,
  noForbiddenChars,
  progressText,
  booleanToCheck,
  datetoshow,
  dataStoreTypeLogo,
  layerTypeToIcon,
  userExtraProvider,
  ObjectsArrayToObjectAttributeArray,
  isArray,
  isHexa,
  displayXML,
  forceArray,
  findObjectInArray,
  arrayMap,
  trustUrl,
  translateColumn,
  nl2br,
  formatDateToLocale,
  joinArray
) {
  // Module
  var mod = angular.module('common', ['ngRoute', 'ngDragDrop']);

  // Services
  mod.factory('extendedNgDialog', extendedNgDialog);
  mod.factory('dialogsCommon', dialogsCommon);
  mod.factory('kisGeocodageFactory', kisGeocodageFactory);
  mod.factory('twitterFactory', twitterFactory);
  mod.factory('versionsFactory', versionsFactory);

  // Controllers
  mod.controller('NavigationCtrl', NavigationCtrl);
  mod.controller('CalendarInviteCtrl', CalendarInviteCtrl);
  mod.controller('listesDeroulantesCtrl', listesDeroulantesCtrl);

  // Directives
  mod.directive('navGroup', navGroup);
  mod.directive('applicationLogo', applicationLogo);
  mod.directive('submitLoad', submitLoad);
  mod.directive('dualListBox', dualListBox);
  mod.directive('editList', editList);
  mod.directive('closeModaleButton', closeModaleButton);
  mod.directive('geocatalogueFilter', geocatalogueFilter);
  mod.directive('checkList', checkList);
  mod.directive('arrayInput', arrayInput);
  mod.directive('restrictedInput', restrictedInput);
  mod.directive('validateInput', validateInput);
  mod.directive('tabbedForm', tabbedForm);
  mod.directive('uncheckableRadio', uncheckableRadio);
  mod.directive('fixedHeaderTable', fixedHeaderTable);
  mod.directive('mapPositionPicker', mapPositionPicker);
  mod.directive('positionAutoComplete', positionAutoComplete);
  mod.directive('banoInfo', banoInfo);
  mod.directive('featuresConfig', featuresConfig);
  mod.directive('kisGeocoderPicker', kisGeocoderPicker);
  mod.directive('eventLinked', eventLinked);
  mod.directive('userPicker', userPicker);
  mod.directive('parameterSaveLoad', parameterSaveLoad);
  mod.directive('emailWriter', emailWriter);
  mod.directive('positionFeature', positionFeature);
  mod.directive('featureHistoryTable', featureHistoryTable);
  mod.directive('imageLibraryPicker', imageLibraryPicker);
  mod.directive('jsonText', jsonText);
  mod.directive('arrayNumberInput', arrayNumberInput);
  mod.directive('kisSocialShare', kisSocialShare);

  mod.directive('optionsClass', function($parse) {
    return {
      require: 'select',
      link: function(scope, elem, attrs, ngSelect) {
        // get the source for the items array that populates the select.
        var optionsSourceStr = attrs.ngOptions.split(' ').pop(),
          // use $parse to get a function from the options-class attribute
          // that you can use to evaluate later.
          getOptionsClass = $parse(attrs.optionsClass);

        scope.$watch(optionsSourceStr, function(items) {
          // when the options source changes loop through its items.
          angular.forEach(items, function(item, index) {
            // evaluate against the item to get a mapping object for
            // for your classes.
            var classes = getOptionsClass(item),
              // also get the option you're going to need. This can be found
              // by looking for the option with the appropriate index in the
              // value attribute.
              option = elem.find('option[value=' + index + ']');

            // now loop through the key/value pairs in the mapping object
            // and apply the classes that evaluated to be truthy.
            angular.forEach(classes, function(add, className) {
              if (add) {
                angular.element(option).addClass(className);
              }
            });
          });
        });
      },
    };
  });
  mod.directive('executequery', executeQuery);
  mod.directive('executequerymanager', executeQueryManager);
  mod.directive('mapLeftMenu', mapLeftMenu);
  mod.directive('iconPicker', iconPicker);
  mod.directive('categoryWidgetIconPicker', categoryWidgetIconPicker);
  mod.directive('kisVersions', kisVersions);
  mod.directive('portalhelplinks', portalHelpLinks);
  mod.directive('noForbiddenChars', noForbiddenChars);
  mod.directive('progressText', progressText);

  // Filters
  mod.filter('booleanToCheck', booleanToCheck);
  mod.filter('datetoshow', datetoshow);
  mod.filter('dataStoreTypeLogo', dataStoreTypeLogo);
  mod.filter('layerTypeToIcon', layerTypeToIcon);
  mod.filter('userExtraProvider', userExtraProvider);
  mod.filter(
    'ObjectsArrayToObjectAttributeArray',
    ObjectsArrayToObjectAttributeArray
  );
  mod.filter('isArray', isArray);
  mod.filter('isHexa', isHexa);
  mod.filter('displayXML', displayXML);
  mod.filter('forceArray', forceArray);
  mod.filter('findObjectInArray', findObjectInArray);
  mod.filter('arrayMap', arrayMap);
  mod.filter('trustUrl', trustUrl);
  mod.filter('translateColumn', translateColumn);
  mod.filter('nl2br', nl2br);
  mod.filter('formatDateToLocale', formatDateToLocale);
  mod.filter('joinArray', joinArray);

  /**
   * Dynamic filter allowing to invoke another filter dynamically
   */
  mod.filter('dynamicFilter', [
    '$filter',
    '$sce',
    function($filter, $sce) {
      return function(input, filterToUse) {
        if (filterToUse == '') {
          if (typeof input == 'number') {
            input = '' + input;
          }
          if (typeof input == 'boolean') {
            input = input
              ? '<i class="fa fa-check" aria-hidden="true"></i>'
              : '';
          }
          return $sce.trustAsHtml(input);
        } else {
          return $filter(filterToUse)(input);
        }
      };
    },
  ]);

  /**
   * Dynamic filter allowing to invoke another filter dynamically
   */
  mod.filter('datetypetoparse', [
    '$filter',
    function($filter) {
      return function(input, filterToUse) {
        if (input) {
          return $filter('date')(new Date(input), 'dd MMM yyyy HH:mm');
        } else {
          return undefined;
        }
      };
    },
  ]);
  /**
   * orderByTranslated
   */
  mod.filter('orderByTranslated', [
    '$translate',
    '$filter',
    function($translate, $filter) {
      return function(array, i18nKeyPrefix, objKey) {
        var result = [];
        var translated = [];
        angular.forEach(array, function(value) {
          var i18nKeySuffix = objKey ? value[objKey] : value;
          translated.push({
            key: value,
            label: $translate.instant(i18nKeyPrefix + i18nKeySuffix),
          });
        });
        angular.forEach($filter('orderBy')(translated, 'label'), function(
          sortedObject
        ) {
          result.push(sortedObject.key);
        });
        return result;
      };
    },
  ]);

  // Configuration
  mod.config([
    '$routeProvider',
    '$locationProvider',
    function($routeProvider, $locationProvider) {
      $locationProvider.hashPrefix('');
      // specific route resolve for some apps
      var originalWhen = $routeProvider.when;

      $routeProvider.when = function(path, route) {
        route.resolve || (route.resolve = {});

        angular.extend(route.resolve, {
          cfgLoaded: ['SirocoFactory', 'AncAppFactory', 'BacAppFactory', 'ApplicationFactory', function(SirocoFactory, AncAppFactory, BacAppFactory, ApplicationFactory) {
            if (path) {
              // SIROCO
              // any siroco route but nocfg
              if (
                ~path.indexOf('/siroco/') &&
                !~path.indexOf('/siroco/nocfg')
              ) {
                return SirocoFactory.getSirocoCfg();
              }
              // ANC
              if (~path.indexOf('/anc/')) {
                return AncAppFactory.getAppCfg();
              }
              // BAC
              if (~path.indexOf('/bac/')) {
                return BacAppFactory.getAppCfg();
              }
              if (path === '/map') {
                // récupère les applications avant de poursuivre vers la destination
                return ApplicationFactory.get();
              }
            }
          }],
        });
        return originalWhen.call($routeProvider, path, route);
      };

      // Routes
      $routeProvider.when('/map', {
        templateUrl: 'map.html',
        controller: 'gcMainController',
      });
      $routeProvider.when('/form', {
        templateUrl: 'form.html',
        controller: 'gcFormController',
      });

      /*  siroco was moved into widgets/sirocoapp/init/mod.js to include extra verifications
             $routeProvider.when('/siroco', {
             templateUrl: 'siroco.html',
             controller: 'gcSirocoController'
             });
      */
      $routeProvider.when('/indigau', {
        templateUrl: 'js/XG/widgets/indigauapp/main/views/controller/main.html',
        controller: 'gcIndigauController',
      });
      $routeProvider.when('/calendar_invite', {
        templateUrl: 'js/XG/modules/common/views/calendar_invite.html',
        controller: 'CalendarInviteCtrl',
      });
      /**
       * SEPPRI
       */
      $routeProvider.when('/hpo', {
        templateUrl: 'js/XG/widgets/hpoapp/main/views/controller/main.html',
        controller: 'gcMainHpoController',
      });
      /**
       * SEPPRI
       */
      $routeProvider.when('/mapv2', {
        templateUrl: 'js/XG/widgets/hpoapp/main/views/controller/main.html',
        controller: 'gcMainCarteController',
      });

      $routeProvider.when('/503/', {
        templateUrl: 'js/XG/modules/common/views/503.html',
      });
      $routeProvider.when('/404/', {
        templateUrl: 'js/XG/modules/common/views/404.html',
      });
      $routeProvider.when('/', { redirectTo: '/users/' });
      $routeProvider.otherwise({ redirectTo: '/404/' });
    },
  ]);

  return mod;
});


define('modules/export/services/ExportFactory',[],function() {
  var ExportFactory = function($http) {
    var ExportFactory = {};
    /**
     * Class : ExportFactory
     * Factory WebServices
     */

    /**
     * Function: downloadexportedfile
     */
    function downloadexportedfile(exportedFileId) {
      var promise = $http.get(
        '/services/' +
          localStorage.portal +
          '/export/downloadexportedfile?f=json' +
          '&exportedFileId=' +
          exportedFileId
      );

      return promise;
    }
    /**
     * Function: exportfeaturecollection
     */
    function exportfeaturecollection(senddata, exportFormat) {
      var promise = $http.post(
        '/services/{portalid}/export/exportfeaturecollection?f=json' +
          '&exportFormat=' +
          exportFormat,
        senddata
      );

      return promise;
    }
    /**
     * Function: exportlayersfeatures
     */
    function exportlayersfeatures(senddata, exportFormat, layers) {
      var promise = $http.post(
        '/services/{portalid}/export/exportLayersFeatures?f=json' +
          '&exportFormat=' +
          exportFormat +
          '&layers=' +
          layers,
        senddata
      );

      return promise;
    }
    return {
      ExportFactory: ExportFactory,
      downloadexportedfile: downloadexportedfile,
      exportfeaturecollection: exportfeaturecollection,
      exportlayersfeatures: exportlayersfeatures,
    };
  };
  ExportFactory.$inject = ['$http'];
  return ExportFactory;
});


/**
 * @ngdoc overview
 * @name modules.export
 * @description
 * export module
 */
define('modules/export/mod',['angular', 'modules/export/services/ExportFactory'], function(
  angular,
  ExportFactory
) {
  // Module
  var mod = angular.module('export', []);

  // Services
  mod.factory('ExportFactory', ExportFactory);

  return mod;
});


define('modules/geometry/services/GeometryFactory',['toastr','toastr','toastr','toastr','toastr'],function() {
  var GeometryFactory = function($http, $filter) {
    var GeometryFactory = {};
    /**
     * Class : GeometryFactory
     * Factory WebServices
     */

    /**
     * Function: union
     */
    function union(senddata) {
      var promise = $http.post(
        '/services/{portalid}/geometry/union?f=json',
        senddata
      );
      return promise;
    }

    /**
     * Function: unionifpossible
     */
    function unionifpossible(senddata) {
      var promise = $http.post(
        '/services/{portalid}/geometry/unionifpossible?f=json',
        senddata
      );
      return promise;
    }

    /**
     * Function: buffer
     */
    let buffer = (senddata, bufferMethod, distance) => {
      return $http.post(
        '/services/{portalid}/geometry/buffer?f=json' +
        '&bufferMethod=' + bufferMethod +
        '&distance=' + distance,
        senddata
      );
    };

    /**
     * Function: difference
     */
    function difference(senddata, DifferenceGeometry) {
      var promise = $http.post(
        '/services/{portalid}/geometry/difference?f=json' +
          '&DifferenceGeometry=' +
          DifferenceGeometry,
        senddata
      );
      return promise;
    }
    /**
     * Function: unionandbuffer
     */
    function unionandbuffer(senddata, bufferMethod, distance) {
      var promise = $http.post(
        '/services/{portalid}/geometry/unionandbuffer?f=json' +
          '&bufferMethod=' +
          bufferMethod +
          '&distance=' +
          distance,
        senddata
      );
      return promise;
    }
    /**
     * Function: project
     */
    function project(senddata, inCRS, outCRS) {
      var promise = $http.post(
        '/services/{portalid}/geometry/project?f=json' +
          '&inCRS=' +
          inCRS +
          '&outCRS=' +
          outCRS,
        senddata
      );
      return promise;
    }
    /**
     * Function: autocomplete
     */
    function autocomplete(senddata, polygons, polylines) {
      var promise = $http.post(
        '/services/{portalid}/geometry/autoComplete?f=json' +
          '&polygons=' +
          polygons +
          '&polylines=' +
          polylines,
        senddata
      );
      return promise;
    }
    /**
     * Function: simplify
     */
    function simplify(senddata) {
      var promise = $http.post(
        '/services/{portalid}/geometry/simplify?f=json',
        senddata
      );
      return promise;
    }
    /**
     * Function: intersectTwoGeoms
     */
    function intersectTwoGeoms(senddata) {
      var promise = $http.post(
        '/services/{portalid}/geometry/intersectTwoGeoms?f=json',
        senddata
      );
      return promise;
    }
    /**
     * Function: intersect
     */
    function intersect(senddata, intersectGeometry) {
      var promise = $http.post(
        '/services/{portalid}/geometry/intersect?f=json' +
          '&intersectGeometry=' +
          intersectGeometry,
        senddata
      );
      return promise;
    }

    /**
     * Function: cut
     */
    function cut(senddata, CutterGeometry) {
      var promise = $http.post(
        '/services/{portalid}/geometry/cut?f=json' +
          '&CutterGeometry=' +
          CutterGeometry,
        senddata
      );
      return promise;
    }
    /**
     * Function: getcentroid
     */
    function getcentroid(senddata) {
      var promise = $http.post(
        '/services/{portalid}/geometry/getCentroid?f=json',
        senddata
      );
      return promise;
    }
    /**
     * Function: convexhull
     */
    function convexhull(senddata) {
      var promise = $http.post(
        '/services/{portalid}/geometry/convexHull?f=json',
        senddata
      );
      return promise;
    }

    function movePointWithLine(senddata) {
      var promise = $http.post(
        '/services/{portalid}/geometry/movepointwithline?f=json',
        senddata
      );
      return promise;
    }

    function moveLineWithLine(senddata) {
      var promise = $http.post(
        '/services/{portalid}/geometry/movelinetwithline?f=json',
        senddata
      );
      return promise;
    }

    /**
     * Opération qui peut être effectuée avec openlayers<ul><li>
     *   ol.geom.LineString.getCoordinatesAt()</li><li>
     *   MapJsUtils.getMultiLineStringCoordinatesAt()</li></ul>
     * @param {string} senddata tableau de géométries au format Geojson
     * @param {number} distance distance à laquelle doit etre calculée le point à partir de l'extrémité de départ de la ligne
     * @return {Promise} response contenant les coordonnées du point sous la forme d'une string
     */
    function getPointAtDistanceOnLine(senddata, distance) {
      return $http.post(
        '/services/{portalid}/geometry/getpointatdistanceonline?f=json' +
          '&distance=' +
          distance,
        senddata
      );
    }

    function getCentroidInPolygon(senddata) {
      var promise = $http.post(
        '/services/{portalid}/geometry/getCentroidInPolygon?f=json',
        senddata
      );
      return promise;
    }

    /**
     * Teste si la géométrie linéaire s'intersecte elle-même.
     * Utilise la méthode de Geotools de la classe Geometry: isSimple()
     * @param {string} lineGeometry géométrie linéaire geojson (ex. {type, coordinates})
     * @return {Promise} contient un booleen égal à true si la ligne s'intersecte elle-même sinon false
     */
    const isLineSelfIntersecting = (lineGeometry) => {
      return $http.post('/services/{portalid}/geometry/isLineSelfIntersecting?f=json', lineGeometry)
      .catch(error => {
        if (error && error.data && error.data.message) {
          require('toastr').error($filter('translate')(error.data.message));
        } else {
          require('toastr').error($filter('translate')('rulecfg.mustNotSelfIntersect.error'));
        }
      });
    };



    /**
     * Teste si la géométrie linéaire se chevauche elle-même.
     * Utilise la méthode de Geotools de la classe Geometry: isSimple()
     * @param {object} lineGeometry géométrie linéaire geojson (ex. {type, coordinates})
     * @return {boolean} true si la ligne se superpose elle-même sinon false
     */
    const isLineSelfOverlapping = (lineGeometry) => {
      return $http.post('/services/{portalid}/geometry/isLineSelfOverlapping?f=json', lineGeometry)
      .catch(
          error => {
            if (error && error.data && error.data.message) {
              require('toastr').error($filter('translate')(error.data.message));
            } else {
              require('toastr').error($filter('translate')('rulecfg.mustNotSelfIntersect.error'));
            }
          }
      );
    };
    /**
     * Trouve les objets qui se chevauchent à la géométrie fournie dans le corps de la requête.
     * Méthode pour suppléer l'opérateur overlap qui ne fonctionne pas correctement.
     * @param geometry geométrie linéaire ou surfacique pour laquelle on veut rechercher la présence d'objet en chevauchement
     * @param ftis liste d'uid de fti séparés par une virgule
     * @param outGeomType type de géométrie recherché en sortie ('LINESTRING', 'POLYGON'...), si null tous les types sont renvoyés
     * @param mapSrid srid de la carte de l'application KIS Map
     * @param tolerance distance de superposition minimale entre 2 lignes pour être considéré comme un réel chevauchement (en mètres).
     *                  Paramètre utilisé uniquement pour évaluer un chevauchement entre 2 linéaires/polygones
     * @return {string} objet geojson contenant la collection d'objets chevauchant la géométrie en entrée
     */
    const overlap = (geometry, ftis, outGeomType, mapSrid, tolerance) => {
      let url = '/services/{portalid}/geometry/overlap?f=json' + '&ftiUids=' + ftis
          + '&outGeomType=' + outGeomType + '&mapSrid=' + mapSrid;
      if (tolerance) {
        url += '&tolerance=' + tolerance;
      }
      return $http.post(url, geometry).catch(
          error => {
            if (error && typeof error.data === 'string') {
              console.error(error.data);
            }
            if (typeof error === 'object' && error !== null && error.hasOwnProperty('data')
                && typeof error.data === 'object' && error.data !== null
                && typeof error.data.message === 'string' && Array.isArray(error.data.details)
                && error.data.details.length > 0) {
              require('toastr').error($filter('translate')(error.message));
              console.error(error.data.details[0])
            }
          }
      );
    };

    return {
      GeometryFactory: GeometryFactory,
      union: union,
      unionifpossible: unionifpossible,
      buffer: buffer,
      difference: difference,
      unionandbuffer: unionandbuffer,
      project: project,
      autocomplete: autocomplete,
      simplify: simplify,
      intersectTwoGeoms: intersectTwoGeoms,
      intersect: intersect,
      getcentroid: getcentroid,
      cut: cut,
      convexhull: convexhull,
      movepointwithline: movePointWithLine,
      moveLineWithLine: moveLineWithLine,
      getPointAtDistanceOnLine: getPointAtDistanceOnLine,
      getCentroidInPolygon: getCentroidInPolygon,
      isLineSelfOverlapping: isLineSelfOverlapping,
      isLineSelfIntersecting: isLineSelfIntersecting,
      overlap: overlap
    };
  };
  GeometryFactory.$inject = ['$http', '$filter'];
  return GeometryFactory;
});


define('modules/geometry/services/GeoTreatmentFactory',['toastr','toastr'],function() {
  let GeoTreatmentFactory = ($http, $filter, $timeout, gclayers, SelectManager)=> {
    let GeoTreatmentFactory = {};
    const CURRENT_SELECTION = 'CURRENT_SELECTION';
    const DATABASE = 'BD';
    const CURRENT_VIEW = 'View';
    const SELECT_ZONE = 'Zone';

    let handlePromiseError= () =>{
      require('toastr').error('erreur serveur');
    };

    let result = (senddata, map) => {
      const mapsrid = map
        .getView()
        .getProjection()
        .getCode();
      let promise = $http.post(
        '/services/{portalid}/geotreatment/result?f=json&mapsrid=' + mapsrid,
        senddata
      ).catch(handlePromiseError);
      return promise;
    };

    let moreResults = (senddata, mapSrid) =>{
      if (mapSrid == undefined) mapSrid = '';
      var promise = $http.post(
        '/services/{portalid}/geotreatment/moreResults?f=json&mapSrid=' +
          mapSrid,
        senddata
      ).catch(handlePromiseError);
      return promise;
    };

    let sql = () => {
      let promise = $http.get('/services/{portalid}/geotreatment/sql?f=json')
      .catch(handlePromiseError);
      return promise;
    };

    let applychange = (senddata, typeOfGeotreatment, attributesTochange,
      insertNew)=> {
      let promise = $http.post(
        '/services/{portalid}/geotreatment/applychange?f=json&typeOfGeotreatment=' +
          typeOfGeotreatment +
          '&attributesTochange=' +
          attributesTochange +
          '&insertNew=' +
          insertNew,
        senddata
      ).catch(handlePromiseError);
      return promise;
    };

    let surveytreatment = (senddata)=> {
      var promise = $http.post(
        '/services/{portalid}/geotreatment/survey?f=json',
        senddata
      ).catch(handlePromiseError);
      return promise;
    };

    let stoptreatment = (senddata)=> {
      var promise = $http.post(
        '/services/{portalid}/geotreatment/stop?f=json',
        senddata
      );
      return promise;
    };

    let treatment = (senddata, method)=> {
      let promise = $http.post(
        '/services/{portalid}/geotreatment/run?f=json' + '&method=' + method,
        senddata
      ).catch(handlePromiseError);
      return promise;
    };

    let manageInterruption = (scope)=> {
      scope.interrupt = false;
      swal({
        title: $filter('translate')('geotreat.geotreatments'),
        text: $filter('translate')('geotreat.interrupted'),
        type: 'warning',
        showCancelButton: false,
        confirmButtonColor: '#DD6B55',
        confirmButtonText: $filter('translate')('common.ok'),
        closeOnConfirm: true,
      });
    };

    let tick = (scope, attributeList, actionList)=> {
      if (scope.httpStatus === 204 ) {
        scope.inprogress = false;
        require('toastr').error(
          "Il n'y a pas de " + scope.$parent.$parent.$parent.title,
          '',
          {
            positionClass: 'toast-bottom-left',
          });
      }
      else {
        let ind,
          mess = '';
        if (!scope.interrupt) {
          surveytreatment(scope.state).then(function (data2) {
            scope.state = data2.data;
            if (scope.state.state == 'RUNNABLE') {
              $timeout(function () {
                tick(scope, attributeList, actionList);
              }, 2000);
            } else if (scope.state.state == 'TERMINATED') {
              result(scope.state, scope.map).then(function (data3) {
                scope.inprogress = false;
                if (data3.data.etat != 'erreur') {
                  scope.result = JSON.parse(data3.data.objValeur);
                  scope.attributes = attributeList;
                  gclayers
                  .getDrawLayer()
                  .getSource()
                  .clear();
                  scope.vopenResult(scope);
                  if (actionList != undefined) {
                    scope.actions = actionList;
                  }
                }
                else {
                  for (ind = 0; ind < data3.data.errorList.length; ind++) {
                    if (mess != '') mess += '\n';
                    mess += data3.data.errorList[ind].message_kis;
                  }
                  swal({
                    title: $filter('translate')('geotreat.geotreatments'),
                    text: $filter('translate')('common.error') + ': ' + mess,
                    type: 'error',
                    showCancelButton: false,
                    confirmButtonColor: '#DD6B55',
                    confirmButtonText: $filter('translate')('common.ok'),
                    closeOnConfirm: true,
                  });
                }
              });
            }
          });
        } else {
          manageInterruption(scope);
        }
      }
    };

    /**
     * 
     * @param {*} geoLimit 
     * @param {*} map 
     * @param {*} limitZoneGeometry 
     * @param {Array of String} ftisName liste des noms des couches sélectionnés
     * @param {Array} featureCollections tableau vide qui sera rempli avec les objets de
     *    la sélection courante (si nécessaire)
     * @returns 
     */
    const getSpatialClause = (geoLimit, map, limitZoneGeometry, ftisName, featureCollections) => {
      const wktObj = new ol.format.WKT();
      let spatialClause = '';
      switch (geoLimit) {
        case CURRENT_VIEW:
          const currExtent = map
            .getView()
            .calculateExtent(map.getSize());
          const polyExtent = ol.geom.Polygon.fromExtent(currExtent);
          const wktStr = wktObj.writeGeometry(polyExtent);
          spatialClause = 'INTERSECTS(geom, ' + wktStr + ')';
          break;
        case SELECT_ZONE:
          if (limitZoneGeometry != null) {
            const coords = limitZoneGeometry.coordinates;
            const polyCoords = new ol.geom.Polygon(coords, 'XY');
            const wktStr = wktObj.writeGeometry(polyCoords);
            spatialClause = 'INTERSECTS(geom, ' + wktStr + ')';
          }
          break;
        case DATABASE:
          spatialClause = 'no';
          break;
        case CURRENT_SELECTION:
          for (const ftiName of ftisName) {
            // récupère seulement les objets qui sont de type ftiName
            featureCollections.push({
              features: SelectManager.getFeaturesByftiType(ftiName).features,
              type: "FeatureCollection"
            });
          }
          break;
        default:
          console.error('geotreatment: search zone is not correct.');
          break;
      }
      return spatialClause;
    };

    return {
      GeoTreatmentFactory: GeoTreatmentFactory,
      CURRENT_SELECTION: CURRENT_SELECTION,
      DATABASE: DATABASE,
      CURRENT_VIEW: CURRENT_VIEW,
      SELECT_ZONE: SELECT_ZONE,
      result: result,
      moreResults: moreResults,
      applychange: applychange,
      sql: sql,
      surveytreatment: surveytreatment,
      stoptreatment: stoptreatment,
      treatment: treatment,
      manageInterruption: manageInterruption,
      tick: tick,
      getSpatialClause: getSpatialClause
    };
  };
  GeoTreatmentFactory.$inject = ['$http', '$filter', '$timeout', 'gclayers', 'SelectManager'];
  return GeoTreatmentFactory;
});



define('modules/geometry/mod',[
  'angular',
  'modules/geometry/services/GeometryFactory',
  'modules/geometry/services/GeoTreatmentFactory',
], function(angular, GeometryFactory, GeoTreatmentFactory) {
  // Module
  var mod = angular.module('geometry', []);

  // Services
  mod.factory('GeometryFactory', GeometryFactory);

  mod.factory('GeoTreatmentFactory', GeoTreatmentFactory);

  return mod;
});


define('modules/googlemaps/services/GoogleMapsFactory',['toastr'],function() {
  var GoogleMapsFactory = function(
    $window,
    $q,
    $rootScope,
    $http,
    gaJsUtils,
    $filter
  ) {
    var GoogleMapsFactory = {};
    /**
     * Class : GoogleMapsFactory
     * Factory WebServices
     */
    /**
     * LazyLoad GoogleStreetView script
     * @returns {*}
     */
    function lazyLoad() {
      var body = angular
        .element(document)
        .find('body')
        .eq(0);
      body.addClass('waitCursor');
      var deferred = $q.defer(),
        resolve = function() {
          body.removeClass('waitCursor');
          deferred.resolve();
        };
      if ($window.google && $window.google.maps) {
        console.log('Gmap Already Loaded');
        resolve();
      } else {
        var googleKey = false;
        var _gk = gaJsUtils.checkNestedProperty(
          'portal.parameters.apikey.google',
          $rootScope.xgos
        );
        if (_gk && _gk.trim() != '') {
          googleKey = $rootScope.xgos.portal.parameters.apikey.google;
        }
        var s = document.createElement('script'); // use global document since Angular's $document is weak
        var langage = localStorage.getItem('current_language');
        s.src =
          'https://maps.googleapis.com/maps/api/js?sensor=false&callback=initialize&language=' +
          langage;
        if (googleKey) s.src += '&key=' + googleKey;
        document.body.appendChild(s);
        $window.initialize = function() {
          resolve();
          require('toastr').clear();
          //require('toastr').success($filter('translate')('common.gmap_loaded'));
        };
      }
      return deferred.promise;
    }
    /**
     * Transform evt.coordinate into EPSG:4326
     * and return a google.maps.LatLng object
     * @param coordinate
     * @param projection
     * @returns {google.maps.LatLng}
     */
    function coordinatesToLatLng(coordinate, projection, notGoogle) {
      var transformCoordinates = ol.proj.transform(
          [coordinate[0], coordinate[1]],
          projection,
          'EPSG:4326'
        ),
        lat = Math.round(transformCoordinates[1] * 10000000) / 10000000,
        lng = Math.round(transformCoordinates[0] * 10000000) / 10000000;
      if (notGoogle) {
        return [lng, lat];
      } else {
        return new google.maps.LatLng(lat, lng);
      }
    }
    /**
     * Transform gmap LatLng to coordinates in the map current projection
     * @param position
     * @param projection
     * @returns {ol.Coordinate}
     */
    function latLngTocoordinates(position, projection) {
      return ol.proj.transform(
        [position.lng, position.lat],
        'EPSG:4326',
        projection
      );
    }
    /**
     * set the dragable layers
     * @param dragableLayers
     * @returns {Drag}
     */
    function setDragableLayers(dragableLayers) {
      var Drag = function() {
        ol.interaction.Pointer.call(this, {
          handleDownEvent: Drag.prototype.handleDownEvent,
          handleDragEvent: Drag.prototype.handleDragEvent,
          handleMoveEvent: Drag.prototype.handleMoveEvent,
          handleUpEvent: Drag.prototype.handleUpEvent,
        });
        this.dragableLayers = dragableLayers;
        this.coordinate_ = null;
        this.cursor_ = 'pointer';
        this.feature_ = null;
        this.previousCursor_ = undefined;
      };
      ol.inherits(Drag, ol.interaction.Pointer);
      Drag.prototype.handleDownEvent = function(evt) {
        var featureLayer = evt.map.forEachFeatureAtPixel(evt.pixel, function(
          feature,
          layer
        ) {
          return [feature, layer];
        });
        /* Only allowed Layers */
        if (featureLayer && featureLayer[0]) {
          if (this.dragableLayers.indexOf(featureLayer[1]) != -1) {
            this.coordinate_ = evt.coordinate;
            this.feature_ = featureLayer[0];
          }
          return !!featureLayer[0];
        } else {
          return false;
        }
      };
      Drag.prototype.handleDragEvent = function(evt) {
        /* Only allowed Layers */
        if (this.feature_ != null) {
          var deltaX = evt.coordinate[0] - this.coordinate_[0];
          var deltaY = evt.coordinate[1] - this.coordinate_[1];
          this.feature_.getGeometry().translate(deltaX, deltaY);
          this.feature_.moving = true;
          this.coordinate_[0] = evt.coordinate[0];
          this.coordinate_[1] = evt.coordinate[1];
        }
      };
      Drag.prototype.handleMoveEvent = function(evt) {
        if (this.cursor_) {
          /* Only allowed Layers */
          var feature = evt.map.forEachFeatureAtPixel(evt.pixel, function(
            feature,
            layer
          ) {
            if (this.dragableLayers.indexOf(layer) != -1) {
              return feature;
            }
          });
          var element = evt.map.getTargetElement();
          if (feature) {
            if (element.style.cursor != this.cursor_) {
              this.previousCursor_ = element.style.cursor;
              element.style.cursor = this.cursor_;
            }
          } else if (this.previousCursor_ !== undefined) {
            element.style.cursor = this.previousCursor_;
            this.previousCursor_ = undefined;
          }
        }
      };
      Drag.prototype.handleUpEvent = function(evt) {
        if (this.feature_) {
          this.feature_.moving = false;
        }
        this.coordinate_ = null;
        this.feature_ = null;
        return false;
      };
      return new Drag();
    }
    /* urls des services */
    function getInformationsFromCoordinates(latlng, apikey) {
      return $http.get(
        'https://maps.googleapis.com/maps/api/geocode/json?latlng=' +
          latlng.lat() +
          ',' +
          latlng.lng() +
          '&key=' +
          apikey
      );
    }
    function getInformationsFromAddress(apikey, params) {
      return $http.get(
        'https://maps.googleapis.com/maps/api/geocode/json?key=' + apikey,
        {
          params: params,
        }
      );
    }
    function getElevationFromOpenRoute(coordinatesLatLng) {
      return $http({
        url: 'https://api.openrouteservice.org/elevation/line',
        method: 'POST',
        data: {
          format_in: 'polyline',
          format_out: 'geojson',
          geometry: coordinatesLatLng,
        },
        headers: {
          Authorization: $rootScope.xgos.portal.parameters.apikey.openroute,
        },
      });
    }
    function typeOfApiUsed() {
      const ign = $rootScope.xgos.portal.parameters.apikey.ign;
      if (ign && ign.trim() != '') {
        return 'ign';
      } else {
        const openroute = $rootScope.xgos.portal.parameters.apikey.openroute;
        if (openroute && openroute.trim() != '') {
          return 'openroute';
        } else {
          const google = $rootScope.xgos.portal.parameters.apikey.google;
          if (google && google.trim() != '') {
            return 'google';
          }
        }
      }
    }
    return {
      GoogleMapsFactory: GoogleMapsFactory,
      lazyLoad: lazyLoad,
      coordinatesToLatLng: coordinatesToLatLng,
      latLngTocoordinates: latLngTocoordinates,
      setDragableLayers: setDragableLayers,
      getInformationsFromCoordinates: getInformationsFromCoordinates,
      getInformationsFromAddress: getInformationsFromAddress,
      getElevationFromOpenRoute: getElevationFromOpenRoute,
      typeOfApiUsed: typeOfApiUsed,
    };
  };
  GoogleMapsFactory.$inject = [
    '$window',
    '$q',
    '$rootScope',
    '$http',
    'gaJsUtils',
    '$filter',
  ];
  return GoogleMapsFactory;
});


define('modules/googlemaps/services/GoogleGeocodeFactory',[],function() {
  var GoogleGeocodeFactory = function($window, $q, $http) {
    var GoogleGeocodeFactory = {};

    /**
     * Getting Coordinates Informations from GoogleMap api
     * @param address
     * @param filters
     * @returns {*}
     */
    function getInformationsFromAddress(address, filters) {
      var params = { address: address, sensor: false };
      if (filters) {
        params.components = '';
        for (var i in filters) {
          params.components += i + ':' + filters[i] + '|';
        }
        params.components = params.components.substring(
          0,
          params.components.length - 1
        );
      }
      var promise = $http.get(
        'https://maps.googleapis.com/maps/api/geocode/json',
        { params: params }
      );
      return promise;
    }

    /**
     * Getting Coordinates Informations from GoogleMap api
     * @param address
     * @param filters
     * @returns {*}
     */
    function getAdresseFromCoordinate(coordinate) {
      var params = {
        latlng: coordinate[0] + ',' + coordinate[1],
        location_type: 'ROOFTOP',
        result_type: 'street_address',
      };

      var promise = $http.get(
        ' https://nominatim.openstreetmap.org/reverse?format=json&lat=' +
          coordinate[1] +
          '&lon=' +
          coordinate[0] +
          '&zoom=18&addressdetails=1',
        { params: params }
      );
      return promise;
    }

    return {
      GoogleGeocodeFactory: GoogleGeocodeFactory,
      getInformationsFromAddress: getInformationsFromAddress,
      getAdresseFromCoordinate: getAdresseFromCoordinate,
    };
  };
  GoogleGeocodeFactory.$inject = ['$window', '$q', '$http'];
  return GoogleGeocodeFactory;
});



define('modules/googlemaps/mod',[
  'angular',
  'modules/googlemaps/services/GoogleMapsFactory',
  'modules/googlemaps/services/GoogleGeocodeFactory',
], function(angular, GoogleMapsFactory, GoogleGeocodeFactory) {
  var mod = angular.module('googlemaps', []);
  mod.factory('GoogleMapsFactory', GoogleMapsFactory);
  mod.factory('GoogleGeocodeFactory', GoogleGeocodeFactory);

  return mod;
});


define('modules/query/services/QueryFactory',['toastr','toastr'],function() {
  var QueryFactory = function(
    $http,
    $filter,
    gcRestrictionProvider,
    $q
  ) {
    var Query = {};

    /**
     * Class : Query Factory WebServices
     */

    function updateMaintaSave2(data) {
      return $http.post(
        '/services/{portalid}/query/updateMaintaSave2?f=json',data
      );
    }
    /**
     * Function: get
     */
    function get(ftid, featureIDs, targetCrsName) {
      if (targetCrsName === undefined) {
        targetCrsName = '';
      }
      if (typeof queryAndroid !== 'undefined') {
        var defer = $q.defer();
        var int = createDefer(defer);
        queryAndroid.getFeaturesByIds(ftid, featureIDs,
          targetCrsName, int );
        return defer.promise;
      } else {
        var promise = $http.get(
          '/services/{portalid}/query/' + ftid + '/getFeaturesByIds?f=json' +
            '&featureIDs=' + featureIDs +
            '&targetCrsName=' + targetCrsName
        );
        promise.then(
          function() {
            // service level logic if any
          },
          function(result) {
            gcRestrictionProvider.showDetailsErrorMessage(result);
          }
        );
        return promise;
      }
    }

    var QueryDataDefers = [];
    /**
     * Function: data
     */
    function data(fid, where, mapCrs, page, count, sort) {
      var defer = $q.defer();
      if (mapCrs === undefined) mapCrs = '';
      if (page === undefined) page = '';
      if (count === undefined) count = '';
      if (sort === undefined) sort = '';
      // where = gaUrlUtils.encodeUriQuery(where || '');

      if (typeof queryAndroid !== 'undefined') {
        var int = createDefer(defer);
        queryAndroid.data(fid, where, page, count, sort, int);
        return defer.promise;
      } else {
        var postdata = {
          filter: where,
          page: page + '',
          count: count + '',
          sort: sort + '',
          mapCrs: mapCrs + '',
        };
        // var promise = $http.get('/services/{portalid}/query/' + fid +
        // '/data?f=json' + '&where=' + where + '&crs=' + mapCrs + '&page=' +
        // page + '&count=' + count+ '&sort=' + sort);
        if (fid) {
          var promise = $http.post(
            '/services/{portalid}/query/' + fid + '/data?f=json',
            postdata
          );
          promise.then(
            function() {
              // service level logic if any
            },
            function(result) {
              gcRestrictionProvider.showDetailsErrorMessage(result);
            }
          );
          return promise;
        }
          
      }
    }

    function createDefer(defer) {
      var int = Math.round(Math.random() * 10e7);
      QueryDataDefers.push({
        idx: int,
        defer: defer,
      });
      return int;
    }

    function dataResultAndroid(res, int) {
      var defer;
      try {
        var index;
        for (var i = 0; i < QueryDataDefers.length; i++) {
          var d = QueryDataDefers[i];
          if (d.idx === int) {
            defer = d.defer;
            index = i;
            break;
          }
        }

        var response = {
          data: res,
        };
        try {
          if (response.data && typeof response.data == 'string') {
            response.data = JSON.parse(response.data);
          }
        } catch (e) {
          console.log(response.data);
          e.stack;
        }
        defer.resolve(response);
      } catch (e) {
        e.stack;
        defer.reject();
      }
      QueryDataDefers.splice(index, 1);
    }

    /**
     * Function: pdata
     */
    function pdata(fid, where, mapCrs, page, count) {
      if (mapCrs === undefined) mapCrs = '';
      if (page === undefined) page = '';
      if (count === undefined) count = '';

      // where = gaUrlUtils.encodeUriQuery (where|| '');
      var promise = $http.post(
        '/services/{portalid}/query/' +
          fid +
          '/pdata?f=json' +
          '&crs=' +
          mapCrs +
          '&page=' +
          page +
          '&count=' +
          count,
        where
      );
      promise.then(
        function() {
          // service level logic if any
        },
        function(result) {
          gcRestrictionProvider.showDetailsErrorMessage(result);
        }
      );
      return promise;
    }


    /**
     * Function: pmultidata
     */
    function pmultidata(fids, where, mapCrs, page, count) {
      if (mapCrs === undefined) mapCrs = '';
      if (page === undefined) page = '';
      if (count === undefined) count = '';

      // where = gaUrlUtils.encodeUriQuery (where|| '');
      var promise = $http.post(
        '/services/{portalid}/query/' + fids + '/pmultidata?f=json' +
          '&crs=' + mapCrs + '&page=' + page + '&count=' + count,
        where
      );
      promise.then(
        () => {
          // service level logic if any
        },
        (result) => {
          gcRestrictionProvider.showDetailsErrorMessage(result);
        }
      );
      return promise;
    }


    /**
     * Function: popupdata
     */
    function popupdata(senddata) {
      return $http.post(
        '/services/{portalid}/query/data/popup?f=json',
        senddata
      );
    }


    /**
     * Function: relation
     */
    function relation(fid, namerelation, idobject, where, ogcobjectid,
      relationogcid,srid) {
      if (relationogcid == undefined) relationogcid = -1;

      var promise = $http.get(
        '/services/{portalid}/query/' + fid + '/relation/' + idobject +
          '?f=json' + '&fid=' + fid + '&namerelation=' + namerelation +
        '&idobject=' + idobject + '&where=' + where +
        '&ogcobjectid=' + ogcobjectid +
        '&relationogcid=' + relationogcid + '&srid=' + srid
      );
      promise.then( (res) => {
        if (res.data && res.data.etat === 'erreur') {
          require('toastr').error($filter('translate')(res.data.errorList[0].message_kis));
        }
      });
      return promise;
    }


    /**
     * Function: relation
     */
    function relationReprojected(fid, namerelation, idobject, where, crs) {
      return $http.get(
        '/services/{portalid}/query/' + fid + '/relationReprojected/'
        + idobject + '?f=json' + '&fid=' + fid
        + '&namerelation=' + namerelation + '&idobject=' + idobject
        + '&where=' + where + '&dstcrs=' + crs
      );
    }


    /**
     * Function: dataattribute
     * @param where clause where qui sera passer dans la requete
     */
    function dataattribute(fid, attribute, where) {
      if (!where) where = '';
      if (typeof queryAndroid !== 'undefined') {
        var defer = $q.defer();
        var response = {
          data: queryAndroid.dataattribute(fid, attribute),
        };
        // console.log(response.data);

        if (response.data) response.data = JSON.parse(response.data);
        defer.resolve(response);
        return defer.promise;
      } else {
        return $http.get(
            '/services/{portalid}/query/' +
            fid +
            '/data/attribute?f=json' +
            '&attribute=' +
            attribute +
            '&where=' +
            where
        ).catch(error => {
          if (typeof error.data === 'object' && error.data !== null) {
            if (error.data.hasOwnProperty('message')) {
              require('toastr').error($filter('translate')(error.data.message));
            }
            if (Array.isArray(error.data.details) && error.data.details.length > 0) {
              console.error('dataattribute : ' + error.data.details[0]);
            }
          }
        });
      }
    }
    /**
     * Function: dataattribute
     */
    function dataattributeCorrectedDate(fid, attribute, where) {
      if (!where) where = '';
      if (typeof queryAndroid !== 'undefined') {
        var defer = $q.defer();
        var response = {
          data: queryAndroid.dataattribute(fid, attribute),
        };
        // console.log(response.data);

        if (response.data) response.data = JSON.parse(response.data);
        defer.resolve(response);
        return defer.promise;
      } else {
        var promise = $http.get(
          '/services/{portalid}/query/' +
            fid +
            '/data/attribute/corrected?f=json' +
            '&attribute=' +
            attribute +
            '&where=' +
            where
        );
        return promise;
      }
    }
    /**
     * Function: datamultiquery
     */
    function datamultiquery(senddata, fid) {
      var promise = $http.post(
        '/services/{portalid}/query/' + fid + '/data/multiquery?f=json',
        senddata
      );
      return promise;
    }

    /**
     * Extract id value from id string which looks like "featuretypename.X"
     * where X is the identifier value.
     */
    function getFeatureId(feature) {
      var indPt;

      // -- If widget state is "insert" then there is no object identifier.
      if (feature.id == undefined) return null;
      indPt = ('' + feature.id).indexOf('.');
      if (indPt == -1) return parseInt(feature.id);
      else return parseInt(feature.id.substr(indPt + 1));
    }

    /**
     * Extract name value from id string which looks like "featuretypename.X"
     * where featuretypename is the feature type name.
     */
    function getFeatureName(feature) {
      var indPt;

      // -- If widget state is "insert" then there is no object identifier.
      if (feature == undefined || feature.id == undefined) return null;
      indPt = feature.id.indexOf('.');
      if (indPt == -1) return feature.id;
      else return feature.id.substr(0, indPt);
    }

    function getAttachementAndroid(documentId, ftiname, id) {
      var defer = $q.defer();
      var int = createDefer(defer);
      ancAppAndroid.getAttachement(documentId, ftiname, id, int);
      return defer.promise;
    }

    function getObjectId(obj, fti) {
      if (obj && obj.id && fti && fti.uid) {
        const response = $filter('translate')('features.' + fti.name + '.alias');
        if (!fti.showFid) return response;

        // si esri, on défini attributeFid en fonction de esriIdField

        let attributeFid = fti.attributeFid;
        if (fti.type === 'esri') {
          if (fti.useDifferentFID) {
            attributeFid = fti.attributeFid ? fti.attributeFid : (fti.esriIdField !== null && fti.esriIdField
            !== undefined ? fti.esriIdField : 'objectid');
          } else {
            attributeFid = fti.esriIdField !== null && fti.esriIdField !== undefined ? fti.esriIdField : 'objectid';
          }
        }


        if (fti.showFid && !fti.useDifferentFID) {
          if (fti.type === 'esri' && fti.esriIdField !== 'objectid') {
            const idValue = obj.properties[attributeFid] ? obj.properties[attributeFid] : '';
            return response + ' ' + idValue;
          }else {
            return response + ' ' + obj.id.replace(fti.name + '.', '');
          }
        }

        if (fti.showFid && fti.useDifferentFID) {
          if (attributeFid) {
            const attributeFidValue = obj.properties[attributeFid];
            return attributeFidValue && angular.isDefined(attributeFidValue)
              ? response + ' ' + attributeFidValue
              : response;
          } else {
            return (
              $filter('translate')('model.featuretypes.fid.conferror') +
              ' ' +
              $filter('translate')('features.' + fti.name + '.alias')
            );
          }
        }

        return (
          $filter('translate')('model.featuretypes.fid.conferror') +
          ' ' +
          $filter('translate')('features.' + fti.name + '.alias')
        );
      } else if ((!obj || !obj.id) && fti && fti.uid) {
        return $filter('translate')('features.' + fti.name + '.alias');
      } else if (obj && obj.id && (!fti || !fti.uid)) {
        return obj.id.replace('.', ' ');
      } else {
        return $filter('translate')('model.featuretypes.fid.unknownObject');
      }
    }

    /**
     * Function: listFichSQL
     */
    function listFichSQL() {
      var promise = $http.post(
        '/services/{portalid}/query/data/listFichSQL?f=json'
      );
      return promise;
    }
    /** ** affiche requet** */
    function afficherequet(nomDir, nomApp, idWidget) {
      var promise = $http.post(
        '/services/{portalid}/query/data/afficherequet?f=json' +
          '&nomDir=' +
          nomDir +
          '&nomApp=' +
          nomApp +
          '&idWidget=' +
          idWidget
      );
      return promise;
    }
    /***************************************************************************
     * Permet de mettre a jour un fichier sql
     **************************************************************************/
    function MAJFichSQL(requete, nomApp, idWidget) {
      var promise = $http.post(
        '/services/{portalid}/query/data/MAJFichSQL?f=json' +
          '&nomApp=' +
          nomApp +
          '&idWidget=' +
          idWidget,
        requete
      );
      return promise;
    }
    /***************************************************************************
     * Permet de créer un fichier sql
     **************************************************************************/
    function createFichSQL(requete, nomApp, idWidget) {
      var promise = $http.post(
        '/services/{portalid}/query/data/createFichSQL?f=json' +
          '&nomApp=' +
          nomApp +
          '&idWidget=' +
          idWidget,
        requete
      );
      return promise;
    }

    /***************************************************************************
     * remove fichier sql
     **************************************************************************/

    function removeRequete(newRequeteNameFile, nomApp, idWidget) {
      var promise = $http.post(
        '/services/{portalid}/query/data/removeRequete?f=json' +
          '&newRequeteNameFile=' +
          newRequeteNameFile +
          '&nomApp=' +
          nomApp +
          '&idWidget=' +
          idWidget
      );
      return promise;
    }

    /***************************************************************************
     * Function: execute d'un fichier sql
     **************************************************************************/
    function executFichSQL(storeName, senddata, test) {
      var promise = $http.post(
        '/services/{portalid}/query/data/executFichSQL?f=json' +
          '&storeName=' +
          storeName +
          '&test=' +
          test,
        senddata
      );
      return promise;
    }

    function executeAdvancedFilters(filters, db, test=false) {
      var promise = $http.post(
        '/services/{portalid}/query/data/executeFiltresAvancesQuery?f=json' +
          `&storeName=${db}` +
          `&test=${test}`,
        filters
      );
      return promise;
    }

    function getFilterCategories(nomApp, idWidget) {
      var promise = $http.post(
        '/services/{portalid}/query/data/getFilterCategories?f=json' +
          '&nomApp=' +
          nomApp +
          '&idWidget=' +
          idWidget
      );
      return promise;
    }

    function addCategorie(titreCat, nomApp, idWidget) {
      var promise = $http.post(
        '/services/{portalid}/query/data/addCategorie?f=json' +
          '&titreCat=' +
          titreCat +
          '&nomApp=' +
          nomApp +
          '&idWidget=' +
          idWidget
      );
      return promise;
    }
    function removeCategorie(uidCategorie, nomApp, idWidget) {
      var promise = $http.post(
        '/services/{portalid}/query/data/removeCategorie?f=json' +
          '&uidCategorie=' +
          uidCategorie +
          '&nomApp=' +
          nomApp +
          '&idWidget=' +
          idWidget
      );
      return promise;
    }

    function editCategorie(nameCategorie, uidCategorie, nomApp, idWidget) {
      var promise = $http.post(
        '/services/{portalid}/query/data/editCategorie?f=json' +
          '&nameCategorie=' +
          nameCategorie +
          '&uidCategorie=' +
          uidCategorie +
          '&nomApp=' +
          nomApp +
          '&idWidget=' +
          idWidget
      );
      return promise;
    }

    function getAllFeatureTypeInfo() {
      var promise = $http.post(
        '/services/{portalid}/query/data/getAllFeatureTypeInfo?f=json'
      );
      return promise;
    }
    function getFeatureByNameAndTable(table) {
      var promise = $http.post(
        '/services/{portalid}/query/data/getFeatureByNameAndTable?f=json' +
          '&table=' +
          table
      );
      return promise;
    }

    /**
     * Function: objectsWithGeomRelation
     *
     * geomRelation: pour l'instant testé uniquement avec WITHIN.
     */
    function objectsWithGeomRelation(
      ftiToLookFor,
      container,
      geomRelation,
      containerSrid
    ) {
      var promise = $http.post(
        '/services/{portalid}/query/objectsWithGeomRelation?f=json' +
          '&fti=' +
          ftiToLookFor +
          '&geomrelation=' +
          geomRelation +
          '&containersrid=' +
          containerSrid,
        container
      );
      return promise;
    }

    function getCount(postdata) {
      return $http.post('/services/{portalid}/query/getCount?f=json', postdata);
    }

    /**
     * Récupère un tableau d'attributs triés par attributeLabel asc
     * Utilisée pour récupérer les tables de restriction
     * @param fid uid du composant ciblé
     * @param attributeLabel attribut à récupérer correspondant au libellé
     * @param attributeKey attribut à récupérer correspondant au code
     * @param whereClause clause where qui sera passer dans la requete
     * @returns {Promise} contenant un geojson où le tableau de features est la liste d'attributs
     * @see attributeRestrictions.selectRestrictedValue
     */
    function dataattributes(fid, attributeLabel, attributeKey, whereClause) {
      if (!whereClause) whereClause = '';
      if (!attributeLabel) attributeLabel = '';
      if (!attributeKey) attributeKey = '';
      if (typeof queryAndroid !== 'undefined') {
        const defer = $q.defer();
        const response = {
          data: queryAndroid.dataattributes(fid, attributeLabel, attributeKey),
        };
        if (response.data){
          response.data = JSON.parse(response.data);
        }
        defer.resolve(response);
        return defer.promise;
      } else {
        return $http.get(
          '/services/{portalid}/query/' +
            fid +
            '/data/attributes?f=json' +
            '&attributeLabel=' +
            attributeLabel +
            '&attributeKey=' +
            attributeKey +
            '&whereClause=' +
            whereClause
        );
      }
    }


    /**
     * Appel api pour récupérer des données dans un thread parallèle
     * Méthode équivalente à data avec utilisation d'un thread parallèle
     * @param fid uid du fti
     * @param where clause/filtre de la requête
     * @param mapCrs éventuelle projection saisie par l'utilisateur
     * @param page éventuel numéro de la page souhaitée
     * @param count éventuel nombre d'enregistrements souhaités
     * @param sort éventuel tri des enregistrement souhaité
     * @return {*} Promise contenant un tableau de features geojson
     * @see data
     * méthode analogue qui a inspiré la rédaction
     */
    function dataByThread(fid, where, mapCrs, page, count, sort) {
      const defer = $q.defer();
      if (mapCrs === undefined){mapCrs = '';}
      if (page === undefined){page = '';}
      if (count === undefined){count = '';}
      if (sort === undefined){sort = '';}

      if (typeof queryAndroid !== 'undefined') {
        const int = createDefer(defer);
        queryAndroid.data(fid, where, page, count, sort, int);
        return defer.promise;
      } else {
        const postdata = {
          filter: where,
          page: page + '',
          count: count + '',
          sort: sort + '',
          mapCrs: mapCrs + '',
        };

        const promise = $http.post(
          '/services/{portalid}/query/' + fid + '/dataByThread?f=json',
          postdata
        );
        promise.then(
          () => {
            // logique
          },
          (error) => {
            gcRestrictionProvider.showDetailsErrorMessage(error);
          }
        );
        return promise;
      }
    }

    /**
     * Récupère le status du processus d'export CSV
     * Utilisé depuis la page d'admin d'un composant
     * @param process processus d'export de fichier
     * @return {Promise} contenant le processus
     */
    function getDataProgression(process) {
      return $http.post(
        '/services/{portalid}/query/getDataProgression?', process
      );
    }


    /**
     *
     * @param {*} ftid uid of the component of the feature. 'fti.uid'
     *             do not use 'attribute.restrictions[0].ftid'
     * @param {*} attributeName
     * @param {*} value
     * @param whereClause
     * @returns an object like { key: "myKey" }. you will get your key in res.data.key
     */
    function getKeyRestrictionTable(ftid, attributeName, value, whereClause) {
      if (typeof queryAndroid !== 'undefined') {
        const defer = $q.defer();
        const response = {
          data: queryAndroid.getKeyRestrictionTable(ftid, attributeName, value),
        };
        if (response.data){
          response.data = JSON.parse(response.data);
        }
        defer.resolve(response);
        return defer.promise;
      } else {
        return $http.get(
          '/services/{portalid}/query/' +
            ftid +
            '/data/getKeyRestrictionTable?f=json' +
            '&attributeName=' +
            (attributeName ? attributeName : null) +
            '&value=' +
            // undefined = "undefined" in Java. it's better to send null.
            (value ? value : null) +
            '&filterCompleted=' + whereClause
        );
      }
    }


    // Je mets seulement 5 seconde de cache car je veux éviter les problèmes de mauvaise
    // valeurs en cache, le but étant juste d'optimiser le chargement d'une liste (gcDatatable ou autre)
    let cacheTableRestrictionValues = [];
    /**
     * @param {string} ftid uid of the component of the feature. 'fti.uid'
     *             do not use 'attribute.restrictions[0].ftid'
     * @param {string} attributeName
     * @param {string} key
     * @returns an object like { value: "myValue" }. you will get your value in res.data.value
     */
    function getValueRestrictionTable(ftid, attributeName, key) {
      if (typeof queryAndroid !== 'undefined') {
        const defer = $q.defer();
        const response = {
          data: queryAndroid.getValueRestrictionTable(ftid, attributeName, key),
        };
        if (response.data){
          response.data = JSON.parse(response.data);
        }
        defer.resolve(response);
        return defer.promise;
      } else {
        //get value in cache if possible
        //remove all cache values older than 5 seconds
        cacheTableRestrictionValues = cacheTableRestrictionValues.filter(it => it.timestamp + 5000 > Date.now());
        const valueObject = cacheTableRestrictionValues.find( it =>
            it.ftid === ftid 
            && it.attributeName === attributeName
            && it.key === key);
        if (valueObject && valueObject.promise) {
          return valueObject.promise
        } else {
          // value is not in cache
          const promise = $http.get(
            '/services/{portalid}/query/' +
              ftid +
              '/data/getValueRestrictionTable?f=json' +
              '&attributeName=' +
              (attributeName ? attributeName : null) +
              '&key=' +
              // undefined = "undefined" in Java. it's better to send null.
              (key ? key : null)
          );
          promise.catch( err => {
            console.error(err.data);
          });

          // cache the promise
          // on retournera la même promesse si on refait la même requete dans les 5 secondes
          cacheTableRestrictionValues.push(
            {
              ftid: ftid,
              attributeName: attributeName,
              key: key,
              promise: promise,
              timestamp: Date.now()
            }
          );

          return promise;
        }
      }
    }


    return {
      Query: Query,
      updateMaintaSave2: updateMaintaSave2,
      get: get,
      data: data,
      pdata: pdata,
      getFeatureId: getFeatureId,
      relation: relation,
      relationReprojected: relationReprojected,
      popupdata: popupdata,
      getFeatureName: getFeatureName,
      datamultiquery: datamultiquery,
      dataattribute: dataattribute,
      dataattributeCorrectedDate: dataattributeCorrectedDate,
      pmultidata: pmultidata,
      dataResultAndroid: dataResultAndroid,
      getAttachementAndroid: getAttachementAndroid,
      getObjectId: getObjectId,
      listFichSQL: listFichSQL,
      afficherequet: afficherequet,
      MAJFichSQL: MAJFichSQL,
      createFichSQL: createFichSQL,
      executFichSQL: executFichSQL,
      executeAdvancedFilters: executeAdvancedFilters,
      getFilterCategories: getFilterCategories,
      addCategorie: addCategorie,
      removeCategorie: removeCategorie,
      removeRequete: removeRequete,
      editCategorie: editCategorie,
      getAllFeatureTypeInfo: getAllFeatureTypeInfo,
      getFeatureByNameAndTable: getFeatureByNameAndTable,
      objectsWithGeomRelation: objectsWithGeomRelation,
      getCount: getCount,
      dataattributes: dataattributes,
      getKeyRestrictionTable: getKeyRestrictionTable,
      getValueRestrictionTable: getValueRestrictionTable,
      dataByThread: dataByThread,
      getDataProgression: getDataProgression
    };
  };

  QueryFactory.$inject = ['$http','$filter','gcRestrictionProvider','$q'];
  return QueryFactory;
});


define('modules/query/services/ChartsFactory',[],function() {
  var ChartsFactory = function($http) {
    var ChartsFactory = {};
    /**
     * Class : ChartsFactory Factory WebServices
     */

    /**
     * Function: datastats
     */
    function datastats(senddata) {
      var promise = $http.post(
        '/services/{portalid}/stats/stats/data?f=json',
        senddata
      );

      return promise;
    }
    /**
     * Function: datastatsedition
     */
    function datastatsedition(senddata) {
      var promise = $http.post(
        '/services/{portalid}/stats/stats/data/edition?f=json',
        senddata
      );

      return promise;
    }

    /**
     * Function: dataattribute
     */
    function dataattribute(senddata) {
      var promise = $http.post(
        '/services/{portalid}/stats/{fid}/charts/data?f=json',
        senddata
      );
      return promise;
    }

    /**
     * Function: areaperimeter
     */
    function areaperimeter(senddata ,areaOrLengh) {
      var promise = $http.post(
        '/services/{portalid}/stats/stats/areaperimeter?f=json' +
          '&areaOrLengh=' +
          areaOrLengh,
        senddata
      );
      return promise;
    }
    return {
      ChartsFactory: ChartsFactory,
      datastats: datastats,
      dataattribute: dataattribute,
      datastatsedition: datastatsedition,
      areaperimeter: areaperimeter,
    };
  };
  ChartsFactory.$inject = ['$http'];
  return ChartsFactory;
});


define('modules/query/services/LongitudinalProfileFactory',[],function() {
  var LongitudinalProfileFactory = function($http) {
    var LongitudinalProfileFactory = {};
    /**
     * Class : LongitudinalProfileFactory
     * Factory WebServices
     */

    /**
     * Function: get
     */
    function get(senddata) {
      var promise = $http.post(
        '/services/{portalid}/profile/longitudinal?f=json',
        senddata
      );

      return promise;
    }

    function exportProfil(senddata, exportFormat, encoding) {
      var promise = $http.post(
        '/services/{portalid}/profile/exportprofil?f=json'
          + '&exportFormat=' + exportFormat
          + (encoding ? ('&encoding=' + encoding) : ''),
        senddata
      );

      return promise;
    }

    function exportProfilToShapeFile(senddata) {
      var promise = $http.post(
        '/services/{portalid}/profile/exportprofil?f=json' +
          '&exportFormat=SHAPEFILE',
        senddata
      );

      return promise;
    }

    function exportProfilToDXF(senddata) {
      var promise = $http.post(
        '/services/{portalid}/profile/exportprofil?f=json' +
          '&exportFormat=DXF',
        senddata
      );

      return promise;
    }
    function isEsriType(fuid) {
      const promise = $http.get(
        '/services/{portalid}/profile/'+fuid+'?f=json'
      );

      return promise;
    }

    function generateJasperReport(senddata) {
      const promise = $http.post(
        '/services/{portalid}/profile/generatereport?f=json', senddata);
      return promise;
    };

    return {
      LongitudinalProfileFactory: LongitudinalProfileFactory,
      get: get,
      exportProfil: exportProfil,
      exportProfilToShapeFile: exportProfilToShapeFile,
      exportProfilToDXF: exportProfilToDXF,
      isEsriType: isEsriType,
      generateJasperReport: generateJasperReport,
    };
  };
  LongitudinalProfileFactory.$inject = ['$http'];
  return LongitudinalProfileFactory;
});


define('modules/query/services/ElasticFactory',[],function() {
  var ElasticFactory = function($http, $q) {
    var ElasticFactory = {};
    /**
     * Class : ElasticFactory
     * Factory WebServices
     */

    /**
     * Function: indexall
     */
    function indexall() {
      var promise = $http.get('/services/{portalid}/elastic/indexall?');

      return promise;
    }

    /**
     * Function: createIndex
     */
    function createIndex() {
      var promise = $http.get(
        '/services/{portalid}/elastic/create/simple/index?'
      );

      return promise;
    }

    /**
     * Function: deleteIndex
     */
    function deleteIndex(portalid) {
      var promise = $http.get(
        '/services/' + portalid + '/elastic/delete/simple/index?'
      );

      return promise;
    }

    /**
     * Function: createType
     * @param {string} ftiname
     */
    function createType(ftiname) {
      var promise = $http.get(
        '/services/{portalid}/elastic/create/simple/type?' + 'type=' + ftiname
      );

      return promise;
    }

    /**
     * Function: createTypeByJsonData
     * @param {string} name from fti
     * @param {object} sendata
     */
    function createTypeByJsonData(ftiname, sendata) {
      var promise = $http.post(
        '/services/{portalid}/elastic/create/simple/type?' + 'type=' + ftiname,
        sendata
      );

      return promise;
    }

    /**
     * Function: createCompleteType
     * @param {string} ftiname
     * @param {string} crs
     * @param {fastIndex} fastIndex utilisation du bulk et d'autres strategies pour augmenter la vitesse d'indexation
     */
    function createCompleteType(ftiname, crs, fastIndex) {
      fastIndex = fastIndex || false;

      var promise = $http.get(
        '/services/{portalid}/elastic/create/complete/type?' +
          'type=' +
          ftiname +
          '&crs=' +
          crs +
          '&fastIndex=' +
          fastIndex
      );

      return promise;
    }

    /**
     * Function: updateTypebyJson
     * @param {string} ftiname
     * @param {object} sendata
     */
    function updateTypebyJson(ftiname, sendata) {
      var promise = $http.post(
        '/services/{portalid}/elastic/update/simple/type?' + 'type=' + ftiname,
        sendata
      );

      return promise;
    }

    /**
     * Function: updateType
     * @param {string} ftiname
     */
    function updateType(ftiname) {
      var promise = $http.get(
        '/services/{portalid}/elastic/update/simple/type?' + 'type=' + ftiname
      );

      return promise;
    }

    /**
     * Function: addDocument
     * @param {string} ftiname
     * @param {string} crs
     * @param {object} sendata
     */
    function addDocument(ftiname, crs, sendata) {
      var promise = $http.post(
        '/services/{portalid}/elastic/add/simple/document?' +
          'type=' +
          ftiname +
          '&crs=' +
          crs,
        sendata
      );

      return promise;
    }

    /**
     * Function: addMultipleDocuments
     * @param {string} ftiname
     * @param {string} crs
     * @param {object} sendata
     */
    function addMultipleDocuments(ftiname, crs, sendata) {
      var promise = $http.post(
        '/services/{portalid}/elastic/add/multiple/document?' +
          'type=' +
          ftiname +
          '&crs=' +
          crs,
        sendata
      );

      return promise;
    }

    /**
     * Function: updateDocument
     * @param {string} ftiname
     * @param {string} crs
     * @param {object} sendata
     */
    function updateDocument(ftiname, crs, sendata) {
      var promise = $http.post(
        '/services/{portalid}/elastic/update/simple/document?' +
          'type=' +
          ftiname +
          '&crs=' +
          crs,
        sendata
      );

      return promise;
    }

    /**
     * Function: updatemultipleDocument
     * @param {string} ftiname
     * @param {string} crs
     * @param {object} sendata
     */
    function updatemultipleDocument(ftiname, crs, sendata) {
      var promise = $http.post(
        '/services/{portalid}/elastic/update/multiple/document?' +
          'type=' +
          ftiname +
          '&crs=' +
          crs,
        sendata
      );

      return promise;
    }

    /**
     * Function: getDocument
     * @param {string} ftiname
     * @param {String} uid
     */
    function getDocument(ftiname, uid) {
      var promise = $http.get(
        '/services/{portalid}/elastic/get/simple/document?' +
          'type=' +
          ftiname +
          '&uid=' +
          uid
      );

      return promise;
    }

    /**
     * Function: getMultipleDocument
     * @param {string} ftiname
     * @param {string} uids , "uid,uid,uid"
     */
    function getMultipleDocument(ftiname, uids) {
      var promise = $http.get(
        '/services/{portalid}/elastic/get/multiple/document?' +
          'type=' +
          ftiname +
          '&uids=' +
          uids
      );

      return promise;
    }

    /**
     * Function: deleteDocument
     * @param {string} ftiname
     * @param {string} crs
     * @param {String} uid
     */
    function deleteDocument(ftiname, crs, uid) {
      var promise = $http.get(
        '/services/{portalid}/elastic/delete/simple/document?' +
          'type=' +
          ftiname +
          '&uid=' +
          uid
      );

      return promise;
    }

    /**
     * Function: deleteMultipleDocument
     * @param {string} ftiname
     * @param {string} crs
     * @param {String} uid
     */
    function deleteMultipleDocument(ftiname, uids) {
      var promise = $http.get(
        '/services/{portalid}/elastic/delete/multiple/document?' +
          'type=' +
          ftiname +
          '&uids=' +
          uids
      );

      return promise;
    }

    /**
     * Function: deleteAllDocument
     * @param {string} ftiname
     */
    function deleteAllDocument(ftiname) {
      var promise = $http.get(
        '/services/{portalid}/elastic/delete/all/document?' + 'type=' + ftiname
      );

      return promise;
    }

    /**
     * Function: searchInType
     * @param {string} ftiname
     * @param {string} format , geojson ou json
     */
    function searchInType(ftiname, format, sendata, srid) {
      var promise = $http.post(
        '/services/{portalid}/elastic/search/in/type?' +
          'type=' +
          ftiname +
          '&format=' +
          format+
          '&srid=' +
          srid,
        sendata
      );

      return promise;
    }

    /**
     * Function: searchInTypeAnc
     * @param {string} ftiname
     * @param {string} format , geojson ou json
     */
    function searchInTypeAnc(ftiname, format, sendata, saveOriginalProperties) {
      // defer promise so we can apply the specific behavior
      console.log(sendata.searchquery);

      var def = $q.defer(),
        promise = $http.post(
          '/services/{portalid}/elastic/search/in/typeanc?' +
            'type=' +
            ftiname +
            '&format=' +
            format,
          sendata
        );

      var needToRemapDossierControlNames =
        angular.isDefined(sendata.liaisons) &&
        sendata.liaisons.length &&
        sendata.liaisons.filter(function(x) {
          return (
            x.child == 'kis_anc_dossier_controle_reponse' ||
            x.child == 'kis_bac_dossier_controle_reponse'
          );
        }).length;

      promise.then(
        function(res) {
          // comportement specifique kis_anc/bac_dossier_controle_reponse
          // on remplace les a.b.c.d du json des controles par un alias
          // @TODO : devrait etre fait cote serveur
          if (needToRemapDossierControlNames && res.data.totalFeatures > 0) {
            // console.log(sendata.opts);
            //  console.log(res.data);
            // garde une copie des attributs non modifiées
            if (saveOriginalProperties) {
              res.data.features.map(function(x) {
                x.originalProperties = angular.copy(x.properties);
              });
            }

            var cible =
              sendata.opts[
                angular.isDefined(sendata.opts.kis_anc_dossier_controle_reponse)
                  ? 'kis_anc_dossier_controle_reponse'
                  : 'kis_bac_dossier_controle_reponse'
              ];

            var tmp = cible.fti.attributes,
              attributesReference = {},
              attributsUtilises = res.data.fti.attributes.map(function(x) {
                return x.name;
              });

            var uniqAliases = {};
            for (var a in tmp) {
              if (attributsUtilises.indexOf(tmp[a].name) == -1) continue;
              // creation d'un index avec compteur pour le cas ou plusieurs attributs ont le meme alias...
              // sans quoi on doublonne les valeurs lors du remplacement dans la reponse
              if (!angular.isDefined(uniqAliases[tmp[a].alias])) {
                attributesReference[tmp[a].name] = tmp[a].alias;
                uniqAliases[tmp[a].alias] = 0;
              } else {
                uniqAliases[tmp[a].alias] = uniqAliases[tmp[a].alias] + 1;
                attributesReference[tmp[a].name] =
                  '(' + uniqAliases[tmp[a].alias] + ') ' + tmp[a].alias;
              }
            }

            // remplace dans le fti + dans les reponses
            for (var k in res.data.fti.attributes) {
              var attrName = res.data.fti.attributes[k].name;
              // si contient un ".", c'est sans doute une chaine de la reponse controle
              if (attrName.indexOf('.') != -1) {
                var _ref = attributesReference[attrName];
                res.data.fti.attributes[k].name = _ref;

                for (var i in res.data.features) {
                  for (var j in res.data.features[i].properties) {
                    if (j == attrName) {
                      res.data.features[i].properties[_ref] =
                        res.data.features[i].properties[j];
                      delete res.data.features[i].properties[j];
                    }
                  }
                }
              }
            }
          }

          // fin comportement specifique kis_anc_dossier_controle_reponse
          def.resolve(res);

          // service level logic if any
        },
        function() {
          def.reject();
        }
      );

      return def.promise;
    }

    /**
     * Function: searchInTypes
     * @param {string} ftiname
     * @param {string} format , geojson ou json
     */
    function searchInTypes(ftinames, format, sendata, srid) {
      var promise = $http.post(
        '/services/{portalid}/elastic/search/in/types?' +
          'types=' +
          ftinames +
          '&format=' +
          format+
          '&srid=' +
          srid,
        sendata
      );

      return promise;
    }

    /**
     * Function: searchInIndex
     * @param {string} ftiname
     * @param {string} format , geojson ou json
     */
    function searchInIndex(format, sendata, srid) {
      var promise = $http.post(
        '/services/{portalid}/elastic/search/in/index?' + 'format=' + format+ '&srid=' + srid,
        sendata
      );

      return promise;
    }

    /**
     * Function: searchInIndex
     * @param {string} format , geojson ou json
     */
    function advancedSearch(format, sendata, srid) {
      var promise = $http.post(
        '/services/{portalid}/elastic/advanced/search?' + 'format=' + format+ '&srid=' + srid,
        sendata
      );

      return promise;
    }

    /**
     * Function: relationalSearch
     * @param {string} format , geojson ou json
     */
    function relationalSearch(format, sendata, srid) {
      var promise = $http.post(
        '/services/{portalid}/elastic/relational/search?' + 'format=' + format+ '&srid=' + srid,
        sendata
      );

      return promise;
    }

    /**
     * Function: saveConfig
     * @param {string} format , geojson ou json
     */
    function saveConfig(filename, app, sendata) {
      var promise = $http.post(
        '/services/{portalid}/elastic/save/config?app=' +
          app +
          '&filename=' +
          filename,
        sendata
      );

      return promise;
    }

    /**
     * Function: getConfig
     * @param {string} format , geojson ou json
     */
    function getConfig(app) {
      var promise = $http.get(
        '/services/{portalid}/elastic/get/config?app=' + app
      );

      return promise;
    }

    /**
     * Function: saveConfig
     * @param {string} format , geojson ou json
     */
    function saveRelationalConfig(filename, app, sendata) {
      var promise = $http.post(
        '/services/{portalid}/elastic/save/relational/config?app=' +
          app +
          '&filename=' +
          filename,
        sendata
      );

      return promise;
    }

    /**
     * Function: getConfig
     * @param {string} format , geojson ou json
     */
    function getRelationalConfig(app) {
      var promise = $http.get(
        '/services/{portalid}/elastic/get/relational/config?app=' + app
      );

      return promise;
    }

    /**
     * Function: getConfig
     * @param {string} format , geojson ou json
     */
    function deleteSavedFile(app, fname) {
      var promise = $http.get(
        '/services/{portalid}/elastic/delete/saved/file?app=' +
          app +
          '&filename=' +
          fname
      );

      return promise;
    }

    /**
     * Function: getConfig
     * @param {string} format , geojson ou json
     */
    function getProgression() {
      var promise = $http.get('/services/{portalid}/elastic/get/progression?');

      return promise;
    }

    /**
     * Function: getprogressiondetaillee
     */
    function getprogressiondetaillee(index, type) {
      var promise = $http.get(
        '/services/{portalid}/elastic/get/progressionDetaillee?f=json' +
          '&index=' +
          index +
          '&type=' +
          type
      );

      return promise;
    }

    /**
     * Function: search
     */
    function search(senddata, types, f) {
      var promise = $http.post(
        '/services/{portalid}/elastic/search?' + '&types=' + types + '&f=' + f,
        senddata
      );

      return promise;
    }

    /**
     * Function: elastic
     */
    function elastic(ftid) {
      var promise = $http.get(
        '/services/{portalid}/elastic/indexes?f=json' + '&ftid=' + ftid
      );

      return promise;
    }

    /**
     * Function: createTypeByJsonData
     * @param {string} name from fti
     * @param {object} sendata
     */
    function getSuggestions(query, sendata) {
      var promise = $http.post(
        '/services/{portalid}/elastic/suggester/index?' + 'suggestion=' + query,
        sendata
      );

      return promise;
    }

    /**
     * Function: createTypeByJsonData
     * @param {string} name from fti
     * @param {object} sendata
     */
    function getSuggestionsFromTypes(query, sendata, types) {
      var promise = $http.post(
        '/services/{portalid}/elastic/suggester/types?' +
          'suggestion=' +
          query +
          '&types=' +
          types,
        sendata
      );

      return promise;
    }

    /**
     * Function: createTypeByJsonData
     * @param {string} name from fti
     * @param {object} sendata
     */
    function getSuggestionsFromType(query, sendata, types, field) {
      var promise = $http.post(
        '/services/{portalid}/elastic/suggester/in/type?' +
          'suggestion=' +
          query +
          '&type=' +
          types +
          '&field=' +
          field,
        sendata
      );

      return promise;
    }

    function cleanFieldValue(filter) {
      filter.value = undefined;
      filter.newvalue = undefined;
      filter.newValueUtil = {};
      filter.key = {};
      filter.restrictedValue = {}
    }

    return {
      ElasticFactory: ElasticFactory,

      indexall: indexall,
      createIndex: createIndex,
      deleteIndex: deleteIndex,
      createType: createType,
      createTypeByJsonData: createTypeByJsonData,
      createCompleteType: createCompleteType,
      updateTypebyJson: updateTypebyJson,
      updateType: updateType,
      addDocument: addDocument,
      addMultipleDocuments: addMultipleDocuments,
      updateDocument: updateDocument,
      updatemultipleDocument: updatemultipleDocument,
      getDocument: getDocument,
      getMultipleDocument: getMultipleDocument,
      deleteDocument: deleteDocument,
      deleteMultipleDocument: deleteMultipleDocument,
      deleteAllDocument: deleteAllDocument,
      searchInType: searchInType,
      searchInTypeAnc: searchInTypeAnc,
      searchInTypes: searchInTypes,
      searchInIndex: searchInIndex,
      advancedSearch: advancedSearch,
      relationalSearch: relationalSearch,
      saveConfig: saveConfig,
      getConfig: getConfig,
      saveRelationalConfig: saveRelationalConfig,
      getRelationalConfig: getRelationalConfig,
      deleteSavedFile: deleteSavedFile,
      getProgression: getProgression,
      getprogressiondetaillee: getprogressiondetaillee,
      search: search,
      elastic: elastic,
      getSuggestions: getSuggestions,
      getSuggestionsFromTypes: getSuggestionsFromTypes,
      getSuggestionsFromType: getSuggestionsFromType,
      cleanFieldValue: cleanFieldValue,
    };
  };
  ElasticFactory.$inject = ['$http', '$q'];
  return ElasticFactory;
});


define('modules/query/services/ElasticReplacementFactory',[],function() {
  /**
   * factory contenant des functions n'utilisant pas elastic. on rempace des appels élastic par des appels base de données.
   */
  var ElasticReplacementFactory = function($http, $q) {

    const queryOnJointureDossierAndControle = (whereClause, sendData) => {
      if (typeof whereClause != 'string') {
        whereClause = '';
      }
      return $http.post(
        '/services/{portalid}/elasticReplacement/queryOnJointureDossierAndControle?f=json' +
        '&whereClause=' + whereClause, 
        sendData
        ).then( (res) => {
          let def = $q.defer();
          
          res.data.crs = {"type": "name","properties": {"name": "EPSG:3857"}};
          res.data.type = "FeatureCollection";
          // result.fti = TODO kis-2711
          
          def.resolve(res);
          return def.promise;
        });
    }

    const facturationDatabaseQuery = (relations) => {
      // change date format to fit elasticRule
      // for (let attribute of elasticQuery.relations) {
      //   for (let clause of attribute.filters) {
      //     if (clause.choice === 'rule' && clause.type == 'java.sql.Timestamp') {
      //       clause.newValueUtil = {[clause.name]: new Date(clause.value)};
      //     }
      //   }
      // }
      let whereClause = getWhereClauseForRelations(relations);

      return queryOnJointureDossierAndControle(whereClause, relations[0]);
    }

    const getStringForClause = (clauseData) => {
      /// clauseData.operand contains the operator, not the operand !
      let stringWhereClause = null;
      if (clauseData.name && clauseData.operand) {
        let correctValue = undefined;
        if (clauseData.operand != 'exists' &&
          clauseData.operand != 'notExists') {
          //Handle specific cases and correct format of the value
          if (clauseData.operand == 'last' ||
            clauseData.operand == 'next') {
            //for some reason, in this specific case, the value is stored in .newvalue
            correctValue = clauseData.newvalue;
          } else if (clauseData.attr && clauseData.attr.restrictions && clauseData.attr.restrictions[0] &&
            clauseData.operand === "equals") {
            //when the field has a restriction (table, domain, user, ...) value is stored in .restrictedValue
            if (clauseData.restrictedValue != undefined) {
              correctValue = clauseData.restrictedValue[clauseData.name];
            }
          } else if (clauseData.name.startsWith('extraFormFields.') && clauseData.restrictedValue != undefined) {
            correctValue = clauseData.restrictedValue[clauseData.name];
          } else if (clauseData.type == 'java.util.Date') {
            if (typeof clauseData.value == "string") {
              //sometimes it is a string, no format needed
              correctValue = clauseData.value;
            } else {
            // format like that: 2012-03-31T22:00:00.000Z
              if (clauseData.value != undefined) {
                correctValue = clauseData.value.toISOString();
              }
            }
          } else if (clauseData.type == 'java.sql.Timestamp' && typeof clauseData.value === 'string') {
              correctValue = "'" + clauseData.value + "'";
          } else if ((clauseData.operand == 'equals') && (clauseData.type == 'java.lang.Boolean')) {
            //for some reasons, in this specific case, the value is stored in weird location
            if (clauseData.newValueUtil != undefined) {
              correctValue = clauseData.newValueUtil[clauseData.name];
            }
          } else {
            // ignore filter if value is empty string
            if (clauseData.value !== "" && typeof clauseData.value !== 'object') {
              correctValue = clauseData.value;
            }
          }
        }

        // ignore filter if correctValue is undefined
        //in case 'exists' and 'notExists' there is no value
        if (correctValue != undefined ||
          clauseData.operand == 'exists' ||
          clauseData.operand == 'notExists') {

          if (clauseData.guid === "extrafactu_controle") {
            // get data in 'document_json' field
            if (clauseData.name.startsWith('extraFormFields.')) {
              // au 11/01/23 seul Thierache du centre utilise un extraField sans ces critères avancées de factu
              stringWhereClause = "document_json::jsonb" + 
                " -> 'extraFormFields' ->> '" + clauseData.name.split('.')[1] + "'";
            } else {
              switch (clauseData.name) {
                case 'agent': stringWhereClause = 'conformite.agent';
                  break;
                case 'avis_agent': stringWhereClause = 'conformite.valeur_agent';
                  break;
                // --- ANC ----
                case 'avis': stringWhereClause = "document_json::jsonb" + 
                    " -> 'conformite' ->> 'valeur'";
                  break;
                case 'type': stringWhereClause = "document_json::jsonb" + 
                    " -> 'service_controle' ->> 'type'";
                  break;
                case 'filiere_sup_20_eh': stringWhereClause = "document_json::jsonb" + 
                    " -> 'service_controle' ->> 'type'";
                  break;

                // --- BAC ---
                case 'info_generales.type_controle':
                  stringWhereClause = "document_json::jsonb" + 
                    " -> 'info_generales' ->> 'type_controle'";
                  // on envlève les 0 au debut de la string car les typecontroles sont stocker sous forme de int en json
                  // --> 1 = '01' NOT ok
                  // --> 1 = '1' ok
                  if (correctValue.startsWith('0')) {
                    while (correctValue.startsWith('0')) correctValue = correctValue.substring(1);
                  }
                  break;
                case 'info_generales.montant_pfac': stringWhereClause = "document_json::jsonb" + 
                    " -> 'info_generales' ->> 'montant_pfac'";
                  break;
                default: stringWhereClause = undefined;
              }
            }
          } else if (clauseData.guid === "extrafactu_dossier") {
            // get data from a normal database field
            stringWhereClause = 'public.kis_anc_dossier.' + clauseData.name;
          } else {
            // get data from a normal database field
            stringWhereClause = clauseData.name;
          }



          switch (clauseData.operand) {
            case 'startWith':
              stringWhereClause += " LIKE '" + correctValue + "%'";
              break;
            case 'endWith':
              stringWhereClause += " LIKE '%" + correctValue + "'";
              break;
            case 'regexp':
              stringWhereClause += " LIKE '%" + correctValue + "%'";
              break;
            case 'equals':
              if ((clauseData.type == 'java.lang.String') || (clauseData.type == 'java.lang.Boolean')) {
                stringWhereClause += " = '" + correctValue + "'";
              } else {
                stringWhereClause += ' = ' + correctValue;
              }
              break;
            case 'notEquals':
              stringWhereClause += " <> '" + correctValue + "'";
              break;
            case 'include':
              // is included in a list of value
              stringWhereClause += " IN ('" + correctValue.replaceAll(',', "','") + "')";
              break;
            case 'gt':
              // '>' greater than
              stringWhereClause += ' > ' + correctValue;
              break;
            case 'gte':
              // '>=' greater than or equals
              stringWhereClause += ' >= ' + correctValue;
              break;
            case 'lt':
              // '<'
              stringWhereClause += ' < ' + correctValue;
              break;
            case 'lte':
              // '<='
              stringWhereClause += ' <= ' + correctValue;
              break;
            case 'exists':
              if (clauseData.type == 'java.lang.String') {
                stringWhereClause = stringWhereClause + ' IS NOT NULL AND ' + stringWhereClause + " <> ''";
              } else {
                stringWhereClause += ' IS NOT NULL';
              }
              break;
            case 'notExists':
              if (clauseData.type == 'java.lang.String') {
                stringWhereClause = '(' + stringWhereClause + ' IS NULL OR ' + stringWhereClause + " = '')";
              } else {
                stringWhereClause += ' IS NULL';
              }
              break;
            case 'last':
              stringWhereClause +=
                " BETWEEN datetime('now', '-" +
                correctValue +
                " days') AND datetime('now', 'localtime')";
              break;
            case 'next':
              stringWhereClause +=
                " BETWEEN datetime('now', '+" +
                correctValue +
                " days') AND datetime('now', 'localtime')";
              break;
            default:
              stringWhereClause = null;
              break;
          }
        } else {
          stringWhereClause = null;
        }
      } else {
        stringWhereClause = null;
      }
      if ((stringWhereClause == null) && (clauseData.name != undefined)) {
        console.log('intervention simple: ignoring "WHERE" clause -> ' + clauseData.name);
      }
      return stringWhereClause;
    }

    /**
     * 
     * @param {*} relations elastic filter relations
     * @returns 
     */
    const getWhereClauseForRelations = (relations) => {
      let globalWhereClause = '';

      for (let attribute of relations) {
        for (let clause of attribute.filters) {
          //add where clause
          const singleWhereClause = getStringForClause(clause);
          if(singleWhereClause != undefined) {
            if (globalWhereClause != "") {
              globalWhereClause += " AND ";
            }
            globalWhereClause += singleWhereClause;
          }
        }
        // Les critères de facturation avancée liés sont stocké à part:
        // Pour l'ANC c'est les ('extrafactu_dossier') qui sont stockés dans 'attribute.filters[0].filters'
        if (Array.isArray(attribute.filters) && attribute.filters.length > 0 && attribute.filters[0].filters) {
          for (let clause of attribute.filters[0].filters) {
            if (clause.guid === "extrafactu_dossier") {
              //add where clause
              const singleWhereClause = getStringForClause(clause);
              if(singleWhereClause != undefined) {
                if (globalWhereClause != "") {
                  globalWhereClause += " AND ";
                }
                globalWhereClause += singleWhereClause;
              }
            }
          }
        }
        // Pour BAC c'est les ('extrafactu_controle') qui sont stockés dans 'attribute.filters[1].filters'
        if (Array.isArray(attribute.filters) && attribute.filters.length > 1 && attribute.filters[1].filters) {
          for (let clause of attribute.filters[1].filters) {
            if (clause.guid === "extrafactu_controle") {
              //add where clause
              const singleWhereClause = getStringForClause(clause);
              if(singleWhereClause != undefined) {
                if (globalWhereClause != "") {
                  globalWhereClause += " AND ";
                }
                globalWhereClause += singleWhereClause;
              }
            }
          }
        }
      }

      return globalWhereClause;
    }

    return {
      queryOnJointureDossierAndControle: queryOnJointureDossierAndControle,
      facturationDatabaseQuery: facturationDatabaseQuery,
      getWhereClauseForRelations: getWhereClauseForRelations,
    };
  };
  ElasticReplacementFactory.$inject = ['$http', '$q'];
  return ElasticReplacementFactory;
});


define('modules/query/services/ChartLocaliseFactory',[],function() {
  var ChartLocaliseFactory = function($http) {
    var ChartLocaliseFactory = {};
    /**
     * Class : ChartLocaliseFactory
     * Factory WebServices
     */

    /**
     * Function: datastats
     */
    function datastats(senddata) {
      return $http.post(
        '/services/{portalid}/chartlocalise/data?f=json',
        senddata
      );
    }

    /**
     * Function: dataStyle
     */
    function dataStyle(senddata) {
      return $http.post(
        '/services/{portalid}/chartlocalise/dataStyle?f=json',
        senddata
      );
    }
    /**
     * Function: dataStylePieChart
     */
    function dataStylePieChart(senddata) {
      return $http.post(
        '/services/{portalid}/chartlocalise/dataStylePieChart?f=json',
        senddata
      );
    }
    return {
      ChartLocaliseFactory: ChartLocaliseFactory,
      datastats: datastats,
      dataStyle: dataStyle,
      dataStylePieChart: dataStylePieChart,
    };
  };
  ChartLocaliseFactory.$inject = ['$http'];
  return ChartLocaliseFactory;
});



define('modules/query/mod',[
  'angular',
  'modules/query/services/QueryFactory',
  'modules/query/services/ChartsFactory',
  'modules/query/services/LongitudinalProfileFactory',
  'modules/query/services/ElasticFactory',
  'modules/query/services/ElasticReplacementFactory',
  'modules/query/services/ChartLocaliseFactory',
], function(
  angular,
  QueryFactory,
  ChartsFactory,
  LongitudinalProfileFactory,
  ElasticFactory,
  ElasticReplacementFactory,
  ChartLocaliseFactory
) {
  // Module
  var mod = angular.module('query', []);

  // Services
  mod.factory('QueryFactory', QueryFactory);
  mod.factory('ChartsFactory', ChartsFactory);
  mod.factory('LongitudinalProfileFactory', LongitudinalProfileFactory);
  mod.factory('ElasticFactory', ElasticFactory);
  mod.factory('ElasticReplacementFactory', ElasticReplacementFactory);
  mod.factory('ChartLocaliseFactory', ChartLocaliseFactory);
  return mod;
});



define('modules/majic/services/MajicFactory',[],function() {
  var magicFactory = function($http, gaUrlUtils) {
    var magicFactory = {};

    /**
     * Function: getinfo
     * @param {String} id1 nom de la table
     * @param {String} id2 nom du champ de la table
     * @param {String} id3 chaine recherchée
     */
    function getinfo(id1, id2, id3) {
      return $http.get(
        '/services/{portalid}/majic/getInfo?f=json' +
          '&id1=' +
          id1 +
          '&id2=' +
          id2 +
          '&id3=' +
          id3
      );
    }

    /**
     * Function: getparambyid (getParcelle)
     * @param {String} id1 valeur de 'idcommune'
     * @param {String} id2 valeur de 'idparcelle'
     */
    function getparambyid(id1, id2) {
      return $http.get(
        '/services/{portalid}/majic/getParcelle?f=json' +
          '&id1=' +
          id1 +
          '&id2=' +
          id2
      );
    }
    /**
     * Function: getpropbyid
     * @param {String} id1 valeur de 'idcommune'
     * @param {String} id2 valeur de 'idcompte'
     * @param typeNom
     */
    function getpropbyid(id1, id2, typeNom) {
      id1 = gaUrlUtils.encodeUriQuery(id1 || '');
      id2 = gaUrlUtils.encodeUriQuery(id2 || '');
      return $http.get(
        '/services/{portalid}/majic/getProprietaire?f=json' +
          '&id1=' +
          id1 +
          '&id2=' +
          id2 +
          '&typenom=' +
          typeNom
      );
    }
    /**
     * Function: getsubdibyid
     * @param {String} id1 valeur de 'idcommune'
     * @param {String} id2 valeur de 'idparcelle'
     */
    function getsubdibyid(id1, id2) {
      return $http.get(
        '/services/{portalid}/majic/getSubdivision?f=json' +
          '&id1=' +
          id1 +
          '&id2=' +
          id2
      );
    }
    /**
     * Function: getexobyid
     * @param {String} id1 valeur de 'idcommune'
     * @param {String} id2 valeur de 'idparcelle'
     */
    function getexobyid(id1, id2) {
      return $http.get(
        '/services/{portalid}/majic/getExoneration?f=json' +
          '&id1=' +
          id1 +
          '&id2=' +
          id2
      );
    }
    /**
     * Function: getbatibyid
     * @param {String} id1 valeur de 'idcommune'
     * @param {String} id2 valeur de 'idparcelle'
     * @param {String} typeLocal 'locauxPrincipaux' ou 'locauxDesLots'
     */
    function getbatibyid(id1, id2, typeLocal) {
      return $http.get(
        '/services/{portalid}/majic/getBatiment?f=json' +
          '&id1=' +
          id1 +
          '&id2=' +
          id2 +
          '&typelocal=' +
          typeLocal
      );
    }
    /**
     * Function: getpevbyid
     * @param {String} id1 valeur de 'idcommune'
     * @param {String} id2 valeur de 'idparcelle'
     */
    function getpevbyid(id1, id2) {
      return $http.get(
        '/services/{portalid}/majic/getPEV?f=json' +
          '&id1=' +
          id1 +
          '&id2=' +
          id2
      );
    }
    /**
     * Function: gethabbyid
     * @param {String} id1 valeur de 'idcommune'
     * @param {String} id2 valeur de 'idparcelle'
     */
    function gethabbyid(id1, id2) {
      return $http.get(
        '/services/{portalid}/majic/getHabitat?f=json' +
          '&id1=' +
          id1 +
          '&id2=' +
          id2
      );
    }
    /**
     * Function: getdepbyid
     * @param {String} id1 valeur de 'idcommune'
     * @param {String} id2 valeur de 'idparcelle'
     */
    function getdepbyid(id1, id2) {
      return $http.get(
        '/services/{portalid}/majic/getDependance?f=json' +
          '&id1=' +
          id1 +
          '&id2=' +
          id2
      );
    }
    /**
     * Function: getexolocbyid
     * @param {String} id1 valeur de 'idcommune'
     * @param {String} id2 valeur de 'idparcelle'
     */
    function getexolocbyid(id1, id2) {
      return $http.get(
        '/services/{portalid}/majic/getExoLoc?f=json' +
          '&id1=' +
          id1 +
          '&id2=' +
          id2
      );
    }
    /**
     * Function: getparcellaire
     * @param {String} id1 nom du champ de la table nb_10.
     * @param {String} id2 une clause where
     */
    function getparcellaire(id1, id2) {
      return $http.get(
        '/services/{portalid}/majic/chargeCommune?f=json' +
          '&id1=' +
          id1 +
          '&id2=' +
          id2
      );
    }
    /**
     * Function: getville
     * Liste des communes dans la base majic.
     */
    function getville() {
      return $http.get('/services/{portalid}/majic/chargeVille?f=json');
    }

    /**
     * Retrouve la liste des Communes (idcommune et libelle commune)
     */
    function getcommunes(condition) {
      return $http.get(
        '/services/{portalid}/majic/getCommunes?f=json' + '&id1=' + condition
      );
    }

    /**
     * Function: getlisteparcelle
     * @param {String} id1 une clause where
     */
    function getlisteparcelle(id1) {
      return $http.get(
        '/services/{portalid}/majic/chargeListeParcelle?f=json' + '&id1=' + id1
      );
    }
    /**
     * Function: getlisteproprio
     * @param {String} id1 une clause where sur la table 'prop'.
     * @param {String} id1 une clause where sur la table 'nb_10'
     * @param id2
     */
    function getlisteproprio(id1, id2) {
      const encodedId1 = gaUrlUtils.encodeUriQuery(id1);
      const encodedId2 = gaUrlUtils.encodeUriQuery(id2);
      return $http.get(
        '/services/{portalid}/majic/chargeListeProprio?f=json' +
          '&id1=' +
          encodedId1 +
          '&id2=' +
          encodedId2
      );
    }
    /**
     * Function: getlisteadresse
     * @param {String} id1 une clause where sur la table 'nb_10'.
     * @param {String} id2 une clause where sur la table 'f_commune'
     * @param {String} id3 une clause where sur la table 'f_voie'.
     */
    function getlisteadresse(id1, id2, id3) {
      const encodedId1 = gaUrlUtils.encodeUriQuery(id1);
      const encodedId2 = gaUrlUtils.encodeUriQuery(id2);
      const encodedId3 = gaUrlUtils.encodeUriQuery(id3);
      return $http.get(
        '/services/{portalid}/majic/chargeListeAdresse?f=json' +
          '&id1=' +
          encodedId1 +
          '&id2=' +
          encodedId2 +
          '&id3=' +
          encodedId3
      );
    }

    /**
     * Function: getlisteadresse
     * @param {String} idcommune code insee de la commune de la parcelle.
     * @param {String} idparcelle identifiant de la parcelle code insee
     *                  ancienne commune + section = no parcelles
     */
    function getcoproprietaires(idcommune, idparcelle) {
      return $http.get(
        '/services/{portalid}/majic/getPropietairesParLots?f=json' +
          '&id1=' +
          idcommune +
          '&id2=' +
          idparcelle
      );
    }
    /**
     * Function: getproprietairesCsv = get list proprietaires for import CSV
     *
     * @param {*} idcommune
     * @param {*} idparcelle
     * @param {*} idcompte
     * @param coprops
     */
    function getproprietairesCsv(idcommune, idparcelle, idcompte, coprops) {
      if (coprops !== undefined && coprops.length !== 0) {
        return getcoproprietaires(idcommune, idparcelle);
      } else {
        return getpropbyid(idcommune, idcompte, 'nom_d_usage');
      }
    }

    /**
     * Récupère les noms de rapports dans un objet config
     * Méthode partagée par MajicDockWidget et MajicConsult
     * @param config configuration du widget majic
     */
    function getReportNames(config){
      const reportsMap = new Map();
      // Nom des rapports Jasper
      let reportsConfig = config['reports'];
      if (reportsConfig &&
          reportsConfig.hasOwnProperty('MatCad') &&
          String(reportsConfig['MatCad']).length > 0
      ) {
        reportsMap.set('MatCadReportName', reportsConfig.MatCad);
      }
      if (reportsConfig &&
          reportsConfig.hasOwnProperty('RelProp') &&
          String(reportsConfig['RelProp']).length > 0
      ) {
        reportsMap.set('RelPropReportName', reportsConfig.RelProp);
      }
      return reportsMap;
    }

    /**
     * Récupère une map des communes MAJIC
     * @return {map} des communes MAJIC (code insee IDCOMMUNE => nom commune LIBCOM)
     */
    const getVilleInsee = () => {
      return $http.get(
          '/services/{portalid}/majic/getVilleInsee?f=json'
      );
    };

    let popupPanel;
    let popupCollapse;
    /**
     * Définie les dimensions de la popup à l'ouverture de celle-ci
     * @param viewMode string correspondant à l'onglet de la popup actuellement affiché ('consult' au départ)
     * @param fromTool est true si la popup est ouverte depuis le i rouge
     */
    const setInitPopupWidthAndMinWidth = (viewMode, fromTool=false) => {
      if (fromTool) {
        const majicConsult = document.getElementById('majicController');
        popupPanel = majicConsult.closest('.popupPanel');
      } else {
        if (!popupPanel) {
          const majicConsult = document.getElementById('majicController');
          if (majicConsult) {
            popupPanel = majicConsult.closest('.popup > .panel');
          }
        }
      }
      if (popupPanel && !popupCollapse){
        popupCollapse = popupPanel.getElementsByClassName('.panel-collapse')[0];
      }
      if (popupPanel) {
        if (viewMode && viewMode === 'search') {
          popupPanel.style.width = '990px';
          popupPanel.style.minWidth = '450px';
        } else{
          popupPanel.style.width = '820px';
          popupPanel.style.minWidth = '450px';
        }
      }
      if (popupCollapse) {
        popupCollapse.style.overflowY = 'auto';
      }
    };

    /**
     * A chaque mise à jour du dom,
     * renvoie true si la largeur de la popup est inférieure à 780px
     * ajoute des modifications de mise en page spécifique suivant l'onglet
     * et la largeur de la popup
     * @param viewMode search/consult...
     * @param fromTool est true si la popup est ouverte depuis le i rouge
     * @return {boolean} est true si la largeur de la popup est inférieure à 780px
     */
    const adaptPopupSizeByViewMode = (viewMode, fromTool=false) => {
      let isStretched = false;
      const majicConsult = document.getElementById('majicController');
      if (majicConsult) {
        // popupPanel est la div redimensionnable
        const popupPanel = fromTool ? majicConsult.closest('.popupPanel')
            : majicConsult.closest('.popup > .panel');
        if (popupPanel) {
          for (const child of popupPanel.children) {
            if (child.className === 'panel-collapse') {
              child.style.overflowY = 'auto';
            }
          }
          switch (viewMode) {
            case 'localconsult':
              break;
            case 'search':
              break;
            case 'baticonsult':
              break;
            case 'consult':
            default:
              const parcOnMapCbSpan = document.getElementById('parcOnMapCbSpan');
              if (popupPanel.offsetWidth < 780) {
                if (parcOnMapCbSpan){
                  parcOnMapCbSpan.textContent = 'Parcelle au plan';
                }
                isStretched = true
              } else if (parcOnMapCbSpan) {
                parcOnMapCbSpan.textContent = 'Parcelle figure au plan';
              }
              break;
          }
        }
      }
      return isStretched;
    };

    /**
     * Vérifie si le portail contient une source de données nommée "majic" uniquement (cf. KIS-2474)
     * @return {boolean} true si une source de données MAJIC existe
     */
    const hasMajicDataStore = () => {
      // Si un datastoreInfo nommé "majic" existe
      return $http.get(
          '/services/{portalid}/majic/hasMajicDataStore?f=json'
      );
    };
    /**
     * Vérifie si la source de données "majic" du portail contient la table f_commune (cf. KIS-2474)
     * @return {boolean} true si la table existe dans la source de données ainsi nommée.
     */
    const hasTableCommuneInMajicDataStore = () => {
      // Teste l'existence de la table f_commune dans la source de données nommée "majic"
      return $http.get(
          '/services/{portalid}/majic/hasTableCommuneInMajicDataStore?f=json'
      );
    };

    /**
     * Vérifie si le portail contient une source de données MAJIC.
     * Le test est fait sur l’existence de la table B_10
     * @return {boolean} true si un datastore existe contenant une table B_10
     */
    const hasTableB10InMajicDataStore = () => {
      return $http.get(
          '/services/{portalid}/majic/hasTableB10InMajicDataStore?f=json'
      );
    }

    return {
      magicFactory: magicFactory,
      getinfo: getinfo,
      getparambyid: getparambyid,
      getpropbyid: getpropbyid,
      getsubdibyid: getsubdibyid,
      getexobyid: getexobyid,
      getbatibyid: getbatibyid,
      getpevbyid: getpevbyid,
      gethabbyid: gethabbyid,
      getdepbyid: getdepbyid,
      getexolocbyid: getexolocbyid,
      getparcellaire: getparcellaire,
      getville: getville,
      getcommunes: getcommunes,
      getlisteparcelle: getlisteparcelle,
      getlisteproprio: getlisteproprio,
      getlisteadresse: getlisteadresse,
      getcoproprietaires: getcoproprietaires,
      getproprietairesCsv: getproprietairesCsv,
      getReportNames: getReportNames,
      setInitPopupWidthAndMinWidth: setInitPopupWidthAndMinWidth,
      adaptPopupSizeByViewMode: adaptPopupSizeByViewMode,
      getVilleInsee: getVilleInsee,
      hasMajicDataStore: hasMajicDataStore,
      hasTableCommuneInMajicDataStore: hasTableCommuneInMajicDataStore,
      hasTableB10InMajicDataStore: hasTableB10InMajicDataStore
    };
  };

  magicFactory.$inject = ['$http', 'gaUrlUtils'];

  return magicFactory;
});



define('modules/majic/mod',['angular', 'modules/majic/services/MajicFactory'], function(
  angular,
  MajicFactory
) {
  // Module
  var mod = angular.module('majic', []);

  // Services
  mod.factory('MajicFactory', MajicFactory);

  return mod;
});


define('modules/config/services/ConfigFactory',[],function () {
  var ConfigFactory = function ($http, $location, $q) {
    var ConfigFactory = {};
    /**
     * Class : ConfigFactory
     * Factory WebServices
     */
    var resources = {configs: []};

    let portalid = angular.module('gcMain').portalid;
    if (portalid === undefined || portalid === '' || portalid == null) {
      portalid = localStorage.getItem('portal');
    }
    const appName = localStorage.getItem('app');

    /**
     * Function: add
     */
    function add(senddata, type, name, appname) {
      var url = appname
        ? '/services/{portalid}/config/' +
        appname +
        '/add?f=json&type=' +
        type +
        '&name=' +
        name
        : '/services/{portalid}/config/{appname}/add?f=json' +
        '&type=' +
        type +
        '&name=' +
        name;
      return $http.post(url, senddata);
    }

    /**
     * Permet d'ajouter un fichier de tout type en configuration
     * @param senddata
     * @param type
     * @param name
     * @param appname
     */
    const addFile = (senddata, type, name, fileName, oldFileName, appname) => {
      return $http.post(
          appname ?
              '/services/{portalid}/config/' + appname
              + '/addFile?f=json&type=' + type
              + '&name=' + name
              + '&fileName=' + fileName
              + '&oldFileName=' + oldFileName
          : '/services/{portalid}/config/{appname}/addFile?f=json'
              + '&type=' + type
              + '&name=' + name
              + '&fileName=' + fileName
              + '&oldFileName=' + oldFileName,
      senddata);
    };

    /**
     * Permet de télécharger un fichier de tout type en configuration
     * @param senddata
     * @param type
     * @param name
     * @param appname
     */
    const getFileUrl = (type, name, fileName, appname) => {
      return    appname ?
              '/services/' + portalid + '/config/' + appname
              + '/getFile?f=json&type=' + type
              + '&name=' + name
              + '&fileName=' + fileName
              : '/services/' + portalid + '/config/' + appName + '/getFile?f=json'
              + '&type=' + type
              + '&name=' + name
              + '&fileName=' + fileName
    };

    /**
     * Function: remove
     */
    function remove(type, name, appname) {
      var url = appname
        ? '/services/{portalid}/config/' +
        appname +
        '/remove?f=json' +
        '&type=' +
        type +
        '&name=' +
        name
        : '/services/{portalid}/config/{appname}/remove?f=json' +
        '&type=' +
        type +
        '&name=' +
        name;
      return $http.get(url);
    }

    const getGetUpdateURL = (type, name, appname, httpVerb) => {
      if (typeof ancAppAndroid !== 'undefined') {
        return $q.when(['detail', 'simple']);
      } else {
        if (appname == undefined) {
          if ($location.search().app) {
            appname = $location.search().app;
          } else {
            appname = angular.module('gcMain').app;
          }
        }
        return appname
          ? '/services/{portalid}/config/' +
          appname +
          '/' +
          httpVerb +
          '?f=json' +
          '&type=' +
          type +
          '&name=' +
          name
          : '/services/{portalid}/config/{appname}/get?f=json' +
          '&type=' +
          type +
          '&name=' +
          name;
      }
    };

    /**
     * get
     * @param type
     * @param name
     * @param appname - optional
     * @returns {HttpPromise}
     */
    const get = (type, name, appname) => {
      const url = getGetUpdateURL(type, name, appname, 'get');
      return $http.get(url);
    };

    /**
     * put
     * @param type
     * @param name
     * @param appname - optional
     * @returns {HttpPromise}
     */
    const updateConfigWithCreateCommune = (data, type, name, appname,
                                           isancapp) => {
      let url = getGetUpdateURL(type, name, appname, 'put');
      url = url + '&isancapp=' + isancapp;
      return $http.put(url, data);
    };

    /**
     * checkDocumentsForConfig -  calls the webservice which checks if the documents
     *                            found in the configuration exist on the server
     * @param controleConfig - the controle configuration object
     * @returns {HttpPromise} - the response contains the sent object with the
     *                          information about the files existence added to
     *                          the documents
     */
    function checkDocumentsForConfig(controleConfig) {
      let url = '/services/{portalid}/config/{appname}/checkDocumentsForConfig';
      return $http.post(url, controleConfig);
    }

    /**
     * checkTemplates - calls the webservice which checks if the documents
     *                  attached to the templates exist on the server
     * @param templates - the templates list
     * @returns {HttpPromise} - the response contains the sent list with the
     *                          information about the files existence added to
     *                          the templates
     */
    function checkTemplates(templates) {
      var url = '/services/{portalid}/config/{appname}/checkTemplates';
      return $http.post(url, templates);
    }

    /**
     * getAllFormCfg
     * @param type
     * @param appname - optional
     * @returns {HttpPromise}
     */
    function getAllFormCfg(type, appname) {
      if (typeof cfgandroid !== 'undefined') {
        var defer = $q.defer();
        var response = {
          data: undefined,
        };
        var value;
        var val = cfgandroid.getAllFormCfg();
        try {
          value = JSON.parse(val);
        } catch (e) {
          e.stack;
          value = val;
        }
        response.data = value;
        defer.resolve(response);
        return defer.promise;
      } else {
        var url = appname
          ? '/services/{portalid}/config/' +
          appname +
          '/getAllFormCfg?f=json' +
          '&type=' +
          type
          : '/services/{portalid}/config/{appname}/getAllFormCfg?f=json'
          +
          '&type=' +
          type;
        return $http.get(url);
      }
    }

    /**
     * gettype
     * @param appname - optional
     * @returns {HttpPromise}
     */
    function gettype(appname) {
      var url = appname
        ? '/services/{portalid}/config/' + appname + '/gettype'
        : '/services/{portalid}/config/{appname}/gettype';
      return $http.get(url);
    }

    /**
     * Function: gettype
     * @param type
     * @param appname - optional
     * @returns {HttpPromise}
     */
    function getbytype(type, appname) {
      var url = appname
        ? '/services/{portalid}/config/' + appname + '/getbytype/?type='
        + type
        : '/services/{portalid}/config/{appname}/getbytype/?type='
        + type;

      return $http.get(url);
    }

    /**
     * Function: update
     */
    function update(senddata, type, name) {
      var promise = $http.post(
        '/services/{portalid}/config/{appname}/update?f=json' +
        '&type=' +
        type +
        '&name=' +
        name,
        senddata
      );
      promise.then(function (res) {
        resources.configs.push({
          type: type,
          name: name,
          config: res.data,
        });
      });
      return promise;
    }

    /**
     * Function: getFormBuilderList
     */
    function getFormBuilderList() {
      return $http.get(
        '/services/{portalid}/config/getFormBuilderList?f=json');
    }

    /**
     * Function: reprojectExtend
     */
    function reprojectExtend(srid, type, name, appname) {
      var url = appname
        ? '/services/{portalid}/config/' +
        appname +
        '/reprojectExtend?f=json&type=' +
        type +
        '&srid=' +
        srid +
        '&name=' +
        name
        : '/services/{portalid}/config/{appname}/reprojectExtend?f=json'
        +
        '&type=' +
        type +
        '&srid=' +
        srid +
        '&name=' +
        name;
      return $http.get(url);
    }

    /**
     * Récupère les liens wiki personnalisés définis pour les widgets d'une l'application
     * @returns {Promise} promise contenant un objet dont les propriétés ont pour clé le nom du widget et l'URL du wiki en valeur
     * L'objet contient autant de propriétés que le nombre de liens wiki personnalisés existant
     */
    const getWikiConfig = () => {
      return $http.get('/services/{portalid}/config/{appname}/getWiki?f=json');
    };

    return {
      ConfigFactory: ConfigFactory,
      add: add,
      addFile: addFile,
      getFileUrl: getFileUrl,
      remove: remove,
      get: get,
      checkDocumentsForConfig: checkDocumentsForConfig,
      checkTemplates: checkTemplates,
      getAllFormCfg: getAllFormCfg,
      gettype: gettype,
      getbytype: getbytype,
      update: update,
      getFormBuilderList: getFormBuilderList,
      reprojectExtend: reprojectExtend,
      updateConfigWithCreateCommune: updateConfigWithCreateCommune,
      getWikiConfig: getWikiConfig
    };
  };

  ConfigFactory.$inject = ['$http', '$location', '$q'];
  return ConfigFactory;
});


/**
 * @ngdoc overview
 * @name modules.configuration
 * @description
 * configuration module
 */
define('modules/config/mod',['angular', 'modules/config/services/ConfigFactory'], function(
  angular,
  ConfigFactory
) {
  // Module
  var mod = angular.module('config', []);

  // Services
  mod.factory('ConfigFactory', ConfigFactory);

  return mod;
});


define('modules/decoupadmin/services/DecoupAdminFactory',[],function() {
  /**
   * Class : DecoupAdminFactory
   * Factory WebServices
   * https://api.gouv.fr/documentation/api-geo
   * base URL: https://
   */
  class DecoupAdminFactory {
    constructor($http) {
      /**
       * Recherche de departements
       * {nom,code,codeRegion}
       */
      function getDepartements() {
        const url = 'https://geo.api.gouv.fr/departements';
        return $http.get(url);
      }
      /**
       * Renvoi les communes d'un département
       * @param codeDepartement: code du département avec le 0 (ex. 01)
       * {nom,code,codeDepartement,codeRegion,codesPostaux,population}
       */
      function getCommunesByDepartement(codeDept) {
        const url =
          'https://geo.api.gouv.fr/departements/' + codeDept + '/communes';
        return $http.get(url);
      }
      return {
        getDepartements: getDepartements,
        getCommunesByDepartement: getCommunesByDepartement,
      };
    }
  }

  DecoupAdminFactory.$inject = ['$http'];
  return DecoupAdminFactory;
});


/**
 * @ngdoc overview
 * @name modules.export
 * @description
 * decoupadmin module
 */
define('modules/decoupadmin/mod',['angular', 'modules/decoupadmin/services/DecoupAdminFactory'], function(
  angular,
  DecoupAdminFactory
) {
  // Module
  var mod = angular.module('decoupadmin', []);

  // Services
  mod.factory('DecoupAdminFactory', DecoupAdminFactory);

  return mod;
});


define('modules/edit/services/AdvancedEditionFactory',['toastr','toastr','toastr','toastr','toastr'],function() {
  var AdvancedEditionFactory = function(
    $http,
    $filter,
    $translate,
    FeatureTypeFactory
  ) {
    var AdvancedEditionFactory = {};

    var storeNameToLoadIds = null;

    var storedLotOfIds = [];

    var lastUsedId = -1;

    var indexUseLotOfIds = 0;

    var handlingIdsNotImplemented = false;

    var idsInUse = [];

    const ERROR_RESPONSE = 'ERROR_RESPONSE';
    const WARNING_RESPONSE = 'WARNING_RESPONSE';
    const INFO_RESPONSE = 'INFO_RESPONSE';

    const CAN_PROCESS_EDIT = { canProcessEdit: true };
    const CANNOT_PROCESS_EDIT = { canProcessEdit: false };

    function sendResponse(responseMessage, typeResponse, saveRelated, promise) {
      if (saveRelated == null) saveRelated = false;
      if (typeResponse == null) typeResponse = INFO_RESPONSE;
      else if (
        ERROR_RESPONSE != typeResponse &&
        WARNING_RESPONSE != typeResponse &&
        INFO_RESPONSE != typeResponse
      )
        typeResponse = INFO_RESPONSE;
      return {
        message: responseMessage,
        type: typeResponse,
        saveRelated: saveRelated,
        promise: promise,
        isEditionResponse: true,
      };
    }

    function logResponse(response) {
      if (ERROR_RESPONSE == response.type)
        require('toastr').error(response.message);
      else if (WARNING_RESPONSE == response.type)
        require('toastr').warning(response.message);
      else if (INFO_RESPONSE == response.type)
        require('toastr').info(response.message);
    }

    function isEditionResponse(response) {
      return response.isEditionResponse;
    }

    /**
     * Class : AdvancedEditionFactory
     * Factory WebServices
     */


    /**
     *     Recherche d'erreurs dans le retour du "applyEdits".
     * Les erreurs détectées sont affichées dans le toastr.
     *
     * @param {[[type]]} resdata [[Description]]
     */
    function manageApplyEditsErrors(resdata) {
      var ind,
        mess = '',
        ierr,
        ftiOps,
        fti,
        rdArray;

      if (resdata instanceof Array) rdArray = resdata;
      else rdArray = [resdata];
      for (ind = 0; ind < rdArray.length; ind++) {
        ftiOps = rdArray[ind].response;
        if (rdArray[ind]==='NORES') {
          continue;
        }
        if (!ftiOps && rdArray[ind].data[0]) {
          ftiOps = rdArray[ind].data[0].response;
        }
        if (!ftiOps && rdArray[ind].data && rdArray[ind].data.errors) {
          ftiOps = rdArray[ind].data;
        }
        for (ierr = 0; ierr < ftiOps.errors.length; ierr++) {
          mess += JSON.stringify(ftiOps.errors[ierr]) + '\n';
        }
        if (mess.length == 0 && ftiOps.create.length == 0 &&
          ftiOps.delete.length == 0 && ftiOps.depose.length == 0 &&
          ftiOps.historic.length == 0 && ftiOps.update.length == 0) {
          fti = FeatureTypeFactory.getFeatureByUid(resdata.data[ind].ftiUID);
          mess +=
            'ApplyEdits: Erreur non détaillée pour le composant [' +
            fti.name +
            ']\n';
        }
      }
      if (mess.length) {
        require('toastr').error(mess);
      }
    }

    /**
     * Function: applyEdits
     */
    function applyEdits(senddata, crs, checktopology) {
      var promise = $http.post(
        '/services/{portalid}/processedition/{appname}/applyedits?f=json' +
          '&crs=' +
          crs +
          '&checktopology=' +
          checktopology +
          '&storename=' +
          storeNameToLoadIds,
        senddata
      );
      promise.then(
        function(res) {
          if (angular.isDefined(res.data)) {
            if (
              angular.isDefined(res.data.stopAllEdits) &&
              res.data.stopAllEdits == true
            ) {
              var errorMessage = $filter('translate')(
                res.data.stopAllEditsReason
              );
              require('toastr').error(errorMessage);
            } else manageApplyEditsErrors(res.data);
            if (angular.isDefined(res.data.lotOfIdsJSON)) {
              if (angular.isArray(res.data.lotOfIdsJSON)) {
                idsInUse = [];
                indexUseLotOfIds = 0;
                storedLotOfIds = res.data.lotOfIdsJSON;
              } else handlingIdsNotImplemented = true;
            }
          }
          lastUsedId = -1;
        },
        function(err) {
          console.log(err);
          lastUsedId = -1;
        }
      );
      return promise;
    }


    function isTemporaryId(idToCheck) {
      if (indexUseLotOfIds == 0 || idsInUse.length == 0) return false;
      else return idsInUse.indexOf(idToCheck) !== -1;
    }

    function getObjectId(feature) {
      if (angular.isDefined(feature.getId)) return feature.getId();
      else if (feature.properties && feature.properties.objectid)
        return feature.properties.objectid;
      else if (feature.id) return feature.id;
      else return -1;
    }

    return {
      AdvancedEditionFactory: AdvancedEditionFactory,
      applyEdits: applyEdits,
      getObjectId: getObjectId,
      isTemporaryId: isTemporaryId,
      sendResponse: sendResponse,
      logResponse: logResponse,
      isEditionResponse: isEditionResponse,
      INFO_RESPONSE: INFO_RESPONSE,
      WARNING_RESPONSE: WARNING_RESPONSE,
      ERROR_RESPONSE: ERROR_RESPONSE,
      CAN_PROCESS_EDIT: CAN_PROCESS_EDIT,
      CANNOT_PROCESS_EDIT: CANNOT_PROCESS_EDIT,
    };
  };
  AdvancedEditionFactory.$inject = [
    '$http',
    '$filter',
    '$translate',
    'FeatureTypeFactory',
  ];
  return AdvancedEditionFactory;
});

define('modules/edit/services/EditFactory',['toastr'],function() {
  var EditFactory = function(
    $http,
    gaUrlUtils,
    $q,
    $location,
    $rootScope,
    $filter, gcRestrictionProvider
  ) {
    var Edit = {};
    /**
     * Class : Edit
     * Factory WebServices
     */
    function historicize(fid, senddata, crs) {
      console.log(senddata);
      var promise = $http.post(
        '/services/{portalid}/edit/' + fid + '/historicize?f=json&crs=' + crs,
        senddata
      );
      promise.then(
        function(res) {
          console.log(res);
          // service level logic if any
        },
        function(err) {
          console.log(err);
        }
      );
      return promise;
    }

    function depose(fid, senddata, crs) {
      console.log(senddata);
      var promise = $http.post(
        '/services/{portalid}/edit/' + fid + '/depose?f=json&crs=' + crs,
        senddata
      );
      promise.then(
        function(res) {
          console.log(res);
          // service level logic if any
        },
        function(err) {
          console.log(err);
        }
      );
      return promise;
    }

    var QueryDataDefers = [];

    function createDefer(defer) {
      var int = Math.round(Math.random() * 10e7);
      QueryDataDefers.push({
        idx: int,
        defer: defer,
      });
      return int;
    }

    function dataResultAndroid(res, int) {
      var defer;
      try {
        var index;
        for (var i = 0; i < QueryDataDefers.length; i++) {
          var d = QueryDataDefers[i];
          if (d.idx === int) {
            defer = d.defer;
            index = i;
            break;
          }
        }

        var response = {
          data: res,
        };
        try {
          if (response.data && typeof response.data == 'string') {
            response.data = JSON.parse(response.data);
          }
        } catch (e) {
          console.log(response.data);
          e.stack;
        }
        defer.resolve(response);
      } catch (e) {
        e.stack;
        defer.reject();
      }
      QueryDataDefers.splice(index, 1);
    }

    /**
     * Function: applyedits
     */
    function applyedits(fid, idstodelete, senddata, crs, checktopology) {
      console.log(senddata);
      if (typeof EditAndroid !== 'undefined') {
        var defer = $q.defer();
        var int = createDefer(defer);
        EditAndroid.add(fid, JSON.stringify(senddata), int);
        return defer.promise;
      } else {
        var promise = $http.post(
          '/services/{portalid}/edit/' +
            fid +
            '/applyedits?f=json&crs=' +
            crs +
            '&checktopology=' +
            checktopology +
            '&ids=' +
            idstodelete,
          senddata
        );
        promise.then(
          function() {
            // service level logic if any
          },
          function(err) {
            console.log(err);
          }
        );
        return promise;
      }
    }

    /**
     * Function: add
     */
    function add(fid, senddata, crs, checktopology, applyRules, returnInCrsProj,
        purgeLayer = false) {
      console.log(senddata);
      if (typeof EditAndroid !== 'undefined') {
        var defer = $q.defer();
        var int = createDefer(defer);
        EditAndroid.add(fid, JSON.stringify(senddata), int);
        return defer.promise;
      } else {
        senddata.features = senddata.features.map(transformFeatureForSave);
        var promise = $http.post(
          '/services/{portalid}/edit/' +
            fid +
            '/add?f=json&crs=' +
            crs +
            (checktopology ? '&checktopology=' + checktopology : '') +
            (applyRules ? '&applyRules=true' : '') +
            (returnInCrsProj ? '&returnInCrsProj=true' : '') +
            (purgeLayer ? '&purgeLayer=true' : ''),
          senddata
        );
        promise.then(
          function() {
            // service level logic if any
          },
          function(err) {
            console.log(err);
          }
        );
        return promise;
      }
    }

    /**
     * Function: specialUpdate
     */
    function specialUpdate(fid, senddata, crs, checktopology, applyRules,
        purgeLayer, isCsv = true) {
      console.log(senddata);
      var promise = $http.post(
        '/services/{portalid}/edit/' +
          fid +
          '/specialUpdate?f=json&crs=' +
          crs +
          '&checktopology=' +
          checktopology +
          (applyRules ? '&applyRules=true' : '') +
          (purgeLayer ? '&purgeLayer=true' : '') +
          (isCsv ? '&isCsv=true' : ''),
        senddata
      );
      promise.then(
        function() {
          // service level logic if any
        },
        function(err) {
          console.log(err);
        }
      );
      return promise;
    }

    /* Function: delete_feature_relations **/
    function delete_feature_relations(fid, featdUid, feataUid, featdFid) {
      var promise = $http.get(
        '/services/{portalid}/edit/{fid}/rel/delete_feature_relations?f=json' +
          '&fid=' +
          fid +
          '&featdUid=' +
          featdUid +
          '&feataUid=' +
          feataUid +
          '&featdFid=' +
          featdFid
      );

      return promise;
    }
    /**
     * Function: delete
     */
    function remove(fid, ids, allData) {
      if (typeof EditAndroid !== 'undefined') {
        var defer = $q.defer();
        var int = createDefer(defer);
        EditAndroid.delete(fid, ids, int);
        return defer.promise;
      } else {
        ids = gaUrlUtils.encodeUriQuery(ids || '');
        var app = '';
        if ($location.search().app) {
          app = $location.search().app;
        } else {
          try {
            app = angular.module('gcMain').app;
          } catch (e) {
            console.log('no app name available');
          }
        }
        var promise = $http.get(
          '/services/{portalid}/edit/' +
            fid +
            '/delete?f=json' +
          (allData ? ('&allData=' + true) : ('&ids=' + ids)) +
            '&appname=' + app
        );
        promise.then(function() {
          // service level logic if any
        });
        return promise;
      }
    }

    /**
     * Function: deletewhere
     */
    function deleteWhere(fid, where) {
      where = gaUrlUtils.encodeUriQuery(where || '');
      var app = '';
      if ($location.search().app) {
        app = $location.search().app;
      } else {
        try {
          app = angular.module('gcMain').app;
        } catch (e) {
          console.log('no app name available');
        }
      }
      var promise = $http.get(
        '/services/{portalid}/edit/' + fid + '/deleteWhere?f=json' +
        '&fid=' + fid +
        '&where=' + where +
        '&appname=' + app
      );

      return promise;
    }
    /**
     * Function: update
     */
    function update(fid, senddata, crs) {
      if (typeof EditAndroid !== 'undefined') {
        var defer = $q.defer();
        var int = createDefer(defer);
        EditAndroid.update(fid, JSON.stringify(senddata), int);
        return defer.promise;
      } else {
        senddata.features = senddata.features.map(transformFeatureForSave);
        var promise = $http.post(
          '/services/{portalid}/edit/' + fid + '/update?f=json&crs=' + crs,
          senddata
        );
        promise.then(function(res) {
          var ind;
          if (res.data.errors.length != 0) {
            for (ind = 0; ind < res.data.errors.length; ind++) {
              require('toastr').error(
                $filter('translate')('editfactory.' + res.data.errors[ind])
              );
            }
          }
        },
        result => {
          gcRestrictionProvider.showDetailsErrorMessage(result);
        });
        return promise;
      }
    }

    /**
     * Function: updatewhere
     */
    function updateWhere(fid, where, senddata) {
      where = gaUrlUtils.encodeUriQuery(where || '');
      var promise = $http.post(
        '/services/{portalid}/edit/' +
          fid +
          '/updateWhere?f=json' +
          '&where=' +
          where,
        senddata
      );

      return promise;
    }


    /**
     * Function: updatespecificproperties
     */
    function updatespecifiedproperties(fid, senddata, crs) {
      var promise = $http.post(
        '/services/{portalid}/edit/' +
          fid +
          '/updateSpecifiedProperties?f=json&crs=' +
          crs,
        senddata
      );

      return promise;
    }

    /**
     * Function: r_add
     */
    function r_add(senddata, fid, idd, relname) {
      var promise = $http.post(
        '/services/{portalid}/edit/' +
          fid +
          '/rel/' +
          idd +
          '/' +
          relname +
          '/add?f=json',
        senddata
      );

      return promise;
    }

    /**
     * Function: r_delete
     */
    function r_delete(fid, relname, ids, delrobject) {
      ids = gaUrlUtils.encodeUriQuery(ids || '');
      //            var promise = $http.get('/services/{portalid}/edit/{fid}/rel/{idd}/{relname}/delete?f=json' +'&fid=' + fid +'&relname=' + relname +'&ids=' + ids +'&delrobject=' + delrobject);
      var promise = $http.get(
        '/services/{portalid}/edit/' +
          fid +
          '/rel/' +
          relname +
          '/delete?f=json' +
          '&fid=' +
          fid +
          '&relname=' +
          relname +
          '&idd=' +
          ids +
          '&delrobject=' +
          delrobject
      );
      promise.then(function(res) {});
      return promise;
    }

    /**
     * Function: r_delete_1_nm
     *    Supprime la relation entre 2 objets précis.
     *    La relation est déduité du feaid qui est dans le path
     *    et de son nom passé en paramètre.
     */
    function r_delete_1_nm(fid, relname, idd, ida, delrobject) {
      var promise = $http.get(
        '/services/{portalid}/edit/' +
          fid +
          '/rel/' +
          relname +
          '/delete_nm?f=json' +
          '&idd=' +
          idd +
          '&idaList=' +
          ida +
          '&delrobject=' +
          delrobject
      );

      return promise;
    }

    /**
     * Function: updatebyid
     */
    function updatebyid(fid, ids, fieldname, fieldtype, fieldvalue) {
      ids = gaUrlUtils.encodeUriQuery(ids || '');
      var promise = $http.get(
        '/services/{portalid}/edit/' +
          fid +
          '/updateById?f=json' +
          '&fid=' +
          fid +
          '&ids=' +
          ids +
          '&fieldname=' +
          fieldname +
          '&fieldtype=' +
          fieldtype +
          '&fieldvalue=' +
          fieldvalue
      );

      return promise;
    }
    /**
     * Function: updateexpression
     */
    function updateexpression(senddata, fid) {
      var promise = $http.post(
        '/services/{portalid}/edit/' + fid + '/updateExpression?f=json',
        senddata
      );

      return promise;
    }
    /**
     * Function: updatebyid
     */
    function updatebyfilter(fid, where, fieldname, fieldtype, fieldvalue) {
      var promise = $http.post(
        '/services/{portalid}/edit/' +
          fid +
          '/updateByFilter?f=json' +
          '&fid=' +
          fid +
          '&fieldname=' +
          fieldname +
          '&fieldtype=' +
          fieldtype +
          '&fieldvalue=' +
          fieldvalue,
        where
      );

      return promise;
    }

    function transformFeatureForSave(feature) {
      feature.properties = Object.keys(feature.properties || {})
        .reduce((properties, key) => {
          if (
            typeof feature.properties[key] === 'object' &&
            feature.properties[key] !== null &&
            typeof feature.properties[key].getMonth === 'function'
          ) {
            properties[key] = moment(feature.properties[key]).utc().format('YYYY-MM-DDTHH:mm:ss.SSSZZ');
          } else {
            properties[key] = feature.properties[key];
          }
          return properties;
        }, {});
      return feature;
    }
    return {
      Edit: Edit,
      historicize: historicize,
      depose: depose,
      applyedits: applyedits,
      add: add,
      specialUpdate: specialUpdate,
      remove: remove,
      update: update,
      deleteWhere: deleteWhere,
      r_add: r_add,
      updatespecifiedproperties: updatespecifiedproperties,
      r_delete: r_delete,
      r_delete_1_nm: r_delete_1_nm,
      updatebyid: updatebyid,
      updateWhere: updateWhere,
      updateexpression: updateexpression,
      delete_feature_relations: delete_feature_relations,
      dataResultAndroid: dataResultAndroid,
      updatebyfilter: updatebyfilter,
    };
  };
  EditFactory.$inject = [
    '$http',
    'gaUrlUtils',
    '$q',
    '$location',
    '$rootScope',
    '$filter', 'gcRestrictionProvider'
  ];
  return EditFactory;
});

/**
 * Implémentation des règles métiers d'édition.
 * @returns {EditRulesProvider_L6.EditRulesProvider}
 */

define('modules/edit/services/EditRulesProvider',['toastr','toastr','toastr','toastr','toastr','toastr','toastr','toastr','toastr','toastr'],function() {
  let EditRulesProvider = {
    $get: function(
      gclayers,
      gcWFS,
      $q,
      ogcFactory,
      EditTypesFactory,
      GeometryFactory,
      gcPopup,
      $rootScope,
      SridFactory,
      ConfigFactory,
      ChartsFactory,
      $filter,
      What3WordFactory,
      $timeout,
      CopyPasteAttributeFactory,
      gaJsGeneral,
      gaDomUtils,
      EditRuleAllowDelete,
      EditRuleMoveObjectOnEnd,
      EditRuleObjectNotAllowedAtIntersection,
      EditRuleSetDefaultValueByRole,
      EditRuleSnappedOnFeature,
      ngDialog,
      MustNotSelfIntersectRule,
      MustNotSelfOverlapRule,
      GetFeaturesFromLineAssociationRule,
      bizeditProvider,
      FeatureTypeFactory
    ) {
      ///////// Fonctions utilitaires ///////////////////////////////////

      let format = new ol.format.GeoJSON();

      /**
       * Vérifie si l'objet partagé est present dans le tableau des objets liés destinés à être sauvegardés.
       * @param {type} shareObjectName: nom de l'objet partagé.
       * @param {type} editdescription: objet contenant les informations sur l'édition en cours (voir bizeditwidget.js).
       * @returns {Boolean} true si l'objet partagé est present dans le tableau de sauvegarde, false sinon.
       */
      function isObjectInRelatedFeatures(shareObjectName, editdescription) {
        var isFeatureExistInRelated = false;
        for (var k = 0; k < editdescription.relatedfeatures.length; k++) {
          if (
            editdescription.relatedfeatures[k].shareObject == shareObjectName
          ) {
            isFeatureExistInRelated = true;
            break;
          }
        }
        return isFeatureExistInRelated;
      }

      /**
       * Renvoie l'objet layer situé dans le tableau layers passé en second argument et
       * dont le nom correspond au premier argument layerName.
       * @param {type} layerName
       * @param {type} layers
       * @returns {unresolved}
       */
      function getLayerByName(layerName, layers) {
        var layer = undefined;
        for (var i = 0; i < layers.length; i++) {
          var l = layers[i];
          if (l.name == undefined) continue;
          if (layerName == l.name) {
            layer = l;
            break;
          }
        }
        return layer;
      }

      /**
       * Retourne l'angle du segment P1P2 par rapport à l'axe des x,
       * dans le sens horaire, en degré.
       * @param {type} p1
       * @param {type} p2
       * @returns {Number}
       */
      function getP1P2Angle(p1, p2) {
        //Angle trigo entre le segment p1p2 et l'axe des x

        var dx = p2[0] - p1[0];
        var dy = p2[1] - p1[1];

        var radian = Math.atan(Math.abs(dy) / Math.abs(dx));

        //L'angle considéré par le style a le sens inverse trigonometrique
        if (dy > 0 && dx > 0) {
          radian = 2 * Math.PI - radian;
        } else if (dy < 0 && dx > 0) {
        } else if (dx < 0 && dy > 0) {
          radian = Math.PI + radian;
        } else if (dy < 0 && dx < 0) {
          radian = Math.PI - radian;
        }

        //Conversion en degre et arrondi à l'entier le plus proche.
        return Math.round(radian * (180 / Math.PI));
      }

      /**
       * Affecte une valeur d'orientation dans le featurePoint à partir de l'objet intersectedFeatureLine et d'un offset eventuel.
       * @param {type} featurePoint
       * @param {type} rotateFieldName
       * @param {type} intersectedFeatureLine
       * @param {type} rotationOffset
       * @returns {undefined}
       */
      function setPointRotationFromLineObject(
        featurePoint,
        rotateFieldName,
        intersectedFeatureLine,
        rotationOffset
      ) {
        var pointCoordinate = featurePoint.getGeometry().getCoordinates();

        var line = intersectedFeatureLine.getGeometry();
        var isSimpleLine = line instanceof ol.geom.LineString;
        var isMultiLine = line instanceof ol.geom.MultiLineString;

        //Index du segment sur lequel couper la line.
        var cuttingIndex = undefined;
        var cuttinglineIndex = undefined;

        //Points du segment courant pour lequel on recherche l'intersection avec le featurePoint
        var p1 = undefined;
        var p2 = undefined;
        if (isSimpleLine) {
          var lineCoordinates = line.getCoordinates();
          cuttingIndex = getIndexOnSimpleLine(lineCoordinates, pointCoordinate);

          if (cuttingIndex == undefined) {
            console.info(
              'setPointRotationFromLineObject() Pas de segment trouvé sous le point'
            );
            return;
          }
          p1 = lineCoordinates[cuttingIndex];
          p2 = lineCoordinates[cuttingIndex + 1];
        } else if (isMultiLine) {
          var simpleLines = line.getCoordinates();
          //Pour chaque simple line de la multiline
          for (var lineIndex = 0; lineIndex < simpleLines.length; lineIndex++) {
            cuttingIndex = getIndexOnSimpleLine(
              simpleLines[lineIndex],
              pointCoordinate
            );
            //Si l'index du segement de la simple line a été trouvé
            if (cuttingIndex != undefined) {
              //mémorisation de l'index de la simple line
              cuttinglineIndex = lineIndex;
              break;
            }
          }
          if (cuttingIndex == undefined) {
            console.info(
              'setPointRotationFromLineObject() Pas de segment trouvé sous le point'
            );
            return;
          }
          var simpleLine = simpleLines[cuttinglineIndex];
          p1 = simpleLine[cuttingIndex];
          p2 = simpleLine[cuttingIndex + 1];
        }

        //Affectation de la valeur de la rotation
        var property = {};
        property[rotateFieldName] = getP1P2Angle(p1, p2);
        if (rotationOffset != undefined) {
          property[rotateFieldName] =
            property[rotateFieldName] + rotationOffset;
        }
        featurePoint.setProperties(property);
      }

      /**
       * Ajoute l'objet dans le tableau des objets à sauver uniqument si il n'est pas déjà present dans ce tableau.
       * @param {type} editdescription
       * @param {type} objectToDelete
       * @returns {undefined}
       */
      function recordObjectIfNotExists(editdescription, objectToDelete) {
        var isAlreadyRecorded = false;
        for (var i = 0; i < editdescription.relatedfeatures.length; i++) {
          var related = editdescription.relatedfeatures[i];
          if (related.editType == objectToDelete.editType) {
            if (related.feature.getId() == objectToDelete.feature.getId()) {
              isAlreadyRecorded = true;
              break;
            }
          }
        }
        if (!isAlreadyRecorded) {
          editdescription.relatedfeatures.push(objectToDelete);
        }
      }

      /**
       * Donne l'index 'cuttingIndex' correspondant au premier point de la simpleLine 'lineCoordinates' du segment sur lequel se trouve le point 'intersectionPointCoordinate'.
       * Retourne undefined si le point n'est pas situé sur la simple line.
       * @param {type} lineCoordinates
       * @param {type} intersectionPointCoordinate
       * @returns {Number}cuttingIndex
       */
      function getIndexOnSimpleLine(
        lineCoordinates,
        intersectionPointCoordinate
      ) {
        var cuttingIndex = undefined;

        //Pour chaque segment de la simple line
        for (var i = 0; i < lineCoordinates.length - 1; i++) {
          //Les deux points du segments
          var p1 = lineCoordinates[i];
          var p2 = lineCoordinates[i + 1];

          //Si le point édité est posé sur le premier point du segment ou sur le second point (x et y sont les mêmes à 1cm près)
          if (
            (Math.round(intersectionPointCoordinate[0] * 100) ==
              Math.round(p1[0] * 100) &&
              Math.round(intersectionPointCoordinate[1] * 100) ==
                Math.round(p1[1] * 100)) ||
            (Math.round(intersectionPointCoordinate[0] * 100) ==
              Math.round(p2[0] * 100) &&
              Math.round(intersectionPointCoordinate[1] * 100) ==
                Math.round(p2[1] * 100))
          ) {
            cuttingIndex = i;
            break;
          }
          //Si le point édité est posé entre les deux points du segment
          else {
            //Coef directeur de la line
            var coef = (p2[1] - p1[1]) / (p2[0] - p1[0]);
            //Coef directeur de la droite intersectionPointCoordinate et une des extrémité (celle qui ne se superpose pas au point édité)
            var coef2 = NaN;
            coef2 =
              (intersectionPointCoordinate[1] - p1[1]) /
              (intersectionPointCoordinate[0] - p1[0]);
            //Si intersectionPoint appartient à la DROITE line correspondant au segment en cours P1P2
            if (
              Math.abs(Math.round(coef * 100)) ==
              Math.abs(Math.round(coef2 * 100))
            ) {
              //Vérification si intersectionPointCoordinate appartient au SEGMENT P1P2
              if (
                intersectionPointCoordinate[0] <= Math.max(p1[0], p2[0]) &&
                intersectionPointCoordinate[0] >= Math.min(p1[0], p2[0]) &&
                intersectionPointCoordinate[1] <= Math.max(p1[1], p2[1]) &&
                intersectionPointCoordinate[1] >= Math.min(p1[1], p2[1])
              ) {
                cuttingIndex = i;
                break;
              }
            }
          }
        }
        return cuttingIndex;
      }

      /**
       * Non utilisée.
       * @param {type} line1
       * @param {type} line2
       * @param {type} intersectingPoint
       * @returns {ol.geom.MultiLineString}
       */
      function mergeTwoLines(line1, line2, intersectingPoint) {
        var deletedCoordinate = intersectingPoint.getCoordinates();
        var firstLine = undefined;
        var secondLine = undefined;

        //Si les coordonnées en x et en y sont égales à 10cm près
        if (
          Math.round(line1.getLastCoordinate()[0] * 10) ==
            Math.round(deletedCoordinate[0] * 10) &&
          Math.round(line1.getLastCoordinate()[1] * 10) ==
            Math.round(deletedCoordinate[1] * 10)
        ) {
          firstLine = line1;
          secondLine = line2;
        } else if (
          Math.round(line2.getLastCoordinate()[0] * 10) ==
            Math.round(deletedCoordinate[0] * 10) &&
          Math.round(line2.getLastCoordinate()[1] * 10) ==
            Math.round(deletedCoordinate[1] * 10)
        ) {
          firstLine = line2;
          secondLine = line1;
        }
        //Concatenation de la first line avec la seconde line
        var isSimpleLine1 = firstLine instanceof ol.geom.LineString;
        var isMultiLine1 = firstLine instanceof ol.geom.MultiLineString;
        var isSimpleLine2 = secondLine instanceof ol.geom.LineString;
        var isMultiLine2 = secondLine instanceof ol.geom.MultiLineString;

        var multiCoordinates = [];

        if (isSimpleLine1) {
          multiCoordinates.push(firstLine.getCoordinates());
        } else if (isMultiLine1) {
          multiCoordinates = multiCoordinates.concat(
            firstLine.getCoordinates()
          );
        }
        if (isSimpleLine2) {
          multiCoordinates.push(secondLine.getCoordinates());
        } else if (isMultiLine2) {
          multiCoordinates = multiCoordinates.concat(
            secondLine.getCoordinates()
          );
        }
        //-- Retourne la ligne fusionnée
        return new ol.geom.MultiLineString(multiCoordinates, 'XY');
      }

      function toRad(Value) {
        /** Converts numeric degrees to radians */
        return (Value * Math.PI) / 180;
      }

      var wgs84Sphere = new ol.Sphere(6378137);
      function getPreciseLineLength(simpleLine, map) {
        var length = 0;
        var coordinates = simpleLine.getCoordinates();
        var sourceProj = map
          .getView()
          .getProjection()
          .getCode();

        for (var i = 0, ii = coordinates.length - 1; i < ii; ++i) {
          var c1 = ol.proj.transform(coordinates[i], sourceProj, 'EPSG:4326');
          var c2 = ol.proj.transform(
            coordinates[i + 1],
            sourceProj,
            'EPSG:4326'
          );
          length += wgs84Sphere.haversineDistance(c1, c2);
        }
        return length;
      }
      function getSimpleLineLength(simpleLine, map, fti) {
        var ftiUid = '';
        if (
          fti &&
          angular.isDefined(fti) &&
          fti.uid &&
          angular.isDefined(fti.uid)
        ) {
          ftiUid = fti.uid;
          var fc = {
            type: 'FeatureCollection',
            crs: {
              type: 'name',
              properties: {
                name: map
                  .getView()
                  .getProjection()
                  .getCode(),
              },
            },
            features: [
              {
                type: 'Feature',
                properties: {},
                geometry: {
                  type: simpleLine.getType(),
                  coordinates: simpleLine.getCoordinates(),
                },
                uid: ftiUid,
              },
            ],
            totalFeatures: 1,
          };
          return ChartsFactory.areaperimeter(fc, false);
        } else {
          console.error(
            'Règle getSimpleLineLength mal ou pas configurée : vérifie le fti de la couche'
          );
        }
      }

      function getSimplePolygonArea(simpleLine, map, featureType) {
        var fc = {
          type: 'FeatureCollection',
          crs: {
            type: 'name',
            properties: {
              name: map
                .getView()
                .getProjection()
                .getCode(),
            },
          },
          features: [
            {
              type: 'Feature',
              properties: {},
              geometry: {
                type: simpleLine.getType(),
                coordinates: simpleLine.getCoordinates(),
              },
              uid: featureType.uid,
            },
          ],
          totalFeatures: 1,
        };

        return ChartsFactory.areaperimeter(fc, false);
      }

      //////// FIN METHODES UTILITAIRES //////////////////////////////////

      ////////// Implémentation des règles métiers ///////////////////////

      /// Régles métiers executées à l'initialisation ////////////////////

      function snapFailed(deferred) {
        require('toastr').error(
          $filter('translate')('rulecfg.snapon.snapIsMandatory')
        );
        deferred.reject({
          error: true,
          errorType: 'snapFailed',
        });
      }

      function snapCrExistMoveExtremityLines(params) {
        var ind;
        for (ind = 0; ind < params.rules.length; ind++)
          if (params.rules[ind].name == 'MoveExtremityLines') return true;
        return false;
      }

      function checkSnapRestrictionsIsOk(
        editdescription,
        params,
        ruleConf,
        features
      ) {
        var iFeat, layerName, snapcfg, val;

        if (ruleConf.parameters.must == 'true') return true;

        for (iFeat = 0; iFeat < features.length; iFeat++) {
          layerName = GlobalServices.getLayerNameFromFullIdValue(
            features[iFeat].id
          );
          snapcfg = ruleConf.parameters.snapOnSet[layerName];
          if (snapcfg && snapcfg.fieldName) {
            if (snapcfg.snapSet != 'attribute') return true;
            val = features[iFeat].properties[snapcfg.fieldName];
            if (snapcfg.mustAttributeVal[val] == 'true') return true;
          }
        }
        return false;
      }

      function snapOnHaveToSnap(snapParams, editdesc, fti) {
        if (snapParams['must'] == 'true') return true;
        if (
          snapParams['must'] == 'attribute' &&
          snapParams.mustAttribute == editdesc.subtypefn
        ) {
          return snapParams.mustAttributeVal[editdesc.subtypevalue] == 'true';
        }
        return false;
      }
      /**
       * Règle d'accroche sur objets appartenant aux couches wfs chargées une à une sur la carte
       *  et dont les noms correspondent à ceux configurés pour cette règle.
       * @param {object} editdescription objet de l'édition métier en cours
       * @param {object} ruleConf configuration de la règle snapOn. Element du tableau fti.rules
       * @param {object} featureType fti sur lequel s'applique la règle métier
       * @param {ol.Map} map carte
       * @return {Promise} vide si la règle a pu s'appliquer sinon contient une erreur serveur
       */
      function snapOn(editdescription, ruleConf, featureType, map) {
        var layersToLoad = [];
        var layers = gclayers.getOperationalLayer();
        var layerNames = ruleConf.parameters['layers'];

        function snapCheckResult(editdescription, params, ruleConf) {
          var deferred = $q.defer();
          var coord;
          if (
            editdescription.originalfeature != undefined &&
            (editdescription.strictsnap == undefined ||
              !editdescription.strictsnap) &&
            snapCrExistMoveExtremityLines(params)
          )
            //-- Dans le cas du déplacement d'un point où on va déplacer
            //-- les lignes aux extrémités on doit vérifier que le point
            //-- original est bien connecté aux ligne
            //-- et non pas le nouveau (la nouvelle position).
            coord = editdescription.originalfeature
              .getGeometry()
              .getCoordinates();
          else {
            if (params.evt.feature == undefined) {
              //-- On doit être ici par erreur !!!
              deferred.resolve();
              return deferred.promise;
            }
            coord = params.evt.feature.getGeometry().getCoordinates();
          }
          while (typeof coord[0] == 'object') coord = coord[0];
          var tol = 0.25;
          var selGeomCql =
            'POLYGON((' +
            (coord[0] - tol) +
            ' ' +
            (coord[1] - tol) +
            ',' +
            (coord[0] + tol) +
            ' ' +
            (coord[1] - tol) +
            ',' +
            (coord[0] + tol) +
            ' ' +
            (coord[1] + tol) +
            ',' +
            (coord[0] - tol) +
            ' ' +
            (coord[1] + tol) +
            ',' +
            (coord[0] - tol) +
            ' ' +
            (coord[1] - tol) +
            '))';

          var spatialClause = 'INTERSECTS(geom, ' + selGeomCql + ')';
          var promise = ogcFactory.getfeatures(
            'GetFeature',
            'WFS',
            '1.0.0',
            params.ftiList,
            'json',
            map
              .getView()
              .getProjection()
              .getCode(),
            spatialClause
          );
          promise.then(
            function(res) {
              if (
                res.data.features.length &&
                checkSnapRestrictionsIsOk(
                  editdescription,
                  params,
                  ruleConf,
                  res.data.features
                )
              )
                deferred.resolve();
              else snapFailed(deferred);
            },
            function(res) {
              snapFailed(deferred);
            }
          );
          return deferred.promise;
        }

        if (snapOnHaveToSnap(ruleConf.parameters, editdescription, featureType))
          ruleConf.checkResult = snapCheckResult;
        else ruleConf.checkResult = undefined;
        ruleConf.checkResultParams = {};
        ruleConf.checkResultParams.ftiList = [];
        let filters = [];
        //Pour chaque nom de layer en config de cette règle
        for (var j = 0; j < layerNames.length; j++) {
          var name = layerNames[j].name;
          //Pour chaque layer opérationelle
          for (var i = 0; i < layers.length; i++) {
            var l = layers[i];
            if (l.name == undefined) {
              continue;
            }
            if (name == l.name) {
              var fti = l.fti;
              layersToLoad.push(fti);
              ruleConf.checkResultParams.ftiList.push(fti.uid);
              //set esri filters
              if(featureType.type == 'esri' && ruleConf.parameters.must=='attribute'){
                let desc = ruleConf.parameters.snapOnSet[name];
                let strFilter = '';
                for (var prop in desc.mustAttributeVal) {
                  if (strFilter != '') strFilter += ' OR ';
                  strFilter += desc.fieldName + '=\'' + prop + '\'';
                }
                filters.push({
                  'ftiUid': fti.uid,
                  'filter': '(' + strFilter + ')'
                });
              }
              break;
            }
          }
        }
        //Chargement des objets des couches sur lesquelles s'accrocher
        let wfsLayer = gcWFS.getOlLayerFromFeaturetypeInfoArray(layersToLoad, map, (filters.length == 0) ? undefined : filters);
        gclayers.addSnapLayer(wfsLayer);
        var srcDrawedDXF = gclayers.getImportLayer().getSource();
        wfsLayer.getSource().addFeatures(srcDrawedDXF.getFeatures());

        var config = map.get(editdescription.theme);
        var snapTolerance;
        //Récupération de la tolérance de snapping (paramètre de configuration du widget)
        config
          ? (snapTolerance = Number(config.snaptolerance))
          : (snapTolerance = Number(map.get('snaptolerance'))); // * resolution;

        if (snapTolerance == undefined || isNaN(snapTolerance)) {
          snapTolerance = 20;
        } // * resolution;

        //Définir la couleur de la couche wfs ol d'accrochage
        //Si l'utilisateur choisi une couleur depuis l'interface admin (thème),
        //on affiche la couleur sélectionnée sinon on met la couleur par défaut (couleur du logo KIS)
        let snapColor;
        if($rootScope && $rootScope.xgos && $rootScope.xgos.portal
            && $rootScope.xgos.portal.parameters && $rootScope.xgos.portal.parameters.snapColor) {
          snapColor = $rootScope.xgos.portal.parameters.snapColor;
        } else {
          snapColor = '#f31f72';
        }
        // Définir un style spécifique basé sur le type de géométrie
        let getLayerStyle = (type) => {
          if (type === 'POLYGON') {
            return new ol.style.Style({
              fill: new ol.style.Fill({
                color: 'rgba(0, 0, 0, 0)' // Remplissage transparent
              }),
              stroke: new ol.style.Stroke({
                color: snapColor,
                width: 2
              })
            });
          } else {
            return new ol.style.Style({
              fill: new ol.style.Fill({
                color: snapColor
              }),
              stroke: new ol.style.Stroke({
                color: snapColor,
                width: 2
              }),
              image: new ol.style.Circle({
                radius: 5,
                fill: new ol.style.Fill({
                  color: snapColor
                }),
                stroke: new ol.style.Stroke({
                  color: '#000000',
                  width: 1
                })
              })
            });
          }
        };

        // Appliquer un style spécifique à chaque couche dans layersToLoad
        layersToLoad.forEach(layer => {
          let type = layer.typeInfo; // Type de la géométrie
          let layerStyle = getLayerStyle(type);
          wfsLayer.setStyle(layerStyle);
        });

        //Instanciation de l'interaction OpenLayer d'accroche sur objets
        // appartenant aux layers chargées dans l'objet 'source' de la couche WFS crée.
        var snap = new ol.interaction.Snap({
          source: wfsLayer.getSource(),
          edge: true,
          vertex: true,
          pixelTolerance: snapTolerance,
        });

        snap.set('gctype', 'kis');
        snap.set('interaction', 'Snap');
        snap.set('widget', 'Edition');
        snap.setActive(true);

        //Ajout de l'interaction à la carte
        map.addInteraction(snap);
        if (
          map
            .getInteractions()
            .getArray()
            .indexOf(snap) !== -1
        ) {
          //Envoi de l'information de l'interaction ajoutée.
          map.dispatchEvent({ type: 'snapAddedEvent' });
          //Enregistrement de la reference vers l'interaction pour la retirer de la carte au besoin.
          editdescription.interactions.push(snap);
          console.info('Bizeditwidget: intéraction snapOn chargée.');
        }
        var mess = ruleConf.parameters['inputMessage'];
        if (mess != undefined && mess.length !== 0) {
          var t = require('toastr');
          t.info(mess, 'Info', {
            showDuration: 1800,
            timeOut: 2500,
          });
        }
      }

      /**
       * Copie les features éditées et enregistre ces copies dans l'objet editdescription
       * en vue d'être ajouté à la couche d'historisation lorsque la sauvegarde de la session d'édition aura lieu.
       * @param {object} editdescription objet de l'édition métier en cours
       * @param {object} ruleConf configuration de la règle snapOn. Element du tableau fti.rules
       * @param {object} featureType fti sur lequel s'applique la règle métier
       * @param {ol.Map} map carte
       * @returns {Promise} contient un string
       */
      function historicize(editdescription, ruleConf, featureType, map) {
        var deferred = $q.defer();

        function isEditType(element, indice, array) {
          return element.name == this;
        }

        //Traitement de l'objet principal
        //Copie du feature
        var mainFeatureCopie = editdescription.editedfeature.clone();
        //Copie de l'id
        mainFeatureCopie.setId(editdescription.editedfeature.getId());
        //Enregistrement de la copie pour historisation
        var newObject = {
          shareObject: '',
          editType: EditTypesFactory.editTypes.tohistorize.name,
          feature: mainFeatureCopie,
          fti: editdescription.fti,
        };
        editdescription.relatedfeatures.push(newObject);

        //Traitement des objets secondaires
        var featuresToHistorize = [];
        for (var i = 0; i < editdescription.relatedfeatures.length; i++) {
          var related = editdescription.relatedfeatures[i];
          //Si le type d'édition de l'objet secondaire est un de ceux précisés dans la config de la règle et
          // que la layer de l'objet secondaire est la même que celle de l'édition principale
          if (
            related.fti.uid === editdescription.fti.uid &&
            ruleConf.editTypes.some(isEditType, related.editType)
          ) {
            var feature = related.feature;
            var featureCopie = feature.clone();
            //Copie de l'id
            featureCopie.setId(feature.getId());
            //Ajout de l'objet en tant qu'objet à historiser.
            //Faire une copie de l'objet car cette copie va recevoir un nouvel id dans la table d'historique. Les relations avec les interventions se feront coté serveur.
            newObject = {
              shareObject: '',
              editType: EditTypesFactory.editTypes.tohistorize.name,
              feature: featureCopie,
              fti: related.fti,
            };
            featuresToHistorize.push(newObject);
          }
        }
        if (featuresToHistorize.length > 0) {
          editdescription.relatedfeatures = editdescription.relatedfeatures.concat(
            featuresToHistorize
          );
        }

        deferred.resolve('historicize terminé !');
        return deferred.promise;
      }

      /// Régles métiers executées sur l'evenement de fin d'édition //////

      /**
       * Crée automatiquement un objet ponctuel en amont et /ou en aval de l'objet lineaire principal en cours d'édition.
       * @param {type} editdescription
       * @param {type} ruleConf
       * @param {type} featureType
       * @param {type} map
       * @returns {$q@call;defer.promise}
       */
      function setObjectOnExtremity(
        editdescription,
        ruleConf,
        featureType,
        map
      ) {
        if (featureType.typeInfo != 'LINE') {
          console.error(
            'Règle setObjectOnExtremity non adaptée à la couche ' +
              featureType.name
          );
          var deferred = $q.defer();
          deferred.resolve('terminé !');
          return deferred.promise;
        }
        var deferred = $q.defer();
        var layers = gclayers.getOperationalLayer();

        /**
         * Utilitaire: indique si un objet du même nom et de la même layer existe déjà.
         * @param {type} currentExtremity
         * @returns {Boolean}
         */
        function isShareObjectAlreadyInCurrentEdit(currentExtremity) {
          var isShareObjectPresent = false;
          var shareObjectName = currentExtremity.name;
          angular.forEach(editdescription.shareObjects, function(
            shareObj,
            key
          ) {
            if (
              !isShareObjectPresent &&
              shareObj.shareObject == shareObjectName
            ) {
              isShareObjectPresent = true;
            }
          });
          return isShareObjectPresent;
        }

        /**
         * Vérification qu'aucun des objets possible n'existe déjà à cette extrémité
         * @param shareObjectsConfigs
         * @returns {boolean}
         */
        const isOneShareObjectAlreadyInCurrentEdit = (shareObjectsConfigs) => {
          for (const shareObjectConfig of shareObjectsConfigs) {
            if (isShareObjectAlreadyInCurrentEdit(shareObjectConfig)) {
              return true;
            }
          }
          return false;
        };

        /**
         * Utilitaire: crée un objet feature et l'ajoute à l'objet 'editdescription' décrivant la session d'édition
         * @param {type} currentExtremity
         * @param {type} pointCoordinate
         * @returns {undefined}
         */
        function createObject(currentExtremity, pointCoordinate) {
          var layerName = currentExtremity.layer;
          var shareObjectName = currentExtremity.name;
          for (var i = 0; i < layers.length; i++) {
            var l = layers[i];
            if (l.name == undefined) {
              continue;
            }
            if (layerName == l.name) {
              var pointFeature = new ol.Feature({
                geometry: new ol.geom.Point(pointCoordinate),
              });
              gclayers
                .getDrawLayer()
                .getSource()
                .addFeature(pointFeature);
              var newObject = {
                shareObject: shareObjectName,
                editType: EditTypesFactory.editTypes.add.name,
                feature: pointFeature,
                fti: l.fti,
                isNew: true
              };
              editdescription.relatedfeatures.push(newObject);
              editdescription.shareObjects.push(newObject);
              break;
            }
          }
        }

        // Récupération des données de configuration
        let amontShareObjectsConfigs;
        let avalShareObjectsConfigs;
        if (ruleConf.parameters.amont) {
          amontShareObjectsConfigs = ruleConf.parameters.amont.shareObjects;
        }
        if (ruleConf.parameters.aval) {
          avalShareObjectsConfigs = ruleConf.parameters.aval.shareObjects;
        }
        const linearGeometry = editdescription.editedfeature.getGeometry();

        const resetBizEdiWidget = () => {
          bizeditProvider.stopApplyRulesButtonBlinking(true);
          $rootScope.$emit('resetBizEditWidget');
        }
        function enrichShareObjectConfigsWithAlias(shareObjectConfigs) {
          const featureTypes = shareObjectConfigs.map(config =>
            FeatureTypeFactory.getFeatureByName(config.layer)
          );
        
          shareObjectConfigs.forEach((config) => {
            const featureType = featureTypes.find(
              (ft) => ft.name.toLowerCase() === config.layer.toLowerCase()
            );
            if (featureType) {
              config.alias = featureType.alias;
            }
          });
        
          return shareObjectConfigs;
        }
        /**
         * Selection de la configuration de l'objet à créer en amont, et continuation du traitement
         */
        const selectAmontShareObjectConfigAndContinue = () => {
          // Vérification qu'un ponctuel d'un des types configuré n'est pas déjà présent
          if (isOneShareObjectAlreadyInCurrentEdit(amontShareObjectsConfigs)) {
            selectAvalShareObjectConfigAndContinue();
            return;
          }
          // Scope à utiliser pour la popup de sélection du type de feature à créer
          let popupScope = $rootScope.$new(true);
          popupScope.resetBizEdiWidget = resetBizEdiWidget;
          popupScope.shareObjectConfigs = enrichShareObjectConfigsWithAlias(amontShareObjectsConfigs);
          popupScope.stepForPopupTitle = 'Amont';
          // Fonction de sélection du type de feature à créer
          popupScope.pickShareObjectConfig = (shareObjectConfig) => {
            createObject(shareObjectConfig, linearGeometry.getFirstCoordinate());
            // Continuation sur l'aval
            if (avalShareObjectsConfigs
              && avalShareObjectsConfigs.length !== 0) {
              selectAvalShareObjectConfigAndContinue();
            }
            else {
              //-- Seul l'objet en extrémité amont est à créer
              deferred.resolve();
            }
          };
          // Si une seule configuration possible, on la choisi automatiquement
          if (amontShareObjectsConfigs.length === 1) {
            popupScope.pickShareObjectConfig(amontShareObjectsConfigs[0]);
          } else {
            // Sinon, ouverture d'une popup de selection
            ngDialog.open({
              template: 'js/XG/modules/edit/views/rules/rulesPopup/popupSelectShareObjectConfig.html',
              className: 'width400 ngdialog-theme-plain miniclose nopadding',
              closeByDocument: false,
              showClose: false,
              scope: popupScope
            });
          }
        };


        /**
         * Selection de la configuration de l'objet à créer en aval, et continuation du traitement
         */
        const selectAvalShareObjectConfigAndContinue = () => {
          // Vérification qu'un ponctuel d'un des types configuré n'est pas déjà présent
          if (isOneShareObjectAlreadyInCurrentEdit(avalShareObjectsConfigs)) {
            deferred.resolve();
            return;
          }
          // Scope à utiliser pour la popup de sélection du type de feature à créer
          let popupScope = $rootScope.$new(true);
          popupScope.resetBizEdiWidget = resetBizEdiWidget;
          popupScope.shareObjectConfigs = enrichShareObjectConfigsWithAlias(avalShareObjectsConfigs);
          popupScope.stepForPopupTitle = 'Aval';
          // Fonction de sélection du type de feature à créer
          popupScope.pickShareObjectConfig = (shareObjectConfig) => {
            if (!isShareObjectAlreadyInCurrentEdit(shareObjectConfig)) {
              createObject(shareObjectConfig, linearGeometry.getLastCoordinate());
              // Le traitement est terminé
              deferred.resolve();
            }
          };
          // Si une seule configuration possible, on la choisi automatiquement
          if (avalShareObjectsConfigs.length === 1) {
            popupScope.pickShareObjectConfig(avalShareObjectsConfigs[0]);
          } else {
            // Sinon, ouverture d'une popup de selection
            ngDialog.open({
              template: 'js/XG/modules/edit/views/rules/rulesPopup/popupSelectShareObjectConfig.html',
              className: 'width400 ngdialog-theme-plain miniclose nopadding',
              closeByDocument: false,
              showClose: false,
              scope: popupScope
            });
          }
        };


        // Détection d'une ancienne configuration
        if (angular.isUndefined(amontShareObjectsConfigs) && angular.isUndefined(avalShareObjectsConfigs)
         && ((ruleConf.parameters.amont && ruleConf.parameters.amont.isAmont)
                || (ruleConf.parameters.amont && ruleConf.parameters.amont.isAval))) {
          // AMONT
          const amontConfig = ruleConf.parameters ? ruleConf.parameters.amont : undefined;
          if (angular.isDefined(amontConfig) && amontConfig.isAmont && !isShareObjectAlreadyInCurrentEdit(amontConfig)) {
            createObject(amontConfig, linearGeometry.getFirstCoordinate());
          }
          // AVAL
          const avalConfig = ruleConf.parameters ? ruleConf.parameters.aval : undefined;
          if (angular.isDefined(avalConfig) && avalConfig.isAval && !isShareObjectAlreadyInCurrentEdit(avalConfig)) {
            createObject(avalConfig, linearGeometry.getLastCoordinate());
          }
          deferred.resolve();
        }
        // Avec nouvelle configuration
        else {
          // Selection de la configuration (type d'objet / nom de l'objet partagé) du ponctuel créé
          if (amontShareObjectsConfigs && amontShareObjectsConfigs.length > 0) {
            selectAmontShareObjectConfigAndContinue();
          }
          else
          if (avalShareObjectsConfigs && avalShareObjectsConfigs.length !== 0) {
            selectAvalShareObjectConfigAndContinue();
          }
          else {
            //-- Juste pour le cas où, et éviter de bloquer les régles
            deferred.resolve();
          }
        }

        return deferred.promise;
      }


      /**
       * Affectation d'une valeur d'attribut à l'objet principal.
       * @param {type} editdescription
       * @param {type} ruleConf
       * @param {type} featureType
       * @param {type} map
       * @returns {$q@call;defer.promise}
       */
      function setAttribute(editdescription, ruleConf, featureType, map) {
        var deferred = $q.defer();
        //Nom de l'attribut de l'objet principal à compléter
        var targetFieldName = ruleConf.parameters['targetField'];

        //Nom de l'objet partagé
        var shareObjectName = ruleConf.parameters['dataSource']['sourceName'];
        //layers auxquelles peut appartenir l'objet partagé.
        var layers = ruleConf.parameters['dataSource']['layers'];

        //Récupération de l'objet partagé, source de données pour compléter la valeur d'attribut de l'objet principal.
        var featureSource = undefined;
        var sourceFieldName = undefined;
        for (var i = 0; i < editdescription.shareObjects.length; i++) {
          if (editdescription.shareObjects[i].shareObject == shareObjectName) {
            featureSource = editdescription.shareObjects[i].feature;
            //Recherche de la layer correspondante à l'objet partagé, pour récupérer le bon nom d'attribut de l'objet partagé.
            for (var j = 0; j < layers.length; j++) {
              var layerName = layers[j].layer;
              if (layerName == editdescription.shareObjects[i].fti.name) {
                sourceFieldName = layers[j].field;
                break;
              }
            }
            break;
          }
        }
        if (featureSource != undefined) {
          //Affectation de la valeur attributaire de l'objet principal
          var newValue = featureSource.getProperties()[sourceFieldName];
          var newProperty = {};
          newProperty[targetFieldName] = newValue;
          editdescription.editedfeature.setProperties(newProperty);
          if (editdescription.relatedfeatures.length > 0) {
            editdescription.relatedfeatures.map(function(feat) {
              if (
                feat.feature.getId() != undefined &&
                feat.feature.getId().split('.')[0] === editdescription.fti.name
              ) {
                feat.feature.setProperties(newProperty);
              }
            });
          }
        } else {
          console.error(
            'Règle setAttribute n\'a pas trouvé l\'objet partagé ' +
              shareObjectName +
              ', impossible d\'affecter la valeur d\'attribut ' +
              targetFieldName +
              ' à l\'objet ' +
              editdescription.fti.name
          );
        }

        deferred.resolve('terminé !');
        return deferred.promise;
      }

      /**
       * Sets a default value to the target attribute of the edited object
       * @param {type} editdescription
       * @param {type} ruleConf
       * @param {type} featureType
       * @param {type} map
       * @returns {$q@call;defer.promise}
       */
      function setDefaultValue(editdescription, ruleConf, featureType, map) {
        var deferred = $q.defer();

        var targetFieldName = ruleConf.parameters['targetField'];
        var defaultValue = ruleConf.parameters['defaultValue'];
        var properties = editdescription.editedfeature.getProperties();
        if (angular.isUndefined(properties[targetFieldName])) {
          var propertyToSet = {};
          let parsedValue = parseValue(
            editdescription,
            targetFieldName,
            defaultValue
          );
          if (angular.isDefined(parsedValue)) {
            propertyToSet[targetFieldName] = parsedValue;
          }
          editdescription.editedfeature.setProperties(propertyToSet);
        }

        deferred.resolve('terminé !');
        return deferred.promise;
      }

      function parseValue(editdescription, attributeName, valueToParse) {
        let targetAttribute = editdescription.fti.attributes.filter(
          attribute => attribute.name === attributeName
        );
        if (targetAttribute.length > 0) {
          let attributeType = targetAttribute[0].type;
          if (angular.isDefined(attributeType)) {
            if (
              attributeType === 'java.lang.Integer' ||
              attributeType === 'java.lang.Long'
            ) {
              let valueAsInt = parseInt(valueToParse);
              if (!isNaN(valueAsInt)) {
                return valueAsInt;
              } else {
                return undefined;
              }
            }
            if (
              attributeType === 'java.lang.Double' ||
              attributeType === 'java.math.BigDecimal' ||
              attributeType === 'java.lang.Float'
            ) {
              let valueAsFloat = parseFloat(valueToParse);
              if (!isNaN(valueAsFloat)) {
                return valueAsFloat;
              } else {
                return undefined;
              }
            }
          }
        }
        return valueToParse;
      }

      function showErrorMsg() {
        require('toastr').warning(
          $filter('translate')('rulecfg.setattributebyformula.error_msg')
        );
      }

      function doFormulaCalculation(formula, propertyToSet, targetFieldName, featureType, targetFieldVariable) {
        try {
          let calculatedFormula =
            math.eval(formula.join('').toString()).toFixed(2) * 1;
          if (Number.isFinite(calculatedFormula)) {
            if (targetFieldVariable) {
              featureType.rulesVariables = featureType.rulesVariables || {};
              featureType.rulesVariables[targetFieldVariable] = calculatedFormula;
            } else {
              propertyToSet[targetFieldName] = calculatedFormula;
            }
          } else {
            showErrorMsg();
          }
        } catch (e) {
          showErrorMsg();
        }
      }

      function addMessage(
        editdescription,
        targetField,
        new_value,
        old_value,
        ruleId
      ) {
        if (old_value == new_value) {
          return;
        }
        let message = {
          attribute: targetField,
          old_value: old_value,
          new_value: new_value,
          ruleId: ruleId,
        };

        if (editdescription.messages) {
          let attrIsPressent = false;
          editdescription.messages.forEach(function(msg) {
            if (msg.attribute === targetField) {
              msg.new_value = new_value;
              attrIsPressent = true;
            }
          });
          if (!attrIsPressent) {
            editdescription.messages.push(message);
          }
        } else {
          let messages = [];
          messages.push(message);
          editdescription.messages = messages;
        }
      }

      function getAlreadyCaculatedValue(editdescription, item) {
        let alreadyCalc = false;
        let calcValue;
        if (editdescription.messages) {
          editdescription.messages.forEach(function(msg) {
            if (item === msg.attribute) {
              alreadyCalc = true;
              calcValue = msg.new_value;
            }
          });
        }
        if (alreadyCalc) {
          return calcValue;
        } else {
          return false;
        }
      }

      function setCalculatedProperty(
        deferred,
        editdescription,
        properties,
        propertyToSet,
        targetFieldName,
        ruleId
      ) {
        if (
          properties[targetFieldName] &&
          propertyToSet[targetFieldName] &&
          propertyToSet[targetFieldName] !== properties[targetFieldName]
        ) {
          // add message to show in confirmation dialog
          addMessage(
            editdescription,
            targetFieldName,
            propertyToSet[targetFieldName],
            properties[targetFieldName],
            ruleId
          );
        } else {
          editdescription.editedfeature.setProperties(propertyToSet);
        }
        deferred.resolve('terminé !');
      }

      function setAttributeByFormula(
        editdescription,
        ruleConf,
        featureType,
        map
      ) {
        var deferred = $q.defer();
        const targetFieldName = ruleConf.parameters['targetField'];
        const targetFieldVariable = ruleConf.parameters['variableName'];
        cleanupMessages(ruleConf.id, editdescription.messages);

        if (targetFieldName || (!targetFieldName && targetFieldVariable)) {
          var formula = [];
          var propertyToSet = {};
          var validFormula = true;
          var properties = editdescription.editedfeature.getProperties();

          ruleConf.parameters.formula.numerotation.parts.forEach(function(
            item
          ) {
            switch (item.key) {
              case 'attribut':
                let alreadyCalc = getAlreadyCaculatedValue(
                  editdescription,
                  item.format
                );
                if (alreadyCalc || alreadyCalc === 0) {
                  formula.push(alreadyCalc);
                } else {
                  if (!angular.isUndefined(properties[item.format])) {
                    formula.push(properties[item.format]);
                  } else {
                    validFormula = false;
                  }
                }
                break;
              case 'operator':
                if (item.format === '√') {
                  formula.push('sqrt');
                } else {
                  formula.push(item.format);
                }
                break;
              case 'variable':
                if (featureType.rulesVariables && featureType.rulesVariables[item.format]) {
                  formula.push(featureType.rulesVariables[item.format]);
                }
                break;
              case 'value':
                formula.push(item.format);
                break;
            }
          });
          if (validFormula) {
            if (!window.math) {
              gaJsGeneral.loadScript('lib/mathjs/mathjs.min.js').then(() => {
                doFormulaCalculation(formula, propertyToSet, targetFieldName, featureType, targetFieldVariable);
                setCalculatedProperty(
                  deferred,
                  editdescription,
                  properties,
                  propertyToSet,
                  targetFieldName,
                  ruleConf.id
                );
              });
            } else {
              doFormulaCalculation(formula, propertyToSet, targetFieldName, featureType, targetFieldVariable);
              setCalculatedProperty(
                deferred,
                editdescription,
                properties,
                propertyToSet,
                targetFieldName,
                ruleConf.id
              );
            }
          } else {
            showErrorMsg();
            deferred.resolve('terminé avec erreur !');
          }
        } else {
          showErrorMsg();
          deferred.resolve('terminé avec erreur !');
        }
        return deferred.promise;
      }

      function setAttributeByConcat(
        editdescription,
        ruleConf,
        featureType,
        map
      ) {
        cleanupMessages(ruleConf.id, editdescription.messages);
        var deferred = $q.defer();
        var targetFieldName = ruleConf.parameters['targetField'];

        if (targetFieldName) {
          var propertyToSet = {};
          var properties = editdescription.editedfeature.getProperties();

          // collect the valid values in an array of pairs [value, isSeparator]
          var formulaItems = [];
          ruleConf.parameters.formula.numerotation.parts.forEach(function(
            item
          ) {
            if (item.key === 'attribut') {
              let alreadyCalc = getAlreadyCaculatedValue(
                editdescription,
                item.format
              );
              if (properties[item.format]) {
                if (alreadyCalc || alreadyCalc === 0) {
                  formulaItems.push([alreadyCalc, false]);
                } else {
                  formulaItems.push([properties[item.format], false]);
                }
              }
            } else if (item.key === 'fid') {
              let featureId = editdescription.editedfeature
                .getId()
                .substring(
                  editdescription.editedfeature.getId().lastIndexOf('.') + 1
                );
              formulaItems.push([featureId, false]);
            } else if (item.key === 'variable') {
              if (featureType && featureType.rulesVariables && featureType.rulesVariables[item.format]) {
                formulaItems.push([featureType.rulesVariables[item.format], false]);
              }
            } else {
              formulaItems.push([item.format, item.key === 'separator']);
            }
          });
          // remove the leading separators
          while (getSecondElement(formulaItems[0])) {
            formulaItems.shift();
          }
          // remove the trailing separators
          while (getSecondElement(formulaItems[formulaItems.length - 1])) {
            formulaItems.pop();
          }
          // collect the final concatenation items while removing the extra separators
          var formula = [];
          var canAddSep = false;
          formulaItems.forEach(function(item) {
            if (item[1]) {
              if (canAddSep) {
                canAddSep = false;
                formula.push(item[0]);
              }
            } else {
              canAddSep = true;
              formula.push(item[0]);
            }
          });
          // set the concatenation result to the target field
          propertyToSet[targetFieldName] = formula.join('').toString();

          if (
            properties[targetFieldName] &&
            propertyToSet[targetFieldName] &&
            propertyToSet[targetFieldName] !== properties[targetFieldName] &&
            ruleConf.type === 'OnPostValidation'
          ) {
            addMessage(
              editdescription,
              targetFieldName,
              propertyToSet[targetFieldName],
              properties[targetFieldName],
              ruleConf.id
            );
          } else {
            editdescription.editedfeature.setProperties(propertyToSet);
            editdescription.performUpdateOnPostsaving = ruleConf.type === 'PostSave';
          }
        }

        deferred.resolve(propertyToSet);
        return deferred.promise;
      }

      function cleanupMessages(ruleId, messages) {
        if (messages && messages.length) {
          messages.forEach(message => {
            if (message.ruleId === ruleId) {
              messages.splice(messages.indexOf(message), 1);
            }
          });
        }
      }

      /**
       * Affectation d'une valeur d'attribut à un objet partagé.
       * @param {type} editdescription
       * @param {type} ruleConf
       * @param {type} featureType
       * @param {type} map
       * @returns {$q@call;defer.promise}
       */
      function setRemoteAttribute(editdescription, ruleConf, featureType, map) {
        let fieldName;
        var deferred = $q.defer();
        //Récupération de la source de données
        var dataSource = ruleConf['parameters']['dataSource'];
        //Valeur de l'attribut à affecter
        var valueToSet = undefined;
        //Si la source de donnnées est l'objet principal édité
        if (dataSource['type'] == 'mainObject') {
          fieldName = ruleConf['parameters']['dataSource']['field'];
          valueToSet = editdescription.editedfeature.get(fieldName);
        }
        //Si la source de données est un objet partagé
        else if (dataSource['type'] == 'shareObject') {
          var shareObjectName = dataSource['shareObjectName'];
          fieldName = dataSource['field'];
          for (var i = 0; i < editdescription.shareObjects.length; i++) {
            if (
              editdescription.shareObjects[i].shareObject == shareObjectName
            ) {
              valueToSet = editdescription.shareObjects[i].feature.get(
                fieldName
              );
              break;
            }
          }
        }
        //Affectation de la valeur dans le(s) objet(s) cible(s)
        var targetObjects = ruleConf.parameters['targets'];
        //Pour chaque objet cible
        for (var j = 0; j < targetObjects.length; j++) {
          //Nom de l'objet cible
          var shareObjectName = targetObjects[j]['shareObjectName'];
          //Recherche de l'objet cible parmi les objets partagés
          for (var k = 0; k < editdescription.shareObjects.length; k++) {
            if (
              editdescription.shareObjects[k].shareObject == shareObjectName
            ) {
              var targetfeature = editdescription.shareObjects[k].feature;
              var newProperty = {};
              var targetField = targetObjects[j]['field'];
              newProperty[targetField] = valueToSet;
              targetfeature.setProperties(newProperty);

              if (editdescription.relatedfeatures.length > 0) {
                editdescription.relatedfeatures.map(function(feat) {
                  if (
                    feat.feature.getId() != undefined &&
                    feat.feature.getId().split('.')[0] ===
                      editdescription.fti.name
                  ) {
                    feat.feature.setProperties(newProperty);
                  }
                });
              }

              //Si l'objet partagé n'est pas present dans le tableau des features liés à sauvegarder, alors ajout de celui-ci.
              if (
                !isObjectInRelatedFeatures(
                  editdescription.shareObjects[k].shareObject,
                  editdescription
                )
              ) {
                editdescription.relatedfeatures.push(
                  editdescription.shareObjects[k]
                );
              }
              break;
            }
          }
        }

        deferred.resolve('terminé !');
        return deferred.promise;
      }

      function verifZoneSaisie(editdescription, ruleConf, featureType, map) {
        var deferred = $q.defer();
        var promises = [deferred.promise];
        //console.log(ruleConf);
        var editedgeom = editdescription.editedfeature.getGeometry();
        var wktStr = new ol.format.WKT().writeGeometry(editedgeom);
        //-- Uid du composant zone interdite.
        var uid = ruleConf.parameters.component.uid;

        //var uid = ruleConf.parameters.component.uid;
        var cql_filter = 'INTERSECTS(geom, ' + wktStr + ')';
        var clauseWhere = ruleConf.parameters.clauseWhere;
        var message = ruleConf.parameters.message;
        var promise;
        if (clauseWhere != '' && clauseWhere != undefined) {
          promise = ogcFactory.getfeatures(
            'GetFeature',
            'WFS',
            '1.0.0',
            uid,
            'json',
            map
              .getView()
              .getProjection()
              .getCode(),
            cql_filter + ' AND ' + clauseWhere
          );
        } else {
          promise = ogcFactory.getfeatures(
            'GetFeature',
            'WFS',
            '1.0.0',
            uid,
            'json',
            map
              .getView()
              .getProjection()
              .getCode(),
            cql_filter
          );
        }
        promise.then(
          function(res) {
            console.log(res.data);
            if (ruleConf.parameters.strict == undefined) {
              ruleConf.parameters.strict = false;
            }
            if (
              res.data.features.length > 0 &&
              ruleConf.parameters.strict == true
            ) {
              //console.log(ruleConf.parameters.component);
              $timeout(function() {
                swal(
                  {
                    title: message,
                    //text: "You will not be able to recover this imaginary file!",
                    type: 'warning',
                    showCancelButton: false,
                    confirmButtonColor: '#DD6B55',
                    confirmButtonText: 'ok',
                    //cancelButtonText: $filter('translate')('common.no'),
                    closeOnConfirm: true,
                  },
                  function(isConfirm) {}
                );
                deferred.reject(message);
                return deferred.promise;
              }, 700);

              //deferred.reject(message);
              //return deferred.promise;
            } else if (
              res.data.features.length > 0 &&
              ruleConf.parameters.strict == false
            ) {
              swal(
                {
                  //title:"<div> message </div> <br/>> <div>Voulez vous continuer?</div>",
                  title: message,
                  text: 'Voulez vous continuer?',
                  //text: "You will not be able to recover this imaginary file!",
                  type: 'warning',
                  showCancelButton: true,
                  confirmButtonColor: '#DD6B55',
                  confirmButtonText: $filter('translate')('common.yes'),
                  cancelButtonText: $filter('translate')('common.no'),
                  closeOnConfirm: true,
                },
                function(isConfirm) {
                  if (isConfirm) {
                    deferred.resolve('terminé !');
                    return deferred.promise;
                  } else {
                    deferred.reject(message);
                    return deferred.promise;
                  }
                }
              );
            } else {
              deferred.resolve('terminé !');
              return deferred.promise;
            }
          },
          function(error) {}
        );
        promises.push(promise);
        //deferred.resolve("terminé !");
        return $q.all(promises);
      }

      /**
       * Récupére les objets intersectant l'amont et / ou l'aval de l'objet lineaire principal en cours d'édition.
       * @param {type} editdescription
       * @param {type} ruleConf
       * @param {type} featureType
       * @param {type} map
       * @returns {undefined}
       */
      function getFeaturesIntersectingLine(
        editdescription,
        ruleConf,
        featureType,
        map
      ) {
        //var deferred = $q.defer();
        if (featureType.typeInfo != 'LINE') {
          console.error(
            'Règle getFeaturesIntersectingLine non adaptée à la couche ' +
              featureType.name
          );
          var deferred = $q.defer();
          deferred.resolve('terminé !');
          return deferred.promise;
        }

        //Récupération de la configuration de la règle: config des  objets partagés
        var cfgUpShareObjects = ruleConf.parameters['amont']['shareObjects'];
        var cfgDownShareObjects = ruleConf.parameters['aval']['shareObjects'];

        //Si pas de config
        if (
          (cfgUpShareObjects == undefined &&
            !Array.isArray(cfgUpShareObjects)) ||
          (cfgDownShareObjects == undefined &&
            !Array.isArray(cfgDownShareObjects))
        ) {
          console.error(
            'Règle getFeaturesIntersectingLine mal ou pas configurée pour la couche ' +
              featureType.name
          );
          var deferred = $q.defer();
          deferred.resolve('terminé !');
          return deferred.promise;
        }

        var layers = gclayers.getOperationalLayer();

        // Recherche et ajoute les features appartenant aux layers dont le nom est contenu dans cfgShareObjects en paramètre,
        // et intersectant les coordonées en paramètre.
        function searchIntersections(cfgShareObjects, pointCoordinate) {
          var promises = [];
          var leftX = pointCoordinate[0] - 0.2;
          var bottomY = pointCoordinate[1] - 0.2;
          var rightX = pointCoordinate[0] + 0.2;
          var topY = pointCoordinate[1] + 0.2;
          var cql_filter =
            'INTERSECTS(geom, POLYGON((' +
            leftX +
            ' ' +
            bottomY +
            ',' +
            rightX +
            ' ' +
            bottomY +
            ',' +
            rightX +
            ' ' +
            topY +
            ',' +
            leftX +
            ' ' +
            topY +
            ',' +
            leftX +
            ' ' +
            bottomY +
            ')))';

          for (var j = 0; j < cfgShareObjects.length; j++) {
            var cfgShareObj = cfgShareObjects[j];
            var l = getLayerByName(cfgShareObj.layerName, layers);
            if (l == undefined) {
              continue;
            }

            //La requete d'intersection de pointCoordinate avec les objets de la couche cfgShareObj.layerName.
            var promise = ogcFactory.getfeatures(
              'GetFeature',
              'WFS',
              '1.0.0',
              l.fti.uid,
              'json',
              map
                .getView()
                .getProjection()
                .getCode(),
              cql_filter
            );
            //Reponse.
            var callBackSuccess = getCallbackSuccess(cfgShareObj, l);
            //promise2 sera resolue lorsque la callback aura finie d'être executée (car elle ne renvoie pas de promesse)
            var promise2 = promise.then(callBackSuccess, function(error) {
              console.error(
                'Erreur à l\'appel de  ogc.data(),avec la couche:' +
                  l.name +
                  'cql_filter:' +
                  cql_filter
              );
            });
            promises.push(promise2);
          }
          return promises;
        }

        /**
         * Appelée lors du résultat de la requete de feature
         * @param {type} cfgShareObj
         * @param {type} layer
         * @returns {Function}
         */
        function getCallbackSuccess(cfgShareObj, layer) {
          return function(result) {
            var intersectedFeatures = format.readFeatures(result.data);
            if (
              intersectedFeatures != undefined &&
              intersectedFeatures.length > 0
            ) {
              addShareObject(intersectedFeatures, cfgShareObj.name, layer);
            }
          };
        }

        function addShareObject(intersectedFeatures, shareObjectName, layer) {
          for (const intersectedFeature of intersectedFeatures) {
            editdescription.shareObjects.push(
              {
                shareObject: shareObjectName,
                editType: EditTypesFactory.editTypes.updateattributes.name,
                feature: intersectedFeature,
                fti: layer.fti,
              }
            );
          }
        }

        var editedgeom = editdescription.editedfeature.getGeometry();
        var upHillpointCoordinate = editedgeom.getFirstCoordinate();
        var downHillpointCoordinate = editedgeom.getLastCoordinate();

        //Récupération des objets intersectés en amont
        var upHillpromises = searchIntersections(
          cfgUpShareObjects,
          upHillpointCoordinate
        );
        //Récupération des objets intersectés en aval
        var downHillpromises = searchIntersections(
          cfgDownShareObjects,
          downHillpointCoordinate
        );
        //Crée une promesse qui sera résolue lorsque toutes les promesses du tableau seront résolues;
        //la valeur de résolution est un tableau contenant les valeurs des différentes promesses en paramètre.
        return $q.all(upHillpromises.concat(downHillpromises));
      }

      /**
       * Récupère les objets portés par les objets linéaires édités (modification ou suppression).
       * Chaque objet relatedFeature dans le tableau des relatedfeatures comportera aussi un tableau shareObjects
       * representant les objets partagés par les règles lors du traitement de l'objet relatedfeature par la présente règle.
       * @param {type} editdescription
       * @param {type} ruleConf
       * @param {type} featureType
       * @param {type} map
       * @returns {$q@call;defer.promise}
       */
      function getAllFeaturesIntersectingLine(
        editdescription,
        ruleConf,
        featureType,
        map
      ) {
        var deferred = $q.defer();
        if (featureType.typeInfo != 'LINE') {
          console.error(
            'Règle getAllFeaturesIntersectingLine non adaptée à la couche ' +
              featureType.name
          );
          deferred.resolve('terminé !');
          return deferred.promise;
        }

        //Récupération de la configuration de la règle: config des  objets partagés
        var cfgUpShareObjects = ruleConf.parameters['shareObjects'];

        //Si pas de config
        if (
          cfgUpShareObjects == undefined &&
          !Array.isArray(cfgUpShareObjects)
        ) {
          console.error(
            'Règle getAllFeaturesIntersectingLine mal ou pas configurée pour la couche ' +
              featureType.name
          );
          deferred.resolve('terminé !');
          return deferred.promise;
        }

        var layers = gclayers.getOperationalLayer();

        // Recherche et ajoute les features appartenant aux layers dont le nom est contenu dans cfgShareObjects en paramètre,
        // et intersectant les coordonées en paramètre.
        function searchIntersections(
          cfgShareObjects,
          featureLine,
          currenteditdescription
        ) {
          var lineGeom = featureLine.getGeometry();
          var geoJson = format.writeGeometryObject(lineGeom);

          //Buffer de la geometrie de l'objet ligne courant.
          var firstPromise = GeometryFactory.buffer(geoJson, 'ROUND', 1);

          //Une fois le buffer de l'objet ligne effectué, on peut rechercher les intersections.
          var mainPromise = firstPromise.then(
            function(res) {
              var polygon = res.data;
              //-- Retourne la promesse du travail d'intersection.
              return requestIntersections(polygon);
            },
            function(error) {
              console.error(
                'Erreur lors de la requete de bufferisation de l\'objet édité line de la couche ' +
                  currenteditdescription.fti.name
              );
              //Fin de la méthode de la recherche d'intesection pour l'objet édité featureLine (résolution de la mainPromise)
              return undefined;
            }
          );

          /**
           * Recherche sur chaque layer d'intersection configurée les
           * features intersectant la ligne édité buferisé 'polygon' passé en paramètre de cette méthode.
           * @param {type} polygon
           * @returns {$q@call;defer.promise}
           */
          function requestIntersections(polygon) {
            var promises = [];

            var lineCoordsString2 = '';

            if (polygon.type == 'Polygon') {
              var polygonGeom = format.readGeometry(polygon);
              angular.forEach(polygonGeom.getLinearRings(), function(
                linearRing,
                key
              ) {
                var coords = linearRing.getCoordinates();
                lineCoordsString2 += '(';
                angular.forEach(coords, function(value, key) {
                  lineCoordsString2 += value[0] + ' ' + value[1] + ',';
                });
                lineCoordsString2 = lineCoordsString2.substring(
                  0,
                  lineCoordsString2.length - 1
                );
                lineCoordsString2 += ')';
              });
            } else {
              var deferred = $q.defer();
              console.error(
                'Règle getAllFeaturesIntersectingLine featureLine after buffer operation is not a Polygon !'
              );
              deferred.resolve('terminé !');
              return deferred.promise;
            }

            var cql_filter =
              'INTERSECTS(geom, Polygon(' + lineCoordsString2 + '))';

            //Pour chaque layer d'intersection configurée
            for (var j = 0; j < cfgShareObjects.length; j++) {
              //configuration de la layer sur laquelle on souhaite rechercher les intersections.
              var cfgShareObj = cfgShareObjects[j];
              var l = getLayerByName(cfgShareObj.layerName, layers);
              if (l == undefined) {
                continue;
              }

              //Préparation du traitement de la Reponse.
              var callBackSuccess = getCallbackSuccess(
                cfgShareObj,
                l,
                currenteditdescription
              );

              //La requete d'intersection de la featureLine avec les objets de la couche cfgShareObj.layerName.
              var promise = ogcFactory.getfeatures(
                'GetFeature',
                'WFS',
                '1.0.0',
                l.fti.uid,
                'json',
                map
                  .getView()
                  .getProjection()
                  .getCode(),
                cql_filter
              );

              //promise2 sera resolue lorsque la callback aura fini d'être executée (car elle ne renvoie pas de promesse)
              var promise2 = promise.then(callBackSuccess, function(error) {
                console.error(
                  'Erreur à l\'appel de ogc.data(), avec la couche:' +
                    l.name +
                    'cql_filter:' +
                    cql_filter
                );
              });
              promises.push(promise2);
            }
            return $q.all(promises);
          }

          return mainPromise;
        }

        /**
         * Renvoie la méthode qui sera appelé lors de la réponse à la recherche de feature intersecté (ogcFactory.getfeatures)
         * @param {type} cfgShareObj
         * @param {type} layer
         * @param {type} currenteditdescription
         * @returns {Function}
         */
        function getCallbackSuccess(
          cfgShareObj,
          layer,
          currenteditdescription
        ) {
          return function(result) {
            var intersectedFeatures = format.readFeatures(result.data);
            if (
              intersectedFeatures != undefined &&
              intersectedFeatures.length > 0
            ) {
              addShareObject(
                intersectedFeatures,
                cfgShareObj.name,
                layer,
                currenteditdescription
              );
            }
          };
        }

        function addShareObject(
          intersectedFeatures,
          shareObjectName,
          layer,
          currenteditdescription
        ) {
          angular.forEach(intersectedFeatures, function(
            aFeatureintersected,
            key
          ) {
            var newObject = {
              shareObject: shareObjectName,
              editType: EditTypesFactory.editTypes.updateattributes.name,
              feature: aFeatureintersected,
              fti: layer.fti,
            };
            if (currenteditdescription.shareObjects == undefined) {
              currenteditdescription.shareObjects = [];
            }
            currenteditdescription.shareObjects.push(newObject);
          });
        }

        //Pour la ligne principale
        //Récupération des objets intersectés par le point.
        var promises = searchIntersections(
          cfgUpShareObjects,
          editdescription.editedfeature,
          editdescription
        );

        //Pour les Les AUTRES lignes éditées (édition multiple de lignesgetAllFeaturesIntersectingLinedelete)
        //Index de l'objet secondaire édité
        var relatedfeaturesIndex = 0;
        //on mémorise le nombre initial d'objets secondaires car on va au cours de l'execution possiblement alimenter ce tableau.
        //Si la règle ajoutait de nouveaux objets et que l'on voulait prendre en compte ces nouveaux objets,
        //on aurait comparé 'relatedfeaturesIndex' à 'editdescription.relatedfeatures.length' dans treatNextLineObject().
        var nbRelatedFeature = editdescription.relatedfeatures.length;

        function treatNextLineObject() {
          if (relatedfeaturesIndex < nbRelatedFeature) {
            var related = editdescription.relatedfeatures[relatedfeaturesIndex];
            if (
              related.editType == editdescription.editType &&
              related.fti.name == editdescription.fti.name
            ) {
              var anOtherpromises = searchIntersections(
                cfgUpShareObjects,
                related.feature,
                related
              );
              anOtherpromises.then(
                function(res) {
                  relatedfeaturesIndex++;
                  treatNextLineObject();
                },
                function(error) {
                  relatedfeaturesIndex++;
                  treatNextLineObject();
                }
              );
            } else {
              relatedfeaturesIndex++;
              treatNextLineObject();
            }
          }
          //si fin du parcours des objets
          else {
            deferred.resolve('rule end !');
          }
        }

        treatNextLineObject();

        //Crée une promesse qui sera résolue lorsque toutes les promesses du tableau seront résolues;
        //la valeur de résolution est un tableau contenant les valeurs des différentes promesses en paramètre.
        return $q.all([promises, deferred.promise]);
      }

      /**
       * Récupére les objets intersectant l'objet ponctuel principal en cours d'édition.
       * @param {type} editdescription
       * @param {type} ruleConf
       * @param {type} featureType
       * @param {type} map
       * @returns {undefined}
       */
      function getFeaturesIntersectingPoint(
        editdescription,
        ruleConf,
        featureType,
        map
      ) {
        //var deferred = $q.defer();
        if (featureType.typeInfo != 'POINT') {
          console.error(
            'Règle getFeaturesIntersectingPoint non adaptée à la couche ' +
              featureType.name
          );
          var deferred = $q.defer();
          deferred.resolve('terminé !');
          return deferred.promise;
        }

        //Récupération de l'objet configuration.
        var cfgUpShareObjects = ruleConf.parameters['shareObjects'];

        //Si pas de config.
        if (
          cfgUpShareObjects == undefined &&
          !Array.isArray(cfgUpShareObjects)
        ) {
          console.error(
            'Règle getFeaturesIntersectingPoint mal ou pas configurée pour la couche ' +
              featureType.name
          );
          var deferred = $q.defer();
          deferred.resolve('terminé !');
          return deferred.promise;
        }

        var layers = gclayers.getOperationalLayer();

        // Recherche et ajoute les features appartenant aux layers dont le nom est contenu dans cfgShareObjects en paramètre,
        // et intersectant les coordonées en paramètre.
        function searchIntersections(cfgShareObjects, pointCoordinate) {
          var promises = [];

          const leftX = Number.parseFloat(pointCoordinate[0]) - 0.05;
          const bottomY = Number.parseFloat(pointCoordinate[1]) - 0.05;
          const rightX = Number.parseFloat(pointCoordinate[0]) + 0.05;
          const topY = Number.parseFloat(pointCoordinate[1]) + 0.05;
          var cql_filter =
            'INTERSECTS(geom, POLYGON((' +
            leftX +
            ' ' +
            bottomY +
            ',' +
            rightX +
            ' ' +
            bottomY +
            ',' +
            rightX +
            ' ' +
            topY +
            ',' +
            leftX +
            ' ' +
            topY +
            ',' +
            leftX +
            ' ' +
            bottomY +
            ')))';
          //var cql_filter = "INTERSECTS(geom,Point("+pointCoordinate[0]+' '")";

          for (var j = 0; j < cfgShareObjects.length; j++) {
            var cfgShareObj = cfgShareObjects[j];
            var l = getLayerByName(cfgShareObj.layerName, layers);
            if (l == undefined) {
              continue;
            }

            //La requete d'intersection de pointCoordinate avec les objets de la couche cfgShareObj.layerName.
            var promise = ogcFactory.getfeatures(
              'GetFeature',
              'WFS',
              '1.0.0',
              l.fti.uid,
              'json',
              map
                .getView()
                .getProjection()
                .getCode(),
              cql_filter
            );
            //Reponse.
            var callBackSuccess = getCallbackSuccess(cfgShareObj, l);
            //promise2 sera resolue lorsque la callback aura finie d'être executée (car elle ne renvoie pas de promesse)
            var promise2 = promise.then(callBackSuccess, function(error) {
              console.error(
                'Erreur à l\'appel de  ogc.data(),avec la couche:' +
                  l.name +
                  'cql_filter:' +
                  cql_filter
              );
            });
            promises.push(promise2);
          }
          return promises;
        }

        /*
         * Renvoie la méthode qui sera appelée lors de la réponse à la recherche de feature intersecté (ogcFactory.getfeatures)
         * @param {type} cfgShareObj
         * @param {type} layer
         * @returns {Function}
         */
        function getCallbackSuccess(cfgShareObj, layer) {
          return function(result) {
            var intersectedFeatures = format.readFeatures(result.data);
            if (
              intersectedFeatures != undefined &&
              intersectedFeatures.length > 0
            ) {
              addShareObject(intersectedFeatures, cfgShareObj.name, layer);
            }
          };
        }

        function addShareObject(intersectedFeatures, shareObjectName, layer) {
          for (const intersectedFeature of intersectedFeatures) {
            editdescription.shareObjects.push(
              {
                shareObject: shareObjectName,
                editType: EditTypesFactory.editTypes.updateattributes.name,
                feature: intersectedFeature,
                fti: layer.fti,
              }
            );
          }
        }

        //Récupération de l'objet édité
        var editedgeom = editdescription.editedfeature.getGeometry();
        //Récupération des cooordonnées de l'objet édité.
        var coordinate = editedgeom.getCoordinates();
        //Récupération des objets intersectés par le point.
        var promises = searchIntersections(cfgUpShareObjects, coordinate);

        //Crée une promesse qui sera résolue lorsque toutes les promesses du tableau seront résolues;
        //la valeur de résolution est un tableau contenant les valeurs des différentes promesses en paramètre.
        return $q.all(promises);
      }

      /**
       * Récupére les objets intersectant l'objet ponctuel principal en cours d'édition.
       * @param {type} editdescription
       * @param {type} ruleConf
       * @param {type} featureType
       * @param {type} map
       * @returns {undefined}
       */
      const getFeatureIntersectingPolygon = (
        editdescription,
        ruleConf,
        featureType,
        map
      ) => {

        //Récupération de l'objet configuration.
        const cfgUpShareObjects = ruleConf.parameters['shareObjects'];
        if (!cfgUpShareObjects === undefined || !Array.isArray(cfgUpShareObjects)) {
          const deferred = $q.defer();
          console.error('Règle GetFeatureIntersectingPolygon mal ou pas configurée pour la couche ' +featureType.name);
          deferred.resolve();
          return deferred.promise;
        }

        const layers = gclayers.getOperationalLayer();

        // Recherche et ajoute les features appartenant aux layers dont le nom est contenu dans cfgShareObjects en paramètre,
        // et intersectant les coordonées en paramètre.
        function searchIntersections(cfgShareObjects, polygonCoordinate) {
          const intersectingFeaturesPromises = [];

          // Creation du filtre
          let cql_filter =
              'INTERSECTS(geom, POLYGON((';
          for (const coordinate of polygonCoordinate[0]) {
            cql_filter += coordinate[0] + ' ' + coordinate[1] + ',';
          }
          cql_filter = cql_filter.slice(0, cql_filter.length - 1);
          cql_filter += ')))';

          for (const cfgShareObject of cfgShareObjects) {
            const layer = getLayerByName(cfgShareObject.layerName, layers);

            const promise = ogcFactory.getfeatures(
              'GetFeature',
              'WFS',
              '1.0.0',
              layer.fti.uid,
              'json',
              map
                .getView()
                .getProjection()
                .getCode(),
              cql_filter
            );

            promise.then(
              // Succès
              result => {
                const intersectedFeatures = format.readFeatures(result.data);
                if (intersectedFeatures && intersectedFeatures.length > 0) {
                  editdescription.shareObjects.push({
                    shareObject: cfgShareObject.name,
                    editType: EditTypesFactory.editTypes.updateattributes.name,
                    feature: intersectedFeatures[0],
                    fti: layer.fti,
                  });
                }
              },
              // Echec
              () => {
                console.error('Erreur à l\'appel de ogc.data() avec la couche:' +
                      layer.name + 'cql_filter:' + cql_filter);
              }
            );
            intersectingFeaturesPromises.push(promise);
          }
          return intersectingFeaturesPromises;
        }

        //Récupération des objets intersectés par le point.
        const promises = searchIntersections(cfgUpShareObjects,
          editdescription.editedfeature.getGeometry().getCoordinates());

        //Crée une promesse qui sera résolue lorsque toutes les promesses du tableau seront résolues;
        //la valeur de résolution est un tableau contenant les valeurs des différentes promesses en paramètre.
        return $q.all(promises);
      };

      /**
       * Scinde la ligne intersectée par l'objet principal lineaire ou ponctuel.
       * Les deux objets lineraires résultant sont issus de la mise à jour de la ligne scindée d'origine pour l'un
       * et de la création d'un deuxième objet lineaire pour l'autre.
       *
       * @param {type} editdescription
       * @param {type} ruleConf
       * @param {type} featureType
       * @param {type} map
       * @returns {$q@call;defer.promise}
       */
      function cutIntersectingLine(
        editdescription,
        ruleConf,
        featureType,
        map
      ) {
        var deferred = $q.defer();

        var editedGeom = editdescription.editedfeature.getGeometry();

        /**
         * Récupére le feature partagé à partir des informations de configuration (contenant le nom de l'objet (shareObject) et le nom de la layer)
         * @param {type} cfgShareObjects
         * @returns {EditRulesProvider_L7.EditRulesProvider.$get.cutIntersectingLine.getIntersectedShareObject.EditRulesProviderAnonym$4|undefined}
         */
        function getIntersectedShareObject(cfgShareObjects) {
          for (var j = 0; j < cfgShareObjects.length; j++) {
            for (var k = 0; k < editdescription.shareObjects.length; k++) {
              if (
                editdescription.shareObjects[k].shareObject ==
                  cfgShareObjects[j].name &&
                editdescription.shareObjects[k].fti.name ==
                  cfgShareObjects[j].layerName
              ) {
                return {
                  shareObject: editdescription.shareObjects[k],
                  isHistoricize: cfgShareObjects[j].isHistoricize,
                };
              }
            }
          }
          return undefined;
        }

        /**
         * Vérifie si le feature Amont correspond aussi au feature aval , si c'est le cas cherche dans le shared feature amont le tronçon qui contient le point
         * @param {type} cfgShareObjects
         * @returns {EditRulesProvider_L7.EditRulesProvider.$get.cutIntersectingLine.getIntersectedShareObject.EditRulesProviderAnonym$4|undefined}
         */
        function UpdateIntersectedShareObjectAval(
          intersectedShareObject,
          intersectedShareObject2,
          pointCoordiantes
        ) {
          editdescription.relatedfeatures.map(function(x, i) {
            if (
              x.feature.getGeometry().getType() == 'MultiLineString' &&
              x.feature.getGeometry().getCoordinates() !== undefined &&
              getCuttingIndexOnSimpleLine(
                x.feature.getGeometry().getCoordinates()[0],
                pointCoordiantes
              ) !== undefined
            ) {
              intersectedShareObject2.shareObject.feature = x.feature.clone();
              intersectedShareObject2.shareObject.feature.setId(
                x.feature.getId()
              );
              intersectedShareObject2.shareObject.fti = angular.copy(x.fti);
              intersectedShareObject2.shareObject.editType = angular.copy(
                x.editType
              );
              editdescription.relatedfeatures.splice(i, 1);
            } else if (
              x.feature.getGeometry().getType() == 'LineString' &&
              x.feature.getGeometry().getCoordinates() !== undefined &&
              getCuttingIndexOnSimpleLine(
                x.feature.getGeometry().getCoordinates(),
                pointCoordiantes
              ) !== undefined
            ) {
              intersectedShareObject2.shareObject.feature = x.feature.clone();
              intersectedShareObject2.shareObject.feature.setId(
                x.feature.getId()
              );
              intersectedShareObject2.shareObject.fti = angular.copy(x.fti);
              intersectedShareObject2.shareObject.editType = angular.copy(
                x.editType
              );
              editdescription.relatedfeatures.splice(i, 1);
            }
          });
          return intersectedShareObject2;
        }

        /**
         * Donne l'index 'cuttingIndex' du dernier point de la simpleLine 'lineCoordinates' qui appartiendra à la première ligne issue de la scission.
         * (cuttingIndex+1 est l'index du point qui appartiendra à la deuxième ligne issue de la scission.
         * Si le point intersectionPointCoordinate est situé à une extrémité, la méthode retourne undefined.
         * @param {type} lineCoordinates
         * @param {type} intersectionPointCoordinate
         * @returns {Number}cuttingIndex
         */
        function getCuttingIndexOnSimpleLine(
          lineCoordinates,
          intersectionPointCoordinate
        ) {
          var cuttingIndex = undefined;

          //Pour chaque segment de la simple line
          for (var i = 0; i < lineCoordinates.length - 1; i++) {
            //Les deux points du segments
            var p1 = lineCoordinates[i];
            var p2 = lineCoordinates[i + 1];

            //Si le point édité est posé sur le premier point du segment ou sur le second point (x et y sont les mêmes à 1cm près)
            if (
              (Math.round(intersectionPointCoordinate[0] * 100) ==
                Math.round(p1[0] * 100) &&
                Math.round(intersectionPointCoordinate[1] * 100) ==
                  Math.round(p1[1] * 100)) ||
              (Math.round(intersectionPointCoordinate[0] * 100) ==
                Math.round(p2[0] * 100) &&
                Math.round(intersectionPointCoordinate[1] * 100) ==
                  Math.round(p2[1] * 100))
            ) {
              cuttingIndex = i;
              break;
            } else {
              //Coef directeur de la line
              var coef = (p2[1] - p1[1]) / (p2[0] - p1[0]);
              //Coef directeur de la droite intersectionPointCoordinate P1
              var coef2 =
                (intersectionPointCoordinate[1] - p1[1]) /
                (intersectionPointCoordinate[0] - p1[0]);

              //Si intersectionPoint appartient à la DROITE line correspondant au segment en cours P1P2
              if (
                Math.abs(Math.round(coef * 100)) ==
                Math.abs(Math.round(coef2 * 100))
              ) {
                //Vérification si intersectionPointCoordinate appartient au SEGMENT P1P2
                if (
                  intersectionPointCoordinate[0] <= Math.max(p1[0], p2[0]) &&
                  intersectionPointCoordinate[0] >= Math.min(p1[0], p2[0]) &&
                  intersectionPointCoordinate[1] <= Math.max(p1[1], p2[1]) &&
                  intersectionPointCoordinate[1] >= Math.min(p1[1], p2[1])
                ) {
                  cuttingIndex = i;
                  break;
                }
              }
            }
          }
          return cuttingIndex;
        }

        /**
         * Crée et enregistre les deux objets ol.Feature issus de la scission de la SimpleLine ou Multiligne 'intersectedShareObject.feature' au point de coordonnée 'intersectionPointCoordinate'.
         * @param {type} intersectionPointCoordinate
         * @param {type} intersectedShareObject
         * @returns {undefined}
         */
        function performCutting(
          intersectionPointCoordinate,
          intersectedShareObject,
          isTobeHistoricize
        ) {
          var deferred = $q.defer();
          if (intersectedShareObject != undefined) {
            var intersectedFeature = intersectedShareObject.feature;

            //Copie de l'objet qui va être scindé pour historisation eventuelle
            if (isTobeHistoricize) {
              var mainFeatureCopie = intersectedFeature.clone();
              mainFeatureCopie.setId(intersectedFeature.getId());
            }

            var line = intersectedFeature.getGeometry();

            var isSimpleLine = line instanceof ol.geom.LineString;
            var isMultiLine = line instanceof ol.geom.MultiLineString;

            //Index du segment sur lequel couper la line.
            var cuttingIndex = undefined;
            var cuttinglineIndex = undefined;

            var line1 = undefined;
            var line2 = undefined;

            var line1Length = 0;
            var line2Length = 0;

            const promisesLength = [];

            if (
              (Math.round(intersectionPointCoordinate[0] * 100) ===
                Math.round(line.getFirstCoordinate()[0] * 100) &&
                Math.round(intersectionPointCoordinate[1] * 100) ===
                  Math.round(line.getFirstCoordinate()[1] * 100)) ||
              (Math.round(intersectionPointCoordinate[0] * 100) ===
                Math.round(line.getLastCoordinate()[0] * 100) &&
                Math.round(intersectionPointCoordinate[1] * 100) ===
                  Math.round(line.getLastCoordinate()[1] * 100))
            ) {
              const featId = intersectedFeature instanceof ol.Feature ? intersectedFeature.getId() : intersectedFeature.id;
              console.info('Pas de scission possible de l\'objet intersecté id =', featId,
                  ' de la couche ', intersectedShareObject.fti.name);
              return;
            }

            if (isSimpleLine) {
              var originCoordinates = line.getCoordinates();
              cuttingIndex = getCuttingIndexOnSimpleLine(
                originCoordinates,
                intersectionPointCoordinate
              );

              if (cuttingIndex == undefined) {
                console.info(
                  'Pas de scission possible de l\'objet intersecté id=' +
                    intersectedFeature.id +
                    ' de la couche =' +
                    intersectedShareObject.fti.name
                );
                return;
              }
              //Création des deux objets lines issus de la scission.
              var coordinates1 = originCoordinates.slice(0, cuttingIndex + 1); //slice extrait jusqu'à endIndex exclu.
              coordinates1.push(intersectionPointCoordinate);
              line1 = new ol.geom.LineString(coordinates1, 'XY');

              var prom1 = getSimpleLineLength(
                line1,
                map,
                intersectedShareObject.fti
              );
              prom1.then(function(res) {
                line1Length = Math.round(res.data[0].perimeter * 100) / 100;
              });

              var coordinates2 = [intersectionPointCoordinate];
              coordinates2 = coordinates2.concat(
                originCoordinates.slice(cuttingIndex + 1)
              );
              line2 = new ol.geom.LineString(coordinates2, 'XY');

              var prom2 = getSimpleLineLength(
                line2,
                map,
                intersectedShareObject.fti
              );
              prom2.then(function(res) {
                line2Length = Math.round(res.data[0].perimeter * 100) / 100;
              });

              promisesLength.push(prom1, prom2);
            } else if (isMultiLine) {
              var simpleLines = line.getCoordinates();
              //Pour chaque simple line de la multiline
              for (
                var lineIndex = 0;
                lineIndex < simpleLines.length;
                lineIndex++
              ) {
                cuttingIndex = getCuttingIndexOnSimpleLine(
                  simpleLines[lineIndex],
                  intersectionPointCoordinate
                );
                //Si l'index du segement de la simple line a été trouvé
                if (cuttingIndex != undefined) {
                  //mémorisation de l'index de la simple line
                  cuttinglineIndex = lineIndex;
                  break;
                }
              }
              if (cuttingIndex == undefined) {
                console.info(
                  'Pas de scission possible de l\'objet intersecté id=' +
                    intersectedFeature.id +
                    ' de la couche =' +
                    intersectedShareObject.fti.name
                );
                return;
              }
              //Création des deux objets Multilines issus de la scission.

              //Premiere Multiligne:
              var multiCoordinates1 = [];

              //Récupération des simples lignes précedents celle sur laquelle se trouve la scission.
              for (
                var lineIndex2 = 0;
                lineIndex2 < cuttinglineIndex;
                lineIndex2++
              ) {
                multiCoordinates1.push(simpleLines[lineIndex2]);
              }
              //Ajout de la nouvelle simple line sur laquelle se trouve la scission (première partie de la simple line jusqu'au point d'intersection).
              var coordinates1 = simpleLines[cuttinglineIndex].slice(
                0,
                cuttingIndex + 1
              ); //slice extrait jusqu'à endIndex exclu.
              coordinates1.push(intersectionPointCoordinate);
              multiCoordinates1.push(coordinates1);

              line1 = new ol.geom.MultiLineString(multiCoordinates1, 'XY');

              //Seconde Multiligne:
              var multiCoordinates2 = [];

              //Ajout de la nouvelle simple line sur laquelle se trouve la scission (première partie de la simple line jusqu'au point d'intersection).
              var coordinates2 = [intersectionPointCoordinate];
              var lastPoints = simpleLines[cuttinglineIndex].slice(
                cuttingIndex + 1
              ); //slice extrait jusqu'à endIndex exclu.
              coordinates2 = coordinates2.concat(lastPoints);
              multiCoordinates2.push(coordinates2);

              //Récupération des simples lignes qui suivent celle sur laquelle se trouve la scission.
              for (
                var lineIndex3 = cuttinglineIndex + 1;
                lineIndex3 < simpleLines.length;
                lineIndex3++
              ) {
                multiCoordinates2.push(simpleLines[lineIndex3]);
              }

              line2 = new ol.geom.MultiLineString(multiCoordinates2, 'XY');

              angular.forEach(line1.getLineStrings(), function(value, key) {
                var prom1 = getSimpleLineLength(
                  value,
                  map,
                  intersectedShareObject.fti
                );
                prom1.then(function(res) {
                  line1Length += res.data[0].perimeter;
                });
                promisesLength.push(prom1);
              });

              angular.forEach(line2.getLineStrings(), function(value, key) {
                var prom2 = getSimpleLineLength(
                  value,
                  map,
                  intersectedShareObject.fti
                );
                prom2.then(function(res) {
                  line2Length += res.data[0].perimeter;
                });
                promisesLength.push(prom2);
              });
            }

            var majorPromise = $q.all(promisesLength);
            majorPromise.then(function() {
              line1Length = Math.round(line1Length * 100) / 100;
              line2Length = Math.round(line2Length * 100) / 100;

              //Création d'une deuxième feature ligne : deuxième objet issu de la scission.
              var newFeature = new ol.Feature({
                geometry: line2,
              });
              //Recopie des attributs dans le deuxième objet
              //Itérerer parmi les propriétés et les ajouter au nouveau Feature
              var properties = intersectedFeature.getProperties();
              var geomPropertieName = intersectedFeature.getGeometryName();
              angular.forEach(properties, function(value, key) {
                if (key != geomPropertieName) {
                  var prop = {};
                  prop[key] = value;
                  newFeature.setProperties(prop);
                }
              });
              //Mise à jour de l'attribut longueur si il a été configuré
              if (
                ruleConf.parameters['layerInfos'][
                  intersectedShareObject.fti.name
                ] != undefined &&
                ruleConf.parameters['layerInfos'][
                  intersectedShareObject.fti.name
                ]['lengthFieldName'] != undefined
              ) {
                var lengthFieldName =
                  ruleConf.parameters['layerInfos'][
                    intersectedShareObject.fti.name
                  ]['lengthFieldName'];
                var lengthProperties1 = {};
                lengthProperties1[lengthFieldName] = line1Length;
                intersectedFeature.setProperties(lengthProperties1);

                var lengthProperties2 = {};
                lengthProperties2[lengthFieldName] = line2Length;
                newFeature.setProperties(lengthProperties2);
              }

              //Mise à jour de la geometry de la feature ligne intersectée: premier objet issu de la scission.
              intersectedFeature.setGeometry(line1);

              //Visualisation et enregistrement de ces objets pour la sauvegarde:

              //Objet modifié (1ere objet issu de la scission)
              gclayers
                .getDrawLayer()
                .getSource()
                .addFeature(intersectedFeature);
              var updatedObject = {
                shareObject: '',
                editType:
                  intersectedFeature.getId() == undefined
                    ? EditTypesFactory.editTypes.add.name
                    : EditTypesFactory.editTypes.update.name,
                feature: intersectedFeature,
                fti: intersectedShareObject.fti,
              };
              editdescription.relatedfeatures.push(updatedObject);

              //Objet créé (2e objet issu de la scission)
              gclayers
                .getDrawLayer()
                .getSource()
                .addFeature(newFeature);
              var newObject = {
                shareObject: '',
                editType: EditTypesFactory.editTypes.add.name,
                feature: newFeature,
                fti: intersectedShareObject.fti,
              };
              editdescription.relatedfeatures.push(newObject);

              //Historisation eventuelle de l'objet lineaire modifié : Copie du feature
              if (isTobeHistoricize) {
                //Enregistrement de la copie pour historisation
                var copie = {
                  shareObject: '',
                  editType: EditTypesFactory.editTypes.tohistorize.name,
                  feature: mainFeatureCopie,
                  fti: intersectedShareObject.fti,
                };
                editdescription.relatedfeatures.push(copie);
              }
            });
          }
          return $q.all(majorPromise);
        }

        //Si l'objet principal édité est de type line
        if (featureType.typeInfo == 'LINE') {
          //Amont
          var promincut = new Array();
          var cfgUpShareObjects = ruleConf.parameters['amont']['shareObjects'];
          //Récupération de l'objet partagé intersecté par l'amont de la ligne éditée et mis en mémoire par une règle executée juste avant
          var intersectedShareObject = getIntersectedShareObject(
            cfgUpShareObjects
          );
          if (intersectedShareObject != undefined) {
            var amontCoordinate = editedGeom.getFirstCoordinate();
            var deff2 = $q.defer();
            var prom1 = performCutting(
              amontCoordinate,
              intersectedShareObject.shareObject,
              intersectedShareObject.isHistoricize
            );
            if (prom1 !== undefined) {
              prom1.then(
                function() {
                  //Aval
                  var cfgDownShareObjects =
                    ruleConf.parameters['aval']['shareObjects'];
                  //Récupération de l'objet partagé intersecté par l'aval de la ligne éditée et mis en mémoire par une règle executée juste avant
                  var intersectedShareObject2 = getIntersectedShareObject(
                    cfgDownShareObjects
                  );

                  if (
                    cfgUpShareObjects != undefined &&
                    cfgDownShareObjects != undefined &&
                    intersectedShareObject != undefined &&
                    intersectedShareObject2 != undefined &&
                    intersectedShareObject.shareObject.feature.getId() ==
                      intersectedShareObject2.shareObject.feature.getId()
                  ) {
                    intersectedShareObject2 = UpdateIntersectedShareObjectAval(
                      intersectedShareObject,
                      intersectedShareObject2,
                      editedGeom.getLastCoordinate()
                    );
                  }

                  if (intersectedShareObject2 != undefined) {
                    var avalCoordinate = editedGeom.getLastCoordinate();
                    deff2.promise = performCutting(
                      avalCoordinate,
                      intersectedShareObject2.shareObject,
                      intersectedShareObject2.isHistoricize
                    );
                    deff2.promise.then(
                      function(res) {
                        console.log(res);
                        deff2.resolve('terminé !');
                      },
                      function() {
                        deff2.resolve('terminé !');
                      }
                    );
                  } else {
                    deff2.resolve('terminé !');
                  }
                },
                function() {
                  deff2.resolve('terminé !');
                }
              );
              promincut.push(prom1, deff2.promise, deferred.promise);
              deferred.resolve('terminé !');
              return $q.all(promincut);
            } else {
              var cfgDownShareObjects =
                ruleConf.parameters['aval']['shareObjects'];
              //Récupération de l'objet partagé intersecté par l'aval de la ligne éditée et mis en mémoire par une règle executée juste avant
              var intersectedShareObject2 = getIntersectedShareObject(
                cfgDownShareObjects
              );

              if (
                cfgUpShareObjects != undefined &&
                cfgDownShareObjects != undefined &&
                intersectedShareObject != undefined &&
                intersectedShareObject2 != undefined &&
                intersectedShareObject.shareObject.feature.getId() ==
                  intersectedShareObject2.shareObject.feature.getId()
              ) {
                intersectedShareObject2 = UpdateIntersectedShareObjectAval(
                  intersectedShareObject,
                  intersectedShareObject2,
                  editedGeom.getLastCoordinate()
                );
              }

              if (intersectedShareObject2 != undefined) {
                var avalCoordinate = editedGeom.getLastCoordinate();
                deff2.promise = performCutting(
                  avalCoordinate,
                  intersectedShareObject2.shareObject,
                  intersectedShareObject2.isHistoricize
                );
                if (deff2.promise !== undefined) {
                  deff2.promise.then(
                    function(res) {
                      console.log(res);
                      deff2.resolve('terminé !');
                    },
                    function() {
                      deff2.resolve('terminé !');
                    }
                  );
                  promincut.push(prom2, deferred.promise);
                  deferred.resolve('terminé !');
                  return $q.all(promincut);
                } else {
                  deferred.resolve('terminé !');
                  return deferred.promise;
                }
              } else {
                deff2.resolve('terminé !');
              }
            }
          } else {
            //Aval
            var cfgDownShareObjects =
              ruleConf.parameters['aval']['shareObjects'];
            //Récupération de l'objet partagé intersecté par l'aval de la ligne éditée et mis en mémoire par une règle executée juste avant
            var intersectedShareObject2 = getIntersectedShareObject(
              cfgDownShareObjects
            );

            if (
              cfgUpShareObjects != undefined &&
              cfgDownShareObjects != undefined &&
              intersectedShareObject != undefined &&
              intersectedShareObject2 != undefined &&
              intersectedShareObject.shareObject.feature.getId() ==
                intersectedShareObject2.shareObject.feature.getId()
            ) {
              intersectedShareObject2 = UpdateIntersectedShareObjectAval(
                intersectedShareObject,
                intersectedShareObject2,
                editedGeom.getLastCoordinate()
              );
            }

            if (intersectedShareObject2 != undefined) {
              var avalCoordinate = editedGeom.getLastCoordinate();
              var prom2 = performCutting(
                avalCoordinate,
                intersectedShareObject2.shareObject,
                intersectedShareObject2.isHistoricize
              );
              if (prom2 !== undefined) {
                prom2.then(function() {});
                promincut.push(prom2, deferred.promise);
                deferred.resolve('terminé !');
                return $q.all(promincut);
              } else {
                deferred.resolve('terminé !');
                return deferred.promise;
              }
            }
          }
          promincut.push(prom1, prom2, deferred.promise);
          deferred.resolve('terminé !');
          return $q.all(promincut);
        }
        //Si l'objet principal édité est de type point
        else if (featureType.typeInfo == 'POINT') {
          var deff1 = $q.defer();
          var promincut = new Array();
          var cfgShareObjects = ruleConf.parameters['point']['shareObjects'];
          //Récupération de l'objet partagé intersecté par l'objet ponctuel éditée et mis en mémoire par une règle executée juste avant
          var intersectedShareObject3 = getIntersectedShareObject(
            cfgShareObjects
          );
          if (intersectedShareObject3 != undefined) {
            var coordinate = editedGeom.getCoordinates();
            deff1.promise = performCutting(
              coordinate,
              intersectedShareObject3.shareObject,
              intersectedShareObject3.isHistoricize
            );
            if (deff1.promise !== undefined) {
              deff1.promise.then(function() {
                deff1.resolve('terminé !');
              });
              promincut.push(deff1.promise, deferred.promise);
              //deff1.resolve("terminé !");
              deferred.resolve('terminé !');
              return $q.all(promincut);
            } else {
              deferred.resolve('terminé !');
              return deferred.promise;
            }
          }
        }
        promincut.push(deferred.promise);
        deferred.resolve('terminé !');
        return $q.all(promincut);
      }

      /*function performCutting(intersectionPointCoordinate,intersectedShareObject, isTobeHistoricize){
                    if (intersectedShareObject != undefined){
                        var intersectedFeature = intersectedShareObject.feature;

                        //Copie de l'objet qui va être scindé pour historisation eventuelle
                        if (isTobeHistoricize){
                            var mainFeatureCopie = intersectedFeature.clone();
                            mainFeatureCopie.setId(intersectedFeature.getId());
                        }

                        var line = intersectedFeature.getGeometry();

                        var isSimpleLine = line instanceof ol.geom.LineString;
                        var isMultiLine = line instanceof ol.geom.MultiLineString;

                        //Index du segment sur lequel couper la line.
                        var cuttingIndex = undefined;
                        var cuttinglineIndex = undefined;

                        var line1 = undefined;
                        var line2 = undefined;

                        var line1Length = 0;
                        var line2Length = 0;

                        if ( (Math.round(intersectionPointCoordinate[0]*100) ==  Math.round(line.getFirstCoordinate()[0]*100) && Math.round(intersectionPointCoordinate[1]*100) ==  Math.round(line.getFirstCoordinate()[1]*100) )
                                || ( Math.round(intersectionPointCoordinate[0]*100) ==  Math.round(line.getLastCoordinate()[0]*100) && Math.round(intersectionPointCoordinate[1]*100) ==  Math.round(line.getLastCoordinate()[1]*100 ) ) ){
                                console.info("Pas de scission possible de l'objet intersecté id="+intersectedFeature.id+" de la couche ="+intersectedShareObject.fti.name);
                                return;
                        }


                        if (isSimpleLine){
                            var originCoordinates = line.getCoordinates();
                            cuttingIndex = getCuttingIndexOnSimpleLine(originCoordinates, intersectionPointCoordinate);

                            if (cuttingIndex == undefined){
                                console.info("Pas de scission possible de l'objet intersecté id="+intersectedFeature.id+" de la couche ="+intersectedShareObject.fti.name);
                                return;
                            }
                            //Création des deux objets lines issus de la scission.
                            var coordinates1 = originCoordinates.slice(0,cuttingIndex+1);//slice extrait jusqu'à endIndex exclu.
                            coordinates1.push(intersectionPointCoordinate);
                            line1 = new ol.geom.LineString(coordinates1,'XY');
                            line1Length = getSimpleLineLength(line1,map);
                            line1Length = (Math.round(line1Length*100)) / 100;

                            var coordinates2 = [intersectionPointCoordinate];
                            coordinates2 = coordinates2.concat(originCoordinates.slice(cuttingIndex+1));
                            line2 = new ol.geom.LineString(coordinates2,'XY');
                            line2Length = getSimpleLineLength(line2,map);
                            line2Length = (Math.round(line2Length*100)) / 100;
                        }
                        else if (isMultiLine){

                            var simpleLines = line.getCoordinates();
                            //Pour chaque simple line de la multiline
                            for (var lineIndex=0;lineIndex<simpleLines.length;lineIndex++){
                                cuttingIndex = getCuttingIndexOnSimpleLine(simpleLines[lineIndex], intersectionPointCoordinate);
                                //Si l'index du segement de la simple line a été trouvé
                                if (cuttingIndex != undefined){
                                    //mémorisation de l'index de la simple line
                                     cuttinglineIndex = lineIndex;
                                     break;
                                 }
                            }
                            if (cuttingIndex == undefined){
                                console.info("Pas de scission possible de l'objet intersecté id="+intersectedFeature.id+" de la couche ="+intersectedShareObject.fti.name);
                                return;
                            }
                            //Création des deux objets Multilines issus de la scission.

                            //Premiere Multiligne:
                            var multiCoordinates1 = [];

                            //Récupération des simples lignes précedents celle sur laquelle se trouve la scission.
                            for (var lineIndex2=0; lineIndex2<cuttinglineIndex; lineIndex2++){
                                 multiCoordinates1.push(simpleLines[lineIndex2]);
                            }
                            //Ajout de la nouvelle simple line sur laquelle se trouve la scission (première partie de la simple line jusqu'au point d'intersection).
                            var coordinates1 = simpleLines[cuttinglineIndex].slice(0,cuttingIndex+1);//slice extrait jusqu'à endIndex exclu.
                            coordinates1.push(intersectionPointCoordinate);
                            multiCoordinates1.push(coordinates1);

                            line1 = new ol.geom.MultiLineString(multiCoordinates1,'XY');

                            //Seconde Multiligne:
                            var multiCoordinates2 = [];

                            //Ajout de la nouvelle simple line sur laquelle se trouve la scission (première partie de la simple line jusqu'au point d'intersection).
                            var coordinates2 = [intersectionPointCoordinate];
                            var lastPoints = simpleLines[cuttinglineIndex].slice(cuttingIndex+1);//slice extrait jusqu'à endIndex exclu.
                            coordinates2 = coordinates2.concat(lastPoints);
                            multiCoordinates2.push(coordinates2);

                            //Récupération des simples lignes qui suivent celle sur laquelle se trouve la scission.
                            for (var lineIndex3=cuttinglineIndex+1; lineIndex3<simpleLines.length; lineIndex3++){
                                 multiCoordinates2.push(simpleLines[lineIndex3]);
                            }

                            line2 = new ol.geom.MultiLineString(multiCoordinates2,'XY');

                            angular.forEach(line1.getLineStrings(), function(value, key) {
                                line1Length += getSimpleLineLength(value,map);
                            });
                            line1Length = (Math.round(line1Length*100)) / 100;

                            angular.forEach(line2.getLineStrings(), function(value, key) {
                                line2Length += getSimpleLineLength(value,map);
                            });
                            line2Length = (Math.round(line2Length*100)) / 100;
                        }

                        //Création d'une deuxième feature ligne : deuxième objet issu de la scission.
                        var newFeature = new ol.Feature({
                             geometry : line2
                        });
                        //Recopie des attributs dans le deuxième objet
                        //Itérerer parmi les propriétés et les ajouter au nouveau Feature
                        var properties = intersectedFeature.getProperties();
                        var geomPropertieName = intersectedFeature.getGeometryName();
                        angular.forEach(properties, function(value, key) {
                            if (key != geomPropertieName ){
                                var prop = {};
                                prop[key] = value;
                                newFeature.setProperties(prop);
                            }
                         });
                        //Mise à jour de l'attribut longueur si il a été configuré
                        if ( ruleConf.parameters['layerInfos'][intersectedShareObject.fti.name] != undefined && ruleConf.parameters['layerInfos'][intersectedShareObject.fti.name]['lengthFieldName'] != undefined){
                            var lengthFieldName = ruleConf.parameters['layerInfos'][intersectedShareObject.fti.name]['lengthFieldName'];
                            var lengthProperties1 = {};
                            lengthProperties1[lengthFieldName] = line1Length;
                            intersectedFeature.setProperties(lengthProperties1);

                            var lengthProperties2 = {};
                            lengthProperties2[lengthFieldName] = line2Length;
                            newFeature.setProperties(lengthProperties2);
                        }

                        //Mise à jour de la geometry de la feature ligne intersectée: premier objet issu de la scission.
                        intersectedFeature.setGeometry(line1);

                        //Visualisation et enregistrement de ces objets pour la sauvegarde:

                        //Objet modifié (1ere objet issu de la scission)
                        gclayers.getDrawLayer().getSource().addFeature(intersectedFeature);
                        var typeis = intersectedFeature.getId() == undefined ? EditTypesFactory.editTypes.add.name : EditTypesFactory.editTypes.update.name ;
                        var updatedObject = {shareObject:'',editType:typeis, feature: intersectedFeature, fti:intersectedShareObject.fti};
                        editdescription.relatedfeatures.push(updatedObject);

                        //Objet créé (2e objet issu de la scission)
                        gclayers.getDrawLayer().getSource().addFeature(newFeature);
                        var newObject = {shareObject:'',editType:EditTypesFactory.editTypes.add.name, feature: newFeature, fti:intersectedShareObject.fti};
                        editdescription.relatedfeatures.push(newObject);

                        //Historisation eventuelle de l'objet lineaire modifié : Copie du feature
                        if (isTobeHistoricize){
                            //Enregistrement de la copie pour historisation
                            var copie = {shareObject:'',editType:EditTypesFactory.editTypes.tohistorize.name, feature: mainFeatureCopie, fti:intersectedShareObject.fti};
                            editdescription.relatedfeatures.push(copie);
                        }
                    }
                }


                //Si l'objet principal édité est de type line
                if (featureType.typeInfo == 'LINE'){
                   //Amont
                    var cfgUpShareObjects = ruleConf.parameters['amont']['shareObjects'];
                    //Récupération de l'objet partagé intersecté par l'amont de la ligne éditée et mis en mémoire par une règle executée juste avant
                    var intersectedShareObject = getIntersectedShareObject(cfgUpShareObjects);
                    if (intersectedShareObject != undefined){
                        var amontCoordinate = editedGeom.getFirstCoordinate();
                        performCutting(amontCoordinate, intersectedShareObject.shareObject, intersectedShareObject.isHistoricize);
                    }

                    //Aval
                    var cfgDownShareObjects = ruleConf.parameters['aval']['shareObjects'];
                    //Récupération de l'objet partagé intersecté par l'aval de la ligne éditée et mis en mémoire par une règle executée juste avant
                    var intersectedShareObject2 = getIntersectedShareObject(cfgDownShareObjects);

                    if (    cfgUpShareObjects != undefined
                            && cfgDownShareObjects != undefined
                            && intersectedShareObject != undefined
                            && intersectedShareObject2 != undefined
                            && intersectedShareObject.shareObject.feature.getId() == intersectedShareObject2.shareObject.feature.getId() )
                            intersectedShareObject2 = UpdateIntersectedShareObjectAval(intersectedShareObject , intersectedShareObject2 , editedGeom.getLastCoordinate());

                    if (intersectedShareObject2 != undefined){
                        var avalCoordinate = editedGeom.getLastCoordinate();
                        performCutting(avalCoordinate, intersectedShareObject2.shareObject, intersectedShareObject2.isHistoricize);
                    }

                }
                //Si l'objet principal édité est de type point
                else if (featureType.typeInfo == 'POINT'){
                    var cfgShareObjects = ruleConf.parameters['point']['shareObjects'];
                    //Récupération de l'objet partagé intersecté par l'objet ponctuel éditée et mis en mémoire par une règle executée juste avant
                    var intersectedShareObject3 = getIntersectedShareObject(cfgShareObjects);
                    if (intersectedShareObject3 != undefined){
                        var coordinate = editedGeom.getCoordinates();
                        performCutting(coordinate, intersectedShareObject3.shareObject, intersectedShareObject3.isHistoricize);
                    }
                }

                deferred.resolve("terminé !");
                return deferred.promise;
            };*/

      /**
       * Déplace les objets ponctuels portés par les extrémités de la ligne principale déplacée.
       * @param {type} editdescription
       * @param {type} ruleConf
       * @param {type} featureType
       * @param {type} map
       * @returns {$q@call;defer.promise}
       */
      function moveExtremityPoint(editdescription, ruleConf, featureType, map) {
        var deferred = $q.defer();

        var editedGeom = editdescription.editedfeature.getGeometry();

        /*
         * Récupére le feature partagé à partir des informations de configuration
         * (contenant le nom de l'objet (shareObject) et le nom de la layer)
         * @param {type} cfgShareObjects
         * @returns {undefined|EditRulesProvider_L7.EditRulesProvider.$get.moveExtremityPoint.getIntersectedShareObject.EditRulesProviderAnonym$8}
         */
        function getIntersectedShareObject(cfgShareObjects) {
          for (var j = 0; j < cfgShareObjects.length; j++) {
            for (var k = 0; k < editdescription.shareObjects.length; k++) {
              if (
                editdescription.shareObjects[k].shareObject ==
                  cfgShareObjects[j].name &&
                editdescription.shareObjects[k].fti.name ==
                  cfgShareObjects[j].layerName
              ) {
                return {
                  shareObject: editdescription.shareObjects[k],
                  isHistoricize: cfgShareObjects[j].isHistoricize,
                };
              }
            }
          }
          return undefined;
        }

        /**
         * Déplace l'objet partagé 'intersectedShareObject' sur les coordonnée de l'extrémité 'lineExtremityCoordinate'
         * @param {type} lineExtremityCoordinate
         * @param {type} intersectedShareObject
         * @param {type} isTobeHistoricize
         * @returns {undefined}
         */
        function performMove(
          lineExtremityCoordinate,
          intersectedShareObject,
          isTobeHistoricize
        ) {
          if (intersectedShareObject != undefined) {
            var intersectedFeaturePoint = intersectedShareObject.feature;

            var intersectedGeom = intersectedFeaturePoint.getGeometry();
            if (!(intersectedGeom instanceof ol.geom.Point)) {
              console.info(
                'moveExtremityPoint: objet intersecté ' +
                  intersectedShareObject.shareObject +
                  ' de la layer ' +
                  intersectedShareObject.fti.name +
                  ' n\'est pas un ponctuel !'
              );
              return;
            }

            //Copie de l'objet qui va être scindé pour historisation eventuelle
            if (isTobeHistoricize) {
              var mainFeatureCopie = intersectedFeaturePoint.clone();
              mainFeatureCopie.setId(intersectedFeaturePoint.getId());
            }

            //Objet ponctuel déplacé vers la nouvelle extrémité de la ligne
            //Mise à jour de la géométrie du point (le déplécement)
            intersectedGeom.setCoordinates(lineExtremityCoordinate);

            //Enregistrement
            //KIS-3631: try-catch pour eviter le crash si l'objet est deja dans la couche
            try {
              gclayers
              .getDrawLayer()
              .getSource()
              .addFeature(intersectedFeaturePoint);
            } catch(e) {
              console.info('Feature déja dans la couche');
            }
            var updatedObject = {
              shareObject: intersectedShareObject.shareObject,
              editType: EditTypesFactory.editTypes.update.name,
              feature: intersectedFeaturePoint,
              fti: intersectedShareObject.fti,
            };
            editdescription.relatedfeatures.push(updatedObject);

            //Historisation eventuelle de l'objet lineaire modifié : Copie du feature
            if (isTobeHistoricize) {
              //Enregistrement de la copie pour historisation
              var copie = {
                shareObject: '',
                editType: EditTypesFactory.editTypes.tohistorize.name,
                feature: mainFeatureCopie,
                fti: intersectedShareObject.fti,
              };
              editdescription.relatedfeatures.push(copie);
            }
          }
        }

        //Si l'objet principal édité est de type line
        if (featureType.typeInfo == 'LINE') {
          //Amont
          var cfgUpShareObjects = ruleConf.parameters['amont']['shareObjects'];
          var intersectedShareObject = getIntersectedShareObject(
            cfgUpShareObjects
          );
          if (intersectedShareObject != undefined) {
            var amontCoordinate = editedGeom.getFirstCoordinate();
            performMove(
              amontCoordinate,
              intersectedShareObject.shareObject,
              intersectedShareObject.isHistoricize
            );
          }

          //Aval
          var cfgDownShareObjects = ruleConf.parameters['aval']['shareObjects'];
          var intersectedShareObject2 = getIntersectedShareObject(
            cfgDownShareObjects
          );
          if (intersectedShareObject2 != undefined) {
            var avalCoordinate = editedGeom.getLastCoordinate();
            performMove(
              avalCoordinate,
              intersectedShareObject2.shareObject,
              intersectedShareObject2.isHistoricize
            );
          }
        }
        deferred.resolve('terminé !');
        return deferred.promise;
      }

      /**
       * Déplace les objets ponctuels et linéaires portés par les lignes éditées.
       * Utilise les objets récupérés par la règle 'GetAllFeaturesIntersectingInitialLine'.
       * @param {type} editdescription
       * @param {type} ruleConf
       * @param {type} featureType
       * @param {type} map
       * @returns {$q@call;defer.promise}
       */
      function moveObjectsOnLine(editdescription, ruleConf, featureType, map) {
        var deferred = $q.defer();
        if (featureType.typeInfo != 'LINE') {
          console.error(
            'Règle moveObjectsOnLine non adaptée à la couche ' +
              featureType.name
          );
          deferred.resolve('terminé !');
          return deferred.promise;
        }

        //Récupération des informations de configuration sur les objets partagés à utiliser dans cette règle (ces objets partagés sont ceux ajoutés par des règles executées juste avant).
        var cfgUpShareObjects = ruleConf.parameters['shareObjects'];

        //Si pas de config
        if (
          cfgUpShareObjects == undefined &&
          !Array.isArray(cfgUpShareObjects)
        ) {
          console.error(
            'Règle moveObjectsOnLine mal ou pas configurée pour la couche ' +
              featureType.name
          );
          deferred.resolve('terminé !');
          return deferred.promise;
        }

        //Récupération de l'ensemble des layers
        var layers = gclayers.getOperationalLayer();

        //Récupère les features partagés stockés dans 'currenteditdescription' et dont les noms d'objets partagés sont dans l'objet de configuration 'cfgUpShareObjects'
        function getIntersectedShareObjects(currenteditdescription) {
          var shareObjects = [];

          //Pour chaque layer d'intersection de la configuration
          for (var j = 0; j < cfgUpShareObjects.length; j++) {
            if (currenteditdescription.shareObjects !== undefined) {
              //Recherche dans les features récupérés les objets partagés du même nom.
              for (
                var k = 0;
                k < currenteditdescription.shareObjects.length;
                k++
              ) {
                if (
                  currenteditdescription.shareObjects[k].shareObject ==
                    cfgUpShareObjects[j].name &&
                  currenteditdescription.shareObjects[k].fti.name ==
                    cfgUpShareObjects[j].layerName
                ) {
                  shareObjects.push({
                    shareObject: currenteditdescription.shareObjects[k],
                    isHistoricize: cfgUpShareObjects[j].isHistoricize,
                  });
                }
              }
            }
          }
          return shareObjects;
        }

        /**
         * Utilitaire: permet de savoir si l'objet feature passé en argument
         * est déjà present dans l'objet representant l'action d'édition ('editdescription').
         * @param {type} featureID
         * @returns {Boolean}
         */
        function isObjectRecordedInRelatedfeatures(featureID) {
          var isPresent = false;
          for (var i = 0; i < editdescription.relatedfeatures.length; i++) {
            if (
              featureID == editdescription.relatedfeatures[i].feature.getId()
            ) {
              isPresent = true;
              break;
            }
          }
          return isPresent;
        }

        //Traitement d'un objet porté par la ligne featureLine modifiée.
        function treatNextShareObject(
          shareObject,
          formerFeatureLine,
          newFeatureLine
        ) {
          var shareObjectlayer = getLayerByName(
            shareObject.shareObject.fti.name,
            layers
          );
          if (shareObjectlayer == undefined) {
            var deferred = $q.defer();
            console.error(
              'Règle moveObjectsOnLine treatNextShareObject(): shareObjectlayer undefined !'
            );
            deferred.resolve('terminé !');
            return deferred.promise;
          }

          //Récupération de la géometrie de l'objet feature partagé qui est à déplacer.
          var intersectedGeom = shareObject.shareObject.feature.getGeometry();

          //Préparation des données pour appeler le service java de calcul des nouvelles coordonnnées.
          var geoms = [];
          var firstPromise = undefined;

          var formerLineGeoJson = format.writeGeometryObject(
            formerFeatureLine.getGeometry()
          );
          var newLineGeoJson = format.writeGeometryObject(
            newFeatureLine.getGeometry()
          );
          var geomtoMoveGeoJson = format.writeGeometryObject(intersectedGeom);
          geoms.push(formerLineGeoJson);
          geoms.push(newLineGeoJson);
          geoms.push(geomtoMoveGeoJson);

          //Appelle du service java de calcul des nouvelles coordonnnées
          //Si la géometrie à déplacer est de type point
          if (intersectedGeom instanceof ol.geom.Point) {
            firstPromise = GeometryFactory.movepointwithline(geoms);
          } else if (
            intersectedGeom instanceof ol.geom.LineString ||
            intersectedGeom instanceof ol.geom.MultiLineString
          ) {
            firstPromise = GeometryFactory.moveLineWithLine(geoms);
          }
          //Sinon
          else {
            console.info(
              'treatNextShareObject() dans  movePointWithLine : objet à déplacer de la couche ' +
                shareObjectlayer.fti.name +
                ' non traité car pas de type point'
            );
            //Fin de la méthode de la recherche d'intesection pour l'objet édité featureLine (résolution de la mainPromise)
            var deferred = $q.defer();
            deferred.resolve('terminé !');
            return deferred.promise;
          }

          //Récupération de la réponse du service de calcul des nouvelles coordonnées (lorsque la prommesse est resolue)
          var mainPromise = firstPromise.then(
            function(res) {
              var movedGeom = format.readGeometry(res.data);
              var featureToUpdate = shareObject.shareObject.feature;
              featureToUpdate.setGeometry(movedGeom);

              //Si l'objet n'est pas déjà enregistré, on l'enregistre
              if (
                !isObjectRecordedInRelatedfeatures(
                  shareObject.shareObject.feature.getId()
                )
              ) {
                var newObject = {
                  shareObject: shareObject.shareObject.name,
                  editType: EditTypesFactory.editTypes.update.name,
                  feature: featureToUpdate,
                  fti: shareObjectlayer.fti,
                };
                editdescription.relatedfeatures.push(newObject);
                //Historisation si configurée
                if (shareObject.isHistoricize) {
                  var newObject2 = {
                    shareObject: shareObject.shareObject.name,
                    editType: EditTypesFactory.editTypes.tohistorize.name,
                    feature: featureToUpdate,
                    fti: shareObjectlayer.fti,
                  };
                  editdescription.relatedfeatures.push(newObject2);
                }
              }
            },
            function(error) {
              console.error(
                'Erreur lors de la requete  movePointWithLine de l\'objet à déplacer de la couche ' +
                  shareObjectlayer.fti.name
              );
              //Fin de la méthode de la recherche d'intesection pour l'objet édité featureLine (résolution de la mainPromise)
              var deferred = $q.defer();
              deferred.resolve('terminé !');
              return deferred.promise;
            }
          );

          return mainPromise;
        }

        //Traitement des objets par la ligne modifié
        function treatAnEditedLine(currenteditdescription, featureLine) {
          var promises = [];

          //Récupération des features intersectés par la ligne éditée dont les noms d'objets partagés sont dans cfgUpShareObjects.
          var shareObjects = getIntersectedShareObjects(currenteditdescription);

          //Récupérer la featureLine tel qu'elle est en base (avant sa modification).
          var cql_filter = 'IN (\'' + featureLine.getId() + '\')';
          //La requete d'intersection de la featureLine avec les objets de la couche cfgShareObj.layerName.
          var promise = ogcFactory.getfeatures(
            'GetFeature',
            'WFS',
            '1.0.0',
            currenteditdescription.fti.uid,
            'json',
            map
              .getView()
              .getProjection()
              .getCode(),
            cql_filter
          );
          promises.push(promise);

          //Traitement de chaque objet shareObject porté par la featureLine
          var promise2 = promise.then(
            function(res) {
              var promises = [];
              var formerFeatureLine = format.readFeatures(res.data);
              if (
                formerFeatureLine != undefined &&
                formerFeatureLine.length > 0
              ) {
                //Pour chaque shareObject contenant le feature intersecté par la ligne éditée
                for (var j = 0; j < shareObjects.length; j++) {
                  var shareObject = shareObjects[j];
                  var promise = treatNextShareObject(
                    shareObject,
                    formerFeatureLine[0],
                    featureLine
                  );
                  promises.push(promise);
                }
              }
              return $q.all(promises);
            },
            function(error) {
              console.error(
                'Erreur à l\'appel de ogc.data(), cql_filter:' + cql_filter
              );
              var deferred = $q.defer();
              deferred.resolve('terminé !');
              return deferred.promise;
            }
          );
          promises.push(promise2);

          return $q.all(promises);
        }

        //Pour la ligne principale
        //Suppression des objets portés
        var promises = treatAnEditedLine(
          editdescription,
          editdescription.editedfeature
        );

        //Pour les Les AUTRES lignes éditées (édition multiple de lignes)
        //Index de l'objet secondaire édité
        var relatedfeaturesIndex = 0;
        //on mémorise le nombre initial d'objets secondaires car on va au cours de l'execution possiblement alimenter ce tableau.
        //Si la règle ajoutait de nouveaux objets et que l'on voulait prendre en compte ces nouveaux objets,
        //on aurait comparé 'relatedfeaturesIndex' à 'editdescription.relatedfeatures.length' dans treatNextLineObject().
        var nbRelatedFeature = editdescription.relatedfeatures.length;

        function treatNextLineObject() {
          if (relatedfeaturesIndex < nbRelatedFeature) {
            var related = editdescription.relatedfeatures[relatedfeaturesIndex];
            if (
              related.editType == editdescription.editType &&
              related.fti.name == editdescription.fti.name
            ) {
              var anOtherpromises = treatAnEditedLine(related, related.feature);

              anOtherpromises.then(
                function(res) {
                  relatedfeaturesIndex++;
                  treatNextLineObject();
                },
                function(error) {
                  relatedfeaturesIndex++;
                  treatNextLineObject();
                }
              );
            } else {
              relatedfeaturesIndex++;
              treatNextLineObject();
            }
          }
          //si fin du parcours des objets
          else {
            deferred.resolve('rule end !');
          }
        }

        treatNextLineObject();

        //Crée une promesse qui sera résolue lorsque toutes les promesses du tableau seront résolues;
        //la valeur de résolution est un tableau contenant les valeurs des différentes promesses en paramètre.
        return $q.all([promises, deferred.promise]);
      }

      /**
       * Supprime les objets partagés portés par les objets linéaire édités.
       * Cette règle utilise le résultat de la règle 'getAllFeaturesIntersectingLine' qui récupère les objets portés par les lignes éditées.
       * @param {type} editdescription
       * @param {type} ruleConf
       * @param {type} featureType
       * @param {type} map
       * @returns {$q@call;defer.promise}
       */
      function deleteObjectsOnLine(
        editdescription,
        ruleConf,
        featureType,
        map
      ) {
        var deferred = $q.defer();
        if (featureType.typeInfo != 'LINE') {
          console.error(
            'Règle deleteObjectsOnLine non adaptée à la couche ' +
              featureType.name
          );
          deferred.resolve('terminé !');
          return deferred.promise;
        }
        var cfgUpShareObjects = ruleConf.parameters['shareObjects'];

        if (
          cfgUpShareObjects == undefined &&
          !Array.isArray(cfgUpShareObjects)
        ) {
          console.error(
            'Règle deleteObjectsOnLine mal ou pas configurée pour la couche ' +
              featureType.name
          );
          deferred.resolve('terminé !');
          return deferred.promise;
        }

        var layers = gclayers.getOperationalLayer();

        function isThemeLayer(layer) {
          return layer.fti.theme == editdescription.theme;
        }

        function getThemeLayerUids() {
          var layerUids = '';
          var themeLayers = layers.filter(isThemeLayer);
          angular.forEach(themeLayers, function(l, key) {
            layerUids += l.fti.uid + ',';
          });
          layerUids.substring(0, layerUids.length - 1);
          return layerUids;
        }

        function getLayerUidsFromRule() {
          var layerUids = cfgUpShareObjects
            .map(function(x) {
              var fti = gclayers.getOperationalLayerByName(x.layerName);
              if (fti) {
                return fti.uid;
              }
            })
            .filter(function(x) {
              if (x) {
                return x;
              }
            });
          return layerUids.join(',');
        }

        //Récupère les features partagés stockés dans 'currenteditdescription' et dont les noms d'objets partagés sont dans l'objet de configuration 'cfgUpShareObjects'
        function getIntersectedShareObjects(currenteditdescription) {
          var shareObjects = [];

          if (currenteditdescription.shareObjects != undefined) {
            //Pour chaque layer d'intersection de la configuration
            for (var j = 0; j < cfgUpShareObjects.length; j++) {
              //Recherche dans les features récupérés les objets partagés du même nom.
              for (
                var k = 0;
                k < currenteditdescription.shareObjects.length;
                k++
              ) {
                if (
                  currenteditdescription.shareObjects[k].shareObject ==
                    cfgUpShareObjects[j].name &&
                  currenteditdescription.shareObjects[k].fti.name ==
                    cfgUpShareObjects[j].layerName
                ) {
                  shareObjects.push({
                    shareObject: currenteditdescription.shareObjects[k],
                    isHistoricize: cfgUpShareObjects[j].isHistoricize,
                  });
                }
              }
            }
          }
          return shareObjects;
        }

        function getFeatureCountInEditdescription(featureID) {
          var count = 0;
          angular.forEach(editdescription.shareObjects, function(
            shareObj,
            key
          ) {
            if (shareObj.feature.getId() == featureID) {
              count++;
            }
          });
          angular.forEach(editdescription.relatedfeatures, function(
            related,
            key
          ) {
            angular.forEach(related.shareObjects, function(shareObj, key) {
              if (shareObj.feature.getId() == featureID) {
                count++;
              }
            });
          });
          return count;
        }

        function isObjectRecordedInRelatedfeatures(featureID) {
          var isPresent = false;
          for (var i = 0; i < editdescription.relatedfeatures.length; i++) {
            if (
              featureID == editdescription.relatedfeatures[i].feature.getId()
            ) {
              isPresent = true;
              break;
            }
          }
          return isPresent;
        }

        function treatNextShareObject(shareObject, promises) {
          var shareObjectlayer = getLayerByName(
            shareObject.shareObject.fti.name,
            layers
          );
          if (shareObjectlayer == undefined) {
            return;
          }

          var intersectedGeom = shareObject.shareObject.feature.getGeometry();
          console.log(shareObject, editdescription);

          var geoJson = format.writeGeometryObject(intersectedGeom);

          //Buffer de la geometrie de l'objet ligne courant.
          var firstPromise = GeometryFactory.buffer(geoJson, 'ROUND', 1);
          promises.push(firstPromise);

          //Une fois le buffer de l'objet ligne effectué, on peut rechercher les intersections.
          var mainPromise = firstPromise.then(
            function(res) {
              var polygon = res.data;
              var lineCoordsString2 = '';

              if (polygon.type == 'Polygon') {
                var polygonGeom = format.readGeometry(polygon);
                angular.forEach(polygonGeom.getLinearRings(), function(
                  linearRing,
                  key
                ) {
                  var coords = linearRing.getCoordinates();
                  lineCoordsString2 += '(';
                  angular.forEach(coords, function(value, key) {
                    lineCoordsString2 += value[0] + ' ' + value[1] + ',';
                  });
                  lineCoordsString2 = lineCoordsString2.substring(
                    0,
                    lineCoordsString2.length - 1
                  );
                  lineCoordsString2 += ')';
                });
                var cql_filter =
                  'INTERSECTS(geom, Polygon(' + lineCoordsString2 + '))';

                //UID des layers du theme d'édition sur lequel on désire connaitre les intersections avec le shareObject courant.
                var uidSharedObj = shareObject.shareObject.fti.uid;
                var layersUids = editdescription.fti.uid + ',' + uidSharedObj;
                //var layersUids = "08f6b94b-5031-4c19-a370-161b0d0d4f6a,dd2ab6fb-2347-4d5b-b05e-e7fcbecfa28e";

                //La requete d'intersection de la featureLine avec les objets de la couche cfgShareObj.layerName.
                var promise = ogcFactory.getfeatures(
                  'GetFeature',
                  'WFS',
                  '1.0.0',
                  layersUids,
                  'json',
                  map
                    .getView()
                    .getProjection()
                    .getCode(),
                  cql_filter
                );
                //Préparation du traitement de la Reponse.
                var callBackSuccess = getCallbackSuccess(
                  shareObject,
                  shareObjectlayer
                );
                //promise2 sera resolue lorsque la callback aura fini d'être executée (car elle ne renvoie pas de promesse)
                var promise2 = promise.then(callBackSuccess, function(error) {
                  console.error(
                    'Erreur à l\'appel de ogc.data(), cql_filter:' + cql_filter
                  );
                });
                return promise2;
              } else {
                var deferred = $q.defer();
                console.error(
                  'Règle deleteObjectsOnLine featureLine after buffer operation is not a Polygon !'
                );
                deferred.resolve('terminé !');
                return deferred.promise;
              }
            },
            function(error) {
              console.error(
                'Erreur lors de la requete de bufferisation de l\'objet édité line de la couche ' +
                  currenteditdescription.fti.name
              );
              //Fin de la méthode de la recherche d'intesection pour l'objet édité featureLine (résolution de la mainPromise)
              return undefined;
            }
          );

          promises.push(mainPromise);
        }

        //Supprime les objets partagés de la ligne éditée presents dans 'currenteditdescription' correspondant à ceux configurés dans la règle.
        //Condition pour la suppression: l'objet partagé n'intersecte pas d'autres objets non supprimés.
        function treatAnEditedLine(currenteditdescription) {
          var promises = [];

          //Récupération des features intersectés par la ligne éditée dont les noms d'objets partagés sont dans cfgUpShareObjects.
          var shareObjects = getIntersectedShareObjects(currenteditdescription);

          //Pour chaque shareObject contenant le feature intersecté par la ligne éditée
          for (var j = 0; j < shareObjects.length; j++) {
            var shareObject = shareObjects[j];
            treatNextShareObject(shareObject, promises, currenteditdescription);
          }

          return $q.all(promises);
        }

        function getCallbackSuccess(shareObj, shareObjectlayer) {
          return function(result) {
            var intersectedFeatures = format.readFeatures(result.data);

            //Si la geométrie de l'objet n'intersecte que deux objets (l'objet lui-même et celui supprimé, alors on peut supprimer cet objet partagé)
            if (
              intersectedFeatures != undefined &&
              intersectedFeatures.length == 2
            ) {
              var newObject = {
                shareObject: shareObj.shareObject.name,
                editType: EditTypesFactory.editTypes.delete.name,
                feature: shareObj.shareObject.feature,
                fti: shareObjectlayer.fti,
              };
              editdescription.relatedfeatures.push(newObject);

              //Historisation si configurée
              if (shareObj.isHistoricize) {
                var newObject = {
                  shareObject: shareObj.shareObject.name,
                  editType: EditTypesFactory.editTypes.tohistorize.name,
                  feature: shareObj.shareObject.feature,
                  fti: shareObjectlayer.fti,
                };
                editdescription.relatedfeatures.push(newObject);
              }
              //Mise en évidence du feature intersecté à supprimer
              gclayers
                .getselectSource()
                .addFeature(shareObj.shareObject.feature);
            }
            //Si le nombre d'intersections trouvées au niveau serveur est égale au nombre de fois que l'objet est present dans les shareobjets
            // (nombre de fois où l'objet est present sur l'ensemble des lignes à supprimer).
            //(+1 car le serveur considère l'intersection de la geometrie de l'objet avec lui-même)
            else if (
              intersectedFeatures.length ==
              1 +
                getFeatureCountInEditdescription(
                  shareObj.shareObject.feature.getId()
                )
            ) {
              if (
                !isObjectRecordedInRelatedfeatures(
                  shareObj.shareObject.feature.getId()
                )
              ) {
                var newObject = {
                  shareObject: shareObj.shareObject.name,
                  editType: EditTypesFactory.editTypes.delete.name,
                  feature: shareObj.shareObject.feature,
                  fti: shareObjectlayer.fti,
                };
                editdescription.relatedfeatures.push(newObject);

                //Mise en évidence du feature intersecté à supprimer
                gclayers
                  .getselectSource()
                  .addFeature(shareObj.shareObject.feature);

                //Historisation si configurée
                if (shareObj.isHistoricize) {
                  var newObject = {
                    shareObject: shareObj.shareObject.name,
                    editType: EditTypesFactory.editTypes.tohistorize.name,
                    feature: shareObj.shareObject.feature,
                    fti: shareObjectlayer.fti,
                  };
                  editdescription.relatedfeatures.push(newObject);
                }
              }
            }
            /* else {
                                //Si le feature à supprimer n'est pas déjà enregistré, ( cas possible si le feature est à l'intersection d'au moins deux linéaires supprimés)


                                    var newObject = {shareObject:shareObj.shareObject.name,editType:EditTypesFactory.editTypes.delete.name, feature: shareObj.shareObject.feature, fti:shareObjectlayer.fti};
                                    editdescription.relatedfeatures.push(newObject);

                                    //Mise en évidence du feature intersecté à supprimer
                                     gclayers.getselectSource().addFeature(shareObj.shareObject.feature);

                                    //Historisation si configurée
                                    if (shareObj.isHistoricize){
                                        var newObject2 = {shareObject:shareObj.shareObject.name,editType:EditTypesFactory.editTypes.tohistorize.name, feature: shareObj.shareObject.feature, fti:shareObjectlayer.fti};
                                        editdescription.relatedfeatures.push(newObject2);
                                    }
                                }
                            }*/
          };
        }

        //Pour la ligne principale
        //Suppression des objets portés
        var promises = treatAnEditedLine(editdescription);

        //Pour les Les AUTRES lignes éditées (édition multiple de lignes)
        //Index de l'objet secondaire édité
        var relatedfeaturesIndex = 0;
        //on mémorise le nombre initial d'objets secondaires car on va au cours de l'execution possiblement alimenter ce tableau.
        //Si la règle ajoutait de nouveaux objets et que l'on voulait prendre en compte ces nouveaux objets,
        //on aurait comparé 'relatedfeaturesIndex' à 'editdescription.relatedfeatures.length' dans treatNextLineObject().
        var nbRelatedFeature = editdescription.relatedfeatures.length;

        function treatNextLineObject() {
          if (relatedfeaturesIndex < nbRelatedFeature) {
            var related = editdescription.relatedfeatures[relatedfeaturesIndex];
            if (
              related.editType == editdescription.editType &&
              related.fti.name == editdescription.fti.name
            ) {
              var anOtherpromises = treatAnEditedLine(related);

              anOtherpromises.then(() => {
                relatedfeaturesIndex++;
                treatNextLineObject();
              },
              () => {
                relatedfeaturesIndex++;
                treatNextLineObject();
              }
              );
            } else {
              relatedfeaturesIndex++;
              treatNextLineObject();
            }
          }
          //si fin du parcours des objets
          else {
            deferred.resolve('rule end !');
          }
        }

        treatNextLineObject();

        //Crée une promesse qui sera résolue lorsque toutes les promesses du tableau seront résolues;
        //la valeur de résolution est un tableau contenant les valeurs des différentes promesses en paramètre.
        return $q.all([promises, deferred.promise]);
      }

      /**
       * Pour chaque objet ponctuel supprimé (Considère l'édition multiple),
       * recherche les objets intersectés des couches précisées
       * en configuration de cette règle
       * et effectue une fusion des objets linéaires intersectés trouvés
       * si les conditions le permettent.
       *
       * @param {type} editdescription
       * @param {type} ruleConf
       * @param {type} featureType
       * @param {type} map
       * @returns {$q@call;defer.promise}
       */
      function mergeIntersectingLines(
        editdescription,
        ruleConf,
        featureType,
        map
      ) {
        var deferred = $q.defer();
        if (featureType.typeInfo != 'POINT') {
          console.error(
            'Règle mergeIntersectingLines non adaptée à la couche ' +
              featureType.name
          );
          deferred.resolve('terminé !');
          return deferred.promise;
        }

        var layers = gclayers.getOperationalLayer();

        /**
         * Cherche les objets de la layer décrite par l'objet cfglayerObject qui intersecte l'objet supprimé deletedFeaturePoint;
         * Puis effectue une fusion si les conditions sur les objets intersectés trouvés le permettent.
         * @param {type} cfglayerObject
         * @param {type} deletedFeaturePoint
         * @returns {Array}
         */
        function deleteAndMergeIntersectingLines(
          cfglayerObject,
          deletedFeaturePoint
        ) {
          var editedgeom = deletedFeaturePoint.getGeometry();
          var pointCoordinate = editedgeom.getCoordinates();

          var leftX = pointCoordinate[0] - 0.05;
          var bottomY = pointCoordinate[1] - 0.05;
          var rightX = pointCoordinate[0] + 0.05;
          var topY = pointCoordinate[1] + 0.05;
          var cql_filter =
            'INTERSECTS(geom, POLYGON((' +
            leftX +
            ' ' +
            bottomY +
            ',' +
            rightX +
            ' ' +
            bottomY +
            ',' +
            rightX +
            ' ' +
            topY +
            ',' +
            leftX +
            ' ' +
            topY +
            ',' +
            leftX +
            ' ' +
            bottomY +
            ')))';
          //var cql_filter = "INTERSECTS(geom,Point("+pointCoordinate[0]+' '")";

          var l = getLayerByName(cfglayerObject.layerName, layers);
          if (l == undefined) {
            console.error(
              'Erreur à l\'appel de  ogc.data(),avec la couche:' +
                cfglayerObject.layerName +
                'cql_filter:' +
                cql_filter
            );
            var deferred = $q.defer();
            deferred.resolve('terminé !');
            return deferred.promise;
          }

          //La requete d'intersection de pointCoordinate avec les objets de la couche cfgShareObj.layerName.
          var promise = ogcFactory.getfeatures(
            'GetFeature',
            'WFS',
            '1.0.0',
            l.fti.uid,
            'json',
            map.getView().getProjection().getCode(),
            cql_filter
          );
          //Reponse.
          var callBackSuccess = getCallbackSuccess(
            cfglayerObject,
            l,
            deletedFeaturePoint
          );
          //promise2 sera resolue lorsque la callback aura finie d'être executée
          var promise2 = promise.then(callBackSuccess, function (error) {
            console.error(
              'Erreur à l\'appel de  ogc.data(),avec la couche:' +
                l.name +
                'cql_filter:' +
                cql_filter
            );
          });

          return promise2;
        }


        /**
         * Affichage d'un toastr pour les messages ayant comme
         * chemin d'accés JSON "rulecfg.mergeintersectinglines".
         *
         * @param {*} messageName : Clef identifiant le message
         */
        const mergeToastr = (messageName) => {
          require('toastr').error(
            $filter('translate')('rulecfg.mergeintersectinglines.' + messageName));
        };


        /**
         * Vérifier que les canalisations à fusionner ont le même matériau
         * et le même diamètre.
         *
         * @param {*} prop1 : Propriétés de la canalisation 1
         * @param {*} prop2 : Propriétés de la canalisation 2
         * @param {*} cfglayerObject : Configuration où sont stockés
         *                  le nom des attributs matériau et diamètre
         * @returns VRAI si la fusion est possible, FAUX sinon
         */
        const checkMaterialOfPipes = (prop1, prop2, cfglayerObject) => {
          let ok = true;
          if (prop1[cfglayerObject.materialFieldName] !==
            prop2[cfglayerObject.materialFieldName]) {
            mergeToastr('differentMaterials');
            ok = false;
          }
          if (prop1[cfglayerObject.diameterFieldName] !==
            prop2[cfglayerObject.diameterFieldName]) {
            mergeToastr('differentDiameters');
            ok = false;
          }
          if (ok) {
            return true;
          }
          else {
            mergeToastr('notCompatible');
            return false;
          }
        };


        function getCallbackSuccess(
          cfglayerObject,
          intersectionlayerLine,
          deletedFeaturePoint
        ) {
          return function(result) {
            var deferred = $q.defer();
            var intersectedFeatures = format.readFeatures(result.data);
            //Si  intersection de deux cana uniquement,alors possibilité de fusion
            if (intersectedFeatures != undefined) {
              if (intersectedFeatures.length === 2) {
                var feature1 = intersectedFeatures[0];
                var feature2 = intersectedFeatures[1];
                var prop1 = feature1.getProperties();
                var prop2 = feature2.getProperties();

                //Vérification des types des cana pour accepter la fusion.
                if (checkMaterialOfPipes(prop1,prop2,cfglayerObject)) {
                  //Renvoi une promesse qui sera résolue lorsque
                  //les opérations de fusion seront terminées pour ces lignes.
                  return doMerge(deletedFeaturePoint,intersectedFeatures,
                    cfglayerObject,intersectionlayerLine);
                }
              }
              else {
                if (intersectedFeatures.length < 2) {
                  //-- Isolé ou connecté à un seul tronçon, on n'interdit pas
                  //-- la suppression(en tout cas pas dans cette régle).
                  deferred.resolve('terminé !');
                  return deferred.promise;
                }
              }
            }

            //-- -- ANNULATION DE LA SUPPRESSION

            if (intersectedFeatures != undefined
              && intersectedFeatures.length > 2) {
            //-- Message du cas où on essaye de supprimer un point connecté
            //-- à plus de 2 tronçons
              mergeToastr('moreThan2Lines');
            }

            if (editdescription.editedfeature.getId() ==
              deletedFeaturePoint.getId()
            ) {
              if (editdescription.relatedfeatures.length > 0) {
                // take the first relatedFeature and put it in editedFeature
                editdescription.editedfeature =
                  editdescription.relatedfeatures[0];
                editdescription.relatedfeatures.splice(0, 1);
              } else {
                editdescription.editedfeature = null;
              }
            } else {
              for(let index in editdescription.relatedfeatures){
                if (editdescription.relatedfeatures[index].getId() ==
                  deletedFeaturePoint.getId()) {
                  editdescription.relatedfeatures.splice(index,1);
                }
              }
            }


            /* else {
                            alert ('le noeud est raccordé à plus de deux tronçons')
                        }  */
            //CallBack fait aussi un return dans la condition interne, donc pas de else, sinon, si la deuxième condition n'est pas vérifié, la promesse résolue ne serait pas envoyée.
            //Si pas de fusion, cette callback renvoi une promesse resolue.
            deferred.resolve('terminé !');
            return deferred.promise;
          };
        }

        /**
         * tempAllMergedObjects: Object contenant les tableaux par layers des feature line fusionnées pour acceder plus facilement à ces objetss lors de vérifications.
         * @type Array
         */
        function getMergedObjectsArrayByLayerName(editdescription, layerName) {
          if(!editdescription.tempAllMergedObjects) {
            editdescription.tempAllMergedObjects = {};
          }
          if (editdescription.tempAllMergedObjects[layerName] == undefined) {
            editdescription.tempAllMergedObjects[layerName] = [];
          }
          return editdescription.tempAllMergedObjects[layerName];
        }

        //overlapPoints est un tableau d'objets representant chacun une coordonnée commune entre les deux lines.
        //Chaque objet de overlapPoints contient les valeurs d'index et subindex de la coordonnée commune.
        function getOverlapPoints(currentLine, newMergeLine) {
          var overlapPoints = [];

          var coordinates1 = currentLine.getCoordinates();
          var coordinates2 = newMergeLine.getCoordinates();

          //Pour chaque point de la première line
          for (
            var lineStringIndex1 = 0;
            lineStringIndex1 < coordinates1.length;
            lineStringIndex1++
          ) {
            var subcoordinates1 = coordinates1[lineStringIndex1];

            //Pour chaque point de la deuxième line, vérification si currentpoint1 et currentpoint2 ont les memes valeurs
            for (
              var lineStringIndex2 = 0;
              lineStringIndex2 < coordinates2.length;
              lineStringIndex2++
            ) {
              var subcoordinates2 = coordinates2[lineStringIndex2];

              if (
                Math.round(subcoordinates1[0] * 10) ==
                      Math.round(subcoordinates2[0] * 10) &&
                    Math.round(subcoordinates1[1] * 10) ==
                      Math.round(subcoordinates2[1] * 10)
              ) {
                //Stockage des index et subindex des lines où les points se chevauchent
                overlapPoints.push(subcoordinates1);
              }
            }
          }
          return overlapPoints;
        }

        function getOverlapFeatureObjectIfAny(editdescription, newMergeFeature, layerName) {
          var overlapObjects = [];
          var mergedObjects = getMergedObjectsArrayByLayerName(editdescription ,layerName);
          for (var i = 0; i < mergedObjects.length; i++) {
            var currentLine = mergedObjects[i].feature.getGeometry();
            if (
              getOverlapPoints(currentLine, newMergeFeature.getGeometry())
                .length >= 2
            ) {
              overlapObjects.push(mergedObjects[i]);
            }
          }
          return overlapObjects;
        }

        /**
         * Vérifie que l'objet fusionné passé en paramètre à cette fonction ne chevauche pas un autre objet préalablement fusionné,
         * si c'est le cas il faut à nouveau fusionner cet objet et ceux qui le chevauche.
         * @param {type} featureToUpdate le ol.feature non encore sauvé, issu d'une premiere fusion mais qui se chevauche avec une autre feature precedement fusionnée present dans overlapFeatureObject.
         * @param {type} overlapFeatureObject l' autre feature precedement fusionné
         * @param {type} cfglayerObject l'objet configuration lié à la layer de l'objet fusionné.
         * @returns {undefined}
         */
        var mergeCanceledByUser = false;
        var allpopupInstances = [];

        function checkSecondaryMerges(featureToUpdate, cfglayerObject) {
          var deferred = $q.defer();
          if (mergeCanceledByUser) {
            deferred.resolve('CanceledByUser!');
            return deferred.promise;
          }

          var layer = getLayerByName(cfglayerObject.layerName, layers);

          var overlapFeatureObjects = getOverlapFeatureObjectIfAny(
            editdescription,
            featureToUpdate,
            cfglayerObject.layerName
          );

          //Si 'featureToUpdate' resultat d'une première fusion dans doMerge(),
          // ne superpose aucun autre objet precedement fusionné, on l'enregistre simplement.
          if (overlapFeatureObjects.length == 0) {
            //Visualisation
            gclayers
              .getDrawLayer()
              .getSource()
              .addFeature(featureToUpdate);
            //Enregistrement pour sauvegarde
            var objectToCreate = {
              shareObject: '',
              editType: EditTypesFactory.editTypes.add.name,
              feature: featureToUpdate,
              fti: layer.fti,
            };
            editdescription.relatedfeatures.push(objectToCreate);

            //Enregistrement dans un tableau secondaire pour acceder plus facilement aux objets déjà fusionnés lors des prochaines fusions.
            getMergedObjectsArrayByLayerName(editdescription, layer.fti.name).push(
              objectToCreate
            );

            deferred.resolve('terminé !');
          }
          //Sinon, fusion et enregistrement du resultat de la fusion des deux objets.
          else {
            var geoms = [];
            var f1geoJson = format.writeGeometryObject(
              featureToUpdate.getGeometry()
            );
            geoms.push(f1geoJson);
            for (var i = 0; i < overlapFeatureObjects.length; i++) {
              var overlapFeatureObject = overlapFeatureObjects[i];
              var f2geoJson = format.writeGeometryObject(
                overlapFeatureObject.feature.getGeometry()
              );
              geoms.push(f2geoJson);
            }

            //ATTENTION, SI UN DEUXIEME APPEL DE LA METHODE ARRIVE ICI ET QUE L'APPEL PRECEDENT N'EST PAS ENCORE TRAITE DANS LE HANDLER DE RESULTATS,
            // LE TABLEAU DE MERGED LINES NE SERA PAS à JOUR ET IL N'Y AURA PAS DE FUSION COMPLEMENTAIRE;
            GeometryFactory.union(geoms).then(
              function(result) {
                var mergedLine = format.readGeometry(result.data);

                //Enregistrement dans un tableau secondaire pour acceder plus facilement aux objets déjà fusionnés lors des prochaines fusions.
                //this temporary version will be replaced after
                let tempFeature = overlapFeatureObjects[0].feature;
                tempFeature.setGeometry(mergedLine);
                let objectToCreate = {
                  shareObject: '',
                  editType: EditTypesFactory.editTypes.add.name,
                  feature: tempFeature,
                  fti: layer.fti,
                };
                getMergedObjectsArrayByLayerName(editdescription, layer.fti.name).push(objectToCreate);

                var scope = $rootScope.$new(true);

                scope.editdescription = editdescription;
                scope.selectedFeatures = [];
                //On retire des tableaux les precedents objets fusionnés qui chevauchent le nouvel objet fusioné
                for (var i = 0; i < overlapFeatureObjects.length; i++) {
                  var overlapFeatureObject = overlapFeatureObjects[i];
                  var mergedObjects = getMergedObjectsArrayByLayerName(
                    editdescription, overlapFeatureObject.fti.name);
                  var index1 = mergedObjects.indexOf(overlapFeatureObject);
                  if (index1 >= 0) {
                    mergedObjects.splice(index1, 1);
                  }
                  var index2 = editdescription.relatedfeatures.indexOf(
                    overlapFeatureObject
                  );
                  if (index2 >= 0) {
                    editdescription.relatedfeatures.splice(index2, 1);
                  }

                  // //Retirer de la visualisation
                  // gclayers
                  //   .getDrawLayer()
                  //   .getSource()
                  //   .removeFeature(overlapFeatureObject.feature);

                  //Tratement pour le choix par l'utilisateur du feature à conserver
                  overlapFeatureObject.feature.currentProperties = overlapFeatureObject.feature.getProperties();
                  scope.selectedFeatures.push(overlapFeatureObject.feature);
                }

                /**
                 * Définition de la méthode qui poursuivra le traitement après le choix par défaut ou par l'utilisateur du feature dont les attributs sont à conserver.
                 * @param {type} featureChoosen
                 * @returns {undefined}
                 */
                scope.confirm = function(featureChoosen) {
                  if (featureChoosen == undefined) {
                    return;
                  }
                  if (scope.p) {
                    scope.p.destroy();
                  }

                  var newFeatureToUpdate = featureChoosen;
                  newFeatureToUpdate.setGeometry(mergedLine);

                  //Affectation de la valeur à la propriété longueur
                  if (cfglayerObject.lengthFieldName) {
                    //Recalcul de la longueur
                    var lineLength = 0;
                    if(mergedLine.getLineStrings){
                      //multiple lines (multiLineString)
                      angular.forEach(mergedLine.getLineStrings(), function(
                        value,
                        key
                      ) {
                        lineLength += getPreciseLineLength(value, map);
                      });
                    } else {
                      //single line (lineString)
                      lineLength = getPreciseLineLength(mergedLine, map);
                    }
                    var lengthFieldName = cfglayerObject.lengthFieldName;
                    var lengthProperties = {};
                    lengthProperties[lengthFieldName] =
                      Math.round(lineLength * 100) / 100;
                    newFeatureToUpdate.setProperties(lengthProperties);
                  }

                  var updatedObject = {
                    shareObject: '',
                    editType: EditTypesFactory.editTypes.add.name,
                    feature: newFeatureToUpdate,
                    fti: layer.fti,
                  };
                  //Enregistrement pour sauvegarde
                  editdescription.relatedfeatures.push(updatedObject);

                  //Enregistrement dans un tableau secondaire pour acceder plus facilement aux objets déjà fusionnés lors des prochaines fusions.
                  let tempFeatureIndex = mergedObjects.indexOf(tempFeature);
                  mergedObjects.splice(tempFeatureIndex, 1);
                  mergedObjects.push(updatedObject);

                  //Visualisation
                  gclayers
                    .getDrawLayer()
                    .getSource()
                    .addFeature(newFeatureToUpdate);

                  deferred.resolve('terminé !');
                };

                //Si FastMode est activé alors ON MET À JOUR LE PREMIER FEATURE AVEC LA NOUVELLE GEOMETRY ET ON SUPPRIME LE DEUXIÈME FEATURE
                if (editdescription.fastMode) {
                  scope.confirm(featureToUpdate);
                }
                //Sinon, l'utilisateur choisit dans une popup lequel est à conserver (celui pour lequel on garde les attributs)
                else {
                  scope.highLightFeature = function(f) {
                    gclayers.addhighLightFeature(f);
                    //ADD Timeout sur scope.removehighLightFeature si probleme pour retirer le highLight
                  };
                  scope.removehighLightFeature = function(f) {
                    gclayers.removehighLightFeatures(f);
                    //gclayers.clearhighLightFeatures();
                  };

                  //Choix de la feature dont les attributs sont à conserver
                  featureToUpdate.currentProperties = featureToUpdate.getProperties();
                  scope.selectedFeatures.push(featureToUpdate);
                  angular.forEach(scope.selectedFeatures, (feature) => {
                    if (!feature.getId()) {
                      feature.setId('Elément temporaire');
                    }
                  });
                  scope.intersectionlayer = layer;
                  scope.result = {};
                  scope.p = gcPopup.open({
                    template:
                      'js/XG/modules/edit/views/featuresChoice_popup.html',
                    scope: scope,
                    title: $filter('translate')(
                      'rules.mergeLines.scdMergeChoicePopupTitle'
                    ),
                    showClose: false,
                  });
                  allpopupInstances.push(scope.p);

                  scope.closeThisDialog = function(res) {
                    mergeCanceledByUser = true;
                    //Fermeture des popup
                    angular.forEach(allpopupInstances, function(value, key) {
                      value.destroy();
                    });

                    deferred.resolve('CanceledByUser!');
                  };
                }
              },
              function(error) {
                console.error(
                  'Erreur à l\'appel de   GeometryFactory.union,avec la couche:' +
                    cfglayerObject.layerName
                );
                deferred.resolve('terminé !');
              }
            );
          }
          return deferred.promise;
        }

        /**
         * Effectue la fusion des deux objets linéaires intersectés situé dans le tableau 'intersectedFeatures' passé en paramètre.
         * @param {type} deletedFeaturePoint
         * @param {type} intersectedFeatures
         * @param {type} cfglayerObject
         * @param {type} intersectionlayerLine
         * @returns {$q@call;defer.promise}
         */
        function doMerge(
          deletedFeaturePoint,
          intersectedFeatures,
          cfglayerObject,
          intersectionlayerLine
        ) {
          var deferred = $q.defer();

          if (mergeCanceledByUser) {
            deferred.resolve('CanceledByUser!');
            return deferred.promise;
          }

          var feature1 = intersectedFeatures[0];
          var feature2 = intersectedFeatures[1];

          // //change the 'multiLineString' in a 'LineString' because arcgis is throwing an error with 'multiLineString'
          // deletedFeaturePoint



          var geoms = [];
          var f1geoJson = format.writeGeometryObject(feature1.getGeometry());
          var f2geoJson = format.writeGeometryObject(feature2.getGeometry());
          geoms.push(f1geoJson);
          geoms.push(f2geoJson);

          //Appelle du service java de fusion
          GeometryFactory.union(geoms).then(
            //Fonction appellée lors du resultat de la fusion
            function(result) {
              //Geometrie resultat de la fusion
              var mergedLine = format.readGeometry(result.data);

              var scope = $rootScope.$new(true);

              /**
               * Définition de la méthode qui poursuivra le traitement après le choix par défaut ou par l'utilisateur du feature dont les attributs sont à conserver.
               * @param {type} featureChoosen
               * @returns {undefined}
               */
              scope.confirm = function(featureChoosen) {
                if (featureChoosen == undefined) {
                  return;
                }
                if (scope.p) {
                  scope.p.destroy();
                }

                var featureToCreate = featureChoosen.clone();

                featureToCreate.setGeometry(mergedLine);
                //Reprise des attributs dans la nouvelle ligne fusionnée: attributs dans feature deja present puisque seule la geometry a été remplacée dans le feature déja existant.

                //Affectation de la valeur à la propriété longueur
                if (cfglayerObject.lengthFieldName) {
                  //Recalcul de la longueur
                  var lineLength = 0;
                  if (mergedLine.getLineStrings) {
                    //multiple lines
                    angular.forEach(
                      mergedLine.getLineStrings(),
                      function (value, key) {
                        lineLength += getPreciseLineLength(value, map);
                      }
                    );
                  } else {
                    //multiple lines
                    lineLength = getPreciseLineLength(
                      mergedLine,
                      map
                    );
                  }
                  var lengthFieldName = cfglayerObject.lengthFieldName;
                  var lengthProperties = {};
                  lengthProperties[lengthFieldName] =
                    Math.round(lineLength * 100) / 100;
                  featureToCreate.setProperties(lengthProperties);
                }

                //Enregistrement des features
                //Objets à supprimer
                gclayers
                  .getDrawLayer()
                  .getSource()
                  .addFeature(feature1);
                var objectToDelete1 = {
                  shareObject: '',
                  editType: EditTypesFactory.editTypes.delete.name,
                  feature: feature1,
                  fti: intersectionlayerLine.fti,
                };
                recordObjectIfNotExists(editdescription, objectToDelete1);
                gclayers
                  .getDrawLayer()
                  .getSource()
                  .addFeature(feature2);
                var objectToDelete2 = {
                  shareObject: '',
                  editType: EditTypesFactory.editTypes.delete.name,
                  feature: feature2,
                  fti: intersectionlayerLine.fti,
                };
                recordObjectIfNotExists(editdescription, objectToDelete2);

                //Historisation eventuelle des objets lineaires modifié et supprimé:
                if (cfglayerObject.isHistoricize) {
                  //Enregistrement de la copie pour historisation
                  var objectToHistoricize1 = {
                    shareObject: '',
                    editType: EditTypesFactory.editTypes.tohistorize.name,
                    feature: feature1,
                    fti: intersectionlayerLine.fti,
                  };
                  recordObjectIfNotExists(
                    editdescription,
                    objectToHistoricize1
                  );
                  var objectToHistoricize2 = {
                    shareObject: '',
                    editType: EditTypesFactory.editTypes.tohistorize.name,
                    feature: feature2,
                    fti: intersectionlayerLine.fti,
                  };
                  recordObjectIfNotExists(
                    editdescription,
                    objectToHistoricize2
                  );
                }
                //Objet Créé

                // finish merging
                checkSecondaryMerges(featureToCreate, cfglayerObject).then(
                  function(result) {
                    deferred.resolve('terminé !');
                  },
                  function(error) {
                    console.error(
                      'Erreur à l\'appel de   checkSecondaryMerges, avec la couche:' +
                        intersectionlayerLine.fti.name
                    );
                    deferred.resolve('terminé !');
                  }
                );
              };

              //Si FastMode est activé alors ON MET À JOUR LE PREMIER FEATURE AVEC LA NOUVELLE GEOMETRY ET ON SUPPRIME LE DEUXIÈME FEATURE
              if (editdescription.fastMode) {
                scope.confirm(feature1);
              }
              //Sinon, l'utilisateur choisit dans une popup lequel est à conserver (celui pour lequel on garde les attributs)
     