'use strict';
define(function() {
  var geolocalisationwidget = function(
    NominatimFactory,
    GoogleGeocodeFactory,
    ConfigFactory,
    $translate,
    ngDialog,
    $http,
    kisGeocodageFactory,
    gaJsUtils
  ) {
    return {
      templateUrl: 'js/XG/biz/aepInterventions/views/localisationaep1.html',
      restrict: 'A',

      //methode executée au chargement de la page
      link: function(scope, element, attrs, ctrl) {
        scope.tabs = [
          {
            titleKey: 'geolocalisation.tabAdresse',
            title: 'geolocalisation.tabAdresse',
          },
          {
            titleKey: 'geolocalisation.tabCoordinate',
            title: 'geolocalisation.tabCoordinate',
          },
        ];
        scope.tabs.activeTab = 0;
        scope.tabs.activeTab = 0;

        var map = scope.map;
        var projection = map.getView().getProjection();
        var vectorLayer = kisGeocodageFactory.getMarkerLayer();
        map.addLayer(vectorLayer);
        var vectorSource = scope.vectorLayer.getSource();
        //scope.inputAdress = "";
        scope.wait = false;
        scope.adress = {};

        /**
         * Getting Coordinates Informations from GoogleMap api
         * @param address
         * @returns {*}
         */
        scope.getInformationsFromAddress = function(address) {
          if (address == '') return false;
          var params = { address: address, sensor: false };
          return $http
            .get('https://maps.googleapis.com/maps/api/geocode/json', {
              params: params,
            })
            .then(function(res) {
              return res.data.results;
            });
        };

        /**
         * [searchAdress Recherche les lieux correspondant à la valeur de 'inputAdress',
         * en appelant un service web.]
         * @return {[type]} [description]
         */
        scope.searchAdress = function() {
          scope.wait = true;
          scope.activeAddress = {};
          scope.adress = [];

          GoogleGeocodeFactory.getInformationsFromAddress(
            scope.inputAdress,
            ''
          ).then(function(res) {
            console.log(res);
            scope.wait = false;
            var adressResults = res.data.results;
            for (var i = 0; i < adressResults.length; i++) {
              var aResult = adressResults[i];
              var anAdress = {
                address: {
                  state: aResult.address_components[3].long_name,
                },
                display_name: aResult.formatted_address,
                lat: aResult.geometry.location.lat,
                lon: aResult.geometry.location.lng,
              };
              anAdress.origin = 'google';
              scope.adress.push(anAdress);
            }
          });
        };

        /**
         * [clear vide la liste de resultats]
         * @return {[type]} [vide la liste de resultat]
         */
        scope.clear = function() {
          scope.adress = undefined;
        };
        scope.cleargps = function() {
          scope.searchPosition = { x: '', y: '' };
        };

        scope.markerSet = false;
        scope.activeAddress = {};
        scope.selectedsrid = {};
        /**
         *
         * [seeOnMap Centre la carte sur le lieu correspondant à 'anAdress' et positionne sur la carte un marqueur et une délimitation du lieu.]
         * @param  {[type]} anAdress [description]
         * @param  {[type]} index [description]
         * @return {[type]}          [description]
         */

        scope.seeOnMap = function(anAdress, index) {
          var formerCenter = map.getView().getCenter();
          scope.markerSet = true;
          scope.activeAddress.value = index;

          //Coordonnées géographiques (WGS84), du centre du lieu choisi.
          var myLong = Number(anAdress.lon);
          var lat = Number(anAdress.lat);

          //Test qui fonctionne: (Coordonnées de Berlin): var projetedCoord = ol.proj.transform([13.37, 52.50], 'EPSG:4326', 'EPSG:3857');

          var mapCode = projection.getCode();
          //Projection des coordonnées du lieu dans le systeme de la carte
          var projetedCoord = ol.proj.transform(
            [myLong, lat],
            'EPSG:4326',
            mapCode
          );
          //scope.coords = projetedCoord;
          //Centrage de la carte sur le lieu
          map.getView().setCenter(projetedCoord);

          //Visualisation du lieu sur la carte
          vectorSource.clear(true);
          //Visualisation du centre du lieu
          var centerFeature = new ol.Feature({
            name: anAdress.display_name,
          });
          centerFeature.setGeometry(new ol.geom.Point(projetedCoord));
          vectorSource.addFeature(centerFeature);

          if (anAdress.geojson === undefined){
            const zIndex = gaJsUtils.getZIndexMax(map) + 1;
            scope.vectorLayer.setZIndex(zIndex);
            return;
          }
          //Visualisation du lieu
          var geojson = anAdress.geojson;
          var featureGeoCoordinates = geojson.coordinates;

          var feature = new ol.Feature({
            name: anAdress.display_name,
          });
          if (geojson.type == 'LineString') {
            //(featureGeoCoordinates is an Array of [myLong,lat] )

            //Coordonnées de l'objet permettant la visualisation du lieu, dans le systeme de coordonnées de la carte.
            var featureCoordinates = [];
            var index, len;
            for (
              index = 0, len = featureGeoCoordinates.length;
              index < len;
              ++index
            ) {
              featureCoordinates.push(
                ol.proj.transform(
                  featureGeoCoordinates[index],
                  'EPSG:4326',
                  mapCode
                )
              );
            }
            feature.setGeometry(new ol.geom.LineString(featureCoordinates));
          }
          if (geojson.type == 'Polygon') {
            //(featureGeoCoordinates is an Array of Array of [myLong,lat] )
            var polyFeatureCoordinates = [];
            var index1, len1;
            for (
              index1 = 0, len1 = featureGeoCoordinates.length;
              index1 < len1;
              ++index1
            ) {
              var subGeoCoordinate = featureGeoCoordinates[index1];
              polyFeatureCoordinates.push([]);
              var index2, len2;
              for (
                index2 = 0, len2 = subGeoCoordinate.length;
                index2 < len2;
                ++index2
              ) {
                polyFeatureCoordinates[index1].push(
                  ol.proj.transform(
                    subGeoCoordinate[index2],
                    'EPSG:4326',
                    mapCode
                  )
                );
              }
            }
            feature.setGeometry(new ol.geom.Polygon(polyFeatureCoordinates));
          }
          vectorSource.addFeature(feature);
        };

        /**
         * [clearMarker description]
         * @return {[type]} [description]
         */
        scope.clearMarker = function() {
          scope.markerSet = false;
          vectorSource.clear(true);
        };
      },
    };
  };

  geolocalisationwidget.$inject = [
    'NominatimFactory',
    'GoogleGeocodeFactory',
    'ConfigFactory',
    '$translate',
    'ngDialog',
    '$http',
    'kisGeocodageFactory',
    'gaJsUtils'
  ];
  return geolocalisationwidget;
});
