/**
 *
 */
'use strict';
define(function() {
  var IndicateurMgtCtrl = function(
    $scope,
    FeatureTypeFactory,
    QueryFactory,
    EditFactory
  ) {
    /**
     *     As input parameter we have the step end object id, for example
     *  the id of table day_projet_etape_standard.
     *  From the id we read the content of the table "indicateurTable" with such an id.
     *  We get a list of objects for distinct document type.
     *  We have the list of fields to display, and the mode.
     *  This component can be used for two purposes,
     *  -1- To create the "indicateurs"
     *  -2- To set he values during project life.
     *
     *   input parameters
     *   + specific_step_id
     *
     *   input configuration
     *   + mode
     *   + fields:                field list
     *   + expected result table name
     *   + real result table name
     *   + indicateurTableIdFn:   field name of id
     *   + indicateurTableTypeFn: field name of indicateur type
     */

    $scope.listOfTypes = [];
    $scope.config = angular.copy($scope.indicConfig);
    $scope.currentCalculationFieldNames = [];

    /**
     *        Build the list of fields to display in this directive.
     *   There are two types of fields, the standard type (text, number, ...)
     *   and the computed fields.
     */
    $scope.prepareListOfFields = function() {
      var field;
      for (
        var indField = 0;
        indField < $scope.config.fieldOrder.length;
        indField++
      ) {
        field = $scope.config.fieldOrder[indField];
        if ($scope.config.fieldOrder[indField].computedField == 'true') {
          //-- Field to evaluate with other information from Database
          field.fieldDesc = {};
          field.fieldDesc.readOnly = true;
          field.fieldDesc.name = field.field;
          if (field.alias != undefined) field.fieldDesc.alias = field.alias;
          field.fieldDesc.type = 'java.lang.String';
          field.objectField = { name: field.field, value: '' };
        } else
          for (
            var indAtt = 0;
            indAtt < $scope.expectedResTableDesc.attributes.length;
            indAtt++
          ) {
            var att = $scope.expectedResTableDesc.attributes[indAtt];
            if (att.name == field.field) {
              //-- Field is an attribute of the table
              field.fieldDesc = att;
              field.objectField = { name: att.name, value: '' };
              break;
            }
          }
      }
    };

    /**
     *       Get the description odf the two main tables from server and
     *    describe the fields to display in order the directive presents them.
     *    The two tables are the table of "indicateurs prévus" and the table
     *    of "indicateurs réels".
     */
    $scope.readConfiguration = function() {
      $scope.expectedResTableDesc = FeatureTypeFactory.getFeatureTypeDesc(
        $scope.config.datastoreName,
        $scope.config.expectedResTableName
      );
      $scope.realResTableDesc = FeatureTypeFactory.getFeatureTypeDesc(
        $scope.config.datastoreName,
        $scope.config.realResTableName
      );
      $scope.prepareListOfFields();
    };

    $scope.getPropertiesFor = function(typeValue) {
      var att,
        prop = {};
      var conf = $scope.config;

      //-- Build a list of properties for new "indicateur".
      //-- Each field is NULL except the id of the step and the type of indicateur.
      for (
        var ind = 0;
        ind < $scope.expectedResTableDesc.attributes.length;
        ind++
      ) {
        att = $scope.expectedResTableDesc.attributes[ind];
        if (att.name == conf.indicateurTableTypeFn) prop[att.name] = typeValue;
        else if (att.name == conf.indicateurTableIdFn)
          prop[att.name] = $scope.specificStepId.value;
        else prop[att.name] = null;
      }

      return prop;
    };

    $scope.createExpectedResultList = function() {
      var ind, att, restr, feat, features;
      var conf = $scope.config;

      //-- Look for field which is the type of "indicateur"
      for (
        ind = 0;
        ind < $scope.expectedResTableDesc.attributes.length;
        ind++
      ) {
        att = $scope.expectedResTableDesc.attributes[ind];
        if (att.name == conf.indicateurTableTypeFn) {
          //-- Build GeoJSON object describing the objects we want to insert
          features = {};
          features.type = 'FeatureCollection';
          features.features = [];

          //-- We are on the field which is the type of "indicateur"
          //-- so create a record for each type.
          //-- Each type is in the listOfValue property of the field restriction.
          for (
            var indRestr = 0;
            indRestr < att.restrictions.length;
            indRestr++
          ) {
            if (att.restrictions[indRestr].type == 'Domain') {
              restr = att.restrictions[indRestr];
              for (var propName in restr.listofValues) {
                feat = {};
                feat.type = 'feature';
                feat.properties = $scope.getPropertiesFor(propName);
                feat.geometry = {};
                features.features.push(feat);
              }
            }
          }
          EditFactory.add($scope.expectedResTableDesc.uid, features).then(
            function(res) {
              var cnt = 0;
              for (var propName in restr.listofValues) cnt++;
              if (cnt != 0) $scope.loadWidget();
            }
          );
          break;
        }
      }
    };

    $scope.loadWidget = function() {
      var conf = $scope.config;
      var where, stepTable;

      if (conf.indicateurSpecificTable1 == $scope.specificStepId.table) {
        where = conf.indicateurTableIdFn + '=' + $scope.specificStepId.value;
        stepTable = conf.indicateurSpecificTable1;
      } else if (conf.indicateurSpecificTable2 == $scope.specificStepId.table) {
        where = conf.indicateurTableIdFn2 + '=' + $scope.specificStepId.value;
        stepTable = conf.indicateurSpecificTable2;
      }

      //-- This function may be called recursively, if records are created then
      //-- it is called to get the created records, so it should not be called more than twice.
      //-- And we  define a security number of calls with a max of 5.
      if ($scope.loadWidgetCallCnt == undefined) $scope.loadWidgetCallCnt = 0;
      if (++$scope.loadWidgetCallCnt > 5) return;

      //-- Load data from expected results table.
      QueryFactory.data($scope.expectedResTableDesc.uid, where).then(function(
        res
      ) {
        var feat, att;

        if (res.data.features.length == 0) $scope.createExpectedResultList();
        else {
          $scope.expectedResFeatures = res.data.features;
          //-- Buils list of type for select tag
          for (var ind = 0; ind < res.data.features.length; ind++) {
            feat = res.data.features[ind];
            $scope.listOfTypes.push({
              code: QueryFactory.getFeatureId(feat),
              value: feat.properties[conf.indicateurTableTypeFn],
            });
          }
          //-- Default selected type
          $scope.ftype = QueryFactory.getFeatureId(res.data.features[0]);
          $scope.selectedFeature = res.data.features[0];
          $scope.theTypeHasChangedTo($scope.ftype, stepTable);
        }
      });
    };

    /**
     *
     */
    $scope.getValueFor = function(desc, value) {
      if (typeof value == 'boolean') return value;
      if (!desc.fieldTypeIsString && value == '') return null;
      if (desc.fieldTypeIsDate) {
        if (value == undefined) return null;
        if (value.trim == undefined)
          //-- Date value is not a string so we assume it is a Date object.
          return (
            '' +
            value.getFullYear() +
            '-' +
            (1 + value.getMonth()) +
            '-' +
            value.getDate() +
            'T12:00:00.000+0000'
          );
        //-- Case of a date value stored as a string
        //-- there we ensure the string format is OK
        return $scope.stringDateCorrectlyFormatted(value);
        //return "2016-01-02T12:00:00.000+0000";
      }

      if (value == undefined) return null;
      return value;
    };

    /**
     *       When a value has been changed depending on mode we update the object.
     *   If the update mode is "global" then we wait the user to click on the update command.
     *   If the update mode is not "global" (default is "inline") then we automatically
     *   update the object when a value has been changed.
     */
    $scope.valueChangedFunction = true;
    $scope.valueChanged = function() {
      var field, val;

      //-- Set feature property with new values.
      for (
        var indField = 0;
        indField < $scope.config.fieldOrder.length;
        indField++
      ) {
        field = $scope.config.fieldOrder[indField];
        val = field.objectField.value;
        if (field.computedField != 'true')
          $scope.selectedFeature.properties[field.field] = $scope.getValueFor(
            field.fieldDesc,
            val
          );
      }

      //-- Save the feature in the database.
      var features = {};
      features.type = 'FeatureCollection';
      features.features = [];
      features.features[0] = $scope.selectedFeature;
      EditFactory.update($scope.expectedResTableDesc.uid, features).then(
        function(res) {
          var errorMsg;

          if (res.statusText != 'OK' || res.data.errors.ERROR != undefined) {
            var errorMsg = '<h4>Erreur</h4> ';
            errorMsg +=
              "<br/><h4>Details</h4>  Echec de la modification d'un objet en base !";
            errorMsg += '<br/>' + res.data.errors.ERROR;
            require('toastr').error(errorMsg);
          }
        }
      );
    };

    $scope.selectIndicateur = function(indicateurType) {
      var conf = $scope.config;

      if ($scope.expectedResFeatures == undefined) return false;
      for (var ind = 0; ind < $scope.expectedResFeatures.length; ind++) {
        if (
          QueryFactory.getFeatureId($scope.expectedResFeatures[ind]) ==
          indicateurType
        ) {
          $scope.selectedFeature = $scope.expectedResFeatures[ind];
          if ($scope.config.indicateurHasDependentField == 'true') {
            var params = {},
              param;
            for (
              var ind = 0;
              ind < $scope.config.indicDepFieldsParams.length;
              ind++
            ) {
              param = $scope.config.indicDepFieldsParams[ind];
              params[param] = $scope.selectedFeature.properties[param];
            }
            for (
              var ind = 0;
              ind < $scope.config.indicateurDepFields.length;
              ind++
            )
              $scope.$emit('changeEmittedToParent', {
                targetField: $scope.config.indicateurDepFields[ind],
                mainObjectId: QueryFactory.getFeatureId($scope.selectedFeature),
                properties: params,
              });
          }
          return true;
        }
      }
    };

    /**
     *       Build the where clause in oder to find related objects.
     *    Pragmatically this way we'll find the "quantité réeelle"
     *    when the "indicateur" type is "Rapport de suivi".
     */
    $scope.sumOfGetWhereId = function(field, tDesc) {
      var val;
      for (var ind = 0; ind < tDesc.relations.length; ind++)
        if (
          tDesc.relations[ind].componentEnd == tDesc.name &&
          tDesc.relations[ind].componentStart ==
            $scope.config.expectedResTableName
        ) {
          if (tDesc.relations[ind].fieldStart == 'id')
            val = QueryFactory.getFeatureId($scope.selectedFeature);
          else
            val =
              $scope.selectedFeature.properties[
                tDesc.relations[ind].fieldStart
              ];
          return tDesc.relations[ind].fieldEnd + '=' + val;
        } else if (
          tDesc.relations[ind].componentStart == tDesc.name &&
          tDesc.relations[ind].componentEnd ==
            $scope.config.expectedResTableName
        ) {
          if (tDesc.relations[ind].fieldEnd == 'id')
            val = QueryFactory.getFeatureId($scope.selectedFeature);
          else
            val =
              $scope.selectedFeature.properties[tDesc.relations[ind].fieldEnd];

          return tDesc.relations[ind].fieldStart + '=' + val;
        }
    };

    $scope.setSumValue = function(field, res, fn) {
      var val = 0;

      //-- -2- Sum the given field values
      for (var ind = 0; ind < res.data.features.length; ind++)
        if (res.data.features[ind].properties.hasOwnProperty(fn))
          if (res.data.features[ind].properties[fn] != null)
            val += res.data.features[ind].properties[fn];
      field.objectField.value = val;
    };

    $scope.setIfValue = function(field, res, fn) {
      var val = 0;

      //-- -3- If the value is not null or empty string then the quantity is one.
      //--     else the quantity is 0.
      if (res.data.features.length != 0) {
        val = res.data.features[0].properties[fn];
        if (val == null) val = 0;
        else {
          if (val.trim !== undefined && val != '') val = 1;
          else val = 0;
        }
      }
      field.objectField.value = val;
    };

    /**
     *       The quantity is the sum of a column if the related objects.
     */
    $scope.sumOf = function(field, expression) {
      var fn, tn, ptInd, tDesc, whereId;
      //-- Example: day_projet_etape_indicreel.quantite_reelle
      //-- -0- Extract tbe name and field name from the expression
      ptInd = expression.lastIndexOf('.');
      if (ptInd != -1) {
        fn = expression.substr(ptInd + 1);
        tn = expression.substr(0, ptInd);
        //-- -1- Get related objects
        tDesc = FeatureTypeFactory.getFeatureTypeDesc(
          $scope.config.datastoreName,
          tn
        );
        whereId = $scope.sumOfGetWhereId(field, tDesc);
        if (whereId.substr(0, 3) == 'id=')
          QueryFactory.get(tDesc.uid, whereId.substr(3)).then(function(res) {
            $scope.setSumValue(field, res, fn);
          });
        else
          QueryFactory.data(tDesc.uid, whereId).then(function(res) {
            $scope.setSumValue(field, res, fn);
          });
      }
    };

    /**
     *      If the field is not null then the quantity is 1.
     */
    $scope.oneIf = function(field, expression, stepTable) {
      var fn, tn, ptInd, tDesc, whereId;

      //-- Example: day_projet_etape_standard.pj_reception_prov_part_pv_reception
      ptInd = expression.lastIndexOf('.');
      if (ptInd != -1) {
        //-- -1- Extract tbe name and field name from the expression
        fn = expression.substr(ptInd + 1);
        $scope.setFieldCalculationCurrentDependency(field, fn);
        if (stepTable != undefined) tn = stepTable;
        else tn = expression.substr(0, ptInd);
        $scope.currentCalculationFieldName = fn;
        //-- -2- Get the related object.
        tDesc = FeatureTypeFactory.getFeatureTypeDesc(
          $scope.config.datastoreName,
          tn
        );
        whereId = $scope.sumOfGetWhereId(field, tDesc);
        if (whereId.substr(0, 3) == 'id=')
          QueryFactory.get(tDesc.uid, whereId.substr(3)).then(function(res) {
            $scope.setIfValue(field, res, fn);
          });
        else
          QueryFactory.data(tDesc.uid, whereId).then(function(res) {
            $scope.setIfValue(field, res, fn);
          });
      }
    };

    $scope.setFieldCalculationCurrentDependency = function(
      field,
      dependentFieldName
    ) {
      var ind;
      for (ind = 0; ind < $scope.currentCalculationFieldNames.length; ind++)
        if ($scope.currentCalculationFieldNames[ind].field.name == field.name) {
          $scope.currentCalculationFieldNames[
            ind
          ].depFieldName = dependentFieldName;
          break;
        }
      if (ind == $scope.currentCalculationFieldNames.length)
        $scope.currentCalculationFieldNames.push({
          field: field,
          depFieldName: dependentFieldName,
        });
    };

    /**
     *       Displayed "indicateur" has chnaged so compute matching
     *    total quantity.
     */
    $scope.computeFieldValue = function(field, stepTable) {
      var typeIndic, calc;

      $scope.setFieldCalculationCurrentDependency(field, undefined);
      //-- Get "indicateur" value
      typeIndic =
        $scope.selectedFeature.properties[$scope.config.indicateurTableTypeFn];
      //-- Look for calculation method for the current "indicateur"
      for (var ind = 0; ind < field.calculations.length; ind++) {
        if (field.calculations[ind].type == typeIndic) {
          //-- Calculation method is found
          calc = field.calculations[ind].calculation;
          //-- Two possible methods: 1) summing an attribute,
          //-                        2) one when a value is not empty
          if (calc.substr(0, 4) == 'SUM(')
            $scope.sumOf(field, calc.substr(4, calc.length - 5));
          else if (calc.substr(0, 3) == 'IF(')
            $scope.oneIf(field, calc.substr(3, calc.length - 4), stepTable);
        }
      }
      return 0;
    };

    /**
     *     "Indicateur" type has been selected by the user.
     *  So get information to the matching record to make it the current
     *  record we display the values of and we get modifications for.
     */
    $scope.theTypeHasChangedTo = function(newftype, stepTable) {
      var field, val;

      if (!$scope.selectIndicateur(newftype)) return;

      for (
        var indField = 0;
        indField < $scope.config.fieldOrder.length;
        indField++
      ) {
        field = $scope.config.fieldOrder[indField];

        if (field.computedField != 'true') {
          val = $scope.selectedFeature.properties[field.field];
          if (field.objectField != undefined) {
            if (val == null) field.objectField.value = '';
            else field.objectField.value = val;
          }
        } else {
          $scope.computeFieldValue(field, stepTable);
        }
      }
    };

    /*-------------------     EVENTS      ---------------------*/

    /**
     *       When there is a change in the list of "indicateurs réels"
     *   computed values have to be updated.
     */
    $scope.$on('brotherListChanged', function(event, data) {
      var field;

      if (data == $scope.config.realResTableName)
        for (
          var indField = 0;
          indField < $scope.config.fieldOrder.length;
          indField++
        ) {
          field = $scope.config.fieldOrder[indField];
          if (field.computedField == 'true') $scope.computeFieldValue(field);
        }
    });

    $scope.$on('oneFieldHasChanged', function(event, data) {
      var field, ind;

      for (ind = 0; ind < $scope.currentCalculationFieldNames.length; ind++)
        if (
          $scope.currentCalculationFieldNames[ind].depFieldName ==
          data.modifiedFieldname
        ) {
          setTimeout(
            $scope.computeFieldValue,
            500,
            $scope.currentCalculationFieldNames[ind].field
          );
          //$scope.computeFieldValue( $scope.currentCalculationFieldNames[ind].field );
          break;
        }
    });
    /*-------------------     ------      ---------------------*/

    $scope.readConfiguration();
    $scope.loadWidget();
  };

  IndicateurMgtCtrl.$inject = [
    '$scope',
    'FeatureTypeFactory',
    'QueryFactory',
    'EditFactory',
  ];
  return IndicateurMgtCtrl;
});
