'use strict';
define(function() {
  var RelationFormFieldFactory = function(
    $http,
    FeatureTypeFactory,
    gaJsUtils
  ) {
    var RelationFormFieldFactory = {};
    /**
     * Class : RelationFormFieldFactory
     * Factory WebServices
     */

    var resources = {
      objects: [],
    };

    /**
     * Function: add related object
     */
    function addRelatedObject(fid, senddata, featureType, geom, crs) {
      var features;

      //-- Build GeoJSON object describing the object we want  to insert
      features = {};
      features.type = 'FeatureCollection';
      features.features = [];
      features.features[0] = {};
      features.features[0].type = 'feature';
      features.features[0].properties = senddata;
      features.features[0].geometry = {};
      if (geom !== undefined) features.features[0].geometry = geom;
      else features.features[0].geometry = {};

      //-- Do the insert
      var promise = $http.post(
        '/services/{portalid}/edit/' + fid + '/add?f=json&crs=' + crs,
        features
      );
      promise.then(function(res) {
        //- If the service returns OK (which does not mean the creation is OK)
        if (res.status == 200) {
          var created = res.data.create[0];
          if (created != undefined && created.id != undefined) {
            resources.objectId = created.id.substr(created.id.indexOf('.') + 1);
          } else {
            var mess1,
              mess2 = '';
            if (res.data.errors.length != 0) mess2 = res.data.errors[0];
            mess1 = 'Impossible de créer un objet';
            gaJsUtils.errorMessage(mess1, mess2);
          }
        }
      });
      return promise;
    }

    /**
     * Function: delete
     */
    function delRelatedObject(fid, ids) {
      var promise = $http.get(
        '/services/{portalid}/edit/' +
          fid +
          '/delete?f=json&fid=' +
          fid +
          '&ids=' +
          ids
      );
      promise.then(function(res) {
        // service level logic if any
      });
      return promise;
    }

    /**
     * Function: update
     */
    function updateObjects(fid, features) {
      var senddata, ind1;

      //-- Build GeoJSON object describing the object we want  to insert
      senddata = {};
      senddata.type = 'FeatureCollection';
      senddata.features = [];

      for (ind1 = 0; ind1 < features.length; ind1++) {
        senddata.features[ind1] = {};
        senddata.features[ind1].id = features[ind1].id;
        senddata.features[ind1].type = 'feature';
        senddata.features[ind1].properties = features[ind1].properties;
        senddata.features[ind1].geometry = {};
      }

      var promise = $http.post(
        '/services/{portalid}/edit/' + fid + '/update?f=json',
        senddata
      );
      return promise;
    }

    return {
      updateObjects: updateObjects,
      delRelatedObject: delRelatedObject,
      addRelatedObject: addRelatedObject,
      RelationFormFieldFactory: RelationFormFieldFactory,
      resources: resources,
    };
  };
  RelationFormFieldFactory.$inject = [
    '$http',
    'FeatureTypeFactory',
    'gaJsUtils',
  ];
  return RelationFormFieldFactory;
});
